/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.common.grpc.stats;

import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerInterceptor;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.bookkeeper.common.grpc.stats.MonitoringServerCall;
import org.apache.bookkeeper.common.grpc.stats.MonitoringServerCallListener;
import org.apache.bookkeeper.common.grpc.stats.ServerStats;
import org.apache.bookkeeper.stats.StatsLogger;

public class MonitoringServerInterceptor
implements ServerInterceptor {
    private final ServerStats.Factory statsFactory;
    private final StatsLogger statsLogger;
    private final ConcurrentMap<String, ServerStats> methods;

    public static MonitoringServerInterceptor create(StatsLogger statsLogger, boolean includeLatencyHistograms) {
        return new MonitoringServerInterceptor(new ServerStats.Factory(includeLatencyHistograms), statsLogger);
    }

    private MonitoringServerInterceptor(ServerStats.Factory statsFactory, StatsLogger statsLogger) {
        this.statsFactory = statsFactory;
        this.statsLogger = statsLogger;
        this.methods = new ConcurrentHashMap<String, ServerStats>();
    }

    private ServerStats getMethodStats(MethodDescriptor<?, ?> method) {
        ServerStats stats = (ServerStats)this.methods.get(method.getFullMethodName());
        if (null != stats) {
            return stats;
        }
        ServerStats newStats = this.statsFactory.createMetricsForMethod(method, this.statsLogger);
        ServerStats oldStats = this.methods.putIfAbsent(method.getFullMethodName(), newStats);
        if (null != oldStats) {
            return oldStats;
        }
        return newStats;
    }

    public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(ServerCall<ReqT, RespT> call, Metadata headers, ServerCallHandler<ReqT, RespT> next) {
        MethodDescriptor method = call.getMethodDescriptor();
        ServerStats stats = this.getMethodStats(method);
        MonitoringServerCall<ReqT, RespT> monitoringCall = new MonitoringServerCall<ReqT, RespT>(call, stats);
        return new MonitoringServerCallListener(next.startCall(monitoringCall, headers), stats);
    }
}

