/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.net.impl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.vertx.core.impl.ContextImpl;
import io.vertx.core.net.impl.ConnectionBase;
import io.vertx.core.net.impl.VertxHandler;
import java.util.Map;

public abstract class VertxNetHandler<C extends ConnectionBase>
extends VertxHandler<C> {
    private final Channel ch;
    private final Map<Channel, C> connectionMap;
    protected C conn;

    public VertxNetHandler(Channel ch, Map<Channel, C> connectionMap) {
        this.ch = ch;
        this.connectionMap = connectionMap;
    }

    public VertxNetHandler(Channel ch, C conn, Map<Channel, C> connectionMap) {
        this.ch = ch;
        this.connectionMap = connectionMap;
        this.conn = conn;
    }

    @Override
    protected C getConnection() {
        return this.conn;
    }

    @Override
    protected C removeConnection() {
        this.connectionMap.remove(this.ch);
        C conn = this.conn;
        this.conn = null;
        return conn;
    }

    @Override
    protected void channelRead(C sock, ContextImpl context, ChannelHandlerContext chctx, Object msg) throws Exception {
        if (sock != null) {
            context.executeFromIO(() -> this.handleMsgReceived(msg));
        }
    }

    protected abstract void handleMsgReceived(Object var1);

    @Override
    protected Object safeObject(Object msg, ByteBufAllocator allocator) throws Exception {
        if (msg instanceof ByteBuf) {
            return VertxNetHandler.safeBuffer((ByteBuf)msg, allocator);
        }
        return msg;
    }
}

