/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.client;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import org.apache.bookkeeper.client.LedgerMetadataImpl;
import org.apache.bookkeeper.client.LedgerMetadataUtils;
import org.apache.bookkeeper.client.api.DigestType;
import org.apache.bookkeeper.client.api.LedgerMetadata;
import org.apache.bookkeeper.common.annotation.InterfaceAudience;
import org.apache.bookkeeper.common.annotation.InterfaceStability;
import org.apache.bookkeeper.net.BookieSocketAddress;

@InterfaceAudience.LimitedPrivate
@InterfaceStability.Unstable
@VisibleForTesting
public class LedgerMetadataBuilder {
    private int metadataFormatVersion = 3;
    private int ensembleSize = 3;
    private int writeQuorumSize = 3;
    private int ackQuorumSize = 2;
    private LedgerMetadata.State state = LedgerMetadata.State.OPEN;
    private Optional<Long> lastEntryId = Optional.empty();
    private Optional<Long> length = Optional.empty();
    private TreeMap<Long, List<BookieSocketAddress>> ensembles = new TreeMap();
    private Optional<DigestType> digestType = Optional.empty();
    private Optional<byte[]> password = Optional.empty();
    private long ctime = -1L;
    private boolean storeCtime = false;
    private Map<String, byte[]> customMetadata = Collections.emptyMap();
    private static final long BLANK_CTOKEN = 0L;
    private long cToken = 0L;

    public static LedgerMetadataBuilder create() {
        return new LedgerMetadataBuilder();
    }

    public static LedgerMetadataBuilder from(LedgerMetadata other) {
        LedgerMetadataBuilder builder = new LedgerMetadataBuilder();
        builder.metadataFormatVersion = other.getMetadataFormatVersion();
        builder.ensembleSize = other.getEnsembleSize();
        builder.writeQuorumSize = other.getWriteQuorumSize();
        builder.ackQuorumSize = other.getAckQuorumSize();
        builder.state = other.getState();
        if (builder.state == LedgerMetadata.State.CLOSED) {
            builder.lastEntryId = Optional.of(other.getLastEntryId());
            builder.length = Optional.of(other.getLength());
        }
        builder.ensembles.putAll(other.getAllEnsembles());
        if (other.hasPassword()) {
            builder.password = Optional.of(other.getPassword());
            builder.digestType = Optional.of(other.getDigestType());
        }
        builder.ctime = other.getCtime();
        builder.storeCtime = LedgerMetadataUtils.shouldStoreCtime(other);
        builder.customMetadata = ImmutableMap.copyOf(other.getCustomMetadata());
        return builder;
    }

    public LedgerMetadataBuilder withMetadataFormatVersion(int version) {
        this.metadataFormatVersion = version;
        return this;
    }

    public LedgerMetadataBuilder withPassword(byte[] password) {
        this.password = Optional.of(Arrays.copyOf(password, password.length));
        return this;
    }

    public LedgerMetadataBuilder withDigestType(DigestType digestType) {
        this.digestType = Optional.of(digestType);
        return this;
    }

    public LedgerMetadataBuilder withEnsembleSize(int ensembleSize) {
        Preconditions.checkState((this.ensembles.size() == 0 ? 1 : 0) != 0, (Object)"Can only set ensemble size before adding ensembles to the builder");
        this.ensembleSize = ensembleSize;
        return this;
    }

    public LedgerMetadataBuilder withWriteQuorumSize(int writeQuorumSize) {
        this.writeQuorumSize = writeQuorumSize;
        return this;
    }

    public LedgerMetadataBuilder withAckQuorumSize(int ackQuorumSize) {
        this.ackQuorumSize = ackQuorumSize;
        return this;
    }

    public LedgerMetadataBuilder newEnsembleEntry(long firstEntry, List<BookieSocketAddress> ensemble) {
        Preconditions.checkArgument((ensemble.size() == this.ensembleSize ? 1 : 0) != 0, (Object)"Size of passed in ensemble must match the ensembleSize of the builder");
        Preconditions.checkArgument((this.ensembles.isEmpty() || firstEntry > this.ensembles.lastKey() ? 1 : 0) != 0, (Object)"New entry must have a first entry greater than any existing ensemble key");
        this.ensembles.put(firstEntry, ensemble);
        return this;
    }

    public LedgerMetadataBuilder replaceEnsembleEntry(long firstEntry, List<BookieSocketAddress> ensemble) {
        Preconditions.checkArgument((ensemble.size() == this.ensembleSize ? 1 : 0) != 0, (Object)"Size of passed in ensemble must match the ensembleSize of the builder");
        Preconditions.checkArgument((boolean)this.ensembles.containsKey(firstEntry), (Object)"Ensemble must replace an existing ensemble in the ensemble map");
        this.ensembles.put(firstEntry, ensemble);
        return this;
    }

    public LedgerMetadataBuilder withInRecoveryState() {
        this.state = LedgerMetadata.State.IN_RECOVERY;
        return this;
    }

    public LedgerMetadataBuilder withClosedState() {
        this.state = LedgerMetadata.State.CLOSED;
        return this;
    }

    public LedgerMetadataBuilder withLastEntryId(long lastEntryId) {
        this.lastEntryId = Optional.of(lastEntryId);
        return this;
    }

    public LedgerMetadataBuilder withLength(long length) {
        this.length = Optional.of(length);
        return this;
    }

    public LedgerMetadataBuilder withCustomMetadata(Map<String, byte[]> customMetadata) {
        this.customMetadata = ImmutableMap.copyOf(customMetadata);
        return this;
    }

    public LedgerMetadataBuilder withCreationTime(long ctime) {
        this.ctime = ctime;
        return this;
    }

    public LedgerMetadataBuilder storingCreationTime(boolean storing) {
        this.storeCtime = storing;
        return this;
    }

    public LedgerMetadataBuilder withCToken(long cToken) {
        this.cToken = cToken;
        return this;
    }

    public LedgerMetadata build() {
        Preconditions.checkArgument((this.ensembleSize >= this.writeQuorumSize ? 1 : 0) != 0, (Object)"Write quorum must be less or equal to ensemble size");
        Preconditions.checkArgument((this.writeQuorumSize >= this.ackQuorumSize ? 1 : 0) != 0, (Object)"Write quorum must be greater or equal to ack quorum");
        return new LedgerMetadataImpl(this.metadataFormatVersion, this.ensembleSize, this.writeQuorumSize, this.ackQuorumSize, this.state, this.lastEntryId, this.length, this.ensembles, this.digestType, this.password, this.ctime, this.storeCtime, this.cToken, this.customMetadata);
    }
}

