/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.tool;

import java.io.BufferedOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.List;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import org.apache.avro.file.DataFileStream;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.io.DatumReader;
import org.apache.avro.tool.Tool;
import org.apache.avro.tool.Util;
import org.apache.trevni.ColumnFileMetaData;
import org.apache.trevni.avro.AvroColumnWriter;

public class ToTrevniTool
implements Tool {
    @Override
    public String getName() {
        return "totrevni";
    }

    @Override
    public String getShortDescription() {
        return "Converts an Avro data file to a Trevni file.";
    }

    @Override
    public int run(InputStream stdin, PrintStream out, PrintStream err, List<String> args) throws Exception {
        OptionParser p = new OptionParser();
        ArgumentAcceptingOptionSpec codec = p.accepts("codec", "Compression codec").withRequiredArg().defaultsTo((Object)"null", (Object[])new String[0]).ofType(String.class);
        OptionSet opts = p.parse(args.toArray(new String[0]));
        if (opts.nonOptionArguments().size() != 2) {
            err.println("Usage: inFile outFile (filenames or '-' for stdin/stdout)");
            p.printHelpOn((OutputStream)err);
            return 1;
        }
        args = opts.nonOptionArguments();
        DataFileStream reader = new DataFileStream((InputStream)Util.fileOrStdin((String)args.get(0), stdin), (DatumReader)new GenericDatumReader());
        BufferedOutputStream outs = Util.fileOrStdout((String)args.get(1), out);
        AvroColumnWriter writer = new AvroColumnWriter(reader.getSchema(), (ColumnFileMetaData)new ColumnFileMetaData().setCodec((String)codec.value(opts)));
        for (Object datum : reader) {
            writer.write(datum);
        }
        writer.writeTo((OutputStream)outs);
        ((OutputStream)outs).close();
        reader.close();
        return 0;
    }
}

