/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.subsystem.core.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.aries.subsystem.core.internal.ResourceHelper;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;
import org.osgi.resource.Resource;
import org.osgi.service.repository.Repository;

public class ContentRepository
implements Repository {
    private final Collection<Resource> installableContent;
    private final Collection<Resource> sharedContent;

    private static void findContent(Requirement requirement, Collection<Capability> capabilities, Collection<Resource> resources) {
        for (Resource resource : resources) {
            for (Capability capability : resource.getCapabilities(requirement.getNamespace())) {
                if (!ResourceHelper.matches(requirement, capability)) continue;
                capabilities.add(capability);
            }
        }
    }

    public ContentRepository(Collection<Resource> installableContent, Collection<Resource> sharedContent) {
        this.installableContent = new HashSet<Resource>(installableContent);
        this.sharedContent = new HashSet<Resource>(sharedContent);
    }

    public Map<Requirement, Collection<Capability>> findProviders(Collection<? extends Requirement> requirements) {
        HashMap<Requirement, Collection<Capability>> result = new HashMap<Requirement, Collection<Capability>>();
        for (Requirement requirement : requirements) {
            result.put(requirement, this.findProviders(requirement));
        }
        return result;
    }

    public Collection<Capability> findProviders(Requirement requirement) {
        ArrayList<Capability> result = new ArrayList<Capability>();
        if (this.findSharedContent(requirement, result)) {
            return result;
        }
        this.findInstallableContent(requirement, result);
        result.trimToSize();
        return result;
    }

    public Collection<Resource> getInstallableContent() {
        return Collections.unmodifiableCollection(this.installableContent);
    }

    public Collection<Resource> getSharedContent() {
        return Collections.unmodifiableCollection(this.sharedContent);
    }

    private void findInstallableContent(Requirement requirement, Collection<Capability> capabilities) {
        ContentRepository.findContent(requirement, capabilities, this.installableContent);
    }

    private boolean findSharedContent(Requirement requirement, Collection<Capability> capabilities) {
        int size = capabilities.size();
        ContentRepository.findContent(requirement, capabilities, this.sharedContent);
        return size < capabilities.size();
    }
}

