/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.subsystem.core.archive;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.aries.subsystem.core.archive.Clause;
import org.apache.aries.subsystem.core.archive.GenericClause;
import org.apache.aries.subsystem.core.archive.Header;
import org.osgi.framework.Version;
import org.osgi.resource.Capability;
import org.osgi.resource.Resource;

public abstract class AbstractHeader
implements Header {
    protected static final String REGEX = "(?:(?:/|/?[^/\"\r\n\u0000\\:=;, ]+(?:/[^/\"\r\n\u0000\\:=;, ]+)*)|\"(?:/|/?[^/\"\r\n\u0000]+(?:/[^/\"\r\n\u0000]+)*)\")(?:;(?:/|/?[^/\"\r\n\u0000\\:=;, ]+(?:/[^/\"\r\n\u0000\\:=;, ]+)*)|\"(?:/|/?[^/\"\r\n\u0000]+(?:/[^/\"\r\n\u0000]+)*)\")*(?:;\\s*(?:(?:(?:[0-9]|[A-Za-z]|_|-|\\.)+:=(?:(?:[0-9]|[A-Za-z]|_|-|\\.)+|\"(?:[^\\\\\"\r\n\u0000]|\\\\\"|\\\\\\\\)*\"))|(?:(?:[0-9]|[A-Za-z]|_|-|\\.)+=(?:(?:[0-9]|[A-Za-z]|_|-|\\.)+|\"(?:[^\\\\\"\r\n\u0000]|\\\\\"|\\\\\\\\)*\"))))*(?=,|\\z)";
    protected static final Pattern PATTERN = Pattern.compile("(?:(?:/|/?[^/\"\r\n\u0000\\:=;, ]+(?:/[^/\"\r\n\u0000\\:=;, ]+)*)|\"(?:/|/?[^/\"\r\n\u0000]+(?:/[^/\"\r\n\u0000]+)*)\")(?:;(?:/|/?[^/\"\r\n\u0000\\:=;, ]+(?:/[^/\"\r\n\u0000\\:=;, ]+)*)|\"(?:/|/?[^/\"\r\n\u0000]+(?:/[^/\"\r\n\u0000]+)*)\")*(?:;\\s*(?:(?:(?:[0-9]|[A-Za-z]|_|-|\\.)+:=(?:(?:[0-9]|[A-Za-z]|_|-|\\.)+|\"(?:[^\\\\\"\r\n\u0000]|\\\\\"|\\\\\\\\)*\"))|(?:(?:[0-9]|[A-Za-z]|_|-|\\.)+=(?:(?:[0-9]|[A-Za-z]|_|-|\\.)+|\"(?:[^\\\\\"\r\n\u0000]|\\\\\"|\\\\\\\\)*\"))))*(?=,|\\z)");
    protected final List<Clause> clauses = new ArrayList<Clause>();
    protected final String name;
    protected final String value;

    protected static void appendResource(Resource resource, StringBuilder builder) {
        Map attributes = ((Capability)resource.getCapabilities("osgi.identity").get(0)).getAttributes();
        String symbolicName = (String)attributes.get("osgi.identity");
        Version version = (Version)attributes.get("version");
        String namespace = (String)attributes.get("type");
        builder.append(symbolicName).append(';').append("deployed-version").append('=').append(version.toString()).append(';').append("type").append('=').append(namespace);
    }

    public AbstractHeader(String name, String value) {
        this.name = name;
        this.value = value;
        Matcher matcher = PATTERN.matcher(value);
        while (matcher.find()) {
            this.clauses.add(new GenericClause(matcher.group()));
        }
        if (this.clauses.isEmpty()) {
            throw new IllegalArgumentException("Invalid header syntax -> " + name + ": " + value);
        }
    }

    public List<Clause> getClauses() {
        return Collections.unmodifiableList(this.clauses);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    public String toString() {
        return this.getClass().getName() + ": name=" + this.name + ", value=" + this.value;
    }
}

