/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.blueprint.jexl.evaluator;

import java.util.Map;
import org.apache.commons.jexl2.JexlContext;
import org.apache.commons.jexl2.JexlEngine;
import org.apache.commons.jexl2.MapContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JexlExpressionParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(JexlExpressionParser.class);
    protected final JexlContext context;
    private final JexlEngine engine;

    public JexlExpressionParser(Map<String, Object> vars) {
        if (vars == null) {
            throw new IllegalArgumentException("vars: " + vars);
        }
        this.engine = new JexlEngine();
        this.context = new MapContext(vars);
        LOGGER.trace("Using variables: {}", vars);
    }

    public Object evaluate(String expression) throws Exception {
        if (expression == null) {
            throw new IllegalArgumentException("expression: " + expression);
        }
        LOGGER.trace("Evaluating expression: {}", (Object)expression);
        return this.engine.createExpression(expression).evaluate(this.context);
    }
}

