/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.clientImpl;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.net.HostAndPort;
import java.util.Objects;
import org.apache.accumulo.core.clientImpl.ClientContext;
import org.apache.accumulo.core.rpc.SaslConnectionParams;
import org.apache.accumulo.core.rpc.SslConnectionParams;

@VisibleForTesting
public class ThriftTransportKey {
    private final HostAndPort server;
    private final long timeout;
    private final SslConnectionParams sslParams;
    private final SaslConnectionParams saslParams;
    private final int hash;

    @VisibleForTesting
    public ThriftTransportKey(HostAndPort server, long timeout, ClientContext context) {
        this(server, timeout, context.getClientSslParams(), context.getSaslParams());
    }

    ThriftTransportKey(HostAndPort server, long timeout, SslConnectionParams sslParams, SaslConnectionParams saslParams) {
        Objects.requireNonNull(server, "location is null");
        this.server = server;
        this.timeout = timeout;
        this.sslParams = sslParams;
        this.saslParams = saslParams;
        if (saslParams != null && sslParams != null) {
            throw new IllegalArgumentException("Cannot use both SSL and SASL thrift transports");
        }
        this.hash = Objects.hash(server, timeout, sslParams, saslParams);
    }

    HostAndPort getServer() {
        return this.server;
    }

    long getTimeout() {
        return this.timeout;
    }

    public boolean isSsl() {
        return this.sslParams != null;
    }

    public boolean isSasl() {
        return this.saslParams != null;
    }

    public boolean equals(Object o) {
        if (!(o instanceof ThriftTransportKey)) {
            return false;
        }
        ThriftTransportKey ttk = (ThriftTransportKey)o;
        return this.server.equals((Object)ttk.server) && this.timeout == ttk.timeout && (!this.isSsl() || ttk.isSsl() && this.sslParams.equals(ttk.sslParams)) && (!this.isSasl() || ttk.isSasl() && this.saslParams.equals(ttk.saslParams));
    }

    public int hashCode() {
        return this.hash;
    }

    public String toString() {
        Object prefix = "";
        if (this.isSsl()) {
            prefix = "ssl:";
        } else if (this.isSasl()) {
            prefix = this.saslParams + ":";
        }
        return (String)prefix + this.server + " (" + this.timeout + ")";
    }

    public SslConnectionParams getSslParams() {
        return this.sslParams;
    }

    public SaslConnectionParams getSaslParams() {
        return this.saslParams;
    }
}

