/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.classloader;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.accumulo.core.spi.common.ContextClassLoaderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class URLContextClassLoaderFactory
implements ContextClassLoaderFactory {
    private static final AtomicBoolean isInstantiated = new AtomicBoolean(false);
    private static final Logger LOG = LoggerFactory.getLogger(URLContextClassLoaderFactory.class);
    private static final String className = URLContextClassLoaderFactory.class.getName();
    private final Cache<String, URLClassLoader> classloaders = Caffeine.newBuilder().weakValues().build();

    public URLContextClassLoaderFactory() {
        if (!isInstantiated.compareAndSet(false, true)) {
            throw new IllegalStateException("Can only instantiate " + className + " once");
        }
    }

    @Override
    public ClassLoader getClassLoader(String context) {
        if (context == null) {
            throw new IllegalArgumentException("Unknown context");
        }
        return (ClassLoader)this.classloaders.get((Object)context, k -> {
            LOG.debug("Creating URLClassLoader for context, uris: {}", (Object)context);
            return new URLClassLoader((URL[])Arrays.stream(context.split(",")).map(url -> {
                try {
                    return new URL((String)url);
                }
                catch (MalformedURLException e) {
                    throw new RuntimeException(e);
                }
            }).toArray(URL[]::new), ClassLoader.getSystemClassLoader());
        });
    }
}

