#!/bin/sh
#
# 1. Rotate squid logfile access.log -> access.log.0
# 2. move access.log.0 -> access.log.YYYYMMDD
# 3. process logfiles
# 4. archive logfiles
# 5. delete logs older than specified days

#
# Change to suit your site
#
HOST=cache1.sbs.de
TOPN=50
LOGDIR=/var/adm/squid
BINDIR=/www/bin
WWWDIR=/www/cache.sbs.de/pub/stats/squid
PIDFILE=/var/run/squid.pid
GZIP=/usr/local/bin/gzip
FIND=/sbin/find
RM=/sbin/rm
#
# Anything below here does NOT need changing!
#

DATE=`date +%Y%m%d`
PID=`cat $PIDFILE`
LOGFILE=$LOGDIR/access.log.$DATE
SUMFILE=$WWWDIR/summary.$DATE
WWWFILE=$WWWDIR/$DATE.html

echo "kill -USR1 squid (pid $PID) (and sleeping 30 seconds) ..."
kill -USR1 $PID
sleep 30
mv $LOGDIR/access.log.0 $LOGFILE

if [ ! -d $WWWDIR ]; then
	mkdir -p $WWWDIR
fi

date
echo "Processing $LOGFILE ..."
echo "Running access-extract.pl ..."
$BINDIR/access-extract.pl < $LOGFILE > $SUMFILE
echo "Running access-extract-urls.pl ..."
$BINDIR/access-extract-urls.pl < $LOGFILE >> $SUMFILE
echo "Generating $WWWFILE ..."
echo "Running access-summary.pl ..."
$BINDIR/access-summary.pl -m $HOST -n $TOPN -H < $SUMFILE > $WWWFILE
date

$FIND $LOGDIR -type f -mtime +7 | xargs $RM -f 
$FIND $WWWDIR -type f -name "summary.*" -mtime +31 | xargs $RM -f 
# $RM -f $SUMFILE
$GZIP $LOGFILE

exit 1
