#!/bin/sh
#
# 1. Gernerate NS-Proxy statistics using NS psats
# 2. Parse pstats.YYYYMMDD
# 3. process logfiles
# 4. archive logfiles
# 5. delete logs older than specified days

#
# Change to suit your site
#
HOST=cache1.sbs.de
TOPN=50
LOGDIR=/var/adm/ns-proxy
BINDIR=/www/bin
WWWDIR=/www/cache.sbs.de/pub/stats/ns-proxy
NSDIR=/usr/local/ns-proxy
PSTATS=$NSDIR/utils/pstats
GZIP=/usr/local/bin/gzip
FIND=/sbin/find
RM=/sbin/rm
#
# Anything below here does NOT need changing!
#

DATE=`date +%Y%m%d`
LOGFILE=$LOGDIR/access.$DATE
SUMFILE=$WWWDIR/summary.$DATE
WWWFILE=$WWWDIR/$DATE.html

echo "Stopping & restarting Proxy ..."
$NSDIR/kill-proxy
sleep 5
$NSDIR/kill-proxy	# make sure
mv $LOGDIR/access $LOGFILE
$NSDIR/start-proxy

if [ ! -d $WWWDIR ]; then
	mkdir -p $WWWDIR
fi

date
echo "Processing $LOGFILE ..."
echo "Running $PSTATS ..."
$PSTATS $LOGFILE > $SUMFILE
echo "Generating $WWWFILE ..."
echo "Running proxy-summary.pl ..."
$BINDIR/proxy-summary.pl -c -m $HOST -n $TOPN -s $SUMFILE -l $LOGFILE > $WWWFILE
date

$FIND $LOGDIR -type f -mtime +7 | xargs $RM -f 
$FIND $WWWDIR -type f -name "summary.*" -mtime +31 | xargs $RM -f 
# $RM -f $SUMFILE

echo "Archiving $LOGFILE ..."
$GZIP $LOGFILE
date

exit 1
