/*
 * $Id: redirect.h,v 1.7 1996/11/04 18:12:59 wessels Exp $
 *
 * AUTHOR: Duane Wessels
 *
 * SQUID Internet Object Cache  http://www.nlanr.net/Squid/
 * --------------------------------------------------------
 *
 *  Squid is the result of efforts by numerous individuals from the
 *  Internet community.  Development is led by Duane Wessels of the
 *  National Laboratory for Applied Network Research and funded by
 *  the National Science Foundation.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *  
 */

#ifndef REDIRECT_H
#define REDIRECT_H

#define REDIRECT_AV_FACTOR 1000

typedef void (*RH) (void *data, char *result);

extern void redirectStart _PARAMS((int cfd, icpStateData *, RH, void *));
extern void redirectOpenServers _PARAMS((void));
extern void redirectShutdownServers _PARAMS((void));
extern void redirectStats _PARAMS((StoreEntry *));
extern int redirectUnregister _PARAMS((const char *url, int fd));
extern void redirectFreeMemory _PARAMS((void));

#endif /* REDIRECT_H */
