./#=========
.TH o2 1 "" "1.0"
./#=========
.SH NAME
o2 \(em multi-threaded non-deterministic lr(1) compiler/compiler included in the 
.B yacco2 
system.
./"=========
.SH SYNOPSIS
.B o2
[
.B \-p
]
[
.B -t
]
[
.B \-err
]
[
grammar file to compile
]
./"=========
.SH OPTIONS
.B o2 
options are each individually prefixed by one ``\-'' only.
If no grammar file is inputted, o2 will ask for one.
.TP
.B \-p
Create pdf documents for the inputted grammar. It requires CWEB's program suite: 
.B cweave
and 
.B mpost
programs to do this.

./"=========
.TP
.B \-t
Generate ``User terminal class'' vocabulary's c++ code along with the inputted grammar.
.PP
.B Warning:
Option is required if the ``User terminal class'' has been modified:
Tes added, subtracted, or modified.
Not doing so leaves the emitted lr(1) tables out-of-whack!
So regenerate 
.B all the grammars
so that their lr(1) tables are in sync with the new Terminal vocabulary.
See reference to 
.B o2grammars.bat
script on how to do it for your own grammars. 

./"=========
.TP
.B \-err
Generate "Error terminal class" vocabulary's c++ code along with the inputted grammar.
.B Warning:
Ditto as \-t warning.

./"========
.SH DESCRIPTION
.B o2
extends bottom-up parsing by
defining 2 types of grammars: monolithic and threaded.
A ``thread call'' operator is introduced into the traditional grammar definition along with
an arbitration clause.
These 2 extensions allow multiple grammars 
to be run in parallel with potentially multiple results returned to be arbitrated upon.
.PP 
The 
.B yacco2
system is written in the ``Literate programming'' genre using the 
.B CWEB
program suite: cweave and ctangle. ctangle emits c++ code while cweave
emits a TeX file for the
.B pdftex
program to typeset into a pdf document.

.B o2
is just 1 program within the yacco2 translation system.
Other items of import:
.B yacco2
library for your own compiler to link to
and
.B o2linker
that is
o2's companion program to link all your grammars together. 
Grammars and Terminal vocabulary files
support cweave's language directives and 
.B TeX
typesetting facilities.
By using the 
.B \-p
option, 
.B o2
emits files for 
.I mpost 
(a graphic drawing program)
and 
.I cweave 
digestion.
.I mpost 
draws  Niklaus Wirth's  ``Pascal grammar like diagrams'' that get included into
files processed by cweave.
.I cweave 
then generates the Tex files for the
.I pdftex 
program to generate the pdf documents.
.PP
.SH "o2 outputed files"
.TP
c++ code and lr(1) tables for each grammar and grammar's fsc type file for o2linker consumption
.TP
Pdf documents per grammar: grammar code and its lr(1) cross reference tables 

./"========
.SH "OTHER FEATURES"
.PP
\(em Modular grammars allowing reuse by other compilers
.RS
.nf
.fi
.RE
\(em Simplified ambiguity resolution
.RS
.nf
.fi
.RE
\(em Programmable ``context sensitive'' lookahead per threaded grammar
.RS
.nf
.fi
.RE
\(em Self documenting
.RS
.nf
.fi
.RE
\(em Dynamic tracing / trouble shooting facilities
.RS
.nf
.fi
.RE
\(em Out-of-the-box error messaging
.RS
.nf
.fi
.RE
\(em Multiple input / output token container types:
.RS
.nf
Files
Trees
In memory string
.fi
.RE

./"========
.PP
.SH EXAMPLES
1) Compiling one of o2's grammars
.RS
.nf
\&\fCcd /usr/local/yacco2/compiler/grammars
/usr/local/yacco2/bin/o2 eol.lex # no options except file: emit c++ code for grammar
.fi
.RE
2) Generate grammar's documents
.RS
.nf
\&\fCcd /usr/local/yacco2/compiler/grammars
o2 -p eol.lex # bash PATH variable modified to resolve o2 whereabouts
.fi
.RE
3) Compile grammar and ``Error class'' due to new error terminal added
.RS
.nf
\&\fCo2 -err /usr/local/yacco2/compiler/grammars/eol.lex 
.fi
.RE

./"========
.SH "SEE ALSO by man"
.BR o2linker(1), 
.BR yacco2(1), 
.BR CWEB(1),
.BR cweave(1),
.BR ctangle(1),
.BR mpost(1),
.BR TeX(1)
.PP
In 
.B /usr/local/yacco2/docs/ 
.RS
.nf
wlibrary.pdf \(em yacco2's library documented ``literate program'' 
o2.pdf \(em compiler/compiler documented ``literate program'' 
o2linker.pdf \(em linker documented ``literate program'' 
yacco2's grammars's pdfes
o2linker_doc.pdf \(em example of o2/o2linker's grammars cross reference produced by o2linker 
o2book.pdf \(em reference manual 
.fi
.RE

In 
.B /usr/local/yacco2/
.RS
.nf
READMEvx.y.pdf \(em installation guide x: version number, y: minor adjustment number.
bld_bash_APPLE script to build complete yacco2 system
.fi
.RE

In 
.B /usr/local//yacco2/compiler/grammars, 
to help u out, some bash scripts that u can clone off for your own projects:
.RE
.RS
.nf
o2grammars.sh \(em gen all grammars with possible inputted parameters
gen1grammar.sh \(em gen 1 grammar where appropriate parameters are asked by the script
.fi
.RE

./"=========
.SH "SUGGESTED READINGS GIVING REASONS FOR YACCO2 SYSTEM"
In 
.B /usr/local/yacco2/docs
.RS
.nf
p1 and p2 pdf documents \(em unpublished essays overviewing some of whyes for yacco2 development
Tugboat-o2.pdf \(em  unpublished essay on ``literate programming'' as applied to the yacco2 system
.fi
.RE

./"========
.SH "NOTE"
The bld_bash_APPLE script is used as an example. There are other bash scripts
for
.B GNU
and
.B SOLARIS.
See 
READMEvx.y.pdf. 


./"=========
.SH "OTHER LINKS"
.TP
.B www.tug.org
\(em website to download the 
.B CWEB 
``Literate programming'' system,
.I mpost
Metapost graphics program
and possibly the
.B TeX
typesetting system. These are open source. Please consider joining
.B
Tug. 

./"=========
.SH AUTHOR
Dave Bone

 
