#!/bin/sh
#
# remove NONE and foo.rl afterwards
#
#
SRCS="hb-blob.cc \
hb-buffer.cc \
hb-buffer-serialize.cc \
hb-common.cc \
hb-face.cc \
hb-fallback-shape.cc \
hb-font.cc \
hb-ot-tag.cc \
hb-ot-font.cc \
hb-set.cc \
hb-shape.cc \
hb-shape-plan.cc \
hb-shaper.cc \
hb-unicode.cc \
hb-warning.cc \
hb-ot-layout.cc \
hb-ot-map.cc \
hb-ot-shape.cc \
hb-ot-shape-complex-arabic.cc \
hb-ot-shape-complex-default.cc \
hb-ot-shape-complex-hangul.cc \
hb-ot-shape-complex-hebrew.cc \
hb-ot-shape-complex-indic.cc \
hb-ot-shape-complex-indic-table.cc \
hb-ot-shape-complex-myanmar.cc \
hb-ot-shape-complex-sea.cc \
hb-ot-shape-complex-thai.cc \
hb-ot-shape-complex-tibetan.cc \
hb-ot-shape-normalize.cc \
hb-ot-shape-fallback.cc \
hb-icu.cc \
hb-graphite2.cc"

DEFS="-DHAVE_CONFIG_H=1 -DWIN32=1 -DNO_KPSE_DLL=1 -D_CRT_SECURE_NO_DEPRECATE=1 \
-D_CRT_NONSTDC_NO_DEPRECATE -D_CRT_OBSOLETE_NO_DEPRECATE \
-D_SECURE_SCL=0 -DGRAPHITE2_STATIC=1"

icudir=icu-551
grdir=../../../graphite2-1.2.4

FTINC=-I../../../freetype/include

GRINC=-I$grdir/include

ICUINC="-I../../../$icudir/source/common/unicode \
-I../../../$icudir/source/common \
-I../../../$icudir/source/layout \
-I../../../$icudir/source"

INCS="-I. -I.. $FTINC $GRINC $ICUINC"

rm -f depend.mk
touch depend.mk
makedepend -fdepend.mk -o.obj -pobjs/ --cpp=vc --cpp-bin=cl --newline=unix \
 $DEFS $INCS $SRCS
