/* deltexlsr.c

   Copyright 2000, 2015 Akira Kakuto.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public License
   along with this library; if not, see <http://www.gnu.org/licenses/>.

   deltexlsr ( erase ls-R files )
   Web2C 7.3.7 (2002/04/26 --ak)
   !! construct (2002/10/09 --ak)
   Web2C 7.3.8 (2002/10/13 --ak)
   Web2C 7.3.9 (2002/10/25 --ak)
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <malloc.h>
#include <kpathsea/kpathsea.h>

#define  TEXMFDBS  "TEXMFDBS"

int main(int ac, char **av)
{
  char *texmfdbs = NULL;
  char ls_R_name[512];
  int  i, numtree;
  size_t len;
  char *progname;
  char **pathbuff = NULL;
  char *p, *pa, *pc;

  kpse_set_program_name(av[0], NULL);
  progname = kpse_program_name;

  if(!(p = kpse_var_value(TEXMFDBS))) {
    fprintf(stderr, "TEXMFDBS is not defined in texmf.cnf.\n");
    exit (100);
  }

  texmfdbs = kpse_brace_expand(p);
  free(p);

  p = texmfdbs;
  i = 0;

  while(*p) {
    if(*p == '!' && *(p+1) == '!')
      p += 2;
    if(*p == ';')
      while(*p == ';')
        p++;
    if(*p && *p != '!') {
      while(*p != ';' && *p)
        p++;
      if(*p == ';') {
        i++;
        while(*p == ';')
          p++;
      } else if(*p == '\0') {
        i++;
        break;
      }
    }
  }

  numtree = i;

  pathbuff = malloc(numtree * sizeof(char *));

  i = 0;
  pa = texmfdbs;

  while (*pa) {
    if (*pa == '!' && *(pa + 1) == '!')
      pa += 2;
    if (*pa == ';') {
      while (*pa == ';')
        pa++;
    }
    if(*pa && *pa != '!') {
      pathbuff[i] = malloc(strlen(pa) + 1);
      pc = pathbuff[i];
      while (*pa != ';' && *pa)
        *pc++ = *pa++;
      *pc = '\0';
      if (*pa == ';') {
        while (*pa == ';')
          pa++;
        i++;
      } else if (*pa == '\0') {
        i++;
        break;
      }
    }
  }

  for(i = 0; i < numtree; i++) {
    strcpy(ls_R_name, pathbuff[i]);
    len = strlen(ls_R_name);
    if(ls_R_name[len-1] != '/') strcat(ls_R_name, "/");
    strcat(ls_R_name, "ls-R");

    if(_access(ls_R_name, 0) == 0) {
      if(remove(ls_R_name) == 0)
        fprintf(stdout, "Deleted : %s\n", ls_R_name);
      else
        fprintf(stdout, "Failed to delete %s\n", ls_R_name);
    }
    else
      fprintf(stdout, "%s does not exist\n", ls_R_name);
  }

  fprintf(stdout, "%s: Done.\n", progname);
  
  for(i = 0; i < numtree; i++) {
    free(pathbuff[i]);
  }
  
  free(pathbuff);

  if(texmfdbs)
    free(texmfdbs);

  return 0;
}
