/* `rm' file deletion utility for GNU.
   Copyright (C) 88, 90, 91, 94, 95, 1996 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  */

/* Written by Paul Rubin, David MacKenzie, and Richard Stallman.  */

/* Adapted for pkfind by Paul Vojta. */

#include <config.h>
#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>

#include "defs.h"
#include "modetype.h"

#if ENABLE_NLS
# include <libintl.h>
# define _(Text) gettext (Text)
#else
# define _(Text) Text
#endif

#ifndef STDIN_FILENO
#define STDIN_FILENO 0
#endif

#ifndef STDOUT_FILENO
#define STDOUT_FILENO 1
#endif

#ifndef STDERR_FILENO
#define STDERR_FILENO 2
#endif

#ifndef F_OK
# define F_OK 0
# define X_OK 1
# define W_OK 2
# define R_OK 4
#endif

int euidaccess ();
int yesno ();

/* Query the user if appropriate, and if ok try to remove the
   non-directory `name', which STATP contains info about.  */

boolean
remove_file (name, relname, statp, ignore_missing_files)
     char *name;
     char *relname;
     struct stat *statp;
     boolean ignore_missing_files;
{
  static boolean have_stdin_tty = false;
  static stdin_tty;

  if (!ignore_missing_files && !have_stdin_tty)
    {
      stdin_tty = isatty (STDIN_FILENO);
      have_stdin_tty = true;
    }

  if (!ignore_missing_files && stdin_tty && euidaccess (relname, W_OK)
#ifdef S_ISLNK
      && !S_ISLNK (statp->st_mode)
#endif
      )
    {
      fprintf (stderr, _("%s: remove `%s', overriding mode %04o? "),
	       program_name,
	       name,
	       (unsigned int) (statp->st_mode & 07777));
      if (!yesno ())
	return false;
    }

  if (unlink (relname) && (errno != ENOENT || !ignore_missing_files))
    {
      error (0, errno, "%s", name);
      return false;
    }

  return true;
}
