%
%
% change file of psout.w for jMetaPost (CWEB version)
% Akira Kakuto (translated the WEB version)
%
%

@x
#include "mppsout.h" /* internal header */
#include "mpmath.h" /* internal header */
@y
#include "mppsout.h" /* internal header */
#include "mpmath.h" /* internal header */
#include <ptexenc/ptexenc.h>
#include <ptexenc/unicode.h>
@z

% Treat all Kanji fonts as used
@x
    if ( mp->font_info[p].qqqq.b3==mp_used ) 
@y
    if ( mp->font_info[p].qqqq.b3==mp_used || mp->font_id[f]!=0)
@z

%
% Kanji string output
@x
static void mp_print_initial_comment(MP mp,mp_edge_object *hh, int prologues);
@y
static void mp_print_initial_comment(MP mp,mp_edge_object *hh, int prologues);
void mp_ps_kanji_string_out (MP mp,mp_string s);

#define Hi(x) (((x) >> 8) & 0xff)
#define Lo(x) ((x) & 0xff)

@ @c
void mp_ps_kanji_string_out (MP mp, char *s)
{
int i, len;
int c, cx;

len = strlen(s);
i=0;
mp_ps_print(mp, "<");
while (i<len) {
  if ( mp->ps->ps_offset+5>mp->max_print_line )
    mp_ps_print_ln(mp);
  c=toDVI(fromBUFF(s, len, i));
  i=i+multistrlen(s, len, i);
  if (isinternalUPTEX && c>65535) {
    cx=UTF32toUTF16HS(c); /* High surrogate */
    mp_hex_digit_out(mp, Hi(cx) / 16);
    mp_hex_digit_out(mp, Hi(cx) % 16);
    mp_hex_digit_out(mp, Lo(cx) / 16);
    mp_hex_digit_out(mp, Lo(cx) % 16);
    c=UTF32toUTF16LS(c); /* Low surrogate */
  }
  mp_hex_digit_out(mp, Hi(c) / 16);
  mp_hex_digit_out(mp, Hi(c) % 16);
  mp_hex_digit_out(mp, Lo(c) / 16);
  mp_hex_digit_out(mp, Lo(c) % 16);
  };
mp_ps_print(mp, ">");
};
@z

@x
  mp_ps_print_nl(mp, "%%Creator: MetaPost ");
@y
  mp_ps_print_nl(mp, "%%Creator: MetaPost (upTeX version) ");
@z

%
% Call Kanji string output routine if the font is JFM.
@x
        mp_ps_string_out(mp, gr_text_p(p),gr_text_l(p));
        mp_ps_name_out(mp, mp->font_name[gr_font_n(p)],false);
@y
        if (mp->font_id[gr_font_n(p)]!=0)
           mp_ps_kanji_string_out(mp, gr_text_p(p));
        else
           mp_ps_string_out(mp, gr_text_p(p),gr_text_l(p));
        mp_ps_name_out(mp, mp->font_name[gr_font_n(p)],false);
@z
