//================================================= -*- mode: c++ -*- ====
//
// poppler-config.h
//
// Copyright 1996-2004 Glyph & Cog, LLC
//
//========================================================================

#ifndef POPPLER_CONFIG_H
#define POPPLER_CONFIG_H

// We duplicate some of the config.h #define's here since they are
// used in some of the header files we install.  The #ifndef/#endif
// around #undef look odd, but it's to silence warnings about
// redefining those symbols.

/* Enable multithreading support. */
#ifndef MULTITHREADED
#define MULTITHREADED 1
#endif

#define POPPLER_VERSION "0.25.2"
#define PACKAGE_VERSION "0.25.2"
/* Use fixedpoint. */
#ifndef USE_FIXEDPOINT
#undef USE_FIXEDPOINT
#endif

/* Include support for OPI comments. */
#ifndef OPI_SUPPORT
#define OPI_SUPPORT 1
#endif

/* Enable word list support. */
#ifndef TEXTOUT_WORD_LIST
#define TEXTOUT_WORD_LIST 1
#endif

/* Use fontconfig font configuration backend */
#ifndef WITH_FONTCONFIGURATION_FONTCONFIG
#undef WITH_FONTCONFIGURATION_FONTCONFIG
#endif

/* Use win32 font configuration backend */
#ifndef WITH_FONTCONFIGURATION_WIN32
#define WITH_FONTCONFIGURATION_WIN32 1
#endif

/* Support for curl is compiled in. */
#ifndef POPPLER_HAS_CURL_SUPPORT
#undef POPPLER_HAS_CURL_SUPPORT
#endif

/* Use libjpeg instead of builtin jpeg decoder. */
#ifndef ENABLE_LIBJPEG
#undef ENABLE_LIBJPEG
#endif

/* Build against libtiff. */
#ifndef ENABLE_LIBTIFF
#undef ENABLE_LIBTIFF
#endif

/* Build against libpng. */
#ifndef ENABLE_LIBPNG
#define ENABLE_LIBPNG 1
#endif

/* Use zlib instead of builtin zlib decoder. */
#ifndef ENABLE_ZLIB
#define ENABLE_ZLIB 1
#endif

/* Define to 1 if you have the <dirent.h> header file, and it defines `DIR'.
   */
#ifndef HAVE_DIRENT_H
#undef HAVE_DIRENT_H
#endif

/* Defines if gettimeofday is available on your system */
#ifndef HAVE_GETTIMEOFDAY
#undef HAVE_GETTIMEOFDAY
#endif

/* Define to 1 if you have the <ndir.h> header file, and it defines `DIR'. */
#ifndef HAVE_NDIR_H
#undef HAVE_NDIR_H
#endif

/* Define to 1 if you have the <sys/dir.h> header file, and it defines `DIR'.
   */
#ifndef HAVE_SYS_DIR_H
#undef HAVE_SYS_DIR_H
#endif

/* Define to 1 if you have the <sys/ndir.h> header file, and it defines `DIR'.
   */
#ifndef HAVE_SYS_NDIR_H
#undef HAVE_SYS_NDIR_H
#endif

/* Have FreeType2 include files */
#ifndef HAVE_FREETYPE_H
#define HAVE_FREETYPE_H 1
#endif

/* Defines if use cms */
#ifndef USE_CMS
#undef USE_CMS
#endif

// Also, there's a couple of preprocessor symbols in the header files
// that are used but never defined: DISABLE_OUTLINE, DEBUG_MEM and

//------------------------------------------------------------------------
// version
//------------------------------------------------------------------------

// copyright notice
#define popplerCopyright "Copyright 2005-2011 The Poppler Developers - http://poppler.freedesktop.org"
#define xpdfCopyright "Copyright 1996-2004 Glyph & Cog, LLC"

//------------------------------------------------------------------------
// popen
//------------------------------------------------------------------------
#include <stdio.h>
#ifdef __cplusplus
extern "C" {
#endif
extern FILE *win32_popen(const char *cmd, const char *mode);
extern int win32_pclose(FILE *file);
#ifdef __cplusplus
}
#endif

#if defined(VMS) || defined(VMCMS) || defined(DOS) || defined(OS2) || defined(__EMX__) || defined(_WIN32) || defined(__DJGPP__) || defined(MACOS)
#define POPEN_READ_MODE "rb"
#else
#define POPEN_READ_MODE "r"
#endif

//------------------------------------------------------------------------
// Win32 stuff
//------------------------------------------------------------------------

#if defined(_WIN32) && !defined(_MSC_VER)
#include <windef.h>
#else
#define CDECL
#endif

#if defined(_WIN32)
#ifdef _MSC_VER
#define strtok_r strtok_s
#elif __MINGW32__
char * strtok_r (char *s, const char *delim, char **save_ptr);
#endif
#endif

//------------------------------------------------------------------------
// Compiler
//------------------------------------------------------------------------

#if __GNUC__ > 2 || (__GNUC__ == 2 && __GNUC_MINOR__ > 4)
#define GCC_PRINTF_FORMAT(fmt_index, va_index) \
	__attribute__((__format__(__printf__, fmt_index, va_index)))
#else
#define GCC_PRINTF_FORMAT(fmt_index, va_index)
#endif

#if defined(_MSC_VER)
#define fmax(a, b) std::max(a, b)
#define fmin(a, b) std::min(a, b)
#include <inttypes.h>
#endif


#endif /* POPPLER_CONFIG_H */
