#!/bin/sh
SHELL=sh
SRCDIR=../src
HEAD=fcalias.h
TAIL=fcaliastail.h
rm -f $HEAD $TAIL
echo "#if HAVE_GNUC_ATTRIBUTE" >> $TAIL
for name in \
FcBlanksCreate \
FcBlanksDestroy \
FcBlanksAdd \
FcBlanksIsMember \
FcCacheDir \
FcCacheCopySet \
FcCacheSubdir \
FcCacheNumSubdir \
FcCacheNumFont \
FcDirCacheUnlink \
FcDirCacheValid \
FcDirCacheClean \
FcCacheCreateTagFile \
FcConfigHome \
FcConfigEnableHome \
FcConfigFilename \
FcConfigCreate \
FcConfigReference \
FcConfigDestroy \
FcConfigSetCurrent \
FcConfigGetCurrent \
FcConfigUptoDate \
FcConfigBuildFonts \
FcConfigGetFontDirs \
FcConfigGetConfigDirs \
FcConfigGetConfigFiles \
FcConfigGetCache \
FcConfigGetBlanks \
FcConfigGetCacheDirs \
FcConfigGetRescanInterval \
FcConfigSetRescanInterval \
FcConfigGetFonts \
FcConfigAppFontAddFile \
FcConfigAppFontAddDir \
FcConfigAppFontClear \
FcConfigSubstituteWithPat \
FcConfigSubstitute \
FcConfigGetSysRoot \
FcConfigSetSysRoot \
FcCharSetCreate \
FcCharSetNew \
FcCharSetDestroy \
FcCharSetAddChar \
FcCharSetDelChar \
FcCharSetCopy \
FcCharSetEqual \
FcCharSetIntersect \
FcCharSetUnion \
FcCharSetSubtract \
FcCharSetMerge \
FcCharSetHasChar \
FcCharSetCount \
FcCharSetIntersectCount \
FcCharSetSubtractCount \
FcCharSetIsSubset \
FcCharSetFirstPage \
FcCharSetNextPage \
FcCharSetCoverage \
FcValuePrint \
FcPatternPrint \
FcFontSetPrint \
FcGetDefaultLangs \
FcDefaultSubstitute \
FcFileIsDir \
FcFileScan \
FcDirScan \
FcDirSave \
FcDirCacheLoad \
FcDirCacheRescan \
FcDirCacheRead \
FcDirCacheLoadFile \
FcDirCacheUnload \
FcFreeTypeQuery \
FcFontSetCreate \
FcFontSetDestroy \
FcFontSetAdd \
FcInitLoadConfig \
FcInitLoadConfigAndFonts \
FcInit \
FcFini \
FcGetVersion \
FcInitReinitialize \
FcInitBringUptoDate \
FcGetLangs \
FcLangNormalize \
FcLangGetCharSet \
FcLangSetCreate \
FcLangSetDestroy \
FcLangSetCopy \
FcLangSetAdd \
FcLangSetDel \
FcLangSetHasLang \
FcLangSetCompare \
FcLangSetContains \
FcLangSetEqual \
FcLangSetHash \
FcLangSetGetLangs \
FcLangSetUnion \
FcLangSetSubtract \
FcObjectSetCreate \
FcObjectSetAdd \
FcObjectSetDestroy \
FcObjectSetVaBuild \
FcObjectSetBuild \
FcFontSetList \
FcFontList \
FcAtomicCreate \
FcAtomicLock \
FcAtomicNewFile \
FcAtomicOrigFile \
FcAtomicReplaceOrig \
FcAtomicDeleteNew \
FcAtomicUnlock \
FcAtomicDestroy \
FcFontSetMatch \
FcFontMatch \
FcFontRenderPrepare \
FcFontSetSort \
FcFontSort \
FcFontSetSortDestroy \
FcMatrixCopy \
FcMatrixEqual \
FcMatrixMultiply \
FcMatrixRotate \
FcMatrixScale \
FcMatrixShear \
FcNameRegisterObjectTypes \
FcNameUnregisterObjectTypes \
FcNameGetObjectType \
FcNameRegisterConstants \
FcNameUnregisterConstants \
FcNameGetConstant \
FcNameConstant \
FcNameParse \
FcNameUnparse \
FcPatternCreate \
FcPatternDuplicate \
FcPatternReference \
FcPatternFilter \
FcValueDestroy \
FcValueEqual \
FcValueSave \
FcPatternDestroy \
FcPatternEqual \
FcPatternEqualSubset \
FcPatternHash \
FcPatternAdd \
FcPatternAddWeak \
FcPatternGet \
FcPatternDel \
FcPatternRemove \
FcPatternAddInteger \
FcPatternAddDouble \
FcPatternAddString \
FcPatternAddMatrix \
FcPatternAddCharSet \
FcPatternAddBool \
FcPatternAddLangSet \
FcPatternGetInteger \
FcPatternGetDouble \
FcPatternGetString \
FcPatternGetMatrix \
FcPatternGetCharSet \
FcPatternGetBool \
FcPatternGetLangSet \
FcPatternVaBuild \
FcPatternBuild \
FcPatternFormat \
FcStrCopy \
FcStrCopyFilename \
FcStrPlus \
FcStrFree \
FcStrDowncase \
FcStrCmpIgnoreCase \
FcStrCmp \
FcStrStrIgnoreCase \
FcStrStr \
FcUtf8ToUcs4 \
FcUtf8Len \
FcUcs4ToUtf8 \
FcUtf16ToUcs4 \
FcUtf16Len \
FcStrDirname \
FcStrBasename \
FcStrSetCreate \
FcStrSetMember \
FcStrSetEqual \
FcStrSetAdd \
FcStrSetAddFilename \
FcStrSetDel \
FcStrSetDestroy \
FcStrListCreate \
FcStrListFirst \
FcStrListNext \
FcStrListDone \
FcConfigParseAndLoad \
FcConfigGetRescanInverval \
FcConfigSetRescanInverval
do
	case $name in
	FcCacheDir|FcCacheSubdir)
		;;
	*)
		alias="IA__$name"
		hattr='__attribute((visibility("hidden")))'
		echo "extern __typeof ($name) $alias $hattr;" >> $HEAD
		echo "#define $name $alias" >> $HEAD
		grep -l '^'$name'[ (]' "$SRCDIR"/*.c | head -1 | sed -e 's/^.*\/\([^.]*\)\.c/#ifdef __\1__/' >> $TAIL
		echo "#undef $name" >> $TAIL
		cattr='__attribute((alias("'$alias'"), visibility("default")))'
		echo "extern __typeof ($name) $name $cattr;" >> $TAIL
		echo "#endif" >> $TAIL
		;;
	esac
done
echo "#endif" >> $TAIL
