/*
   utf8toutf.c --ak 2004/01/05 (Borrowed from inutf8.otp in Omega)

   utf8toutf changes utf-8 into sjis or euc and \UTF/\CID commands
   in utf/otf packages for pLaTeX by S. Saito. Some of Latin characters
   are converted into TeX commands.


   Usage: utf8toutf [-c] [-s|-e] [input] [output]
          Default input is stdin, and default output is stdout.

          utf8toutf --help
          Prints help message and exits.

          utf8toutf --version
          Prints version number and exits.

          -c : China characters are prefered for some surrogate pairs.

   How to get a source for pTeX from a source written by utf-8:
   (1) utf8toutf <utf8.tex >ptexsource.tex
   (2) cat utf8.tex | utf8toutf >ptexsource.tex
   (3) utf8toutf utf8.tex >ptexsource.tex
   (4) utf8toutf utf8.tex ptexsource.tex


   Output encodings of utf8toutf are sjis or euc, depending on the
   compiling time options (default), and on the execution time
   options (-s: sjis, -e: euc) :

   (1) MacOS and euc pTeX   --->   -DMACOS -DEUC
   (2) MacOS and sjis pTeX  --->   -DMACOS
   (3) Generic euc pTeX     --->   -DEUC
   (4) Generic sjis pTeX    --->

   (In MacOS, U+2014 = SJIS+815C (Thanks Kino san)).

   Line endings of input can be any of CR, LF or CRLF. 
*/

#include <stdio.h>
#include <stdlib.h>

#ifdef WIN32
#include <io.h>
#include <fcntl.h>
#define RMODE "rb"
#define WMODE "wb"
#else
#define RMODE "r"
#define WMODE "w"
#endif

/*
   Global variables: File pointers, ...
*/
FILE *Finp;
FILE *Fout;
char *Version = "20040105";
int  Chlang = 0;
#ifdef EUC
int  Euc = 1;
#else
int  Euc = 0;
#endif

/*--------------
Begin (tables)
  --------------*/
/*
  Latin2tex tables by Kino san

needs
\usepackage[T1]{fontenc}
\usepackage{textcomp}
\usepackage{lmodern}
\usepackage{utf}

*/

/*
  U+00A0 --- U+05FF
*/

char *latin2tex_a[] = {
"~",                      /* 0x00a0 (00160) */
"!`",                     /* 0x00a1 (00161) */
"{\\textcentoldstyle}",   /* 0x00a2 (00162) */
"{\\textsterling}",       /* 0x00a3 (00163) */
"{\\textcurrency}",       /* 0x00a4 (00164) */
"{\\textyen}",            /* 0x00a5 (00165) */
"{\\textbrokenbar}",      /* 0x00a6 (00166) */
"{\\textsection}",        /* 0x00a7 (00167) */
"{\\textasciidieresis}",  /* 0x00a8 (00168) */
"{\\copyright}",          /* 0x00a9 (00169) */
"{\\textordfeminine}",    /* 0x00aa (00170) */
"{\\guillemotleft}",      /* 0x00ab (00171) */
"{\\textlnot}",           /* 0x00ac (00172) */
"\\-",                    /* 0x00ad (00173) */
"{\\textregistered}",     /* 0x00ae (00174) */
"{\\textasciimacron}",    /* 0x00af (00175) */
"{\\textdegree}",         /* 0x00b0 (00176) */
"{\\textpm}",             /* 0x00b1 (00177) */
"{\\texttwosuperior}",    /* 0x00b2 (00178) */
"{\\textthreesuperior}",  /* 0x00b3 (00179) */
"{\\textasciiacute}",     /* 0x00b4 (00180) */
"{\\textmu}",             /* 0x00b5 (00181) */
"{\\textparagraph}",      /* 0x00b6 (00182) */
"{\\textperiodcentered}", /* 0x00b7 (00183) */
"\\c{}",                  /* 0x00b8 (00184) */
"{\\textonesuperior}",    /* 0x00b9 (00185) */
"{\\textordmasculine}",   /* 0x00ba (00186) */
"{\\guillemotright}",     /* 0x00bb (00187) */
"{\\textonequarter}",     /* 0x00bc (00188) */
"{\\textonehalf}",        /* 0x00bd (00189) */
"{\\textthreequarters}",  /* 0x00be (00190) */
"?`",                     /* 0x00bf (00191) */
"\\`{A}",                 /* 0x00c0 (00192) */
"\\'{A}",                 /* 0x00c1 (00193) */
"\\^{A}",                 /* 0x00c2 (00194) */
"\\~{A}",                 /* 0x00c3 (00195) */
"\\\"{A}",                /* 0x00c4 (00196) */
"\\r{A}",                 /* 0x00c5 (00197) */
"{\\AE}",                 /* 0x00c6 (00198) */
"\\c{C}",                 /* 0x00c7 (00199) */
"\\`{E}",                 /* 0x00c8 (00200) */
"\\'{E}",                 /* 0x00c9 (00201) */
"\\^{E}",                 /* 0x00ca (00202) */
"\\\"{E}",                /* 0x00cb (00203) */
"\\`{I}",                 /* 0x00cc (00204) */
"\\'{I}",                 /* 0x00cd (00205) */
"\\^{I}",                 /* 0x00ce (00206) */
"\\\"{I}",                /* 0x00cf (00207) */
"{\\DH}",                 /* 0x00d0 (00208) */
"\\~{N}",                 /* 0x00d1 (00209) */
"\\`{O}",                 /* 0x00d2 (00210) */
"\\'{O}",                 /* 0x00d3 (00211) */
"\\^{O}",                 /* 0x00d4 (00212) */
"\\~{O}",                 /* 0x00d5 (00213) */
"\\\"{O}",                /* 0x00d6 (00214) */
"{\\texttimes}",          /* 0x00d7 (00215) */
"{\\O}",                  /* 0x00d8 (00216) */
"\\`{U}",                 /* 0x00d9 (00217) */
"\\'{U}",                 /* 0x00da (00218) */
"\\^{U}",                 /* 0x00db (00219) */
"\\\"{U}",                /* 0x00dc (00220) */
"\\'{Y}",                 /* 0x00dd (00221) */
"{\\TH}",                 /* 0x00de (00222) */
"{\\ss}",                 /* 0x00df (00223) */
"\\`{a}",                 /* 0x00e0 (00224) */
"\\'{a}",                 /* 0x00e1 (00225) */
"\\^{a}",                 /* 0x00e2 (00226) */
"\\~{a}",                 /* 0x00e3 (00227) */
"\\\"{a}",                /* 0x00e4 (00228) */
"\\r{a}",                 /* 0x00e5 (00229) */
"{\\ae}",                 /* 0x00e6 (00230) */
"\\c{c}",                 /* 0x00e7 (00231) */
"\\`{e}",                 /* 0x00e8 (00232) */
"\\'{e}",                 /* 0x00e9 (00233) */
"\\^{e}",                 /* 0x00ea (00234) */
"\\\"{e}",                /* 0x00eb (00235) */
"\\`{\\i}",               /* 0x00ec (00236) */
"\\'{\\i}",               /* 0x00ed (00237) */
"\\^{\\i}",               /* 0x00ee (00238) */
"\\\"{\\i}",              /* 0x00ef (00239) */
"{\\dh}",                 /* 0x00f0 (00240) */
"\\~{n}",                 /* 0x00f1 (00241) */
"\\`{o}",                 /* 0x00f2 (00242) */
"\\'{o}",                 /* 0x00f3 (00243) */
"\\^{o}",                 /* 0x00f4 (00244) */
"\\~{o}",                 /* 0x00f5 (00245) */
"\\\"{o}",                /* 0x00f6 (00246) */
"{\\textdiv}",            /* 0x00f7 (00247) */
"{\\o}",                  /* 0x00f8 (00248) */
"\\`{u}",                 /* 0x00f9 (00249) */
"\\'{u}",                 /* 0x00fa (00250) */
"\\^{u}",                 /* 0x00fb (00251) */
"\\\"{u}",                /* 0x00fc (00252) */
"\\'{y}",                 /* 0x00fd (00253) */
"{\\th}",                 /* 0x00fe (00254) */
"\\\"{y}",                /* 0x00ff (00255) */
"\\={A}",                 /* 0x0100 (00256) */
"\\={a}",                 /* 0x0101 (00257) */
"\\u{A}",                 /* 0x0102 (00258) */
"\\u{a}",                 /* 0x0103 (00259) */
"\\k{A}",                 /* 0x0104 (00260) */
"\\k{a}",                 /* 0x0105 (00261) */
"\\'{C}",                 /* 0x0106 (00262) */
"\\'{c}",                 /* 0x0107 (00263) */
"\\^{C}",                 /* 0x0108 (00264) */
"\\^{c}",                 /* 0x0109 (00265) */
"\\.{C}",                 /* 0x010a (00266) */
"\\.{c}",                 /* 0x010b (00267) */
"\\v{C}",                 /* 0x010c (00268) */
"\\v{c}",                 /* 0x010d (00269) */
"\\v{D}",                 /* 0x010e (00270) */
"\\v{d}",                 /* 0x010f (00271) */
"{\\DJ}",                 /* 0x0110 (00272) */
"{\\dj}",                 /* 0x0111 (00273) */
"\\={E}",                 /* 0x0112 (00274) */
"\\={e}",                 /* 0x0113 (00275) */
"\\u{E}",                 /* 0x0114 (00276) */
"\\u{e}",                 /* 0x0115 (00277) */
"\\.{E}",                 /* 0x0116 (00278) */
"\\.{e}",                 /* 0x0117 (00279) */
"\\k{E}",                 /* 0x0118 (00280) */
"\\k{e}",                 /* 0x0119 (00281) */
"\\v{E}",                 /* 0x011a (00282) */
"\\v{e}",                 /* 0x011b (00283) */
"\\^{G}",                 /* 0x011c (00284) */
"\\^{g}",                 /* 0x011d (00285) */
"\\u{G}",                 /* 0x011e (00286) */
"\\u{g}",                 /* 0x011f (00287) */
"\\.{G}",                 /* 0x0120 (00288) */
"\\.{g}",                 /* 0x0121 (00289) */
"\\c{G}",                 /* 0x0122 (00290) */
NULL,                     /* 0x0123 (00291) */
"\\^{H}",                 /* 0x0124 (00292) */
"\\^{h}",                 /* 0x0125 (00293) */
NULL,                     /* 0x0126 (00294) */
NULL,                     /* 0x0127 (00295) */
"\\~{I}",                 /* 0x0128 (00296) */
"\\~{\\i}",               /* 0x0129 (00297) */
"\\={I}",                 /* 0x012a (00298) */
"\\={\\i}",               /* 0x012b (00299) */
"\\u{I}",                 /* 0x012c (00300) */
"\\u{\\i}",               /* 0x012d (00301) */
"\\k{I}",                 /* 0x012e (00302) */
"\\k{i}",                 /* 0x012f (00303) */
"\\.{I}",                 /* 0x0130 (00304) */
"{\\i}",                  /* 0x0131 (00305) */
NULL,                     /* 0x0132 (00306) */
NULL,                     /* 0x0133 (00307) */
"\\^{J}",                 /* 0x0134 (00308) */
"\\^{\\j}",               /* 0x0135 (00309) */
"\\c{K}",                 /* 0x0136 (00310) */
"\\c{k}",                 /* 0x0137 (00311) */
NULL,                     /* 0x0138 (00312) */
"\\'{L}",                 /* 0x0139 (00313) */
"\\'{l}",                 /* 0x013a (00314) */
"\\c{L}",                 /* 0x013b (00315) */
"\\c{l}",                 /* 0x013c (00316) */
"\\v{L}",                 /* 0x013d (00317) */
"\\v{l}",                 /* 0x013e (00318) */
NULL,                     /* 0x013f (00319) */
NULL,                     /* 0x0140 (00320) */
"{\\L}",                  /* 0x0141 (00321) */
"{\\l}",                  /* 0x0142 (00322) */
"\\'{N}",                 /* 0x0143 (00323) */
"\\'{n}",                 /* 0x0144 (00324) */
"\\c{N}",                 /* 0x0145 (00325) */
"\\c{n}",                 /* 0x0146 (00326) */
"\\v{N}",                 /* 0x0147 (00327) */
"\\v{n}",                 /* 0x0148 (00328) */
NULL,                     /* 0x0149 (00329) */
NULL,                     /* 0x014a (00330) */
NULL,                     /* 0x014b (00331) */
"\\={O}",                 /* 0x014c (00332) */
"\\={o}",                 /* 0x014d (00333) */
"\\u{O}",                 /* 0x014e (00334) */
"\\u{o}",                 /* 0x014f (00335) */
"\\H{O}",                 /* 0x0150 (00336) */
"\\H{o}",                 /* 0x0151 (00337) */
"{\\OE}",                 /* 0x0152 (00338) */
"{\\oe}",                 /* 0x0153 (00339) */
"\\'{R}",                 /* 0x0154 (00340) */
"\\'{r}",                 /* 0x0155 (00341) */
"\\c{R}",                 /* 0x0156 (00342) */
"\\c{r}",                 /* 0x0157 (00343) */
"\\v{R}",                 /* 0x0158 (00344) */
"\\v{r}",                 /* 0x0159 (00345) */
"\\'{S}",                 /* 0x015a (00346) */
"\\'{s}",                 /* 0x015b (00347) */
"\\^{S}",                 /* 0x015c (00348) */
"\\^{s}",                 /* 0x015d (00349) */
"\\c{S}",                 /* 0x015e (00350) */
"\\c{s}",                 /* 0x015f (00351) */
"\\v{S}",                 /* 0x0160 (00352) */
"\\v{s}",                 /* 0x0161 (00353) */
"\\c{T}",                 /* 0x0162 (00354) */
"\\c{t}",                 /* 0x0163 (00355) */
"\\v{T}",                 /* 0x0164 (00356) */
"\\v{t}",                 /* 0x0165 (00357) */
NULL,                     /* 0x0166 (00358) */
NULL,                     /* 0x0167 (00359) */
"\\~{U}",                 /* 0x0168 (00360) */
"\\~{u}",                 /* 0x0169 (00361) */
"\\={U}",                 /* 0x016a (00362) */
"\\={u}",                 /* 0x016b (00363) */
"\\u{U}",                 /* 0x016c (00364) */
"\\u{u}",                 /* 0x016d (00365) */
"\\r{U}",                 /* 0x016e (00366) */
"\\r{u}",                 /* 0x016f (00367) */
"\\H{U}",                 /* 0x0170 (00368) */
"\\H{u}",                 /* 0x0171 (00369) */
"\\k{U}",                 /* 0x0172 (00370) */
"\\k{u}",                 /* 0x0173 (00371) */
"\\^{W}",                 /* 0x0174 (00372) */
"\\^{w}",                 /* 0x0175 (00373) */
"\\^{Y}",                 /* 0x0176 (00374) */
"\\^{y}",                 /* 0x0177 (00375) */
"\\\"{Y}",                /* 0x0178 (00376) */
"\\'{Z}",                 /* 0x0179 (00377) */
"\\'{z}",                 /* 0x017a (00378) */
"\\.{Z}",                 /* 0x017b (00379) */
"\\.{z}",                 /* 0x017c (00380) */
"\\v{Z}",                 /* 0x017d (00381) */
"\\v{z}",                 /* 0x017e (00382) */
NULL,                     /* 0x017f (00383) */
NULL,                     /* 0x0180 (00384) */
NULL,                     /* 0x0181 (00385) */
NULL,                     /* 0x0182 (00386) */
NULL,                     /* 0x0183 (00387) */
NULL,                     /* 0x0184 (00388) */
NULL,                     /* 0x0185 (00389) */
NULL,                     /* 0x0186 (00390) */
NULL,                     /* 0x0187 (00391) */
NULL,                     /* 0x0188 (00392) */
NULL,                     /* 0x0189 (00393) */
NULL,                     /* 0x018a (00394) */
NULL,                     /* 0x018b (00395) */
NULL,                     /* 0x018c (00396) */
NULL,                     /* 0x018d (00397) */
NULL,                     /* 0x018e (00398) */
NULL,                     /* 0x018f (00399) */
NULL,                     /* 0x0190 (00400) */
NULL,                     /* 0x0191 (00401) */
"{\\textflorin}",         /* 0x0192 (00402) */
NULL,                     /* 0x0193 (00403) */
NULL,                     /* 0x0194 (00404) */
NULL,                     /* 0x0195 (00405) */
NULL,                     /* 0x0196 (00406) */
NULL,                     /* 0x0197 (00407) */
NULL,                     /* 0x0198 (00408) */
NULL,                     /* 0x0199 (00409) */
NULL,                     /* 0x019a (00410) */
NULL,                     /* 0x019b (00411) */
NULL,                     /* 0x019c (00412) */
NULL,                     /* 0x019d (00413) */
NULL,                     /* 0x019e (00414) */
NULL,                     /* 0x019f (00415) */
NULL,                     /* 0x01a0 (00416) */
NULL,                     /* 0x01a1 (00417) */
NULL,                     /* 0x01a2 (00418) */
NULL,                     /* 0x01a3 (00419) */
NULL,                     /* 0x01a4 (00420) */
NULL,                     /* 0x01a5 (00421) */
NULL,                     /* 0x01a6 (00422) */
NULL,                     /* 0x01a7 (00423) */
NULL,                     /* 0x01a8 (00424) */
NULL,                     /* 0x01a9 (00425) */
NULL,                     /* 0x01aa (00426) */
NULL,                     /* 0x01ab (00427) */
NULL,                     /* 0x01ac (00428) */
NULL,                     /* 0x01ad (00429) */
NULL,                     /* 0x01ae (00430) */
NULL,                     /* 0x01af (00431) */
NULL,                     /* 0x01b0 (00432) */
NULL,                     /* 0x01b1 (00433) */
NULL,                     /* 0x01b2 (00434) */
NULL,                     /* 0x01b3 (00435) */
NULL,                     /* 0x01b4 (00436) */
NULL,                     /* 0x01b5 (00437) */
NULL,                     /* 0x01b6 (00438) */
NULL,                     /* 0x01b7 (00439) */
NULL,                     /* 0x01b8 (00440) */
NULL,                     /* 0x01b9 (00441) */
NULL,                     /* 0x01ba (00442) */
NULL,                     /* 0x01bb (00443) */
NULL,                     /* 0x01bc (00444) */
NULL,                     /* 0x01bd (00445) */
NULL,                     /* 0x01be (00446) */
NULL,                     /* 0x01bf (00447) */
NULL,                     /* 0x01c0 (00448) */
NULL,                     /* 0x01c1 (00449) */
NULL,                     /* 0x01c2 (00450) */
NULL,                     /* 0x01c3 (00451) */
NULL,                     /* 0x01c4 (00452) */
NULL,                     /* 0x01c5 (00453) */
NULL,                     /* 0x01c6 (00454) */
NULL,                     /* 0x01c7 (00455) */
NULL,                     /* 0x01c8 (00456) */
NULL,                     /* 0x01c9 (00457) */
NULL,                     /* 0x01ca (00458) */
NULL,                     /* 0x01cb (00459) */
NULL,                     /* 0x01cc (00460) */
"\\v{A}",                 /* 0x01cd (00461) */
"\\v{a}",                 /* 0x01ce (00462) */
"\\v{I}",                 /* 0x01cf (00463) */
"\\v{\\i}",               /* 0x01d0 (00464) */
"\\v{O}",                 /* 0x01d1 (00465) */
"\\v{o}",                 /* 0x01d2 (00466) */
"\\v{U}",                 /* 0x01d3 (00467) */
"\\v{u}",                 /* 0x01d4 (00468) */
NULL,                     /* 0x01d5 (00469) */
NULL,                     /* 0x01d6 (00470) */
NULL,                     /* 0x01d7 (00471) */
NULL,                     /* 0x01d8 (00472) */
NULL,                     /* 0x01d9 (00473) */
NULL,                     /* 0x01da (00474) */
NULL,                     /* 0x01db (00475) */
NULL,                     /* 0x01dc (00476) */
NULL,                     /* 0x01dd (00477) */
NULL,                     /* 0x01de (00478) */
NULL,                     /* 0x01df (00479) */
NULL,                     /* 0x01e0 (00480) */
NULL,                     /* 0x01e1 (00481) */
"\\={{\\AE}}",            /* 0x01e2 (00482) */
"\\={{\\ae}}",            /* 0x01e3 (00483) */
NULL,                     /* 0x01e4 (00484) */
NULL,                     /* 0x01e5 (00485) */
"\\v{G}",                 /* 0x01e6 (00486) */
"\\v{g}",                 /* 0x01e7 (00487) */
"\\v{K}",                 /* 0x01e8 (00488) */
"\\v{k}",                 /* 0x01e9 (00489) */
"\\k{O}",                 /* 0x01ea (00490) */
"\\k{o}",                 /* 0x01eb (00491) */
NULL,                     /* 0x01ec (00492) */
NULL,                     /* 0x01ed (00493) */
NULL,                     /* 0x01ee (00494) */
NULL,                     /* 0x01ef (00495) */
"\\v{\\j}",               /* 0x01f0 (00496) */
NULL,                     /* 0x01f1 (00497) */
NULL,                     /* 0x01f2 (00498) */
NULL,                     /* 0x01f3 (00499) */
"\\'{G}",                 /* 0x01f4 (00500) */
"\\'{g}",                 /* 0x01f5 (00501) */
NULL,                     /* 0x01f6 (00502) */
NULL,                     /* 0x01f7 (00503) */
"\\`{N}",                 /* 0x01f8 (00504) */
"\\`{n}",                 /* 0x01f9 (00505) */
NULL,                     /* 0x01fa (00506) */
NULL,                     /* 0x01fb (00507) */
NULL,                     /* 0x01fc (00508) */
NULL,                     /* 0x01fd (00509) */
NULL,                     /* 0x01fe (00510) */
NULL,                     /* 0x01ff (00511) */
NULL,                     /* 0x0200 (00512) */
NULL,                     /* 0x0201 (00513) */
NULL,                     /* 0x0202 (00514) */
NULL,                     /* 0x0203 (00515) */
NULL,                     /* 0x0204 (00516) */
NULL,                     /* 0x0205 (00517) */
NULL,                     /* 0x0206 (00518) */
NULL,                     /* 0x0207 (00519) */
NULL,                     /* 0x0208 (00520) */
NULL,                     /* 0x0209 (00521) */
NULL,                     /* 0x020a (00522) */
NULL,                     /* 0x020b (00523) */
NULL,                     /* 0x020c (00524) */
NULL,                     /* 0x020d (00525) */
NULL,                     /* 0x020e (00526) */
NULL,                     /* 0x020f (00527) */
NULL,                     /* 0x0210 (00528) */
NULL,                     /* 0x0211 (00529) */
NULL,                     /* 0x0212 (00530) */
NULL,                     /* 0x0213 (00531) */
NULL,                     /* 0x0214 (00532) */
NULL,                     /* 0x0215 (00533) */
NULL,                     /* 0x0216 (00534) */
NULL,                     /* 0x0217 (00535) */
NULL,                     /* 0x0218 (00536) */
NULL,                     /* 0x0219 (00537) */
NULL,                     /* 0x021a (00538) */
NULL,                     /* 0x021b (00539) */
NULL,                     /* 0x021c (00540) */
NULL,                     /* 0x021d (00541) */
"\\v{H}",                 /* 0x021e (00542) */
"\\v{h}",                 /* 0x021f (00543) */
NULL,                     /* 0x0220 (00544) */
NULL,                     /* 0x0221 (00545) */
NULL,                     /* 0x0222 (00546) */
NULL,                     /* 0x0223 (00547) */
NULL,                     /* 0x0224 (00548) */
NULL,                     /* 0x0225 (00549) */
"\\.{A}",                 /* 0x0226 (00550) */
"\\.{a}",                 /* 0x0227 (00551) */
"\\c{E}",                 /* 0x0228 (00552) */
"\\c{e}",                 /* 0x0229 (00553) */
NULL,                     /* 0x022a (00554) */
NULL,                     /* 0x022b (00555) */
NULL,                     /* 0x022c (00556) */
NULL,                     /* 0x022d (00557) */
"\\.{O}",                 /* 0x022e (00558) */
"\\.{o}",                 /* 0x022f (00559) */
NULL,                     /* 0x0230 (00560) */
NULL,                     /* 0x0231 (00561) */
"\\={Y}",                 /* 0x0232 (00562) */
"\\={y}",                 /* 0x0233 (00563) */
NULL,                     /* 0x0234 (00564) */
NULL,                     /* 0x0235 (00565) */
NULL,                     /* 0x0236 (00566) */
NULL,                     /* 0x0237 (00567) */
NULL,                     /* 0x0238 (00568) */
NULL,                     /* 0x0239 (00569) */
NULL,                     /* 0x023a (00570) */
NULL,                     /* 0x023b (00571) */
NULL,                     /* 0x023c (00572) */
NULL,                     /* 0x023d (00573) */
NULL,                     /* 0x023e (00574) */
NULL,                     /* 0x023f (00575) */
NULL,                     /* 0x0240 (00576) */
NULL,                     /* 0x0241 (00577) */
NULL,                     /* 0x0242 (00578) */
NULL,                     /* 0x0243 (00579) */
NULL,                     /* 0x0244 (00580) */
NULL,                     /* 0x0245 (00581) */
NULL,                     /* 0x0246 (00582) */
NULL,                     /* 0x0247 (00583) */
NULL,                     /* 0x0248 (00584) */
NULL,                     /* 0x0249 (00585) */
NULL,                     /* 0x024a (00586) */
NULL,                     /* 0x024b (00587) */
NULL,                     /* 0x024c (00588) */
NULL,                     /* 0x024d (00589) */
NULL,                     /* 0x024e (00590) */
NULL,                     /* 0x024f (00591) */
NULL,                     /* 0x0250 (00592) */
NULL,                     /* 0x0251 (00593) */
NULL,                     /* 0x0252 (00594) */
NULL,                     /* 0x0253 (00595) */
NULL,                     /* 0x0254 (00596) */
NULL,                     /* 0x0255 (00597) */
NULL,                     /* 0x0256 (00598) */
NULL,                     /* 0x0257 (00599) */
NULL,                     /* 0x0258 (00600) */
NULL,                     /* 0x0259 (00601) */
NULL,                     /* 0x025a (00602) */
NULL,                     /* 0x025b (00603) */
NULL,                     /* 0x025c (00604) */
NULL,                     /* 0x025d (00605) */
NULL,                     /* 0x025e (00606) */
NULL,                     /* 0x025f (00607) */
NULL,                     /* 0x0260 (00608) */
NULL,                     /* 0x0261 (00609) */
NULL,                     /* 0x0262 (00610) */
NULL,                     /* 0x0263 (00611) */
NULL,                     /* 0x0264 (00612) */
NULL,                     /* 0x0265 (00613) */
NULL,                     /* 0x0266 (00614) */
NULL,                     /* 0x0267 (00615) */
NULL,                     /* 0x0268 (00616) */
NULL,                     /* 0x0269 (00617) */
NULL,                     /* 0x026a (00618) */
NULL,                     /* 0x026b (00619) */
NULL,                     /* 0x026c (00620) */
NULL,                     /* 0x026d (00621) */
NULL,                     /* 0x026e (00622) */
NULL,                     /* 0x026f (00623) */
NULL,                     /* 0x0270 (00624) */
NULL,                     /* 0x0271 (00625) */
NULL,                     /* 0x0272 (00626) */
NULL,                     /* 0x0273 (00627) */
NULL,                     /* 0x0274 (00628) */
NULL,                     /* 0x0275 (00629) */
NULL,                     /* 0x0276 (00630) */
NULL,                     /* 0x0277 (00631) */
NULL,                     /* 0x0278 (00632) */
NULL,                     /* 0x0279 (00633) */
NULL,                     /* 0x027a (00634) */
NULL,                     /* 0x027b (00635) */
NULL,                     /* 0x027c (00636) */
NULL,                     /* 0x027d (00637) */
NULL,                     /* 0x027e (00638) */
NULL,                     /* 0x027f (00639) */
NULL,                     /* 0x0280 (00640) */
NULL,                     /* 0x0281 (00641) */
NULL,                     /* 0x0282 (00642) */
NULL,                     /* 0x0283 (00643) */
NULL,                     /* 0x0284 (00644) */
NULL,                     /* 0x0285 (00645) */
NULL,                     /* 0x0286 (00646) */
NULL,                     /* 0x0287 (00647) */
NULL,                     /* 0x0288 (00648) */
NULL,                     /* 0x0289 (00649) */
NULL,                     /* 0x028a (00650) */
NULL,                     /* 0x028b (00651) */
NULL,                     /* 0x028c (00652) */
NULL,                     /* 0x028d (00653) */
NULL,                     /* 0x028e (00654) */
NULL,                     /* 0x028f (00655) */
NULL,                     /* 0x0290 (00656) */
NULL,                     /* 0x0291 (00657) */
NULL,                     /* 0x0292 (00658) */
NULL,                     /* 0x0293 (00659) */
NULL,                     /* 0x0294 (00660) */
NULL,                     /* 0x0295 (00661) */
NULL,                     /* 0x0296 (00662) */
NULL,                     /* 0x0297 (00663) */
NULL,                     /* 0x0298 (00664) */
NULL,                     /* 0x0299 (00665) */
NULL,                     /* 0x029a (00666) */
NULL,                     /* 0x029b (00667) */
NULL,                     /* 0x029c (00668) */
NULL,                     /* 0x029d (00669) */
NULL,                     /* 0x029e (00670) */
NULL,                     /* 0x029f (00671) */
NULL,                     /* 0x02a0 (00672) */
NULL,                     /* 0x02a1 (00673) */
NULL,                     /* 0x02a2 (00674) */
NULL,                     /* 0x02a3 (00675) */
NULL,                     /* 0x02a4 (00676) */
NULL,                     /* 0x02a5 (00677) */
NULL,                     /* 0x02a6 (00678) */
NULL,                     /* 0x02a7 (00679) */
NULL,                     /* 0x02a8 (00680) */
NULL,                     /* 0x02a9 (00681) */
NULL,                     /* 0x02aa (00682) */
NULL,                     /* 0x02ab (00683) */
NULL,                     /* 0x02ac (00684) */
NULL,                     /* 0x02ad (00685) */
NULL,                     /* 0x02ae (00686) */
NULL,                     /* 0x02af (00687) */
NULL,                     /* 0x02b0 (00688) */
NULL,                     /* 0x02b1 (00689) */
NULL,                     /* 0x02b2 (00690) */
NULL,                     /* 0x02b3 (00691) */
NULL,                     /* 0x02b4 (00692) */
NULL,                     /* 0x02b5 (00693) */
NULL,                     /* 0x02b6 (00694) */
NULL,                     /* 0x02b7 (00695) */
NULL,                     /* 0x02b8 (00696) */
NULL,                     /* 0x02b9 (00697) */
NULL,                     /* 0x02ba (00698) */
NULL,                     /* 0x02bb (00699) */
NULL,                     /* 0x02bc (00700) */
NULL,                     /* 0x02bd (00701) */
NULL,                     /* 0x02be (00702) */
NULL,                     /* 0x02bf (00703) */
NULL,                     /* 0x02c0 (00704) */
NULL,                     /* 0x02c1 (00705) */
NULL,                     /* 0x02c2 (00706) */
NULL,                     /* 0x02c3 (00707) */
NULL,                     /* 0x02c4 (00708) */
NULL,                     /* 0x02c5 (00709) */
"\\^{}",                  /* 0x02c6 (00710) */
"\\v{}",                  /* 0x02c7 (00711) */
NULL,                     /* 0x02c8 (00712) */
NULL,                     /* 0x02c9 (00713) */
NULL,                     /* 0x02ca (00714) */
NULL,                     /* 0x02cb (00715) */
NULL,                     /* 0x02cc (00716) */
NULL,                     /* 0x02cd (00717) */
NULL,                     /* 0x02ce (00718) */
NULL,                     /* 0x02cf (00719) */
NULL,                     /* 0x02d0 (00720) */
NULL,                     /* 0x02d1 (00721) */
NULL,                     /* 0x02d2 (00722) */
NULL,                     /* 0x02d3 (00723) */
NULL,                     /* 0x02d4 (00724) */
NULL,                     /* 0x02d5 (00725) */
NULL,                     /* 0x02d6 (00726) */
NULL,                     /* 0x02d7 (00727) */
"\\u{}",                  /* 0x02d8 (00728) */
"\\.{}",                  /* 0x02d9 (00729) */
"{\\textdegree}",         /* 0x02da (00730) */
"\\k{}",                  /* 0x02db (00731) */
"\\~{}",                  /* 0x02dc (00732) */
"\\H{}",                  /* 0x02dd (00733) */
NULL,                     /* 0x02de (00734) */
NULL,                     /* 0x02df (00735) */
NULL,                     /* 0x02e0 (00736) */
NULL,                     /* 0x02e1 (00737) */
NULL,                     /* 0x02e2 (00738) */
NULL,                     /* 0x02e3 (00739) */
NULL,                     /* 0x02e4 (00740) */
NULL,                     /* 0x02e5 (00741) */
NULL,                     /* 0x02e6 (00742) */
NULL,                     /* 0x02e7 (00743) */
NULL,                     /* 0x02e8 (00744) */
NULL,                     /* 0x02e9 (00745) */
NULL,                     /* 0x02ea (00746) */
NULL,                     /* 0x02eb (00747) */
NULL,                     /* 0x02ec (00748) */
NULL,                     /* 0x02ed (00749) */
NULL,                     /* 0x02ee (00750) */
NULL,                     /* 0x02ef (00751) */
NULL,                     /* 0x02f0 (00752) */
NULL,                     /* 0x02f1 (00753) */
NULL,                     /* 0x02f2 (00754) */
NULL,                     /* 0x02f3 (00755) */
NULL,                     /* 0x02f4 (00756) */
NULL,                     /* 0x02f5 (00757) */
NULL,                     /* 0x02f6 (00758) */
NULL,                     /* 0x02f7 (00759) */
NULL,                     /* 0x02f8 (00760) */
NULL,                     /* 0x02f9 (00761) */
NULL,                     /* 0x02fa (00762) */
NULL,                     /* 0x02fb (00763) */
NULL,                     /* 0x02fc (00764) */
NULL,                     /* 0x02fd (00765) */
NULL,                     /* 0x02fe (00766) */
NULL,                     /* 0x02ff (00767) */
NULL,                     /* 0x0300 (00768) */
NULL,                     /* 0x0301 (00769) */
NULL,                     /* 0x0302 (00770) */
NULL,                     /* 0x0303 (00771) */
NULL,                     /* 0x0304 (00772) */
NULL,                     /* 0x0305 (00773) */
NULL,                     /* 0x0306 (00774) */
NULL,                     /* 0x0307 (00775) */
NULL,                     /* 0x0308 (00776) */
NULL,                     /* 0x0309 (00777) */
NULL,                     /* 0x030a (00778) */
NULL,                     /* 0x030b (00779) */
NULL,                     /* 0x030c (00780) */
NULL,                     /* 0x030d (00781) */
NULL,                     /* 0x030e (00782) */
NULL,                     /* 0x030f (00783) */
NULL,                     /* 0x0310 (00784) */
NULL,                     /* 0x0311 (00785) */
NULL,                     /* 0x0312 (00786) */
NULL,                     /* 0x0313 (00787) */
NULL,                     /* 0x0314 (00788) */
NULL,                     /* 0x0315 (00789) */
NULL,                     /* 0x0316 (00790) */
NULL,                     /* 0x0317 (00791) */
NULL,                     /* 0x0318 (00792) */
NULL,                     /* 0x0319 (00793) */
NULL,                     /* 0x031a (00794) */
NULL,                     /* 0x031b (00795) */
NULL,                     /* 0x031c (00796) */
NULL,                     /* 0x031d (00797) */
NULL,                     /* 0x031e (00798) */
NULL,                     /* 0x031f (00799) */
NULL,                     /* 0x0320 (00800) */
NULL,                     /* 0x0321 (00801) */
NULL,                     /* 0x0322 (00802) */
NULL,                     /* 0x0323 (00803) */
NULL,                     /* 0x0324 (00804) */
NULL,                     /* 0x0325 (00805) */
NULL,                     /* 0x0326 (00806) */
NULL,                     /* 0x0327 (00807) */
NULL,                     /* 0x0328 (00808) */
NULL,                     /* 0x0329 (00809) */
NULL,                     /* 0x032a (00810) */
NULL,                     /* 0x032b (00811) */
NULL,                     /* 0x032c (00812) */
NULL,                     /* 0x032d (00813) */
NULL,                     /* 0x032e (00814) */
NULL,                     /* 0x032f (00815) */
NULL,                     /* 0x0330 (00816) */
NULL,                     /* 0x0331 (00817) */
NULL,                     /* 0x0332 (00818) */
NULL,                     /* 0x0333 (00819) */
NULL,                     /* 0x0334 (00820) */
NULL,                     /* 0x0335 (00821) */
NULL,                     /* 0x0336 (00822) */
NULL,                     /* 0x0337 (00823) */
NULL,                     /* 0x0338 (00824) */
NULL,                     /* 0x0339 (00825) */
NULL,                     /* 0x033a (00826) */
NULL,                     /* 0x033b (00827) */
NULL,                     /* 0x033c (00828) */
NULL,                     /* 0x033d (00829) */
NULL,                     /* 0x033e (00830) */
NULL,                     /* 0x033f (00831) */
NULL,                     /* 0x0340 (00832) */
NULL,                     /* 0x0341 (00833) */
NULL,                     /* 0x0342 (00834) */
NULL,                     /* 0x0343 (00835) */
NULL,                     /* 0x0344 (00836) */
NULL,                     /* 0x0345 (00837) */
NULL,                     /* 0x0346 (00838) */
NULL,                     /* 0x0347 (00839) */
NULL,                     /* 0x0348 (00840) */
NULL,                     /* 0x0349 (00841) */
NULL,                     /* 0x034a (00842) */
NULL,                     /* 0x034b (00843) */
NULL,                     /* 0x034c (00844) */
NULL,                     /* 0x034d (00845) */
NULL,                     /* 0x034e (00846) */
NULL,                     /* 0x034f (00847) */
NULL,                     /* 0x0350 (00848) */
NULL,                     /* 0x0351 (00849) */
NULL,                     /* 0x0352 (00850) */
NULL,                     /* 0x0353 (00851) */
NULL,                     /* 0x0354 (00852) */
NULL,                     /* 0x0355 (00853) */
NULL,                     /* 0x0356 (00854) */
NULL,                     /* 0x0357 (00855) */
NULL,                     /* 0x0358 (00856) */
NULL,                     /* 0x0359 (00857) */
NULL,                     /* 0x035a (00858) */
NULL,                     /* 0x035b (00859) */
NULL,                     /* 0x035c (00860) */
NULL,                     /* 0x035d (00861) */
NULL,                     /* 0x035e (00862) */
NULL,                     /* 0x035f (00863) */
NULL,                     /* 0x0360 (00864) */
NULL,                     /* 0x0361 (00865) */
NULL,                     /* 0x0362 (00866) */
NULL,                     /* 0x0363 (00867) */
NULL,                     /* 0x0364 (00868) */
NULL,                     /* 0x0365 (00869) */
NULL,                     /* 0x0366 (00870) */
NULL,                     /* 0x0367 (00871) */
NULL,                     /* 0x0368 (00872) */
NULL,                     /* 0x0369 (00873) */
NULL,                     /* 0x036a (00874) */
NULL,                     /* 0x036b (00875) */
NULL,                     /* 0x036c (00876) */
NULL,                     /* 0x036d (00877) */
NULL,                     /* 0x036e (00878) */
NULL,                     /* 0x036f (00879) */
NULL,                     /* 0x0370 (00880) */
NULL,                     /* 0x0371 (00881) */
NULL,                     /* 0x0372 (00882) */
NULL,                     /* 0x0373 (00883) */
NULL,                     /* 0x0374 (00884) */
NULL,                     /* 0x0375 (00885) */
NULL,                     /* 0x0376 (00886) */
NULL,                     /* 0x0377 (00887) */
NULL,                     /* 0x0378 (00888) */
NULL,                     /* 0x0379 (00889) */
NULL,                     /* 0x037a (00890) */
NULL,                     /* 0x037b (00891) */
NULL,                     /* 0x037c (00892) */
NULL,                     /* 0x037d (00893) */
NULL,                     /* 0x037e (00894) */
NULL,                     /* 0x037f (00895) */
NULL,                     /* 0x0380 (00896) */
NULL,                     /* 0x0381 (00897) */
NULL,                     /* 0x0382 (00898) */
NULL,                     /* 0x0383 (00899) */
NULL,                     /* 0x0384 (00900) */
NULL,                     /* 0x0385 (00901) */
NULL,                     /* 0x0386 (00902) */
NULL,                     /* 0x0387 (00903) */
NULL,                     /* 0x0388 (00904) */
NULL,                     /* 0x0389 (00905) */
NULL,                     /* 0x038a (00906) */
NULL,                     /* 0x038b (00907) */
NULL,                     /* 0x038c (00908) */
NULL,                     /* 0x038d (00909) */
NULL,                     /* 0x038e (00910) */
NULL,                     /* 0x038f (00911) */
NULL,                     /* 0x0390 (00912) */
NULL,                     /* 0x0391 (00913) */
NULL,                     /* 0x0392 (00914) */
"$\\Gamma$",              /* 0x0393 (00915) */
"$\\Delta$",              /* 0x0394 (00916) */
NULL,                     /* 0x0395 (00917) */
NULL,                     /* 0x0396 (00918) */
NULL,                     /* 0x0397 (00919) */
"$\\Theta$",              /* 0x0398 (00920) */
NULL,                     /* 0x0399 (00921) */
NULL,                     /* 0x039a (00922) */
"$\\Lambda$",             /* 0x039b (00923) */
NULL,                     /* 0x039c (00924) */
NULL,                     /* 0x039d (00925) */
"$\\Xi$",                 /* 0x039e (00926) */
NULL,                     /* 0x039f (00927) */
"$\\Pi$",                 /* 0x03a0 (00928) */
NULL,                     /* 0x03a1 (00929) */
NULL,                     /* 0x03a2 (00930) */
"$\\Sigma$",              /* 0x03a3 (00931) */
NULL,                     /* 0x03a4 (00932) */
"$\\Upsilon$",            /* 0x03a5 (00933) */
"$\\Phi$",                /* 0x03a6 (00934) */
NULL,                     /* 0x03a7 (00935) */
"$\\Psi$",                /* 0x03a8 (00936) */
"$\\Omega$",              /* 0x03a9 (00937) */
NULL,                     /* 0x03aa (00938) */
NULL,                     /* 0x03ab (00939) */
NULL,                     /* 0x03ac (00940) */
NULL,                     /* 0x03ad (00941) */
NULL,                     /* 0x03ae (00942) */
NULL,                     /* 0x03af (00943) */
NULL,                     /* 0x03b0 (00944) */
"$\\alpha$",              /* 0x03b1 (00945) */
"$\\beta$",               /* 0x03b2 (00946) */
"$\\gamma$",              /* 0x03b3 (00947) */
"$\\delta$",              /* 0x03b4 (00948) */
"$\\epsilon$",            /* 0x03b5 (00949) */
"$\\zeta$",               /* 0x03b6 (00950) */
"$\\eta$",                /* 0x03b7 (00951) */
"$\\theta$",              /* 0x03b8 (00952) */
"$\\iota$",               /* 0x03b9 (00953) */
"$\\kappa$",              /* 0x03ba (00954) */
"$\\lambda$",             /* 0x03bb (00955) */
"$\\mu$",                 /* 0x03bc (00956) */
"$\\nu$",                 /* 0x03bd (00957) */
"$\\xi$",                 /* 0x03be (00958) */
"o",                      /* 0x03bf (00959) */
"$\\pi$",                 /* 0x03c0 (00960) */
"$\\rho$",                /* 0x03c1 (00961) */
"$\\varsigma$",           /* 0x03c2 (00962) */
"$\\sigma$",              /* 0x03c3 (00963) */
"$\\tau$",                /* 0x03c4 (00964) */
"$\\upsilon$",            /* 0x03c5 (00965) */
"$\\phi$",                /* 0x03c6 (00966) */
"$\\chi$",                /* 0x03c7 (00967) */
"$\\psi$",                /* 0x03c8 (00968) */
"$\\omega$",              /* 0x03c9 (00969) */
NULL,                     /* 0x03ca (00970) */
NULL,                     /* 0x03cb (00971) */
NULL,                     /* 0x03cc (00972) */
NULL,                     /* 0x03cd (00973) */
NULL,                     /* 0x03ce (00974) */
NULL,                     /* 0x03cf (00975) */
NULL,                     /* 0x03d0 (00976) */
NULL,                     /* 0x03d1 (00977) */
NULL,                     /* 0x03d2 (00978) */
NULL,                     /* 0x03d3 (00979) */
NULL,                     /* 0x03d4 (00980) */
NULL,                     /* 0x03d5 (00981) */
NULL,                     /* 0x03d6 (00982) */
NULL,                     /* 0x03d7 (00983) */
NULL,                     /* 0x03d8 (00984) */
NULL,                     /* 0x03d9 (00985) */
NULL,                     /* 0x03da (00986) */
NULL,                     /* 0x03db (00987) */
NULL,                     /* 0x03dc (00988) */
NULL,                     /* 0x03dd (00989) */
NULL,                     /* 0x03de (00990) */
NULL,                     /* 0x03df (00991) */
NULL,                     /* 0x03e0 (00992) */
NULL,                     /* 0x03e1 (00993) */
NULL,                     /* 0x03e2 (00994) */
NULL,                     /* 0x03e3 (00995) */
NULL,                     /* 0x03e4 (00996) */
NULL,                     /* 0x03e5 (00997) */
NULL,                     /* 0x03e6 (00998) */
NULL,                     /* 0x03e7 (00999) */
NULL,                     /* 0x03e8 (01000) */
NULL,                     /* 0x03e9 (01001) */
NULL,                     /* 0x03ea (01002) */
NULL,                     /* 0x03eb (01003) */
NULL,                     /* 0x03ec (01004) */
NULL,                     /* 0x03ed (01005) */
NULL,                     /* 0x03ee (01006) */
NULL,                     /* 0x03ef (01007) */
NULL,                     /* 0x03f0 (01008) */
NULL,                     /* 0x03f1 (01009) */
NULL,                     /* 0x03f2 (01010) */
NULL,                     /* 0x03f3 (01011) */
NULL,                     /* 0x03f4 (01012) */
NULL,                     /* 0x03f5 (01013) */
NULL,                     /* 0x03f6 (01014) */
NULL,                     /* 0x03f7 (01015) */
NULL,                     /* 0x03f8 (01016) */
NULL,                     /* 0x03f9 (01017) */
NULL,                     /* 0x03fa (01018) */
NULL,                     /* 0x03fb (01019) */
NULL,                     /* 0x03fc (01020) */
NULL,                     /* 0x03fd (01021) */
NULL,                     /* 0x03fe (01022) */
NULL,                     /* 0x03ff (01023) */
NULL,                     /* 0x0400 (01024) */
NULL,                     /* 0x0401 (01025) */
NULL,                     /* 0x0402 (01026) */
NULL,                     /* 0x0403 (01027) */
NULL,                     /* 0x0404 (01028) */
NULL,                     /* 0x0405 (01029) */
NULL,                     /* 0x0406 (01030) */
NULL,                     /* 0x0407 (01031) */
NULL,                     /* 0x0408 (01032) */
NULL,                     /* 0x0409 (01033) */
NULL,                     /* 0x040a (01034) */
NULL,                     /* 0x040b (01035) */
NULL,                     /* 0x040c (01036) */
NULL,                     /* 0x040d (01037) */
NULL,                     /* 0x040e (01038) */
NULL,                     /* 0x040f (01039) */
NULL,                     /* 0x0410 (01040) */
NULL,                     /* 0x0411 (01041) */
NULL,                     /* 0x0412 (01042) */
NULL,                     /* 0x0413 (01043) */
NULL,                     /* 0x0414 (01044) */
NULL,                     /* 0x0415 (01045) */
NULL,                     /* 0x0416 (01046) */
NULL,                     /* 0x0417 (01047) */
NULL,                     /* 0x0418 (01048) */
NULL,                     /* 0x0419 (01049) */
NULL,                     /* 0x041a (01050) */
NULL,                     /* 0x041b (01051) */
NULL,                     /* 0x041c (01052) */
NULL,                     /* 0x041d (01053) */
NULL,                     /* 0x041e (01054) */
NULL,                     /* 0x041f (01055) */
NULL,                     /* 0x0420 (01056) */
NULL,                     /* 0x0421 (01057) */
NULL,                     /* 0x0422 (01058) */
NULL,                     /* 0x0423 (01059) */
NULL,                     /* 0x0424 (01060) */
NULL,                     /* 0x0425 (01061) */
NULL,                     /* 0x0426 (01062) */
NULL,                     /* 0x0427 (01063) */
NULL,                     /* 0x0428 (01064) */
NULL,                     /* 0x0429 (01065) */
NULL,                     /* 0x042a (01066) */
NULL,                     /* 0x042b (01067) */
NULL,                     /* 0x042c (01068) */
NULL,                     /* 0x042d (01069) */
NULL,                     /* 0x042e (01070) */
NULL,                     /* 0x042f (01071) */
NULL,                     /* 0x0430 (01072) */
NULL,                     /* 0x0431 (01073) */
NULL,                     /* 0x0432 (01074) */
NULL,                     /* 0x0433 (01075) */
NULL,                     /* 0x0434 (01076) */
NULL,                     /* 0x0435 (01077) */
NULL,                     /* 0x0436 (01078) */
NULL,                     /* 0x0437 (01079) */
NULL,                     /* 0x0438 (01080) */
NULL,                     /* 0x0439 (01081) */
NULL,                     /* 0x043a (01082) */
NULL,                     /* 0x043b (01083) */
NULL,                     /* 0x043c (01084) */
NULL,                     /* 0x043d (01085) */
NULL,                     /* 0x043e (01086) */
NULL,                     /* 0x043f (01087) */
NULL,                     /* 0x0440 (01088) */
NULL,                     /* 0x0441 (01089) */
NULL,                     /* 0x0442 (01090) */
NULL,                     /* 0x0443 (01091) */
NULL,                     /* 0x0444 (01092) */
NULL,                     /* 0x0445 (01093) */
NULL,                     /* 0x0446 (01094) */
NULL,                     /* 0x0447 (01095) */
NULL,                     /* 0x0448 (01096) */
NULL,                     /* 0x0449 (01097) */
NULL,                     /* 0x044a (01098) */
NULL,                     /* 0x044b (01099) */
NULL,                     /* 0x044c (01100) */
NULL,                     /* 0x044d (01101) */
NULL,                     /* 0x044e (01102) */
NULL,                     /* 0x044f (01103) */
NULL,                     /* 0x0450 (01104) */
NULL,                     /* 0x0451 (01105) */
NULL,                     /* 0x0452 (01106) */
NULL,                     /* 0x0453 (01107) */
NULL,                     /* 0x0454 (01108) */
NULL,                     /* 0x0455 (01109) */
NULL,                     /* 0x0456 (01110) */
NULL,                     /* 0x0457 (01111) */
NULL,                     /* 0x0458 (01112) */
NULL,                     /* 0x0459 (01113) */
NULL,                     /* 0x045a (01114) */
NULL,                     /* 0x045b (01115) */
NULL,                     /* 0x045c (01116) */
NULL,                     /* 0x045d (01117) */
NULL,                     /* 0x045e (01118) */
NULL,                     /* 0x045f (01119) */
NULL,                     /* 0x0460 (01120) */
NULL,                     /* 0x0461 (01121) */
NULL,                     /* 0x0462 (01122) */
NULL,                     /* 0x0463 (01123) */
NULL,                     /* 0x0464 (01124) */
NULL,                     /* 0x0465 (01125) */
NULL,                     /* 0x0466 (01126) */
NULL,                     /* 0x0467 (01127) */
NULL,                     /* 0x0468 (01128) */
NULL,                     /* 0x0469 (01129) */
NULL,                     /* 0x046a (01130) */
NULL,                     /* 0x046b (01131) */
NULL,                     /* 0x046c (01132) */
NULL,                     /* 0x046d (01133) */
NULL,                     /* 0x046e (01134) */
NULL,                     /* 0x046f (01135) */
NULL,                     /* 0x0470 (01136) */
NULL,                     /* 0x0471 (01137) */
NULL,                     /* 0x0472 (01138) */
NULL,                     /* 0x0473 (01139) */
NULL,                     /* 0x0474 (01140) */
NULL,                     /* 0x0475 (01141) */
NULL,                     /* 0x0476 (01142) */
NULL,                     /* 0x0477 (01143) */
NULL,                     /* 0x0478 (01144) */
NULL,                     /* 0x0479 (01145) */
NULL,                     /* 0x047a (01146) */
NULL,                     /* 0x047b (01147) */
NULL,                     /* 0x047c (01148) */
NULL,                     /* 0x047d (01149) */
NULL,                     /* 0x047e (01150) */
NULL,                     /* 0x047f (01151) */
NULL,                     /* 0x0480 (01152) */
NULL,                     /* 0x0481 (01153) */
NULL,                     /* 0x0482 (01154) */
NULL,                     /* 0x0483 (01155) */
NULL,                     /* 0x0484 (01156) */
NULL,                     /* 0x0485 (01157) */
NULL,                     /* 0x0486 (01158) */
NULL,                     /* 0x0487 (01159) */
NULL,                     /* 0x0488 (01160) */
NULL,                     /* 0x0489 (01161) */
NULL,                     /* 0x048a (01162) */
NULL,                     /* 0x048b (01163) */
NULL,                     /* 0x048c (01164) */
NULL,                     /* 0x048d (01165) */
NULL,                     /* 0x048e (01166) */
NULL,                     /* 0x048f (01167) */
NULL,                     /* 0x0490 (01168) */
NULL,                     /* 0x0491 (01169) */
NULL,                     /* 0x0492 (01170) */
NULL,                     /* 0x0493 (01171) */
NULL,                     /* 0x0494 (01172) */
NULL,                     /* 0x0495 (01173) */
NULL,                     /* 0x0496 (01174) */
NULL,                     /* 0x0497 (01175) */
NULL,                     /* 0x0498 (01176) */
NULL,                     /* 0x0499 (01177) */
NULL,                     /* 0x049a (01178) */
NULL,                     /* 0x049b (01179) */
NULL,                     /* 0x049c (01180) */
NULL,                     /* 0x049d (01181) */
NULL,                     /* 0x049e (01182) */
NULL,                     /* 0x049f (01183) */
NULL,                     /* 0x04a0 (01184) */
NULL,                     /* 0x04a1 (01185) */
NULL,                     /* 0x04a2 (01186) */
NULL,                     /* 0x04a3 (01187) */
NULL,                     /* 0x04a4 (01188) */
NULL,                     /* 0x04a5 (01189) */
NULL,                     /* 0x04a6 (01190) */
NULL,                     /* 0x04a7 (01191) */
NULL,                     /* 0x04a8 (01192) */
NULL,                     /* 0x04a9 (01193) */
NULL,                     /* 0x04aa (01194) */
NULL,                     /* 0x04ab (01195) */
NULL,                     /* 0x04ac (01196) */
NULL,                     /* 0x04ad (01197) */
NULL,                     /* 0x04ae (01198) */
NULL,                     /* 0x04af (01199) */
NULL,                     /* 0x04b0 (01200) */
NULL,                     /* 0x04b1 (01201) */
NULL,                     /* 0x04b2 (01202) */
NULL,                     /* 0x04b3 (01203) */
NULL,                     /* 0x04b4 (01204) */
NULL,                     /* 0x04b5 (01205) */
NULL,                     /* 0x04b6 (01206) */
NULL,                     /* 0x04b7 (01207) */
NULL,                     /* 0x04b8 (01208) */
NULL,                     /* 0x04b9 (01209) */
NULL,                     /* 0x04ba (01210) */
NULL,                     /* 0x04bb (01211) */
NULL,                     /* 0x04bc (01212) */
NULL,                     /* 0x04bd (01213) */
NULL,                     /* 0x04be (01214) */
NULL,                     /* 0x04bf (01215) */
NULL,                     /* 0x04c0 (01216) */
NULL,                     /* 0x04c1 (01217) */
NULL,                     /* 0x04c2 (01218) */
NULL,                     /* 0x04c3 (01219) */
NULL,                     /* 0x04c4 (01220) */
NULL,                     /* 0x04c5 (01221) */
NULL,                     /* 0x04c6 (01222) */
NULL,                     /* 0x04c7 (01223) */
NULL,                     /* 0x04c8 (01224) */
NULL,                     /* 0x04c9 (01225) */
NULL,                     /* 0x04ca (01226) */
NULL,                     /* 0x04cb (01227) */
NULL,                     /* 0x04cc (01228) */
NULL,                     /* 0x04cd (01229) */
NULL,                     /* 0x04ce (01230) */
NULL,                     /* 0x04cf (01231) */
NULL,                     /* 0x04d0 (01232) */
NULL,                     /* 0x04d1 (01233) */
NULL,                     /* 0x04d2 (01234) */
NULL,                     /* 0x04d3 (01235) */
NULL,                     /* 0x04d4 (01236) */
NULL,                     /* 0x04d5 (01237) */
NULL,                     /* 0x04d6 (01238) */
NULL,                     /* 0x04d7 (01239) */
NULL,                     /* 0x04d8 (01240) */
NULL,                     /* 0x04d9 (01241) */
NULL,                     /* 0x04da (01242) */
NULL,                     /* 0x04db (01243) */
NULL,                     /* 0x04dc (01244) */
NULL,                     /* 0x04dd (01245) */
NULL,                     /* 0x04de (01246) */
NULL,                     /* 0x04df (01247) */
NULL,                     /* 0x04e0 (01248) */
NULL,                     /* 0x04e1 (01249) */
NULL,                     /* 0x04e2 (01250) */
NULL,                     /* 0x04e3 (01251) */
NULL,                     /* 0x04e4 (01252) */
NULL,                     /* 0x04e5 (01253) */
NULL,                     /* 0x04e6 (01254) */
NULL,                     /* 0x04e7 (01255) */
NULL,                     /* 0x04e8 (01256) */
NULL,                     /* 0x04e9 (01257) */
NULL,                     /* 0x04ea (01258) */
NULL,                     /* 0x04eb (01259) */
NULL,                     /* 0x04ec (01260) */
NULL,                     /* 0x04ed (01261) */
NULL,                     /* 0x04ee (01262) */
NULL,                     /* 0x04ef (01263) */
NULL,                     /* 0x04f0 (01264) */
NULL,                     /* 0x04f1 (01265) */
NULL,                     /* 0x04f2 (01266) */
NULL,                     /* 0x04f3 (01267) */
NULL,                     /* 0x04f4 (01268) */
NULL,                     /* 0x04f5 (01269) */
NULL,                     /* 0x04f6 (01270) */
NULL,                     /* 0x04f7 (01271) */
NULL,                     /* 0x04f8 (01272) */
NULL,                     /* 0x04f9 (01273) */
NULL,                     /* 0x04fa (01274) */
NULL,                     /* 0x04fb (01275) */
NULL,                     /* 0x04fc (01276) */
NULL,                     /* 0x04fd (01277) */
NULL,                     /* 0x04fe (01278) */
NULL,                     /* 0x04ff (01279) */
NULL,                     /* 0x0500 (01280) */
NULL,                     /* 0x0501 (01281) */
NULL,                     /* 0x0502 (01282) */
NULL,                     /* 0x0503 (01283) */
NULL,                     /* 0x0504 (01284) */
NULL,                     /* 0x0505 (01285) */
NULL,                     /* 0x0506 (01286) */
NULL,                     /* 0x0507 (01287) */
NULL,                     /* 0x0508 (01288) */
NULL,                     /* 0x0509 (01289) */
NULL,                     /* 0x050a (01290) */
NULL,                     /* 0x050b (01291) */
NULL,                     /* 0x050c (01292) */
NULL,                     /* 0x050d (01293) */
NULL,                     /* 0x050e (01294) */
NULL,                     /* 0x050f (01295) */
NULL,                     /* 0x0510 (01296) */
NULL,                     /* 0x0511 (01297) */
NULL,                     /* 0x0512 (01298) */
NULL,                     /* 0x0513 (01299) */
NULL,                     /* 0x0514 (01300) */
NULL,                     /* 0x0515 (01301) */
NULL,                     /* 0x0516 (01302) */
NULL,                     /* 0x0517 (01303) */
NULL,                     /* 0x0518 (01304) */
NULL,                     /* 0x0519 (01305) */
NULL,                     /* 0x051a (01306) */
NULL,                     /* 0x051b (01307) */
NULL,                     /* 0x051c (01308) */
NULL,                     /* 0x051d (01309) */
NULL,                     /* 0x051e (01310) */
NULL,                     /* 0x051f (01311) */
NULL,                     /* 0x0520 (01312) */
NULL,                     /* 0x0521 (01313) */
NULL,                     /* 0x0522 (01314) */
NULL,                     /* 0x0523 (01315) */
NULL,                     /* 0x0524 (01316) */
NULL,                     /* 0x0525 (01317) */
NULL,                     /* 0x0526 (01318) */
NULL,                     /* 0x0527 (01319) */
NULL,                     /* 0x0528 (01320) */
NULL,                     /* 0x0529 (01321) */
NULL,                     /* 0x052a (01322) */
NULL,                     /* 0x052b (01323) */
NULL,                     /* 0x052c (01324) */
NULL,                     /* 0x052d (01325) */
NULL,                     /* 0x052e (01326) */
NULL,                     /* 0x052f (01327) */
NULL,                     /* 0x0530 (01328) */
NULL,                     /* 0x0531 (01329) */
NULL,                     /* 0x0532 (01330) */
NULL,                     /* 0x0533 (01331) */
NULL,                     /* 0x0534 (01332) */
NULL,                     /* 0x0535 (01333) */
NULL,                     /* 0x0536 (01334) */
NULL,                     /* 0x0537 (01335) */
NULL,                     /* 0x0538 (01336) */
NULL,                     /* 0x0539 (01337) */
NULL,                     /* 0x053a (01338) */
NULL,                     /* 0x053b (01339) */
NULL,                     /* 0x053c (01340) */
NULL,                     /* 0x053d (01341) */
NULL,                     /* 0x053e (01342) */
NULL,                     /* 0x053f (01343) */
NULL,                     /* 0x0540 (01344) */
NULL,                     /* 0x0541 (01345) */
NULL,                     /* 0x0542 (01346) */
NULL,                     /* 0x0543 (01347) */
NULL,                     /* 0x0544 (01348) */
NULL,                     /* 0x0545 (01349) */
NULL,                     /* 0x0546 (01350) */
NULL,                     /* 0x0547 (01351) */
NULL,                     /* 0x0548 (01352) */
NULL,                     /* 0x0549 (01353) */
NULL,                     /* 0x054a (01354) */
NULL,                     /* 0x054b (01355) */
NULL,                     /* 0x054c (01356) */
NULL,                     /* 0x054d (01357) */
NULL,                     /* 0x054e (01358) */
NULL,                     /* 0x054f (01359) */
NULL,                     /* 0x0550 (01360) */
NULL,                     /* 0x0551 (01361) */
NULL,                     /* 0x0552 (01362) */
NULL,                     /* 0x0553 (01363) */
NULL,                     /* 0x0554 (01364) */
NULL,                     /* 0x0555 (01365) */
NULL,                     /* 0x0556 (01366) */
NULL,                     /* 0x0557 (01367) */
NULL,                     /* 0x0558 (01368) */
NULL,                     /* 0x0559 (01369) */
NULL,                     /* 0x055a (01370) */
NULL,                     /* 0x055b (01371) */
NULL,                     /* 0x055c (01372) */
NULL,                     /* 0x055d (01373) */
NULL,                     /* 0x055e (01374) */
NULL,                     /* 0x055f (01375) */
NULL,                     /* 0x0560 (01376) */
NULL,                     /* 0x0561 (01377) */
NULL,                     /* 0x0562 (01378) */
NULL,                     /* 0x0563 (01379) */
NULL,                     /* 0x0564 (01380) */
NULL,                     /* 0x0565 (01381) */
NULL,                     /* 0x0566 (01382) */
NULL,                     /* 0x0567 (01383) */
NULL,                     /* 0x0568 (01384) */
NULL,                     /* 0x0569 (01385) */
NULL,                     /* 0x056a (01386) */
NULL,                     /* 0x056b (01387) */
NULL,                     /* 0x056c (01388) */
NULL,                     /* 0x056d (01389) */
NULL,                     /* 0x056e (01390) */
NULL,                     /* 0x056f (01391) */
NULL,                     /* 0x0570 (01392) */
NULL,                     /* 0x0571 (01393) */
NULL,                     /* 0x0572 (01394) */
NULL,                     /* 0x0573 (01395) */
NULL,                     /* 0x0574 (01396) */
NULL,                     /* 0x0575 (01397) */
NULL,                     /* 0x0576 (01398) */
NULL,                     /* 0x0577 (01399) */
NULL,                     /* 0x0578 (01400) */
NULL,                     /* 0x0579 (01401) */
NULL,                     /* 0x057a (01402) */
NULL,                     /* 0x057b (01403) */
NULL,                     /* 0x057c (01404) */
NULL,                     /* 0x057d (01405) */
NULL,                     /* 0x057e (01406) */
NULL,                     /* 0x057f (01407) */
NULL,                     /* 0x0580 (01408) */
NULL,                     /* 0x0581 (01409) */
NULL,                     /* 0x0582 (01410) */
NULL,                     /* 0x0583 (01411) */
NULL,                     /* 0x0584 (01412) */
NULL,                     /* 0x0585 (01413) */
NULL,                     /* 0x0586 (01414) */
NULL,                     /* 0x0587 (01415) */
NULL,                     /* 0x0588 (01416) */
NULL,                     /* 0x0589 (01417) */
NULL,                     /* 0x058a (01418) */
NULL,                     /* 0x058b (01419) */
NULL,                     /* 0x058c (01420) */
NULL,                     /* 0x058d (01421) */
NULL,                     /* 0x058e (01422) */
NULL,                     /* 0x058f (01423) */
NULL,                     /* 0x0590 (01424) */
NULL,                     /* 0x0591 (01425) */
NULL,                     /* 0x0592 (01426) */
NULL,                     /* 0x0593 (01427) */
NULL,                     /* 0x0594 (01428) */
NULL,                     /* 0x0595 (01429) */
NULL,                     /* 0x0596 (01430) */
NULL,                     /* 0x0597 (01431) */
NULL,                     /* 0x0598 (01432) */
NULL,                     /* 0x0599 (01433) */
NULL,                     /* 0x059a (01434) */
NULL,                     /* 0x059b (01435) */
NULL,                     /* 0x059c (01436) */
NULL,                     /* 0x059d (01437) */
NULL,                     /* 0x059e (01438) */
NULL,                     /* 0x059f (01439) */
NULL,                     /* 0x05a0 (01440) */
NULL,                     /* 0x05a1 (01441) */
NULL,                     /* 0x05a2 (01442) */
NULL,                     /* 0x05a3 (01443) */
NULL,                     /* 0x05a4 (01444) */
NULL,                     /* 0x05a5 (01445) */
NULL,                     /* 0x05a6 (01446) */
NULL,                     /* 0x05a7 (01447) */
NULL,                     /* 0x05a8 (01448) */
NULL,                     /* 0x05a9 (01449) */
NULL,                     /* 0x05aa (01450) */
NULL,                     /* 0x05ab (01451) */
NULL,                     /* 0x05ac (01452) */
NULL,                     /* 0x05ad (01453) */
NULL,                     /* 0x05ae (01454) */
NULL,                     /* 0x05af (01455) */
NULL,                     /* 0x05b0 (01456) */
NULL,                     /* 0x05b1 (01457) */
NULL,                     /* 0x05b2 (01458) */
NULL,                     /* 0x05b3 (01459) */
NULL,                     /* 0x05b4 (01460) */
NULL,                     /* 0x05b5 (01461) */
NULL,                     /* 0x05b6 (01462) */
NULL,                     /* 0x05b7 (01463) */
NULL,                     /* 0x05b8 (01464) */
NULL,                     /* 0x05b9 (01465) */
NULL,                     /* 0x05ba (01466) */
NULL,                     /* 0x05bb (01467) */
NULL,                     /* 0x05bc (01468) */
NULL,                     /* 0x05bd (01469) */
NULL,                     /* 0x05be (01470) */
NULL,                     /* 0x05bf (01471) */
NULL,                     /* 0x05c0 (01472) */
NULL,                     /* 0x05c1 (01473) */
NULL,                     /* 0x05c2 (01474) */
NULL,                     /* 0x05c3 (01475) */
NULL,                     /* 0x05c4 (01476) */
NULL,                     /* 0x05c5 (01477) */
NULL,                     /* 0x05c6 (01478) */
NULL,                     /* 0x05c7 (01479) */
NULL,                     /* 0x05c8 (01480) */
NULL,                     /* 0x05c9 (01481) */
NULL,                     /* 0x05ca (01482) */
NULL,                     /* 0x05cb (01483) */
NULL,                     /* 0x05cc (01484) */
NULL,                     /* 0x05cd (01485) */
NULL,                     /* 0x05ce (01486) */
NULL,                     /* 0x05cf (01487) */
NULL,                     /* 0x05d0 (01488) */
NULL,                     /* 0x05d1 (01489) */
NULL,                     /* 0x05d2 (01490) */
NULL,                     /* 0x05d3 (01491) */
NULL,                     /* 0x05d4 (01492) */
NULL,                     /* 0x05d5 (01493) */
NULL,                     /* 0x05d6 (01494) */
NULL,                     /* 0x05d7 (01495) */
NULL,                     /* 0x05d8 (01496) */
NULL,                     /* 0x05d9 (01497) */
NULL,                     /* 0x05da (01498) */
NULL,                     /* 0x05db (01499) */
NULL,                     /* 0x05dc (01500) */
NULL,                     /* 0x05dd (01501) */
NULL,                     /* 0x05de (01502) */
NULL,                     /* 0x05df (01503) */
NULL,                     /* 0x05e0 (01504) */
NULL,                     /* 0x05e1 (01505) */
NULL,                     /* 0x05e2 (01506) */
NULL,                     /* 0x05e3 (01507) */
NULL,                     /* 0x05e4 (01508) */
NULL,                     /* 0x05e5 (01509) */
NULL,                     /* 0x05e6 (01510) */
NULL,                     /* 0x05e7 (01511) */
NULL,                     /* 0x05e8 (01512) */
NULL,                     /* 0x05e9 (01513) */
NULL,                     /* 0x05ea (01514) */
NULL,                     /* 0x05eb (01515) */
NULL,                     /* 0x05ec (01516) */
NULL,                     /* 0x05ed (01517) */
NULL,                     /* 0x05ee (01518) */
NULL,                     /* 0x05ef (01519) */
NULL,                     /* 0x05f0 (01520) */
NULL,                     /* 0x05f1 (01521) */
NULL,                     /* 0x05f2 (01522) */
NULL,                     /* 0x05f3 (01523) */
NULL,                     /* 0x05f4 (01524) */
NULL,                     /* 0x05f5 (01525) */
NULL,                     /* 0x05f6 (01526) */
NULL,                     /* 0x05f7 (01527) */
NULL,                     /* 0x05f8 (01528) */
NULL,                     /* 0x05f9 (01529) */
NULL,                     /* 0x05fa (01530) */
NULL,                     /* 0x05fb (01531) */
NULL,                     /* 0x05fc (01532) */
NULL,                     /* 0x05fd (01533) */
NULL,                     /* 0x05fe (01534) */
NULL                      /* 0x05ff (01535) */
};

/*
  U+1E00 --- U+1EFF
*/
char *latin2tex_b[] = {
NULL,                     /* 0x1e00 (07680) */
NULL,                     /* 0x1e01 (07681) */
"\\.{B}",                 /* 0x1e02 (07682) */
"\\.{b}",                 /* 0x1e03 (07683) */
"\\d{B}",                 /* 0x1e04 (07684) */
"\\d{b}",                 /* 0x1e05 (07685) */
"\\b{B}",                 /* 0x1e06 (07686) */
"\\b{b}",                 /* 0x1e07 (07687) */
NULL,                     /* 0x1e08 (07688) */
NULL,                     /* 0x1e09 (07689) */
"\\.{D}",                 /* 0x1e0a (07690) */
"\\.{d}",                 /* 0x1e0b (07691) */
"\\d{D}",                 /* 0x1e0c (07692) */
"\\d{d}",                 /* 0x1e0d (07693) */
"\\b{D}",                 /* 0x1e0e (07694) */
"\\b{d}",                 /* 0x1e0f (07695) */
"\\c{D}",                 /* 0x1e10 (07696) */
"\\c{d}",                 /* 0x1e11 (07697) */
NULL,                     /* 0x1e12 (07698) */
NULL,                     /* 0x1e13 (07699) */
NULL,                     /* 0x1e14 (07700) */
NULL,                     /* 0x1e15 (07701) */
NULL,                     /* 0x1e16 (07702) */
NULL,                     /* 0x1e17 (07703) */
NULL,                     /* 0x1e18 (07704) */
NULL,                     /* 0x1e19 (07705) */
NULL,                     /* 0x1e1a (07706) */
NULL,                     /* 0x1e1b (07707) */
NULL,                     /* 0x1e1c (07708) */
NULL,                     /* 0x1e1d (07709) */
"\\.{F}",                 /* 0x1e1e (07710) */
"\\.{f}",                 /* 0x1e1f (07711) */
"\\={G}",                 /* 0x1e20 (07712) */
"\\={g}",                 /* 0x1e21 (07713) */
"\\.{H}",                 /* 0x1e22 (07714) */
"\\.{h}",                 /* 0x1e23 (07715) */
"\\d{H}",                 /* 0x1e24 (07716) */
"\\d{h}",                 /* 0x1e25 (07717) */
"\\\"{H}",                /* 0x1e26 (07718) */
"\\\"{h}",                /* 0x1e27 (07719) */
"\\c{H}",                 /* 0x1e28 (07720) */
"\\c{h}",                 /* 0x1e29 (07721) */
NULL,                     /* 0x1e2a (07722) */
NULL,                     /* 0x1e2b (07723) */
NULL,                     /* 0x1e2c (07724) */
NULL,                     /* 0x1e2d (07725) */
NULL,                     /* 0x1e2e (07726) */
NULL,                     /* 0x1e2f (07727) */
"\\'{K}",                 /* 0x1e30 (07728) */
"\\'{k}",                 /* 0x1e31 (07729) */
"\\d{K}",                 /* 0x1e32 (07730) */
"\\d{k}",                 /* 0x1e33 (07731) */
"\\b{K}",                 /* 0x1e34 (07732) */
"\\b{k}",                 /* 0x1e35 (07733) */
"\\d{L}",                 /* 0x1e36 (07734) */
"\\d{l}",                 /* 0x1e37 (07735) */
NULL,                     /* 0x1e38 (07736) */
NULL,                     /* 0x1e39 (07737) */
"\\b{L}",                 /* 0x1e3a (07738) */
"\\b{l}",                 /* 0x1e3b (07739) */
NULL,                     /* 0x1e3c (07740) */
NULL,                     /* 0x1e3d (07741) */
"\\'{M}",                 /* 0x1e3e (07742) */
"\\'{m}",                 /* 0x1e3f (07743) */
"\\.{M}",                 /* 0x1e40 (07744) */
"\\.{m}",                 /* 0x1e41 (07745) */
"\\d{M}",                 /* 0x1e42 (07746) */
"\\d{m}",                 /* 0x1e43 (07747) */
"\\.{N}",                 /* 0x1e44 (07748) */
"\\.{n}",                 /* 0x1e45 (07749) */
"\\d{N}",                 /* 0x1e46 (07750) */
"\\d{n}",                 /* 0x1e47 (07751) */
"\\b{N}",                 /* 0x1e48 (07752) */
"\\b{n}",                 /* 0x1e49 (07753) */
NULL,                     /* 0x1e4a (07754) */
NULL,                     /* 0x1e4b (07755) */
NULL,                     /* 0x1e4c (07756) */
NULL,                     /* 0x1e4d (07757) */
NULL,                     /* 0x1e4e (07758) */
NULL,                     /* 0x1e4f (07759) */
NULL,                     /* 0x1e50 (07760) */
NULL,                     /* 0x1e51 (07761) */
NULL,                     /* 0x1e52 (07762) */
NULL,                     /* 0x1e53 (07763) */
"\\'{P}",                 /* 0x1e54 (07764) */
"\\'{p}",                 /* 0x1e55 (07765) */
"\\.{P}",                 /* 0x1e56 (07766) */
"\\.{p}",                 /* 0x1e57 (07767) */
"\\.{R}",                 /* 0x1e58 (07768) */
"\\.{r}",                 /* 0x1e59 (07769) */
"\\d{R}",                 /* 0x1e5a (07770) */
"\\d{r}",                 /* 0x1e5b (07771) */
NULL,                     /* 0x1e5c (07772) */
NULL,                     /* 0x1e5d (07773) */
"\\b{R}",                 /* 0x1e5e (07774) */
"\\b{r}",                 /* 0x1e5f (07775) */
"\\.{S}",                 /* 0x1e60 (07776) */
"\\.{s}",                 /* 0x1e61 (07777) */
"\\d{S}",                 /* 0x1e62 (07778) */
"\\d{s}",                 /* 0x1e63 (07779) */
NULL,                     /* 0x1e64 (07780) */
NULL,                     /* 0x1e65 (07781) */
NULL,                     /* 0x1e66 (07782) */
NULL,                     /* 0x1e67 (07783) */
NULL,                     /* 0x1e68 (07784) */
NULL,                     /* 0x1e69 (07785) */
"\\.{T}",                 /* 0x1e6a (07786) */
"\\.{t}",                 /* 0x1e6b (07787) */
"\\d{T}",                 /* 0x1e6c (07788) */
"\\d{t}",                 /* 0x1e6d (07789) */
"\\b{T}",                 /* 0x1e6e (07790) */
"\\b{t}",                 /* 0x1e6f (07791) */
NULL,                     /* 0x1e70 (07792) */
NULL,                     /* 0x1e71 (07793) */
NULL,                     /* 0x1e72 (07794) */
NULL,                     /* 0x1e73 (07795) */
NULL,                     /* 0x1e74 (07796) */
NULL,                     /* 0x1e75 (07797) */
NULL,                     /* 0x1e76 (07798) */
NULL,                     /* 0x1e77 (07799) */
NULL,                     /* 0x1e78 (07800) */
NULL,                     /* 0x1e79 (07801) */
NULL,                     /* 0x1e7a (07802) */
NULL,                     /* 0x1e7b (07803) */
"\\~{V}",                 /* 0x1e7c (07804) */
"\\~{v}",                 /* 0x1e7d (07805) */
"\\d{V}",                 /* 0x1e7e (07806) */
"\\d{v}",                 /* 0x1e7f (07807) */
"\\`{W}",                 /* 0x1e80 (07808) */
"\\`{w}",                 /* 0x1e81 (07809) */
"\\'{W}",                 /* 0x1e82 (07810) */
"\\'{w}",                 /* 0x1e83 (07811) */
"\\\"{W}",                /* 0x1e84 (07812) */
"\\\"{w}",                /* 0x1e85 (07813) */
"\\.{W}",                 /* 0x1e86 (07814) */
"\\.{w}",                 /* 0x1e87 (07815) */
"\\d{W}",                 /* 0x1e88 (07816) */
"\\d{w}",                 /* 0x1e89 (07817) */
"\\.{X}",                 /* 0x1e8a (07818) */
"\\.{x}",                 /* 0x1e8b (07819) */
"\\\"{X}",                /* 0x1e8c (07820) */
"\\\"{x}",                /* 0x1e8d (07821) */
"\\.{Y}",                 /* 0x1e8e (07822) */
"\\.{y}",                 /* 0x1e8f (07823) */
"\\^{Z}",                 /* 0x1e90 (07824) */
"\\^{z}",                 /* 0x1e91 (07825) */
"\\d{Z}",                 /* 0x1e92 (07826) */
"\\d{z}",                 /* 0x1e93 (07827) */
"\\b{Z}",                 /* 0x1e94 (07828) */
"\\b{z}",                 /* 0x1e95 (07829) */
"\\b{h}",                 /* 0x1e96 (07830) */
"\\\"{t}",                /* 0x1e97 (07831) */
"\\r{w}",                 /* 0x1e98 (07832) */
"\\r{y}",                 /* 0x1e99 (07833) */
NULL,                     /* 0x1e9a (07834) */
NULL,                     /* 0x1e9b (07835) */
NULL,                     /* 0x1e9c (07836) */
NULL,                     /* 0x1e9d (07837) */
NULL,                     /* 0x1e9e (07838) */
NULL,                     /* 0x1e9f (07839) */
"\\d{A}",                 /* 0x1ea0 (07840) */
"\\d{a}",                 /* 0x1ea1 (07841) */
NULL,                     /* 0x1ea2 (07842) */
NULL,                     /* 0x1ea3 (07843) */
NULL,                     /* 0x1ea4 (07844) */
NULL,                     /* 0x1ea5 (07845) */
NULL,                     /* 0x1ea6 (07846) */
NULL,                     /* 0x1ea7 (07847) */
NULL,                     /* 0x1ea8 (07848) */
NULL,                     /* 0x1ea9 (07849) */
NULL,                     /* 0x1eaa (07850) */
NULL,                     /* 0x1eab (07851) */
NULL,                     /* 0x1eac (07852) */
NULL,                     /* 0x1ead (07853) */
NULL,                     /* 0x1eae (07854) */
NULL,                     /* 0x1eaf (07855) */
NULL,                     /* 0x1eb0 (07856) */
NULL,                     /* 0x1eb1 (07857) */
NULL,                     /* 0x1eb2 (07858) */
NULL,                     /* 0x1eb3 (07859) */
NULL,                     /* 0x1eb4 (07860) */
NULL,                     /* 0x1eb5 (07861) */
NULL,                     /* 0x1eb6 (07862) */
NULL,                     /* 0x1eb7 (07863) */
"\\d{E}",                 /* 0x1eb8 (07864) */
"\\d{e}",                 /* 0x1eb9 (07865) */
NULL,                     /* 0x1eba (07866) */
NULL,                     /* 0x1ebb (07867) */
"\\~{E}",                 /* 0x1ebc (07868) */
"\\~{e}",                 /* 0x1ebd (07869) */
NULL,                     /* 0x1ebe (07870) */
NULL,                     /* 0x1ebf (07871) */
NULL,                     /* 0x1ec0 (07872) */
NULL,                     /* 0x1ec1 (07873) */
NULL,                     /* 0x1ec2 (07874) */
NULL,                     /* 0x1ec3 (07875) */
NULL,                     /* 0x1ec4 (07876) */
NULL,                     /* 0x1ec5 (07877) */
NULL,                     /* 0x1ec6 (07878) */
NULL,                     /* 0x1ec7 (07879) */
NULL,                     /* 0x1ec8 (07880) */
NULL,                     /* 0x1ec9 (07881) */
"\\d{I}",                 /* 0x1eca (07882) */
"\\d{i}",                 /* 0x1ecb (07883) */
"\\d{O}",                 /* 0x1ecc (07884) */
"\\d{o}",                 /* 0x1ecd (07885) */
NULL,                     /* 0x1ece (07886) */
NULL,                     /* 0x1ecf (07887) */
NULL,                     /* 0x1ed0 (07888) */
NULL,                     /* 0x1ed1 (07889) */
NULL,                     /* 0x1ed2 (07890) */
NULL,                     /* 0x1ed3 (07891) */
NULL,                     /* 0x1ed4 (07892) */
NULL,                     /* 0x1ed5 (07893) */
NULL,                     /* 0x1ed6 (07894) */
NULL,                     /* 0x1ed7 (07895) */
NULL,                     /* 0x1ed8 (07896) */
NULL,                     /* 0x1ed9 (07897) */
NULL,                     /* 0x1eda (07898) */
NULL,                     /* 0x1edb (07899) */
NULL,                     /* 0x1edc (07900) */
NULL,                     /* 0x1edd (07901) */
NULL,                     /* 0x1ede (07902) */
NULL,                     /* 0x1edf (07903) */
NULL,                     /* 0x1ee0 (07904) */
NULL,                     /* 0x1ee1 (07905) */
NULL,                     /* 0x1ee2 (07906) */
NULL,                     /* 0x1ee3 (07907) */
"\\d{U}",                 /* 0x1ee4 (07908) */
"\\d{u}",                 /* 0x1ee5 (07909) */
NULL,                     /* 0x1ee6 (07910) */
NULL,                     /* 0x1ee7 (07911) */
NULL,                     /* 0x1ee8 (07912) */
NULL,                     /* 0x1ee9 (07913) */
NULL,                     /* 0x1eea (07914) */
NULL,                     /* 0x1eeb (07915) */
NULL,                     /* 0x1eec (07916) */
NULL,                     /* 0x1eed (07917) */
NULL,                     /* 0x1eee (07918) */
NULL,                     /* 0x1eef (07919) */
NULL,                     /* 0x1ef0 (07920) */
NULL,                     /* 0x1ef1 (07921) */
"\\`{Y}",                 /* 0x1ef2 (07922) */
"\\`{y}",                 /* 0x1ef3 (07923) */
"\\d{Y}",                 /* 0x1ef4 (07924) */
"\\d{y}",                 /* 0x1ef5 (07925) */
NULL,                     /* 0x1ef6 (07926) */
NULL,                     /* 0x1ef7 (07927) */
"\\~{Y}",                 /* 0x1ef8 (07928) */
"\\~{y}",                 /* 0x1ef9 (07929) */
NULL,                     /* 0x1efa (07930) */
NULL,                     /* 0x1efb (07931) */
NULL,                     /* 0x1efc (07932) */
NULL,                     /* 0x1efd (07933) */
NULL,                     /* 0x1efe (07934) */
NULL                      /* 0x1eff (07935) */
};

/*
  U+2000 --- U+22FF
*/
char *latin2tex_c[] = { 
NULL,                     /* 0x2000 (08192) */
NULL,                     /* 0x2001 (08193) */
NULL,                     /* 0x2002 (08194) */
NULL,                     /* 0x2003 (08195) */
NULL,                     /* 0x2004 (08196) */
NULL,                     /* 0x2005 (08197) */
NULL,                     /* 0x2006 (08198) */
NULL,                     /* 0x2007 (08199) */
NULL,                     /* 0x2008 (08200) */
NULL,                     /* 0x2009 (08201) */
NULL,                     /* 0x200a (08202) */
NULL,                     /* 0x200b (08203) */
NULL,                     /* 0x200c (08204) */
NULL,                     /* 0x200d (08205) */
NULL,                     /* 0x200e (08206) */
NULL,                     /* 0x200f (08207) */
NULL,                     /* 0x2010 (08208) */
NULL,                     /* 0x2011 (08209) */
NULL,                     /* 0x2012 (08210) */
"--",                     /* 0x2013 (08211) */
NULL,                     /* 0x2014 (08212) */
NULL,                     /* 0x2015 (08213) */
NULL,                     /* 0x2016 (08214) */
NULL,                     /* 0x2017 (08215) */
"`",                      /* 0x2018 (08216) */
"'",                      /* 0x2019 (08217) */
"{\\quotesinglbase}",     /* 0x201a (08218) */
NULL,                     /* 0x201b (08219) */
"``",                     /* 0x201c (08220) */
"''",                     /* 0x201d (08221) */
"{\\quotedblbase}",       /* 0x201e (08222) */
NULL,                     /* 0x201f (08223) */
"{\\dag}",                /* 0x2020 (08224) */
"{\\ddag}",               /* 0x2021 (08225) */
"{\\textbullet}",         /* 0x2022 (08226) */
NULL,                     /* 0x2023 (08227) */
NULL,                     /* 0x2024 (08228) */
NULL,                     /* 0x2025 (08229) */
NULL,                     /* 0x2026 (08230) */
NULL,                     /* 0x2027 (08231) */
NULL,                     /* 0x2028 (08232) */
NULL,                     /* 0x2029 (08233) */
NULL,                     /* 0x202a (08234) */
NULL,                     /* 0x202b (08235) */
NULL,                     /* 0x202c (08236) */
NULL,                     /* 0x202d (08237) */
NULL,                     /* 0x202e (08238) */
"\\,",                    /* 0x202f (08239) */
"{\\textperthousand}",    /* 0x2030 (08240) */
NULL,                     /* 0x2031 (08241) */
NULL,                     /* 0x2032 (08242) */
NULL,                     /* 0x2033 (08243) */
NULL,                     /* 0x2034 (08244) */
NULL,                     /* 0x2035 (08245) */
NULL,                     /* 0x2036 (08246) */
NULL,                     /* 0x2037 (08247) */
NULL,                     /* 0x2038 (08248) */
"{\\guilsinglleft}",      /* 0x2039 (08249) */
"{\\guilsinglright}",     /* 0x203a (08250) */
NULL,                     /* 0x203b (08251) */
NULL,                     /* 0x203c (08252) */
NULL,                     /* 0x203d (08253) */
NULL,                     /* 0x203e (08254) */
NULL,                     /* 0x203f (08255) */
NULL,                     /* 0x2040 (08256) */
NULL,                     /* 0x2041 (08257) */
NULL,                     /* 0x2042 (08258) */
NULL,                     /* 0x2043 (08259) */
"/",                      /* 0x2044 (08260) */
NULL,                     /* 0x2045 (08261) */
NULL,                     /* 0x2046 (08262) */
NULL,                     /* 0x2047 (08263) */
NULL,                     /* 0x2048 (08264) */
NULL,                     /* 0x2049 (08265) */
NULL,                     /* 0x204a (08266) */
NULL,                     /* 0x204b (08267) */
NULL,                     /* 0x204c (08268) */
NULL,                     /* 0x204d (08269) */
NULL,                     /* 0x204e (08270) */
NULL,                     /* 0x204f (08271) */
NULL,                     /* 0x2050 (08272) */
NULL,                     /* 0x2051 (08273) */
NULL,                     /* 0x2052 (08274) */
NULL,                     /* 0x2053 (08275) */
NULL,                     /* 0x2054 (08276) */
NULL,                     /* 0x2055 (08277) */
NULL,                     /* 0x2056 (08278) */
NULL,                     /* 0x2057 (08279) */
NULL,                     /* 0x2058 (08280) */
NULL,                     /* 0x2059 (08281) */
NULL,                     /* 0x205a (08282) */
NULL,                     /* 0x205b (08283) */
NULL,                     /* 0x205c (08284) */
NULL,                     /* 0x205d (08285) */
NULL,                     /* 0x205e (08286) */
NULL,                     /* 0x205f (08287) */
NULL,                     /* 0x2060 (08288) */
NULL,                     /* 0x2061 (08289) */
NULL,                     /* 0x2062 (08290) */
NULL,                     /* 0x2063 (08291) */
NULL,                     /* 0x2064 (08292) */
NULL,                     /* 0x2065 (08293) */
NULL,                     /* 0x2066 (08294) */
NULL,                     /* 0x2067 (08295) */
NULL,                     /* 0x2068 (08296) */
NULL,                     /* 0x2069 (08297) */
NULL,                     /* 0x206a (08298) */
NULL,                     /* 0x206b (08299) */
NULL,                     /* 0x206c (08300) */
NULL,                     /* 0x206d (08301) */
NULL,                     /* 0x206e (08302) */
NULL,                     /* 0x206f (08303) */
NULL,                     /* 0x2070 (08304) */
NULL,                     /* 0x2071 (08305) */
NULL,                     /* 0x2072 (08306) */
NULL,                     /* 0x2073 (08307) */
NULL,                     /* 0x2074 (08308) */
NULL,                     /* 0x2075 (08309) */
NULL,                     /* 0x2076 (08310) */
NULL,                     /* 0x2077 (08311) */
NULL,                     /* 0x2078 (08312) */
NULL,                     /* 0x2079 (08313) */
NULL,                     /* 0x207a (08314) */
NULL,                     /* 0x207b (08315) */
NULL,                     /* 0x207c (08316) */
NULL,                     /* 0x207d (08317) */
NULL,                     /* 0x207e (08318) */
NULL,                     /* 0x207f (08319) */
NULL,                     /* 0x2080 (08320) */
NULL,                     /* 0x2081 (08321) */
NULL,                     /* 0x2082 (08322) */
NULL,                     /* 0x2083 (08323) */
NULL,                     /* 0x2084 (08324) */
NULL,                     /* 0x2085 (08325) */
NULL,                     /* 0x2086 (08326) */
NULL,                     /* 0x2087 (08327) */
NULL,                     /* 0x2088 (08328) */
NULL,                     /* 0x2089 (08329) */
NULL,                     /* 0x208a (08330) */
NULL,                     /* 0x208b (08331) */
NULL,                     /* 0x208c (08332) */
NULL,                     /* 0x208d (08333) */
NULL,                     /* 0x208e (08334) */
NULL,                     /* 0x208f (08335) */
NULL,                     /* 0x2090 (08336) */
NULL,                     /* 0x2091 (08337) */
NULL,                     /* 0x2092 (08338) */
NULL,                     /* 0x2093 (08339) */
NULL,                     /* 0x2094 (08340) */
NULL,                     /* 0x2095 (08341) */
NULL,                     /* 0x2096 (08342) */
NULL,                     /* 0x2097 (08343) */
NULL,                     /* 0x2098 (08344) */
NULL,                     /* 0x2099 (08345) */
NULL,                     /* 0x209a (08346) */
NULL,                     /* 0x209b (08347) */
NULL,                     /* 0x209c (08348) */
NULL,                     /* 0x209d (08349) */
NULL,                     /* 0x209e (08350) */
NULL,                     /* 0x209f (08351) */
NULL,                     /* 0x20a0 (08352) */
NULL,                     /* 0x20a1 (08353) */
NULL,                     /* 0x20a2 (08354) */
NULL,                     /* 0x20a3 (08355) */
NULL,                     /* 0x20a4 (08356) */
NULL,                     /* 0x20a5 (08357) */
NULL,                     /* 0x20a6 (08358) */
NULL,                     /* 0x20a7 (08359) */
NULL,                     /* 0x20a8 (08360) */
NULL,                     /* 0x20a9 (08361) */
NULL,                     /* 0x20aa (08362) */
NULL,                     /* 0x20ab (08363) */
"{\\texteuro}",           /* 0x20ac (08364) */
NULL,                     /* 0x20ad (08365) */
NULL,                     /* 0x20ae (08366) */
NULL,                     /* 0x20af (08367) */
NULL,                     /* 0x20b0 (08368) */
NULL,                     /* 0x20b1 (08369) */
NULL,                     /* 0x20b2 (08370) */
NULL,                     /* 0x20b3 (08371) */
NULL,                     /* 0x20b4 (08372) */
NULL,                     /* 0x20b5 (08373) */
NULL,                     /* 0x20b6 (08374) */
NULL,                     /* 0x20b7 (08375) */
NULL,                     /* 0x20b8 (08376) */
NULL,                     /* 0x20b9 (08377) */
NULL,                     /* 0x20ba (08378) */
NULL,                     /* 0x20bb (08379) */
NULL,                     /* 0x20bc (08380) */
NULL,                     /* 0x20bd (08381) */
NULL,                     /* 0x20be (08382) */
NULL,                     /* 0x20bf (08383) */
NULL,                     /* 0x20c0 (08384) */
NULL,                     /* 0x20c1 (08385) */
NULL,                     /* 0x20c2 (08386) */
NULL,                     /* 0x20c3 (08387) */
NULL,                     /* 0x20c4 (08388) */
NULL,                     /* 0x20c5 (08389) */
NULL,                     /* 0x20c6 (08390) */
NULL,                     /* 0x20c7 (08391) */
NULL,                     /* 0x20c8 (08392) */
NULL,                     /* 0x20c9 (08393) */
NULL,                     /* 0x20ca (08394) */
NULL,                     /* 0x20cb (08395) */
NULL,                     /* 0x20cc (08396) */
NULL,                     /* 0x20cd (08397) */
NULL,                     /* 0x20ce (08398) */
NULL,                     /* 0x20cf (08399) */
NULL,                     /* 0x20d0 (08400) */
NULL,                     /* 0x20d1 (08401) */
NULL,                     /* 0x20d2 (08402) */
NULL,                     /* 0x20d3 (08403) */
NULL,                     /* 0x20d4 (08404) */
NULL,                     /* 0x20d5 (08405) */
NULL,                     /* 0x20d6 (08406) */
NULL,                     /* 0x20d7 (08407) */
NULL,                     /* 0x20d8 (08408) */
NULL,                     /* 0x20d9 (08409) */
NULL,                     /* 0x20da (08410) */
NULL,                     /* 0x20db (08411) */
NULL,                     /* 0x20dc (08412) */
NULL,                     /* 0x20dd (08413) */
NULL,                     /* 0x20de (08414) */
NULL,                     /* 0x20df (08415) */
NULL,                     /* 0x20e0 (08416) */
NULL,                     /* 0x20e1 (08417) */
NULL,                     /* 0x20e2 (08418) */
NULL,                     /* 0x20e3 (08419) */
NULL,                     /* 0x20e4 (08420) */
NULL,                     /* 0x20e5 (08421) */
NULL,                     /* 0x20e6 (08422) */
NULL,                     /* 0x20e7 (08423) */
NULL,                     /* 0x20e8 (08424) */
NULL,                     /* 0x20e9 (08425) */
NULL,                     /* 0x20ea (08426) */
NULL,                     /* 0x20eb (08427) */
NULL,                     /* 0x20ec (08428) */
NULL,                     /* 0x20ed (08429) */
NULL,                     /* 0x20ee (08430) */
NULL,                     /* 0x20ef (08431) */
NULL,                     /* 0x20f0 (08432) */
NULL,                     /* 0x20f1 (08433) */
NULL,                     /* 0x20f2 (08434) */
NULL,                     /* 0x20f3 (08435) */
NULL,                     /* 0x20f4 (08436) */
NULL,                     /* 0x20f5 (08437) */
NULL,                     /* 0x20f6 (08438) */
NULL,                     /* 0x20f7 (08439) */
NULL,                     /* 0x20f8 (08440) */
NULL,                     /* 0x20f9 (08441) */
NULL,                     /* 0x20fa (08442) */
NULL,                     /* 0x20fb (08443) */
NULL,                     /* 0x20fc (08444) */
NULL,                     /* 0x20fd (08445) */
NULL,                     /* 0x20fe (08446) */
NULL,                     /* 0x20ff (08447) */
NULL,                     /* 0x2100 (08448) */
NULL,                     /* 0x2101 (08449) */
NULL,                     /* 0x2102 (08450) */
NULL,                     /* 0x2103 (08451) */
NULL,                     /* 0x2104 (08452) */
NULL,                     /* 0x2105 (08453) */
NULL,                     /* 0x2106 (08454) */
NULL,                     /* 0x2107 (08455) */
NULL,                     /* 0x2108 (08456) */
NULL,                     /* 0x2109 (08457) */
NULL,                     /* 0x210a (08458) */
NULL,                     /* 0x210b (08459) */
NULL,                     /* 0x210c (08460) */
NULL,                     /* 0x210d (08461) */
NULL,                     /* 0x210e (08462) */
NULL,                     /* 0x210f (08463) */
NULL,                     /* 0x2110 (08464) */
NULL,                     /* 0x2111 (08465) */
NULL,                     /* 0x2112 (08466) */
NULL,                     /* 0x2113 (08467) */
NULL,                     /* 0x2114 (08468) */
NULL,                     /* 0x2115 (08469) */
NULL,                     /* 0x2116 (08470) */
NULL,                     /* 0x2117 (08471) */
NULL,                     /* 0x2118 (08472) */
NULL,                     /* 0x2119 (08473) */
NULL,                     /* 0x211a (08474) */
NULL,                     /* 0x211b (08475) */
NULL,                     /* 0x211c (08476) */
NULL,                     /* 0x211d (08477) */
NULL,                     /* 0x211e (08478) */
NULL,                     /* 0x211f (08479) */
NULL,                     /* 0x2120 (08480) */
NULL,                     /* 0x2121 (08481) */
"{\\texttrademark}",      /* 0x2122 (08482) */
NULL,                     /* 0x2123 (08483) */
NULL,                     /* 0x2124 (08484) */
NULL,                     /* 0x2125 (08485) */
NULL,                     /* 0x2126 (08486) */
NULL,                     /* 0x2127 (08487) */
NULL,                     /* 0x2128 (08488) */
NULL,                     /* 0x2129 (08489) */
NULL,                     /* 0x212a (08490) */
NULL,                     /* 0x212b (08491) */
NULL,                     /* 0x212c (08492) */
NULL,                     /* 0x212d (08493) */
NULL,                     /* 0x212e (08494) */
NULL,                     /* 0x212f (08495) */
NULL,                     /* 0x2130 (08496) */
NULL,                     /* 0x2131 (08497) */
NULL,                     /* 0x2132 (08498) */
NULL,                     /* 0x2133 (08499) */
NULL,                     /* 0x2134 (08500) */
NULL,                     /* 0x2135 (08501) */
NULL,                     /* 0x2136 (08502) */
NULL,                     /* 0x2137 (08503) */
NULL,                     /* 0x2138 (08504) */
NULL,                     /* 0x2139 (08505) */
NULL,                     /* 0x213a (08506) */
NULL,                     /* 0x213b (08507) */
NULL,                     /* 0x213c (08508) */
NULL,                     /* 0x213d (08509) */
NULL,                     /* 0x213e (08510) */
NULL,                     /* 0x213f (08511) */
NULL,                     /* 0x2140 (08512) */
NULL,                     /* 0x2141 (08513) */
NULL,                     /* 0x2142 (08514) */
NULL,                     /* 0x2143 (08515) */
NULL,                     /* 0x2144 (08516) */
NULL,                     /* 0x2145 (08517) */
NULL,                     /* 0x2146 (08518) */
NULL,                     /* 0x2147 (08519) */
NULL,                     /* 0x2148 (08520) */
NULL,                     /* 0x2149 (08521) */
NULL,                     /* 0x214a (08522) */
NULL,                     /* 0x214b (08523) */
NULL,                     /* 0x214c (08524) */
NULL,                     /* 0x214d (08525) */
NULL,                     /* 0x214e (08526) */
NULL,                     /* 0x214f (08527) */
NULL,                     /* 0x2150 (08528) */
NULL,                     /* 0x2151 (08529) */
NULL,                     /* 0x2152 (08530) */
NULL,                     /* 0x2153 (08531) */
NULL,                     /* 0x2154 (08532) */
NULL,                     /* 0x2155 (08533) */
NULL,                     /* 0x2156 (08534) */
NULL,                     /* 0x2157 (08535) */
NULL,                     /* 0x2158 (08536) */
NULL,                     /* 0x2159 (08537) */
NULL,                     /* 0x215a (08538) */
NULL,                     /* 0x215b (08539) */
NULL,                     /* 0x215c (08540) */
NULL,                     /* 0x215d (08541) */
NULL,                     /* 0x215e (08542) */
NULL,                     /* 0x215f (08543) */
NULL,                     /* 0x2160 (08544) */
NULL,                     /* 0x2161 (08545) */
NULL,                     /* 0x2162 (08546) */
NULL,                     /* 0x2163 (08547) */
NULL,                     /* 0x2164 (08548) */
NULL,                     /* 0x2165 (08549) */
NULL,                     /* 0x2166 (08550) */
NULL,                     /* 0x2167 (08551) */
NULL,                     /* 0x2168 (08552) */
NULL,                     /* 0x2169 (08553) */
NULL,                     /* 0x216a (08554) */
NULL,                     /* 0x216b (08555) */
NULL,                     /* 0x216c (08556) */
NULL,                     /* 0x216d (08557) */
NULL,                     /* 0x216e (08558) */
NULL,                     /* 0x216f (08559) */
NULL,                     /* 0x2170 (08560) */
NULL,                     /* 0x2171 (08561) */
NULL,                     /* 0x2172 (08562) */
NULL,                     /* 0x2173 (08563) */
NULL,                     /* 0x2174 (08564) */
NULL,                     /* 0x2175 (08565) */
NULL,                     /* 0x2176 (08566) */
NULL,                     /* 0x2177 (08567) */
NULL,                     /* 0x2178 (08568) */
NULL,                     /* 0x2179 (08569) */
NULL,                     /* 0x217a (08570) */
NULL,                     /* 0x217b (08571) */
NULL,                     /* 0x217c (08572) */
NULL,                     /* 0x217d (08573) */
NULL,                     /* 0x217e (08574) */
NULL,                     /* 0x217f (08575) */
NULL,                     /* 0x2180 (08576) */
NULL,                     /* 0x2181 (08577) */
NULL,                     /* 0x2182 (08578) */
NULL,                     /* 0x2183 (08579) */
NULL,                     /* 0x2184 (08580) */
NULL,                     /* 0x2185 (08581) */
NULL,                     /* 0x2186 (08582) */
NULL,                     /* 0x2187 (08583) */
NULL,                     /* 0x2188 (08584) */
NULL,                     /* 0x2189 (08585) */
NULL,                     /* 0x218a (08586) */
NULL,                     /* 0x218b (08587) */
NULL,                     /* 0x218c (08588) */
NULL,                     /* 0x218d (08589) */
NULL,                     /* 0x218e (08590) */
NULL,                     /* 0x218f (08591) */
NULL,                     /* 0x2190 (08592) */
NULL,                     /* 0x2191 (08593) */
NULL,                     /* 0x2192 (08594) */
NULL,                     /* 0x2193 (08595) */
NULL,                     /* 0x2194 (08596) */
NULL,                     /* 0x2195 (08597) */
NULL,                     /* 0x2196 (08598) */
NULL,                     /* 0x2197 (08599) */
NULL,                     /* 0x2198 (08600) */
NULL,                     /* 0x2199 (08601) */
NULL,                     /* 0x219a (08602) */
NULL,                     /* 0x219b (08603) */
NULL,                     /* 0x219c (08604) */
NULL,                     /* 0x219d (08605) */
NULL,                     /* 0x219e (08606) */
NULL,                     /* 0x219f (08607) */
NULL,                     /* 0x21a0 (08608) */
NULL,                     /* 0x21a1 (08609) */
NULL,                     /* 0x21a2 (08610) */
NULL,                     /* 0x21a3 (08611) */
NULL,                     /* 0x21a4 (08612) */
NULL,                     /* 0x21a5 (08613) */
NULL,                     /* 0x21a6 (08614) */
NULL,                     /* 0x21a7 (08615) */
NULL,                     /* 0x21a8 (08616) */
NULL,                     /* 0x21a9 (08617) */
NULL,                     /* 0x21aa (08618) */
NULL,                     /* 0x21ab (08619) */
NULL,                     /* 0x21ac (08620) */
NULL,                     /* 0x21ad (08621) */
NULL,                     /* 0x21ae (08622) */
NULL,                     /* 0x21af (08623) */
NULL,                     /* 0x21b0 (08624) */
NULL,                     /* 0x21b1 (08625) */
NULL,                     /* 0x21b2 (08626) */
NULL,                     /* 0x21b3 (08627) */
NULL,                     /* 0x21b4 (08628) */
NULL,                     /* 0x21b5 (08629) */
NULL,                     /* 0x21b6 (08630) */
NULL,                     /* 0x21b7 (08631) */
NULL,                     /* 0x21b8 (08632) */
NULL,                     /* 0x21b9 (08633) */
NULL,                     /* 0x21ba (08634) */
NULL,                     /* 0x21bb (08635) */
NULL,                     /* 0x21bc (08636) */
NULL,                     /* 0x21bd (08637) */
NULL,                     /* 0x21be (08638) */
NULL,                     /* 0x21bf (08639) */
NULL,                     /* 0x21c0 (08640) */
NULL,                     /* 0x21c1 (08641) */
NULL,                     /* 0x21c2 (08642) */
NULL,                     /* 0x21c3 (08643) */
NULL,                     /* 0x21c4 (08644) */
NULL,                     /* 0x21c5 (08645) */
NULL,                     /* 0x21c6 (08646) */
NULL,                     /* 0x21c7 (08647) */
NULL,                     /* 0x21c8 (08648) */
NULL,                     /* 0x21c9 (08649) */
NULL,                     /* 0x21ca (08650) */
NULL,                     /* 0x21cb (08651) */
NULL,                     /* 0x21cc (08652) */
NULL,                     /* 0x21cd (08653) */
NULL,                     /* 0x21ce (08654) */
NULL,                     /* 0x21cf (08655) */
NULL,                     /* 0x21d0 (08656) */
NULL,                     /* 0x21d1 (08657) */
NULL,                     /* 0x21d2 (08658) */
NULL,                     /* 0x21d3 (08659) */
NULL,                     /* 0x21d4 (08660) */
NULL,                     /* 0x21d5 (08661) */
NULL,                     /* 0x21d6 (08662) */
NULL,                     /* 0x21d7 (08663) */
NULL,                     /* 0x21d8 (08664) */
NULL,                     /* 0x21d9 (08665) */
NULL,                     /* 0x21da (08666) */
NULL,                     /* 0x21db (08667) */
NULL,                     /* 0x21dc (08668) */
NULL,                     /* 0x21dd (08669) */
NULL,                     /* 0x21de (08670) */
NULL,                     /* 0x21df (08671) */
NULL,                     /* 0x21e0 (08672) */
NULL,                     /* 0x21e1 (08673) */
NULL,                     /* 0x21e2 (08674) */
NULL,                     /* 0x21e3 (08675) */
NULL,                     /* 0x21e4 (08676) */
NULL,                     /* 0x21e5 (08677) */
NULL,                     /* 0x21e6 (08678) */
NULL,                     /* 0x21e7 (08679) */
NULL,                     /* 0x21e8 (08680) */
NULL,                     /* 0x21e9 (08681) */
NULL,                     /* 0x21ea (08682) */
NULL,                     /* 0x21eb (08683) */
NULL,                     /* 0x21ec (08684) */
NULL,                     /* 0x21ed (08685) */
NULL,                     /* 0x21ee (08686) */
NULL,                     /* 0x21ef (08687) */
NULL,                     /* 0x21f0 (08688) */
NULL,                     /* 0x21f1 (08689) */
NULL,                     /* 0x21f2 (08690) */
NULL,                     /* 0x21f3 (08691) */
NULL,                     /* 0x21f4 (08692) */
NULL,                     /* 0x21f5 (08693) */
NULL,                     /* 0x21f6 (08694) */
NULL,                     /* 0x21f7 (08695) */
NULL,                     /* 0x21f8 (08696) */
NULL,                     /* 0x21f9 (08697) */
NULL,                     /* 0x21fa (08698) */
NULL,                     /* 0x21fb (08699) */
NULL,                     /* 0x21fc (08700) */
NULL,                     /* 0x21fd (08701) */
NULL,                     /* 0x21fe (08702) */
NULL,                     /* 0x21ff (08703) */
NULL,                     /* 0x2200 (08704) */
NULL,                     /* 0x2201 (08705) */
"$\\partial$",            /* 0x2202 (08706) */
NULL,                     /* 0x2203 (08707) */
NULL,                     /* 0x2204 (08708) */
NULL,                     /* 0x2205 (08709) */
"$\\Delta$",              /* 0x2206 (08710) */
NULL,                     /* 0x2207 (08711) */
NULL,                     /* 0x2208 (08712) */
NULL,                     /* 0x2209 (08713) */
NULL,                     /* 0x220a (08714) */
NULL,                     /* 0x220b (08715) */
NULL,                     /* 0x220c (08716) */
NULL,                     /* 0x220d (08717) */
NULL,                     /* 0x220e (08718) */
"$\\prod$",               /* 0x220f (08719) */
NULL,                     /* 0x2210 (08720) */
"$\\sum$",                /* 0x2211 (08721) */
NULL,                     /* 0x2212 (08722) */
NULL,                     /* 0x2213 (08723) */
NULL,                     /* 0x2214 (08724) */
NULL,                     /* 0x2215 (08725) */
NULL,                     /* 0x2216 (08726) */
NULL,                     /* 0x2217 (08727) */
NULL,                     /* 0x2218 (08728) */
NULL,                     /* 0x2219 (08729) */
"$\\surd$",               /* 0x221a (08730) */
NULL,                     /* 0x221b (08731) */
NULL,                     /* 0x221c (08732) */
NULL,                     /* 0x221d (08733) */
"$\\infty$",              /* 0x221e (08734) */
NULL,                     /* 0x221f (08735) */
NULL,                     /* 0x2220 (08736) */
NULL,                     /* 0x2221 (08737) */
NULL,                     /* 0x2222 (08738) */
NULL,                     /* 0x2223 (08739) */
NULL,                     /* 0x2224 (08740) */
NULL,                     /* 0x2225 (08741) */
NULL,                     /* 0x2226 (08742) */
NULL,                     /* 0x2227 (08743) */
NULL,                     /* 0x2228 (08744) */
NULL,                     /* 0x2229 (08745) */
NULL,                     /* 0x222a (08746) */
"$\\int$",                /* 0x222b (08747) */
NULL,                     /* 0x222c (08748) */
NULL,                     /* 0x222d (08749) */
NULL,                     /* 0x222e (08750) */
NULL,                     /* 0x222f (08751) */
NULL,                     /* 0x2230 (08752) */
NULL,                     /* 0x2231 (08753) */
NULL,                     /* 0x2232 (08754) */
NULL,                     /* 0x2233 (08755) */
NULL,                     /* 0x2234 (08756) */
NULL,                     /* 0x2235 (08757) */
NULL,                     /* 0x2236 (08758) */
NULL,                     /* 0x2237 (08759) */
NULL,                     /* 0x2238 (08760) */
NULL,                     /* 0x2239 (08761) */
NULL,                     /* 0x223a (08762) */
NULL,                     /* 0x223b (08763) */
NULL,                     /* 0x223c (08764) */
NULL,                     /* 0x223d (08765) */
NULL,                     /* 0x223e (08766) */
NULL,                     /* 0x223f (08767) */
NULL,                     /* 0x2240 (08768) */
NULL,                     /* 0x2241 (08769) */
NULL,                     /* 0x2242 (08770) */
NULL,                     /* 0x2243 (08771) */
NULL,                     /* 0x2244 (08772) */
NULL,                     /* 0x2245 (08773) */
NULL,                     /* 0x2246 (08774) */
NULL,                     /* 0x2247 (08775) */
"$\\approx$",             /* 0x2248 (08776) */
NULL,                     /* 0x2249 (08777) */
NULL,                     /* 0x224a (08778) */
NULL,                     /* 0x224b (08779) */
NULL,                     /* 0x224c (08780) */
NULL,                     /* 0x224d (08781) */
NULL,                     /* 0x224e (08782) */
NULL,                     /* 0x224f (08783) */
NULL,                     /* 0x2250 (08784) */
NULL,                     /* 0x2251 (08785) */
NULL,                     /* 0x2252 (08786) */
NULL,                     /* 0x2253 (08787) */
NULL,                     /* 0x2254 (08788) */
NULL,                     /* 0x2255 (08789) */
NULL,                     /* 0x2256 (08790) */
NULL,                     /* 0x2257 (08791) */
NULL,                     /* 0x2258 (08792) */
NULL,                     /* 0x2259 (08793) */
NULL,                     /* 0x225a (08794) */
NULL,                     /* 0x225b (08795) */
NULL,                     /* 0x225c (08796) */
NULL,                     /* 0x225d (08797) */
NULL,                     /* 0x225e (08798) */
NULL,                     /* 0x225f (08799) */
"$\\neq$",                /* 0x2260 (08800) */
NULL,                     /* 0x2261 (08801) */
NULL,                     /* 0x2262 (08802) */
NULL,                     /* 0x2263 (08803) */
"$\\leq$",                /* 0x2264 (08804) */
"$\\geq$",                /* 0x2265 (08805) */
NULL,                     /* 0x2266 (08806) */
NULL,                     /* 0x2267 (08807) */
NULL,                     /* 0x2268 (08808) */
NULL,                     /* 0x2269 (08809) */
NULL,                     /* 0x226a (08810) */
NULL,                     /* 0x226b (08811) */
NULL,                     /* 0x226c (08812) */
NULL,                     /* 0x226d (08813) */
NULL,                     /* 0x226e (08814) */
NULL,                     /* 0x226f (08815) */
NULL,                     /* 0x2270 (08816) */
NULL,                     /* 0x2271 (08817) */
NULL,                     /* 0x2272 (08818) */
NULL,                     /* 0x2273 (08819) */
NULL,                     /* 0x2274 (08820) */
NULL,                     /* 0x2275 (08821) */
NULL,                     /* 0x2276 (08822) */
NULL,                     /* 0x2277 (08823) */
NULL,                     /* 0x2278 (08824) */
NULL,                     /* 0x2279 (08825) */
NULL,                     /* 0x227a (08826) */
NULL,                     /* 0x227b (08827) */
NULL,                     /* 0x227c (08828) */
NULL,                     /* 0x227d (08829) */
NULL,                     /* 0x227e (08830) */
NULL,                     /* 0x227f (08831) */
NULL,                     /* 0x2280 (08832) */
NULL,                     /* 0x2281 (08833) */
NULL,                     /* 0x2282 (08834) */
NULL,                     /* 0x2283 (08835) */
NULL,                     /* 0x2284 (08836) */
NULL,                     /* 0x2285 (08837) */
NULL,                     /* 0x2286 (08838) */
NULL,                     /* 0x2287 (08839) */
NULL,                     /* 0x2288 (08840) */
NULL,                     /* 0x2289 (08841) */
NULL,                     /* 0x228a (08842) */
NULL,                     /* 0x228b (08843) */
NULL,                     /* 0x228c (08844) */
NULL,                     /* 0x228d (08845) */
NULL,                     /* 0x228e (08846) */
NULL,                     /* 0x228f (08847) */
NULL,                     /* 0x2290 (08848) */
NULL,                     /* 0x2291 (08849) */
NULL,                     /* 0x2292 (08850) */
NULL,                     /* 0x2293 (08851) */
NULL,                     /* 0x2294 (08852) */
NULL,                     /* 0x2295 (08853) */
NULL,                     /* 0x2296 (08854) */
NULL,                     /* 0x2297 (08855) */
NULL,                     /* 0x2298 (08856) */
NULL,                     /* 0x2299 (08857) */
NULL,                     /* 0x229a (08858) */
NULL,                     /* 0x229b (08859) */
NULL,                     /* 0x229c (08860) */
NULL,                     /* 0x229d (08861) */
NULL,                     /* 0x229e (08862) */
NULL,                     /* 0x229f (08863) */
NULL,                     /* 0x22a0 (08864) */
NULL,                     /* 0x22a1 (08865) */
NULL,                     /* 0x22a2 (08866) */
NULL,                     /* 0x22a3 (08867) */
NULL,                     /* 0x22a4 (08868) */
NULL,                     /* 0x22a5 (08869) */
NULL,                     /* 0x22a6 (08870) */
NULL,                     /* 0x22a7 (08871) */
NULL,                     /* 0x22a8 (08872) */
NULL,                     /* 0x22a9 (08873) */
NULL,                     /* 0x22aa (08874) */
NULL,                     /* 0x22ab (08875) */
NULL,                     /* 0x22ac (08876) */
NULL,                     /* 0x22ad (08877) */
NULL,                     /* 0x22ae (08878) */
NULL,                     /* 0x22af (08879) */
NULL,                     /* 0x22b0 (08880) */
NULL,                     /* 0x22b1 (08881) */
NULL,                     /* 0x22b2 (08882) */
NULL,                     /* 0x22b3 (08883) */
NULL,                     /* 0x22b4 (08884) */
NULL,                     /* 0x22b5 (08885) */
NULL,                     /* 0x22b6 (08886) */
NULL,                     /* 0x22b7 (08887) */
NULL,                     /* 0x22b8 (08888) */
NULL,                     /* 0x22b9 (08889) */
NULL,                     /* 0x22ba (08890) */
NULL,                     /* 0x22bb (08891) */
NULL,                     /* 0x22bc (08892) */
NULL,                     /* 0x22bd (08893) */
NULL,                     /* 0x22be (08894) */
NULL,                     /* 0x22bf (08895) */
NULL,                     /* 0x22c0 (08896) */
NULL,                     /* 0x22c1 (08897) */
NULL,                     /* 0x22c2 (08898) */
NULL,                     /* 0x22c3 (08899) */
NULL,                     /* 0x22c4 (08900) */
NULL,                     /* 0x22c5 (08901) */
NULL,                     /* 0x22c6 (08902) */
NULL,                     /* 0x22c7 (08903) */
NULL,                     /* 0x22c8 (08904) */
NULL,                     /* 0x22c9 (08905) */
NULL,                     /* 0x22ca (08906) */
NULL,                     /* 0x22cb (08907) */
NULL,                     /* 0x22cc (08908) */
NULL,                     /* 0x22cd (08909) */
NULL,                     /* 0x22ce (08910) */
NULL,                     /* 0x22cf (08911) */
NULL,                     /* 0x22d0 (08912) */
NULL,                     /* 0x22d1 (08913) */
NULL,                     /* 0x22d2 (08914) */
NULL,                     /* 0x22d3 (08915) */
NULL,                     /* 0x22d4 (08916) */
NULL,                     /* 0x22d5 (08917) */
NULL,                     /* 0x22d6 (08918) */
NULL,                     /* 0x22d7 (08919) */
NULL,                     /* 0x22d8 (08920) */
NULL,                     /* 0x22d9 (08921) */
NULL,                     /* 0x22da (08922) */
NULL,                     /* 0x22db (08923) */
NULL,                     /* 0x22dc (08924) */
NULL,                     /* 0x22dd (08925) */
NULL,                     /* 0x22de (08926) */
NULL,                     /* 0x22df (08927) */
NULL,                     /* 0x22e0 (08928) */
NULL,                     /* 0x22e1 (08929) */
NULL,                     /* 0x22e2 (08930) */
NULL,                     /* 0x22e3 (08931) */
NULL,                     /* 0x22e4 (08932) */
NULL,                     /* 0x22e5 (08933) */
NULL,                     /* 0x22e6 (08934) */
NULL,                     /* 0x22e7 (08935) */
NULL,                     /* 0x22e8 (08936) */
NULL,                     /* 0x22e9 (08937) */
NULL,                     /* 0x22ea (08938) */
NULL,                     /* 0x22eb (08939) */
NULL,                     /* 0x22ec (08940) */
NULL,                     /* 0x22ed (08941) */
NULL,                     /* 0x22ee (08942) */
NULL,                     /* 0x22ef (08943) */
NULL,                     /* 0x22f0 (08944) */
NULL,                     /* 0x22f1 (08945) */
NULL,                     /* 0x22f2 (08946) */
NULL,                     /* 0x22f3 (08947) */
NULL,                     /* 0x22f4 (08948) */
NULL,                     /* 0x22f5 (08949) */
NULL,                     /* 0x22f6 (08950) */
NULL,                     /* 0x22f7 (08951) */
NULL,                     /* 0x22f8 (08952) */
NULL,                     /* 0x22f9 (08953) */
NULL,                     /* 0x22fa (08954) */
NULL,                     /* 0x22fb (08955) */
NULL,                     /* 0x22fc (08956) */
NULL,                     /* 0x22fd (08957) */
NULL,                     /* 0x22fe (08958) */
NULL                      /* 0x22ff (08959) */
};

/*
   Table of surrogate pairs by Kino san
*/
#define SRGNUM 383

typedef struct __srgtag {
unsigned int utfeight;
unsigned short cid;
} __srg;

__srg srgtab[SRGNUM] = {
0xF0A8B39D, 7641,
0xF0AFA3AD, 7665,
0xF0A5A1B4, 7670,
0xF0A8BBB6, 7673,
0xF0AFA39C, 7695,
0xF0AFA284, 7734,
0xF0AFA1B7, 7754,
0xF0AFA08F, 7814,
0xF0AFA393, 7816,
0xF0AFA098, 7817,
0xF0A1A89A, 7825,
0xF0A48F90, 7838,
0xF0AFA4A0, 7839,
0xF0AFA585, 13357,
0xF0A0A48E, 13523,
0xF0A6A591, 13646,
0xF0AFA3BC, 13656,
0xF0AFA695, 13670,
0xF0AFA3AA, 13679,
0xF0AFA0A2, 13684,
0xF0A0AEB7, 13706,
0xF0A9B58B, 13717,
0xF0AFA0B3, 13719,
0xF0AFA2AC, 13750,
0xF0A0A9A4, 13755,
0xF0AFA483, 13768,
0xF0AFA48B, 13801,
0xF0A0AE9F, 13803,
0xF0AFA0A8, 13807,
0xF0AFA4A1, 13809,
0xF0AFA0BF, 13815,
0xF0AFA1B3, 13832,
0xF0A0808B, 13839,
0xF0AFA192, 13841,
0xF0A999BF, 13849,
0xF0AFA587, 13854,
0xF0A086A2, 13857,
0xF0AFA2B2, 13867,
0xF0A7BEB7, 13898,
0xF0A3B3BE, 13904,
0xF0AFA49A, 13916,
0xF0AFA29A, 13928,
0xF0AFA48F, 13932,
0xF0A188BD, 13953,
0xF0AFA09A, 13954,
0xF0A4B494, 13995,
0xF0AFA1A2, 13998,
0xF0AFA790, 14068,
0xF0AFA79F, 14069,
0xF0A599BF, 14075,
0xF0A69AB0, 14100,
0xF0A098A8, 14105,
0xF0A0828A, 14108,
0xF0AFA0AC, 14109,
0xF0AFA1AD, 14121,
0xF0AFA2B6, 14129,
0xF0A6A699, 14134,
0xF0AFA39B, 14140,
0xF0AFA5AC, 14180,
0xF0A082B0, 14209,
0xF0A8A687, 14253,
0xF0A8B897, 14256,
0xF0A48BAE, 14282,
0xF0AFA3A1, 14291,
0xF0A3B2BE, 14293,
0xF0A09891, 14294,
0xF0AFA7B4, 15269,
0xF0AFA084, 15388,
0xF0A398BA, 15393,
0xF0A38FBE, 15422,
0xF0A29889, 15443,
0xF0A18C9B, 16816,
0xF0A191AE, 16821,
0xF0A1A2BD, 16833,
0xF0A19AB4, 16838,
0xF0A1B8B4, 16845,
0xF0A38784, 16888,
0xF0A39784, 16905,
0xF0A39CBF, 16914,
0xF0A39DA3, 16916,
0xF0A49FB1, 16970,
0xF0A5928E, 17005,
0xF0A5948E, 17009,
0xF0A59DB1, 17018,
0xF0A5A784, 17024,
0xF0A5B6A1, 17033,
0xF0A6ABBF, 17063,
0xF0A6B980, 17089,
0xF0A783B4, 17103,
0xF0A79A84, 17117,
0xF0A889B7, 17140,
0xF0A88F8D, 17146,
0xF0AA8690, 17227,
0xF0A08289, 17233,
0xF0A082A2, 17240,
0xF0A082A4, 17243,
0xF0A08893, 17259,
0xF0A08CAB, 17282,
0xF0A08E81, 17289,
0xF0A08DB1, 17291,
0xF0A08FB9, 17295,
0xF0A0918A, 17297,
0xF0A09489, 17299,
0xF0A09796, 17308,
0xF0A09D8F, 17312,
0xF0A0A087, 17319,
0xF0A0A0BA, 17321,
0xF0A0A2B9, 17327,
0xF0A0A5BC, 17331,
0xF0A0A69D, 17332,
0xF0A0AB93, 17337,
0xF0A0AC9D, 17340,
0xF0A0B585, 17359,
0xF0A0B7A1, 17373,
0xF0A0BA95, 17379,
0xF0A0B9AD, 17380,
0xF0A0B9A4, 17388,
0xF0A0BD9F, 17391,
0xF0A18881, 17414,
0xF0A18995, 17415,
0xF0A189BB, 17417,
0xF0A189B4, 17421,
0xF0A18BA4, 17428,
0xF0A18B97, 17429,
0xF0A18BBD, 17435,
0xF0A18CB6, 17437,
0xF0A18D84, 17438,
0xF0A18F84, 17449,
0xF0A191AD, 17462,
0xF0A19797, 17472,
0xF0A6B0A9, 17478,
0xF0A19987, 17480,
0xF0A19C86, 17492,
0xF0A19D82, 17493,
0xF0A1A783, 17525,
0xF0A1B196, 17539,
0xF0A1B4AD, 17544,
0xF0A1B585, 17545,
0xF0A1B5B8, 17546,
0xF0A1B5A2, 17547,
0xF0A1B6A1, 17551,
0xF0A1B69C, 17552,
0xF0A1B692, 17556,
0xF0A1B6B7, 17559,
0xF0A1B7A0, 17561,
0xF0A1B8B3, 17562,
0xF0A1BC9E, 17575,
0xF0A1BDB6, 17582,
0xF0A1BFBA, 17585,
0xF0A285BB, 17599,
0xF0A28C9E, 17605,
0xF0A28EAD, 17608,
0xF0A29BB3, 17632,
0xF0A2A19B, 17647,
0xF0A2A2AB, 17653,
0xF0A2A68F, 17657,
0xF0A2AAB8, 17667,
0xF0A2AD8F, 17671,
0xF0A2AD90, 17672,
0xF0A2AD86, 17680,
0xF0A2B09D, 17682,
0xF0A2AEA6, 17683,
0xF0A2B0A4, 17686,
0xF0A2B7A1, 17710,
0xF0A38783, 17742,
0xF0A387B5, 17743,
0xF0A386B6, 17744,
0xF0A38DB2, 17761,
0xF0A38F93, 17763,
0xF0A38F92, 17764,
0xF0A38F90, 17768,
0xF0A38FA4, 17769,
0xF0A38F95, 17770,
0xF0A38F9A, 17772,
0xF0A38F9F, 17774,
0xF0A3918A, 17782,
0xF0A39191, 17783,
0xF0A3918B, 17784,
0xF0A391A5, 17788,
0xF0A393A4, 17814,
0xF0A3959A, 17815,
0xF0A39694, 17827,
0xF0A398B9, 17841,
0xF0A39987, 17842,
0xF0A398B8, 17843,
0xF0A39C9C, 17854,
0xF0A39C8C, 17863,
0xF0A39DA4, 17867,
0xF0A39FBF, 17874,
0xF0A39FA7, 17875,
0xF0A3A0A4, 17880,
0xF0A3A0BD, 17885,
0xF0A3AA98, 17897,
0xF0A3B1BF, 17910,
0xF0A3B480, 17925,
0xF0A3B580, 17942,
0xF0A3B7BA, 17943,
0xF0A3B7B9, 17944,
0xF0A3B793, 17945,
0xF0A3BDBE, 17983,
0xF0A48296, 17998,
0xF0A48483, 18003,
0xF0A48786, 18015,
0xF0A487BE, 18018,
0xF0A48EBC, 18039,
0xF0A498A9, 18049,
0xF0A49AA5, 18055,
0xF0A4A296, 18077,
0xF0A4A98D, 18104,
0xF0A4AD96, 18117,
0xF0A4ADAF, 18119,
0xF0A4B096, 18124,
0xF0A4B88E, 18158,
0xF0A4B8B7, 18162,
0xF0A4B9AA, 18167,
0xF0A4BA8B, 18170,
0xF0A5818A, 18181,
0xF0A58195, 18183,
0xF0A584A2, 18185,
0xF0A586A9, 18190,
0xF0A587A5, 18192,
0xF0A5878D, 18193,
0xF0A5889E, 18195,
0xF0A5898C, 18197,
0xF0A590AE, 18209,
0xF0A59399, 18217,
0xF0A596A7, 18229,
0xF0A59EA9, 18248,
0xF0A59EB4, 18249,
0xF0A5A794, 18268,
0xF0A5ABA4, 18276,
0xF0A5ABA3, 18277,
0xF0A5ABB1, 18278,
0xF0A5AEB2, 18293,
0xF0A5B18B, 18302,
0xF0A5B1A4, 18303,
0xF0A5B8AE, 18318,
0xF0A5B996, 18319,
0xF0A5B9A5, 18320,
0xF0A5B9A2, 18322,
0xF0A5BB98, 18325,
0xF0A5BB82, 18327,
0xF0A5BBA8, 18329,
0xF0A5BCA3, 18330,
0xF0A5BD9C, 18332,
0xF0A5BFA0, 18338,
0xF0A5BF94, 18339,
0xF0A6808C, 18344,
0xF0A5BFBB, 18345,
0xF0A68097, 18352,
0xF0A681A0, 18355,
0xF0A683AD, 18365,
0xF0A689B0, 18385,
0xF0A68A86, 18386,
0xF0A3B48E, 18394,
0xF0A69082, 18398,
0xF0A699BE, 18416,
0xF0A69C9D, 18430,
0xF0A6A39D, 18444,
0xF0A6A3AA, 18446,
0xF0A6A5AF, 18450,
0xF0A6A79D, 18452,
0xF0A6A89E, 18455,
0xF0A6A998, 18459,
0xF0A6AA8C, 18463,
0xF0A6AAB7, 18466,
0xF0A6B1B3, 18506,
0xF0A6B39D, 18515,
0xF0A6B9A5, 18528,
0xF0A6BE94, 18544,
0xF0A6BFB8, 18553,
0xF0A6BFB6, 18554,
0xF0A6BFB7, 18555,
0xF0A7848D, 18571,
0xF0A784B9, 18574,
0xF0A78F9B, 18610,
0xF0A78F9A, 18611,
0xF0A78FBE, 18617,
0xF0A79090, 18620,
0xF0A79189, 18624,
0xF0A79895, 18637,
0xF0A79894, 18638,
0xF0A798B1, 18640,
0xF0A79A93, 18645,
0xF0A79C8E, 18650,
0xF0A79CA3, 18652,
0xF0A79D92, 18656,
0xF0A7A685, 18672,
0xF0A7AA84, 18684,
0xF0A7AEB3, 18699,
0xF0A7AEBE, 18701,
0xF0A7AF87, 18702,
0xF0A7B2B8, 18708,
0xF0A7B6A0, 18716,
0xF0A7B890, 18718,
0xF0A8828A, 18727,
0xF0A882BB, 18733,
0xF0A88A82, 18745,
0xF0A88BB3, 18747,
0xF0A8908C, 18754,
0xF0A89195, 18757,
0xF0A895AB, 18770,
0xF0A89788, 18773,
0xF0A89789, 18774,
0xF0A89B97, 18784,
0xF0A89BBA, 18787,
0xF0A8A589, 18811,
0xF0A8A586, 18812,
0xF0A8A5AB, 18817,
0xF0A8A688, 18824,
0xF0A8A6BA, 18834,
0xF0A8A6BB, 18835,
0xF0A8A89E, 18843,
0xF0A8A8A9, 18844,
0xF0A8A9B1, 18847,
0xF0A8A983, 18848,
0xF0A8AA99, 18855,
0xF0A8AB8D, 18856,
0xF0A8ABA4, 18862,
0xF0A8AB9D, 18863,
0xF0A8AF81, 18874,
0xF0A8AFAF, 18875,
0xF0A8B490, 18882,
0xF0A8B5B1, 18883,
0xF0A8B7BB, 18885,
0xF0A8B89F, 18886,
0xF0A8B8B6, 18890,
0xF0A8BA89, 18893,
0xF0A8BBAB, 18895,
0xF0A8BCB2, 18897,
0xF0A8BFB8, 18903,
0xF0A98AA0, 18917,
0xF0A98AB1, 18918,
0xF0A99290, 18935,
0xF0A9978F, 18944,
0xF0A99BB0, 18959,
0xF0A99C99, 18962,
0xF0A99D90, 18966,
0xF0A9A386, 18983,
0xF0A9A9B2, 19001,
0xF0A9B79B, 19026,
0xF0A9B895, 19036,
0xF0A9BA8A, 19037,
0xF0A9B989, 19038,
0xF0A9BB84, 19046,
0xF0A9BBA9, 19051,
0xF0A9BB9B, 19054,
0xF0A9BF97, 19071,
0xF0AA80AF, 19075,
0xF0AA809A, 19077,
0xF0AA83B9, 19083,
0xF0AA8282, 19084,
0xF0A28898, 19105,
0xF0AA8E8C, 19109,
0xF0AA90B7, 19111,
0xF0AA97B1, 19123,
0xF0AA9882, 19125,
0xF0AA9AB2, 19129,
0xF0A083B5, 20057,
0xF0A4B884, 20058,
0xF0A4BFB2, 20059,
0xF0A7B5B3, 20060,
0xF0AFA095, 20061,
0xF0AFA186, 20062,
0xF0AFA299, 20063,
0xF0AFA2A6, 20064,
0xF0AFA3A5, 20065,
0xF0AFA79E, 20066,
0xF0AA8AB2, 20072,
0xF0A08598, 20075,
0xF0A096B1, 20080,
0xF0A09BAC, 20083,
0xF0A0B598, 20090,
0xF0A5A78C, 20112,
0xF0A2B982, 20124,
0xF0A2BFAB, 20130,
0xF0A7A6B4, 20133,
0xF0A4818B, 20168,
0xF0A6B29E, 20206,
0xF0A7B0BC, 20220,
0xF0A68D8C, 20311,
0xF0A9B8BD, 20315,
0xF0AA989A, 20316
};

/*
  surrogate pair ---> private region (Kino san)
*/
#define SRGNUM2 1651

typedef struct __srgtag2 {
unsigned int utfeight;
unsigned short ucs;
} __srg2;

__srg2 srgtab2[SRGNUM2] = {
0xF0A080A1, 0xEBD8,
0xF0A080BE, 0xE657,
0xF0A08186, 0xE658,
0xF0A0818E, 0xE764,
0xF0A081A8, 0xE375,
0xF0A08286, 0xF53D,
0xF0A08287, 0xF572,
0xF0A0828A, 0xF7E8,
0xF0A08294, 0xEABF,
0xF0A0838A, 0xF311,
0xF0A0838B, 0xF30E,
0xF0A0838C, 0xF7E6,
0xF0A0838D, 0xF30B,
0xF0A08391, 0xF30A,
0xF0A083AE, 0xEEAF,
0xF0A0848C, 0xF308,
0xF0A0848E, 0xF316,
0xF0A08498, 0xE185,
0xF0A086A9, 0xF488,
0xF0A086AB, 0xE5B7,
0xF0A08781, 0xE141,
0xF0A08794, 0xE73C,
0xF0A087B2, 0xEDED,
0xF0A08884, 0xE106,
0xF0A0888C, 0xE5C2,
0xF0A08894, 0xE975,
0xF0A0899B, 0xE744,
0xF0A089B4, 0xE4B4,
0xF0A089B5, 0xE5C0,
0xF0A08A99, 0xE735,
0xF0A08A9E, 0xE159,
0xF0A08AA0, 0xE014,
0xF0A08AB7, 0xEAC0,
0xF0A08ABF, 0xE871,
0xF0A08B80, 0xE5BE,
0xF0A08BA5, 0xE034,
0xF0A08C8A, 0xE5BA,
0xF0A08CA5, 0xF6AD,
0xF0A08D81, 0xF446,
0xF0A08D85, 0xE602,
0xF0A08D86, 0xEB46,
0xF0A08D87, 0xE023,
0xF0A08DBE, 0xE020,
0xF0A08DBF, 0xE5B2,
0xF0A08E80, 0xE022,
0xF0A08EA0, 0xEAC1,
0xF0A08EA7, 0xE8C1,
0xF0A08EB5, 0xE201,
0xF0A08F89, 0xE1EB,
0xF0A08F8B, 0xE5B8,
0xF0A08FB5, 0xE90C,
0xF0A08FBC, 0xEDD7,
0xF0A09093, 0xE624,
0xF0A09094, 0xE5BB,
0xF0A0909F, 0xE025,
0xF0A091A5, 0xE5B1,
0xF0A09287, 0xE02E,
0xF0A0928E, 0xED5F,
0xF0A09291, 0xE5E3,
0xF0A09292, 0xE5E2,
0xF0A092A3, 0xE5E1,
0xF0A09397, 0xEAC5,
0xF0A093BC, 0xF48E,
0xF0A093BE, 0xE8CB,
0xF0A09587, 0xE000,
0xF0A0968E, 0xE036,
0xF0A096A5, 0xE10B,
0xF0A096B3, 0xE03B,
0xF0A09783, 0xE2A1,
0xF0A0978A, 0xEB5B,
0xF0A09790, 0xF40A,
0xF0A09795, 0xEAC9,
0xF0A0979F, 0xE002,
0xF0A097A0, 0xE5DF,
0xF0A097AB, 0xE6DB,
0xF0A09891, 0xEB5D,
0xF0A09895, 0xEACA,
0xF0A09899, 0xE978,
0xF0A0989A, 0xE8D8,
0xF0A098B0, 0xE4E6,
0xF0A09996, 0xE175,
0xF0A099B6, 0xEACB,
0xF0A09C8E, 0xE5E6,
0xF0A09CB1, 0xF485,
0xF0A09DB9, 0xEB78,
0xF0A0A0AC, 0xE76C,
0xF0A0A1B3, 0xE5E9,
0xF0A0A395, 0xE977,
0xF0A0A496, 0xE762,
0xF0A0A4A3, 0xE1FA,
0xF0A0A594, 0xE060,
0xF0A0A5B9, 0xED42,
0xF0A0A7A7, 0xF3F0,
0xF0A0A891, 0xEBCD,
0xF0A0A990, 0xE45E,
0xF0A0AAB4, 0xE8F5,
0xF0A0AB82, 0xEACF,
0xF0A0AB8D, 0xEAD0,
0xF0A0AC8D, 0xE39E,
0xF0A0AE8F, 0xE087,
0xF0A0AEA8, 0xE5A7,
0xF0A0AEA9, 0xF4D2,
0xF0A0AEBF, 0xEAD1,
0xF0A0AF86, 0xE604,
0xF0A0AF8B, 0xEAD4,
0xF0A0AFA2, 0xE064,
0xF0A0AFAB, 0xE8D9,
0xF0A0AFBB, 0xEAD6,
0xF0A0AFBF, 0xE032,
0xF0A0B08B, 0xF45B,
0xF0A0B08D, 0xE73D,
0xF0A0B0A0, 0xE5EF,
0xF0A0B0B4, 0xF4C0,
0xF0A0B0BA, 0xE290,
0xF0A0B0BB, 0xEAD7,
0xF0A0B181, 0xECDB,
0xF0A0B182, 0xF440,
0xF0A0B183, 0xF481,
0xF0A0B193, 0xEAD8,
0xF0A0B1A5, 0xEAD9,
0xF0A0B1B7, 0xE08C,
0xF0A0B1B8, 0xEB74,
0xF0A0B1BC, 0xEADA,
0xF0A0B28D, 0xEADC,
0xF0A0B296, 0xECDC,
0xF0A0B29C, 0xEC80,
0xF0A0B2B5, 0xEADE,
0xF0A0B2B8, 0xE8DA,
0xF0A0B38F, 0xE9EF,
0xF0A0B393, 0xE131,
0xF0A0B394, 0xEDE1,
0xF0A0B395, 0xF456,
0xF0A0B396, 0xF505,
0xF0A0B39D, 0xEADF,
0xF0A0B3AD, 0xEAE0,
0xF0A0B3BF, 0xE8D6,
0xF0A0B495, 0xF441,
0xF0A0B4A8, 0xED88,
0xF0A0B4B1, 0xE48A,
0xF0A0B4B2, 0xE219,
0xF0A0B586, 0xF461,
0xF0A0B587, 0xF4CD,
0xF0A0B588, 0xF4D3,
0xF0A0B589, 0xECBA,
0xF0A0B58C, 0xE733,
0xF0A0B58D, 0xE09C,
0xF0A0B58E, 0xE0E2,
0xF0A0B5AF, 0xEAE1,
0xF0A0B5B1, 0xED8B,
0xF0A0B5B4, 0xE094,
0xF0A0B5BC, 0xF454,
0xF0A0B5BE, 0xF4DD,
0xF0A0B5BF, 0xF4DE,
0xF0A0B696, 0xF491,
0xF0A0B69C, 0xF49B,
0xF0A0B6A7, 0xECF5,
0xF0A0B6B2, 0xEAE2,
0xF0A0B788, 0xEAE3,
0xF0A0B884, 0xEAE7,
0xF0A0B889, 0xF4A5,
0xF0A0B88A, 0xED27,
0xF0A0B88D, 0xE5A8,
0xF0A0B88E, 0xEAE8,
0xF0A0B88F, 0xF4FF,
0xF0A0B890, 0xF509,
0xF0A0B891, 0xF518,
0xF0A0B896, 0xE3B1,
0xF0A0B89D, 0xE5F3,
0xF0A0B98C, 0xF4CF,
0xF0A0B9AD, 0xECA0,
0xF0A0B9B3, 0xEAEC,
0xF0A0B9B5, 0xE1B6,
0xF0A0B9B6, 0xECDF,
0xF0A0B9B7, 0xF500,
0xF0A0B9B8, 0xF50A,
0xF0A0B9B9, 0xF50F,
0xF0A0B9BA, 0xF4BF,
0xF0A0B9BB, 0xF51C,
0xF0A0BA8C, 0xF4C8,
0xF0A0BA96, 0xF45A,
0xF0A0BA98, 0xF4E2,
0xF0A0BA9D, 0xECCF,
0xF0A0BAA2, 0xECE1,
0xF0A0BAAA, 0xF4CA,
0xF0A0BAAB, 0xF4D1,
0xF0A0BAAC, 0xED17,
0xF0A0BAB6, 0xED62,
0xF0A0BB97, 0xEAE9,
0xF0A0BB98, 0xF6B0,
0xF0A0BB9D, 0xE09A,
0xF0A0BBB8, 0xEBF6,
0xF0A0BBB9, 0xED18,
0xF0A0BBBA, 0xF4FE,
0xF0A0BBBB, 0xF501,
0xF0A0BC9D, 0xE8A1,
0xF0A0BCA6, 0xE80C,
0xF0A0BCAD, 0xEAEB,
0xF0A0BCAE, 0xF4E4,
0xF0A0BCB0, 0xF4CC,
0xF0A0BCB1, 0xF4B2,
0xF0A0BCBB, 0xEE64,
0xF0A0BD8C, 0xF490,
0xF0A0BDA4, 0xF45C,
0xF0A0BE8D, 0xF4C9,
0xF0A0BE90, 0xEAEA,
0xF0A0BEAD, 0xF4D9,
0xF0A0BEB4, 0xF455,
0xF0A0BEB5, 0xF51B,
0xF0A0BEB6, 0xF51F,
0xF0A0BEBC, 0xEAEE,
0xF0A0BF9F, 0xE5A6,
0xF0A0BFAA, 0xECB9,
0xF0A0BFAB, 0xED1E,
0xF0A0BFAC, 0xED26,
0xF0A0BFAD, 0xED2A,
0xF0A18094, 0xE44D,
0xF0A1809D, 0xF513,
0xF0A1809E, 0xF514,
0xF0A1818F, 0xEAF1,
0xF0A1819C, 0xEAF0,
0xF0A181AF, 0xF47B,
0xF0A181B5, 0xECE5,
0xF0A181B6, 0xEAF2,
0xF0A181B7, 0xF479,
0xF0A181B8, 0xF50B,
0xF0A181BB, 0xEAF4,
0xF0A18288, 0xEAF5,
0xF0A18296, 0xEAF6,
0xF0A1829D, 0xF498,
0xF0A182B4, 0xE0AB,
0xF0A182BF, 0xEAF8,
0xF0A18380, 0xF4D4,
0xF0A18381, 0xED04,
0xF0A18387, 0xF4E3,
0xF0A18388, 0xF4A9,
0xF0A18389, 0xF508,
0xF0A1838F, 0xF4C3,
0xF0A18393, 0xEAF9,
0xF0A183A4, 0xE5F1,
0xF0A183B4, 0xF457,
0xF0A183B5, 0xF515,
0xF0A183B6, 0xF516,
0xF0A184AF, 0xEAFA,
0xF0A184BB, 0xEAFB,
0xF0A184BD, 0xF4D5,
0xF0A18585, 0xF3A1,
0xF0A18588, 0xF50C,
0xF0A1858F, 0xF4CE,
0xF0A18680, 0xF520,
0xF0A18687, 0xED2D,
0xF0A18799, 0xED13,
0xF0A188BC, 0xE0D0,
0xF0A1898F, 0xE0BC,
0xF0A189BC, 0xE4A3,
0xF0A18AA8, 0xE584,
0xF0A18AA9, 0xED75,
0xF0A18AB0, 0xE921,
0xF0A18BA3, 0xEAFE,
0xF0A18BBE, 0xEEA7,
0xF0A18C82, 0xE835,
0xF0A18C83, 0xE627,
0xF0A18C84, 0xE961,
0xF0A18C85, 0xE016,
0xF0A18CB6, 0xEB00,
0xF0A18CBA, 0xE145,
0xF0A18DB5, 0xEAFF,
0xF0A18DB6, 0xE2F0,
0xF0A18E8E, 0xE18F,
0xF0A18E98, 0xE925,
0xF0A18E9C, 0xE8FB,
0xF0A18F85, 0xEC10,
0xF0A18F86, 0xE585,
0xF0A18FAD, 0xEC2D,
0xF0A18FBE, 0xE583,
0xF0A19093, 0xE8A4,
0xF0A19096, 0xE0C5,
0xF0A190A4, 0xE8C2,
0xF0A190BF, 0xF5D7,
0xF0A19192, 0xE91C,
0xF0A19194, 0xE0C7,
0xF0A19195, 0xF50E,
0xF0A1928A, 0xE396,
0xF0A19297, 0xE23D,
0xF0A192B6, 0xE586,
0xF0A193A8, 0xE838,
0xF0A193BD, 0xE3A2,
0xF0A195B7, 0xEB02,
0xF0A19682, 0xE3F2,
0xF0A19696, 0xE074,
0xF0A1988A, 0xEC0C,
0xF0A19893, 0xE075,
0xF0A19899, 0xEB03,
0xF0A198BE, 0xE0DC,
0xF0A199A1, 0xE374,
0xF0A19A92, 0xE0DF,
0xF0A19AB8, 0xE0FD,
0xF0A19ABA, 0xEACC,
0xF0A19B80, 0xE580,
0xF0A19B81, 0xE2ED,
0xF0A19B82, 0xE8DF,
0xF0A19B93, 0xE4EF,
0xF0A19B95, 0xE0EC,
0xF0A19B9F, 0xE436,
0xF0A19BA6, 0xE72F,
0xF0A19BA7, 0xE295,
0xF0A19BA8, 0xE06C,
0xF0A19BBA, 0xE610,
0xF0A19BBB, 0xE579,
0xF0A19BBC, 0xE686,
0xF0A19BBE, 0xE63C,
0xF0A19C8D, 0xE099,
0xF0A19C90, 0xE612,
0xF0A19CA6, 0xE066,
0xF0A19CBA, 0xE93A,
0xF0A19CBB, 0xE648,
0xF0A19CBC, 0xE948,
0xF0A19D97, 0xE87D,
0xF0A19DAC, 0xED81,
0xF0A19DAD, 0xEDC6,
0xF0A19DAE, 0xE737,
0xF0A19DAF, 0xE611,
0xF0A19DB0, 0xE187,
0xF0A19DB1, 0xE136,
0xF0A19DB3, 0xE3A8,
0xF0A19DB4, 0xE57C,
0xF0A19EAB, 0xE646,
0xF0A19EB0, 0xE752,
0xF0A19EB1, 0xEBFB,
0xF0A19EB2, 0xE0E8,
0xF0A19EB3, 0xE941,
0xF0A19EB4, 0xE3B2,
0xF0A19EB5, 0xE894,
0xF0A19F83, 0xEB04,
0xF0A19F87, 0xEB05,
0xF0A19F99, 0xE8BF,
0xF0A19F9A, 0xE7CE,
0xF0A19F9B, 0xE93E,
0xF0A19F9C, 0xE0E5,
0xF0A19F9F, 0xE96F,
0xF0A19FAF, 0xE570,
0xF0A19FB5, 0xEC91,
0xF0A19FB6, 0xECA7,
0xF0A19FB8, 0xE577,
0xF0A19FB9, 0xE360,
0xF0A19FBA, 0xE8DD,
0xF0A19FBB, 0xE0E7,
0xF0A19FBC, 0xE190,
0xF0A1A0A0, 0xEBFE,
0xF0A1A0A8, 0xE0EB,
0xF0A1A0A9, 0xE1AA,
0xF0A1A0AA, 0xE68B,
0xF0A1A0AD, 0xEB08,
0xF0A1A0B9, 0xE57A,
0xF0A1A0BA, 0xF524,
0xF0A1A0BB, 0xEE30,
0xF0A1A180, 0xE790,
0xF0A1A185, 0xE7B8,
0xF0A1A192, 0xE8E1,
0xF0A1A19E, 0xE398,
0xF0A1A1A1, 0xE61B,
0xF0A1A1A2, 0xE8F2,
0xF0A1A1A3, 0xE514,
0xF0A1A1A4, 0xE707,
0xF0A1A1B7, 0xE15D,
0xF0A1A1BB, 0xECA8,
0xF0A1A283, 0xE8E9,
0xF0A1A284, 0xE5DB,
0xF0A1A285, 0xE575,
0xF0A1A29E, 0xE2B8,
0xF0A1A29F, 0xE8B6,
0xF0A1A2A0, 0xE63A,
0xF0A1A2A1, 0xE792,
0xF0A1A2A2, 0xE3F8,
0xF0A1A2BE, 0xE572,
0xF0A1A2BF, 0xE8E8,
0xF0A1A391, 0xE57D,
0xF0A1A396, 0xE8A0,
0xF0A1A397, 0xE0A6,
0xF0A1A398, 0xE794,
0xF0A1A399, 0xE67C,
0xF0A1A3BA, 0xE55C,
0xF0A1A483, 0xE637,
0xF0A1A484, 0xE638,
0xF0A1A485, 0xE944,
0xF0A1A490, 0xE444,
0xF0A1A491, 0xE0FB,
0xF0A1A492, 0xE6B2,
0xF0A1A495, 0xE4B9,
0xF0A1A49C, 0xEBAB,
0xF0A1A4A2, 0xE59A,
0xF0A1A4A7, 0xE645,
0xF0A1A4BB, 0xE52B,
0xF0A1A584, 0xEEA6,
0xF0A1A598, 0xE202,
0xF0A1A5AA, 0xEB09,
0xF0A1A5BC, 0xE633,
0xF0A1A680, 0xF58E,
0xF0A1A683, 0xE038,
0xF0A1A688, 0xE2BA,
0xF0A1A696, 0xE632,
0xF0A1A79B, 0xE00C,
0xF0A1A7B3, 0xE61A,
0xF0A1A8AD, 0xEB0A,
0xF0A1A8B4, 0xE109,
0xF0A1A985, 0xEB0B,
0xF0A1A98B, 0xE2BF,
0xF0A1AD84, 0xE110,
0xF0A1AF81, 0xF53A,
0xF0A1AF82, 0xEAA9,
0xF0A1B0AA, 0xEB0C,
0xF0A1B1B0, 0xEB0D,
0xF0A1B2A2, 0xED1A,
0xF0A1B2A5, 0xE114,
0xF0A1B2AC, 0xEB0E,
0xF0A1B586, 0xEE60,
0xF0A1B690, 0xEB9B,
0xF0A1B6B6, 0xF5B0,
0xF0A1B6BA, 0xE640,
0xF0A1B78A, 0xF409,
0xF0A1B791, 0xED91,
0xF0A1B7AB, 0xE697,
0xF0A1B7B9, 0xE11C,
0xF0A1B89C, 0xE2E2,
0xF0A1B8B7, 0xE11D,
0xF0A1B8BD, 0xE1BB,
0xF0A1BA89, 0xE47F,
0xF0A1BAA4, 0xE121,
0xF0A1BAA8, 0xEB5F,
0xF0A1BB88, 0xEB0F,
0xF0A1BB95, 0xEB11,
0xF0A1BC8F, 0xED8E,
0xF0A1BC95, 0xEB12,
0xF0A1BDAA, 0xE155,
0xF0A1BE9E, 0xE97A,
0xF0A1BEA1, 0xEC42,
0xF0A1BFA8, 0xF30F,
0xF0A28185, 0xEB15,
0xF0A28189, 0xE127,
0xF0A281BE, 0xF5A0,
0xF0A2829A, 0xEB50,
0xF0A28387, 0xF4B0,
0xF0A283BC, 0xE033,
0xF0A284AA, 0xE1F0,
0xF0A2859B, 0xE528,
0xF0A285B3, 0xE128,
0xF0A285BA, 0xEBEE,
0xF0A286A1, 0xF483,
0xF0A28783, 0xEB6B,
0xF0A28888, 0xF4BC,
0xF0A289BC, 0xEB18,
0xF0A28CA1, 0xE7CA,
0xF0A28CA5, 0xE46A,
0xF0A28EBD, 0xE922,
0xF0A28F90, 0xE148,
0xF0A28F97, 0xEB19,
0xF0A28FBA, 0xEB1A,
0xF0A291A5, 0xED45,
0xF0A291B1, 0xE14A,
0xF0A2928B, 0xE20A,
0xF0A29291, 0xE21C,
0xF0A292B0, 0xEC84,
0xF0A293AD, 0xE018,
0xF0A29493, 0xE01E,
0xF0A2949B, 0xEE34,
0xF0A294B0, 0xE035,
0xF0A29594, 0xE0F9,
0xF0A2968D, 0xEBE7,
0xF0A296AF, 0xE652,
0xF0A296BE, 0xE653,
0xF0A2989B, 0xE659,
0xF0A2989C, 0xE301,
0xF0A298AB, 0xE64F,
0xF0A299A8, 0xE157,
0xF0A299BA, 0xE4A1,
0xF0A29A96, 0xF4D7,
0xF0A29A98, 0xE09E,
0xF0A29BB4, 0xED0C,
0xF0A29BB5, 0xE740,
0xF0A29BB6, 0xE391,
0xF0A29C92, 0xF5B4,
0xF0A29C94, 0xE386,
0xF0A29C9B, 0xEBB4,
0xF0A29C9F, 0xE83A,
0xF0A29CAA, 0xEB1B,
0xF0A29DB5, 0xF49E,
0xF0A29E81, 0xE841,
0xF0A29EB4, 0xE162,
0xF0A29EB5, 0xF507,
0xF0A29F8D, 0xE1FE,
0xF0A2A083, 0xF4C4,
0xF0A2A19F, 0xE179,
0xF0A2A1A0, 0xE64E,
0xF0A2A1B1, 0xEB1C,
0xF0A2A2AD, 0xE2A4,
0xF0A2A381, 0xE180,
0xF0A2A3B7, 0xE1C1,
0xF0A2A4A6, 0xEBF9,
0xF0A2A4B9, 0xF4C5,
0xF0A2A58F, 0xEB1D,
0xF0A2A5A7, 0xEB1F,
0xF0A2A5AB, 0xE842,
0xF0A2A680, 0xE17F,
0xF0A2A693, 0xEB20,
0xF0A2A9A6, 0xF497,
0xF0A2AB8F, 0xF4A6,
0xF0A2AB95, 0xEB21,
0xF0A2ABA6, 0xF40B,
0xF0A2ABA8, 0xEB23,
0xF0A2AC8E, 0xEB25,
0xF0A2ACA2, 0xE665,
0xF0A2ACBF, 0xEB27,
0xF0A2AD83, 0xECF0,
0xF0A2ADAA, 0xE663,
0xF0A2AF8A, 0xF478,
0xF0A2AF8E, 0xF4DC,
0xF0A2B0A6, 0xE8A6,
0xF0A2B0A7, 0xE3FF,
0xF0A2B0B8, 0xF44D,
0xF0A2B18C, 0xEB2A,
0xF0A2B191, 0xF4DF,
0xF0A2B195, 0xF4E0,
0xF0A2B1A2, 0xECE0,
0xF0A2B288, 0xEB2C,
0xF0A2B29B, 0xE65D,
0xF0A2B2A1, 0xE671,
0xF0A2B2A9, 0xF45D,
0xF0A2B2B2, 0xF4B3,
0xF0A2B2B7, 0xEB2D,
0xF0A2B382, 0xF466,
0xF0A2B386, 0xF444,
0xF0A2B389, 0xF4A7,
0xF0A2B487, 0xE65E,
0xF0A2B488, 0xEB2F,
0xF0A2B492, 0xEB30,
0xF0A2B584, 0xF46F,
0xF0A2B58C, 0xF477,
0xF0A2B5A7, 0xE66F,
0xF0A2B68D, 0xF48B,
0xF0A2B695, 0xEB32,
0xF0A2B6A0, 0xED22,
0xF0A2B6A3, 0xE08A,
0xF0A2B6A4, 0xF511,
0xF0A2B6B7, 0xEB31,
0xF0A2B7AE, 0xF4F3,
0xF0A2B88D, 0xE189,
0xF0A2B8B6, 0xE193,
0xF0A2B982, 0xEB33,
0xF0A2B9B8, 0xE668,
0xF0A2BA8B, 0xF4BB,
0xF0A2BAB3, 0xECF2,
0xF0A2BBAF, 0xE3CD,
0xF0A2BDB4, 0xEB34,
0xF0A2BF8C, 0xEB35,
0xF0A2BFA3, 0xE920,
0xF0A380B3, 0xEB36,
0xF0A38184, 0xE282,
0xF0A3818B, 0xE237,
0xF0A381A6, 0xEB37,
0xF0A381BD, 0xE50F,
0xF0A381BE, 0xE1A4,
0xF0A3828E, 0xE676,
0xF0A382B7, 0xE4CD,
0xF0A382BC, 0xE4CE,
0xF0A3839A, 0xED71,
0xF0A38483, 0xE68A,
0xF0A384BD, 0xF534,
0xF0A385BD, 0xE3B4,
0xF0A38682, 0xE68F,
0xF0A386A4, 0xE1B3,
0xF0A386A5, 0xE1B4,
0xF0A386B3, 0xE680,
0xF0A38788, 0xE1BE,
0xF0A38789, 0xE87E,
0xF0A387B7, 0xE1B0,
0xF0A387B8, 0xE1B1,
0xF0A387B9, 0xE21B,
0xF0A3888F, 0xE68E,
0xF0A388A5, 0xE7EB,
0xF0A388AF, 0xEC2E,
0xF0A388B1, 0xE1BC,
0xF0A388B2, 0xE70C,
0xF0A388B3, 0xE037,
0xF0A388B4, 0xE68C,
0xF0A389A2, 0xE465,
0xF0A38A81, 0xF58B,
0xF0A38A89, 0xE67F,
0xF0A38A8A, 0xE0AE,
0xF0A38AAB, 0xE679,
0xF0A38AAC, 0xE2E9,
0xF0A38AAD, 0xE677,
0xF0A38B92, 0xE699,
0xF0A38BA0, 0xE67B,
0xF0A38BA1, 0xE69A,
0xF0A38C80, 0xE974,
0xF0A38C8A, 0xE4BA,
0xF0A38C9F, 0xEB38,
0xF0A38EB4, 0xE030,
0xF0A38F8C, 0xEB93,
0xF0A38F9E, 0xEB39,
0xF0A38FA6, 0xE1D4,
0xF0A38FB4, 0xF4DA,
0xF0A38FB5, 0xEE56,
0xF0A38FB9, 0xF5B6,
0xF0A38FBA, 0xE92B,
0xF0A38FBE, 0xE6A2,
0xF0A39080, 0xE1AE,
0xF0A390BF, 0xE775,
0xF0A39190, 0xE666,
0xF0A391AF, 0xE1D7,
0xF0A391B2, 0xE641,
0xF0A393A5, 0xE926,
0xF0A39499, 0xEBDD,
0xF0A394B0, 0xE3A7,
0xF0A3959A, 0xE3B5,
0xF0A395A7, 0xEB3E,
0xF0A39695, 0xE5D7,
0xF0A39699, 0xE573,
0xF0A3969C, 0xE869,
0xF0A3978D, 0xE1DD,
0xF0A3978E, 0xE3BD,
0xF0A3978F, 0xE765,
0xF0A397B3, 0xEB3F,
0xF0A39880, 0xE01C,
0xF0A3989A, 0xEB43,
0xF0A398BC, 0xE1E2,
0xF0A39980, 0xE86A,
0xF0A39999, 0xE1EF,
0xF0A3999F, 0xE6DE,
0xF0A399B7, 0xEEAE,
0xF0A39AA6, 0xE588,
0xF0A39AAD, 0xE92E,
0xF0A39ABA, 0xECBB,
0xF0A39B9F, 0xE928,
0xF0A39BAE, 0xE592,
0xF0A39C83, 0xE1F2,
0xF0A39C96, 0xEB44,
0xF0A39CA0, 0xED54,
0xF0A39CAD, 0xE04C,
0xF0A39CAF, 0xEC0E,
0xF0A39CBF, 0xE59D,
0xF0A39DA6, 0xE377,
0xF0A39E81, 0xE711,
0xF0A39EA2, 0xE6A1,
0xF0A39EBC, 0xE69F,
0xF0A39F82, 0xE1C8,
0xF0A39F95, 0xE6AC,
0xF0A39F96, 0xE92A,
0xF0A39F97, 0xE866,
0xF0A3A0BA, 0xE69E,
0xF0A3A782, 0xF4AA,
0xF0A3AAA7, 0xEB4A,
0xF0A3AB9B, 0xE200,
0xF0A3ABAE, 0xE634,
0xF0A3ABBA, 0xE973,
0xF0A3AD9A, 0xE205,
0xF0A3B1A3, 0xF5B9,
0xF0A3B299, 0xE03C,
0xF0A3B29A, 0xE6BA,
0xF0A3B29B, 0xE487,
0xF0A3B2B5, 0xE3D5,
0xF0A3B2B7, 0xEC99,
0xF0A3B387, 0xEEA2,
0xF0A3B388, 0xE00E,
0xF0A3B389, 0xE216,
0xF0A3B3BC, 0xED15,
0xF0A3B3BD, 0xEDDB,
0xF0A3B3BE, 0xED4A,
0xF0A3B3BF, 0xEB61,
0xF0A3B580, 0xECB6,
0xF0A3B59B, 0xE8ED,
0xF0A3B5BE, 0xE3A0,
0xF0A3B68F, 0xE797,
0xF0A3B6B6, 0xED51,
0xF0A3B6B7, 0xE8A9,
0xF0A3B6B8, 0xE83B,
0xF0A3B6B9, 0xE40A,
0xF0A3B6BA, 0xE736,
0xF0A3B6BB, 0xE463,
0xF0A3B6BC, 0xE210,
0xF0A3B6BD, 0xE212,
0xF0A3B7A3, 0xE389,
0xF0A3B7B8, 0xE3A9,
0xF0A3B891, 0xEB4D,
0xF0A3B8AC, 0xED58,
0xF0A3B8AD, 0xE908,
0xF0A3B8AE, 0xE4A4,
0xF0A3B8AF, 0xE231,
0xF0A3B8B0, 0xE23B,
0xF0A3B8B1, 0xE58D,
0xF0A3B8B9, 0xE5D8,
0xF0A3BA88, 0xECA3,
0xF0A3BA89, 0xE5DC,
0xF0A3BA8A, 0xE5C9,
0xF0A3BA8B, 0xE3B9,
0xF0A3BAB9, 0xEB4E,
0xF0A3BABF, 0xE5D9,
0xF0A3BB97, 0xE311,
0xF0A3BBB7, 0xED57,
0xF0A3BBB8, 0xE6DD,
0xF0A3BBB9, 0xE952,
0xF0A3BBBA, 0xE72B,
0xF0A3BBBB, 0xE58F,
0xF0A3BBBC, 0xE207,
0xF0A3BCB5, 0xE6E6,
0xF0A3BD81, 0xF69E,
0xF0A3BD8A, 0xEB80,
0xF0A3BDBF, 0xE6C7,
0xF0A3BE80, 0xE05F,
0xF0A3BE81, 0xEC3C,
0xF0A3BE82, 0xE233,
0xF0A3BE8F, 0xE426,
0xF0A3BEB4, 0xE24E,
0xF0A3BEB7, 0xE178,
0xF0A3BF80, 0xE6B9,
0xF0A3BF85, 0xE003,
0xF0A3BFAB, 0xE089,
0xF0A3BFAC, 0xE061,
0xF0A3BFAD, 0xE907,
0xF0A3BFAE, 0xE7F3,
0xF0A3BFAF, 0xEBAF,
0xF0A3BFB0, 0xE24D,
0xF0A48091, 0xEE91,
0xF0A480B9, 0xE24C,
0xF0A480BA, 0xE0A7,
0xF0A480BB, 0xEB57,
0xF0A480BC, 0xE6CA,
0xF0A480BD, 0xE23E,
0xF0A48197, 0xE35B,
0xF0A48285, 0xE227,
0xF0A4828B, 0xE59F,
0xF0A4828C, 0xE195,
0xF0A4828D, 0xE5FC,
0xF0A48291, 0xE24A,
0xF0A48389, 0xE600,
0xF0A483A1, 0xE59E,
0xF0A48484, 0xE851,
0xF0A4848F, 0xE5A0,
0xF0A48499, 0xEB53,
0xF0A484BF, 0xE24F,
0xF0A48580, 0xE253,
0xF0A48584, 0xE248,
0xF0A4858E, 0xF57D,
0xF0A48595, 0xE24B,
0xF0A48596, 0xE251,
0xF0A48597, 0xE252,
0xF0A4859C, 0xE4E7,
0xF0A4859F, 0xE2B3,
0xF0A485B7, 0xF525,
0xF0A485BA, 0xEC1D,
0xF0A486A3, 0xED0E,
0xF0A486A4, 0xE213,
0xF0A486A5, 0xE0BE,
0xF0A486AC, 0xE88F,
0xF0A486B5, 0xE887,
0xF0A4878D, 0xE1CC,
0xF0A487A2, 0xE294,
0xF0A487BC, 0xE945,
0xF0A4889B, 0xE808,
0xF0A4898B, 0xE516,
0xF0A48996, 0xE960,
0xF0A48999, 0xE957,
0xF0A489B6, 0xE6D2,
0xF0A489B7, 0xE261,
0xF0A489B8, 0xE0D5,
0xF0A48A84, 0xE7B4,
0xF0A48A93, 0xE950,
0xF0A48A95, 0xE61C,
0xF0A48AA5, 0xE94D,
0xF0A48B81, 0xE26B,
0xF0A48B89, 0xE690,
0xF0A48B8A, 0xE955,
0xF0A48BAE, 0xEB55,
0xF0A48BBA, 0xE8A5,
0xF0A48C8D, 0xEB56,
0xF0A48C9A, 0xE6D1,
0xF0A48CB4, 0xEB58,
0xF0A48D88, 0xE558,
0xF0A48DA2, 0xE91E,
0xF0A48DA3, 0xE0C8,
0xF0A48DA4, 0xE537,
0xF0A48DA5, 0xE268,
0xF0A48E8C, 0xE5EE,
0xF0A48E96, 0xEB59,
0xF0A48E9C, 0xE1C4,
0xF0A48EBD, 0xE95E,
0xF0A48F81, 0xE8A7,
0xF0A48FA9, 0xE964,
0xF0A48FAA, 0xE7E9,
0xF0A48FB2, 0xED72,
0xF0A48FB8, 0xE56E,
0xF0A49084, 0xEB62,
0xF0A490B5, 0xE0A9,
0xF0A490B6, 0xE5AF,
0xF0A4919A, 0xE26D,
0xF0A4919B, 0xE954,
0xF0A491B3, 0xE56D,
0xF0A49287, 0xE6AD,
0xF0A49288, 0xE89A,
0xF0A492B9, 0xE567,
0xF0A492BC, 0xE130,
0xF0A4938E, 0xE95C,
0xF0A49393, 0xF45F,
0xF0A49396, 0xEB63,
0xF0A49485, 0xF5BD,
0xF0A494A1, 0xEBBC,
0xF0A495B8, 0xE348,
0xF0A49788, 0xF48D,
0xF0A49898, 0xED3B,
0xF0A498AA, 0xE6A6,
0xF0A499A5, 0xE662,
0xF0A499B4, 0xEB65,
0xF0A49A97, 0xE710,
0xF0A49B94, 0xE65F,
0xF0A49C86, 0xED07,
0xF0A49CA5, 0xE6D8,
0xF0A49CAF, 0xEB67,
0xF0A49E8F, 0xE6D7,
0xF0A49FA0, 0xED24,
0xF0A4A092, 0xEB6F,
0xF0A4A0A3, 0xE288,
0xF0A4A282, 0xE345,
0xF0A4A3A9, 0xF54E,
0xF0A4A3B0, 0xE713,
0xF0A4A3B1, 0xE20B,
0xF0A4A3B2, 0xE991,
0xF0A4A3B3, 0xE702,
0xF0A4A3BB, 0xEB70,
0xF0A4A3BF, 0xE7E7,
0xF0A4A480, 0xE215,
0xF0A4A481, 0xE126,
0xF0A4A48C, 0xE214,
0xF0A4A496, 0xE8C5,
0xF0A4A497, 0xE6E0,
0xF0A4A499, 0xEDDD,
0xF0A4A4AF, 0xE7D1,
0xF0A4A4B3, 0xE012,
0xF0A4A4B4, 0xEBBF,
0xF0A4A4BE, 0xEDA6,
0xF0A4A4BF, 0xEB8F,
0xF0A4A580, 0xE1A6,
0xF0A4A581, 0xE87F,
0xF0A4A582, 0xE009,
0xF0A4A583, 0xE8D5,
0xF0A4A5A2, 0xE769,
0xF0A4A5A3, 0xED77,
0xF0A4A5B4, 0xE27D,
0xF0A4A5B5, 0xE554,
0xF0A4A5B6, 0xE8C7,
0xF0A4A5BB, 0xF5E4,
0xF0A4A5BF, 0xE226,
0xF0A4A682, 0xE168,
0xF0A4A688, 0xEC37,
0xF0A4A689, 0xE678,
0xF0A4A68A, 0xE44E,
0xF0A4A68B, 0xE8AF,
0xF0A4A68C, 0xE734,
0xF0A4A68D, 0xE29A,
0xF0A4A68E, 0xE6FC,
0xF0A4A68F, 0xE169,
0xF0A4A694, 0xE58B,
0xF0A4A6A4, 0xE02D,
0xF0A4A6A7, 0xE3A6,
0xF0A4A6A9, 0xE0F2,
0xF0A4A6AB, 0xE6FB,
0xF0A4A6AC, 0xE5F0,
0xF0A4A6AD, 0xE8E6,
0xF0A4A6B7, 0xE299,
0xF0A4A6B8, 0xE837,
0xF0A4A6B9, 0xE8AE,
0xF0A4A6BA, 0xEB41,
0xF0A4A6BB, 0xE555,
0xF0A4A785, 0xE701,
0xF0A4A790, 0xEBF2,
0xF0A4A79A, 0xF523,
0xF0A4A79E, 0xE86C,
0xF0A4A79F, 0xE18B,
0xF0A4A7A3, 0xE66E,
0xF0A4A7A5, 0xE8C3,
0xF0A4A7AC, 0xE6C5,
0xF0A4A7AD, 0xE7F1,
0xF0A4A7B6, 0xEBAD,
0xF0A4A7B7, 0xE777,
0xF0A4A7B8, 0xE557,
0xF0A4A7B9, 0xE751,
0xF0A4A7BB, 0xE29B,
0xF0A4A88E, 0xE5C8,
0xF0A4A892, 0xE2F1,
0xF0A4A893, 0xF5C0,
0xF0A4A895, 0xEB71,
0xF0A4A8A1, 0xE1C5,
0xF0A4A8A2, 0xE26F,
0xF0A4A8A3, 0xE1A0,
0xF0A4A8A4, 0xE296,
0xF0A4A8A5, 0xE582,
0xF0A4A8A6, 0xE29F,
0xF0A4A8A7, 0xE26E,
0xF0A4A8A8, 0xE19F,
0xF0A4A8A9, 0xE4F6,
0xF0A4A8AA, 0xEBFD,
0xF0A4A8BE, 0xE8BD,
0xF0A4A982, 0xE7E8,
0xF0A4A985, 0xEB5A,
0xF0A4A98A, 0xE6DF,
0xF0A4A98E, 0xE6FF,
0xF0A4A98F, 0xE968,
0xF0A4A990, 0xE8E0,
0xF0A4A991, 0xE559,
0xF0A4A99D, 0xE96E,
0xF0A4A9A5, 0xE39A,
0xF0A4A9A6, 0xE8C0,
0xF0A4A9A7, 0xE817,
0xF0A4A9B1, 0xE91F,
0xF0A4A9B7, 0xEE15,
0xF0A4A9B8, 0xE7F2,
0xF0A4A9B9, 0xE2B4,
0xF0A4A9BA, 0xE432,
0xF0A4AA8C, 0xE2B2,
0xF0A4AA93, 0xEC86,
0xF0A4AA94, 0xE8BE,
0xF0A4AA95, 0xE39B,
0xF0A4AA96, 0xE71A,
0xF0A4AAA4, 0xE6DA,
0xF0A4AAA5, 0xEC3B,
0xF0A4AAA6, 0xE045,
0xF0A4AAA7, 0xEB81,
0xF0A4AAB1, 0xE01D,
0xF0A4AAB2, 0xE80F,
0xF0A4AAB3, 0xE8B8,
0xF0A4AABA, 0xE717,
0xF0A4AABB, 0xEE2A,
0xF0A4AABC, 0xE5FB,
0xF0A4AB80, 0xEB73,
0xF0A4AB87, 0xE718,
0xF0A4AB8A, 0xEC63,
0xF0A4AB91, 0xE4B8,
0xF0A4AB9F, 0xE6E4,
0xF0A4ABA2, 0xED8A,
0xF0A4ABA9, 0xE4C1,
0xF0A4ADAE, 0xED3D,
0xF0A4AFB5, 0xE0CA,
0xF0A4B089, 0xE7C4,
0xF0A4B29E, 0xECA4,
0xF0A4B29F, 0xE92C,
0xF0A4B389, 0xE448,
0xF0A4B399, 0xE6F2,
0xF0A4B486, 0xE6F3,
0xF0A4B493, 0xE2C9,
0xF0A4B6B8, 0xF448,
0xF0A4B7AA, 0xF452,
0xF0A4B7AB, 0xF503,
0xF0A4B8BB, 0xF4B7,
0xF0A4B990, 0xF510,
0xF0A4BAA5, 0xEB76,
0xF0A4BAA7, 0xF465,
0xF0A4BC8E, 0xEEB1,
0xF0A4BD9C, 0xE9B0,
0xF0A4BE82, 0xE2C7,
0xF0A4BE86, 0xEB77,
0xF0A4BE97, 0xE892,
0xF0A4BE9A, 0xEBA3,
0xF0A4BEA9, 0xED4D,
0xF0A4BEB8, 0xE394,
0xF0A4BF82, 0xED1C,
0xF0A580AC, 0xEB7A,
0xF0A58192, 0xF480,
0xF0A5829D, 0xE2E0,
0xF0A584AB, 0xF442,
0xF0A58588, 0xECDE,
0xF0A585BD, 0xE2E1,
0xF0A585BE, 0xF51D,
0xF0A5878D, 0xF581,
0xF0A587A3, 0xF4C7,
0xF0A587A6, 0xE1B8,
0xF0A587A7, 0xE70A,
0xF0A588A0, 0xE2E7,
0xF0A588A1, 0xE709,
0xF0A58990, 0xE154,
0xF0A58A99, 0xEB7E,
0xF0A58B87, 0xF46C,
0xF0A58B98, 0xF521,
0xF0A58C8E, 0xE330,
0xF0A58C91, 0xECAD,
0xF0A58C93, 0xE1BF,
0xF0A59099, 0xEB7F,
0xF0A590A5, 0xE688,
0xF0A590AF, 0xE576,
0xF0A590B0, 0xE42C,
0xF0A59186, 0xEB83,
0xF0A591AC, 0xE4D6,
0xF0A591AE, 0xEB84,
0xF0A594B1, 0xEEA5,
0xF0A594B5, 0xE9CB,
0xF0A594BF, 0xEB88,
0xF0A5959B, 0xE687,
0xF0A5959C, 0xE58E,
0xF0A5959D, 0xE878,
0xF0A5959E, 0xEB8A,
0xF0A595A2, 0xEB8C,
0xF0A595A5, 0xE42D,
0xF0A595A6, 0xEB8D,
0xF0A59681, 0xE71D,
0xF0A59684, 0xE683,
0xF0A5968F, 0xE685,
0xF0A596B9, 0xE484,
0xF0A59795, 0xE8D1,
0xF0A5979B, 0xE489,
0xF0A597A0, 0xE2F8,
0xF0A59885, 0xE27A,
0xF0A598B5, 0xEC9A,
0xF0A59991, 0xE5B5,
0xF0A59A83, 0xE7A2,
0xF0A59A95, 0xF5C5,
0xF0A59BA3, 0xE725,
0xF0A59BB6, 0xE98A,
0xF0A59C86, 0xE4E8,
0xF0A59C9D, 0xE196,
0xF0A59CA5, 0xE4FF,
0xF0A59CBD, 0xF52A,
0xF0A59DB2, 0xE07D,
0xF0A59F87, 0xEB8E,
0xF0A59F9F, 0xE7FC,
0xF0A59FA0, 0xE315,
0xF0A59FA1, 0xEBB6,
0xF0A5A197, 0xE306,
0xF0A5A19D, 0xEB90,
0xF0A5A1B2, 0xE69C,
0xF0A5A388, 0xE828,
0xF0A5A3A1, 0xE31B,
0xF0A5A483, 0xEB95,
0xF0A5A586, 0xE619,
0xF0A5A596, 0xEC9B,
0xF0A5A6AC, 0xE31F,
0xF0A5A78C, 0xE10A,
0xF0A5AA95, 0xED41,
0xF0A5AA9C, 0xE742,
0xF0A5AAAE, 0xEB98,
0xF0A5AAAF, 0xE741,
0xF0A5ABA9, 0xE76D,
0xF0A5ADB4, 0xF533,
0xF0A5AE89, 0xEB99,
0xF0A5AEB3, 0xE74D,
0xF0A5AEB4, 0xE335,
0xF0A5AF86, 0xE747,
0xF0A5AFA4, 0xE3CF,
0xF0A5AFA8, 0xEB2E,
0xF0A5B081, 0xE32C,
0xF0A5B086, 0xEB9A,
0xF0A5B0A1, 0xEDDA,
0xF0A5B18A, 0xECAB,
0xF0A5B1A5, 0xE33D,
0xF0A5B291, 0xE3E1,
0xF0A5B2A4, 0xF5C4,
0xF0A5B380, 0xE3E3,
0xF0A5B381, 0xE342,
0xF0A5B3BE, 0xE331,
0xF0A5B4A0, 0xE33B,
0xF0A5B4B0, 0xF583,
0xF0A5B583, 0xE76E,
0xF0A5B88E, 0xE770,
0xF0A5B989, 0xF4AF,
0xF0A5BA81, 0xEC9D,
0xF0A5BA82, 0xE75F,
0xF0A5BA83, 0xE621,
0xF0A5BAA6, 0xE74F,
0xF0A5BABC, 0xE74E,
0xF0A5BB97, 0xEEA3,
0xF0A5BB98, 0xECB4,
0xF0A5BC9A, 0xEE6A,
0xF0A5BD8B, 0xE57E,
0xF0A5BFA1, 0xE6E1,
0xF0A5BFA2, 0xEB4C,
0xF0A680A9, 0xE35C,
0xF0A68188, 0xED2C,
0xF0A681A4, 0xE867,
0xF0A68283, 0xE300,
0xF0A68297, 0xF48F,
0xF0A682A4, 0xE8AD,
0xF0A682A5, 0xF474,
0xF0A68482, 0xEB9F,
0xF0A684A1, 0xE364,
0xF0A68599, 0xEE48,
0xF0A6859A, 0xE365,
0xF0A6859B, 0xE8AC,
0xF0A6859C, 0xE75C,
0xF0A686AD, 0xEEAC,
0xF0A686AE, 0xE71B,
0xF0A686B2, 0xEBA2,
0xF0A6879D, 0xE254,
0xF0A68998, 0xEC9E,
0xF0A689A1, 0xE75B,
0xF0A689AA, 0xF553,
0xF0A689AB, 0xEEB7,
0xF0A68B90, 0xE36F,
0xF0A68CB5, 0xED85,
0xF0A68D8B, 0xF556,
0xF0A68D8C, 0xEEB4,
0xF0A68D91, 0xE372,
0xF0A68EBE, 0xE802,
0xF0A68FB5, 0xE2D4,
0xF0A68FB8, 0xE768,
0xF0A69082, 0xEBA5,
0xF0A69090, 0xE4B5,
0xF0A69091, 0xEBC7,
0xF0A69092, 0xE767,
0xF0A6918A, 0xEBA6,
0xF0A691A9, 0xEBD7,
0xF0A69284, 0xEBAA,
0xF0A69288, 0xEBAE,
0xF0A69289, 0xE37B,
0xF0A6928D, 0xE325,
0xF0A69298, 0xE393,
0xF0A69492, 0xEBB0,
0xF0A695B2, 0xF4F8,
0xF0A696A0, 0xE77A,
0xF0A696AD, 0xE778,
0xF0A696BF, 0xEBB2,
0xF0A69892, 0xF559,
0xF0A698A6, 0xE388,
0xF0A69AAF, 0xEC96,
0xF0A69AB1, 0xE5A4,
0xF0A69AB5, 0xEBB3,
0xF0A69B9A, 0xF47C,
0xF0A69BA8, 0xE38A,
0xF0A69BBC, 0xEBBD,
0xF0A69C96, 0xF47D,
0xF0A69D81, 0xE8AA,
0xF0A69E99, 0xEBC5,
0xF0A69EB3, 0xED53,
0xF0A69EB4, 0xE784,
0xF0A69F8C, 0xEE7C,
0xF0A6A09C, 0xF4C1,
0xF0A6A186, 0xEEB0,
0xF0A6A19E, 0xEBC8,
0xF0A6A1AE, 0xEBC6,
0xF0A6A288, 0xE147,
0xF0A6A28A, 0xECFC,
0xF0A6A293, 0xED0A,
0xF0A6A387, 0xEBCA,
0xF0A6A48E, 0xE2D9,
0xF0A6A491, 0xE2D8,
0xF0A6A4A6, 0xEBCE,
0xF0A6A4B9, 0xEBD0,
0xF0A6A591, 0xF55A,
0xF0A6A6A8, 0xE50D,
0xF0A6A6B5, 0xEC2C,
0xF0A6A7B2, 0xF451,
0xF0A6A7BA, 0xEBD3,
0xF0A6A8AD, 0xEBD5,
0xF0A6A8AE, 0xE291,
0xF0A6A8B4, 0xEBDA,
0xF0A6A982, 0xE786,
0xF0A6A991, 0xE789,
0xF0A6A992, 0xE39F,
0xF0A6AC85, 0xE3BB,
0xF0A6AC8A, 0xE3A5,
0xF0A6AC93, 0xE05A,
0xF0A6AC95, 0xF5EA,
0xF0A6ACA8, 0xE115,
0xF0A6AD90, 0xF4E6,
0xF0A6AD91, 0xE20C,
0xF0A6AD92, 0xEB85,
0xF0A6AD93, 0xE093,
0xF0A6AD9B, 0xEBDB,
0xF0A6ADB5, 0xE761,
0xF0A6AE82, 0xE85D,
0xF0A6AE96, 0xE3D8,
0xF0A6AE97, 0xE3BC,
0xF0A6AE9D, 0xEBDF,
0xF0A6AEB3, 0xE015,
0xF0A6AF80, 0xE918,
0xF0A6AFB7, 0xEBA8,
0xF0A6B0A1, 0xE5A1,
0xF0A6B180, 0xE891,
0xF0A6B1BE, 0xE0C3,
0xF0A6B1BF, 0xE336,
0xF0A6B280, 0xE93C,
0xF0A6B281, 0xE0E3,
0xF0A6B282, 0xE935,
0xF0A6B2A4, 0xEBE1,
0xF0A6B2B7, 0xE92F,
0xF0A6B2B8, 0xE4B3,
0xF0A6B2BD, 0xEBC2,
0xF0A6B380, 0xE8A3,
0xF0A6B383, 0xE382,
0xF0A6B391, 0xE77D,
0xF0A6B4A2, 0xED89,
0xF0A6B4A3, 0xEDD1,
0xF0A6B4A4, 0xE692,
0xF0A6B4A5, 0xE21F,
0xF0A6B4A6, 0xE933,
0xF0A6B4A7, 0xE4EE,
0xF0A6B4A8, 0xE95A,
0xF0A6B4A9, 0xE01A,
0xF0A6B4AA, 0xE0E4,
0xF0A6B591, 0xE934,
0xF0A6B5B4, 0xF5E8,
0xF0A6B6A0, 0xE1D5,
0xF0A6B6A1, 0xE220,
0xF0A6B6A2, 0xE543,
0xF0A6B6A3, 0xE3BA,
0xF0A6B6A4, 0xE860,
0xF0A6B6A5, 0xE3C3,
0xF0A6B6A6, 0xE0E9,
0xF0A6B6A7, 0xE78B,
0xF0A6B6AE, 0xEBE4,
0xF0A6B79C, 0xEEA9,
0xF0A6B7AA, 0xE6EE,
0xF0A6B7AB, 0xE221,
0xF0A6B7B0, 0xE862,
0xF0A6B880, 0xE865,
0xF0A6B885, 0xEE31,
0xF0A6B887, 0xEC26,
0xF0A6B892, 0xE85B,
0xF0A6B982, 0xE3CC,
0xF0A6B983, 0xE3DA,
0xF0A6B984, 0xE352,
0xF0A6B985, 0xE0EE,
0xF0A6B9AE, 0xE14D,
0xF0A6B9B2, 0xE228,
0xF0A6B9B7, 0xE3D9,
0xF0A6BA84, 0xE861,
0xF0A6BA99, 0xE3E7,
0xF0A6BB90, 0xED10,
0xF0A6BB91, 0xEE7E,
0xF0A6BB92, 0xE172,
0xF0A6BB93, 0xE313,
0xF0A6BB94, 0xE3C8,
0xF0A6BB95, 0xE4AB,
0xF0A6BB96, 0xE354,
0xF0A6BB97, 0xE46C,
0xF0A6BCA6, 0xE594,
0xF0A6BDB3, 0xE655,
0xF0A6BDB4, 0xE22A,
0xF0A6BE9F, 0xE2DE,
0xF0A6BEA1, 0xE0F8,
0xF0A6BEBE, 0xF5EB,
0xF0A6BF9E, 0xE936,
0xF0A6BF9F, 0xE85C,
0xF0A7808E, 0xF3FA,
0xF0A7818B, 0xEBE8,
0xF0A78192, 0xE590,
0xF0A78193, 0xE93D,
0xF0A78288, 0xE3F0,
0xF0A782AD, 0xEEAA,
0xF0A782AE, 0xED7A,
0xF0A782AF, 0xEC17,
0xF0A7838D, 0xE3F3,
0xF0A783B8, 0xE156,
0xF0A78489, 0xE938,
0xF0A7848C, 0xE451,
0xF0A7848D, 0xF5E6,
0xF0A784A6, 0xE30C,
0xF0A784A7, 0xE77C,
0xF0A785A4, 0xED86,
0xF0A785A5, 0xE58C,
0xF0A785B5, 0xE4E4,
0xF0A7878D, 0xEBE9,
0xF0A7889B, 0xE78D,
0xF0A78A80, 0xEBEB,
0xF0A78A85, 0xEBEC,
0xF0A78A8B, 0xEBEF,
0xF0A78AB2, 0xED52,
0xF0A78AB6, 0xED11,
0xF0A78BA6, 0xEBF1,
0xF0A78E9A, 0xE3FA,
0xF0A790A2, 0xE799,
0xF0A79190, 0xEBF5,
0xF0A79284, 0xE8EA,
0xF0A79286, 0xEE76,
0xF0A795B4, 0xF4BA,
0xF0A796A3, 0xED29,
0xF0A797A0, 0xE409,
0xF0A797A4, 0xE40B,
0xF0A797BD, 0xE64B,
0xF0A797BE, 0xEB4F,
0xF0A79887, 0xF7EE,
0xF0A7988C, 0xE2FC,
0xF0A798B2, 0xEB89,
0xF0A798B9, 0xF4DB,
0xF0A79995, 0xEC98,
0xF0A79996, 0xEEA4,
0xF0A79997, 0xEB4B,
0xF0A79A94, 0xF519,
0xF0A79C8F, 0xE414,
0xF0A79CB5, 0xF3AC,
0xF0A79CB6, 0xE953,
0xF0A79D81, 0xE724,
0xF0A79D9E, 0xF4F2,
0xF0A79E84, 0xE7A5,
0xF0A79E85, 0xE7A4,
0xF0A79F8C, 0xEC08,
0xF0A7A198, 0xEC09,
0xF0A7A1B0, 0xE696,
0xF0A7A29D, 0xEC8E,
0xF0A7A2B2, 0xF55E,
0xF0A7A388, 0xF46E,
0xF0A7A4A4, 0xE41D,
0xF0A7A5A7, 0xEA43,
0xF0A7A5BA, 0xE4DD,
0xF0A7A6A0, 0xF47E,
0xF0A7A79D, 0xEC13,
0xF0A7A7BD, 0xEC19,
0xF0A7A88A, 0xEC1A,
0xF0A7A88E, 0xE103,
0xF0A7A8BE, 0xEC95,
0xF0A7A993, 0xE16A,
0xF0A7A999, 0xE423,
0xF0A7A9B9, 0xEB3D,
0xF0A7AA84, 0xE01B,
0xF0A7AABD, 0xE41E,
0xF0A7AABE, 0xE46F,
0xF0A7ABB4, 0xE987,
0xF0A7AC86, 0xE821,
0xF0A7AC8B, 0xEC1B,
0xF0A7AC98, 0xE98E,
0xF0A7ACB8, 0xE428,
0xF0A7ACB9, 0xE308,
0xF0A7ACBA, 0xE425,
0xF0A7AD88, 0xE75D,
0xF0A7AFB4, 0xE927,
0xF0A7B092, 0xEBA0,
0xF0A7B4AF, 0xED0D,
0xF0A7B593, 0xE43E,
0xF0A7B594, 0xE43A,
0xF0A7B5A6, 0xEC1C,
0xF0A7B5B3, 0xED0F,
0xF0A7B684, 0xF43D,
0xF0A7B68F, 0xE43B,
0xF0A7B698, 0xE440,
0xF0A7B6BD, 0xE441,
0xF0A7B79C, 0xE7BC,
0xF0A7B98D, 0xE95D,
0xF0A7B98F, 0xE903,
0xF0A7BFB9, 0xED1D,
0xF0A88082, 0xE44C,
0xF0A88089, 0xEC20,
0xF0A8809E, 0xE6C0,
0xF0A880A3, 0xEC2B,
0xF0A880A4, 0xEC92,
0xF0A88188, 0xEC2F,
0xF0A88283, 0xEC32,
0xF0A88290, 0xEC3F,
0xF0A882BD, 0xF4FC,
0xF0A882BE, 0xF44B,
0xF0A883A8, 0xEC0F,
0xF0A883A9, 0xF463,
0xF0A883B4, 0xEC40,
0xF0A884AE, 0xEC41,
0xF0A8858F, 0xEC43,
0xF0A8859D, 0xF450,
0xF0A885AF, 0xEC2A,
0xF0A88689, 0xEC44,
0xF0A886AF, 0xEC45,
0xF0A886BC, 0xE450,
0xF0A88887, 0xF50D,
0xF0A88898, 0xE8FE,
0xF0A8889A, 0xEC46,
0xF0A88996, 0xF45E,
0xF0A889BC, 0xF526,
0xF0A88A9B, 0xF4AD,
0xF0A88B8D, 0xF51A,
0xF0A88BA2, 0xECD4,
0xF0A88C86, 0xEC47,
0xF0A88C98, 0xEC24,
0xF0A88CAF, 0xEC48,
0xF0A88CBA, 0xE379,
0xF0A88DA5, 0xE459,
0xF0A88DAD, 0xE362,
0xF0A88DBD, 0xEE11,
0xF0A88E8A, 0xEC49,
0xF0A89092, 0xE45A,
0xF0A891A8, 0xEC4B,
0xF0A891AC, 0xF408,
0xF0A891B3, 0xEBFA,
0xF0A89282, 0xE139,
0xF0A89481, 0xE469,
0xF0A894BC, 0xE46E,
0xF0A894BD, 0xE462,
0xF0A895AC, 0xE471,
0xF0A897A8, 0xEB68,
0xF0A897B4, 0xE1BD,
0xF0A89880, 0xE50A,
0xF0A8988B, 0xE472,
0xF0A898A5, 0xE3ED,
0xF0A898BB, 0xE3EE,
0xF0A89AAA, 0xEC4C,
0xF0A89AAB, 0xE071,
0xF0A89ABC, 0xE468,
0xF0A89B98, 0xE4A2,
0xF0A89BA6, 0xE476,
0xF0A89C8F, 0xF593,
0xF0A89C93, 0xE474,
0xF0A8A084, 0xE28B,
0xF0A8A0AB, 0xE289,
0xF0A8A4B3, 0xE47E,
0xF0A8A588, 0xEB97,
0xF0A8A589, 0xEC35,
0xF0A8A596, 0xEC4F,
0xF0A8A5A4, 0xE2EB,
0xF0A8A5A8, 0xE2EC,
0xF0A8A5AC, 0xE566,
0xF0A8A5BE, 0xE55E,
0xF0A8A689, 0xE7FF,
0xF0A8A6A8, 0xE642,
0xF0A8A6AA, 0xE013,
0xF0A8A6AB, 0xEC18,
0xF0A8A6B8, 0xEC52,
0xF0A8A6BC, 0xE09D,
0xF0A8A780, 0xF694,
0xF0A8A79C, 0xE6C1,
0xF0A8A79E, 0xE461,
0xF0A8A7A1, 0xE958,
0xF0A8A7A3, 0xF5A3,
0xF0A8A7A4, 0xE00A,
0xF0A8A7A7, 0xEC54,
0xF0A8A7A8, 0xEC56,
0xF0A8A7B9, 0xE7A9,
0xF0A8A7BA, 0xE8B0,
0xF0A8A7BB, 0xE62B,
0xF0A8A7BC, 0xE89D,
0xF0A8A88F, 0xEEAD,
0xF0A8A896, 0xE8CE,
0xF0A8A8A5, 0xE41B,
0xF0A8A8A9, 0xE15A,
0xF0A8A8B2, 0xF585,
0xF0A8A8B6, 0xE150,
0xF0A8A984, 0xE562,
0xF0A8A985, 0xE81A,
0xF0A8A986, 0xE60F,
0xF0A8A987, 0xE63F,
0xF0A8A988, 0xE38D,
0xF0A8A989, 0xE895,
0xF0A8A98A, 0xE1E6,
0xF0A8A98B, 0xE7D8,
0xF0A8A999, 0xE981,
0xF0A8A99A, 0xEE1B,
0xF0A8AA81, 0xE8F1,
0xF0A8AA82, 0xE8D3,
0xF0A8AA83, 0xE929,
0xF0A8AA9A, 0xEB54,
0xF0A8AA9B, 0xE078,
0xF0A8AA9C, 0xE5E5,
0xF0A8AB80, 0xE8E5,
0xF0A8AB86, 0xE486,
0xF0A8AB8B, 0xE6BE,
0xF0A8AB8C, 0xE6FA,
0xF0A8AB8E, 0xE8CD,
0xF0A8AB9E, 0xE05C,
0xF0A8AB9F, 0xE1DA,
0xF0A8ABA0, 0xE4AF,
0xF0A8ABA1, 0xE48D,
0xF0A8ABA2, 0xE491,
0xF0A8ABA3, 0xE706,
0xF0A8ABA5, 0xE492,
0xF0A8ABAA, 0xF59C,
0xF0A8ABBC, 0xE7DA,
0xF0A8AC8C, 0xE488,
0xF0A8AC93, 0xE5AA,
0xF0A8ACA1, 0xE22F,
0xF0A8ACA2, 0xE684,
0xF0A8ACAB, 0xE2FF,
0xF0A8ACAC, 0xEC8D,
0xF0A8ACAD, 0xEE9C,
0xF0A8ACAF, 0xE801,
0xF0A8AD86, 0xEC57,
0xF0A8AD8C, 0xF484,
0xF0A8AD8E, 0xEB6D,
0xF0A8AD90, 0xE816,
0xF0A8ADA3, 0xE8B5,
0xF0A8ADA4, 0xE818,
0xF0A8ADA5, 0xE827,
0xF0A8ADA6, 0xE0BA,
0xF0A8ADAC, 0xEC93,
0xF0A8AE8F, 0xE2B5,
0xF0A8AE99, 0xEC94,
0xF0A8AE9C, 0xE7A8,
0xF0A8AE9D, 0xE17B,
0xF0A8AF82, 0xEE5B,
0xF0A8AF85, 0xE80E,
0xF0A8AF94, 0xEC58,
0xF0A8AF97, 0xE623,
0xF0A8AF99, 0xE7A7,
0xF0A8AF9A, 0xE55B,
0xF0A8AFA7, 0xE8D0,
0xF0A8AFA8, 0xE271,
0xF0A8AFA9, 0xE318,
0xF0A8AFAA, 0xE6BD,
0xF0A8AFAB, 0xE48E,
0xF0A8AFAC, 0xE495,
0xF0A8AFB5, 0xE7A6,
0xF0A8AFBF, 0xE497,
0xF0A8B083, 0xE2B7,
0xF0A8B089, 0xEC5A,
0xF0A8B09C, 0xE917,
0xF0A8B09D, 0xE7DC,
0xF0A8B0A3, 0xE6E5,
0xF0A8B0A6, 0xE800,
0xF0A8B0AB, 0xE53E,
0xF0A8B0B0, 0xEC31,
0xF0A8B0B9, 0xE496,
0xF0A8B0BB, 0xE7DD,
0xF0A8B38A, 0xF4E9,
0xF0A8B38D, 0xF4BE,
0xF0A8B392, 0xF4E7,
0xF0A8B4B4, 0xE7E4,
0xF0A8B699, 0xF4E8,
0xF0A8B6B9, 0xF5D6,
0xF0A8B88F, 0xF565,
0xF0A8B8B6, 0xE55F,
0xF0A8B8B9, 0xEE5D,
0xF0A8B9A5, 0xE7EF,
0xF0A8B9A6, 0xE7EE,
0xF0A8BA97, 0xEDCF,
0xF0A8BAAC, 0xE2C1,
0xF0A8BAB2, 0xE2A6,
0xF0A8BAB3, 0xE5BF,
0xF0A8BB99, 0xE2BE,
0xF0A8BBA7, 0xE7ED,
0xF0A8BF85, 0xEC5C,
0xF0A98288, 0xE654,
0xF0A9828B, 0xE54B,
0xF0A98293, 0xE7FB,
0xF0A982AF, 0xE4B6,
0xF0A982B0, 0xE7F8,
0xF0A982B1, 0xE501,
0xF0A98380, 0xEBCC,
0xF0A983A4, 0xE900,
0xF0A983A5, 0xE4B7,
0xF0A983AC, 0xEC5D,
0xF0A983AD, 0xE1CD,
0xF0A9848D, 0xE30F,
0xF0A98490, 0xEC5F,
0xF0A984BC, 0xEC60,
0xF0A9858D, 0xE660,
0xF0A9859B, 0xE97D,
0xF0A9859E, 0xEC62,
0xF0A985B0, 0xE245,
0xF0A9869C, 0xE1F7,
0xF0A986A8, 0xEC14,
0xF0A98795, 0xE4C6,
0xF0A987AB, 0xE4C9,
0xF0A9909D, 0xE4DC,
0xF0A990A0, 0xE982,
0xF0A990B3, 0xE4D9,
0xF0A990BF, 0xE67D,
0xF0A99188, 0xE7B1,
0xF0A99390, 0xED84,
0xF0A99399, 0xE31C,
0xF0A9939A, 0xE811,
0xF0A993A5, 0xF449,
0xF0A993A7, 0xEC67,
0xF0A9969E, 0xED4E,
0xF0A996B0, 0xEC69,
0xF0A996B8, 0xEC6A,
0xF0A99797, 0xE813,
0xF0A997A9, 0xEC68,
0xF0A997B4, 0xF469,
0xF0A99CA0, 0xF4B4,
0xF0A99CB2, 0xEC6B,
0xF0A99F94, 0xF46D,
0xF0A9A090, 0xF56B,
0xF0A9A197, 0xE4F8,
0xF0A9A2A4, 0xEC06,
0xF0A9A391, 0xEC6C,
0xF0A9A3AA, 0xE667,
0xF0A9A3B1, 0xE82D,
0xF0A9A483, 0xEEA8,
0xF0A9A485, 0xE4F9,
0xF0A9A4AF, 0xE858,
0xF0A9A587, 0xF59B,
0xF0A9A588, 0xE82F,
0xF0A9A589, 0xEC6D,
0xF0A9A59D, 0xE17C,
0xF0A9A5AA, 0xEC6E,
0xF0A9A69D, 0xE593,
0xF0A9A783, 0xEC6F,
0xF0A9A789, 0xEB69,
0xF0A9A8A8, 0xEC70,
0xF0A9A98D, 0xF462,
0xF0A9AC85, 0xE505,
0xF0A9AC8E, 0xEC71,
0xF0A9AF95, 0xE502,
0xF0A9B1B3, 0xF579,
0xF0A9B2AD, 0xEC05,
0xF0A9B4BE, 0xE512,
0xF0A9B59A, 0xEC72,
0xF0A9B5BC, 0xED25,
0xF0A9B698, 0xECAF,
0xF0A9B69B, 0xEC73,
0xF0A9B7B6, 0xF3F9,
0xF0A9B886, 0xED78,
0xF0A9B8AD, 0xE84B,
0xF0A9B9A8, 0xE51A,
0xF0A9BAAC, 0xED47,
0xF0A9BB83, 0xF4EF,
0xF0A9BBB8, 0xEC75,
0xF0A9BCA3, 0xEC76,
0xF0A9BCB0, 0xED4B,
0xF0A9BEB7, 0xE51C,
0xF0A9BF9E, 0xED4F,
0xF0AA8094, 0xE467,
0xF0AA8287, 0xE381,
0xF0AA82B9, 0xE52E,
0xF0AA83A1, 0xE51F,
0xF0AA83AD, 0xE856,
0xF0AA83B3, 0xE857,
0xF0AA83B8, 0xE3FD,
0xF0AA83BE, 0xE84E,
0xF0AA8487, 0xF58C,
0xF0AA84A3, 0xE520,
0xF0AA84B3, 0xF3FC,
0xF0AA84B4, 0xE524,
0xF0AA8590, 0xE0D4,
0xF0AA8692, 0xE51D,
0xF0AA8693, 0xE529,
0xF0AA86AB, 0xE51E,
0xF0AA86B4, 0xE855,
0xF0AA879F, 0xE521,
0xF0AA87B5, 0xE84D,
0xF0AA88A0, 0xE52A,
0xF0AA88B3, 0xE52C,
0xF0AA8A93, 0xEC79,
0xF0AA8A9F, 0xE45D,
0xF0AA8AB2, 0xEE20,
0xF0AA8AB4, 0xE52F,
0xF0AA8AB6, 0xE97B,
0xF0AA8ABA, 0xF596,
0xF0AA8ABD, 0xF522,
0xF0AA8B9F, 0xEC22,
0xF0AA8BBF, 0xEC7B,
0xF0AA8EA9, 0xF3A0,
0xF0AA90B4, 0xED6B,
0xF0AA919B, 0xE66A,
0xF0AA9786, 0xE6F7,
0xF0AA978B, 0xEC7E,
0xF0AA9881, 0xF4A4,
0xF0AA98B2, 0xF4E5,
0xF0AA998A, 0xEE08,
0xF0AA999B, 0xF4BD,
0xF0AA9AA9, 0xED16,
0xF0AFA0A5, 0xE967,
0xF0AFA0BB, 0xEAD3,
0xF0AFA180, 0xEE22,
0xF0AFA1B8, 0xF53B,
0xF0AFA294, 0xE142,
0xF0AFA2A6, 0xE171,
0xF0AFA38D, 0xEBB9,
0xF0AFA694, 0xE3AC,
0xF0AFA6B2, 0xE3F4,
0xF0AFA6BC, 0xE796,
0xF0AFA794, 0xE43C
};

/*
  Unicode ---> sjis
*/
#define TABAL 0
#define TABAH 1105
#define TABBL 8208
#define TABBH 9839
#define TABCL 12288
#define TABCH 12542
#define TABDL 19968
#define TABDH 40864
#define TABEL 65281
#define TABEH 65509

unsigned short uni2sjis_a[] = {
0x0000,
0x0001,
0x0002,
0x0003,
0x0004,
0x0005,
0x0006,
0x0007,
0x0008,
0x0009,
0x000a,
0x000b,
0x000c,
0x000d,
0x000e,
0x000f,
0x0010,
0x0011,
0x0012,
0x0013,
0x0014,
0x0015,
0x0016,
0x0017,
0x0018,
0x0019,
0x001a,
0x001b,
0x001c,
0x001d,
0x001e,
0x001f,
0x0020,
0x0021,
0x0022,
0x0023,
0x0024,
0x0025,
0x0026,
0x0027,
0x0028,
0x0029,
0x002a,
0x002b,
0x002c,
0x002d,
0x002e,
0x002f,
0x0030,
0x0031,
0x0032,
0x0033,
0x0034,
0x0035,
0x0036,
0x0037,
0x0038,
0x0039,
0x003a,
0x003b,
0x003c,
0x003d,
0x003e,
0x003f,
0x0040,
0x0041,
0x0042,
0x0043,
0x0044,
0x0045,
0x0046,
0x0047,
0x0048,
0x0049,
0x004a,
0x004b,
0x004c,
0x004d,
0x004e,
0x004f,
0x0050,
0x0051,
0x0052,
0x0053,
0x0054,
0x0055,
0x0056,
0x0057,
0x0058,
0x0059,
0x005a,
0x005b,
0x005c,
0x005d,
0x005e,
0x005f,
0x0060,
0x0061,
0x0062,
0x0063,
0x0064,
0x0065,
0x0066,
0x0067,
0x0068,
0x0069,
0x006a,
0x006b,
0x006c,
0x006d,
0x006e,
0x006f,
0x0070,
0x0071,
0x0072,
0x0073,
0x0074,
0x0075,
0x0076,
0x0077,
0x0078,
0x0079,
0x007a,
0x007b,
0x007c,
0x007d,
0x007e,
0x007f,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x8198,
0x814e,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x818b,
0x817d,
0xffff,
0xffff,
0x814c,
0xffff,
0x81f7,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x817e,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x8180,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x839f,
0x83a0,
0x83a1,
0x83a2,
0x83a3,
0x83a4,
0x83a5,
0x83a6,
0x83a7,
0x83a8,
0x83a9,
0x83aa,
0x83ab,
0x83ac,
0x83ad,
0x83ae,
0x83af,
0xffff,
0x83b0,
0x83b1,
0x83b2,
0x83b3,
0x83b4,
0x83b5,
0x83b6,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x83bf,
0x83c0,
0x83c1,
0x83c2,
0x83c3,
0x83c4,
0x83c5,
0x83c6,
0x83c7,
0x83c8,
0x83c9,
0x83ca,
0x83cb,
0x83cc,
0x83cd,
0x83ce,
0x83cf,
0xffff,
0x83d0,
0x83d1,
0x83d2,
0x83d3,
0x83d4,
0x83d5,
0x83d6,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x8446,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x8440,
0x8441,
0x8442,
0x8443,
0x8444,
0x8445,
0x8447,
0x8448,
0x8449,
0x844a,
0x844b,
0x844c,
0x844d,
0x844e,
0x844f,
0x8450,
0x8451,
0x8452,
0x8453,
0x8454,
0x8455,
0x8456,
0x8457,
0x8458,
0x8459,
0x845a,
0x845b,
0x845c,
0x845d,
0x845e,
0x845f,
0x8460,
0x8470,
0x8471,
0x8472,
0x8473,
0x8474,
0x8475,
0x8477,
0x8478,
0x8479,
0x847a,
0x847b,
0x847c,
0x847d,
0x847e,
0x8480,
0x8481,
0x8482,
0x8483,
0x8484,
0x8485,
0x8486,
0x8487,
0x8488,
0x8489,
0x848a,
0x848b,
0x848c,
0x848d,
0x848e,
0x848f,
0x8490,
0x8491,
0xffff,
0x8476
};
unsigned short uni2sjis_b[] = {
0x815d,
0xffff,
0xffff,
0xffff,
#ifdef MACOS
0x815c,
#else
0xffff,
#endif
0x815c,
0x8161,
0xffff,
0x8165,
0x8166,
0xffff,
0xffff,
0x8167,
0x8168,
0xffff,
0xffff,
0x81f5,
0x81f6,
0xffff,
0xffff,
0xffff,
0x8164,
0x8163,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x81f1,
0xffff,
0x818c,
0x818d,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x81a6,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x818e,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x81f0,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x81a9,
0x81aa,
0x81a8,
0x81ab,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x81cb,
0xffff,
0x81cc,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x81cd,
0xffff,
0x81dd,
0x81ce,
0xffff,
0xffff,
0xffff,
0x81de,
0x81b8,
0xffff,
0xffff,
0x81b9,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x81e3,
0xffff,
0xffff,
0x81e5,
0x8187,
0xffff,
0x81da,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x81c8,
0x81c9,
0x81bf,
0x81be,
0x81e7,
0x81e8,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x8188,
0x81e6,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x81e4,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x81e0,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x8182,
0x81df,
0xffff,
0xffff,
0xffff,
0xffff,
0x8185,
0x8186,
0xffff,
0xffff,
0x81e1,
0x81e2,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x81bc,
0x81bd,
0xffff,
0xffff,
0x81ba,
0x81bb,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x81db,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x81dc,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x849f,
0x84aa,
0x84a0,
0x84ab,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x84a1,
0xffff,
0xffff,
0x84ac,
0x84a2,
0xffff,
0xffff,
0x84ad,
0x84a4,
0xffff,
0xffff,
0x84af,
0x84a3,
0xffff,
0xffff,
0x84ae,
0x84a5,
0x84ba,
0xffff,
0xffff,
0x84b5,
0xffff,
0xffff,
0x84b0,
0x84a7,
0x84bc,
0xffff,
0xffff,
0x84b7,
0xffff,
0xffff,
0x84b2,
0x84a6,
0xffff,
0xffff,
0x84b6,
0x84bb,
0xffff,
0xffff,
0x84b1,
0x84a8,
0xffff,
0xffff,
0x84b8,
0x84bd,
0xffff,
0xffff,
0x84b3,
0x84a9,
0xffff,
0xffff,
0x84b9,
0xffff,
0xffff,
0x84be,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x84b4,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x81a1,
0x81a0,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x81a3,
0x81a2,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x81a5,
0x81a4,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x819f,
0x819e,
0xffff,
0xffff,
0xffff,
0x819b,
0xffff,
0xffff,
0x819d,
0x819c,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x81fc,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x819a,
0x8199,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x818a,
0xffff,
0x8189,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x81f4,
0xffff,
0xffff,
0x81f3,
0xffff,
0x81f2
};
unsigned short uni2sjis_c[] = {
0x8140,
0x8141,
0x8142,
0x8156,
0xffff,
0x8158,
0x8159,
0x815a,
0x8171,
0x8172,
0x8173,
0x8174,
0x8175,
0x8176,
0x8177,
0x8178,
0x8179,
0x817a,
0x81a7,
0x81ac,
0x816b,
0x816c,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x829f,
0x82a0,
0x82a1,
0x82a2,
0x82a3,
0x82a4,
0x82a5,
0x82a6,
0x82a7,
0x82a8,
0x82a9,
0x82aa,
0x82ab,
0x82ac,
0x82ad,
0x82ae,
0x82af,
0x82b0,
0x82b1,
0x82b2,
0x82b3,
0x82b4,
0x82b5,
0x82b6,
0x82b7,
0x82b8,
0x82b9,
0x82ba,
0x82bb,
0x82bc,
0x82bd,
0x82be,
0x82bf,
0x82c0,
0x82c1,
0x82c2,
0x82c3,
0x82c4,
0x82c5,
0x82c6,
0x82c7,
0x82c8,
0x82c9,
0x82ca,
0x82cb,
0x82cc,
0x82cd,
0x82ce,
0x82cf,
0x82d0,
0x82d1,
0x82d2,
0x82d3,
0x82d4,
0x82d5,
0x82d6,
0x82d7,
0x82d8,
0x82d9,
0x82da,
0x82db,
0x82dc,
0x82dd,
0x82de,
0x82df,
0x82e0,
0x82e1,
0x82e2,
0x82e3,
0x82e4,
0x82e5,
0x82e6,
0x82e7,
0x82e8,
0x82e9,
0x82ea,
0x82eb,
0x82ec,
0x82ed,
0x82ee,
0x82ef,
0x82f0,
0x82f1,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x814a,
0x814b,
0x8154,
0x8155,
0xffff,
0xffff,
0x8340,
0x8341,
0x8342,
0x8343,
0x8344,
0x8345,
0x8346,
0x8347,
0x8348,
0x8349,
0x834a,
0x834b,
0x834c,
0x834d,
0x834e,
0x834f,
0x8350,
0x8351,
0x8352,
0x8353,
0x8354,
0x8355,
0x8356,
0x8357,
0x8358,
0x8359,
0x835a,
0x835b,
0x835c,
0x835d,
0x835e,
0x835f,
0x8360,
0x8361,
0x8362,
0x8363,
0x8364,
0x8365,
0x8366,
0x8367,
0x8368,
0x8369,
0x836a,
0x836b,
0x836c,
0x836d,
0x836e,
0x836f,
0x8370,
0x8371,
0x8372,
0x8373,
0x8374,
0x8375,
0x8376,
0x8377,
0x8378,
0x8379,
0x837a,
0x837b,
0x837c,
0x837d,
0x837e,
0x8380,
0x8381,
0x8382,
0x8383,
0x8384,
0x8385,
0x8386,
0x8387,
0x8388,
0x8389,
0x838a,
0x838b,
0x838c,
0x838d,
0x838e,
0x838f,
0x8390,
0x8391,
0x8392,
0x8393,
0x8394,
0x8395,
0x8396,
0xffff,
0xffff,
0xffff,
0xffff,
0x8145,
0x815b,
0x8152,
0x8153
};
unsigned short uni2sjis_d[] = {
0x88ea,
0x929a,
0xffff,
0x8eb5,
0xffff,
0xffff,
0xffff,
0x969c,
0x8fe4,
0x8e4f,
0x8fe3,
0x89ba,
0xffff,
0x9573,
0x975e,
0xffff,
0x98a0,
0x894e,
0xffff,
0xffff,
0x8a8e,
0x98a1,
0x90a2,
0x99c0,
0x8b75,
0x95b8,
0xffff,
0xffff,
0xffff,
0xffff,
0x8fe5,
0xffff,
0xffff,
0x97bc,
0xffff,
0xffff,
0xffff,
0xffff,
0x95c0,
0xffff,
0xffff,
0xffff,
0x98a2,
0xffff,
0xffff,
0x9286,
0xffff,
0xffff,
0xffff,
0x98a3,
0x8bf8,
0xffff,
0xffff,
0xffff,
0x98a4,
0xffff,
0x8adb,
0x924f,
0xffff,
0x8ee5,
0x98a5,
0xffff,
0xffff,
0x98a6,
0xffff,
0xffff,
0x98a7,
0x9454,
0xffff,
0x8b76,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9456,
0xffff,
0x93e1,
0x8cc1,
0x9652,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe568,
0x98a8,
0x8fe6,
0x98a9,
0x89b3,
0xffff,
0xffff,
0xffff,
0x8be3,
0x8cee,
0x96e7,
0xffff,
0xffff,
0x9ba4,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9790,
0xffff,
0x93fb,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x8aa3,
0xffff,
0x8b54,
0xffff,
0x98aa,
0xffff,
0xffff,
0x98ab,
0x97b9,
0xffff,
0x975c,
0x9188,
0x98ad,
0x8e96,
0x93f1,
0xffff,
0x98b0,
0xffff,
0xffff,
0x895d,
0x8cdd,
0xffff,
0x8cdc,
0x88e4,
0xffff,
0xffff,
0x986a,
0x9869,
0xffff,
0x8db1,
0x889f,
0xffff,
0x98b1,
0x98b2,
0x98b3,
0x9653,
0x98b4,
0xffff,
0x8cf0,
0x88e5,
0x9692,
0xffff,
0x8b9c,
0xffff,
0xffff,
0x8b9d,
0x8b9e,
0x92e0,
0x97ba,
0xffff,
0x98b5,
0xffff,
0xffff,
0x98b6,
0xffff,
0xffff,
0x98b7,
0xffff,
0xffff,
0xffff,
0x906c,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x8f59,
0x906d,
0x98bc,
0xffff,
0x98ba,
0xffff,
0x98bb,
0x8b77,
0xffff,
0xffff,
0x8da1,
0x89ee,
0xffff,
0x98b9,
0x98b8,
0x95a7,
0xffff,
0xffff,
0xffff,
0xffff,
0x8e65,
0x8e64,
0x91bc,
0x98bd,
0x9574,
0x90e5,
0xffff,
0xffff,
0xffff,
0x8157,
0x98be,
0x98c0,
0xffff,
0xffff,
0xffff,
0x91e3,
0x97df,
0x88c8,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x98bf,
0x89bc,
0xffff,
0x8bc2,
0xffff,
0x9287,
0xffff,
0xffff,
0xffff,
0x8c8f,
0x98c1,
0xffff,
0xffff,
0xffff,
0x9443,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x8ae9,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x98c2,
0x88c9,
0xffff,
0xffff,
0x8cde,
0x8aea,
0x959a,
0x94b0,
0x8b78,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x89ef,
0xffff,
0x98e5,
0x9360,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x948c,
0x98c4,
0xffff,
0xffff,
0xffff,
0x94ba,
0xffff,
0x97e0,
0xffff,
0x904c,
0xffff,
0x8e66,
0xffff,
0x8e97,
0x89be,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x92cf,
0xffff,
0xffff,
0x9241,
0x98c8,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x88ca,
0x92e1,
0x8f5a,
0x8db2,
0x9743,
0xffff,
0x91cc,
0xffff,
0x89bd,
0xffff,
0x98c7,
0xffff,
0x975d,
0x98c3,
0x98c5,
0x8dec,
0x98c6,
0x9b43,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x98ce,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x98d1,
0x98cf,
0xffff,
0xffff,
0x89c0,
0xffff,
0x95b9,
0x98c9,
0xffff,
0xffff,
0xffff,
0xffff,
0x98cd,
0x8cf1,
0xffff,
0xffff,
0x8e67,
0xffff,
0xffff,
0xffff,
0x8aa4,
0xffff,
0xffff,
0x98d2,
0xffff,
0x98ca,
0xffff,
0xffff,
0x97e1,
0xffff,
0x8e98,
0xffff,
0x98cb,
0xffff,
0x98d0,
0xffff,
0xffff,
0xffff,
0xffff,
0x98d3,
0xffff,
0x98cc,
0xffff,
0xffff,
0x8b9f,
0xffff,
0x88cb,
0xffff,
0xffff,
0x8ba0,
0x89bf,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9b44,
0xffff,
0x9699,
0x958e,
0x8cf2,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x904e,
0x97b5,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x95d6,
0xffff,
0xffff,
0x8c57,
0x91a3,
0x89e2,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x8f72,
0xffff,
0xffff,
0xffff,
0x98d7,
0xffff,
0x98dc,
0x98da,
0xffff,
0xffff,
0x98d5,
0xffff,
0xffff,
0x91ad,
0x98d8,
0xffff,
0x98db,
0x98d9,
0xffff,
0x95db,
0xffff,
0x98d6,
0xffff,
0x904d,
0xffff,
0x9693,
0x98dd,
0x98de,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x8f43,
0x98eb,
0xffff,
0xffff,
0xffff,
0x946f,
0xffff,
0x9555,
0x98e6,
0xffff,
0x95ee,
0xffff,
0x89b4,
0xffff,
0xffff,
0xffff,
0x98ea,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x98e4,
0x98ed,
0xffff,
0xffff,
0x9171,
0xffff,
0x8cc2,
0xffff,
0x947b,
0xffff,
0xe0c5,
0xffff,
0x98ec,
0x937c,
0xffff,
0x98e1,
0xffff,
0x8cf4,
0xffff,
0xffff,
0x8cf3,
0x98df,
0xffff,
0xffff,
0xffff,
0xffff,
0x8ed8,
0xffff,
0x98e7,
0xffff,
0x95ed,
0x926c,
0x98e3,
0x8c91,
0xffff,
0x98e0,
0x98e8,
0x98e2,
0x97cf,
0x98e9,
0x9860,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x8be4,
0xffff,
0xffff,
0x8c90,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x98ee,
0xffff,
0xffff,
0xffff,
0x98ef,
0x98f3,
0x88cc,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x95ce,
0x98f2,
0xffff,
0xffff,
0xffff,
0xffff,
0x98f1,
0x98f5,
0xffff,
0xffff,
0xffff,
0x98f4,
0xffff,
0x92e2,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x8c92,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x98f6,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x8ec3,
0xffff,
0x91a4,
0x92e3,
0x8bf4,
0xffff,
0x98f7,
0xffff,
0xffff,
0xffff,
0xffff,
0x8b55,
0xffff,
0xffff,
0x98f8,
0xffff,
0xffff,
0xffff,
0xffff,
0x98fa,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9654,
0xffff,
0xffff,
0xffff,
0x8c86,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x8e50,
0x94f5,
0x98f9,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x8dc3,
0x9762,
0xffff,
0xffff,
0xffff,
0xffff,
0x98fc,
0x9942,
0x98fb,
0x8dc2,
0xffff,
0x8f9d,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x8c58,
0xffff,
0xffff,
0xffff,
0x9943,
0xffff,
0xffff,
0x8bcd,
0xffff,
0xffff,
0xffff,
0x9940,
0x9941,
0xffff,
0xffff,
0x93ad,
0xffff,
0x919c,
0xffff,
0x8ba1,
0xffff,
0xffff,
0xffff,
0x966c,
0x9944,
0xffff,
0xffff,
0xffff,
0x97bb,
0xffff,
0xffff,
0xffff,
0x9945,
0xffff,
0xffff,
0xffff,
0xffff,
0x9948,
0xffff,
0x9946,
0xffff,
0x916d,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9947,
0x9949,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x994b,
0xffff,
0xffff,
0xffff,
0x994a,
0xffff,
0x95c6,
0xffff,
0xffff,
0xffff,
0xffff,
0x8b56,
0x994d,
0x994e,
0xffff,
0x89ad,
0xffff,
0xffff,
0xffff,
0xffff,
0x994c,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x8ef2,
0xffff,
0x9951,
0x9950,
0x994f,
0xffff,
0x98d4,
0xffff,
0x9952,
0xffff,
0xffff,
0xffff,
0xffff,
0x8f9e,
0xffff,
0x9953,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9744,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x96d7,
0xffff,
0xffff,
0xffff,
0xffff,
0x9955,
0xffff,
0xffff,
0x9954,
0x9957,
0x9956,
0xffff,
0xffff,
0x9958,
0x9959,
0x88f2,
0xffff,
0x8cb3,
0x8c5a,
0x8f5b,
0x929b,
0x8ba2,
0x90e6,
0x8cf5,
0xffff,
0x8d8e,
0x995b,
0x96c6,
0x9365,
0xffff,
0x8e99,
0xffff,
0x995a,
0xffff,
0x995c,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x937d,
0xffff,
0x8a95,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x995d,
0xffff,
0xffff,
0x93fc,
0xffff,
0xffff,
0x9153,
0x995f,
0x9960,
0x94aa,
0x8cf6,
0x985a,
0x9961,
0xffff,
0xffff,
0x8ba4,
0xffff,
0xffff,
0xffff,
0x95ba,
0x91b4,
0x8bef,
0x9354,
0xffff,
0xffff,
0xffff,
0x8c93,
0xffff,
0xffff,
0xffff,
0x9962,
0xffff,
0x9963,
0xffff,
0xffff,
0x93e0,
0x897e,
0xffff,
0xffff,
0x9966,
0x8dfb,
0xffff,
0x9965,
0x8dc4,
0xffff,
0x9967,
0xe3ec,
0x9968,
0x9660,
0x9969,
0xffff,
0x996a,
0x996b,
0x8fe7,
0xffff,
0x8eca,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x8aa5,
0xffff,
0x996e,
0xffff,
0x996c,
0x96bb,
0x996d,
0xffff,
0x9579,
0x996f,
0x9970,
0x9971,
0x937e,
0xffff,
0xffff,
0xffff,
0x9975,
0x9973,
0x9974,
0x9972,
0x8de1,
0x9976,
0x96e8,
0x97e2,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9977,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x90a6,
0x9978,
0x8f79,
0xffff,
0xffff,
0x9979,
0xffff,
0x929c,
0x97bd,
0x9380,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x99c3,
0xffff,
0xffff,
0xffff,
0xffff,
0x997a,
0xeaa3,
0x8bc3,
0xffff,
0xffff,
0x997b,
0x967d,
0xffff,
0xffff,
0xffff,
0xffff,
0x8f88,
0x91fa,
0xffff,
0x997d,
0x93e2,
0xffff,
0xffff,
0x997e,
0xffff,
0xffff,
0x9980,
0x8a4d,
0xffff,
0xffff,
0xffff,
0x9981,
0x8ba5,
0xffff,
0x93ca,
0x899a,
0x8f6f,
0xffff,
0xffff,
0x949f,
0x9982,
0xffff,
0x9381,
0xffff,
0xffff,
0x906e,
0x9983,
0xffff,
0x95aa,
0x90d8,
0x8aa0,
0xffff,
0x8aa7,
0x9984,
0xffff,
0xffff,
0x9986,
0xffff,
0xffff,
0x8c59,
0xffff,
0xffff,
0x9985,
0xffff,
0xffff,
0x97f1,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x8f89,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x94bb,
0x95ca,
0xffff,
0x9987,
0xffff,
0x9798,
0x9988,
0xffff,
0xffff,
0xffff,
0x9989,
0xffff,
0x939e,
0xffff,
0xffff,
0x998a,
0xffff,
0xffff,
0x90a7,
0x8dfc,
0x8c94,
0x998b,
0x8e68,
0x8d8f,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x92e4,
0x998d,
0xffff,
0xffff,
0x91a5,
0xffff,
0xffff,
0x8ded,
0x998e,
0x998f,
0x914f,
0xffff,
0x998c,
0xffff,
0xffff,
0xffff,
0xffff,
0x9991,
0xffff,
0x9655,
0xffff,
0xffff,
0xffff,
0xffff,
0x8d84,
0xffff,
0xffff,
0x9990,
0xffff,
0xffff,
0xffff,
0xffff,
0x8c95,
0x8ddc,
0x948d,
0xffff,
0xffff,
0xffff,
0x9994,
0x9992,
0xffff,
0xffff,
0xffff,
0xffff,
0x959b,
0x8fe8,
0x999b,
0x8a84,
0x9995,
0x9993,
0x916e,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9997,
0xffff,
0x9996,
0xffff,
0xffff,
0xffff,
0x8a63,
0xffff,
0xffff,
0xffff,
0x8c80,
0x999c,
0x97ab,
0xffff,
0xffff,
0xffff,
0x9998,
0xffff,
0xffff,
0xffff,
0x999d,
0x999a,
0xffff,
0x9999,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x97cd,
0xffff,
0xffff,
0xffff,
0x8cf7,
0x89c1,
0xffff,
0xffff,
0x97f2,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x8f95,
0x9377,
0x8d85,
0x99a0,
0x99a1,
0xffff,
0xffff,
0xffff,
0x97e3,
0xffff,
0xffff,
0x984a,
0x99a3,
0xffff,
0xffff,
0xffff,
0x8cf8,
0xffff,
0xffff,
0x99a2,
0xffff,
0x8a4e,
0xffff,
0xffff,
0x99a4,
0xffff,
0x9675,
0xffff,
0x92ba,
0xffff,
0x9745,
0xffff,
0x95d7,
0xffff,
0xffff,
0xffff,
0x99a5,
0xffff,
0xffff,
0xffff,
0xffff,
0xe8d3,
0xffff,
0xffff,
0x93ae,
0xffff,
0x99a6,
0x8aa8,
0x96b1,
0xffff,
0xffff,
0xffff,
0x8f9f,
0x99a7,
0x95e5,
0x99ab,
0xffff,
0x90a8,
0x99a8,
0x8bce,
0xffff,
0x99a9,
0x8aa9,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x8c4d,
0x99ac,
0xffff,
0x99ad,
0xffff,
0xffff,
0x99ae,
0x99af,
0x8ed9,
0xffff,
0xffff,
0xffff,
0x8cf9,
0x96dc,
0xffff,
0x96e6,
0x93f5,
0xffff,
0xffff,
0x95ef,
0x99b0,
0xffff,
0x99b1,
0xffff,
0xffff,
0xffff,
0xffff,
0x99b3,
0xffff,
0x99b5,
0x99b4,
0xffff,
0xffff,
0xffff,
0xffff,
0x99b6,
0x89bb,
0x966b,
0xffff,
0x8dfa,
0x99b7,
0xffff,
0xffff,
0x9178,
0xffff,
0xffff,
0x8fa0,
0x8ba7,
0xffff,
0x99b8,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x94d9,
0xffff,
0xffff,
0xffff,
0xffff,
0x99b9,
0xffff,
0x99ba,
0xffff,
0x99bb,
0xffff,
0xffff,
0xffff,
0xffff,
0x99bc,
0x9543,
0x8be6,
0x88e3,
0xffff,
0xffff,
0xffff,
0x93bd,
0x99bd,
0x8f5c,
0xffff,
0x90e7,
0xffff,
0x99bf,
0x99be,
0x8fa1,
0x8cdf,
0x99c1,
0x94bc,
0xffff,
0xffff,
0x99c2,
0xffff,
0xffff,
0xffff,
0x94da,
0x91b2,
0x91ec,
0x8ba6,
0xffff,
0xffff,
0x93ec,
0x9250,
0xffff,
0x948e,
0xffff,
0x966d,
0xffff,
0x99c4,
0xffff,
0x90e8,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x8c54,
0xffff,
0xffff,
0x99c5,
0xffff,
0xffff,
0xffff,
0xffff,
0x99c6,
0x894b,
0x88f3,
0x8aeb,
0xffff,
0x91a6,
0x8b70,
0x9791,
0xffff,
0x99c9,
0x89b5,
0xffff,
0xffff,
0x99c8,
0xffff,
0xffff,
0xffff,
0x8ba8,
0xffff,
0xffff,
0x99ca,
0xffff,
0x96ef,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x99cb,
0xffff,
0x97d0,
0xffff,
0x8cfa,
0xffff,
0xffff,
0xffff,
0xffff,
0x8cb4,
0x99cc,
0xffff,
0xffff,
0xffff,
0xffff,
0x99ce,
0x99cd,
0xffff,
0x907e,
0x8958,
0xffff,
0xffff,
0xffff,
0x897d,
0x99cf,
0xffff,
0x99d0,
0xffff,
0xffff,
0x8cb5,
0xffff,
0xffff,
0x99d1,
0xffff,
0xffff,
0xffff,
0xffff,
0x8b8e,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x8e51,
0x99d2,
0xffff,
0xffff,
0xffff,
0xffff,
0x9694,
0x8db3,
0x8b79,
0x9746,
0x916f,
0x94bd,
0x8efb,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x8f66,
0xffff,
0x8ee6,
0x8ef3,
0xffff,
0x8f96,
0xffff,
0x94be,
0xffff,
0xffff,
0xffff,
0x99d5,
0xffff,
0x8962,
0x9170,
0x8cfb,
0x8cc3,
0x8be5,
0xffff,
0xffff,
0x99d9,
0x9240,
0x91fc,
0x8ba9,
0x8fa2,
0x99da,
0x99d8,
0x89c2,
0x91e4,
0x8eb6,
0x8e6a,
0x8945,
0xffff,
0xffff,
0x8a90,
0x8d86,
0x8e69,
0xffff,
0x99db,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x99dc,
0xffff,
0x8b68,
0x8a65,
0xffff,
0xffff,
0xffff,
0x8d87,
0x8b67,
0x92dd,
0x8944,
0x93af,
0x96bc,
0x8d40,
0x9799,
0x9366,
0x8cfc,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x8c4e,
0xffff,
0x99e5,
0xffff,
0x8be1,
0x9669,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x94db,
0xffff,
0xffff,
0x99e4,
0xffff,
0x8adc,
0x99df,
0x99e0,
0x99e2,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x99e3,
0xffff,
0x8b7a,
0x9081,
0xffff,
0x95ab,
0x99e1,
0x99dd,
0x8ce1,
0xffff,
0x99de,
0xffff,
0x9843,
0xffff,
0xffff,
0xffff,
0x95f0,
0xffff,
0x92e6,
0x8ce0,
0x8d90,
0xffff,
0xffff,
0xffff,
0x99e6,
0xffff,
0xffff,
0x93db,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x99ea,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x8efc,
0xffff,
0x8ef4,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x99ed,
0x99eb,
0xffff,
0x96a1,
0xffff,
0x99e8,
0x99f1,
0x99ec,
0xffff,
0xffff,
0xffff,
0x99ef,
0x8cc4,
0x96bd,
0xffff,
0xffff,
0x99f0,
0xffff,
0xffff,
0xffff,
0x99f2,
0xffff,
0x99f4,
0xffff,
0xffff,
0xffff,
0xffff,
0x8dee,
0x9861,
0xffff,
0x99e9,
0x99e7,
0x99f3,
0xffff,
0x99ee,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x99f6,
0xffff,
0x9a42,
0x99f8,
0xffff,
0xffff,
0x99fc,
0xffff,
0xffff,
0x9a40,
0x99f9,
0xffff,
0xffff,
0x9a5d,
0xffff,
0xffff,
0x8de7,
0x8a50,
0xffff,
0xffff,
0xffff,
0xffff,
0x99f7,
0xffff,
0xffff,
0xffff,
0x9a44,
0x88f4,
0x9a43,
0xffff,
0x88a3,
0x9569,
0x9a41,
0xffff,
0x99fa,
0xffff,
0xffff,
0x99f5,
0x99fb,
0x8dc6,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9a45,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x88f5,
0x9a4e,
0xffff,
0xffff,
0x9a46,
0x9a47,
0xffff,
0x8fa3,
0x9689,
0xffff,
0xffff,
0xffff,
0x9a4c,
0x9a4b,
0xffff,
0xffff,
0xffff,
0x934e,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9a4d,
0xffff,
0xffff,
0x9a4a,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x8953,
0xffff,
0x8db4,
0x904f,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9a48,
0x9382,
0xffff,
0xffff,
0xffff,
0x9a49,
0xffff,
0x88a0,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9a53,
0x9742,
0xffff,
0x8fa5,
0xffff,
0x9a59,
0xffff,
0xffff,
0xffff,
0xffff,
0x9a58,
0x9a4f,
0xffff,
0xffff,
0xffff,
0xffff,
0x91c1,
0xffff,
0x9a50,
0xffff,
0xffff,
0xffff,
0x91ed,
0x9a55,
0x8fa4,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9a52,
0xffff,
0xffff,
0x96e2,
0xffff,
0xffff,
0xffff,
0x8c5b,
0xffff,
0xffff,
0x9a56,
0x9a57,
0xffff,
0xffff,
0xffff,
0xffff,
0x9a54,
0x9a5a,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9a51,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9a60,
0x9a65,
0xffff,
0x9a61,
0xffff,
0x9a5c,
0xffff,
0xffff,
0x9a66,
0x9150,
0xffff,
0xffff,
0x9a68,
0xffff,
0x8d41,
0x9a5e,
0x929d,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9a62,
0x9a5b,
0x8aab,
0xffff,
0x8aec,
0x8a85,
0x9a63,
0x9a5f,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x8c96,
0x9a69,
0x9a67,
0x9172,
0x8b69,
0x8baa,
0xffff,
0x9a64,
0xffff,
0x8bf2,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x8963,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9a6d,
0x9a6b,
0xffff,
0x9aa5,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9a70,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9a6a,
0xffff,
0x9a6e,
0xffff,
0xffff,
0x9a6c,
0xffff,
0xffff,
0xffff,
0x8e6b,
0x9a6f,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9a72,
0xffff,
0x9a77,
0xffff,
0xffff,
0xffff,
0x9a75,
0x9a74,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9251,
0xffff,
0xffff,
0x89c3,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9a71,
0xffff,
0x9a73,
0x8fa6,
0x8952,
0xffff,
0xffff,
0x9a76,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x89dc,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9a82,
0xffff,
0x8ffa,
0x9a7d,
0xffff,
0x9a7b,
0xffff,
0x9a7c,
0xffff,
0x9a7e,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x895c,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9158,
0xffff,
0x9a78,
0xffff,
0x9a79,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x8a9a,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9a81,
0xffff,
0xffff,
0xffff,
0x8aed,
0xffff,
0x9a84,
0x9a80,
0x9a83,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x95ac,
0xffff,
0xffff,
0xffff,
0x93d3,
0xffff,
0x94b6,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9a86,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9a85,
0x8a64,
0xffff,
0xffff,
0x9a87,
0xffff,
0xffff,
0xffff,
0xffff,
0x9a8a,
0xffff,
0xffff,
0xffff,
0xffff,
0x9a89,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9a88,
0xffff,
0x9458,
0xffff,
0xffff,
0x9a8b,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9a8c,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9a8e,
0xffff,
0x9a8d,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9a90,
0xffff,
0xffff,
0xffff,
0x9a93,
0x9a91,
0x9a8f,
0x9a92,
0xffff,
0xffff,
0xffff,
0xffff,
0x9a94,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9a95,
0xffff,
0xffff,
0x9a96,
0xffff,
0x9a97,
0xffff,
0xffff,
0xffff,
0x9a98,
0x9964,
0xffff,
0x8efa,
0x8e6c,
0xffff,
0xffff,
0x89f1,
0xffff,
0x88f6,
0xffff,
0xffff,
0x9263,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9a99,
0xffff,
0x8da2,
0xffff,
0x88cd,
0x907d,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9a9a,
0x8cc5,
0xffff,
0xffff,
0x8d91,
0xffff,
0x9a9c,
0x9a9b,
0xffff,
0xffff,
0x95de,
0x9a9d,
0xffff,
0xffff,
0xffff,
0x9a9f,
0x9a9e,
0xffff,
0x9aa0,
0xffff,
0x9aa1,
0xffff,
0x8c97,
0xffff,
0xffff,
0x8980,
0x9aa2,
0xffff,
0xffff,
0x9aa4,
0xffff,
0x9aa3,
0xffff,
0xffff,
0xffff,
0x9aa6,
0xffff,
0xffff,
0x9379,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9aa7,
0x88b3,
0x8ddd,
0xffff,
0xffff,
0xffff,
0xffff,
0x8c5c,
0xffff,
0xffff,
0x926e,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9aa8,
0x9aa9,
0xffff,
0xffff,
0x9aab,
0xffff,
0xffff,
0xffff,
0xffff,
0x9aac,
0xffff,
0x8de2,
0xffff,
0xffff,
0xffff,
0xffff,
0x8bcf,
0xffff,
0xffff,
0x9656,
0xffff,
0xffff,
0xffff,
0x9aaa,
0x9aad,
0x8dbf,
0x8d42,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9ab1,
0xffff,
0xffff,
0x8da3,
0xffff,
0x9252,
0xffff,
0xffff,
0x9aae,
0x92d8,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9ab2,
0xffff,
0xffff,
0x9082,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9ab0,
0x9ab3,
0xffff,
0x8c5e,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9ab4,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9ab5,
0xffff,
0x8d43,
0x8a5f,
0x9ab7,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9ab8,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9ab9,
0xffff,
0xffff,
0x9ab6,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9aaf,
0xffff,
0xffff,
0x9aba,
0xffff,
0xffff,
0x9abb,
0xffff,
0xffff,
0xffff,
0xffff,
0x9684,
0xffff,
0xffff,
0x8fe9,
0xffff,
0xffff,
0xffff,
0x9abd,
0x9abe,
0x9abc,
0xffff,
0x9ac0,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9457,
0xffff,
0xffff,
0x88e6,
0x9575,
0xffff,
0xffff,
0x9ac1,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x8ffb,
0xffff,
0xffff,
0x8eb7,
0xffff,
0x947c,
0x8aee,
0xffff,
0x8de9,
0xffff,
0xffff,
0xffff,
0x9678,
0xffff,
0x93b0,
0xffff,
0xffff,
0x8c98,
0x91cd,
0xffff,
0xffff,
0xffff,
0x9abf,
0x9ac2,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x91c2,
0xffff,
0xffff,
0xffff,
0x9ac3,
0xffff,
0xffff,
0xffff,
0x9ac4,
0xffff,
0xffff,
0xffff,
0x9ac6,
0xffff,
0xffff,
0x92e7,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x8aac,
0xffff,
0xffff,
0xffff,
0xffff,
0xea9f,
0x8981,
0x95f1,
0xffff,
0xffff,
0x8fea,
0x9367,
0xffff,
0xffff,
0xffff,
0xffff,
0x8de4,
0xffff,
0xffff,
0x9acc,
0xffff,
0xffff,
0x95bb,
0x97db,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x89f2,
0x9ac8,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9159,
0x9acb,
0xffff,
0x9383,
0xffff,
0xffff,
0x9368,
0x9384,
0x94b7,
0x92cb,
0xffff,
0xffff,
0xffff,
0x8dc7,
0xffff,
0xffff,
0xffff,
0x9ac7,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x8996,
0xffff,
0x9355,
0xffff,
0xffff,
0xffff,
0xffff,
0x9ac9,
0xffff,
0x9ac5,
0xffff,
0xffff,
0x906f,
0xffff,
0xffff,
0xffff,
0x9acd,
0xffff,
0xffff,
0xffff,
0xffff,
0x8f6d,
0xffff,
0xffff,
0xffff,
0xffff,
0x8bab,
0xffff,
0x9ace,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x95e6,
0xffff,
0xffff,
0xffff,
0x919d,
0xffff,
0xffff,
0xffff,
0xffff,
0x92c4,
0xffff,
0xffff,
0x9ad0,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x966e,
0xffff,
0xffff,
0x9ad1,
0xffff,
0xffff,
0x9ad6,
0xffff,
0xffff,
0xffff,
0xffff,
0x95ad,
0xffff,
0xffff,
0xffff,
0xffff,
0x9ad5,
0x9acf,
0x9ad2,
0x9ad4,
0xffff,
0xffff,
0x8da4,
0xffff,
0xffff,
0x95c7,
0xffff,
0xffff,
0xffff,
0x9ad7,
0xffff,
0x9264,
0xffff,
0xffff,
0x89f3,
0xffff,
0x8feb,
0xffff,
0xffff,
0xffff,
0xffff,
0x9ad9,
0xffff,
0x9ad8,
0xffff,
0x8d88,
0xffff,
0x9ada,
0x9adc,
0x9adb,
0xffff,
0xffff,
0x9ade,
0xffff,
0x9ad3,
0x9ae0,
0xffff,
0xffff,
0xffff,
0xffff,
0x9adf,
0x9add,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x8e6d,
0x9070,
0xffff,
0x9173,
0x9ae1,
0x90ba,
0x88eb,
0x9484,
0xffff,
0xffff,
0xffff,
0xffff,
0x92d9,
0xffff,
0x9ae3,
0x9ae2,
0x9ae4,
0x9ae5,
0x9ae6,
0xffff,
0xffff,
0xffff,
0xffff,
0x9ae7,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x95cf,
0x9ae8,
0xffff,
0xffff,
0xffff,
0xffff,
0x89c4,
0x9ae9,
0xffff,
0xffff,
0xffff,
0xffff,
0x975b,
0x8a4f,
0xffff,
0x99c7,
0x8f67,
0x91bd,
0x9aea,
0x96e9,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x96b2,
0xffff,
0xffff,
0x9aec,
0xffff,
0x91e5,
0xffff,
0x9356,
0x91be,
0x9576,
0x9aed,
0x9aee,
0x899b,
0xffff,
0xffff,
0x8eb8,
0x9aef,
0xffff,
0xffff,
0xffff,
0xffff,
0x88ce,
0x9af0,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9af1,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x8982,
0xffff,
0xffff,
0x8aef,
0x93de,
0x95f2,
0xffff,
0xffff,
0xffff,
0xffff,
0x9af5,
0x9174,
0x9af4,
0x8c5f,
0xffff,
0xffff,
0x967a,
0x9af3,
0xffff,
0x9385,
0x9af7,
0xffff,
0x9af6,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9af9,
0xffff,
0x9af8,
0xffff,
0xffff,
0x899c,
0xffff,
0x9afa,
0x8fa7,
0x9afc,
0x9244,
0xffff,
0x9afb,
0xffff,
0x95b1,
0xffff,
0xffff,
0xffff,
0xffff,
0x8f97,
0x937a,
0xffff,
0xffff,
0xffff,
0x9b40,
0xffff,
0xffff,
0xffff,
0xffff,
0x8d44,
0xffff,
0xffff,
0xffff,
0x9b41,
0x9440,
0x94dc,
0x96cf,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9444,
0xffff,
0xffff,
0x9b4a,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x8b57,
0xffff,
0xffff,
0x9764,
0xffff,
0xffff,
0x96ad,
0xffff,
0x9baa,
0xffff,
0x9b42,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9b45,
0xffff,
0x91c3,
0xffff,
0xffff,
0x9657,
0xffff,
0xffff,
0xffff,
0x9369,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9b46,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9685,
0xffff,
0x8dc8,
0xffff,
0xffff,
0x8fa8,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9b47,
0xffff,
0xffff,
0x8e6f,
0xffff,
0x8e6e,
0xffff,
0xffff,
0xffff,
0xffff,
0x88b7,
0x8cc6,
0xffff,
0x90a9,
0x88cf,
0xffff,
0xffff,
0xffff,
0xffff,
0x9b4b,
0x9b4c,
0xffff,
0x9b49,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x8957,
0x8aad,
0xffff,
0x9b48,
0xffff,
0x96c3,
0x9550,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x88a6,
0xffff,
0xffff,
0xffff,
0xffff,
0x88f7,
0xffff,
0xffff,
0xffff,
0x8e70,
0xffff,
0x88d0,
0xffff,
0x88a1,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9b51,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9b4f,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x96ba,
0xffff,
0x9b52,
0xffff,
0x9b50,
0xffff,
0xffff,
0x9b4e,
0x9050,
0xffff,
0xffff,
0xffff,
0xffff,
0x9b4d,
0xffff,
0xffff,
0xffff,
0x95d8,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x8ce2,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9b56,
0x9b57,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x8fa9,
0xffff,
0xffff,
0xffff,
0x9b53,
0x984b,
0xffff,
0xffff,
0xffff,
0xffff,
0x946b,
0xffff,
0xffff,
0x9b55,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x8da5,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9b58,
0xffff,
0xffff,
0xffff,
0x9577,
0xffff,
0xffff,
0xffff,
0x9b59,
0xffff,
0x9b54,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x96b9,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x947d,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9b5a,
0x9551,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9b5b,
0x9b5f,
0x9b5c,
0xffff,
0xffff,
0x89c5,
0x9b5e,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x8eb9,
0xffff,
0x9b5d,
0x8c99,
0xffff,
0xffff,
0xffff,
0x9b6b,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9b64,
0x9b61,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9284,
0xffff,
0x9b60,
0xffff,
0xffff,
0x9b62,
0xffff,
0xffff,
0x9b63,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9b65,
0x9b66,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x8af0,
0xffff,
0x9b68,
0x9b67,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9b69,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x8fec,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9b6c,
0xffff,
0x92da,
0xffff,
0xffff,
0xffff,
0x8964,
0xffff,
0x9b6a,
0xffff,
0xffff,
0xffff,
0x9b6d,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9b6e,
0xffff,
0x9b71,
0xffff,
0xffff,
0x9b6f,
0xffff,
0x9b70,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x8e71,
0x9b72,
0xffff,
0xffff,
0x8d45,
0x9b73,
0xffff,
0x8e9a,
0x91b6,
0xffff,
0x9b74,
0x9b75,
0x8e79,
0x8d46,
0xffff,
0x96d0,
0xffff,
0xffff,
0xffff,
0x8b47,
0x8cc7,
0x9b76,
0x8a77,
0xffff,
0xffff,
0x9b77,
0xffff,
0x91b7,
0xffff,
0xffff,
0xffff,
0xffff,
0x9b78,
0x9ba1,
0xffff,
0x9b79,
0xffff,
0x9b7a,
0xffff,
0xffff,
0x9b7b,
0xffff,
0x9b7d,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9b7e,
0xffff,
0xffff,
0x9b80,
0xffff,
0x91ee,
0xffff,
0x8946,
0x8ee7,
0x88c0,
0xffff,
0x9176,
0x8aae,
0x8eb3,
0xffff,
0x8d47,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9386,
0xffff,
0x8f40,
0x8aaf,
0x9288,
0x92e8,
0x88b6,
0x8b58,
0x95f3,
0xffff,
0x8ec0,
0xffff,
0xffff,
0x8b71,
0x90e9,
0x8eba,
0x9747,
0x9b81,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x8b7b,
0xffff,
0x8dc9,
0xffff,
0xffff,
0x8a51,
0x8983,
0x8faa,
0x89c6,
0xffff,
0x9b82,
0x9765,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x8f68,
0xffff,
0xffff,
0x8ee2,
0x9b83,
0x8af1,
0x93d0,
0x96a7,
0x9b84,
0xffff,
0x9b85,
0xffff,
0xffff,
0x9578,
0xffff,
0xffff,
0xffff,
0x9b87,
0xffff,
0x8aa6,
0x8bf5,
0x9b86,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x8ab0,
0xffff,
0x9051,
0x9b8b,
0x8e40,
0xffff,
0x89c7,
0x9b8a,
0xffff,
0x9b88,
0x9b8c,
0x9b89,
0x944a,
0x9ecb,
0x9052,
0xffff,
0x9b8d,
0xffff,
0xffff,
0x97be,
0xffff,
0x9b8e,
0xffff,
0xffff,
0x9b90,
0xffff,
0x929e,
0x9b8f,
0xffff,
0x90a1,
0xffff,
0x8e9b,
0xffff,
0xffff,
0xffff,
0x91ce,
0x8ef5,
0xffff,
0x9595,
0x90ea,
0xffff,
0x8ecb,
0x9b91,
0x8fab,
0x9b92,
0x9b93,
0x88d1,
0x91b8,
0x9071,
0xffff,
0x9b94,
0x93b1,
0x8fac,
0xffff,
0x8fad,
0xffff,
0x9b95,
0xffff,
0xffff,
0x90eb,
0xffff,
0xffff,
0xffff,
0x8fae,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9b96,
0xffff,
0x9b97,
0xffff,
0x96de,
0xffff,
0xffff,
0xffff,
0x9b98,
0xffff,
0xffff,
0xffff,
0xffff,
0x8bc4,
0xffff,
0xffff,
0xffff,
0x8f41,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9b99,
0x9b9a,
0x8eda,
0x904b,
0x93f2,
0x9073,
0x94f6,
0x9441,
0x8bc7,
0x9b9b,
0xffff,
0xffff,
0xffff,
0x8b8f,
0x9b9c,
0xffff,
0x8bfc,
0xffff,
0x93cd,
0x89ae,
0xffff,
0x8e72,
0x9b9d,
0x9ba0,
0x9b9f,
0x8bfb,
0xffff,
0x9b9e,
0xffff,
0x9357,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x91ae,
0xffff,
0x936a,
0x8ec6,
0xffff,
0xffff,
0x9177,
0x979a,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9ba2,
0xffff,
0x9ba3,
0x93d4,
0xffff,
0x8e52,
0xffff,
0xffff,
0xffff,
0xffff,
0x9ba5,
0xffff,
0xffff,
0x9ba6,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9ba7,
0xffff,
0xffff,
0xffff,
0x8af2,
0x9ba8,
0xffff,
0xffff,
0x9ba9,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x89aa,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x915a,
0x8ae2,
0xffff,
0x9bab,
0x96a6,
0xffff,
0xffff,
0xffff,
0xffff,
0x91d0,
0xffff,
0x8a78,
0xffff,
0xffff,
0x9bad,
0x9baf,
0x8add,
0xffff,
0xffff,
0x9bac,
0x9bae,
0xffff,
0x9bb1,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9bb0,
0xffff,
0x9bb2,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9bb3,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x93bb,
0x8bac,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x89e3,
0x9bb4,
0x9bb9,
0xffff,
0xffff,
0x9bb7,
0xffff,
0x95f5,
0x95f4,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9387,
0xffff,
0xffff,
0xffff,
0x9bb6,
0x8f73,
0xffff,
0x9bb5,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9092,
0xffff,
0xffff,
0xffff,
0x9bba,
0xffff,
0xffff,
0x8de8,
0xffff,
0xffff,
0x9bc0,
0xffff,
0xffff,
0x9bc1,
0x9bbb,
0x8a52,
0x9bbc,
0x9bc5,
0x9bc4,
0x9bc3,
0x9bbf,
0xffff,
0xffff,
0xffff,
0x9bbe,
0xffff,
0xffff,
0x9bc2,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x95f6,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9bc9,
0x9bc6,
0xffff,
0x9bc8,
0xffff,
0x9792,
0xffff,
0x9bc7,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9bbd,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9093,
0xffff,
0xffff,
0x9bca,
0xffff,
0xffff,
0x8db5,
0xffff,
0xffff,
0xffff,
0x9bcb,
0xffff,
0xffff,
0x9bcc,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9bcf,
0xffff,
0x9bce,
0xffff,
0xffff,
0x9bcd,
0xffff,
0xffff,
0xffff,
0x9388,
0x9bb8,
0xffff,
0xffff,
0xffff,
0x9bd5,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9bd1,
0xffff,
0xffff,
0xffff,
0xffff,
0x9bd0,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9bd2,
0xffff,
0x9bd3,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9bd6,
0xffff,
0xffff,
0x97e4,
0xffff,
0x9bd7,
0x9bd4,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9bd8,
0xffff,
0xffff,
0x8ade,
0x9bd9,
0xffff,
0xffff,
0xffff,
0xffff,
0x9bdb,
0x9bda,
0xffff,
0xffff,
0x9bdc,
0xffff,
0xffff,
0xffff,
0xffff,
0x9bdd,
0xffff,
0x90ec,
0x8f42,
0xffff,
0xffff,
0x8f84,
0xffff,
0x9183,
0xffff,
0x8d48,
0x8db6,
0x8d49,
0x8b90,
0xffff,
0xffff,
0x9bde,
0xffff,
0xffff,
0x8db7,
0xffff,
0xffff,
0x8cc8,
0x9bdf,
0x96a4,
0x9462,
0x9be0,
0xffff,
0x8d4a,
0xffff,
0xffff,
0xffff,
0x8aaa,
0xffff,
0x9246,
0x8bd0,
0xffff,
0xffff,
0xffff,
0x8e73,
0x957a,
0xffff,
0xffff,
0x94bf,
0xffff,
0xffff,
0xffff,
0xffff,
0x9be1,
0x8af3,
0xffff,
0xffff,
0xffff,
0xffff,
0x9be4,
0xffff,
0xffff,
0xffff,
0xffff,
0x929f,
0xffff,
0xffff,
0x9be3,
0x9be2,
0x9be5,
0xffff,
0x92e9,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9083,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x8e74,
0xffff,
0x90c8,
0xffff,
0x91d1,
0x8b41,
0xffff,
0xffff,
0x92a0,
0xffff,
0xffff,
0x9be6,
0x9be7,
0x8fed,
0xffff,
0xffff,
0xffff,
0xffff,
0x9658,
0xffff,
0xffff,
0x9bea,
0xffff,
0xffff,
0x9be9,
0x9be8,
0x959d,
0xffff,
0x9bf1,
0xffff,
0xffff,
0xffff,
0xffff,
0x9679,
0xffff,
0x9beb,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9bed,
0x968b,
0xffff,
0x9bec,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9bee,
0xffff,
0x94a6,
0x9bef,
0x95bc,
0x9bf0,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x8ab1,
0x95bd,
0x944e,
0x9bf2,
0x9bf3,
0xffff,
0x8d4b,
0x8ab2,
0x9bf4,
0x8cb6,
0x9763,
0x9748,
0x8af4,
0x9bf6,
0xffff,
0x92a1,
0xffff,
0x8d4c,
0x8faf,
0xffff,
0xffff,
0x94dd,
0xffff,
0xffff,
0x8fb0,
0xffff,
0xffff,
0xffff,
0xffff,
0x8f98,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x92ea,
0x95f7,
0x9358,
0xffff,
0xffff,
0x8d4d,
0xffff,
0x957b,
0xffff,
0xffff,
0xffff,
0x9bf7,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9378,
0x8dc0,
0xffff,
0xffff,
0xffff,
0x8cc9,
0xffff,
0x92eb,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x88c1,
0x8f8e,
0x8d4e,
0x9766,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9bf8,
0x9bf9,
0x9470,
0xffff,
0xffff,
0xffff,
0xffff,
0x9bfa,
0x97f5,
0x984c,
0xffff,
0xffff,
0xffff,
0xffff,
0x9bfc,
0x9bfb,
0xffff,
0xffff,
0x8a66,
0xffff,
0xffff,
0x9c40,
0xffff,
0xffff,
0xffff,
0x9c43,
0x9c44,
0xffff,
0x9c42,
0xffff,
0x955f,
0x8fb1,
0x9c46,
0x9c45,
0x9c41,
0xffff,
0xffff,
0xffff,
0xffff,
0x9c47,
0x9c48,
0xffff,
0xffff,
0x9c49,
0xffff,
0xffff,
0xffff,
0x9c4c,
0x9c4a,
0xffff,
0x9c4b,
0x9c4d,
0xffff,
0x8984,
0x92ec,
0x9c4e,
0xffff,
0x8c9a,
0x89f4,
0x9455,
0xffff,
0x9c4f,
0x93f9,
0xffff,
0x95d9,
0xffff,
0x9c50,
0x984d,
0xffff,
0xffff,
0xffff,
0xffff,
0x9c51,
0x95be,
0x9c54,
0x989f,
0x98af,
0xffff,
0x8eae,
0x93f3,
0x9c55,
0xffff,
0x8b7c,
0x92a2,
0x88f8,
0x9c56,
0x95a4,
0x8d4f,
0xffff,
0xffff,
0x926f,
0xffff,
0xffff,
0xffff,
0x92ed,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x96ed,
0x8cb7,
0x8cca,
0xffff,
0x9c57,
0xffff,
0xffff,
0xffff,
0x9c58,
0xffff,
0x9c5e,
0xffff,
0x8ee3,
0xffff,
0xffff,
0xffff,
0x92a3,
0xffff,
0x8bad,
0x9c59,
0xffff,
0xffff,
0xffff,
0x954a,
0xffff,
0x9265,
0xffff,
0xffff,
0x9c5a,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9c5b,
0xffff,
0x8bae,
0xffff,
0x9c5c,
0xffff,
0x9c5d,
0xffff,
0xffff,
0x9c5f,
0xffff,
0x9396,
0xffff,
0xffff,
0x9c60,
0x9c61,
0xffff,
0x9c62,
0xffff,
0xffff,
0x9c53,
0x9c52,
0xffff,
0xffff,
0xffff,
0x9c63,
0x8c60,
0xffff,
0xffff,
0xffff,
0x9546,
0xffff,
0xffff,
0x8dca,
0x9556,
0x92a4,
0x956a,
0x9c64,
0xffff,
0xffff,
0x8fb2,
0x8965,
0xffff,
0x9c65,
0xffff,
0xffff,
0xffff,
0x9c66,
0xffff,
0x96f0,
0xffff,
0xffff,
0x94de,
0xffff,
0xffff,
0x9c69,
0x899d,
0x90aa,
0x9c68,
0x9c67,
0x8c61,
0x91d2,
0xffff,
0x9c6d,
0x9c6b,
0xffff,
0x9c6a,
0x97a5,
0x8ce3,
0xffff,
0xffff,
0xffff,
0x8f99,
0x9c6c,
0x936b,
0x8f5d,
0xffff,
0xffff,
0xffff,
0x93be,
0x9c70,
0x9c6f,
0xffff,
0xffff,
0xffff,
0xffff,
0x9c6e,
0xffff,
0x9c71,
0x8ce4,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9c72,
0x959c,
0x8f7a,
0xffff,
0xffff,
0x9c73,
0x94f7,
0xffff,
0xffff,
0xffff,
0xffff,
0x93bf,
0x92a5,
0xffff,
0xffff,
0xffff,
0xffff,
0x934f,
0xffff,
0xffff,
0x9c74,
0x8b4a,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9053,
0xffff,
0x954b,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x8af5,
0x9445,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9c75,
0x8e75,
0x9659,
0x965a,
0xffff,
0xffff,
0x899e,
0x9c7a,
0xffff,
0xffff,
0x9289,
0xffff,
0xffff,
0xffff,
0x9c77,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x89f5,
0xffff,
0xffff,
0xffff,
0xffff,
0x9cab,
0x9c79,
0xffff,
0xffff,
0xffff,
0x944f,
0xffff,
0xffff,
0x9c78,
0xffff,
0xffff,
0x9c76,
0xffff,
0x8d9a,
0xffff,
0x9c7c,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9c83,
0x9c89,
0x9c81,
0xffff,
0x937b,
0xffff,
0xffff,
0x9c86,
0x957c,
0xffff,
0xffff,
0x9c80,
0xffff,
0x9c85,
0x97e5,
0x8e76,
0xffff,
0xffff,
0x91d3,
0x9c7d,
0xffff,
0xffff,
0xffff,
0x8b7d,
0x9c88,
0x90ab,
0x8985,
0x9c82,
0x89f6,
0x9c87,
0xffff,
0xffff,
0xffff,
0x8baf,
0xffff,
0x9c84,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9c8a,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9c8c,
0x9c96,
0x9c94,
0xffff,
0xffff,
0x9c91,
0xffff,
0xffff,
0xffff,
0x9c90,
0x97f6,
0xffff,
0x9c92,
0xffff,
0xffff,
0x8bb0,
0xffff,
0x8d50,
0xffff,
0xffff,
0x8f9a,
0xffff,
0xffff,
0xffff,
0x9c99,
0x9c8b,
0xffff,
0xffff,
0xffff,
0xffff,
0x9c8f,
0x9c7e,
0xffff,
0x89f8,
0x9c93,
0x9c95,
0x9270,
0xffff,
0xffff,
0x8da6,
0x89b6,
0x9c8d,
0x9c98,
0x9c97,
0x8bb1,
0xffff,
0x91a7,
0x8a86,
0xffff,
0xffff,
0xffff,
0xffff,
0x8c62,
0xffff,
0x9c8e,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9c9a,
0xffff,
0x9c9d,
0x9c9f,
0xffff,
0xffff,
0xffff,
0xffff,
0x8ebb,
0xffff,
0x9ca5,
0x92ee,
0x9c9b,
0xffff,
0xffff,
0xffff,
0xffff,
0x9ca3,
0xffff,
0x89f7,
0xffff,
0x9ca1,
0x9ca2,
0xffff,
0xffff,
0x9c9e,
0x9ca0,
0xffff,
0xffff,
0xffff,
0x8ce5,
0x9749,
0xffff,
0xffff,
0x8ab3,
0xffff,
0xffff,
0x8978,
0x9ca4,
0xffff,
0x9459,
0x88ab,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x94df,
0x9c7b,
0x9caa,
0x9cae,
0x96e3,
0xffff,
0x9ca7,
0xffff,
0xffff,
0xffff,
0x9389,
0x9cac,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x8fee,
0x9cad,
0x93d5,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9866,
0xffff,
0x9ca9,
0xffff,
0xffff,
0xffff,
0xffff,
0x9caf,
0xffff,
0x8d9b,
0xffff,
0x90c9,
0xffff,
0xffff,
0x88d2,
0x9ca8,
0x9ca6,
0xffff,
0x9179,
0xffff,
0xffff,
0xffff,
0x9c9c,
0x8e53,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x91c4,
0x9cbb,
0xffff,
0x917a,
0x9cb6,
0xffff,
0x9cb3,
0x9cb4,
0xffff,
0x8ee4,
0x9cb7,
0x9cba,
0xffff,
0xffff,
0xffff,
0xffff,
0x9cb5,
0x8f44,
0xffff,
0x9cb8,
0xffff,
0xffff,
0x9cb2,
0xffff,
0x96fa,
0x96f9,
0xffff,
0xffff,
0xffff,
0x9cbc,
0x9cbd,
0x88d3,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9cb1,
0xffff,
0xffff,
0xffff,
0xffff,
0x8bf0,
0x88a4,
0xffff,
0xffff,
0xffff,
0x8ab4,
0xffff,
0x9cb9,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9cc1,
0x9cc0,
0xffff,
0xffff,
0xffff,
0x9cc5,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9cc6,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9cc4,
0x9cc7,
0x9cbf,
0x9cc3,
0xffff,
0xffff,
0x9cc8,
0xffff,
0x9cc9,
0xffff,
0xffff,
0x9cbe,
0x8e9c,
0xffff,
0x9cc2,
0x91d4,
0x8d51,
0x9cb0,
0x9054,
0xffff,
0xffff,
0xffff,
0xffff,
0x9cd6,
0xffff,
0x95e7,
0xffff,
0xffff,
0x9ccc,
0x9ccd,
0x9cce,
0xffff,
0xffff,
0x9cd5,
0xffff,
0x9cd4,
0xffff,
0xffff,
0x969d,
0x8ab5,
0xffff,
0x9cd2,
0xffff,
0x8c64,
0x8a53,
0xffff,
0xffff,
0x9ccf,
0xffff,
0xffff,
0x97b6,
0x9cd1,
0x88d4,
0x9cd3,
0xffff,
0x9cca,
0x9cd0,
0x9cd7,
0x8c63,
0x9ccb,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x977c,
0xffff,
0xffff,
0xffff,
0x974a,
0xffff,
0xffff,
0xffff,
0xffff,
0x9cda,
0xffff,
0xffff,
0x9cde,
0xffff,
0xffff,
0xffff,
0x919e,
0xffff,
0x97f7,
0x9cdf,
0xffff,
0xffff,
0x9cdc,
0xffff,
0x9cd9,
0xffff,
0xffff,
0x9cd8,
0x9cdd,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x95ae,
0xffff,
0xffff,
0x93b2,
0xffff,
0x8c65,
0xffff,
0x9ce0,
0x9cdb,
0xffff,
0x9ce1,
0xffff,
0xffff,
0xffff,
0x8c9b,
0xffff,
0xffff,
0xffff,
0x89af,
0xffff,
0xffff,
0xffff,
0x9ce9,
0xffff,
0xffff,
0xffff,
0x8ab6,
0xffff,
0xffff,
0xffff,
0xffff,
0x9ce7,
0xffff,
0xffff,
0x9ce8,
0x8da7,
0x9ce6,
0x9ce4,
0x9ce3,
0x9cea,
0x9ce2,
0x9cec,
0xffff,
0xffff,
0x89f9,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9cee,
0xffff,
0xffff,
0x9ced,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x92a6,
0xffff,
0x9cf1,
0xffff,
0x9cef,
0x9ce5,
0x8c9c,
0xffff,
0x9cf0,
0xffff,
0x9cf4,
0x9cf3,
0x9cf5,
0x9cf2,
0x9cf6,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9cf7,
0x9cf8,
0x95e8,
0xffff,
0x9cfa,
0x9cf9,
0x8f5e,
0xffff,
0x90ac,
0x89e4,
0x89fa,
0xffff,
0x9cfb,
0xffff,
0x88bd,
0xffff,
0xffff,
0xffff,
0x90ca,
0x9cfc,
0xffff,
0xe6c1,
0x9d40,
0x8c81,
0xffff,
0x9d41,
0xffff,
0xffff,
0xffff,
0xffff,
0x90ed,
0xffff,
0xffff,
0xffff,
0x9d42,
0xffff,
0xffff,
0xffff,
0x9d43,
0x8b59,
0x9d44,
0xffff,
0x9d45,
0x9d46,
0x91d5,
0xffff,
0xffff,
0xffff,
0x8ccb,
0xffff,
0xffff,
0x96df,
0xffff,
0xffff,
0xffff,
0x965b,
0x8f8a,
0x9d47,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x90ee,
0xe7bb,
0x94e0,
0xffff,
0x8ee8,
0xffff,
0x8dcb,
0x9d48,
0xffff,
0xffff,
0xffff,
0xffff,
0x91c5,
0xffff,
0x95a5,
0xffff,
0xffff,
0x91ef,
0xffff,
0xffff,
0x9d4b,
0xffff,
0xffff,
0x9d49,
0xffff,
0x9d4c,
0xffff,
0xffff,
0x9d4a,
0xffff,
0xffff,
0xffff,
0xffff,
0x9d4d,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x95af,
0xffff,
0xffff,
0x88b5,
0xffff,
0xffff,
0xffff,
0xffff,
0x957d,
0xffff,
0xffff,
0x94e1,
0xffff,
0xffff,
0x9d4e,
0xffff,
0x9d51,
0x8fb3,
0x8b5a,
0xffff,
0x9d4f,
0x9d56,
0x8fb4,
0xffff,
0xffff,
0xffff,
0xffff,
0x9d50,
0x9463,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x977d,
0x9d52,
0x9d53,
0x9d57,
0x938a,
0x9d54,
0x8d52,
0x90dc,
0xffff,
0xffff,
0x9d65,
0x94b2,
0xffff,
0x91f0,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x94e2,
0x9dab,
0xffff,
0xffff,
0xffff,
0xffff,
0x95f8,
0xffff,
0xffff,
0xffff,
0x92ef,
0xffff,
0xffff,
0xffff,
0x9695,
0xffff,
0x9d5a,
0x899f,
0x928a,
0xffff,
0xffff,
0xffff,
0xffff,
0x9d63,
0xffff,
0xffff,
0x9253,
0x9d5d,
0x9d64,
0x9d5f,
0x9d66,
0x9d62,
0xffff,
0x9d61,
0x948f,
0xffff,
0x9d5b,
0x89fb,
0x9d59,
0x8b91,
0x91f1,
0x9d55,
0xffff,
0xffff,
0x9d58,
0x8d53,
0x90d9,
0xffff,
0x8fb5,
0x9d60,
0x9471,
0xffff,
0xffff,
0x8b92,
0x8a67,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x8a87,
0x9040,
0x9d68,
0x9d6d,
0xffff,
0x9d69,
0xffff,
0x8c9d,
0xffff,
0x9d6e,
0x8e41,
0x8d89,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x8f45,
0x9d5c,
0xffff,
0x8e9d,
0x9d6b,
0xffff,
0xffff,
0xffff,
0xffff,
0x8e77,
0x9d6c,
0x88c2,
0xffff,
0xffff,
0x9d67,
0xffff,
0xffff,
0xffff,
0xffff,
0x92a7,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x8b93,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x8bb2,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9d6a,
0x88a5,
0xffff,
0xffff,
0x8dc1,
0xffff,
0xffff,
0xffff,
0x9055,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x92f0,
0xffff,
0xffff,
0x94d2,
0x9d70,
0x917d,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x91a8,
0xffff,
0xffff,
0x8e4a,
0x9d71,
0xffff,
0x9d73,
0x9d6f,
0xffff,
0xffff,
0xffff,
0xffff,
0x95df,
0xffff,
0x92bb,
0xffff,
0xffff,
0xffff,
0xffff,
0x917b,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x95f9,
0x8ecc,
0x9d80,
0xffff,
0x9d7e,
0xffff,
0xffff,
0x9098,
0xffff,
0xffff,
0xffff,
0x8c9e,
0xffff,
0xffff,
0xffff,
0x9d78,
0x8fb7,
0xffff,
0xffff,
0x93e6,
0x9450,
0xffff,
0xffff,
0xffff,
0xffff,
0x9d76,
0xffff,
0xffff,
0x917c,
0xffff,
0xffff,
0xffff,
0xffff,
0x8ef6,
0x9d7b,
0xffff,
0xffff,
0x8fb6,
0xffff,
0x9d75,
0x9d7a,
0xffff,
0xffff,
0x9472,
0xffff,
0xffff,
0xffff,
0x9d74,
0xffff,
0x8c40,
0xffff,
0xffff,
0x8a7c,
0xffff,
0xffff,
0xffff,
0x9d7c,
0x97a9,
0x8dcc,
0x9254,
0x9d79,
0xffff,
0x90da,
0xffff,
0x8d54,
0x9084,
0x8986,
0x915b,
0x9d77,
0x8b64,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x8c66,
0xffff,
0x92cd,
0x9d7d,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x917e,
0xffff,
0xffff,
0x9d81,
0xffff,
0x9d83,
0xffff,
0xffff,
0x91b5,
0x9d89,
0xffff,
0x9d84,
0xffff,
0xffff,
0x9d86,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9560,
0x92f1,
0xffff,
0x9d87,
0xffff,
0xffff,
0xffff,
0x974b,
0xffff,
0xffff,
0xffff,
0x9767,
0x8ab7,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x88ac,
0xffff,
0x9d85,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9d82,
0xffff,
0xffff,
0xffff,
0xffff,
0x8af6,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x8987,
0xffff,
0x9d88,
0xffff,
0xffff,
0xffff,
0x9768,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9d8c,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x91b9,
0xffff,
0x9d93,
0xffff,
0xffff,
0xffff,
0x9d8d,
0xffff,
0xffff,
0x9d8a,
0x9d91,
0xffff,
0xffff,
0xffff,
0xffff,
0x9d72,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9d8e,
0xffff,
0x9d92,
0xffff,
0xffff,
0xffff,
0x94c0,
0x938b,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9d8b,
0xffff,
0x9d8f,
0xffff,
0xffff,
0xffff,
0x8c67,
0xffff,
0xffff,
0xffff,
0x8def,
0xffff,
0xffff,
0xffff,
0x90db,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9d97,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9345,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9d94,
0xffff,
0x9680,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9d95,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9d96,
0xffff,
0x96cc,
0xffff,
0x90a0,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x8c82,
0xffff,
0xffff,
0xffff,
0xffff,
0x9d9d,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x8e54,
0x9d9a,
0xffff,
0x9d99,
0xffff,
0xffff,
0xffff,
0xffff,
0x9451,
0xffff,
0xffff,
0xffff,
0x93b3,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9350,
0x9d9b,
0xffff,
0xffff,
0xffff,
0x9d9c,
0xffff,
0x958f,
0xffff,
0x9464,
0x8e42,
0xffff,
0x90ef,
0xffff,
0x966f,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x8a68,
0xffff,
0x9da3,
0x9d9e,
0xffff,
0xffff,
0xffff,
0xffff,
0x9769,
0x9da5,
0xffff,
0xffff,
0x9da1,
0xffff,
0x9da2,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9180,
0xffff,
0xffff,
0xffff,
0xffff,
0x9da0,
0xffff,
0x9d5e,
0xffff,
0xffff,
0xffff,
0x9da4,
0xffff,
0x9d9f,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9da9,
0x9daa,
0x9346,
0x9dac,
0xffff,
0xffff,
0x8e43,
0x9da7,
0xffff,
0xffff,
0xffff,
0xffff,
0x8b5b,
0xffff,
0xffff,
0x9dad,
0xffff,
0x9da6,
0x9db1,
0xffff,
0x9db0,
0xffff,
0x9daf,
0xffff,
0xffff,
0xffff,
0x9db2,
0xffff,
0xffff,
0x9db4,
0x8fef,
0xffff,
0x9db3,
0xffff,
0xffff,
0xffff,
0xffff,
0x9db7,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9db5,
0xffff,
0xffff,
0xffff,
0x9db6,
0x9d90,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9db9,
0x9db8,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9d98,
0x9dba,
0x9dae,
0xffff,
0xffff,
0x8e78,
0xffff,
0xffff,
0xffff,
0xffff,
0x9dbb,
0x9dbc,
0x9dbe,
0x9dbd,
0x9dbf,
0x89fc,
0xffff,
0x8d55,
0xffff,
0xffff,
0x95fa,
0x90ad,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x8ccc,
0xffff,
0xffff,
0x9dc1,
0xffff,
0xffff,
0xffff,
0xffff,
0x9dc4,
0xffff,
0x9571,
0xffff,
0x8b7e,
0xffff,
0xffff,
0xffff,
0x9dc3,
0x9dc2,
0x9473,
0x9dc5,
0x8bb3,
0xffff,
0xffff,
0xffff,
0x9dc7,
0x9dc6,
0xffff,
0xffff,
0xffff,
0x8ab8,
0x8e55,
0xffff,
0xffff,
0x93d6,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x8c68,
0xffff,
0xffff,
0xffff,
0x9094,
0xffff,
0x9dc8,
0xffff,
0x90ae,
0x9347,
0xffff,
0x957e,
0x9dc9,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9dca,
0x9dcb,
0xffff,
0xffff,
0xffff,
0x95b6,
0x9b7c,
0x90c4,
0xffff,
0xffff,
0x956b,
0xffff,
0x8dd6,
0xffff,
0x94e3,
0x94c1,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x936c,
0xffff,
0x97bf,
0xffff,
0x9dcd,
0x8ece,
0xffff,
0xffff,
0x9dce,
0xffff,
0x88b4,
0xffff,
0xffff,
0x8bd2,
0x90cb,
0xffff,
0x9580,
0xffff,
0xffff,
0xffff,
0x9dcf,
0x8e61,
0x9266,
0xffff,
0x8e7a,
0x9056,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9dd0,
0xffff,
0x95fb,
0xffff,
0xffff,
0x8997,
0x8e7b,
0xffff,
0xffff,
0xffff,
0x9dd3,
0xffff,
0x9dd1,
0x9dd4,
0x97b7,
0x9dd2,
0xffff,
0xffff,
0xffff,
0xffff,
0x90f9,
0x9dd5,
0xffff,
0xffff,
0x91b0,
0xffff,
0xffff,
0x9dd6,
0xffff,
0xffff,
0xffff,
0xffff,
0x8af8,
0xffff,
0x9dd8,
0xffff,
0x9dd7,
0xffff,
0xffff,
0xffff,
0xffff,
0x9dd9,
0x9dda,
0x8af9,
0xffff,
0xffff,
0x93fa,
0x9255,
0x8b8c,
0x8e7c,
0x9181,
0xffff,
0xffff,
0x8f7b,
0x88ae,
0xffff,
0xffff,
0xffff,
0x9ddb,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x89a0,
0x9ddf,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x8d56,
0x9dde,
0xffff,
0xffff,
0x8da9,
0x8fb8,
0xffff,
0xffff,
0x9ddd,
0xffff,
0x8fb9,
0xffff,
0x96be,
0x8da8,
0xffff,
0xffff,
0xffff,
0x88d5,
0x90cc,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9de4,
0xffff,
0xffff,
0x90af,
0x8966,
0xffff,
0xffff,
0xffff,
0xffff,
0x8f74,
0xffff,
0x9686,
0x8df0,
0xffff,
0xffff,
0xffff,
0xffff,
0x8fba,
0xffff,
0x90a5,
0xffff,
0xffff,
0xffff,
0xffff,
0x9de3,
0x9de1,
0x9de2,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x928b,
0xffff,
0xffff,
0x9e45,
0xffff,
0x9de8,
0x8e9e,
0x8d57,
0x9de6,
0xffff,
0xffff,
0xffff,
0xffff,
0x9de7,
0xffff,
0x9057,
0xffff,
0xffff,
0xffff,
0x9de5,
0xffff,
0xffff,
0x8e4e,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9dea,
0x9de9,
0x9dee,
0xffff,
0xffff,
0x9def,
0xffff,
0x9deb,
0xffff,
0x8a41,
0x9dec,
0x9ded,
0x94d3,
0xffff,
0xffff,
0xffff,
0xffff,
0x9581,
0x8c69,
0x9df0,
0xffff,
0xffff,
0xffff,
0x90b0,
0xffff,
0x8fbb,
0xffff,
0xffff,
0xffff,
0x9271,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x8bc5,
0xffff,
0x9df1,
0x9df5,
0xffff,
0xffff,
0x89c9,
0x9df2,
0x9df4,
0xffff,
0xffff,
0xffff,
0xffff,
0x9df3,
0xffff,
0xffff,
0x8f8b,
0xffff,
0xffff,
0xffff,
0xffff,
0x9267,
0x88c3,
0x9df6,
0xffff,
0xffff,
0xffff,
0xffff,
0x9df7,
0xffff,
0xffff,
0xffff,
0xffff,
0x92a8,
0xffff,
0xffff,
0xffff,
0x97ef,
0xffff,
0xffff,
0xffff,
0xffff,
0x8e62,
0xffff,
0xffff,
0x95e9,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x965c,
0xffff,
0xffff,
0xffff,
0x9e41,
0x9df9,
0xffff,
0xffff,
0x9dfc,
0xffff,
0x9dfb,
0xffff,
0xffff,
0x9df8,
0xffff,
0xffff,
0x9e40,
0xffff,
0xffff,
0x93dc,
0xffff,
0x9dfa,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9e42,
0xffff,
0xffff,
0x8f8c,
0x9e43,
0xffff,
0x976a,
0x9498,
0xffff,
0xffff,
0x9e44,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9e46,
0xffff,
0xffff,
0x9e47,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9e48,
0xffff,
0x8bc8,
0x8967,
0x8d58,
0x9e49,
0xffff,
0x9e4a,
0x8f91,
0x9182,
0xffff,
0xffff,
0x99d6,
0x915d,
0x915c,
0x91d6,
0x8dc5,
0xffff,
0xffff,
0x98f0,
0xffff,
0xffff,
0xffff,
0xffff,
0x8c8e,
0x974c,
0xffff,
0x95fc,
0xffff,
0x959e,
0xffff,
0x9e4b,
0xffff,
0xffff,
0xffff,
0xffff,
0x8df1,
0x92bd,
0x9e4c,
0x984e,
0xffff,
0xffff,
0xffff,
0x965d,
0xffff,
0x92a9,
0x9e4d,
0x8afa,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9e4e,
0x9e4f,
0x96d8,
0xffff,
0x96a2,
0x9696,
0x967b,
0x8e44,
0x9e51,
0xffff,
0xffff,
0x8ee9,
0xffff,
0xffff,
0x9670,
0xffff,
0x9e53,
0x9e56,
0x9e55,
0xffff,
0x8af7,
0xffff,
0xffff,
0x8b80,
0xffff,
0x9e52,
0xffff,
0x9e54,
0xffff,
0xffff,
0xffff,
0xffff,
0x9e57,
0xffff,
0xffff,
0x9099,
0xffff,
0xffff,
0xffff,
0xffff,
0x979b,
0x88c7,
0x8dde,
0x91ba,
0xffff,
0x8edb,
0xffff,
0xffff,
0x8ff1,
0xffff,
0xffff,
0x9e5a,
0xffff,
0xffff,
0x936d,
0xffff,
0x9e58,
0x91a9,
0x9e59,
0x8ff0,
0x96db,
0x9e5b,
0x9e5c,
0x9788,
0xffff,
0xffff,
0xffff,
0xffff,
0x9e61,
0xffff,
0xffff,
0x8d59,
0xffff,
0x9474,
0x9e5e,
0x938c,
0x9ddc,
0x9de0,
0xffff,
0x8b6e,
0xffff,
0x9466,
0xffff,
0xffff,
0xffff,
0xffff,
0x9e60,
0xffff,
0x8fbc,
0x94c2,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9e66,
0xffff,
0x94f8,
0xffff,
0x9e5d,
0xffff,
0x9e63,
0x9e62,
0xffff,
0xffff,
0xffff,
0x90cd,
0xffff,
0xffff,
0xffff,
0xffff,
0x968d,
0xffff,
0x97d1,
0xffff,
0xffff,
0x9687,
0xffff,
0x89ca,
0x8e7d,
0xffff,
0xffff,
0x9867,
0x9e65,
0x9095,
0xffff,
0xffff,
0xffff,
0x9e64,
0xffff,
0xffff,
0x9e5f,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x8ccd,
0xffff,
0xffff,
0xffff,
0x9e6b,
0x9e69,
0xffff,
0x89cb,
0x9e67,
0x9e6d,
0x9e73,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x91c6,
0xffff,
0xffff,
0x95bf,
0xffff,
0x9e75,
0xffff,
0xffff,
0xffff,
0x9541,
0xffff,
0xffff,
0xffff,
0x9e74,
0x9490,
0x965e,
0x8ab9,
0xffff,
0x90f5,
0x8f5f,
0xffff,
0xffff,
0xffff,
0x92d1,
0xffff,
0x974d,
0xffff,
0xffff,
0x9e70,
0x9e6f,
0xffff,
0xffff,
0xffff,
0x9e71,
0xffff,
0x9e6e,
0xffff,
0xffff,
0x9e76,
0xffff,
0x9e6c,
0xffff,
0xffff,
0x9e6a,
0xffff,
0x9e72,
0x9e68,
0xffff,
0x928c,
0xffff,
0x96f6,
0x8ec4,
0x8df2,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x8db8,
0xffff,
0xffff,
0x968f,
0x8a60,
0xffff,
0xffff,
0x92cc,
0x93c8,
0x8968,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x90f0,
0xffff,
0xffff,
0x90b2,
0x8c49,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9e78,
0xffff,
0xffff,
0x8d5a,
0x8a9c,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9e7a,
0x8a94,
0x9e81,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9e7d,
0xffff,
0x90f1,
0xffff,
0xffff,
0xffff,
0x8a6a,
0x8daa,
0xffff,
0xffff,
0x8a69,
0x8dcd,
0xffff,
0xffff,
0x9e7b,
0x8c85,
0x8c6a,
0x938d,
0xffff,
0xffff,
0x9e79,
0xffff,
0x88c4,
0xffff,
0xffff,
0xffff,
0xffff,
0x9e7c,
0x9e7e,
0xffff,
0x8bcb,
0x8c4b,
0xffff,
0x8aba,
0x8b6a,
0xffff,
0xffff,
0xffff,
0xffff,
0x9e82,
0xffff,
0xffff,
0x8df7,
0x9691,
0xffff,
0x8e56,
0xffff,
0xffff,
0xffff,
0x9e83,
0xffff,
0xffff,
0xffff,
0x954f,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9e8f,
0xffff,
0x89b1,
0x9e84,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9e95,
0x9e85,
0xffff,
0x97c0,
0xffff,
0x9e8c,
0xffff,
0x947e,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9e94,
0xffff,
0x9e87,
0xffff,
0xffff,
0xffff,
0x88b2,
0x9e89,
0xffff,
0xffff,
0x8d5b,
0xffff,
0xffff,
0xffff,
0x9e8b,
0xffff,
0x9e8a,
0xffff,
0x9e86,
0x9e91,
0xffff,
0x8fbd,
0xffff,
0xffff,
0xffff,
0x9aeb,
0x8ce6,
0x979c,
0xffff,
0xffff,
0xffff,
0xffff,
0x9e88,
0xffff,
0x92f2,
0x8a42,
0x8dab,
0xffff,
0x9e80,
0xffff,
0x9e90,
0x8a81,
0xffff,
0xffff,
0x9e8e,
0x9e92,
0xffff,
0x938e,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x8afc,
0xffff,
0x9eb0,
0xffff,
0xffff,
0x96c7,
0x9e97,
0x8afb,
0xffff,
0x9e9e,
0xffff,
0xffff,
0xffff,
0xffff,
0x965f,
0xffff,
0x9e9f,
0x9ea1,
0xffff,
0x9ea5,
0x9e99,
0xffff,
0x9249,
0xffff,
0xffff,
0xffff,
0xffff,
0x938f,
0x9ea9,
0x9e9c,
0xffff,
0x9ea6,
0xffff,
0xffff,
0xffff,
0x9ea0,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9058,
0x9eaa,
0xffff,
0xffff,
0x90b1,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9ea8,
0x8abb,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x986f,
0x9e96,
0xffff,
0xffff,
0x9ea4,
0x88d6,
0xffff,
0xffff,
0x9e98,
0xffff,
0xffff,
0x96b8,
0x9e9d,
0x9041,
0x92c5,
0x9e93,
0xffff,
0xffff,
0x9ea3,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x909a,
0x9ead,
0x8a91,
0x8c9f,
0xffff,
0xffff,
0xffff,
0xffff,
0x9eaf,
0x9e9a,
0x9eae,
0xffff,
0x9ea7,
0x9e9b,
0xffff,
0x9eab,
0xffff,
0x9eac,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9ebd,
0xffff,
0xffff,
0xffff,
0x93cc,
0xffff,
0x9ea2,
0xffff,
0xffff,
0x9eb9,
0xffff,
0xffff,
0xffff,
0x9ebb,
0xffff,
0x92d6,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x976b,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9596,
0x9eb6,
0x91c8,
0xffff,
0xffff,
0xffff,
0x9ebc,
0x915e,
0xffff,
0x9eb3,
0x9ec0,
0x9ebf,
0xffff,
0x93ed,
0x9ebe,
0x93e8,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9ec2,
0x9eb5,
0xffff,
0x8bc6,
0x9eb8,
0x8f7c,
0xffff,
0xffff,
0xffff,
0x9480,
0x9eba,
0x8bc9,
0xffff,
0x9eb2,
0x9eb4,
0x9eb1,
0xffff,
0xffff,
0x984f,
0x8a79,
0x9eb7,
0xffff,
0xffff,
0x9ec1,
0x8a54,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x8de5,
0xffff,
0xffff,
0xffff,
0x897c,
0xffff,
0xffff,
0x9ed2,
0xffff,
0xffff,
0x9850,
0x9ed5,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9059,
0x9ed4,
0xffff,
0xffff,
0xffff,
0x9ed3,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9ed0,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9ec4,
0xffff,
0xffff,
0x9ee1,
0x9ec3,
0xffff,
0x9ed6,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9ece,
0xffff,
0xffff,
0x9ec9,
0x9ec6,
0xffff,
0x9ec7,
0xffff,
0x9ecf,
0xffff,
0xffff,
0xffff,
0xeaa0,
0xffff,
0xffff,
0x9ecc,
0x8d5c,
0x92c6,
0x9184,
0x9eca,
0xffff,
0x9ec5,
0xffff,
0xffff,
0x9ec8,
0xffff,
0xffff,
0xffff,
0xffff,
0x976c,
0x968a,
0xffff,
0xffff,
0xffff,
0x9ecd,
0x9ed7,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9edf,
0x9ed8,
0xffff,
0xffff,
0x9ee5,
0xffff,
0x9ee3,
0xffff,
0xffff,
0xffff,
0xffff,
0x9ede,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9edd,
0xffff,
0x92ce,
0xffff,
0x9185,
0xffff,
0x9edb,
0xffff,
0xffff,
0x9ed9,
0xffff,
0xffff,
0x9ee0,
0xffff,
0xffff,
0xffff,
0xffff,
0x9ee6,
0x94f3,
0x9eec,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9ee7,
0x9eea,
0x9ee4,
0xffff,
0xffff,
0x9294,
0xffff,
0x9557,
0xffff,
0x9eda,
0xffff,
0xffff,
0x9ee2,
0x8fbe,
0xffff,
0x96cd,
0x9ef6,
0x9ee9,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x8ca0,
0x89a1,
0x8a7e,
0xffff,
0xffff,
0x9ed1,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x8fbf,
0x9eee,
0xffff,
0x9ef5,
0x8ef7,
0x8a92,
0xffff,
0xffff,
0x924d,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9eeb,
0xffff,
0xffff,
0x9ef0,
0x9ef4,
0xffff,
0xffff,
0x8bb4,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x8b6b,
0x9ef2,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x8b40,
0xffff,
0x93c9,
0x9ef1,
0xffff,
0xffff,
0xffff,
0x9ef3,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9eed,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9eef,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x8a80,
0x9268,
0xffff,
0xffff,
0xffff,
0x9efa,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9ef8,
0x8ce7,
0xffff,
0x9ef7,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9f40,
0xffff,
0xffff,
0xffff,
0xffff,
0x9e77,
0xffff,
0xffff,
0xffff,
0x9ef9,
0xffff,
0x9efb,
0x9efc,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9f4b,
0xffff,
0x9f47,
0xffff,
0x9e8d,
0xffff,
0xffff,
0xffff,
0xffff,
0x9f46,
0xffff,
0xffff,
0xffff,
0xffff,
0x9f45,
0xffff,
0xffff,
0x9f42,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9ee8,
0x9f44,
0x9f43,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9f49,
0xffff,
0x9845,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9f4c,
0x8bf9,
0xffff,
0xffff,
0x9f48,
0x9f4a,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x94a5,
0xffff,
0x9f4d,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9f51,
0x9f4e,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9793,
0x9f4f,
0xffff,
0xffff,
0xffff,
0xffff,
0x9edc,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9f52,
0xffff,
0xffff,
0xffff,
0x9f53,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x8954,
0xffff,
0x9f55,
0x8c87,
0x8e9f,
0xffff,
0x8bd3,
0xffff,
0xffff,
0xffff,
0x89a2,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x977e,
0xffff,
0xffff,
0xffff,
0xffff,
0x9f57,
0x9f56,
0x9f59,
0x8b5c,
0xffff,
0xffff,
0x8bd4,
0x8abc,
0xffff,
0xffff,
0xffff,
0xffff,
0x9f5c,
0xffff,
0xffff,
0xffff,
0x9f5b,
0xffff,
0x9f5d,
0xffff,
0xffff,
0x89cc,
0xffff,
0x9256,
0xffff,
0x9f5e,
0xffff,
0xffff,
0x8abd,
0x9f60,
0xffff,
0xffff,
0xffff,
0xffff,
0x9f5f,
0xffff,
0x9f61,
0xffff,
0xffff,
0xffff,
0x9f62,
0xffff,
0x9f63,
0x8e7e,
0x90b3,
0x8d9f,
0xffff,
0x9590,
0xffff,
0xffff,
0x95e0,
0x9863,
0xffff,
0xffff,
0xffff,
0xffff,
0x8e95,
0xffff,
0xffff,
0xffff,
0x8dce,
0x97f0,
0xffff,
0xffff,
0xffff,
0x9f64,
0x9f65,
0xffff,
0x8e80,
0xffff,
0xffff,
0xffff,
0x9f66,
0x9f67,
0xffff,
0xffff,
0x9f69,
0x9f68,
0xffff,
0x9677,
0xffff,
0xffff,
0x8f7d,
0x8eea,
0x8e63,
0xffff,
0x9f6a,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9f6c,
0x9042,
0xffff,
0x9f6b,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9f6d,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9f6e,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9f6f,
0x9f70,
0xffff,
0xffff,
0xffff,
0x9f71,
0xffff,
0x9f73,
0x9f72,
0x9f74,
0x89a3,
0x9269,
0xffff,
0x9f75,
0xffff,
0xffff,
0x8e45,
0x8a6b,
0x9f76,
0xffff,
0xffff,
0x9361,
0x9aca,
0xffff,
0xffff,
0xffff,
0xffff,
0x8b42,
0x9f77,
0xffff,
0xffff,
0xffff,
0xffff,
0x9f78,
0xffff,
0x95ea,
0x9688,
0xffff,
0xffff,
0xffff,
0x93c5,
0x9f79,
0x94e4,
0xffff,
0xffff,
0xffff,
0x94f9,
0xffff,
0xffff,
0x96d1,
0xffff,
0xffff,
0xffff,
0x9f7a,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9f7c,
0x9f7b,
0xffff,
0xffff,
0x9f7e,
0xffff,
0xffff,
0xffff,
0x9f7d,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9f81,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x8e81,
0xffff,
0x96af,
0xffff,
0x9f82,
0x9f83,
0xffff,
0xffff,
0x8b43,
0xffff,
0xffff,
0xffff,
0x9f84,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9f86,
0x9f85,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9085,
0xffff,
0xffff,
0x9558,
0x8969,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x94c3,
0xffff,
0x92f3,
0x8f60,
0x8b81,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x94c4,
0xffff,
0x8eac,
0xffff,
0xffff,
0xffff,
0xffff,
0x9f88,
0xffff,
0x8abe,
0xffff,
0xffff,
0x8998,
0xffff,
0xffff,
0x93f0,
0x9f87,
0x8d5d,
0x9272,
0xffff,
0x9f89,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9f91,
0xffff,
0x9f8a,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x91bf,
0xffff,
0x8b82,
0x9f92,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x8c88,
0xffff,
0xffff,
0x8b44,
0x9f90,
0xffff,
0xffff,
0x9f8e,
0x9f8b,
0x9780,
0xffff,
0xffff,
0xffff,
0xffff,
0x92be,
0xffff,
0xffff,
0xffff,
0x93d7,
0x9f8c,
0xffff,
0xffff,
0x9f94,
0xffff,
0x9f93,
0x8c42,
0xffff,
0xffff,
0x89ab,
0xffff,
0xffff,
0x8db9,
0x9f8d,
0x9f8f,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9676,
0x91f2,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9697,
0xffff,
0xffff,
0x9f9c,
0xffff,
0xffff,
0x9f9d,
0xffff,
0x89cd,
0xffff,
0xffff,
0xffff,
0xffff,
0x95a6,
0x96fb,
0x9f9f,
0x8ea1,
0x8fc0,
0x9f98,
0x9f9e,
0x8988,
0xffff,
0x8bb5,
0xffff,
0xffff,
0x9f95,
0x9f9a,
0xffff,
0xffff,
0xffff,
0x90f2,
0x9491,
0xffff,
0x94e5,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9f97,
0xffff,
0x9640,
0xffff,
0x9f99,
0xffff,
0x9fa2,
0xffff,
0x9fa0,
0xffff,
0x9f9b,
0xffff,
0xffff,
0xffff,
0x9641,
0x9467,
0x8b83,
0xffff,
0x9344,
0xffff,
0xffff,
0x928d,
0xffff,
0x9fa3,
0xffff,
0xffff,
0xffff,
0xffff,
0x9fa1,
0x91d7,
0x9f96,
0xffff,
0x896a,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x976d,
0x9fae,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9fad,
0xffff,
0xffff,
0xffff,
0xffff,
0x90f4,
0xffff,
0x9faa,
0xffff,
0x978c,
0xffff,
0xffff,
0x93b4,
0x9fa4,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x92c3,
0xffff,
0xffff,
0xffff,
0x896b,
0x8d5e,
0x9fa7,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x8f46,
0x9fac,
0xffff,
0x9fab,
0x9fa6,
0xffff,
0x9fa9,
0xffff,
0xffff,
0x8a88,
0xffff,
0x9fa8,
0x9468,
0xffff,
0xffff,
0x97ac,
0xffff,
0xffff,
0x8ff2,
0x90f3,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9fb4,
0x9fb2,
0xffff,
0x956c,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9faf,
0x9fb1,
0xffff,
0x8959,
0xffff,
0xffff,
0x8d5f,
0x9851,
0xffff,
0x8a5c,
0xffff,
0x9582,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9781,
0xffff,
0xffff,
0x8a43,
0x905a,
0x9fb3,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9fb8,
0xffff,
0xffff,
0x8fc1,
0xffff,
0xffff,
0xffff,
0x974f,
0xffff,
0x9fb5,
0xffff,
0xffff,
0xffff,
0xffff,
0x9fb0,
0xffff,
0x9fb6,
0xffff,
0xffff,
0xffff,
0x97dc,
0xffff,
0x9393,
0x93c0,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x8a55,
0xffff,
0xffff,
0x8974,
0xffff,
0xffff,
0x9fbc,
0xffff,
0xffff,
0x9fbf,
0xffff,
0xffff,
0xffff,
0x97c1,
0xffff,
0xffff,
0xffff,
0x9784,
0xffff,
0xffff,
0xffff,
0xffff,
0x9fc6,
0x9fc0,
0x9fbd,
0xffff,
0xffff,
0xffff,
0x97d2,
0x9fc3,
0xffff,
0xffff,
0xffff,
0xffff,
0x8f69,
0x9fc5,
0xffff,
0xffff,
0x9fca,
0xffff,
0xffff,
0x9391,
0x9fc8,
0xffff,
0xffff,
0xffff,
0xffff,
0x9fc2,
0xffff,
0xffff,
0x9257,
0xffff,
0xffff,
0x9fc9,
0xffff,
0x9fbe,
0xffff,
0x9fc4,
0xffff,
0x9fcb,
0x88fa,
0x9fc1,
0xffff,
0x9fcc,
0xffff,
0xffff,
0x905b,
0xffff,
0x8f7e,
0xffff,
0x95a3,
0xffff,
0x8dac,
0xffff,
0x9fb9,
0x9fc7,
0x9359,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x90b4,
0xffff,
0x8a89,
0x8dcf,
0x8fc2,
0x9fbb,
0x8f61,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x8c6b,
0xffff,
0x9fba,
0xffff,
0xffff,
0xffff,
0x9fd0,
0x8f8d,
0x8cb8,
0xffff,
0x9fdf,
0xffff,
0x9fd9,
0x8b94,
0x936e,
0xffff,
0x9fd4,
0x9fdd,
0x88ad,
0x8951,
0xffff,
0xffff,
0x89b7,
0xffff,
0x9fd6,
0x91aa,
0x9fcd,
0x9fcf,
0x8d60,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9fe0,
0xffff,
0x9fdb,
0xffff,
0xffff,
0xffff,
0x9fd3,
0xffff,
0xffff,
0xffff,
0xffff,
0x9fda,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x96a9,
0xffff,
0xffff,
0x9fd8,
0x9fdc,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x8cce,
0xffff,
0x8fc3,
0xffff,
0xffff,
0x9258,
0xffff,
0xffff,
0xffff,
0x9fd2,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x974e,
0xffff,
0xffff,
0xffff,
0x9fd5,
0xffff,
0xffff,
0x9fce,
0x9392,
0xffff,
0xffff,
0x9fd1,
0xffff,
0xffff,
0xffff,
0x9fd7,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9870,
0x8ebc,
0x969e,
0xffff,
0x9fe1,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x94ac,
0xffff,
0xffff,
0x9fed,
0x8cb9,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x8f80,
0xffff,
0x9fe3,
0xffff,
0xffff,
0xffff,
0x97ad,
0x8d61,
0xffff,
0x9ff0,
0xffff,
0xffff,
0x88ec,
0xffff,
0xffff,
0x9fee,
0xffff,
0xffff,
0xffff,
0xffff,
0x9fe2,
0xffff,
0xffff,
0xffff,
0xffff,
0x9fe8,
0xffff,
0xffff,
0x9fea,
0xffff,
0xffff,
0xffff,
0x976e,
0x9fe5,
0xffff,
0xffff,
0x934d,
0xffff,
0xffff,
0x9fe7,
0xffff,
0xffff,
0xffff,
0xffff,
0x9fef,
0xffff,
0x9fe9,
0x96c5,
0xffff,
0xffff,
0xffff,
0x9fe4,
0xffff,
0x8ea0,
0x9ffc,
0xffff,
0xffff,
0xffff,
0xffff,
0x8a8a,
0xffff,
0x9fe6,
0x9feb,
0x9fec,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x91ea,
0x91d8,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9ff4,
0xffff,
0xffff,
0x9ffa,
0xffff,
0xffff,
0x9ff8,
0xffff,
0x9348,
0xffff,
0xffff,
0xe042,
0x9ff5,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9ff6,
0x9fde,
0xffff,
0x8b99,
0x9559,
0xffff,
0xffff,
0xffff,
0x8ebd,
0xffff,
0xffff,
0x8d97,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9852,
0xffff,
0x9ff2,
0xffff,
0xe041,
0x8989,
0x9186,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9499,
0xffff,
0x8abf,
0x97f8,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x969f,
0x92d0,
0xffff,
0xffff,
0xffff,
0xffff,
0x9ff9,
0x9ffb,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9151,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe040,
0x9ff7,
0xffff,
0x9ff1,
0xffff,
0xffff,
0xffff,
0x8ac1,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x8c89,
0xffff,
0xffff,
0xffff,
0xe04e,
0xffff,
0xffff,
0xe049,
0x90f6,
0xffff,
0xffff,
0x8a83,
0xffff,
0xffff,
0xffff,
0xffff,
0x8f81,
0xffff,
0xe052,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe04b,
0x92aa,
0xe048,
0x92d7,
0xffff,
0xffff,
0xffff,
0xe06b,
0xffff,
0xffff,
0xffff,
0xe045,
0xffff,
0xe044,
0xffff,
0xe04d,
0xffff,
0xffff,
0xffff,
0xe047,
0xe046,
0xe04c,
0xffff,
0x909f,
0xffff,
0xe043,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe04f,
0xffff,
0xffff,
0xe050,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x8ac0,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe055,
0xffff,
0xe054,
0xe056,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe059,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9362,
0xffff,
0xe053,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe057,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x8c83,
0x91f7,
0xe051,
0x945a,
0xffff,
0xffff,
0xe058,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe05d,
0xe05b,
0xffff,
0xffff,
0xe05e,
0xffff,
0xffff,
0xe061,
0xffff,
0xffff,
0xffff,
0xe05a,
0x8d8a,
0x9447,
0xffff,
0xffff,
0x9fb7,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9794,
0xe05c,
0xffff,
0xe060,
0x91f3,
0xffff,
0xe05f,
0xffff,
0xe04a,
0xffff,
0xffff,
0xe889,
0xffff,
0xffff,
0xffff,
0xe064,
0xffff,
0xffff,
0xffff,
0xe068,
0xffff,
0xffff,
0xe066,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe062,
0xffff,
0xe063,
0xffff,
0xffff,
0xffff,
0xe067,
0xffff,
0xe065,
0xffff,
0xffff,
0xffff,
0x956d,
0xffff,
0xffff,
0xe06d,
0xffff,
0xe06a,
0xe069,
0xffff,
0xe06c,
0x93d2,
0xe06e,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9295,
0x91eb,
0xffff,
0xffff,
0xffff,
0xffff,
0x90a3,
0xffff,
0xffff,
0xffff,
0xe06f,
0xffff,
0xe071,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe070,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9ff3,
0xffff,
0xffff,
0xffff,
0xffff,
0xe072,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x93e5,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe073,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x89ce,
0xffff,
0xffff,
0xffff,
0x9394,
0x8a44,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x8b84,
0xffff,
0xffff,
0xffff,
0x8edc,
0x8dd0,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9846,
0x9086,
0xffff,
0xffff,
0xffff,
0x898a,
0xffff,
0xffff,
0xffff,
0xe075,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe074,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe078,
0x9259,
0xe07b,
0xe076,
0xffff,
0xffff,
0xffff,
0xe07a,
0xffff,
0xffff,
0xffff,
0xffff,
0xe079,
0x935f,
0x88d7,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x97f3,
0xffff,
0xffff,
0xe07d,
0xffff,
0xffff,
0xffff,
0x8947,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe080,
0xffff,
0xffff,
0xffff,
0xe07e,
0xffff,
0xe07c,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe077,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9642,
0xffff,
0xffff,
0xffff,
0xe082,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe081,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x898b,
0xffff,
0xffff,
0xffff,
0xffff,
0xe084,
0x95b0,
0xffff,
0xe083,
0xffff,
0xffff,
0xffff,
0xffff,
0x96b3,
0xffff,
0xffff,
0xffff,
0xffff,
0x8fc5,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9152,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x8fc4,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x97f9,
0xffff,
0xffff,
0xe08a,
0xffff,
0x90f7,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe086,
0xe08b,
0xffff,
0xffff,
0x898c,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe089,
0xffff,
0x9481,
0xe085,
0xe088,
0x8fc6,
0xffff,
0x94cf,
0xffff,
0xffff,
0xe08c,
0xffff,
0x8ecf,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x90f8,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe08f,
0xffff,
0xffff,
0xffff,
0xe087,
0xffff,
0x8c46,
0xffff,
0xffff,
0xffff,
0xffff,
0xe08d,
0xffff,
0xffff,
0xffff,
0xffff,
0x976f,
0xe090,
0xffff,
0xffff,
0xffff,
0xeaa4,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x8f6e,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe091,
0xffff,
0xffff,
0xffff,
0xe092,
0xffff,
0xffff,
0xffff,
0xffff,
0x944d,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe094,
0xffff,
0xffff,
0xffff,
0xffff,
0xe095,
0xffff,
0xffff,
0xffff,
0xffff,
0x9452,
0xffff,
0xffff,
0xffff,
0xffff,
0x9395,
0xe097,
0xffff,
0xffff,
0xffff,
0xffff,
0xe099,
0xffff,
0x97d3,
0xffff,
0xe096,
0xffff,
0xe098,
0x898d,
0xffff,
0xe093,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9a7a,
0xe09a,
0xffff,
0xffff,
0xffff,
0xffff,
0x9187,
0x8e57,
0xe09c,
0xffff,
0xffff,
0xffff,
0xffff,
0xe09b,
0x9043,
0x99d7,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe09d,
0xffff,
0xffff,
0xffff,
0xe09f,
0xffff,
0xe08e,
0xe09e,
0xffff,
0xffff,
0xe0a0,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x949a,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe0a1,
0xffff,
0xffff,
0xe0a2,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe0a3,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe0a4,
0xffff,
0x92dc,
0xffff,
0xe0a6,
0xe0a5,
0xffff,
0xffff,
0xe0a7,
0xffff,
0xe0a8,
0xffff,
0xffff,
0x8edd,
0x9583,
0xffff,
0xffff,
0xffff,
0x96ea,
0xe0a9,
0xe0aa,
0x9175,
0x8ea2,
0xe0ab,
0xe0ac,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe0ad,
0x95d0,
0x94c5,
0xffff,
0xffff,
0xe0ae,
0x9476,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x92ab,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe0af,
0x89e5,
0xffff,
0x8b8d,
0xffff,
0x96c4,
0xffff,
0x96b4,
0xffff,
0x89b2,
0x9853,
0xffff,
0xffff,
0xffff,
0xffff,
0x9671,
0xffff,
0x95a8,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x90b5,
0xffff,
0xe0b0,
0xffff,
0xffff,
0xffff,
0xffff,
0x93c1,
0xffff,
0xffff,
0xffff,
0x8ca1,
0xe0b1,
0xffff,
0x8dd2,
0xe0b3,
0xe0b2,
0xffff,
0xffff,
0xffff,
0xffff,
0xe0b4,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe0b5,
0xffff,
0xffff,
0xffff,
0xe0b6,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x8b5d,
0xffff,
0xe0b7,
0xffff,
0xffff,
0xffff,
0xffff,
0xe0b8,
0xffff,
0xffff,
0xffff,
0xffff,
0x8ca2,
0xffff,
0xffff,
0x94c6,
0xffff,
0xffff,
0xe0ba,
0xffff,
0xffff,
0xffff,
0x8ff3,
0xffff,
0xffff,
0xe0b9,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x8bb6,
0xe0bb,
0xe0bd,
0xffff,
0xe0bc,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe0be,
0xffff,
0x8ccf,
0xffff,
0xe0bf,
0xffff,
0xffff,
0xffff,
0xffff,
0x8be7,
0xffff,
0x915f,
0xffff,
0x8d9d,
0xffff,
0xffff,
0xffff,
0xffff,
0xe0c1,
0xe0c2,
0xe0c0,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x8eeb,
0xffff,
0xffff,
0x93c6,
0x8bb7,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe0c4,
0x924b,
0xe0c3,
0xffff,
0xffff,
0x9854,
0x9482,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe0c7,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe0c9,
0xe0c6,
0xffff,
0xffff,
0xffff,
0x96d2,
0xe0c8,
0xe0ca,
0xffff,
0x97c2,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe0ce,
0xffff,
0xffff,
0xffff,
0xe0cd,
0x9296,
0x944c,
0xffff,
0xffff,
0x8ca3,
0xe0cc,
0xffff,
0xffff,
0xffff,
0xffff,
0xe0cb,
0xffff,
0x9750,
0x9751,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe0cf,
0x898e,
0xffff,
0xffff,
0xffff,
0xffff,
0x8d96,
0x8e82,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe0d0,
0xe0d1,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe0d3,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x8f62,
0xffff,
0xffff,
0xffff,
0xffff,
0xe0d5,
0xffff,
0xe0d4,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe0d6,
0xffff,
0x8a6c,
0xffff,
0xffff,
0xe0d8,
0xffff,
0xffff,
0xe0d7,
0xffff,
0xe0da,
0xe0d9,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x8cba,
0xffff,
0xffff,
0x97a6,
0xffff,
0x8bca,
0xffff,
0x89a4,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x8be8,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x8adf,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x97e6,
0xe0dc,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe0de,
0xffff,
0xffff,
0xffff,
0xffff,
0xe0df,
0xffff,
0x89cf,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe0db,
0xffff,
0x8e58,
0xffff,
0xffff,
0x92bf,
0xe0dd,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe0e2,
0xffff,
0x8eec,
0xffff,
0xffff,
0xffff,
0xffff,
0xe0e0,
0xffff,
0xffff,
0xffff,
0xffff,
0x8c5d,
0xffff,
0xffff,
0x94c7,
0xe0e1,
0xffff,
0xffff,
0xe0fc,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe0e7,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x8cbb,
0xffff,
0xffff,
0xffff,
0xffff,
0x8b85,
0xffff,
0xe0e4,
0x979d,
0xffff,
0xffff,
0x97ae,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x91f4,
0xffff,
0xffff,
0xe0e6,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe0e8,
0x97d4,
0x8bd5,
0x94fa,
0x9469,
0xffff,
0xffff,
0xffff,
0xe0e9,
0xffff,
0xffff,
0xffff,
0xffff,
0xe0eb,
0xffff,
0xe0ee,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe0ea,
0xffff,
0xffff,
0xffff,
0xe0ed,
0x8ce8,
0x896c,
0xe0ef,
0xffff,
0x9090,
0xe0ec,
0x97da,
0xffff,
0xffff,
0xe0f2,
0xeaa2,
0xffff,
0xffff,
0xffff,
0xffff,
0xe0f0,
0xe0f3,
0xffff,
0xffff,
0xffff,
0xffff,
0xe0e5,
0xe0f1,
0xffff,
0xffff,
0x8dba,
0xffff,
0xffff,
0xe0f4,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe0f5,
0xffff,
0xffff,
0xffff,
0xffff,
0x979e,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe0f6,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe0f7,
0xffff,
0xffff,
0xffff,
0xe0e3,
0xffff,
0xffff,
0xffff,
0xffff,
0xe0f8,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x8ac2,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x8ea3,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe0f9,
0xffff,
0xffff,
0xffff,
0xffff,
0xe0fa,
0xffff,
0xffff,
0xffff,
0xffff,
0xe0fb,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x895a,
0xffff,
0xffff,
0xffff,
0xe140,
0xffff,
0x955a,
0xe141,
0xffff,
0xffff,
0x8aa2,
0xe142,
0xffff,
0xe143,
0xffff,
0xffff,
0xffff,
0xffff,
0xe144,
0xffff,
0xe146,
0xe147,
0xe145,
0xffff,
0xffff,
0xffff,
0x9572,
0xe149,
0xe148,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe14b,
0xe14a,
0xe14c,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe14d,
0xe14f,
0xe14e,
0xffff,
0xffff,
0x8d99,
0xffff,
0xe151,
0xffff,
0xe150,
0xffff,
0xffff,
0x8ac3,
0xffff,
0x9072,
0xffff,
0x935b,
0xffff,
0xe152,
0x90b6,
0xffff,
0xffff,
0xffff,
0x8e59,
0xffff,
0x8999,
0xe153,
0xffff,
0x9770,
0xffff,
0xffff,
0x95e1,
0xe154,
0xffff,
0xffff,
0xffff,
0x9363,
0x9752,
0x8d62,
0x905c,
0xffff,
0xffff,
0xffff,
0x926a,
0x99b2,
0xffff,
0x92ac,
0x89e6,
0xe155,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe156,
0xffff,
0xe15b,
0xffff,
0xffff,
0xe159,
0xe158,
0x9dc0,
0x8a45,
0xe157,
0xffff,
0x88d8,
0xffff,
0x94a8,
0xffff,
0xffff,
0x94c8,
0xffff,
0xffff,
0xffff,
0xffff,
0x97af,
0xe15c,
0xe15a,
0x927b,
0x90a4,
0xffff,
0xffff,
0x94a9,
0xffff,
0x954c,
0xffff,
0xe15e,
0x97aa,
0x8c6c,
0xe15f,
0xffff,
0xe15d,
0x94d4,
0xe160,
0xffff,
0xe161,
0xffff,
0xffff,
0x88d9,
0xffff,
0xffff,
0x8ff4,
0xe166,
0xffff,
0xe163,
0x93eb,
0xe162,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x8b45,
0xffff,
0xffff,
0xe169,
0xffff,
0xffff,
0xffff,
0xe164,
0xe165,
0xffff,
0xe168,
0xe167,
0x9544,
0xffff,
0xffff,
0x9161,
0x9160,
0xffff,
0x8b5e,
0xffff,
0xffff,
0xe16a,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe16b,
0xffff,
0xffff,
0xe16c,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe16e,
0xffff,
0xe16d,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x8975,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe176,
0x94e6,
0xe170,
0xffff,
0xe172,
0xffff,
0xffff,
0xe174,
0x905d,
0xffff,
0xffff,
0xe175,
0xe173,
0x8ebe,
0xffff,
0xffff,
0xffff,
0xe16f,
0xe171,
0xffff,
0x9561,
0xffff,
0x8fc7,
0xffff,
0xffff,
0xe178,
0xffff,
0xffff,
0xe177,
0xffff,
0xffff,
0xffff,
0xffff,
0xe179,
0xffff,
0x8ea4,
0x8dad,
0xffff,
0xffff,
0x9397,
0xe17a,
0xffff,
0x92c9,
0xffff,
0xffff,
0xe17c,
0xffff,
0xffff,
0xffff,
0x979f,
0xe17b,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9189,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe182,
0xffff,
0xe184,
0xe185,
0x9273,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe183,
0xffff,
0xe180,
0xffff,
0xe17d,
0xe17e,
0xffff,
0xe181,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe188,
0xffff,
0xe186,
0xffff,
0xe187,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe189,
0xe18b,
0xe18c,
0xe18d,
0xffff,
0xe18e,
0xffff,
0xffff,
0xe18a,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe190,
0xffff,
0xffff,
0xffff,
0xe18f,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe191,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x97c3,
0xffff,
0xffff,
0xffff,
0xe194,
0xe192,
0xe193,
0xffff,
0xffff,
0xffff,
0x8ae0,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x96fc,
0xffff,
0xffff,
0xffff,
0x95c8,
0xffff,
0xe196,
0xffff,
0xffff,
0xffff,
0xe195,
0xffff,
0xffff,
0xffff,
0xffff,
0xe197,
0xe198,
0xffff,
0xffff,
0xffff,
0xffff,
0xe19c,
0xe199,
0xe19a,
0xe19b,
0xffff,
0xe19d,
0xffff,
0xffff,
0xffff,
0xe19e,
0xffff,
0xe19f,
0xffff,
0xffff,
0xffff,
0xe1a0,
0xffff,
0xe1a1,
0xffff,
0x94ad,
0x936f,
0xe1a2,
0x9492,
0x9553,
0xffff,
0xe1a3,
0xffff,
0xffff,
0xe1a4,
0x9349,
0xffff,
0x8a46,
0x8d63,
0xe1a5,
0xffff,
0xffff,
0xe1a6,
0xffff,
0xffff,
0xe1a7,
0xffff,
0x8e48,
0xffff,
0xffff,
0xe1a9,
0xffff,
0xffff,
0xe1a8,
0xffff,
0xffff,
0xe1aa,
0xe1ab,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x94e7,
0xffff,
0xe1ac,
0xffff,
0xffff,
0xffff,
0xe1ad,
0xffff,
0xffff,
0xea89,
0xe1ae,
0xe1af,
0xe1b0,
0xffff,
0xffff,
0xffff,
0xffff,
0x8e4d,
0xffff,
0xffff,
0xe1b1,
0x9475,
0xffff,
0xffff,
0x967e,
0xffff,
0x896d,
0xffff,
0x8976,
0xffff,
0xffff,
0xe1b2,
0xffff,
0xffff,
0xffff,
0xffff,
0xe1b4,
0xffff,
0xffff,
0xffff,
0xe1b3,
0x9390,
0xffff,
0xffff,
0xffff,
0x90b7,
0x9f58,
0xffff,
0xe1b5,
0x96bf,
0xffff,
0xe1b6,
0xffff,
0x8ac4,
0x94d5,
0xe1b7,
0xffff,
0xe1b8,
0xffff,
0xffff,
0xe1b9,
0xffff,
0xffff,
0xffff,
0x96da,
0xffff,
0xffff,
0xffff,
0x96d3,
0xffff,
0x92bc,
0xffff,
0xffff,
0xffff,
0x918a,
0xffff,
0xffff,
0xe1bb,
0xffff,
0xffff,
0x8f82,
0xffff,
0xffff,
0x8fc8,
0xffff,
0xffff,
0xe1be,
0xffff,
0xffff,
0xe1bd,
0xe1bc,
0x94fb,
0xffff,
0x8ac5,
0x8ca7,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe1c4,
0xffff,
0xffff,
0xe1c1,
0x905e,
0x96b0,
0xffff,
0xffff,
0xffff,
0xe1c0,
0xe1c2,
0xe1c3,
0xffff,
0xffff,
0xe1bf,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe1c5,
0xe1c6,
0xffff,
0x92ad,
0xffff,
0x8ae1,
0xffff,
0xffff,
0xffff,
0x9285,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe1c7,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe1c8,
0xe1cb,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9087,
0xffff,
0x93c2,
0xffff,
0xe1cc,
0x9672,
0xffff,
0xe1c9,
0xffff,
0xffff,
0xe1ca,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe1cf,
0xffff,
0xffff,
0xffff,
0xffff,
0xe1ce,
0xe1cd,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe1d1,
0xffff,
0xffff,
0xe1d0,
0xffff,
0xffff,
0xe1d2,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe1d4,
0xffff,
0xe1d3,
0xffff,
0xffff,
0xffff,
0xffff,
0x95cb,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x8f75,
0x97c4,
0xffff,
0xffff,
0xe1d5,
0xffff,
0xffff,
0x93b5,
0xffff,
0xffff,
0xe1d6,
0xffff,
0xffff,
0xe1d7,
0xffff,
0xe1db,
0xe1d9,
0xe1da,
0xffff,
0xe1d8,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe1dc,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe1dd,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe1de,
0xffff,
0xffff,
0xe1df,
0x96b5,
0xe1e0,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x96ee,
0xe1e1,
0xffff,
0x926d,
0xffff,
0x948a,
0xffff,
0x8be9,
0xffff,
0xffff,
0xffff,
0x925a,
0xe1e2,
0x8bb8,
0xffff,
0xffff,
0xffff,
0x90ce,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe1e3,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x8dbb,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe1e4,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe1e5,
0xffff,
0x8ca4,
0x8dd3,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe1e7,
0xffff,
0xffff,
0xffff,
0xffff,
0x9375,
0x8dd4,
0x8b6d,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9643,
0xffff,
0x946a,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9376,
0xffff,
0xffff,
0xffff,
0xffff,
0x8d7b,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe1e9,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x8fc9,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x97b0,
0x8d64,
0xffff,
0xffff,
0x8ca5,
0xffff,
0xffff,
0x94a1,
0xffff,
0xe1eb,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe1ed,
0xffff,
0xffff,
0xffff,
0xffff,
0x8ce9,
0xffff,
0xffff,
0xffff,
0xffff,
0xe1ec,
0x92f4,
0xffff,
0xffff,
0xffff,
0xffff,
0xe1ef,
0x8a56,
0xe1ea,
0xffff,
0xffff,
0x94e8,
0xffff,
0x894f,
0xffff,
0x8dea,
0xffff,
0x9871,
0xffff,
0xffff,
0xe1ee,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe1f0,
0xffff,
0xffff,
0xffff,
0x95c9,
0xffff,
0x90d7,
0xe1f2,
0xffff,
0xffff,
0xffff,
0xffff,
0xe1f3,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe1f1,
0xffff,
0xffff,
0xffff,
0xffff,
0x8a6d,
0xffff,
0xe1f9,
0xffff,
0xe1f8,
0xffff,
0xffff,
0x8ea5,
0xffff,
0xffff,
0xffff,
0xe1fa,
0xe1f5,
0xffff,
0xffff,
0xffff,
0xe1fb,
0xe1f6,
0xffff,
0xffff,
0xffff,
0xffff,
0x94d6,
0xe1f4,
0xffff,
0xffff,
0xe1f7,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe241,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe240,
0x9681,
0xffff,
0xffff,
0xffff,
0xe1fc,
0xffff,
0xffff,
0x88e9,
0xffff,
0xffff,
0xffff,
0xffff,
0xe243,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe242,
0xffff,
0xffff,
0xffff,
0x8fca,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe244,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9162,
0xffff,
0xffff,
0xe246,
0xe245,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe247,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe1e6,
0xffff,
0xffff,
0xffff,
0xe1e8,
0xe249,
0xe248,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x8ea6,
0xffff,
0x97e7,
0xffff,
0x8ed0,
0xffff,
0xe24a,
0x8c56,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x8b5f,
0x8b46,
0x8e83,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9753,
0xffff,
0xffff,
0xe250,
0xffff,
0xe24f,
0x9163,
0xe24c,
0xffff,
0xffff,
0xe24e,
0xffff,
0xffff,
0x8f6a,
0x905f,
0xe24d,
0xe24b,
0xffff,
0x9449,
0xffff,
0xffff,
0x8fcb,
0xffff,
0xffff,
0x955b,
0xffff,
0xffff,
0xffff,
0xffff,
0x8dd5,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9398,
0xffff,
0xffff,
0xe251,
0xffff,
0xffff,
0xffff,
0xffff,
0xe252,
0xe268,
0x8bd6,
0xffff,
0xffff,
0x985c,
0x9154,
0xffff,
0xffff,
0xffff,
0xffff,
0xe253,
0xffff,
0xffff,
0x89d0,
0x92f5,
0x959f,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe254,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x8b9a,
0xe255,
0xffff,
0xffff,
0xe257,
0xffff,
0xffff,
0xffff,
0xe258,
0xffff,
0x9448,
0xffff,
0xffff,
0xe259,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe25a,
0xe25b,
0xffff,
0xffff,
0x8bd7,
0x89d1,
0x93c3,
0x8f47,
0x8e84,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe25c,
0xffff,
0x8f48,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x89c8,
0x9562,
0xffff,
0xffff,
0xe25d,
0xffff,
0xffff,
0x94e9,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9164,
0xffff,
0xe260,
0xffff,
0xe261,
0x9489,
0xffff,
0x9060,
0xe25e,
0xffff,
0x9281,
0xffff,
0xffff,
0xe25f,
0xffff,
0xffff,
0xffff,
0x8fcc,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x88da,
0xffff,
0xffff,
0xffff,
0xffff,
0x8b48,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe262,
0xffff,
0xffff,
0x92f6,
0xffff,
0xe263,
0x90c5,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x96ab,
0xffff,
0xffff,
0x9542,
0xe264,
0xe265,
0x9274,
0xffff,
0x97c5,
0xffff,
0xffff,
0xe267,
0xe266,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x8eed,
0xffff,
0xffff,
0xe269,
0x88ee,
0xffff,
0xffff,
0xffff,
0xffff,
0xe26c,
0xffff,
0xffff,
0xffff,
0xe26a,
0x89d2,
0x8c6d,
0xe26b,
0x8d65,
0x8d92,
0xffff,
0x95e4,
0xe26d,
0xffff,
0xffff,
0x9673,
0xffff,
0xffff,
0xe26f,
0xffff,
0xffff,
0xffff,
0x90cf,
0x896e,
0x89b8,
0x88aa,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe26e,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe270,
0xe271,
0x8ff5,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe272,
0xffff,
0x8a6e,
0xffff,
0xffff,
0xffff,
0xffff,
0xe274,
0xffff,
0xffff,
0xffff,
0x8c8a,
0xffff,
0x8b86,
0xffff,
0xffff,
0xe275,
0x8bf3,
0xffff,
0xffff,
0xe276,
0xffff,
0x90fa,
0xffff,
0x93cb,
0xffff,
0x90de,
0x8df3,
0xffff,
0xffff,
0xffff,
0xe277,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9282,
0x918b,
0xffff,
0xe279,
0xe27b,
0xe278,
0xe27a,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x8c41,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe27c,
0x8c45,
0xffff,
0xffff,
0xffff,
0x8b87,
0x9771,
0xe27e,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe280,
0xffff,
0xffff,
0xffff,
0x894d,
0xffff,
0xffff,
0xffff,
0xffff,
0xe283,
0xffff,
0xffff,
0xffff,
0x8a96,
0xe282,
0xe281,
0xffff,
0xe285,
0xe27d,
0xffff,
0xe286,
0x97a7,
0xffff,
0xe287,
0xffff,
0xe288,
0xffff,
0xffff,
0x9af2,
0xe28a,
0xffff,
0xe289,
0xffff,
0xffff,
0xffff,
0xe28b,
0xe28c,
0xffff,
0x97b3,
0xe28d,
0xffff,
0xe8ed,
0x8fcd,
0xe28e,
0xe28f,
0x8f76,
0xffff,
0x93b6,
0xe290,
0xffff,
0xffff,
0xffff,
0x9247,
0xffff,
0xffff,
0xe291,
0xffff,
0x925b,
0xe292,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x8ba3,
0xffff,
0x995e,
0x927c,
0x8eb1,
0xffff,
0xffff,
0xffff,
0xffff,
0x8ac6,
0xffff,
0xffff,
0xe293,
0xffff,
0xe2a0,
0xffff,
0xe296,
0xffff,
0x8b88,
0xffff,
0xe295,
0xe2a2,
0xffff,
0xffff,
0xffff,
0xe294,
0xffff,
0x8fce,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe298,
0xe299,
0xffff,
0x934a,
0xffff,
0xffff,
0xe29a,
0xffff,
0x8a7d,
0xffff,
0xffff,
0xffff,
0xffff,
0x9079,
0x9584,
0xffff,
0xe29c,
0xffff,
0xffff,
0xffff,
0x91e6,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe297,
0xffff,
0xe29b,
0xe29d,
0xffff,
0xffff,
0x8df9,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe2a4,
0x954d,
0xffff,
0x94a4,
0x9399,
0xffff,
0x8bd8,
0xe2a3,
0xe2a1,
0xffff,
0x94b3,
0xe29e,
0x927d,
0x939b,
0xffff,
0x939a,
0xffff,
0x8df4,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe2b6,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe2a6,
0xffff,
0xe2a8,
0xffff,
0xffff,
0xffff,
0xffff,
0xe2ab,
0xffff,
0xe2ac,
0xffff,
0xe2a9,
0xe2aa,
0xffff,
0xffff,
0xe2a7,
0xe2a5,
0xffff,
0xffff,
0xffff,
0xffff,
0xe29f,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x95cd,
0x89d3,
0xffff,
0xffff,
0xffff,
0xe2b3,
0xffff,
0xe2b0,
0xffff,
0xe2b5,
0xffff,
0xffff,
0xe2b4,
0xffff,
0x9493,
0x96a5,
0xffff,
0x8e5a,
0xe2ae,
0xe2b7,
0xe2b2,
0xffff,
0xe2b1,
0xe2ad,
0xffff,
0xe2af,
0xffff,
0x8ac7,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x925c,
0xffff,
0xffff,
0x90fb,
0xffff,
0xffff,
0xffff,
0x94a0,
0xffff,
0xffff,
0xe2bc,
0xffff,
0xffff,
0xffff,
0x94a2,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x90df,
0xe2b9,
0xffff,
0xffff,
0x94cd,
0xffff,
0xe2bd,
0x95d1,
0xffff,
0x927a,
0xffff,
0xe2b8,
0xe2ba,
0xffff,
0xffff,
0xe2bb,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe2be,
0xffff,
0xffff,
0x8ec2,
0xffff,
0xffff,
0xffff,
0x93c4,
0xe2c3,
0xe2c2,
0xffff,
0xffff,
0xe2bf,
0xffff,
0xffff,
0xffff,
0x9855,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe2c8,
0xffff,
0xffff,
0xe2cc,
0xe2c9,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe2c5,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe2c6,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe2cb,
0xffff,
0xffff,
0xffff,
0xe2c0,
0x99d3,
0xe2c7,
0xe2c1,
0xffff,
0xffff,
0xe2ca,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe2d0,
0xffff,
0x8ac8,
0xffff,
0xe2cd,
0xffff,
0xffff,
0xffff,
0xe2ce,
0xffff,
0xffff,
0xe2cf,
0xe2d2,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe2d1,
0x94f4,
0xffff,
0xffff,
0xffff,
0xffff,
0xe2d3,
0x97fa,
0x95eb,
0xe2d8,
0xffff,
0xffff,
0xe2d5,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe2d4,
0x90d0,
0xffff,
0xe2d7,
0xe2d9,
0xffff,
0xffff,
0xffff,
0xe2d6,
0xffff,
0xe2dd,
0xffff,
0xe2da,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe2db,
0xe2c4,
0xffff,
0xffff,
0xffff,
0xe2dc,
0xe2de,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe2df,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x95c4,
0xffff,
0xe2e0,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x96e0,
0xffff,
0xffff,
0x8bcc,
0x8c48,
0xe2e1,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x95b2,
0xffff,
0x9088,
0xffff,
0x96ae,
0xffff,
0xffff,
0xe2e2,
0xffff,
0x97b1,
0xffff,
0xffff,
0x9494,
0xffff,
0x9165,
0x9453,
0xffff,
0xffff,
0x8f6c,
0xffff,
0xffff,
0xffff,
0x88be,
0xffff,
0xe2e7,
0xe2e5,
0xffff,
0xe2e3,
0x8a9f,
0xffff,
0x8fcf,
0xe2e8,
0xffff,
0xffff,
0xe2e6,
0xffff,
0xe2e4,
0xe2ec,
0xffff,
0xffff,
0xe2eb,
0xe2ea,
0xe2e9,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe2ed,
0xffff,
0xffff,
0xffff,
0xe2ee,
0x90b8,
0xffff,
0xe2ef,
0xffff,
0xe2f1,
0xffff,
0xffff,
0xe2f0,
0xffff,
0xffff,
0xffff,
0xffff,
0x8cd0,
0xffff,
0xffff,
0xffff,
0x9157,
0xffff,
0xffff,
0xffff,
0xe2f3,
0xffff,
0xffff,
0xffff,
0x939c,
0xffff,
0xe2f2,
0xffff,
0xffff,
0xffff,
0xe2f4,
0xffff,
0x95b3,
0x918c,
0x8d66,
0xffff,
0xe2f5,
0xffff,
0xffff,
0xffff,
0xffff,
0x97c6,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe2f7,
0xffff,
0xffff,
0xe2f8,
0xffff,
0xe2f9,
0xffff,
0xe2fa,
0xffff,
0x8e85,
0xffff,
0xe2fb,
0x8c6e,
0xffff,
0xffff,
0x8b8a,
0xffff,
0x8b49,
0xffff,
0xe340,
0xffff,
0x96f1,
0x8d67,
0xe2fc,
0xffff,
0xffff,
0xffff,
0xe343,
0x96e4,
0xffff,
0x945b,
0xffff,
0xffff,
0x9552,
0xffff,
0xffff,
0xffff,
0x8f83,
0xe342,
0xffff,
0x8ed1,
0x8d68,
0x8e86,
0x8b89,
0x95b4,
0xe341,
0xffff,
0xffff,
0xffff,
0x9166,
0x9661,
0x8df5,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x8e87,
0x92db,
0xffff,
0xe346,
0x97dd,
0x8dd7,
0xffff,
0xe347,
0x9061,
0xffff,
0xe349,
0xffff,
0xffff,
0xffff,
0x8fd0,
0x8dae,
0xffff,
0xffff,
0xffff,
0xffff,
0xe348,
0xffff,
0xffff,
0x8f49,
0x8cbc,
0x9167,
0xe344,
0xe34a,
0xffff,
0xffff,
0xffff,
0xffff,
0xe345,
0x8c6f,
0xffff,
0xe34d,
0xe351,
0x8c8b,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe34c,
0xffff,
0xffff,
0xffff,
0xffff,
0xe355,
0xffff,
0xffff,
0x8d69,
0xffff,
0xffff,
0x978d,
0x88ba,
0xe352,
0xffff,
0xffff,
0x8b8b,
0xffff,
0xe34f,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe350,
0xffff,
0xffff,
0x939d,
0xe34e,
0xe34b,
0xffff,
0x8a47,
0x90e2,
0xffff,
0xffff,
0x8ca6,
0xffff,
0xffff,
0xffff,
0xe357,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe354,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe356,
0xffff,
0xffff,
0xffff,
0xe353,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x8c70,
0x91b1,
0xe358,
0x918e,
0xffff,
0xffff,
0xe365,
0xffff,
0xffff,
0xe361,
0xe35b,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe35f,
0x8ef8,
0x88db,
0xe35a,
0xe362,
0xe366,
0x8d6a,
0x96d4,
0xffff,
0x92d4,
0xe35c,
0xffff,
0xffff,
0xe364,
0xffff,
0xe359,
0x925d,
0xffff,
0xe35e,
0x88bb,
0x96c8,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe35d,
0xffff,
0xffff,
0x8bd9,
0x94ea,
0xffff,
0xffff,
0xffff,
0x918d,
0xffff,
0x97ce,
0x8f8f,
0xffff,
0xffff,
0xe38e,
0xffff,
0xffff,
0xe367,
0xffff,
0x90fc,
0xffff,
0xe363,
0xe368,
0xe36a,
0xffff,
0x92f7,
0xe36d,
0xffff,
0xffff,
0xe369,
0xffff,
0xffff,
0xffff,
0x95d2,
0x8ac9,
0xffff,
0xffff,
0x96c9,
0xffff,
0xffff,
0x88dc,
0xffff,
0xffff,
0xe36c,
0xffff,
0x97fb,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe36b,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x898f,
0xffff,
0xffff,
0x93ea,
0xe36e,
0xffff,
0xffff,
0xffff,
0xe375,
0xe36f,
0xe376,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe372,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x949b,
0xffff,
0xffff,
0x8ec8,
0xe374,
0xffff,
0xe371,
0xe377,
0xe370,
0xffff,
0xffff,
0x8f63,
0xffff,
0xffff,
0xffff,
0xffff,
0x9644,
0xffff,
0xffff,
0x8f6b,
0xffff,
0xffff,
0xe373,
0xe380,
0xffff,
0xffff,
0xe37b,
0xffff,
0xe37e,
0xffff,
0xe37c,
0xe381,
0xe37a,
0xffff,
0xe360,
0x90d1,
0xffff,
0xffff,
0x94c9,
0xffff,
0xe37d,
0xffff,
0xffff,
0xe378,
0xffff,
0xffff,
0xffff,
0x9140,
0x8c71,
0xffff,
0x8f4a,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9044,
0x9155,
0xe384,
0xffff,
0xffff,
0xe386,
0xe387,
0xffff,
0xffff,
0xe383,
0xe385,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe379,
0xe382,
0xffff,
0xe38a,
0xe389,
0xffff,
0xffff,
0x969a,
0xffff,
0xffff,
0x8c4a,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe388,
0xffff,
0xe38c,
0xe38b,
0xe38f,
0xffff,
0xe391,
0xffff,
0xffff,
0x8e5b,
0xe38d,
0xffff,
0xffff,
0xffff,
0xffff,
0xe392,
0xe393,
0xffff,
0xffff,
0xe394,
0xffff,
0xe39a,
0x935a,
0xe396,
0xffff,
0xe395,
0xe397,
0xe398,
0xffff,
0xe399,
0xffff,
0xffff,
0xffff,
0xffff,
0xe39b,
0xe39c,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x8aca,
0xffff,
0xe39d,
0xffff,
0xe39e,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe39f,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe3a0,
0xe3a1,
0xe3a2,
0xffff,
0xe3a3,
0xe3a4,
0xffff,
0xffff,
0xe3a6,
0xe3a5,
0xffff,
0xffff,
0xe3a7,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe3a8,
0xe3a9,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe3ac,
0xe3aa,
0xe3ab,
0x8ddf,
0x8c72,
0xffff,
0xffff,
0x9275,
0xffff,
0x94b1,
0xffff,
0x8f90,
0xffff,
0xffff,
0x946c,
0xffff,
0x94eb,
0xe3ad,
0x9ceb,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe3ae,
0xe3b0,
0xffff,
0x9785,
0xe3af,
0xe3b2,
0xe3b1,
0xffff,
0x9772,
0xffff,
0xe3b3,
0xffff,
0x94fc,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe3b4,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe3b7,
0xffff,
0xffff,
0xe3b6,
0xe3b5,
0xffff,
0xffff,
0xffff,
0xffff,
0xe3b8,
0x8c51,
0xffff,
0xffff,
0xffff,
0x9141,
0x8b60,
0xffff,
0xffff,
0xffff,
0xffff,
0xe3bc,
0xe3b9,
0xffff,
0xffff,
0xe3ba,
0xffff,
0xffff,
0xffff,
0xe3bd,
0xffff,
0xe3be,
0xe3bb,
0xffff,
0xffff,
0xffff,
0x8948,
0xffff,
0xffff,
0xffff,
0x89a5,
0xffff,
0xffff,
0xffff,
0xe3c0,
0xe3c1,
0xffff,
0xffff,
0xffff,
0xe3c2,
0xffff,
0x9782,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x8f4b,
0xffff,
0xe3c4,
0xe3c3,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9089,
0xe3c5,
0xffff,
0xffff,
0xffff,
0xffff,
0xe3c6,
0xffff,
0xffff,
0xe3c7,
0xffff,
0x8ae3,
0xffff,
0xffff,
0xffff,
0xffff,
0x8acb,
0xffff,
0xffff,
0xe3c8,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe3c9,
0xffff,
0x967c,
0x9783,
0xffff,
0xffff,
0xffff,
0x9773,
0x9856,
0xffff,
0x8d6c,
0xe3cc,
0x8ed2,
0xe3cb,
0xffff,
0xffff,
0xffff,
0xffff,
0xe3cd,
0x8ea7,
0xffff,
0xffff,
0xffff,
0x91cf,
0xffff,
0xe3ce,
0xffff,
0xffff,
0x8d6b,
0xffff,
0x96d5,
0xe3cf,
0xe3d0,
0xffff,
0xffff,
0xe3d1,
0xffff,
0xffff,
0xffff,
0xffff,
0xe3d2,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe3d3,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x8ea8,
0xffff,
0xffff,
0x96eb,
0xffff,
0xffff,
0xffff,
0xffff,
0xe3d5,
0xffff,
0x925e,
0xffff,
0xe3d4,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe3d7,
0xffff,
0xffff,
0xffff,
0xe3d6,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe3d8,
0xffff,
0xffff,
0xffff,
0x90b9,
0xffff,
0xe3d9,
0xffff,
0xe3da,
0xffff,
0xffff,
0xffff,
0x95b7,
0xe3db,
0xffff,
0x918f,
0xe3dc,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe3dd,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x97fc,
0xe3e0,
0xffff,
0xe3df,
0xe3de,
0x92ae,
0xffff,
0xe3e1,
0x9045,
0xffff,
0xe3e2,
0xffff,
0xffff,
0xffff,
0xe3e3,
0x9857,
0xe3e4,
0xffff,
0xffff,
0xffff,
0xffff,
0xe3e5,
0xe3e7,
0xe3e6,
0x94a3,
0xffff,
0x93f7,
0xffff,
0x985d,
0x94a7,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe3e9,
0xffff,
0xffff,
0x8fd1,
0xffff,
0x9549,
0xffff,
0xe3ea,
0xe3e8,
0xffff,
0x8acc,
0xffff,
0xffff,
0xffff,
0x8cd2,
0x8e88,
0xffff,
0xffff,
0x94ec,
0xffff,
0xffff,
0xffff,
0x8ca8,
0x9662,
0xffff,
0xe3ed,
0xe3eb,
0xffff,
0x8d6d,
0xffff,
0x8d6e,
0x88e7,
0xffff,
0x8de6,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9478,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x88dd,
0xe3f2,
0xffff,
0x925f,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9477,
0xffff,
0x91d9,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe3f4,
0xffff,
0xffff,
0xe3f0,
0xe3f3,
0xe3ee,
0xffff,
0xe3f1,
0x9645,
0xffff,
0xffff,
0x8cd3,
0xffff,
0xffff,
0x88fb,
0xe3ef,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe3f6,
0xffff,
0xe3f7,
0xffff,
0xffff,
0x93b7,
0xffff,
0xffff,
0xffff,
0x8bb9,
0xffff,
0xffff,
0xffff,
0xe445,
0x945c,
0xffff,
0xffff,
0xffff,
0xffff,
0x8e89,
0xffff,
0xffff,
0x8bba,
0x90c6,
0x9865,
0x96ac,
0xe3f5,
0x90d2,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x8b72,
0xe3f8,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe3fa,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe3f9,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe3fb,
0xffff,
0x9245,
0xffff,
0x945d,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x92af,
0xffff,
0xffff,
0xffff,
0xffff,
0xe442,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe441,
0xffff,
0xffff,
0xffff,
0xffff,
0xe3fc,
0xffff,
0xffff,
0x9074,
0xffff,
0x9585,
0xe444,
0xffff,
0xe443,
0x8d6f,
0x9872,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe454,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe448,
0xe449,
0xffff,
0xffff,
0xffff,
0xffff,
0x8eee,
0xffff,
0xffff,
0xe447,
0xffff,
0x8d98,
0xe446,
0xffff,
0xffff,
0xe44a,
0xffff,
0xffff,
0xffff,
0x92b0,
0x95a0,
0x9142,
0xffff,
0xffff,
0xffff,
0xffff,
0x91da,
0xe44e,
0xffff,
0xe44f,
0xe44b,
0xffff,
0xffff,
0xffff,
0xffff,
0xe44c,
0xffff,
0xe44d,
0xffff,
0xffff,
0xffff,
0xffff,
0x8d70,
0xffff,
0xffff,
0xffff,
0xe455,
0xffff,
0xe451,
0xffff,
0xffff,
0xffff,
0xffff,
0x9586,
0xffff,
0x968c,
0x9547,
0xffff,
0xffff,
0xe450,
0xffff,
0xffff,
0xe453,
0xe452,
0xffff,
0xffff,
0xffff,
0x9663,
0xe456,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe457,
0xffff,
0xffff,
0x9156,
0xffff,
0xe458,
0xffff,
0xffff,
0xe45a,
0xffff,
0xe45e,
0xffff,
0xffff,
0xe45b,
0xe459,
0x945e,
0xe45c,
0xffff,
0xe45d,
0xffff,
0xffff,
0xffff,
0x89b0,
0xffff,
0xe464,
0xe45f,
0xffff,
0xffff,
0xffff,
0xe460,
0xffff,
0xffff,
0xffff,
0xe461,
0xffff,
0x919f,
0xffff,
0xffff,
0xffff,
0xffff,
0xe463,
0xe462,
0xe465,
0xffff,
0xffff,
0xffff,
0xffff,
0xe466,
0xe467,
0xffff,
0xffff,
0x9062,
0xffff,
0x89e7,
0xffff,
0xe468,
0x97d5,
0xffff,
0x8ea9,
0xffff,
0xffff,
0x8f4c,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x8e8a,
0x9276,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe469,
0xe46a,
0x8950,
0xffff,
0xe46b,
0xffff,
0xffff,
0xe46c,
0xe46d,
0xffff,
0xffff,
0xe46e,
0xffff,
0xe46f,
0x8bbb,
0x9da8,
0xe470,
0xffff,
0x90e3,
0xe471,
0x8ec9,
0xffff,
0xe472,
0xffff,
0x98ae,
0xffff,
0xffff,
0xffff,
0xe473,
0x95dc,
0x8ada,
0xffff,
0xffff,
0x9143,
0x8f77,
0xffff,
0x9591,
0x8f4d,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe474,
0x8d71,
0xe475,
0x94ca,
0xffff,
0xe484,
0xffff,
0xffff,
0xffff,
0xffff,
0xe477,
0xffff,
0x91c7,
0x9495,
0x8cbd,
0xe476,
0x9144,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe478,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x92f8,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe47a,
0xe479,
0xe47c,
0xffff,
0xffff,
0xe47b,
0xffff,
0xe47d,
0xffff,
0xffff,
0xe480,
0xffff,
0xe47e,
0xffff,
0x8acd,
0xffff,
0xe481,
0xffff,
0xe482,
0xe483,
0xffff,
0xffff,
0x8daf,
0x97c7,
0xffff,
0xe485,
0x9046,
0xffff,
0xffff,
0xffff,
0x8990,
0xe486,
0xe487,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe488,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x88f0,
0xffff,
0xe489,
0xffff,
0xffff,
0xffff,
0xffff,
0xe48a,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9587,
0xffff,
0xffff,
0xffff,
0x8ec5,
0xffff,
0xe48c,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x8a48,
0x88b0,
0xffff,
0xffff,
0xffff,
0xffff,
0xe48b,
0xe48e,
0x946d,
0xffff,
0x9063,
0xffff,
0x89d4,
0xffff,
0x9646,
0xffff,
0xffff,
0xffff,
0xffff,
0x8c7c,
0x8bda,
0xffff,
0xe48d,
0xffff,
0x89e8,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x8aa1,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x8991,
0xe492,
0x97e8,
0x91db,
0xffff,
0xffff,
0x9563,
0xffff,
0xe49e,
0xffff,
0x89d5,
0xe49c,
0xffff,
0xe49a,
0xe491,
0xffff,
0xe48f,
0xffff,
0xe490,
0xffff,
0x8ee1,
0x8bea,
0x9297,
0xffff,
0xffff,
0xffff,
0x93cf,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x8970,
0xffff,
0xe494,
0xe493,
0xffff,
0xffff,
0xffff,
0xffff,
0xe499,
0xe495,
0xe498,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x96ce,
0xe497,
0x89d6,
0x8a9d,
0xe49b,
0xffff,
0xffff,
0xe49d,
0xffff,
0xffff,
0xffff,
0xffff,
0x8c73,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe4a1,
0xe4aa,
0xe4ab,
0xffff,
0xffff,
0xffff,
0x88a9,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe4b2,
0xffff,
0xffff,
0xffff,
0xffff,
0x88ef,
0xffff,
0xffff,
0xe4a9,
0xffff,
0xffff,
0xffff,
0xe4a8,
0xffff,
0xe4a3,
0xe4a2,
0xffff,
0xe4a0,
0xe49f,
0x9283,
0xffff,
0x91f9,
0xe4a5,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe4a4,
0xffff,
0xffff,
0xffff,
0xffff,
0xe4a7,
0xffff,
0xffff,
0xffff,
0x9190,
0x8c74,
0xffff,
0xffff,
0xffff,
0xffff,
0x8960,
0xe4a6,
0xffff,
0x8d72,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9191,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe4b8,
0xffff,
0xe4b9,
0xffff,
0x89d7,
0xffff,
0xffff,
0xffff,
0x89ac,
0xe4b6,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe4ac,
0xffff,
0xe4b4,
0xffff,
0xe4bb,
0xe4b5,
0xffff,
0xffff,
0xffff,
0xe4b3,
0xffff,
0xffff,
0xffff,
0xffff,
0xe496,
0xffff,
0xffff,
0xe4b1,
0xffff,
0xffff,
0xffff,
0xe4ad,
0xffff,
0xffff,
0xffff,
0x8ace,
0xe4af,
0xe4ba,
0xffff,
0xe4b0,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe4bc,
0xffff,
0xe4ae,
0x949c,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9789,
0xffff,
0xffff,
0xffff,
0xe4b7,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe4cd,
0xffff,
0xffff,
0xffff,
0xe4c5,
0xffff,
0xffff,
0xffff,
0x909b,
0xffff,
0xffff,
0xffff,
0xffff,
0x8b65,
0xffff,
0x8bdb,
0xffff,
0xe4c0,
0xffff,
0xffff,
0xffff,
0xffff,
0x89d9,
0xffff,
0xffff,
0x8fd2,
0xffff,
0xe4c3,
0xffff,
0xffff,
0xffff,
0x8dd8,
0xffff,
0xffff,
0x9370,
0xe4c8,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x95ec,
0xffff,
0xe4bf,
0xffff,
0xffff,
0xffff,
0x89d8,
0x8cd4,
0x9548,
0xe4c9,
0xffff,
0xe4bd,
0xffff,
0xffff,
0xe4c6,
0xffff,
0xffff,
0xffff,
0xe4d0,
0xffff,
0xe4c1,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe4c2,
0x93b8,
0xffff,
0xffff,
0xe4c7,
0xffff,
0xffff,
0xffff,
0xe4c4,
0x9647,
0xe4ca,
0x88de,
0xffff,
0xffff,
0xffff,
0xffff,
0xe4be,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe4cc,
0xffff,
0xe4cb,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x948b,
0xe4d2,
0xffff,
0xe4dd,
0xffff,
0xffff,
0xffff,
0xffff,
0x8a9e,
0xffff,
0xffff,
0xffff,
0xe4e0,
0xffff,
0xffff,
0xe4ce,
0xffff,
0xffff,
0xffff,
0xe4d3,
0x978e,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe4dc,
0xffff,
0xffff,
0x9774,
0xffff,
0xffff,
0xffff,
0xffff,
0x97a8,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9298,
0xffff,
0xffff,
0xffff,
0x8a8b,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9592,
0xe4e2,
0x939f,
0xffff,
0xffff,
0x88af,
0xffff,
0xffff,
0xe4db,
0xffff,
0xe4d7,
0x9192,
0xe4d1,
0xe4d9,
0xe4de,
0xffff,
0x944b,
0xffff,
0xffff,
0xffff,
0x88a8,
0xffff,
0xe4d6,
0xffff,
0xe4df,
0x9598,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe4da,
0xffff,
0xe4d5,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x8fd3,
0xffff,
0xffff,
0xffff,
0xffff,
0x8f4e,
0xffff,
0xffff,
0xffff,
0x8eaa,
0xffff,
0xffff,
0xffff,
0xffff,
0x96d6,
0xffff,
0xffff,
0x9566,
0xffff,
0xffff,
0xe4e5,
0xffff,
0xe4ee,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe4d8,
0xffff,
0xffff,
0xffff,
0xffff,
0x8a97,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x8ff6,
0xe4e3,
0xffff,
0xe4e8,
0x9193,
0xffff,
0xffff,
0xe4e4,
0xffff,
0xe4eb,
0xffff,
0xffff,
0x927e,
0xffff,
0xe4ec,
0xffff,
0xffff,
0x9775,
0xe4e1,
0x8a57,
0xffff,
0xe4e7,
0xffff,
0xffff,
0xe4ea,
0x96aa,
0xffff,
0xffff,
0xffff,
0xffff,
0xe4ed,
0xffff,
0xffff,
0xe4e6,
0xe4e9,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9648,
0xffff,
0x9840,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe4f1,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe4f8,
0xffff,
0xffff,
0xe4f0,
0x8ec1,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe4cf,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x95cc,
0xffff,
0x96a0,
0xe4f7,
0xe4f6,
0xffff,
0xe4f2,
0xe4f3,
0xffff,
0x8955,
0xffff,
0xffff,
0xffff,
0xffff,
0xe4f5,
0xffff,
0xe4ef,
0xffff,
0xffff,
0xffff,
0xffff,
0x92d3,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe4f4,
0x88fc,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x91a0,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x95c1,
0xffff,
0xffff,
0xe4f9,
0xe540,
0xffff,
0x94d7,
0xffff,
0xffff,
0xffff,
0xffff,
0xe4fc,
0x8fd4,
0x8ec7,
0xe542,
0xffff,
0xffff,
0x8bbc,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe543,
0xffff,
0x9599,
0xe4fb,
0xffff,
0xe4d4,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe4fa,
0xffff,
0xffff,
0xffff,
0xffff,
0x986e,
0x93a0,
0x9593,
0xffff,
0xffff,
0xe54a,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe550,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe551,
0xffff,
0xe544,
0xffff,
0xffff,
0xffff,
0x9496,
0xffff,
0xffff,
0xe54e,
0xe546,
0xffff,
0xe548,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe552,
0xe547,
0xffff,
0xffff,
0xe54b,
0xffff,
0xffff,
0x8992,
0xffff,
0x93e3,
0xffff,
0xe54c,
0xe54f,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe545,
0xffff,
0x9145,
0xffff,
0xe549,
0x8e46,
0x9064,
0x8c4f,
0x96f2,
0xffff,
0x96f7,
0x8f92,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe556,
0xe554,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x986d,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe553,
0xffff,
0xffff,
0xffff,
0x9795,
0xffff,
0xe555,
0xe557,
0xffff,
0xffff,
0xffff,
0xffff,
0xe558,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe55b,
0xe559,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x93a1,
0xe55a,
0xffff,
0xffff,
0xffff,
0x94cb,
0xe54d,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x8f93,
0xffff,
0xe55c,
0xe561,
0x9194,
0xffff,
0xffff,
0xe560,
0xffff,
0xffff,
0xffff,
0xe541,
0xffff,
0xffff,
0xffff,
0xe562,
0x9168,
0xffff,
0xffff,
0xe55d,
0xe55f,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe55e,
0xffff,
0xffff,
0x9f50,
0x9f41,
0xffff,
0xffff,
0xe564,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe563,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9796,
0xffff,
0xe1ba,
0xe565,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe566,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe567,
0x8cd5,
0xffff,
0x8b73,
0xffff,
0xffff,
0xffff,
0xe569,
0x997c,
0xffff,
0xffff,
0xffff,
0xffff,
0x8b95,
0xffff,
0x97b8,
0xffff,
0x8bf1,
0xe56a,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe56b,
0xffff,
0xffff,
0xffff,
0x928e,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe56c,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x93f8,
0xffff,
0x88b8,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x89e1,
0xe571,
0xe572,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe56d,
0xffff,
0x8e5c,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe56e,
0x9461,
0xffff,
0xffff,
0xffff,
0xffff,
0xe56f,
0xe570,
0xe57a,
0xffff,
0xffff,
0xffff,
0xe574,
0xe577,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe573,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe575,
0xffff,
0xe576,
0x8ed6,
0xffff,
0xe578,
0xffff,
0x9260,
0xffff,
0x8c75,
0x8a61,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe57b,
0xffff,
0xffff,
0xffff,
0xffff,
0x8a5e,
0xffff,
0xe581,
0xffff,
0xffff,
0xe57c,
0xe580,
0xffff,
0xffff,
0xffff,
0xffff,
0x94b8,
0xffff,
0xffff,
0xffff,
0xffff,
0xe57d,
0xffff,
0xffff,
0xe57e,
0x9567,
0x94d8,
0xe582,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x91fb,
0xe58c,
0xffff,
0xe588,
0xffff,
0xffff,
0x89e9,
0xffff,
0xe586,
0xffff,
0x9649,
0xe587,
0xffff,
0xffff,
0xe584,
0xffff,
0xe585,
0xe58a,
0xe58d,
0xffff,
0xffff,
0xe58b,
0xffff,
0xffff,
0xffff,
0xe589,
0xe583,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9277,
0xffff,
0xe594,
0xffff,
0x96a8,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe592,
0xffff,
0xffff,
0xffff,
0xe593,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe58e,
0xffff,
0xffff,
0xe590,
0xffff,
0xffff,
0xffff,
0xe591,
0xffff,
0xffff,
0xffff,
0xe58f,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x90e4,
0xffff,
0x9858,
0xe598,
0xffff,
0xe599,
0xffff,
0xffff,
0xffff,
0xffff,
0xe59f,
0xffff,
0x9049,
0xffff,
0xe59b,
0xffff,
0xe59e,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe596,
0xe595,
0xffff,
0xffff,
0xe5a0,
0xffff,
0xffff,
0x89da,
0xffff,
0xe59c,
0xffff,
0xe5a1,
0xffff,
0xffff,
0xffff,
0xe59d,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe59a,
0xffff,
0x92b1,
0xffff,
0xe597,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9488,
0xffff,
0xffff,
0xe5a5,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x975a,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe5a4,
0xffff,
0xffff,
0xe5a3,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe5ac,
0xffff,
0xffff,
0xffff,
0xe5a6,
0xffff,
0xffff,
0xffff,
0xe5ae,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9786,
0xe5b1,
0xffff,
0xe5a8,
0xffff,
0xffff,
0xe5a9,
0xffff,
0xffff,
0xffff,
0xe5ad,
0xffff,
0xe5b0,
0xe5af,
0xffff,
0xffff,
0xffff,
0xe5a7,
0xffff,
0xffff,
0xffff,
0xffff,
0xe5aa,
0xffff,
0xe5bb,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe5b4,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe5b2,
0xffff,
0xffff,
0xe5b3,
0xffff,
0xffff,
0xffff,
0xe5b8,
0xe5b9,
0xffff,
0x8a49,
0xffff,
0x8b61,
0xffff,
0xffff,
0xe5b7,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe5a2,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe5b6,
0xe5ba,
0xe5b5,
0xffff,
0xe5bc,
0xffff,
0xffff,
0xffff,
0xe5be,
0xe5bd,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe5c0,
0xe5bf,
0xe579,
0xffff,
0xffff,
0xffff,
0xe5c4,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe5c1,
0xffff,
0xffff,
0xffff,
0xffff,
0xe5c2,
0xffff,
0xffff,
0xe5c3,
0xffff,
0xe5c5,
0xffff,
0xffff,
0xffff,
0xffff,
0x8c8c,
0xffff,
0xe5c7,
0xffff,
0xe5c6,
0xffff,
0x8f4f,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x8d73,
0x9fa5,
0xffff,
0xffff,
0xffff,
0xffff,
0xe5c8,
0x8f70,
0xffff,
0xffff,
0xffff,
0x8a58,
0xffff,
0xe5c9,
0xffff,
0x8971,
0xffff,
0x8fd5,
0xe5ca,
0xffff,
0xffff,
0x8d74,
0xe5cb,
0x88df,
0xffff,
0xffff,
0xffff,
0xffff,
0x955c,
0xffff,
0xffff,
0xe5cc,
0xffff,
0xffff,
0xffff,
0xffff,
0x908a,
0xffff,
0xe5d3,
0xffff,
0xffff,
0xe5d0,
0xffff,
0x928f,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe5d1,
0xe5ce,
0x8bdc,
0xffff,
0xe5cd,
0xe5d4,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x8c55,
0xffff,
0xffff,
0x91dc,
0xffff,
0xe5da,
0xffff,
0xffff,
0xffff,
0xffff,
0xe5d6,
0xffff,
0xffff,
0xffff,
0x91b3,
0xe5d5,
0xffff,
0xe5d8,
0xffff,
0xffff,
0xffff,
0xffff,
0xe5cf,
0xffff,
0xffff,
0xffff,
0xe5d9,
0xffff,
0xe5db,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x94ed,
0xffff,
0xffff,
0xe5d7,
0xffff,
0xe5dc,
0xe5de,
0xffff,
0xffff,
0x8cd1,
0xe5d2,
0xffff,
0x88bf,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe5dd,
0xffff,
0x8dd9,
0x97f4,
0xe5df,
0xe5e0,
0x9195,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x97a0,
0xffff,
0xffff,
0xffff,
0xffff,
0xe5e1,
0x9754,
0xffff,
0xffff,
0xe5e2,
0xe5e3,
0xffff,
0xffff,
0x95e2,
0xe5e4,
0xffff,
0x8dbe,
0xffff,
0x97a1,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe5e9,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe5ea,
0x8fd6,
0xe5e8,
0xffff,
0xffff,
0xffff,
0x9787,
0xe5e5,
0xffff,
0xffff,
0xe5e7,
0x90bb,
0x909e,
0xffff,
0xffff,
0xffff,
0xe5e6,
0xffff,
0xe5eb,
0xffff,
0xffff,
0x95a1,
0xffff,
0xffff,
0xe5ed,
0xffff,
0xe5ec,
0xffff,
0xffff,
0xffff,
0x8a8c,
0xffff,
0x964a,
0xe5ee,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe5fa,
0xe5f0,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe5f1,
0xffff,
0xffff,
0xffff,
0xffff,
0xe5f2,
0xe5f3,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe5f7,
0xffff,
0xe5f8,
0xffff,
0xffff,
0xe5f6,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe5f4,
0xffff,
0xe5ef,
0xe5f5,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe5f9,
0xe8b5,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x89a6,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe5fc,
0x8bdd,
0xe5fb,
0xffff,
0xffff,
0xffff,
0xe641,
0xffff,
0xe640,
0xffff,
0xffff,
0xffff,
0xe643,
0xffff,
0xffff,
0xe642,
0xffff,
0xe644,
0xffff,
0xffff,
0x8f50,
0xffff,
0xe645,
0xffff,
0xffff,
0xe646,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe647,
0x90bc,
0xffff,
0x9776,
0xffff,
0xe648,
0xffff,
0xffff,
0x95a2,
0x9465,
0xe649,
0xffff,
0xe64a,
0x8ca9,
0xffff,
0xffff,
0xffff,
0x8b4b,
0xffff,
0xffff,
0xffff,
0xe64b,
0xffff,
0xffff,
0x8e8b,
0x9460,
0xe64c,
0xffff,
0x8a6f,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe64d,
0xffff,
0xffff,
0xffff,
0xffff,
0xe64f,
0x9797,
0xffff,
0xe64e,
0x9065,
0xffff,
0xe650,
0xffff,
0xffff,
0xe651,
0xffff,
0xffff,
0xe652,
0x8acf,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe653,
0xffff,
0xffff,
0xe654,
0xffff,
0xe655,
0xe656,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x8a70,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe657,
0xffff,
0xe658,
0xe659,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x89f0,
0xffff,
0xffff,
0x9047,
0xe65a,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe65b,
0xffff,
0xffff,
0xffff,
0xe65c,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x8cbe,
0xffff,
0x92f9,
0xe65d,
0xffff,
0xffff,
0xffff,
0xffff,
0x8c76,
0xffff,
0x9075,
0xffff,
0xe660,
0xffff,
0x93a2,
0xffff,
0xe65f,
0xffff,
0xffff,
0x8c50,
0xffff,
0xffff,
0xe65e,
0x91f5,
0x8b4c,
0xffff,
0xffff,
0xe661,
0xffff,
0xe662,
0xffff,
0x8fd7,
0xffff,
0xffff,
0xffff,
0x8c8d,
0xffff,
0xe663,
0xffff,
0xffff,
0xffff,
0xffff,
0x964b,
0xffff,
0xffff,
0x90dd,
0xffff,
0xffff,
0xffff,
0x8b96,
0xffff,
0x96f3,
0x9169,
0xffff,
0xe664,
0xffff,
0xffff,
0xffff,
0x9066,
0x9290,
0x8fd8,
0xffff,
0xffff,
0xffff,
0xffff,
0xe665,
0xffff,
0xffff,
0xffff,
0xffff,
0xe668,
0xffff,
0xe669,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x8dbc,
0x91c0,
0xe667,
0xffff,
0x8fd9,
0x955d,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe666,
0xffff,
0xffff,
0x8e8c,
0xffff,
0x8972,
0xffff,
0xe66d,
0x8c77,
0xffff,
0xffff,
0x8e8e,
0xffff,
0xffff,
0x8e8d,
0xffff,
0x986c,
0xe66c,
0xe66b,
0x9146,
0xffff,
0x8b6c,
0x9862,
0x8a59,
0x8fda,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe66a,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe66f,
0xffff,
0xe670,
0xe66e,
0xffff,
0x8cd6,
0xffff,
0x975f,
0xffff,
0xffff,
0x8e8f,
0x9446,
0xffff,
0xffff,
0xffff,
0xe673,
0xffff,
0x90be,
0xffff,
0x9261,
0xffff,
0xffff,
0x9755,
0xffff,
0xe676,
0xffff,
0xffff,
0xffff,
0x8cea,
0xffff,
0x90bd,
0xe672,
0xffff,
0xe677,
0x8ceb,
0xe674,
0xe675,
0xffff,
0xe671,
0xffff,
0xffff,
0xffff,
0x90e0,
0x93c7,
0xffff,
0xffff,
0x924e,
0xffff,
0x89db,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x94ee,
0xffff,
0xffff,
0x8b62,
0xffff,
0xffff,
0x92b2,
0xffff,
0xffff,
0xe67a,
0xffff,
0xe678,
0xffff,
0xffff,
0x926b,
0xffff,
0xffff,
0xffff,
0x90bf,
0x8ad0,
0xe679,
0xffff,
0x907a,
0xffff,
0xffff,
0x97c8,
0xffff,
0xffff,
0xffff,
0x985f,
0xffff,
0xffff,
0xffff,
0xe67b,
0xe687,
0x92b3,
0xffff,
0xe686,
0xffff,
0xe683,
0xe68b,
0xe684,
0xffff,
0xe680,
0xffff,
0x92fa,
0xe67e,
0xffff,
0xffff,
0xffff,
0xe67c,
0xffff,
0x9740,
0x8e90,
0xffff,
0xffff,
0xe681,
0xffff,
0xe67d,
0xffff,
0xffff,
0xffff,
0xe685,
0x8f94,
0xffff,
0x8cbf,
0xffff,
0xffff,
0xffff,
0x91f8,
0xffff,
0x9664,
0x8979,
0x88e0,
0xffff,
0x93a3,
0xffff,
0xffff,
0xe689,
0xffff,
0xffff,
0xffff,
0xffff,
0xe688,
0xffff,
0x93e4,
0xffff,
0xe68d,
0xffff,
0xffff,
0xffff,
0xe682,
0xffff,
0xe68c,
0xe68e,
0xffff,
0x8caa,
0xe68a,
0x8d75,
0xffff,
0x8ed3,
0xffff,
0xffff,
0xe68f,
0x9777,
0xffff,
0xffff,
0xffff,
0xffff,
0xe692,
0xffff,
0xe695,
0xffff,
0xffff,
0xe693,
0x9554,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe690,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x8bde,
0xffff,
0xffff,
0xffff,
0xffff,
0xe694,
0xffff,
0xffff,
0xe696,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe69a,
0xffff,
0xffff,
0xe697,
0xffff,
0xe699,
0xe698,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe69b,
0xffff,
0x8eaf,
0xffff,
0xe69d,
0xe69c,
0x9588,
0xffff,
0xffff,
0xe69f,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x8c78,
0xffff,
0xffff,
0xffff,
0xffff,
0xe69e,
0xe6a0,
0xffff,
0xffff,
0xe6a1,
0x8b63,
0xe3bf,
0x8ff7,
0xffff,
0xe6a2,
0xffff,
0xffff,
0x8cec,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe6a3,
0xffff,
0xffff,
0xe6a4,
0xffff,
0xffff,
0x8e5d,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9dcc,
0xffff,
0xe6a5,
0xffff,
0xe6a6,
0xffff,
0x8f51,
0xffff,
0xe6a7,
0xe6a8,
0xffff,
0xffff,
0xe6a9,
0xffff,
0xffff,
0xe6aa,
0xe6ab,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x924a,
0xffff,
0xffff,
0xe6ac,
0xffff,
0xffff,
0xffff,
0xffff,
0xe6ae,
0xffff,
0xe6ad,
0xffff,
0xffff,
0xffff,
0xffff,
0x93a4,
0xffff,
0xe6af,
0xffff,
0x964c,
0xffff,
0xe6b0,
0xffff,
0xe6b1,
0xffff,
0xe6b2,
0xffff,
0xffff,
0xffff,
0xffff,
0xe6b3,
0xffff,
0xffff,
0xffff,
0xffff,
0x93d8,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x8fdb,
0xe6b4,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x8d8b,
0x98ac,
0xe6b5,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe6b6,
0x955e,
0xe6b7,
0xffff,
0xe6bf,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe6b8,
0xffff,
0xffff,
0xe6ba,
0xffff,
0xffff,
0xffff,
0xe6b9,
0xe6bb,
0xffff,
0x9665,
0xe6bc,
0xe6bd,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe6be,
0xffff,
0xffff,
0xffff,
0xe6c0,
0xffff,
0xffff,
0xffff,
0xffff,
0x8a4c,
0x92e5,
0xffff,
0x9589,
0x8de0,
0x8d76,
0xffff,
0xffff,
0xffff,
0xffff,
0x956e,
0x89dd,
0x94cc,
0xe6c3,
0x8ad1,
0x90d3,
0xe6c2,
0xe6c7,
0x9299,
0x96e1,
0xffff,
0xe6c5,
0xe6c6,
0x8b4d,
0xffff,
0xe6c8,
0x9483,
0x91dd,
0xffff,
0xffff,
0x94ef,
0x935c,
0xe6c4,
0xffff,
0x9666,
0x89ea,
0xe6ca,
0x9847,
0x92c0,
0x9864,
0xffff,
0xffff,
0x8e91,
0xe6c9,
0xffff,
0x91af,
0xffff,
0xffff,
0xe6da,
0x9147,
0xffff,
0xffff,
0x93f6,
0xffff,
0x956f,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe6cd,
0x8e5e,
0x8e92,
0xffff,
0x8fdc,
0xffff,
0x9485,
0xffff,
0x8cab,
0xe6cc,
0xe6cb,
0xffff,
0x958a,
0xffff,
0xffff,
0xffff,
0x8ebf,
0xffff,
0xffff,
0x9371,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe6cf,
0xe6d0,
0x8d77,
0xe6ce,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe6d1,
0xe6d2,
0xffff,
0xe6d4,
0x91a1,
0xffff,
0xe6d3,
0x8ae4,
0xffff,
0xe6d6,
0xffff,
0xe6d5,
0xe6d7,
0xffff,
0xffff,
0xe6d9,
0xe6db,
0xffff,
0xe6dc,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x90d4,
0xffff,
0x8ecd,
0xe6dd,
0xffff,
0xffff,
0xffff,
0x8a71,
0xffff,
0xe6de,
0xffff,
0xffff,
0x9196,
0xe6df,
0xffff,
0xe6e0,
0x958b,
0xffff,
0xffff,
0x8b4e,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe6e1,
0xffff,
0xffff,
0xffff,
0x92b4,
0xffff,
0xffff,
0xffff,
0xffff,
0x897a,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe6e2,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x8eef,
0xffff,
0xffff,
0xffff,
0xffff,
0x9096,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x91ab,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe6e5,
0xffff,
0xffff,
0xffff,
0xe6e4,
0xffff,
0xffff,
0xffff,
0xe6e3,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe6eb,
0xe6e9,
0xffff,
0xffff,
0xe6e6,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe6e8,
0xffff,
0xffff,
0xffff,
0xe6e7,
0xe6ea,
0xffff,
0x8b97,
0xffff,
0xe6ee,
0xffff,
0x90d5,
0xffff,
0xe6ef,
0xffff,
0xffff,
0xffff,
0xffff,
0x8cd7,
0xffff,
0xe6ec,
0xe6ed,
0xffff,
0xffff,
0xffff,
0x9848,
0xffff,
0xffff,
0xffff,
0x92b5,
0xffff,
0x9148,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe6f0,
0xffff,
0xffff,
0xe6f3,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe6f1,
0xe6f2,
0x9778,
0xffff,
0xffff,
0xffff,
0xffff,
0x93a5,
0xe6f6,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe6f4,
0xe6f5,
0xe6f7,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe748,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe6fa,
0xffff,
0xffff,
0xffff,
0xe6fb,
0xe6f9,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe6f8,
0xffff,
0x92fb,
0xffff,
0xffff,
0xe740,
0xe744,
0xe741,
0xe6fc,
0xffff,
0xe742,
0xffff,
0xffff,
0xffff,
0xe743,
0xffff,
0xffff,
0xffff,
0xffff,
0xe74a,
0xffff,
0xffff,
0xffff,
0xe745,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x90d6,
0xe747,
0xffff,
0xffff,
0xe749,
0xe746,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe74c,
0xffff,
0x8f52,
0xffff,
0xe74b,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe74d,
0xffff,
0xffff,
0xffff,
0xffff,
0xe74e,
0xffff,
0xffff,
0xe751,
0xe750,
0xffff,
0xe74f,
0xffff,
0xffff,
0xe753,
0xe752,
0xffff,
0x96f4,
0xffff,
0xffff,
0xffff,
0xe755,
0xffff,
0xe754,
0xe756,
0xffff,
0xffff,
0xffff,
0xffff,
0xe757,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe759,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe758,
0x9067,
0xe75a,
0xffff,
0xffff,
0x8beb,
0xe75b,
0xe75d,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe75e,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe75f,
0xe75c,
0xffff,
0xe760,
0xffff,
0x8ed4,
0xe761,
0x8b4f,
0x8c52,
0xffff,
0xffff,
0xffff,
0xffff,
0x8cac,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe762,
0xffff,
0xffff,
0xffff,
0x93ee,
0xffff,
0xffff,
0x935d,
0xe763,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe766,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x8eb2,
0xffff,
0xffff,
0xe765,
0xe764,
0x8c79,
0xe767,
0xffff,
0xffff,
0xffff,
0xffff,
0x8a72,
0xffff,
0xe769,
0xffff,
0xffff,
0xffff,
0x8dda,
0xe768,
0xffff,
0xe771,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe76b,
0xe76d,
0x95e3,
0xe76a,
0xffff,
0xffff,
0xffff,
0xe76c,
0xffff,
0xe770,
0xe76e,
0x8b50,
0xffff,
0xe76f,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe772,
0xffff,
0xffff,
0x9479,
0x97d6,
0xffff,
0xffff,
0xffff,
0xffff,
0x8f53,
0xffff,
0xffff,
0xffff,
0xe773,
0xffff,
0xffff,
0xffff,
0xffff,
0x9741,
0xe775,
0xffff,
0xe774,
0xffff,
0xffff,
0xe778,
0x9760,
0xffff,
0xffff,
0xe777,
0xffff,
0x8a8d,
0xe776,
0xe77b,
0xffff,
0xffff,
0xe77a,
0xffff,
0xffff,
0xe779,
0x9351,
0xe77c,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe77d,
0xffff,
0xffff,
0xffff,
0xffff,
0xe77e,
0xffff,
0xffff,
0x8d8c,
0xffff,
0x8c44,
0xe780,
0xe781,
0xe782,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9068,
0xe783,
0xffff,
0x8eab,
0xe784,
0xffff,
0xffff,
0xffff,
0xe785,
0xffff,
0xffff,
0xffff,
0x999f,
0x999e,
0xffff,
0xffff,
0xffff,
0xffff,
0xe786,
0xe390,
0xe787,
0x9243,
0x904a,
0x945f,
0xffff,
0xffff,
0xffff,
0xffff,
0xe788,
0xffff,
0xffff,
0x95d3,
0x92d2,
0x8d9e,
0xffff,
0xffff,
0x9248,
0xffff,
0xffff,
0x8949,
0xffff,
0x9698,
0x9076,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x8c7d,
0xffff,
0xffff,
0x8bdf,
0xffff,
0xffff,
0x95d4,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe789,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe78b,
0xffff,
0xffff,
0xe78a,
0x89de,
0xffff,
0xffff,
0x93f4,
0xe78c,
0x9497,
0xffff,
0x9352,
0xffff,
0xe78d,
0x8f71,
0xffff,
0xffff,
0xffff,
0xe78f,
0xffff,
0xffff,
0x96c0,
0xe79e,
0xe791,
0xe792,
0xffff,
0xffff,
0x92c7,
0xffff,
0xffff,
0x91de,
0x9197,
0xffff,
0x93a6,
0xffff,
0xe790,
0x8b74,
0xffff,
0xffff,
0xffff,
0xffff,
0xe799,
0xffff,
0xe796,
0xe7a3,
0x93a7,
0x9280,
0xe793,
0xffff,
0x92fc,
0x9372,
0xe794,
0xe798,
0x9080,
0xffff,
0x9487,
0x92ca,
0xffff,
0xffff,
0x90c0,
0xe797,
0x91ac,
0x91a2,
0xe795,
0x88a7,
0x9841,
0xffff,
0xffff,
0xffff,
0xe79a,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x91df,
0xffff,
0xffff,
0x8f54,
0x9069,
0xffff,
0xffff,
0xe79c,
0xe79b,
0xffff,
0x88ed,
0xe79d,
0xffff,
0xffff,
0x954e,
0xffff,
0xe7a5,
0xffff,
0xffff,
0x93d9,
0x908b,
0xffff,
0xffff,
0x9278,
0xffff,
0x8bf6,
0xffff,
0xe7a4,
0x9756,
0x895e,
0xffff,
0x95d5,
0x89df,
0xe79f,
0xe7a0,
0xe7a1,
0xe7a2,
0x93b9,
0x9242,
0x88e1,
0xe7a6,
0xffff,
0xe7a7,
0xeaa1,
0xffff,
0xffff,
0x91bb,
0xffff,
0xe7a8,
0xffff,
0x8993,
0x916b,
0xffff,
0x8cad,
0xffff,
0x9779,
0xffff,
0xffff,
0xe7a9,
0x934b,
0xffff,
0xffff,
0xffff,
0x9198,
0x8ed5,
0xe7aa,
0xffff,
0xffff,
0xe7ad,
0xffff,
0xffff,
0x8f85,
0xe7ab,
0x914a,
0x9149,
0xffff,
0x88e2,
0xffff,
0x97c9,
0xe7af,
0xffff,
0x94f0,
0xe7b1,
0xe7b0,
0xe7ae,
0xe284,
0x8ad2,
0xffff,
0xffff,
0xe78e,
0xffff,
0xe7b3,
0xe7b2,
0xffff,
0xffff,
0xffff,
0xffff,
0xe7b4,
0xffff,
0x9757,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x93df,
0xffff,
0xffff,
0x964d,
0xffff,
0xe7b5,
0xffff,
0x8ed7,
0xffff,
0xffff,
0xffff,
0xffff,
0xe7b6,
0xffff,
0xe7b7,
0xffff,
0xffff,
0xffff,
0xe7b8,
0xffff,
0xffff,
0x9340,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x88e8,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x8d78,
0xffff,
0xffff,
0xffff,
0x9859,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe7bc,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x8c53,
0xe7b9,
0xffff,
0xe7ba,
0xffff,
0xffff,
0xffff,
0x9594,
0xffff,
0xffff,
0xffff,
0xffff,
0x8a73,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9758,
0xffff,
0x8bbd,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9373,
0xffff,
0xffff,
0xffff,
0xffff,
0xe7bd,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe7be,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe7bf,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9341,
0xffff,
0xffff,
0xe7c1,
0xffff,
0xe7c0,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x93d1,
0xe7c2,
0x8f55,
0x8ede,
0x947a,
0x9291,
0xffff,
0xffff,
0xffff,
0x8ef0,
0xffff,
0x908c,
0xffff,
0xe7c3,
0xffff,
0xe7c4,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x907c,
0xe7c5,
0xffff,
0xe7c6,
0xffff,
0xffff,
0xffff,
0xe7c7,
0x978f,
0xffff,
0x8f56,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe7c9,
0xe7c8,
0xffff,
0x8d79,
0xffff,
0x8d93,
0x8e5f,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe7cc,
0xffff,
0xffff,
0xffff,
0xffff,
0x8f86,
0xffff,
0xe7cb,
0xffff,
0xe7ca,
0xffff,
0x91e7,
0xffff,
0xffff,
0x8ced,
0xffff,
0x90c1,
0xffff,
0xffff,
0xffff,
0xffff,
0x94ae,
0xffff,
0xffff,
0xffff,
0xffff,
0x8f58,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe7cd,
0xffff,
0x8fdd,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe7d0,
0xe7ce,
0xffff,
0xffff,
0xffff,
0xe7cf,
0xffff,
0xffff,
0xffff,
0xffff,
0xe7d2,
0xe7d1,
0xffff,
0xffff,
0x8ff8,
0xffff,
0xe7d3,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe7d4,
0xe7d5,
0xffff,
0xffff,
0xffff,
0xffff,
0x94ce,
0x8dd1,
0x8edf,
0xe7d6,
0xffff,
0xe7d7,
0x97a2,
0x8f64,
0x96ec,
0x97ca,
0xe7d8,
0x8be0,
0xffff,
0xffff,
0xffff,
0xffff,
0xe7d9,
0xffff,
0x9342,
0xffff,
0xffff,
0xe7dc,
0x8a98,
0x906a,
0xffff,
0xe7da,
0xffff,
0xe7db,
0xffff,
0x92de,
0xffff,
0xffff,
0x9674,
0x8bfa,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe7de,
0xe7df,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe7dd,
0xffff,
0xffff,
0xe7e1,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x93dd,
0x8a62,
0xffff,
0xffff,
0xe7e5,
0xffff,
0xffff,
0xe7e2,
0xe7e4,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe7e0,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe86e,
0xffff,
0xffff,
0xe7e3,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x97e9,
0xffff,
0xffff,
0x8cd8,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe7ed,
0xffff,
0xffff,
0xffff,
0xffff,
0x9353,
0xe7e8,
0xffff,
0xffff,
0xe7eb,
0xe7e9,
0xffff,
0xe7ee,
0xffff,
0xffff,
0xffff,
0xffff,
0xe7ef,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe7e7,
0xffff,
0xffff,
0xe7f4,
0x8994,
0xffff,
0xffff,
0xe7e6,
0xffff,
0xffff,
0xffff,
0x94ab,
0xffff,
0xe7ea,
0xffff,
0x8fde,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x8d7a,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9667,
0xffff,
0x8be2,
0xffff,
0xffff,
0x8f65,
0xffff,
0x93ba,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x914c,
0xffff,
0xe7f2,
0xffff,
0xe7ec,
0xe7f1,
0xffff,
0x96c1,
0xffff,
0x92b6,
0xe7f3,
0xe7f0,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x914b,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe7f7,
0xffff,
0xe7f6,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe7f5,
0xffff,
0xffff,
0x964e,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x8f9b,
0xffff,
0xffff,
0xffff,
0xffff,
0xe7f8,
0x95dd,
0xffff,
0xffff,
0x8973,
0xffff,
0xffff,
0xffff,
0xffff,
0x9565,
0x9292,
0xffff,
0xffff,
0xffff,
0xffff,
0x8b98,
0xffff,
0xe7fa,
0xffff,
0x8d7c,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x8e4b,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe7f9,
0x908d,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x908e,
0xe840,
0xe842,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x8ff9,
0xffff,
0xe841,
0xe843,
0xffff,
0xffff,
0x8bd1,
0xffff,
0x9564,
0xffff,
0xffff,
0x8ee0,
0x9842,
0xffff,
0xe7fc,
0x8df6,
0xffff,
0xffff,
0x985e,
0xffff,
0xffff,
0xe845,
0xffff,
0xffff,
0xffff,
0xffff,
0xe844,
0xe846,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe7fb,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x93e7,
0xffff,
0x9374,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x92d5,
0xffff,
0xe84b,
0xffff,
0xffff,
0xffff,
0xffff,
0x9262,
0xe847,
0xffff,
0xffff,
0xffff,
0xe848,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x8c4c,
0xffff,
0xe84a,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x8cae,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe849,
0xffff,
0x8fdf,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x8a99,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe84f,
0xffff,
0x8dbd,
0x9199,
0xffff,
0xffff,
0x92c8,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x8a5a,
0xffff,
0xffff,
0xffff,
0xffff,
0xe84d,
0xe84e,
0x92c1,
0xffff,
0xe84c,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe850,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe856,
0xffff,
0xffff,
0xffff,
0xffff,
0xe859,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe858,
0x934c,
0xffff,
0xffff,
0xffff,
0xffff,
0xe851,
0xe852,
0xe855,
0xffff,
0xffff,
0xffff,
0xffff,
0xe857,
0xffff,
0xffff,
0xffff,
0x8bbe,
0xffff,
0xffff,
0xe85a,
0xe854,
0xffff,
0xffff,
0xe853,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe85e,
0xffff,
0xffff,
0xffff,
0xe85f,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe860,
0xffff,
0xffff,
0xe85d,
0xe85c,
0xffff,
0xffff,
0xffff,
0x8fe0,
0x93a8,
0xe85b,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe864,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe862,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe863,
0xe861,
0xffff,
0x91f6,
0xffff,
0xe865,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe866,
0xffff,
0xffff,
0xe868,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x8ad3,
0xe867,
0x96f8,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe873,
0xe869,
0xffff,
0xffff,
0xe86c,
0xffff,
0xe86a,
0xffff,
0xe86b,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe86d,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe86f,
0xffff,
0xffff,
0xffff,
0xffff,
0xe870,
0xffff,
0xe871,
0xffff,
0xffff,
0xffff,
0xffff,
0xe874,
0xe872,
0xe875,
0xe877,
0xffff,
0xe876,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x92b7,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x96e5,
0xffff,
0xe878,
0x914d,
0xffff,
0xffff,
0xffff,
0xe879,
0xffff,
0x95c2,
0xe87a,
0x8a4a,
0xffff,
0xffff,
0xffff,
0x895b,
0xffff,
0x8ad5,
0xffff,
0x8ad4,
0xe87b,
0xffff,
0xe87c,
0xffff,
0xe87d,
0xe87e,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe880,
0xffff,
0x8ad6,
0x8a74,
0x8d7d,
0x94b4,
0xffff,
0xe882,
0xe881,
0xffff,
0xffff,
0xffff,
0xffff,
0xe883,
0xffff,
0xffff,
0xffff,
0xffff,
0x897b,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe886,
0xffff,
0xe885,
0xe884,
0xffff,
0xe887,
0xffff,
0xffff,
0xffff,
0xffff,
0xe88a,
0xffff,
0xffff,
0xffff,
0x88c5,
0xffff,
0xffff,
0xe888,
0xffff,
0xe88c,
0xe88b,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe88e,
0xe88d,
0xe88f,
0xffff,
0x93ac,
0xffff,
0xffff,
0xffff,
0xe890,
0xffff,
0xffff,
0xffff,
0xffff,
0xe891,
0xe893,
0xffff,
0xffff,
0xe892,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x958c,
0xffff,
0xffff,
0xffff,
0xffff,
0xe894,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe895,
0xffff,
0x8de3,
0xffff,
0xffff,
0xffff,
0xe896,
0xe897,
0xffff,
0xffff,
0x9668,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x916a,
0xffff,
0xffff,
0xffff,
0x88a2,
0x91c9,
0xffff,
0xe898,
0xffff,
0x958d,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe89b,
0xe899,
0x8d7e,
0xffff,
0xe89a,
0x8cc0,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x95c3,
0xe89d,
0xe89f,
0xe89e,
0xe8a0,
0xffff,
0xffff,
0x8940,
0x9077,
0x8f9c,
0x8ad7,
0xe8a1,
0xffff,
0xffff,
0xffff,
0x9486,
0xffff,
0xe8a3,
0xffff,
0xffff,
0xffff,
0x8941,
0xffff,
0xe8a2,
0x92c2,
0xffff,
0x97cb,
0x93a9,
0xe89c,
0x97a4,
0xffff,
0x8caf,
0xffff,
0xffff,
0x977a,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x8bf7,
0x97b2,
0xffff,
0x8c47,
0xffff,
0x91e0,
0xe440,
0xffff,
0xe8a4,
0x8a4b,
0x908f,
0xffff,
0xffff,
0xffff,
0xffff,
0x8a75,
0xe8a6,
0xffff,
0xe8a7,
0xe8a5,
0x8c84,
0xffff,
0x8ddb,
0x8fe1,
0xffff,
0xffff,
0xffff,
0x8942,
0xffff,
0xffff,
0x97d7,
0xffff,
0xffff,
0xffff,
0xe8a9,
0xe7ac,
0xffff,
0xe8a8,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe8ac,
0xe8aa,
0xe8ab,
0xffff,
0xe8ad,
0xffff,
0xe8ae,
0x97ea,
0xe8af,
0xe8b0,
0xffff,
0x90c7,
0x94b9,
0xffff,
0xffff,
0xffff,
0x909d,
0x8ae5,
0xffff,
0xffff,
0x9759,
0x89eb,
0x8f57,
0x8cd9,
0xffff,
0xe8b3,
0xffff,
0xe8b2,
0x8e93,
0xe8b4,
0xe8b1,
0xffff,
0xffff,
0x8e47,
0xffff,
0xffff,
0xffff,
0xe8b8,
0xe5ab,
0xffff,
0xffff,
0x99d4,
0xffff,
0x9097,
0xe8b6,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x97a3,
0x93ef,
0xffff,
0xffff,
0xffff,
0xffff,
0x894a,
0xffff,
0x90e1,
0x8eb4,
0xffff,
0xffff,
0xffff,
0xffff,
0x95b5,
0xffff,
0x895f,
0xffff,
0xffff,
0xffff,
0x97eb,
0x978b,
0xffff,
0xe8b9,
0xffff,
0x9364,
0xffff,
0xffff,
0xffff,
0xffff,
0x8ef9,
0xffff,
0xffff,
0xffff,
0xe8ba,
0xffff,
0xe8bb,
0x906b,
0xe8bc,
0xffff,
0x97ec,
0xffff,
0xffff,
0xe8b7,
0xe8be,
0xe8c0,
0xffff,
0xe8bf,
0xffff,
0xe8bd,
0xffff,
0xffff,
0xe8c1,
0xffff,
0xffff,
0xe8c2,
0xffff,
0xffff,
0x919a,
0xffff,
0x89e0,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe8c3,
0xffff,
0xffff,
0x96b6,
0xffff,
0xffff,
0xe8c4,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe8c5,
0xffff,
0x9849,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9e50,
0xe8c6,
0xffff,
0xffff,
0xffff,
0xe8c7,
0xe8c8,
0xffff,
0xffff,
0xffff,
0xe8cc,
0xffff,
0xe8c9,
0xffff,
0xe8ca,
0xffff,
0xe8cb,
0xe8cd,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x90c2,
0xffff,
0xffff,
0xffff,
0x96f5,
0xffff,
0xffff,
0x90c3,
0xffff,
0xffff,
0xe8ce,
0xffff,
0x94f1,
0xffff,
0xe8cf,
0xea72,
0x96ca,
0xffff,
0xe8d0,
0xffff,
0xe8d1,
0xffff,
0xe8d2,
0x8a76,
0xffff,
0xe8d4,
0xffff,
0x9078,
0xffff,
0xffff,
0xffff,
0xe8d5,
0xffff,
0xffff,
0x8c43,
0xffff,
0xffff,
0xffff,
0xffff,
0xe8d6,
0xe8da,
0xffff,
0xe8d8,
0xffff,
0xffff,
0xffff,
0xffff,
0xe8d9,
0xffff,
0xffff,
0x8a93,
0xe8d7,
0xe8db,
0xffff,
0xffff,
0xffff,
0xffff,
0xe8dc,
0xffff,
0x88c6,
0xffff,
0xe8dd,
0xe8de,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x8fe2,
0xffff,
0xffff,
0xffff,
0xe8df,
0xffff,
0xffff,
0xffff,
0x8b66,
0xffff,
0xffff,
0xe8e2,
0xffff,
0xffff,
0xe8e1,
0xffff,
0xe8e0,
0xffff,
0xffff,
0xe691,
0xffff,
0x95da,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe8e3,
0xe8e4,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe8e5,
0xffff,
0xffff,
0xe8e6,
0xffff,
0xe8e7,
0xffff,
0xffff,
0xe8e8,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x8ad8,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe8e9,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe8ea,
0x9442,
0xffff,
0xffff,
0xffff,
0xe8ec,
0x89b9,
0xffff,
0xe8ef,
0xe8ee,
0xffff,
0xffff,
0xffff,
0xffff,
0x8943,
0xffff,
0xffff,
0xffff,
0x8bbf,
0xffff,
0x95c5,
0x92b8,
0x8da0,
0xffff,
0x8d80,
0x8f87,
0xffff,
0x907b,
0xffff,
0xffff,
0xffff,
0xe8f1,
0xffff,
0xffff,
0xe8f0,
0x9761,
0x8ae6,
0x94d0,
0x93da,
0xffff,
0xffff,
0xffff,
0x909c,
0x97cc,
0xffff,
0x8c7a,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe8f4,
0xffff,
0xffff,
0xe8f3,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x966a,
0x93aa,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x896f,
0xffff,
0xffff,
0xe8f5,
0xe8f2,
0xffff,
0xffff,
0x9570,
0x978a,
0xe8f6,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe8f7,
0xffff,
0xffff,
0xffff,
0xffff,
0xe8f9,
0x91e8,
0x8a7a,
0x8a7b,
0xe8f8,
0xffff,
0xffff,
0xffff,
0xffff,
0x8ae7,
0x8cb0,
0xffff,
0xffff,
0x8ae8,
0xffff,
0xffff,
0x935e,
0xffff,
0xffff,
0x97de,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x8cda,
0xffff,
0xffff,
0xffff,
0xe8fa,
0xffff,
0xffff,
0xffff,
0xe8fb,
0xe8fc,
0xe940,
0xffff,
0xe942,
0xe941,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9597,
0xffff,
0xe943,
0xffff,
0xffff,
0xffff,
0xffff,
0xe944,
0xffff,
0xe945,
0xffff,
0xffff,
0xffff,
0xffff,
0xe946,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe948,
0xe947,
0xffff,
0xe949,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x94f2,
0xe3ca,
0xffff,
0xffff,
0x9048,
0xffff,
0xffff,
0x8b51,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe94a,
0xffff,
0xe94b,
0xffff,
0x99aa,
0x9f5a,
0x94d1,
0xffff,
0xffff,
0x88f9,
0xffff,
0x88b9,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x8e94,
0x964f,
0x8ffc,
0xffff,
0xffff,
0xffff,
0xffff,
0xe94c,
0xffff,
0x96dd,
0xffff,
0xffff,
0xffff,
0xe94d,
0x977b,
0xffff,
0x8961,
0xffff,
0xffff,
0xffff,
0x8e60,
0xffff,
0xe94e,
0x89ec,
0xe94f,
0xffff,
0xffff,
0xffff,
0xe950,
0xffff,
0xffff,
0xffff,
0xffff,
0xe952,
0xe953,
0xffff,
0xe955,
0xe951,
0xffff,
0xffff,
0xe954,
0xffff,
0xffff,
0xffff,
0x8ad9,
0xffff,
0xffff,
0xffff,
0xe956,
0xffff,
0xe957,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe958,
0xe959,
0xffff,
0xffff,
0xffff,
0xe95a,
0xffff,
0xffff,
0xe95c,
0xffff,
0xffff,
0xffff,
0xe95b,
0xffff,
0xe95e,
0xe961,
0xffff,
0xffff,
0xffff,
0xe95d,
0xe95f,
0xe960,
0xffff,
0xffff,
0xe962,
0xffff,
0x8bc0,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x8ef1,
0xe963,
0xe964,
0x8d81,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe965,
0xffff,
0xffff,
0x8a5d,
0xffff,
0xffff,
0xffff,
0x946e,
0xe966,
0xe967,
0xffff,
0xffff,
0xffff,
0xffff,
0x9279,
0x93e9,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe968,
0xffff,
0xffff,
0xffff,
0xffff,
0x949d,
0xffff,
0xffff,
0x91ca,
0x8977,
0x8bec,
0xffff,
0x8bed,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9293,
0xe96d,
0x8bee,
0xffff,
0xffff,
0x89ed,
0xffff,
0xffff,
0xe96c,
0xffff,
0xffff,
0xe96a,
0xffff,
0xe96b,
0xffff,
0xe969,
0xffff,
0xffff,
0xe977,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe96e,
0xe96f,
0xffff,
0xffff,
0xe970,
0xe971,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe973,
0xffff,
0xffff,
0xe972,
0xffff,
0xffff,
0xffff,
0x8f78,
0xffff,
0xe974,
0xffff,
0xffff,
0xffff,
0xe976,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x8b52,
0xe975,
0xffff,
0xffff,
0x919b,
0x8cb1,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe978,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x91cb,
0xffff,
0xffff,
0xe979,
0xffff,
0xffff,
0xffff,
0xffff,
0x93ab,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe97a,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe980,
0xffff,
0xe97d,
0xffff,
0xe97c,
0xe97e,
0xffff,
0xe97b,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe982,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe981,
0xffff,
0xe984,
0xffff,
0xffff,
0x8bc1,
0xe983,
0xffff,
0xffff,
0xffff,
0xe985,
0xffff,
0xffff,
0xe986,
0xffff,
0xe988,
0xe987,
0xffff,
0xffff,
0xffff,
0xe989,
0xe98b,
0xe98a,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x8d9c,
0xffff,
0xffff,
0xffff,
0xffff,
0xe98c,
0xffff,
0xffff,
0xe98d,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x8a5b,
0xffff,
0xffff,
0xffff,
0xe98e,
0xffff,
0xffff,
0xffff,
0xe98f,
0xffff,
0xffff,
0xffff,
0x9091,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe990,
0xffff,
0xe991,
0xffff,
0xe992,
0xe993,
0xffff,
0xffff,
0xffff,
0x8d82,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe994,
0xe995,
0xffff,
0xffff,
0xe996,
0xe997,
0xffff,
0xffff,
0xe998,
0xffff,
0xffff,
0xffff,
0x94af,
0xe99a,
0xffff,
0x9545,
0xe99b,
0xe999,
0xffff,
0xe99d,
0xffff,
0xffff,
0xe99c,
0xffff,
0xffff,
0xe99e,
0xffff,
0xffff,
0xffff,
0xe99f,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe9a0,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe9a1,
0xffff,
0xe9a2,
0xffff,
0xffff,
0xffff,
0xffff,
0xe9a3,
0xffff,
0xffff,
0xe9a4,
0xe9a5,
0xffff,
0xe9a6,
0xffff,
0xe9a7,
0xe9a8,
0xe9a9,
0xe9aa,
0xffff,
0xffff,
0xffff,
0xe9ab,
0xe9ac,
0xffff,
0x9f54,
0xe9ad,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe2f6,
0x8b53,
0xffff,
0xffff,
0xffff,
0xffff,
0x8a40,
0x8db0,
0xe9af,
0xe9ae,
0x96a3,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe9b1,
0xe9b2,
0xe9b0,
0xffff,
0xe9b3,
0xffff,
0xffff,
0x9682,
0xffff,
0xffff,
0xffff,
0xe9b4,
0xffff,
0x8b9b,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9844,
0xffff,
0xffff,
0xffff,
0xffff,
0xe9b5,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe9b7,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x88bc,
0xffff,
0xffff,
0xe9b8,
0x95a9,
0xe9b6,
0xffff,
0xffff,
0xe9b9,
0xe9ba,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe9bb,
0xe9bc,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe9bd,
0xffff,
0x968e,
0x8e4c,
0xffff,
0x8df8,
0x914e,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe9be,
0xffff,
0xffff,
0xffff,
0xffff,
0xe9c1,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe9bf,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe9c2,
0xffff,
0xffff,
0x8cef,
0xe9c0,
0xffff,
0xffff,
0xffff,
0xffff,
0xe9c3,
0xffff,
0xe9c4,
0xe9c5,
0xffff,
0xe9c9,
0xffff,
0x8e49,
0xffff,
0xffff,
0xffff,
0xffff,
0x91e2,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe9ca,
0xe9c7,
0xe9c6,
0xe9c8,
0xffff,
0xffff,
0xffff,
0x8c7e,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe9ce,
0xe9cd,
0xe9cc,
0xffff,
0xffff,
0x88b1,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe9d8,
0xffff,
0xe9d4,
0xffff,
0xe9d5,
0xe9d1,
0xe9d7,
0xffff,
0xe9d3,
0x8a82,
0xffff,
0xffff,
0x986b,
0xffff,
0xe9d6,
0xe9d2,
0xe9d0,
0xe9cf,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe9da,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe9dd,
0xffff,
0xffff,
0xe9dc,
0xe9db,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9568,
0xe9d9,
0x88f1,
0xe9de,
0xffff,
0xe9e0,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x8a8f,
0xe9cb,
0x8956,
0xffff,
0xffff,
0xe9e2,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe9e1,
0xe9df,
0x924c,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9690,
0xffff,
0xffff,
0xffff,
0xffff,
0x97d8,
0xffff,
0xffff,
0xe9e3,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe9e4,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe9e5,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe9e6,
0xffff,
0xe9e7,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x92b9,
0xffff,
0xe9e8,
0xffff,
0x94b5,
0xffff,
0xe9ed,
0xe9e9,
0xffff,
0xffff,
0xffff,
0xe9ea,
0xffff,
0xffff,
0x9650,
0x96c2,
0xffff,
0x93ce,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xe9ee,
0xffff,
0xffff,
0xe9ef,
0x93bc,
0xe9ec,
0xe9eb,
0xffff,
0xffff,
0xffff,
0xffff,
0x89a8,
0xffff,
0xffff,
0xffff,
0xe9f7,
0xffff,
0xffff,
0xe9f6,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x8995,
0xffff,
0xffff,
0xffff,
0xe9f4,
0xffff,
0xffff,
0xffff,
0xe9f3,
0xffff,
0xffff,
0xe9f1,
0xffff,
0x8a9b,
0xffff,
0xe9f0,
0x8eb0,
0x89a7,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x8d83,
0xffff,
0xffff,
0xe9fa,
0xe9f9,
0xffff,
0xe9f8,
0xffff,
0xffff,
0xe9f5,
0xffff,
0xe9fb,
0xffff,
0xe9fc,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xea44,
0xea43,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xea45,
0xffff,
0xffff,
0x894c,
0xea40,
0xea41,
0xffff,
0x8d94,
0x96b7,
0xffff,
0xffff,
0xea42,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9651,
0xffff,
0xffff,
0xea4a,
0xffff,
0xffff,
0xea46,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xea4b,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xea48,
0xffff,
0xea47,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x8c7b,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xea4c,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xea4d,
0xffff,
0xffff,
0xffff,
0xffff,
0xea4e,
0xffff,
0xea49,
0xffff,
0xffff,
0xffff,
0xe9f2,
0xffff,
0xffff,
0xea4f,
0xffff,
0x92df,
0xffff,
0xffff,
0xffff,
0xea53,
0xffff,
0xea54,
0xea52,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xea51,
0xea57,
0xffff,
0xea50,
0xffff,
0xea55,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xea56,
0xffff,
0xffff,
0xffff,
0xea59,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xea58,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xea5b,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xea5c,
0xffff,
0xea5d,
0xffff,
0xffff,
0x9868,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xea5a,
0x91e9,
0x8deb,
0xffff,
0xffff,
0xea5e,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xea5f,
0xea60,
0xffff,
0xffff,
0xea61,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xea62,
0xffff,
0xffff,
0x8cb2,
0xea63,
0xffff,
0xffff,
0xffff,
0xea64,
0xffff,
0x8ead,
0xffff,
0xea65,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xea66,
0xffff,
0xffff,
0xea67,
0xea68,
0xffff,
0xffff,
0xffff,
0xffff,
0xea6b,
0xea69,
0x985b,
0xffff,
0xea6a,
0xffff,
0x97ed,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xea6c,
0xffff,
0x97d9,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xea6d,
0x949e,
0xffff,
0xffff,
0xea6e,
0xea70,
0xffff,
0xffff,
0xea71,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xea6f,
0x8d8d,
0x96cb,
0x9683,
0x9bf5,
0xffff,
0x9f80,
0x969b,
0xffff,
0xffff,
0xffff,
0xffff,
0x89a9,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xea73,
0x8b6f,
0xea74,
0xea75,
0xea76,
0xffff,
0x8d95,
0xffff,
0xea77,
0xffff,
0xffff,
0xffff,
0xe0d2,
0x96d9,
0xffff,
0x91e1,
0xea78,
0xea7a,
0xea79,
0xffff,
0xea7b,
0xffff,
0xffff,
0xffff,
0xffff,
0xea7c,
0xffff,
0xffff,
0xea7d,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xea7e,
0xffff,
0xffff,
0xffff,
0xffff,
0xea80,
0xffff,
0xea81,
0xea82,
0xffff,
0xea83,
0xffff,
0xea84,
0xea85,
0xea86,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xea87,
0xea88,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9343,
0xffff,
0xffff,
0xffff,
0xffff,
0x8cdb,
0xffff,
0xea8a,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x916c,
0xea8b,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xea8c,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x9540,
0xffff,
0xffff,
0xea8d,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xea8e,
0xe256,
0xffff,
0xffff,
0xe6d8,
0xe8eb,
0xffff,
0xffff,
0xea8f,
0xffff,
0xea90,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xea92,
0xea93,
0xea94,
0x97ee,
0xea91,
0xffff,
0xffff,
0xea95,
0xea96,
0xffff,
0xffff,
0xea98,
0xffff,
0xea97,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xea9a,
0xffff,
0xffff,
0xffff,
0xea9b,
0xea99,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x97b4,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xea9c,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xea9d,
0xe273,
0xffff,
0xffff,
0xea9e
};
unsigned short uni2sjis_e[] = {
0x8149,
0xffff,
0x8194,
0x8190,
0x8193,
0x8195,
0xffff,
0x8169,
0x816a,
0x8196,
0x817b,
0x8143,
0x817c,
0x8144,
0x815e,
0x824f,
0x8250,
0x8251,
0x8252,
0x8253,
0x8254,
0x8255,
0x8256,
0x8257,
0x8258,
0x8146,
0x8147,
0x8183,
0x8181,
0x8184,
0x8148,
0x8197,
0x8260,
0x8261,
0x8262,
0x8263,
0x8264,
0x8265,
0x8266,
0x8267,
0x8268,
0x8269,
0x826a,
0x826b,
0x826c,
0x826d,
0x826e,
0x826f,
0x8270,
0x8271,
0x8272,
0x8273,
0x8274,
0x8275,
0x8276,
0x8277,
0x8278,
0x8279,
0x816d,
0x815f,
0x816e,
0x814f,
0x8151,
0x814d,
0x8281,
0x8282,
0x8283,
0x8284,
0x8285,
0x8286,
0x8287,
0x8288,
0x8289,
0x828a,
0x828b,
0x828c,
0x828d,
0x828e,
0x828f,
0x8290,
0x8291,
0x8292,
0x8293,
0x8294,
0x8295,
0x8296,
0x8297,
0x8298,
0x8299,
0x829a,
0x816f,
0x8162,
0x8170,
0x8160,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0xffff,
0x8191,
0x8192,
0x81ca,
0xffff,
0xffff,
0x818f
};

/*--------------
End (tables)
  --------------*/

unsigned short
sjis2euc(unsigned short jcode) /* from pTeX source */
{
  unsigned short  firstbyte, secondbyte;

  firstbyte = (jcode>>8) & 0xff;
  secondbyte = jcode & 0xff;
  firstbyte -= ( firstbyte>=0xa0 ) ? 0xc1 : 0x81;
  jcode = ((firstbyte<<1) + 0x21)<<8;
  if( secondbyte>=0x9f ) {
    jcode += 0x0100;
    jcode |= (secondbyte - 0x7e) & 0xff;
  } else {
    jcode |= (secondbyte - ((secondbyte<=0x7e) ? 0x1f : 0x20 )) & 0xff;
  }
  return(jcode | 0x8080);
}

void
transform_code(int *asc, int n)
{
  unsigned char  c, d;
  unsigned short w;

  w = 0;

  if(n >= TABAL && n <= TABAH && uni2sjis_a[n] != 0xffff)
    w = uni2sjis_a[n];
  else if(n >= TABBL && n <= TABBH && uni2sjis_b[n-TABBL] != 0xffff)
    w = uni2sjis_b[n-TABBL];
  else if(n >= TABCL && n <= TABCH && uni2sjis_c[n-TABCL] != 0xffff)
    w = uni2sjis_c[n-TABCL];
  else if(n >= TABDL && n <= TABDH && uni2sjis_d[n-TABDL] != 0xffff)
    w = uni2sjis_d[n-TABDL];
  else if(n >= TABEL && n <= TABEH && uni2sjis_e[n-TABEL] != 0xffff)
    w = uni2sjis_e[n-TABEL];

  if(w) {
    if(Euc) w = sjis2euc(w);
    c = (w >> 8) & 0xff;
    d = w & 0xff;
    putc(c, Fout);
    putc(d, Fout);
    *asc = 1;
  }
  else {
    fprintf(Fout, "\\UTF{%04X}", n);
    *asc = 0;
  }
}

/*
  Check the first character of some ligatures (Kino san)
*/
int
ligfirstp(int n)
{
  if(n == 0x304B ||
     n == 0x304D ||
     n == 0x304F ||
     n == 0x3051 ||
     n == 0x3053 ||
     n == 0x30AB ||
     n == 0x30AD ||
     n == 0x30AF ||
     n == 0x30B1 ||
     n == 0x30B3 ||
     n == 0x30BB ||
     n == 0x30C4 ||
     n == 0x30C8 ||
     n == 0x31F7)
    return 1;
  else
    return 0;
}

/*
  Check the second character of some ligatures (Kino san)
*/
int
ligsecondp(int n)
{
  if(n == 0x309a || n == 0x309c)
    return 1;
  else
    return 0;
}

/*
  Output usual TeX commands for Latin characters, \CID command for some
  ligatures (Kino san), otherwise output sjis, euc code or \UTF command.
*/
void
output_character(int *asc, int *lig, int *nsave, int n)
{
/*
  Latin characters
*/
  if(n >= 0x00a0 && n <= 0x05ff) {
    if(latin2tex_a[n-0x00a0]) {
      if(*lig) {
	*lig = 0;
	transform_code(asc, *nsave);
      }
      fprintf(Fout, "%s", latin2tex_a[n-0x00a0]);
      *asc = 1;
      return;
    }
  }
  else if(n >= 0x1e00 && n <= 0x1eff) {
    if(latin2tex_b[n-0x1e00]) {
      if(*lig) {
	*lig = 0;
	transform_code(asc, *nsave);
      }
      fprintf(Fout, "%s", latin2tex_b[n-0x1e00]);
      *asc = 1;
      return;
    }
  }
  else if(n >= 0x2000 && n <= 0x22ff) {
    if(latin2tex_c[n-0x2000]) {
      if(*lig) {
	*lig = 0;
	transform_code(asc, *nsave);
      }
      fprintf(Fout, "%s", latin2tex_c[n-0x2000]);
      *asc = 1;
      return;
    }
  }
/*
  One-byte kanas
*/
  else if(n >= 0xff61 && n <= 0xff9f) {
    if(*lig) {
      *lig = 0;
      transform_code(asc, *nsave);
    }
    fprintf(Fout, "\\CID{%d}", n - 0xff61 + 327);
    *asc = 0;
    return;
  }

/*
  main process
*/ 
  if(*lig == 0) {
    if(ligfirstp(n)) {
      *lig = 1;
      *nsave = n;
    }
    else
      transform_code(asc, n);
  }
  else if(*lig == 1) {
    if(ligsecondp(n)) {
      *lig = 0;
      *asc = 0;
      switch(*nsave) {
      case 0x304b:
	fprintf(Fout, "\\CID{15603}");
	break;
      case 0x304d:
	fprintf(Fout, "\\CID{15604}");
	break;
      case 0x304f:
	fprintf(Fout, "\\CID{15605}");
	break;
      case 0x3051:
	fprintf(Fout, "\\CID{15606}");
	break;
      case 0x3053:
	fprintf(Fout, "\\CID{15607}");
	break;
      case 0x30ab:
	fprintf(Fout, "\\CID{15694}");
	break;
      case 0x30ad:
	fprintf(Fout, "\\CID{15695}");
	break;
      case 0x30af:
	fprintf(Fout, "\\CID{15696}");
	break;
      case 0x30b1:
	fprintf(Fout, "\\CID{15697}");
	break;
      case 0x30b3:
	fprintf(Fout, "\\CID{15698}");
	break;
      case 0x30bb:
	fprintf(Fout, "\\CID{15699}");
	break;
      case 0x30c4:
	fprintf(Fout, "\\CID{15700}");
	break;
      case 0x30c8:
	fprintf(Fout, "\\CID{15701}");
	break;
      case 0x31f7:
	fprintf(Fout, "\\CID{15712}");
	break;
      default:
	break;
      }
    }
    else {
      *lig = 0;
      transform_code(asc, *nsave);
      transform_code(asc, n);
    }
  }
}

void
usage(char *s)
{
  fprintf(stderr, "Usage: %s [-c] [-s|-e] [input] [output]\n", s);
  fprintf(stderr, "   Default input is stdin, and default output is stdout.\n");
#ifdef EUC
  fprintf(stderr, "   utf-8 characters in the input are changed into euc ");
  fprintf(stderr, "(-s: sjis) characters\n");
#else
  fprintf(stderr, "   utf-8 characters in the input are changed into sjis ");
  fprintf(stderr, "(-e: euc) characters\n");
#endif
  fprintf(stderr, "   or \\UTF/\\CID commands in the utf/otf ");
  fprintf(stderr, "packages for pLaTeX.\n");
  fprintf(stderr, "   China characters are prefered for some ");
  fprintf(stderr, "surrogate pairs by the option -c.\n");
  fprintf(stderr, "Usage: %s --help\n", s);
  fprintf(stderr, "   Prints this message and exits.\n");
  fprintf(stderr, "Usage: %s --version\n", s);
  fprintf(stderr, "   Prints version number and exits.\n");
}

int
main(int argc, char **argv)
{
  int i=0, lig=0, asc=1;
  int a, b, c, d, n, j;
  unsigned int k;
  int nsave;

#ifdef WIN32
  strcpy(argv[0], "utf8toutf");
  setmode(fileno(stdout), _O_BINARY);
  setmode(fileno(stdin), _O_BINARY);
#endif

  Finp = stdin;
  Fout = stdout;

  a = 1;

  while(a < argc && argv[a][0] == '-') {
    if(!strncmp(argv[a], "-h", 2) ||
       !strncmp(argv[a], "--h", 3)) {
      fprintf(stderr, "(%s-%s)\n", argv[0], Version);
      usage(argv[0]);
      return 0;
    }
    else if(!strncmp(argv[a], "-v", 2) ||
	    !strncmp(argv[a], "--v", 3)) {
      fprintf(stderr, "%s-%s\n", argv[0], Version);
      return 0;
    }
    else if(!strncmp(argv[a], "-s", 2) ||
	    !strncmp(argv[a], "--s", 3)) {
      Euc = 0;
    }
    else if(!strncmp(argv[a], "-e", 2) ||
	    !strncmp(argv[a], "--e", 3)) {
      Euc = 1;
    }
    else if(!strncmp(argv[a], "-c", 2) ||
	    !strncmp(argv[a], "--c", 3)) {
      Chlang = 1;
    }
    else if(!strncmp(argv[a], "-j", 2) ||
	    !strncmp(argv[a], "--j", 3)) {
      Chlang = 0;
    }
    else {
      fprintf(stderr, "Wrong option.\n");
      usage(argv[0]);
      return 3;
    }
    a++;
  }
  if(a == argc - 1) {
    Finp = fopen(argv[a], RMODE);
    if(!Finp) {
      fprintf(stderr, "I cannot open %s to read.\n", argv[a]);
      return 1;
    }
  }
  else if(a == argc - 2) {
    Finp = fopen(argv[a], RMODE);
    if(!Finp) {
      fprintf(stderr, "I cannot open %s to read.\n", argv[a]);
      return 1;
    }
    Fout = fopen(argv[++a], WMODE);
    if(!Fout) {
      fprintf(stderr, "I cannot open %s to write.\n", argv[a]);
      return 1;
    }
  }
  else if(a != argc){
    fprintf(stderr, "Wrong arguments.\n");
    usage(argv[0]);
    return 2;
  }

  while((a = getc(Finp)) != EOF) {
    i++;
    if(i == 1 && a == 0xef) continue;
    if(i == 2 && a == 0xbb) continue;
    if(i == 3 && a == 0xbf) continue;

    if(a >=0 && a <= 0x7f) {
      if(lig) {
	transform_code(&asc, nsave);
	lig = 0;
      }
      if(a == '\r') {
	if(asc == 0) putc('%', Fout);
	putc(a, Fout);
	a = getc(Finp);
	if(a == EOF) break;
	if(a == '\n')
	  putc(a, Fout);
	else
	  ungetc(a, Finp);
      }
      else if(a == '\n') {
	if(asc == 0) putc('%', Fout);
	putc(a, Fout);
      }
      else
	putc(a, Fout);
      asc = 1;
      continue;
    }
    else if(a >= 0xc0 && a <= 0xdf) {
      b = getc(Finp); i++; asc = 0;
      if(b >= 0x80 && b <= 0xbf) {
	n = 0x40 * (a - 0xc0) + b - 0x80;
	output_character(&asc, &lig, &nsave, n);
      }
    }
    else if(a >= 0xe0 && a <= 0xef) {
      b = getc(Finp); i++;
      c = getc(Finp); i++; asc = 0;
      if(b >= 0x80 && b <= 0xbf && c >= 0x80 && c <= 0xbf) {
	n = 0x1000 * (a - 0xe0) + 0x40 * (b - 0x80) + c - 0x80;
	output_character(&asc, &lig, &nsave, n);
      }
    }
    else if(a == 0xf0) {
      if(lig) {
	transform_code(&asc, nsave);
	lig = 0;
      }
      b = getc(Finp); i++;
      c = getc(Finp); i++;
      d = getc(Finp); i++; asc = 0;
      k = d + c * 256 + b * 256 * 256 + a * 256 * 256 * 256;
      if(Chlang) {
	for(j = 0; j < SRGNUM2; j++) {
	  if(k == srgtab2[j].utfeight) {
	    fprintf(Fout, "\\UTF{%04X}", srgtab2[j].ucs);
	    break;
	  }
	}
	if(j == SRGNUM2 || k != srgtab2[j].utfeight) {
	  for(j = 0; j < SRGNUM; j++) {
	    if(k == srgtab[j].utfeight) {
	      fprintf(Fout, "\\CID{%d}", srgtab[j].cid);
	      break;
	    }
	  }
	}
      }
      else {
	for(j = 0; j < SRGNUM; j++) {
	  if(k == srgtab[j].utfeight) {
	    fprintf(Fout, "\\CID{%d}", srgtab[j].cid);
	    break;
	  }
	}
	if(j == SRGNUM || k != srgtab[j].utfeight) {
	  for(j = 0; j < SRGNUM2; j++) {
	    if(k == srgtab2[j].utfeight) {
	      fprintf(Fout, "\\UTF{%04X}", srgtab2[j].ucs);
	      break;
	    }
	  }
	}
      }
    }
  }
  if(Finp != stdin)  fclose(Finp);
  if(Fout != stdout) fclose(Fout);
  return 0;
}
