/*
  A filter to output UTF-8 text files to stdout.
*/

#define  BSIZ 524288
#include <stdio.h>
#include <fcntl.h>
#include <io.h>
#include <windows.h>

int main(void)
{
  DWORD ret, len;
  unsigned char srcstr[BSIZ];
  unsigned char buffer[BSIZ];
  unsigned char *p;
  HANDLE hstdout;
  int c;
  int isconsole = 0;

  setmode(fileno(stdin), _O_BINARY);
  setmode(fileno(stdout), _O_BINARY);
  setvbuf(stdout, NULL, _IONBF, 0);
  setvbuf(stdin, NULL, _IONBF, 0);

  if(_isatty(fileno(stdout)))
    isconsole = 1;

  if (isconsole)
    hstdout = GetStdHandle(STD_OUTPUT_HANDLE);
  else {
    putc(0xff, stdout);
    putc(0xfe, stdout);
  }

  p = srcstr;

 Again:
  while((c = getc(stdin)) != EOF && c != '\n')
    *p++ = c;
  if(c == '\n') {
    *p++ = c;
    *p++ = '\0';
    len = MultiByteToWideChar(CP_UTF8, 0, srcstr, -1, buffer, BSIZ);
    if(isconsole && len > 1)
      WriteConsoleW(hstdout, buffer, len - 1, &ret, NULL);
    else if(len > 1)
      fwrite(buffer, 2, len - 1, stdout);
    p = srcstr;
    goto Again;
  } else {
    *p++ = '\0';
    len = MultiByteToWideChar(CP_UTF8, 0, srcstr, -1, buffer, BSIZ);
    if(isconsole && len > 1)
      WriteConsoleW(hstdout, buffer, len - 1, &ret, NULL);
    else if(len > 1)
      fwrite(buffer, 2, len - 1, stdout);
    return 0;
  }
}
