#!/bin/sh

set -e
set -x

cwd=`pwd`
thisdir=`dirname $0`
thisfull=`(cd $thisdir; pwd)`
pcre=dist/pcre-8.00.tar.bz2
zlib=dist/zlib-1.2.3.tar.gz

rm -rf build stage external-libs
mkdir build
cd build

tar xjf ../$pcre
cd pcre*
./configure --disable-shared --disable-cpp --prefix=$cwd/stage
make
make install
make distclean
CC=$thisfull/clwrap ./configure --disable-shared --disable-cpp
cp pcre_chartables.c.dist pcre_chartables.c
for i in pcre_compile pcre_config pcre_dfa_exec pcre_exec \
    	 pcre_fullinfo pcre_get pcre_globals pcre_info pcre_maketables \
    	 pcre_newline pcre_ord2utf8 pcre_refcount pcre_study pcre_tables \
    	 pcre_try_flipped pcre_ucd pcre_valid_utf8 pcre_version \
    	 pcre_xclass pcre_chartables; do
    cl -nologo -O2 -Zi -Gy -MD -DHAVE_CONFIG_H -I. -c $i.c
done
lib -nologo /out:pcre.lib *.obj
cp pcre.lib $cwd/stage/lib
cd ..

tar xzf ../$zlib
cd zlib*
make install CC=gcc CFLAGS=-O2 prefix=$cwd/stage

for i in adler32 compress crc32 gzio uncompr deflate trees \
         zutil inflate infback inftrees inffast; do
    cl -nologo -O2 -Zi -Gy -MD -c $i.c
done
lib -nologo /out:z.lib *.obj
cp z.lib $cwd/stage/lib
cd ..

cd ..
mkdir external-libs
mkdir external-libs/include
cp -p stage/include/*.h external-libs/include
mkdir external-libs/lib-mingw
cp -p stage/lib/lib{pcre,z}.a external-libs/lib-mingw
mkdir external-libs/lib-msvc
cp -p stage/lib/{pcre,z}.lib external-libs/lib-msvc

zip -r qpdf-external-libs-bin.zip external-libs

set +x
echo ""
echo "qpdf-external-libs-bin.zip has been created."
echo ""
echo "Run ./clean.sh to remove all generated files except the zip file."
