/*
 platex-euc   : equivalent to platex -kanji=euc
 platex-jis   : equivalent to platex -kanji=jis
 platex-utf8  : equivalent to platex -kanji=utf8
 platex-sjis  : equivalent to platex -kanji=sjis
*/

#include <stdio.h>
#include <string.h>
#include <process.h>
#include <malloc.h>

int isknj(int c)
{
  c &= 0xff;
  return((c>=0x81 && c<=0x9f) || (c>=0xe0 && c<=0xfc));
}

int main(int argc, char *argv[])
{
   char *av[100];
   int  i;
   char buff[256];
   char *p;

   if(argc > 98) {
      fprintf(stderr, "Too many arguments.\n");
      exit (100);
   }

   strcpy(buff, argv[0]);
   for(p = buff; *p; p++) {
      if(isknj(*p) && *(p+1)) {
	 p++;
	 continue;
      }
      if(*p == 0x5c) *p = '/';
   }
   p = strrchr(buff, '/');
   if(p) {
      p++;
      strcpy(buff, p);
   }
   p = strrchr(buff, '.');
   if(p) *p = '\0';

   p = strchr(buff, '-');
   if(p == NULL) {
      fprintf(stderr, "A \"-\" is expecded in the command name.\n");
      exit (100);
   }

   *p = '\0';
   p++;

   if(strcmp(p, "jis") &&
      strcmp(p, "sjis") &&
      strcmp(p, "euc") &&
      strcmp(p, "utf8")) {
      fprintf(stderr, "Incorrect encoding string.\n");
      exit (100);
   }

   av[0] = argv[0];
   strcpy(av[0], buff);
   for(i=1; i <= argc; i++) {
      av[i+1] = argv[i];
   }
   av[1] = (char *)malloc(strlen("-kanji=") + strlen(p) + 3);
   strcpy(av[1], "-kanji=");
   strcat(av[1], p);
   argc++;
   i = dlleptexmain(argc, av);
   return i;
}
