/* Public domain

   elapsedtime.c
   usage :
   elapsedtime command with arguments
   shows elapsed time in milliseconds
   2011/08/12 A. Kakuto

*/

#include <stdio.h>
#include <stdlib.h>
#include <process.h>
#include <string.h>
#include <malloc.h>
#include <windows.h>

typedef unsigned __int64 uint64;

uint64 getmillisec(void)
{
  SYSTEMTIME st;
  FILETIME   ft;
  uint64     w;

  GetSystemTime(&st);
  SystemTimeToFileTime(&st, &ft);
  /* unit : 100ns */
  w = (uint64)((uint64)ft.dwHighDateTime << 32) + (uint64)ft.dwLowDateTime;
  /* unit : ms */
  w = w / 10000;
  return w;
}

int is_include_space(char *s)
{
  char *p;
  p = strchr(s, ' ');
  if(p) return 1;
  p = strchr(s, '\t');
  if(p) return 1;
  return 0;
}

int main(int argc, char *argv[])
{
  int i;
  char *p;
  uint64 btime;
  uint64 etime;
  uint64 exectime;

  if(argc < 2) {
    fprintf(stderr, "Usage: elapsedtime command\n");
    return 1;
  }

  for(i = 0; i < argc; i++) {
    if(is_include_space(argv[i])) {
      p = (char *)malloc(strlen(argv[i])+3);
      strcpy(p, "\"");
      strcat(p, argv[i]);
      strcat(p, "\"");
      argv[i] = p;
    }
  }

  argv[argc] = NULL;
  argv++;
  argc--;

  btime = getmillisec();
  i = spawnvp(_P_WAIT, argv[0], argv);
  etime = getmillisec();

  if(etime >= btime) {
    exectime = etime -  btime;
    fprintf(stderr, "\nElapsed time = %d milliseconds\n", exectime);
  } else {
    fprintf(stderr, "\nelapsedtime: failed to get SYSTEMTIME.\n");
  }
  return i;
}
