/*
  editutf8ind.c
  Change ^^ab in foo.ind created by mendex -U into an unsigned char without
  any check.
  Usage: editutf8ind foo.ind
  It is important to check that a resulting foo.ind is right.
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#define  TMPNAM "ind-tmp-file.xxx.yyy.zzz"
#ifdef _MSC_VER
#define strcasecmp _stricmp
#endif

/* global */
FILE *fin, *fout;

void usage(void)
{
  fprintf(stderr, "Change ^^ab in an index file foo.ind created by mendex -U\n"
                  "into an unsigned char without any check.\n"
                  "It is important to check that a resulting foo.ind is right.\n"
                  "Usage: editutf8ind foo.ind\n");
  exit(0);
}

unsigned char tohex(unsigned char c)
{
  unsigned char ret;
  if(c >= 'a' && c <= 'f')
    ret = c - 'a' + 10;
  else if(c >= '0' && c <= '9')
    ret = c - '0';
  else {
    fprintf(stderr, "editutf8ind: I can't edit this index file.\n"
                    "Don't use me for this index file.\n"
                    "Recreate the index file since I must have broken it.\n");
    fclose(fin);
    fclose(fout);
    remove(TMPNAM);
    exit(2);
    return 255; /* never reaches here */
  }
  return ret;
}

int main(int argc, char **argv)
{
  unsigned char ibuff[4096], obuff[4096];
  unsigned char *p, *q;
  char fname[256];

  if(argc != 2 || !strncmp(argv[1], "-h", 2) || !strncmp(argv[1], "--h", 3))
    usage();

  strcpy(fname, argv[1]);
  p = strrchr(fname, '.');
  if(p == NULL || strcasecmp(p, ".ind"))
    strcat(fname, ".ind");

  fin = fopen(fname, "r");
  if(fin == NULL) {
    fprintf(stderr, "editutf8ind: %s can't be opened.\n", fname);
    return 1;
  }

  fout = fopen(TMPNAM, "wb");
  if(fout == NULL) {
    fprintf(stderr, "editutf8ind: a temporary file can't be opened.\n");
    return 1;
  }

  while(fgets(ibuff, 4094, fin)) {
    p = ibuff;
    q = obuff;
    while(*p) {
      if(strncmp(p, "^^", 2) == 0) {
        p += 2;
        *q = tohex(*p) * 16;
        p++;
        *q += tohex(*p);
        q++;
        p++;
      } else {
        *q++ = *p++;
      }
    }
    *q = '\0';
    fputs(obuff, fout);
  }

  fclose(fin);
  fclose(fout);
  remove(fname);
  rename(TMPNAM, fname);
  return 0;
}
