/*
**  bmp2png --- conversion from (Windows or OS/2 style) BMP to PNG
**
**  Copyright (C) 1999-2001 MIYASAKA Masaru
**
**  For conditions of distribution and use,
**  see copyright notice in common.h.
*/

#include "common.h"
#include "bmphed.h"

#define BMP2PNG_VER		"1.52 (Feb 13 2001)"

char outnam[FILENAME_MAX];
char outdir[FILENAME_MAX];
int  deletesrc = 0;
int  copytime  = 0;
int  complevel = 6;
int  interlace = 0;
int  filters   = 0;

#if defined(WIN32) || defined(MSDOS)
char errlogfile[] = ".\\B2PERROR.LOG";
#else
char errlogfile[] = "./b2perror.log";
#endif

	/* error messages */
#ifdef JAPANESE /* ---------- */
char wrn_mkdirfail[]   =
        "WARNING: o͐fBNg܂ - %s\n"
        "           -> -%c IvV ł̏o͐w͖܂\n";
char err_ropenfail[]   = "SKIPPED: Yt@C܂ - %s\n";
char err_wopenfail[]   = "SKIPPED: o̓t@C쐬ł܂ - %s\n";
char err_outofmemory[] = "SKIPPED: Ɨpmۂł܂ - %s\n";
	/* -- */
char err_readeof[]     = "SKIPPED: t@CrŐ؂Ă܂ - %s\n";
char err_readerr[]     = "SKIPPED: ǂݍ݃G[܂ - %s\n";
char err_not_a_bmp[]   = "SKIPPED: bmp t@Cł͂܂ - %s\n";
char err_invalid_hed[] =
        "SKIPPED: BMP t@C̃wb_TCYł - %s\n";
char err_width_zero[]  = "SKIPPED: 摜̕O(܂͕)ł - %s\n";
char err_height_zero[] = "SKIPPED: 摜̍O(܂͕)ł - %s\n";
char err_compressed[]  =
        "SKIPPED: k`ȊO bmp t@C͈܂ - %s\n";
char err_16or32bpp[]   =
        "SKIPPED: 16,32 bits/pixel  bmp t@C͈܂ - %s\n";
char err_invalid_bpp[] = "SKIPPED: 摜̐Fł - %s\n";
#else  /* ------------------- */
char wrn_mkdirfail[]   =
        "WARNING: Cannot create a directory - %s\n"
        "           -> Output directory specified by '-%c' will be ignored.\n";
char err_ropenfail[]   = "SKIPPED: No such file or directory - %s\n";
char err_wopenfail[]   = "SKIPPED: Cannot create - %s\n";
char err_outofmemory[] = "SKIPPED: Out of memory - %s\n";
	/* -- */
char err_readeof[]     = "SKIPPED: Premature end of BMP file - %s\n";
char err_readerr[]     = "SKIPPED: Read operation failed - %s\n";
char err_not_a_bmp[]   = "SKIPPED: Not a BMP file - %s\n";
char err_invalid_hed[] = "SKIPPED: Invalid header size in BMP file - %s\n";
char err_width_zero[]  =
        "SKIPPED: Invalid image size (width is less than one) - %s\n";
char err_height_zero[] =
        "SKIPPED: Invalid image size (height is less than one) - %s\n";
char err_compressed[]  = "SKIPPED: Compressed or bitfield BMP - %s\n";
char err_16or32bpp[]   = "SKIPPED: 16 or 32 bits/pixel BMP - %s\n";
char err_invalid_bpp[] = "SKIPPED: Invalid bit depth in BMP file - %s\n";
#endif /* ------------------- */

static int png_filters( const char * );
static int read_file( char *, IMAGE * );
static int read_stdin( IMAGE * );
static int write_file( char *, IMAGE * );
static int write_stdout( IMAGE * );
static char *read_bmp( char *, FILE *, IMAGE * );
static unsigned long mgetdwl( void * );
static unsigned int mgetwl( void * );
static int write_png( char *, FILE *, IMAGE * );
static void usage( char *, int );



/*
**		C
*/
int main( int argc, char *argv[] )
{
	char outf[FILENAME_MAX];
	IMAGE image;
	int  opt;
	char *arg;
	char *p,c;
	int  r_stdin,w_stdout;
	int  failure=0,success=0;

#ifdef __LCC__		/* lcc-win32 */
	char **envp;
	void _GetMainArgs( int *, char ***, char ***, int );
	_GetMainArgs( &argc, &argv, &envp, 1 );
#endif
#ifdef __RSXNT__
	_wildcard( &argc, &argv );
#endif
	envargv( &argc, &argv, "B2P" );

	r_stdin  = !isatty( fileno(stdin) );
	w_stdout = !isatty( fileno(stdout) );

	while( parsearg(&opt,&arg,argc,argv,"DdOoFf") ){
		if( isdigit(opt) ){		/* Zlib Compression Level (0-9) */
			complevel = opt - '0';
			continue;
		}
		switch( toupper(opt) ){
		case 'I':	interlace ^= 0x01;	break;
		case 'E':	deletesrc ^= 0x01;	break;
		case 'T':	copytime  ^= 0x01;	break;
		case 'Q':	quietmode ^= 0x01;	break;
		case 'L':	errorlog  ^= 0x01;	break;

		case 'F':		/* filter types to be used in libpng */
			filters = png_filters( arg );
			break;

		case 'D':		/* output directory */
			if( *arg=='-' ) arg = NULL;
			if( arg==NULL ){
				outdir[0] = '\0';
			}else{
				strcpy( outdir, arg );
				addslash( outdir );
				if( makedir(outdir)!=0 ){
					xprintf( wrn_mkdirfail, outdir, 'D' );
					outdir[0] = '\0';
				}
			}
			break;

		case 'O':		/* output filename */
			if( arg==NULL ){
				outnam[0] = '\0';
			}else{
				strcpy( outnam, arg );
				p = basname( outnam );
				c = *p;  *p = '\0';
				if( makedir(outnam)!=0 ){
					xprintf( wrn_mkdirfail, outnam, 'O' );
					outnam[0] = '\0';
				}else{
					*p = c;
				}
			}
			break;

		case 0x00:		/* input file spec */
			if( r_stdin ) break;
			if( w_stdout ){
				if( !read_file(arg,&image) ) return 1;
				if( !write_stdout(&image)  ) return 1;
				if( deletesrc ) remove( arg );
				return 0;
			}
			/* ---------------------- */
			if( outnam[0]!='\0' ){
				strcpy( outf, outnam );
				outnam[0] = '\0';
			}else{
				if( outdir[0]!='\0' ){
					strcpy( outf, outdir );
					strcat( outf, basname(arg) );
				}else{
					strcpy( outf, arg );
				}
#ifdef WIN32_LFN
				strcpy( suffix(outf), is_dos_filename(outf)? ".PNG":".png" );
#else
				strcpy( suffix(outf), ".png" );
#endif
			}
			/* ---------------------- */
			if( !read_file(arg,&image) ){
				failure++;
				break;
			}
			renbak( outf );
			if( !write_file(outf,&image) ){
				failure++;
				break;
			}
			/* ---------------------- */
			if( copytime ) cpyftime( arg, outf );
			if( deletesrc ) remove( arg );
			/* ---------------------- */
			success++;
			break;

		default:
			; /* Ignore unknown option */
		}
	}
	if( r_stdin ){
		if( !read_stdin(&image) ) return 1;
		if( w_stdout ){
			return !write_stdout( &image );
		}else{
			if( outnam[0]!='\0' ){
				strcpy( outf, outnam );
			}else{
				strcpy( outf, outdir );
				strcat( outf, "___stdin.png" );
			}
			renbak( outf );
			return !write_file( outf, &image );
		}
	}
	if( failure==0 && success==0 ) usage( argv[0], 255 );

	return (failure > 255)? 255 : failure;
}


#define elemsof(a)	(sizeof(a)/sizeof((a)[0]))

/*
**		PNG ̃tB^ʎwǂ
*/
static int png_filters( const char *arg )
{
	static const struct { char name[8]; int flag; } filter[] = {
		{ "NONE", PNG_FILTER_NONE  },	{ "SUB"    , PNG_FILTER_SUB   },
		{ "UP"  , PNG_FILTER_UP    },	{ "AVERAGE", PNG_FILTER_AVG   },
		{ "AVG" , PNG_FILTER_AVG   },	{ "PAETH"  , PNG_FILTER_PAETH },
		{ "ALL" , PNG_ALL_FILTERS  },
		{ "AUTO", 0                },	{ "DEFAULT", 0                }
	};
	char c,buf[128];
	int i,flags=0;

	if( arg==NULL ) return 0;	/* auto/default */

	do{
		i = 0;
		while( c=*(arg++), c!=',' && c!='\0' )
			if( i < sizeof(buf)-1 ) buf[i++] = toupper(c);
		buf[i] = '\0';

		for( i=0 ; i<elemsof(filter) ; i++ ){
			if( strcmp(buf,filter[i].name)==0 ){
				if( filter[i].flag==0 ) flags = 0;	/* auto/default */
				else flags |= filter[i].flag;
			}
		}
	}while( c!='\0' );

	return flags;
}


/*
**		fBXNt@C摜f[^ǂ
*/
static int read_file( char *fn, IMAGE *img )
{
	FILE *fp;
	char *p;

	fp = fopen( fn, "rb" );
	if( fp==NULL ){
		xprintf( err_ropenfail, fn );
		return 0;
	}
	p = read_bmp( fn, fp, img );
	fclose( fp );
	if( p!=NULL ){
		xprintf( p, fn );
		return 0;
	}
	return 1;
}


/*
**		W͂摜f[^ǂ
*/
static int read_stdin( IMAGE *img )
{
	static char fn[] = " (stdin)";
	FILE *fp;
	char *p;

#ifdef USE_FDOPEN
	fp = fdopen( fileno(stdin), "rb" );
	if( fp==NULL ){
		xprintf( err_ropenfail, fn );
		return 0;
	}
	p = read_bmp( fn, fp, img );
	fclose( fp );
#else
#ifdef USE_SETMODE
	setmode( fileno(stdin), O_BINARY );
#endif
	fp = stdin;
	p = read_bmp( fn, fp, img );
#endif
	if( p!=NULL ){
		xprintf( p, fn );
		return 0;
	}
	return 1;
}


/*
**		fBXNt@C։摜f[^
*/
static int write_file( char *fn, IMAGE *img )
{
	FILE *fp;
	int b;

	fp = fopen( fn, "wb" );
	if( fp==NULL ){
		xprintf( err_wopenfail, fn );
		imgfree( img );
		return 0;
	}
	b = write_png( fn, fp, img );
	fclose( fp );
	imgfree( img );

	return b;
}


/*
**		Wo͂։摜f[^
*/
static int write_stdout( IMAGE *img )
{
	static char fn[] = " (stdout)";
	FILE *fp;
	int b;

#ifdef USE_FDOPEN
	fp = fdopen( fileno(stdout), "wb" );
	if( fp==NULL ){
		xprintf( err_wopenfail, fn );
		imgfree( img );
		return 0;
	}
	b = write_png( fn, fp, img );
	fclose( fp );
#else
#ifdef USE_SETMODE
	setmode( fileno(stdout), O_BINARY );
#endif
	fp = stdout;
	b = write_png( fn, fp, img );
#endif
	imgfree( img );

	return b;
}


/* -----------------------------------------------------------------------
**		BMP t@C̓ǂݍ
*/

/*
**		.bmp t@C̓ǂݍ
*/
static char *read_bmp( char *fn, FILE *fp, IMAGE *img )
{
	BYTE bfh[FILEHED_SIZE+BMPV5HED_SIZE];
	BYTE * const bih = bfh + FILEHED_SIZE;
	BYTE rgbq[RGBQUAD_SIZE];
	DWORD offbits,bihsize,skip;
	DWORD compression,palsize;
	PALETTE *pal;
	UINT i;

	set_status( "Reading %s", basname(fn) );

	/* ------------------------------------------------------ */

	for( i=1 ; ; i-- ){		/* skip macbinary header */
		if( fread(bfh,(FILEHED_SIZE+BIHSIZE_SIZE),1,fp)!=1 ) goto rderr;
		if( mgetwl(bfh+BFH_WTYPE)==BMP_SIGNATURE ) break;
		if( i==0 ) return err_not_a_bmp;
		if( fread(bfh,(128-FILEHED_SIZE-BIHSIZE_SIZE),1,fp)!=1 ) goto rderr;
	}
	offbits = mgetdwl( bfh + BFH_DOFFBITS );
	bihsize = mgetdwl( bfh + BFH_DBIHSIZE );
	skip    = offbits - bihsize - FILEHED_SIZE;
	if( bihsize<COREHED_SIZE || bihsize>BMPV5HED_SIZE ||
	    offbits<(bihsize+FILEHED_SIZE) ) return err_invalid_hed;

	if( fread((bih+BIHSIZE_SIZE),(bihsize-BIHSIZE_SIZE),1,fp)!=1 ) goto rderr;

	if( bihsize==COREHED_SIZE ){		/* OS/2-Type BMP */
		img->width    = mgetwl( bih + BCH_WWIDTH );
		img->height   = mgetwl( bih + BCH_WHEIGHT );
		img->pixdepth = mgetwl( bih + BCH_WBITCOUNT );
		img->topdown  = FALSE;
		compression   = BI_RGB;
		palsize       = RGBTRIPLE_SIZE;
	}else{							/* Windows-Type BMP */
		img->width    = mgetdwl( bih + BIH_LWIDTH );
		img->height   = mgetdwl( bih + BIH_LHEIGHT );
		img->pixdepth = mgetwl(  bih + BIH_WBITCOUNT );
		img->topdown  = FALSE;
		compression   = mgetdwl( bih + BIH_DCOMPRESSION );
		palsize       = RGBQUAD_SIZE;
		if( img->height<0 ){
			img->height  = -img->height;
			img->topdown = TRUE;	/* top-down BMP */
		}
	}
	if( img->width<=0  ) return err_width_zero;
	if( img->height<=0 ) return err_height_zero;
	if( compression!=BI_RGB ) return err_compressed;
	if( img->pixdepth!=1 && img->pixdepth!=4 &&
	    img->pixdepth!=8 && img->pixdepth!=24 ){
		if( img->pixdepth==16 || img->pixdepth==32 ) return err_16or32bpp;
		else return err_invalid_bpp;
	}
	if( img->pixdepth!=24 ){
		img->palnum  = skip / palsize;
		skip         = skip % palsize;
	}else{
		img->palnum  = 0;
	}
	if( !imgalloc(img) ) return err_outofmemory;

	/* ------------------------------------------------------ */

	for( pal=img->palette, i=img->palnum ; i>0 ; i--, pal++ ){
		if( fread(rgbq,palsize,1,fp)!=1 ) goto rderr2;
		pal->red   = rgbq[RGBQ_RED];
		pal->green = rgbq[RGBQ_GREEN];
		pal->blue  = rgbq[RGBQ_BLUE];
	}
	for( i=skip ; i>0 ; i-- )
		if( fgetc(fp)==EOF ) goto rderr2;

	/* ------------------------------------------------------ */

	if( fread(img->bmpbits,img->imgbytes,1,fp)!=1 ) goto rderr2;

	/* ------------------------------------------------------ */

	set_status( "Read OK %s", basname(fn) );

	return NULL;	/* success */

rderr2:				/* error */
	imgfree( img );
rderr:
	return ferror(fp)? err_readerr : err_readeof;
}


/*
**	 little-endien ` 4oCgǂ
*/
static unsigned long mgetdwl( void *ptr )
{
	unsigned char *p=ptr;
	unsigned long v;

	v = ((unsigned long)p[0]    ) + ((unsigned long)p[1]<<8 ) +
	    ((unsigned long)p[2]<<16) + ((unsigned long)p[3]<<24) ;

	return v;
}


/*
**	 little-endien ` 2oCgǂ
*/
static unsigned int mgetwl( void *ptr )
{
	unsigned char *p=ptr;

	return ((unsigned int)p[0]) + ((unsigned int)p[1]<<8);
}


/* -----------------------------------------------------------------------
**		PNG t@C̏
*/

/*
**		.png t@C̏
*/
static int write_png( char *fn, FILE *fp, IMAGE *img )
{
	png_structp png_ptr;
	png_infop info_ptr;
	int bit_depth;
	int color_type;
	int interlace_type;

	set_status( "Writing %s", basname(fn) );

	/* ------------------------------------------------------ */

	png_ptr = png_create_write_struct( PNG_LIBPNG_VER_STRING, fn,
	                                     png_my_error, png_my_warning );
	if( png_ptr==NULL ){
		xprintf( err_outofmemory, fn );
		return 0;
	}
	info_ptr = png_create_info_struct( png_ptr );
	if( info_ptr==NULL ){
		png_destroy_write_struct( &png_ptr, NULL );
		xprintf( err_outofmemory, fn );
		return 0;
	}
#if PNG_LIBPNG_VER_MINOR > 4
	if(setjmp(png_jmpbuf(png_ptr))){
#else
	if( setjmp(png_ptr->jmpbuf) ){
#endif
		/* If we get here, we had a problem reading the file */
		png_destroy_write_struct( &png_ptr, &info_ptr );
		return 0;
	}
	png_init_io( png_ptr, fp );
	png_set_compression_level( png_ptr, complevel );
	if( filters!=0 )
		png_set_filter( png_ptr, PNG_FILTER_TYPE_BASE, filters );

	/* ------------------------------------------------------ */

	if( img->pixdepth==24 ){
		bit_depth  = 8;
		color_type = PNG_COLOR_TYPE_RGB;
		png_set_compression_mem_level( png_ptr, MAX_MEM_LEVEL );
	}else{
		bit_depth  = img->pixdepth;
		color_type = PNG_COLOR_TYPE_PALETTE;
		png_set_PLTE( png_ptr, info_ptr, img->palette, img->palnum );
	}
	interlace_type = (interlace)? PNG_INTERLACE_ADAM7 : PNG_INTERLACE_NONE ;

	png_set_IHDR( png_ptr, info_ptr, img->width, img->height, bit_depth,
	              color_type, interlace_type, PNG_COMPRESSION_TYPE_DEFAULT,
	              PNG_FILTER_TYPE_DEFAULT );

	png_write_info( png_ptr, info_ptr );

	/* ------------------------------------------------------ */

	if( img->pixdepth==24 ) png_set_bgr( png_ptr );

	/* ------------------------------------------------------ */

	png_set_write_status_fn( png_ptr, row_callback );
	init_progress_meter( png_ptr, img->width, img->height );

	png_write_image( png_ptr, img->rowptr );

	png_write_end( png_ptr, info_ptr );
	png_destroy_write_struct( &png_ptr, &info_ptr );

	/* ------------------------------------------------------ */

	set_status( "OK      %s", basname(fn) );
	feed_line();

	return 1;
}


/* -----------------------------------------------------------------------
**		wvXN[̕\
*/

/*
**		gp@\
*/
static void usage( char *argv0, int status )
{
	static const char str_usage[] =
#ifdef JAPANESE /* -------------------------- */
#ifdef EUC_JP
#define SJ_ESC(esc,raw)	raw
#else /* SHIFT_JIS */
#define SJ_ESC(esc,raw)	esc
#endif
		"bmp2png, BMP -> PNG Ro[^ - version " BMP2PNG_VER "\n"
		"   Copyright (C) 1999-2001 MIYASAKA Masaru\n"
		"   Compiled with libpng " PNG_LIBPNG_VER_STRING " and zlib " ZLIB_VERSION ".\n"
		"\n"
		"g : %s [-XCb`] ̓t@C ...\n"
		"       : ... | %s [-XCb`] | ...\n"
		"\n"
		"̓t@Cɂ̓ChJ[hg܂ (*  ?)\n"
		"o̓t@C͓̓t@C̊gq .png ɕςOɂȂ܂\n"
		"\n"
		"XCb`IvV (ł) :\n"
		"   -0..-9   kx (ftHg -6)\n"
		"   -I       C^[[X` PNG t@C쐬\n"
		"   -F type[,...]  PNG ̈kɎgtB^E^Cvw肷\n"
		"                  ^Cv: none,sub,up,average(avg),paeth,all,auto(default)\n"
		"   -O name  o̓t@Cw肷\n"
		"   -D dir   t@Co͂fBNgw肷\n"
		"   -E       ϊꍇɂ͓̓t@C폜\n"
		"   -T       ̓t@C̃^CX^vo̓t@Cɐݒ肷\n"
		"   -Q       , ؂" SJ_ESC("\x95\x5C\x8E\xA6","\") "Ȃ\n"
		"   -L       ̃G[Ot@C(%s)ɋL^\n";
#else  /* ----------------------------------- */
		"bmp2png, a BMP-to-PNG converter - version " BMP2PNG_VER "\n"
		"   Copyright (C) 1999-2001 MIYASAKA Masaru\n"
		"   Compiled with libpng " PNG_LIBPNG_VER_STRING " and zlib " ZLIB_VERSION ".\n"
		"\n"
		"Usage: %s [-switches] inputfile(s) ...\n"
		"   or: ... | %s [-switches] | ...\n"
		"\n"
		"List of input files may use wildcards (* and ?)\n"
		"Output filename is same as input filename, but extension .png\n"
		"\n"
		"Switches (case-insensitive) :\n"
		"   -0..-9   Compression level (default: -6)\n"
		"   -I       Create interlaced PNG files\n"
		"   -F type[,...]  Specify filter type(s) used to create PNG files\n"
		"                  type: none,sub,up,average(avg),paeth,all,auto(default)\n"
		"   -O name  Specify name for output file\n"
		"   -D dir   Output files into dir\n"
		"   -E       Delete input files after successful conversion\n"
		"   -T       Set the timestamp of input file on output file\n"
		"   -Q       Quiet mode\n"
		"   -L       Log errors to %s file\n";
#endif /* ----------------------------------- */
#if defined(WIN32) || defined(MSDOS)
	char c,*p,exef[FILENAME_MAX];

	argv0 = strcpy( exef, basname(argv0) );
	for( p=argv0 ; (c=*p)!='\0' ; p++ ) *p = tolower(c);
#endif
	fprintf( stdout, str_usage, argv0, argv0, errlogfile );

	exit( status );
}

