@x
  \def\?##1]{\hbox to 1in{\hfil##1.\ }}
  }
@y
  \def\?##1]{\hbox{Changes to \hbox to 1em{\hfil##1}.\ }}
  }
\let\maybe=\iffalse
@z

@x
November 1984].
@y
November 1984].

ML\TeX{} will add new primitives changing the behaviour of \TeX.  The
|banner| string has to be changed.  We do not change the |banner|
string, but will output an additional line to make clear that this is
a modified \TeX{} version.

@z

@x
@d banner=='This is TeX, Version 3.14159265' {printed when \TeX\ starts}
@y
@d TeX_banner_k=='This is JTeXk, Version 2.2, based on TeXk Version 3.14159265'
						{printed when \TeX\ starts}
@d TeX_banner=='This is JTeX, Version 2.2, based on TeX Version 3.14159265'
						{printed when \TeX\ starts}
@#
@d banner==TeX_banner
@d banner_k==TeX_banner {I do not use |TeX_banner_k|}
@z

@x
Actually the heading shown here is not quite normal: The |program| line
does not mention any |output| file, because \ph\ would ask the \TeX\ user
to specify a file name if |output| were specified here.
@:PASCAL H}{\ph@>
@^system dependencies@>
@y
@z

@x
program TEX; {all file names are defined dynamically}
label @<Labels in the outer block@>@/
@y
program TEX; {all file names are defined dynamically}
@z

@x
@t\4@>@<Basic printing procedures@>@/
@t\4@>@<Error handling procedures@>@/
@y
@t\4@>@<Basic printing procedures@>@/
@t\4@>@<Error handling procedures@>@/
@t\4@>@<Utility functions and procedures for Japanese@>@/
@z

@x
@ Three labels must be declared in the main program, so we give them
symbolic names.

@d start_of_TEX=1 {go here when \TeX's variables are initialized}
@d end_of_TEX=9998 {go here to close files and terminate gracefully}
@d final_end=9999 {this label marks the ending of the program}

@<Labels in the out...@>=
start_of_TEX@t\hskip-2pt@>, end_of_TEX@t\hskip-2pt@>,@,final_end;
  {key control points}
@y
@ For Web2c, labels are not declared in the main program, but
we still have to declare the symbolic names.

@d start_of_TEX=1 {go here when \TeX's variables are initialized}
@d final_end=9999 {this label marks the ending of the program}
@z

@x
@d debug==@{ {change this to `$\\{debug}\equiv\null$' when debugging}
@d gubed==@t@>@} {change this to `$\\{gubed}\equiv\null$' when debugging}
@y
@d debug==ifdef('TEXMF_DEBUG')
@d gubed==endif('TEXMF_DEBUG')
@z

@x
@d stat==@{ {change this to `$\\{stat}\equiv\null$' when gathering
  usage statistics}
@d tats==@t@>@} {change this to `$\\{tats}\equiv\null$' when gathering
  usage statistics}
@y
@d stat==ifdef('STAT')
@d tats==endif('STAT')
@z

@x
the codewords `$|init|\ldots|tini|$'.

@d init== {change this to `$\\{init}\equiv\.{@@\{}$' in the production version}
@d tini== {change this to `$\\{tini}\equiv\.{@@\}}$' in the production version}
@y
the codewords `$|init|\ldots|tini|$' for declarations and by the codewords
`$|Init|\ldots|Tini|$' for executable code.  This distinction is helpful for
implementations where a run-time switch differentiates between the two
versions of the program.

@d init==ifdef('INITEX')
@d tini==endif('INITEX')
@d Init==init if ini_version then begin
@d Tini==end;@+tini
@f Init==begin
@f Tini==end
@z

@x
@!init @<Initialize table entries (done by \.{INITEX} only)@>@;@+tini
@y
@!Init @<Initialize table entries (done by \.{INITEX} only)@>@;@+Tini
@z

@x
@<Constants...@>=
@!mem_max=30000; {greatest index in \TeX's internal |mem| array;
  must be strictly less than |max_halfword|;
  must be equal to |mem_top| in \.{INITEX}, otherwise |>=mem_top|}
@!mem_min=0; {smallest index in \TeX's internal |mem| array;
  must be |min_halfword| or more;
  must be equal to |mem_bot| in \.{INITEX}, otherwise |<=mem_bot|}
@!buf_size=500; {maximum number of characters simultaneously present in
  current lines of open files and in control sequences between
  \.{\\csname} and \.{\\endcsname}; must not exceed |max_halfword|}
@!error_line=72; {width of context lines on terminal error messages}
@!half_error_line=42; {width of first lines of contexts in terminal
  error messages; should be between 30 and |error_line-15|}
@!max_print_line=79; {width of longest text lines output; should be at least 60}
@!stack_size=200; {maximum number of simultaneous input sources}
@!max_in_open=6; {maximum number of input files and error insertions that
  can be going on simultaneously}
@!font_max=75; {maximum internal font number; must not exceed |max_quarterword|
  and must be at most |font_base+256|}
@!font_mem_size=20000; {number of words of |font_info| for all fonts}
@!param_size=60; {maximum number of simultaneous macro parameters}
@!nest_size=40; {maximum number of semantic levels simultaneously active}
@!max_strings=3000; {maximum number of strings; must not exceed |max_halfword|}
@!string_vacancies=8000; {the minimum number of characters that should be
  available for the user's control sequences and font names,
  after \TeX's own error messages are stored}
@!pool_size=32000; {maximum number of characters in strings, including all
  error messages and help texts, and the names of all fonts and
  control sequences; must exceed |string_vacancies| by the total
  length of \TeX's own strings, which is currently about 23000}
@!save_size=600; {space for saving values outside of current group; must be
  at most |max_halfword|}
@!trie_size=8000; {space for hyphenation patterns; should be larger for
  \.{INITEX} than it is in production versions of \TeX}
@!trie_op_size=500; {space for ``opcodes'' in the hyphenation patterns}
@!dvi_buf_size=800; {size of the output buffer; must be a multiple of 8}
@!file_name_size=40; {file names shouldn't be longer than this}
@!pool_name='TeXformats:TEX.POOL                     ';
  {string of length |file_name_size|; tells where the string pool appears}
@y
@d file_name_size == maxint
@d ssup_error_line = 255
@d ssup_trick_line=ssup_error_line+ssup_error_line-1
@^JTeX constant@>
@d ssup_max_strings == 2097151
{Larger values than 65536 cause the arrays to consume much more memory.}
@d ssup_trie_opcode == 65535
@d ssup_trie_size == @"3FFFFF

@d ssup_hyph_size == 65535 {Changing this requires changing (un)dumping!}
@d iinf_hyphen_size == 610 {Must be not less than |hyph_prime|!}

@d max_font_max=9000 {maximum number of internal fonts; this can be
                      increased, but |hash_size+max_font_max|
                      should not exceed 29000.}
@d font_base=0 {smallest internal font number; must be
                |>= min_quarterword|; do not change this without
                modifying the dynamic definition of the font arrays.}


@<Constants...@>=
@!hash_offset=514; {smallest index in hash array, i.e., |hash_base| }
  {Use |hash_offset=0| for compilers which cannot decrement pointers.}
@!trie_op_size=35111; {space for ``opcodes'' in the hyphenation patterns;
  best if relatively prime to 313, 361, and 1009.}
@!neg_trie_op_size=-35111; {for lower |trie_op_hash| array bound;
  must be equal to |-trie_op_size|.}
@!min_trie_op=0; {first possible trie op code for any language}
@!max_trie_op=ssup_trie_opcode; {largest possible trie opcode for any language}
@!pool_name=TEXMF_POOL_NAME; {this is configurable, for the sake of ML-\TeX}
  {string of length |file_name_size|; tells where the string pool appears}
@!engine_name=TEXMF_ENGINE_NAME; {the name of this engine}
@#
@!inf_mem_bot = 0;
@!sup_mem_bot = 1;

@!inf_main_memory = 3000;
@!sup_main_memory = 256000000;

@!inf_trie_size = 8000;
@!sup_trie_size = ssup_trie_size;

@!inf_max_strings = 3000;
@!sup_max_strings = ssup_max_strings;
@!inf_strings_free = 100;
@!sup_strings_free = sup_max_strings;

@!inf_buf_size = 500;
@!sup_buf_size = 30000000;

@!inf_nest_size = 40;
@!sup_nest_size = 4000;

@!inf_max_in_open = 6;
@!sup_max_in_open = 127;

@!inf_param_size = 60;
@!sup_param_size = 32767;

@!inf_save_size = 600;
@!sup_save_size = 80000;

@!inf_stack_size = 200;
@!sup_stack_size = 30000;

@!inf_dvi_buf_size = 800;
@!sup_dvi_buf_size = 65536;

@!inf_font_mem_size = 20000;
@!sup_font_mem_size = 147483647; {|integer|-limited, so 2 could be prepended?}

@!sup_font_max = max_font_max;
@!inf_font_max = 50; {could be smaller, but why?}

@!inf_pool_size = 32000;
@!sup_pool_size = 40000000;
@!inf_pool_free = 1000;
@!sup_pool_free = sup_pool_size;
@!inf_string_vacancies = 8000;
@!sup_string_vacancies = sup_pool_size - 23000;

@!sup_hash_extra = sup_max_strings;
@!inf_hash_extra = 0;

@!sup_hyph_size = ssup_hyph_size;
@!inf_hyph_size = iinf_hyphen_size; {Must be not less than |hyph_prime|!}

@!inf_expand_depth = 10;
@!sup_expand_depth = 10000000;
@z

@x
@d mem_bot=0 {smallest index in the |mem| array dumped by \.{INITEX};
  must not be less than |mem_min|}
@d mem_top==30000 {largest index in the |mem| array dumped by \.{INITEX};
  must be substantially larger than |mem_bot|
  and not greater than |mem_max|}
@d font_base=0 {smallest internal font number; must not be less
  than |min_quarterword|}
@d hash_size=2100 {maximum number of control sequences; it should be at most
  about |(mem_max-mem_min)/10|}
@d hash_prime=1777 {a prime number equal to about 85\pct! of |hash_size|}
@d hyph_size=307 {another prime; the number of \.{\\hyphenation} exceptions}
@y
@d hash_size=15000 {maximum number of control sequences; it should be at most
  about |(mem_max-mem_min)/10|; see also |font_max|}
@d hash_prime=8501 {a prime number equal to about 85\pct! of |hash_size|}
@d hyph_prime=607 {another prime for hashing \.{\\hyphenation} exceptions;
                if you change this, you should also change |iinf_hyphen_size|.}
@z

@x
@d incr(#) == #:=#+1 {increase a variable by unity}
@d decr(#) == #:=#-1 {decrease a variable by unity}
@y
@z

@x
@ Characters of text that have been converted to \TeX's internal form
are said to be of type |ASCII_code|, which is a subrange of the integers.
@y
@ Characters of text that have been converted to \TeX's internal form
are said to be of type |ASCII_code|, which is a subrange of the integers.

In |buffer|, |str_pool|, and |trick_buf|, a japanese char (kanji) is
represented by two bytes: |firstbyte+EXTCHARBIT| and |secondbyte|,
where |firstbyte| and |secondbyte| is the JIS-code of the japanese char.
Furthermore, the internal representation of an eighbit char (an ascii char
with eighth bit on) is different from that of \TeX, that is, it is represented
by two bytes: |EXTCHARBIT| and |thebyte-128|. The reason for this complication
is to save memory needed for |str_pool|.

@d EXTCHARBIT = 128
@d is_ext_char(#) == ((#)>=EXTCHARBIT)
@d is_ext_eightbit(#) == ((#)=EXTCHARBIT)
@d ext_eightbit == EXTCHARBIT
@d is_eightbit(#) == ((#)>=128)
@d make_eightbit(#) == ((#)+128)
@d de_eightbit(#) == ((#)-128)
@d is_ext_kanji(#) == ((#)>EXTCHARBIT)
@d make_ext_kanji(#) == ((#)+EXTCHARBIT)
@d de_ext_kanji(#) == ((#)-EXTCHARBIT)

@d repos_char(#) == begin
  if (#>start) and (is_ext_char(buffer[#-1])) then decr(#);
  end
@d backward_onechar(#) == begin decr(#); repos_char(#) end
@z

@x
@d text_char == char {the data type of characters in text files}
@y
@d text_char == ASCII_code {the data type of characters in text files}
@z

@x
for i:=0 to @'37 do xchr[i]:=' ';
for i:=@'177 to @'377 do xchr[i]:=' ';
@y
@z

@x
for i:=@'200 to @'377 do xord[xchr[i]]:=i;
for i:=0 to @'176 do xord[xchr[i]]:=i;
@y
{The idea for this dynamic translation comes from the patch by
 Libor Skarvada \.{<libor@@informatics.muni.cz>}
 and Petr Sojka \.{<sojka@@informatics.muni.cz>}. I didn't use any of the
 actual code, though, preferring a more general approach.}

{This updates the |xchr|, |xord|, and |xprn| arrays from the provided
 |translate_filename|.  See the function definition in \.{texmfmp.c} for
 more comments.}
{if translate_filename then read_tcx_file;}
setup_char_set;
@z

@x
@!name_of_file:packed array[1..file_name_size] of char;@;@/
  {on some systems this may be a \&{record} variable}
@y
@!name_of_file:^text_char;
@z

@x
@ The \ph\ compiler with which the present version of \TeX\ was prepared has
extended the rules of \PASCAL\ in a very convenient way. To open file~|f|,
we can write
$$\vbox{\halign{#\hfil\qquad&#\hfil\cr
|reset(f,@t\\{name}@>,'/O')|&for input;\cr
|rewrite(f,@t\\{name}@>,'/O')|&for output.\cr}}$$
The `\\{name}' parameter, which is of type `{\bf packed array
$[\langle\\{any}\rangle]$ of \\{char}}', stands for the name of
the external file that is being opened for input or output.
Blank spaces that might appear in \\{name} are ignored.

The `\.{/O}' parameter tells the operating system not to issue its own
error messages if something goes wrong. If a file of the specified name
cannot be found, or if such a file cannot be opened for some other reason
(e.g., someone may already be trying to write the same file), we will have
|@!erstat(f)<>0| after an unsuccessful |reset| or |rewrite|.  This allows
\TeX\ to undertake appropriate corrective action.
@:PASCAL H}{\ph@>
@^system dependencies@>

\TeX's file-opening procedures return |false| if no file identified by
|name_of_file| could be opened.

@d reset_OK(#)==erstat(#)=0
@d rewrite_OK(#)==erstat(#)=0

@p function a_open_in(var f:alpha_file):boolean;
  {open a text file for input}
begin reset(f,name_of_file,'/O'); a_open_in:=reset_OK(f);
end;
@#
function a_open_out(var f:alpha_file):boolean;
  {open a text file for output}
begin rewrite(f,name_of_file,'/O'); a_open_out:=rewrite_OK(f);
end;
@#
function b_open_in(var f:byte_file):boolean;
  {open a binary file for input}
begin reset(f,name_of_file,'/O'); b_open_in:=reset_OK(f);
end;
@#
function b_open_out(var f:byte_file):boolean;
  {open a binary file for output}
begin rewrite(f,name_of_file,'/O'); b_open_out:=rewrite_OK(f);
end;
@#
function w_open_in(var f:word_file):boolean;
  {open a word file for input}
begin reset(f,name_of_file,'/O'); w_open_in:=reset_OK(f);
end;
@#
function w_open_out(var f:word_file):boolean;
  {open a word file for output}
begin rewrite(f,name_of_file,'/O'); w_open_out:=rewrite_OK(f);
end;
@y
@ All of the file opening functions are defined in C.
@z

@x
@ Files can be closed with the \ph\ routine `|close(f)|', which
@:PASCAL H}{\ph@>
@^system dependencies@>
should be used when all input or output with respect to |f| has been completed.
This makes |f| available to be opened again, if desired; and if |f| was used for
output, the |close| operation makes the corresponding external file appear
on the user's area, ready to be read.

These procedures should not generate error messages if a file is
being closed before it has been successfully opened.

@p procedure a_close(var f:alpha_file); {close a text file}
begin close(f);
end;
@#
procedure b_close(var f:byte_file); {close a binary file}
begin close(f);
end;
@#
procedure w_close(var f:word_file); {close a word file}
begin close(f);
end;
@y
@ And all the file closing routines as well.
@z

@x
@!buffer:array[0..buf_size] of ASCII_code; {lines of characters being read}
@y
@!buffer:^ASCII_code; {lines of characters being read}
@z

@x
@p function input_ln(var f:alpha_file;@!bypass_eoln:boolean):boolean;
  {inputs the next line or returns |false|}
var last_nonblank:0..buf_size; {|last| with trailing blanks removed}
begin if bypass_eoln then if not eof(f) then get(f);
  {input the first character of the line into |f^|}
last:=first; {cf.\ Matthew 19\thinspace:\thinspace30}
if eof(f) then input_ln:=false
else  begin last_nonblank:=first;
  while not eoln(f) do
    begin if last>=max_buf_stack then
      begin max_buf_stack:=last+1;
      if max_buf_stack=buf_size then
        @<Report overflow of the input buffer, and abort@>;
      end;
    buffer[last]:=xord[f^]; get(f); incr(last);
    if buffer[last-1]<>" " then last_nonblank:=last;
    end;
  last:=last_nonblank; input_ln:=true;
  end;
end;
@y
We define |input_ln| in C, for efficiency. Nevertheless we quote the module
`Report overflow of the input buffer, and abort' here in order to make
\.{WEAVE} happy, since part of that module is needed by e-TeX.

@p @{ @<Report overflow of the input buffer, and abort@> @}
@z

@x
@<Glob...@>=
@!term_in:alpha_file; {the terminal as an input file}
@!term_out:alpha_file; {the terminal as an output file}
@y
@d term_in==stdin {the terminal as an input file}
@d term_out==stdout {the terminal as an output file}

@<Glob...@>=
@!init
@!ini_version:boolean; {are we \.{INITEX}?}
@!dump_option:boolean; {was the dump name option used?}
@!dump_line:boolean; {was a \.{\%\AM format} line seen?}
tini@/
@#
@!dump_name:const_cstring; {format name for terminal display}
@#
@!bound_default:integer; {temporary for setup}
@!bound_name:const_cstring; {temporary for setup}
@#
@!mem_bot:integer;{smallest index in the |mem| array dumped by \.{INITEX};
  must not be less than |mem_min|}
@!main_memory:integer; {total memory words allocated in initex}
@!extra_mem_bot:integer; {|mem_min:=mem_bot-extra_mem_bot| except in \.{INITEX}}
@!mem_min:integer; {smallest index in \TeX's internal |mem| array;
  must be |min_halfword| or more;
  must be equal to |mem_bot| in \.{INITEX}, otherwise |<=mem_bot|}
@!mem_top:integer; {largest index in the |mem| array dumped by \.{INITEX};
  must be substantially larger than |mem_bot|,
  equal to |mem_max| in \.{INITEX}, else not greater than |mem_max|}
@!extra_mem_top:integer; {|mem_max:=mem_top+extra_mem_top| except in \.{INITEX}}
@!mem_max:integer; {greatest index in \TeX's internal |mem| array;
  must be strictly less than |max_halfword|;
  must be equal to |mem_top| in \.{INITEX}, otherwise |>=mem_top|}
@!error_line:integer; {width of context lines on terminal error messages}
@!half_error_line:integer; {width of first lines of contexts in terminal
  error messages; should be between 30 and |error_line-15|}
@!max_print_line:integer;
  {width of longest text lines output; should be at least 60}
@!trick_line:integer; {JTeX: for trick}
@!max_strings:integer; {maximum number of strings; must not exceed |max_halfword|}
@!strings_free:integer; {strings available after format loaded}
@!string_vacancies:integer; {the minimum number of characters that should be
  available for the user's control sequences and font names,
  after \TeX's own error messages are stored}
@!pool_size:integer; {maximum number of characters in strings, including all
  error messages and help texts, and the names of all fonts and
  control sequences; must exceed |string_vacancies| by the total
  length of \TeX's own strings, which is currently about 23000}
@!pool_free:integer;{pool space free after format loaded}
@!font_mem_size:integer; {number of words of |font_info| for all fonts}
@!font_max:integer; {maximum internal font number; ok to exceed |max_quarterword|
  and must be at most |font_base|+|max_font_max|}
@!font_k:integer; {loop variable for initialization}
@!hyph_size:integer; {maximun number of hyphen exceptions}
@!trie_size:integer; {space for hyphenation patterns; should be larger for
  \.{INITEX} than it is in production versions of \TeX.  50000 is
  needed for English, German, and Portuguese.}
@!buf_size:integer; {maximum number of characters simultaneously present in
  current lines of open files and in control sequences between
  \.{\\csname} and \.{\\endcsname}; must not exceed |max_halfword|}
@!stack_size:integer; {maximum number of simultaneous input sources}
@!max_in_open:integer; {maximum number of input files and error insertions that
  can be going on simultaneously}
@!param_size:integer; {maximum number of simultaneous macro parameters}
@!nest_size:integer; {maximum number of semantic levels simultaneously active}
@!save_size:integer; {space for saving values outside of current group; must be
  at most |max_halfword|}
@!dvi_buf_size:integer; {size of the output buffer; must be a multiple of 8}
@!expand_depth:integer; {limits recursive calls to the |expand| procedure}
@!parse_first_line_p:cinttype; {parse the first line for options}
@!file_line_error_style_p:cinttype; {format messages as file:line:error}
@!eight_bit_p:cinttype; {make all characters printable by default}
@!halt_on_error_p:cinttype; {stop at first error}
@!quoted_filename:boolean; {current filename is quoted}
{Variables for source specials}
@!src_specials_p : boolean;{Whether |src_specials| are enabled at all}
@!insert_src_special_auto : boolean;
@!insert_src_special_every_par : boolean;
@!insert_src_special_every_parend : boolean;
@!insert_src_special_every_cr : boolean;
@!insert_src_special_every_math : boolean;
@!insert_src_special_every_hbox : boolean;
@!insert_src_special_every_vbox : boolean;
@!insert_src_special_every_display : boolean;
@z

@x
@ Here is how to open the terminal files
in \ph. The `\.{/I}' switch suppresses the first |get|.
@:PASCAL H}{\ph@>
@^system dependencies@>

@d t_open_in==reset(term_in,'TTY:','/O/I') {open the terminal for text input}
@d t_open_out==rewrite(term_out,'TTY:','/O') {open the terminal for text output}
@y
@ Here is how to open the terminal files.  |t_open_out| does nothing.
|t_open_in|, on the other hand, does the work of ``rescanning,'' or getting
any command line arguments the user has provided.  It's defined in C.

@d t_open_out == {output already open for text output}
@z

@x
these operations can be specified in \ph:
@:PASCAL H}{\ph@>
@^system dependencies@>

@d update_terminal == break(term_out) {empty the terminal output buffer}
@d clear_terminal == break_in(term_in,true) {clear the terminal input buffer}
@y
these operations can be specified with {\mc UNIX}.  |update_terminal|
does an |fflush|. |clear_terminal| is redefined
to do nothing, since the user should control the terminal.
@^system dependencies@>

@d update_terminal == fflush (term_out)
@d clear_terminal == do_nothing
@z

@x
@<Report overflow of the input buffer, and abort@>=
if format_ident=0 then
  begin write_ln(term_out,'Buffer size exceeded!'); goto final_end;
@.Buffer size exceeded@>
  end
else begin cur_input.loc_field:=first; cur_input.limit_field:=last-1;
@y
Routine is implemented in C; part of module is, however, needed for e-TeX.

@<Report overflow of the input buffer, and abort@>=
  begin cur_input.loc_field:=first; cur_input.limit_field:=last-1;
@z

@x
@ The following program does the required initialization
without retrieving a possible command line.
It should be clear how to modify this routine to deal with command lines,
if the system permits them.
@^system dependencies@>

@p function init_terminal:boolean; {gets the terminal input started}
label exit;
begin t_open_in;
@y
@ The following program does the required initialization.
Iff anything has been specified on the command line, then |t_open_in|
will return with |last > first|.
@^system dependencies@>

@p function init_terminal:boolean; {gets the terminal input started}
label exit;
begin t_open_in;
if last > first then
  begin loc := first;
  while (loc < last) and (buffer[loc]=' ') do incr(loc);
  if loc < last then
    begin init_terminal := true; goto exit;
    end;
  end;
@z

@x
    write(term_out,'! End of file on the terminal... why?');
@y
    write_ln(term_out,'! End of file on the terminal... why?');
@z

@x
@!pool_pointer = 0..pool_size; {for variables that point into |str_pool|}
@!str_number = 0..max_strings; {for variables that point into |str_start|}
@y
@!pool_pointer = integer; {for variables that point into |str_pool|}
@!str_number = 0..ssup_max_strings; {for variables that point into |str_start|}
@z

@x
@!str_pool:packed array[pool_pointer] of packed_ASCII_code; {the characters}
@!str_start : array[str_number] of pool_pointer; {the starting pointers}
@y
@!str_pool: ^packed_ASCII_code; {the characters}
@!str_start : ^pool_pointer; {the starting pointers}
@z

@x
@p @!init function get_strings_started:boolean; {initializes the string pool,
@y
@p @t\4@>@<Declare additional routines for string recycling@>@/

@!init function get_strings_started:boolean; {initializes the string pool,
@z

@x
would like string @'32 to be the single character @'32 instead of the
@y
would like string @'32 to be printed as the single character @'32
instead of the
@z

@x
@<Character |k| cannot be printed@>=
  (k<" ")or(k>"~")
@y
@<Character |k| cannot be printed@>=
   not is_printable[k]
@z

@x
@ @d bad_pool(#)==begin wake_up_terminal; write_ln(term_out,#);
  a_close(pool_file); get_strings_started:=false; return;
  end
@<Read the other strings...@>=
name_of_file:=pool_name; {we needn't set |name_length|}
if a_open_in(pool_file) then
  begin c:=false;
  repeat @<Read one string, but return |false| if the
    string memory space is getting too tight for comfort@>;
  until c;
  a_close(pool_file); get_strings_started:=true;
  end
else  bad_pool('! I can''t read TEX.POOL.')
@.I can't read TEX.POOL@>

@ @<Read one string...@>=
begin if eof(pool_file) then bad_pool('! TEX.POOL has no check sum.');
@.TEX.POOL has no check sum@>
read(pool_file,m,n); {read two digits of string length}
if m='*' then @<Check the pool check sum@>
else  begin if (xord[m]<"0")or(xord[m]>"9")or@|
      (xord[n]<"0")or(xord[n]>"9") then
    bad_pool('! TEX.POOL line doesn''t begin with two digits.');
@.TEX.POOL line doesn't...@>
  l:=xord[m]*10+xord[n]-"0"*11; {compute the length}
  if pool_ptr+l+string_vacancies>pool_size then
    bad_pool('! You have to increase POOLSIZE.');
@.You have to increase POOLSIZE@>
  for k:=1 to l do
    begin if eoln(pool_file) then m:=' '@+else read(pool_file,m);
    append_char(xord[m]);
    end;
  read_ln(pool_file); g:=make_string;
  end;
end

@ The \.{WEB} operation \.{@@\$} denotes the value that should be at the
end of this \.{TEX.POOL} file; any other value means that the wrong pool
file has been loaded.
@^check sum@>

@<Check the pool check sum@>=
begin a:=0; k:=1;
loop@+  begin if (xord[n]<"0")or(xord[n]>"9") then
  bad_pool('! TEX.POOL check sum doesn''t have nine digits.');
@.TEX.POOL check sum...@>
  a:=10*a+xord[n]-"0";
  if k=9 then goto done;
  incr(k); read(pool_file,n);
  end;
done: if a<>@$ then bad_pool('! TEX.POOL doesn''t match; TANGLE me again.');
@.TEX.POOL doesn't match@>
c:=true;
end
@y
@ @<Read the other strings...@>=
  g := loadpoolstrings((pool_size-string_vacancies));
  if g=0 then begin
     wake_up_terminal; write_ln(term_out,'! You have to increase POOLSIZE.');
     get_strings_started:=false;
     return;
  end;
  get_strings_started:=true;

@ Empty module

@ Empty module
@z

@x
@!trick_buf:array[0..error_line] of ASCII_code; {circular buffer for
  pseudoprinting}
@y
@!trick_buf:array[0..ssup_trick_line] of ASCII_code; {circular buffer for
  pseudoprinting}
@!tally_disp: integer;
@!first_count_disp: integer;
@z

@x
@ @<Initialize the output routines@>=
selector:=term_only; tally:=0; term_offset:=0; file_offset:=0;
@y
@ @<Initialize the output routines@>=
selector:=term_only; tally:=0; term_offset:=0; file_offset:=0;
tally_disp:=0;
@z

@x
procedure print_char(@!s:ASCII_code); {prints a single character}
label exit;
begin if @<Character |s| is the current new-line character@> then
 if selector<pseudo then
  begin print_ln; return;
  end;
case selector of
term_and_log: begin wterm(xchr[s]); wlog(xchr[s]);
  incr(term_offset); incr(file_offset);
  if term_offset=max_print_line then
    begin wterm_cr; term_offset:=0;
    end;
  if file_offset=max_print_line then
    begin wlog_cr; file_offset:=0;
    end;
  end;
log_only: begin wlog(xchr[s]); incr(file_offset);
  if file_offset=max_print_line then print_ln;
  end;
term_only: begin wterm(xchr[s]); incr(term_offset);
  if term_offset=max_print_line then print_ln;
  end;
no_print: do_nothing;
pseudo: if tally<trick_count then trick_buf[tally mod error_line]:=s;
new_string: begin if pool_ptr<pool_size then append_char(s);
  end; {we drop characters if the string space is full}
othercases write(write_file[selector],xchr[s])
endcases;@/
incr(tally);
exit:end;
@y
@<Declare procedures used by |print_char|@>
procedure print_char(@!s:ASCII_code); {prints a single character}
label exit;
var is_newline:boolean;
begin
case selector of
term_and_log: begin
  if print_char_term(s) then do_nothing;
  if print_char_log(s) then return;
  end;
log_only: if print_char_log(s) then return;
term_only: if print_char_term(s) then return;
no_print: do_nothing;
pseudo: if tally_disp<trick_count then @<Store char in |trick_buf|@>;
new_string: begin if pool_ptr<pool_size then append_char(s);
  end; {we drop characters if the string space is full}
othercases @<Print char to |write_file|@>
endcases;@/
incr(tally);
exit:end;
@z

@x
  else begin if selector>pseudo then
      begin print_char(s); return; {internal strings are not expanded}
      end;
@y
  else begin if selector>pseudo then
      begin if (selector=new_string) and is_eightbit(s) then
          begin print_char(ext_eightbit); print_char(de_eightbit(s)) end
        else print_char(s);
        return; {internal strings are not expanded}
      end;
@z

@x
else begin j:=str_start[s];
  while j<str_start[s+1] do
    begin print(so(str_pool[j])); incr(j);
    end;
  end;
@y
else begin j:=str_start[s];
  @<Print chars in |str_pool| in printable form@>;
  end;
@z

@x
wterm(banner);
@y
if src_specials_p or file_line_error_style_p or parse_first_line_p then
  wterm(banner_k)
else
  wterm(banner);
@z

@x
if format_ident=0 then wterm_ln(' (no format preloaded)')
else  begin slow_print(format_ident); print_ln;
  end;
@y
wterm(version_string);
if format_ident=0 then wterm_ln(' (preloaded format=',dump_name,')')
else  begin slow_print(format_ident); print_ln;
  end;
if shellenabledp then begin
  wterm(' ');
  if restrictedshell then begin
    wterm('restricted ');
  end;
  wterm_ln('\write18 enabled.');
end;
if src_specials_p then begin
  wterm_ln(' Source specials enabled.')
end;
if translate_filename then begin
  wterm(' (');
  fputs(translate_filename, stdout);
  wterm_ln(')');
end;
@z

@x
@d error_stop_mode=3 {stops at every opportunity to interact}
@y
@d error_stop_mode=3 {stops at every opportunity to interact}
@d unspecified_mode=4 {extra value for command-line switch}
@z

@x
  print_nl("! "); print(#);
@y
  if (file_line_error_style_p and not terminal_input) then
  begin
    print_nl ("");
    print (full_source_filename_stack[in_open]);
    print (":"); print_int (line); print (": ");
    print (#);
  end
  else begin print_nl("! "); print(#) end;
@z

@x
@!interaction:batch_mode..error_stop_mode; {current level of interaction}
@y
@!interaction:batch_mode..error_stop_mode; {current level of interaction}
@!interaction_option:batch_mode..unspecified_mode; {set from command line}
@z

@x
@ @<Set init...@>=interaction:=error_stop_mode;
@y
@ @<Set init...@>=if interaction_option=unspecified_mode then
  interaction:=error_stop_mode
else
  interaction:=interaction_option;
@z

@x
@<Error hand...@>=
procedure jump_out;
begin goto end_of_TEX;
end;
@y
@d do_final_end==begin
   update_terminal;
   ready_already:=0;
   if (history <> spotless) and (history <> warning_issued) then
       uexit(1)
   else
       uexit(0);
   end

@<Error hand...@>=
noreturn procedure jump_out;
begin
close_files_and_terminate;
do_final_end;
end;
@z

@x
print_char("."); show_context;
@y
if file_line_error_style_p then interaction:=scroll_mode
else begin print_char("."); show_context end;
if (halt_on_error_p) then begin
  history:=fatal_error_stop; jump_out;
end;
@z

@x
line ready to be edited. But such an extension requires some system
wizardry, so the present implementation simply types out the name of the
file that should be
edited and the relevant line number.
@^system dependencies@>

There is a secret `\.D' option available when the debugging routines haven't
been commented~out.
@^debugging@>
@y
line ready to be edited.
We do this by calling the external procedure |call_edit| with a pointer to
the filename, its length, and the line number.
However, here we just set up the variables that will be used as arguments,
since we don't want to do the switch-to-editor until after TeX has closed
its files.
@^system dependencies@>

There is a secret `\.D' option available when the debugging routines haven't
been commented~out.
@^debugging@>
@d edit_file==input_stack[base_ptr]
@z

@x
"E": if base_ptr>0 then
  begin print_nl("You want to edit file ");
@.You want to edit file x@>
  slow_print(input_stack[base_ptr].name_field);
  print(" at line "); print_int(line);
  interaction:=scroll_mode; jump_out;
@y
"E": if base_ptr>0 then
    begin edit_name_start:=str_start[edit_file.name_field];
    edit_name_length:=str_start[edit_file.name_field+1] -
                      str_start[edit_file.name_field];
    edit_line:=line;
    jump_out;
@z

@x
procedure fatal_error(@!s:str_number); {prints |s|, and that's it}
@y
noreturn procedure fatal_error(@!s:str_number); {prints |s|, and that's it}
@z

@x
procedure overflow(@!s:str_number;@!n:integer); {stop due to finiteness}
@y
noreturn procedure overflow(@!s:str_number;@!n:integer); {stop due to finiteness}
@z

@x
procedure confusion(@!s:str_number);
@y
noreturn procedure confusion(@!s:str_number);
@z

@x
|remainder|, holds the remainder after a division.

@<Glob...@>=
@y
|remainder|, holds the remainder after a division.

@d remainder==tex_remainder

@<Glob...@>=
@z

@x
@!glue_ratio=real; {one-word representation of a glue expansion factor}
@y
@z

@x
@d min_halfword==0 {smallest allowable value in a |halfword|}
@d max_halfword==65535 {largest allowable value in a |halfword|}
@y
@d min_halfword==-@"FFFFFFF {smallest allowable value in a |halfword|}
@d max_halfword==@"FFFFFFF {largest allowable value in a |halfword|}
@z

@x
if (mem_min<min_halfword)or(mem_max>=max_halfword)or@|
  (mem_bot-mem_min>max_halfword+1) then bad:=14;
@y
if (mem_bot-sup_main_memory<min_halfword)or@|
  (mem_top+sup_main_memory>=max_halfword) then bad:=14;
@z

@x
if (font_base<min_quarterword)or(font_max>max_quarterword) then bad:=15;
if font_max>font_base+256 then bad:=16;
@y
if (max_font_max<min_halfword)or(max_font_max>max_halfword) then bad:=15;
if font_max>font_base+max_font_max then bad:=16;
@z

@x
macros are simplified in the obvious way when |min_quarterword=0|.
@^inner loop@>@^system dependencies@>

@d qi(#)==#+min_quarterword
  {to put an |eight_bits| item into a quarterword}
@d qo(#)==#-min_quarterword
  {to take an |eight_bits| item out of a quarterword}
@d hi(#)==#+min_halfword
  {to put a sixteen-bit item into a halfword}
@d ho(#)==#-min_halfword
  {to take a sixteen-bit item from a halfword}
@y
macros are simplified in the obvious way when |min_quarterword=0|.
So they have been simplified here in the obvious way.
@^inner loop@>@^system dependencies@>

The \.{WEB} source for \TeX\ defines |hi(#)==#+min_halfword| which can be
simplified when |min_halfword=0|.  The Web2C implemetation of \TeX\ can use
|hi(#)==#| together with |min_halfword<0| as long as |max_halfword| is
sufficiently large.

@d qi(#)==# {to put an |eight_bits| item into a quarterword}
@d qo(#)==# {to take an |eight_bits| item from a quarterword}
@d hi(#)==# {to put a sixteen-bit item into a halfword}
@d ho(#)==# {to take a sixteen-bit item from a halfword}
@z

@x
@!quarterword = min_quarterword..max_quarterword; {1/4 of a word}
@!halfword=min_halfword..max_halfword; {1/2 of a word}
@!two_choices = 1..2; {used when there are two variants in a record}
@!four_choices = 1..4; {used when there are four variants in a record}
@!two_halves = packed record@;@/
  @!rh:halfword;
  case two_choices of
  1: (@!lh:halfword);
  2: (@!b0:quarterword; @!b1:quarterword);
  end;
@!four_quarters = packed record@;@/
  @!b0:quarterword;
  @!b1:quarterword;
  @!b2:quarterword;
  @!b3:quarterword;
  end;
@!memory_word = record@;@/
  case four_choices of
  1: (@!int:integer);
  2: (@!gr:glue_ratio);
  3: (@!hh:two_halves);
  4: (@!qqqq:four_quarters);
  end;
@y
@!quarterword = min_quarterword..max_quarterword;
@!halfword = min_halfword..max_halfword;
@!two_choices = 1..2; {used when there are two variants in a record}
@!four_choices = 1..4; {used when there are four variants in a record}
@=#include "texmfmem.h";@>
@z

@x
@!mem : array[mem_min..mem_max] of memory_word; {the big dynamic storage area}
@y
@!yzmem : ^memory_word; {the big dynamic storage area}
@!zmem : ^memory_word; {the big dynamic storage area}
@z

@x
if r>p+1 then @<Allocate from the top of node |p| and |goto found|@>;
@y
if r>intcast(p+1) then @<Allocate from the top of node |p| and |goto found|@>;
@z

@x
@p function new_ligature(@!f,@!c:quarterword; @!q:pointer):pointer;
@y
@p function new_ligature(@!f:internal_font_number; @!c:quarterword;
                         @!q:pointer):pointer;
@z

@x
@ In fact, there are still more types coming. When we get to math formula
processing we will see that a |style_node| has |type=14|; and a number
of larger type codes will also be defined, for use in math mode only.
@y
@ In fact, there are still more types coming. When we get to math formula
processing we will see that a |style_node| has |type=14|; and a number
of larger type codes will also be defined, for use in math mode only.
So this is a good point for inserting definitios of new kinds of ref-type
box.

@p @<Define additional ref-type box@>
@z

@x
are debugging.)
@y
are debugging.)

@d free==free_arr
@z

@x
@!debug @!free: packed array [mem_min..mem_max] of boolean; {free cells}
@t\hskip10pt@>@!was_free: packed array [mem_min..mem_max] of boolean;
@y
 {The debug memory arrays have not been mallocated yet.}
@!debug @!free: packed array [0..9] of boolean; {free cells}
@t\hskip10pt@>@!was_free: packed array [0..9] of boolean;
@z

@x
var n:integer; {for replacement counts}
begin while p>mem_min do
  begin if is_char_node(p) then
    begin if p<=mem_end then
      begin if font(p)<>font_in_short_display then
        begin if (font(p)<font_base)or(font(p)>font_max) then
          print_char("*")
@.*\relax@>
        else @<Print the font identifier for |font(p)|@>;
        print_char(" "); font_in_short_display:=font(p);
        end;
      print_ASCII(qo(character(p)));
      end;
    end
  else @<Print a short indication of the contents of node |p|@>;
  p:=link(p);
  end;
end;
@y
var n:integer; {for replacement counts}
jfont_index:s_f_range0; {to hold return value of |j_font_p|}
begin while p>mem_min do
  begin if is_char_node(p) then
    begin if p<=mem_end then
     begin
      jfont_index:=j_font_p(font(p));
      if (jfont_index<>0)
        then print_j_char(jfont_index,qo(character(p)))
      else
      begin
      if font(p)<>font_in_short_display then
        begin if (font(p)>font_max) then
          print_char("*")
@.*\relax@>
        else @<Print the font identifier for |font(p)|@>;
        print_char(" "); font_in_short_display:=font(p);
        end;
      print_ASCII(qo(character(p)));
      end;
     end
    end
  else begin
    @<Print a short indication of the contents of node |p|@>;
    end;
  p:=link(p);
  end;
end;
@z

@x
begin if p>mem_end then print_esc("CLOBBERED.")
else  begin if (font(p)<font_base)or(font(p)>font_max) then print_char("*")
@.*\relax@>
  else @<Print the font identifier for |font(p)|@>;
  print_char(" "); print_ASCII(qo(character(p)));
  end;
end;
@y
var jfont_index:s_f_range0; {to hold return value of |j_font_p|}
begin if p>mem_end then print_esc("CLOBBERED.")
else  begin if (font(p)>font_max) then print_char("*")
@.*\relax@>
  else @<Print the font identifier for |font(p)|@>;
  print_char(" "); jfont_index:=j_font_p(font(p));
  if (jfont_index<>0) then
     print_j_char(jfont_index,qo(character(p)))
  else print_ASCII(qo(character(p)));
  end;
end;
@z

@x
  if abs(mem[p+glue_offset].int)<@'4000000 then print("?.?")
  else if abs(g)>float_constant(20000) then
@y
  { The Unix |pc| folks removed this restriction with a remark that
    invalid bit patterns were vanishingly improbable, so we follow
    their example without really understanding it.
  |if abs(mem[p+glue_offset].int)<@'4000000 then print('?.?')|
  |else| }
  if fabs(g)>float_constant(20000) then
@z

@x
@p procedure delete_glue_ref(@!p:pointer); {|p| points to a glue specification}
fast_delete_glue_ref(p);
@y
@p procedure delete_glue_ref(@!p:pointer); {|p| points to a glue specification}
fast_delete_glue_ref(p);
@<Destroy additional ref-type box@>
@z

@x
@d add_token_ref(#)==incr(token_ref_count(#)) {new reference to a token list}
@d add_glue_ref(#)==incr(glue_ref_count(#)) {new reference to a glue spec}
@y
@d add_token_ref(#)==incr(token_ref_count(#)) {new reference to a token list}
@d add_glue_ref(#)==incr(glue_ref_count(#)) {new reference to a glue spec}
@d add_df_ref(#)==incr(df_ref_count(#)) {new reference to a df spec}
@z

@x
@d max_char_code=15 {largest catcode for individual characters}
@y
@d jletter=16 {characters regarded as japanese letters}
@d max_char_code=16 {largest catcode for individual characters}
@z

@x
@d char_num=16 {character specified numerically ( \.{\\char} )}
@d math_char_num=17 {explicit math code ( \.{\\mathchar} )}
@d mark=18 {mark definition ( \.{\\mark} )}
@d xray=19 {peek inside of \TeX\ ( \.{\\show}, \.{\\showbox}, etc.~)}
@d make_box=20 {make a box ( \.{\\box}, \.{\\copy}, \.{\\hbox}, etc.~)}
@d hmove=21 {horizontal motion ( \.{\\moveleft}, \.{\\moveright} )}
@d vmove=22 {vertical motion ( \.{\\raise}, \.{\\lower} )}
@d un_hbox=23 {unglue a box ( \.{\\unhbox}, \.{\\unhcopy} )}
@d un_vbox=24 {unglue a box ( \.{\\unvbox}, \.{\\unvcopy} )}
@d remove_item=25 {nullify last item ( \.{\\unpenalty},
  \.{\\unkern}, \.{\\unskip} )}
@d hskip=26 {horizontal glue ( \.{\\hskip}, \.{\\hfil}, etc.~)}
@d vskip=27 {vertical glue ( \.{\\vskip}, \.{\\vfil}, etc.~)}
@d mskip=28 {math glue ( \.{\\mskip} )}
@d kern=29 {fixed space ( \.{\\kern})}
@d mkern=30 {math kern ( \.{\\mkern} )}
@d leader_ship=31 {use a box ( \.{\\shipout}, \.{\\leaders}, etc.~)}
@d halign=32 {horizontal table alignment ( \.{\\halign} )}
@d valign=33 {vertical table alignment ( \.{\\valign} )}
@d no_align=34 {temporary escape from alignment ( \.{\\noalign} )}
@d vrule=35 {vertical rule ( \.{\\vrule} )}
@d hrule=36 {horizontal rule ( \.{\\hrule} )}
@d insert=37 {vlist inserted in box ( \.{\\insert} )}
@d vadjust=38 {vlist inserted in enclosing paragraph ( \.{\\vadjust} )}
@d ignore_spaces=39 {gobble |spacer| tokens ( \.{\\ignorespaces} )}
@d after_assignment=40 {save till assignment is done ( \.{\\afterassignment} )}
@d after_group=41 {save till group is done ( \.{\\aftergroup} )}
@d break_penalty=42 {additional badness ( \.{\\penalty} )}
@d start_par=43 {begin paragraph ( \.{\\indent}, \.{\\noindent} )}
@d ital_corr=44 {italic correction ( \.{\\/} )}
@d accent=45 {attach accent in text ( \.{\\accent} )}
@d math_accent=46 {attach accent in math ( \.{\\mathaccent} )}
@d discretionary=47 {discretionary texts ( \.{\\-}, \.{\\discretionary} )}
@d eq_no=48 {equation number ( \.{\\eqno}, \.{\\leqno} )}
@d left_right=49 {variable delimiter ( \.{\\left}, \.{\\right} )}
@d math_comp=50 {component of formula ( \.{\\mathbin}, etc.~)}
@d limit_switch=51 {diddle limit conventions ( \.{\\displaylimits}, etc.~)}
@d above=52 {generalized fraction ( \.{\\above}, \.{\\atop}, etc.~)}
@d math_style=53 {style specification ( \.{\\displaystyle}, etc.~)}
@d math_choice=54 {choice specification ( \.{\\mathchoice} )}
@d non_script=55 {conditional math glue ( \.{\\nonscript} )}
@d vcenter=56 {vertically center a vbox ( \.{\\vcenter} )}
@d case_shift=57 {force specific case ( \.{\\lowercase}, \.{\\uppercase}~)}
@d message=58 {send to user ( \.{\\message}, \.{\\errmessage} )}
@d extension=59 {extensions to \TeX\ ( \.{\\write}, \.{\\special}, etc.~)}
@d in_stream=60 {files for reading ( \.{\\openin}, \.{\\closein} )}
@d begin_group=61 {begin local grouping ( \.{\\begingroup} )}
@d end_group=62 {end local grouping ( \.{\\endgroup} )}
@d omit=63 {omit alignment template ( \.{\\omit} )}
@d ex_space=64 {explicit space ( \.{\\\ } )}
@d no_boundary=65 {suppress boundary ligatures ( \.{\\noboundary} )}
@d radical=66 {square root and similar signs ( \.{\\radical} )}
@d end_cs_name=67 {end control sequence ( \.{\\endcsname} )}
@d min_internal=68 {the smallest code that can follow \.{\\the}}
@d char_given=68 {character code defined by \.{\\chardef}}
@d math_given=69 {math code defined by \.{\\mathchardef}}
@d last_item=70 {most recent item ( \.{\\lastpenalty},
  \.{\\lastkern}, \.{\\lastskip} )}
@d max_non_prefixed_command=70 {largest command code that can't be \.{\\global}}
@y
@d char_num=17 {character specified numerically ( \.{\\char} )}
@d math_char_num=18 {explicit math code ( \.{\\mathchar} )}
@d mark=19 {mark definition ( \.{\\mark} )}
@d xray=20 {peek inside of \TeX\ ( \.{\\show}, \.{\\showbox}, etc.~)}
@d make_box=21 {make a box ( \.{\\box}, \.{\\copy}, \.{\\hbox}, etc.~)}
@d hmove=22 {horizontal motion ( \.{\\moveleft}, \.{\\moveright} )}
@d vmove=23 {vertical motion ( \.{\\raise}, \.{\\lower} )}
@d un_hbox=24 {unglue a box ( \.{\\unhbox}, \.{\\unhcopy} )}
@d un_vbox=25 {unglue a box ( \.{\\unvbox}, \.{\\unvcopy} )}
@d remove_item=26 {nullify last item ( \.{\\unpenalty},
  \.{\\unkern}, \.{\\unskip} )}
@d hskip=27 {horizontal glue ( \.{\\hskip}, \.{\\hfil}, etc.~)}
@d vskip=28 {vertical glue ( \.{\\vskip}, \.{\\vfil}, etc.~)}
@d mskip=29 {math glue ( \.{\\mskip} )}
@d kern=30 {fixed space ( \.{\\kern})}
@d mkern=31 {math kern ( \.{\\mkern} )}
@d leader_ship=32 {use a box ( \.{\\shipout}, \.{\\leaders}, etc.~)}
@d halign=33 {horizontal table alignment ( \.{\\halign} )}
@d valign=34 {vertical table alignment ( \.{\\valign} )}
@d no_align=35 {temporary escape from alignment ( \.{\\noalign} )}
@d vrule=36 {vertical rule ( \.{\\vrule} )}
@d hrule=37 {horizontal rule ( \.{\\hrule} )}
@d insert=38 {vlist inserted in box ( \.{\\insert} )}
@d vadjust=39 {vlist inserted in enclosing paragraph ( \.{\\vadjust} )}
@d ignore_spaces=40 {gobble |spacer| tokens ( \.{\\ignorespaces} )}
@d after_assignment=41 {save till assignment is done ( \.{\\afterassignment} )}
@d after_group=42 {save till group is done ( \.{\\aftergroup} )}
@d break_penalty=43 {additional badness ( \.{\\penalty} )}
@d start_par=44 {begin paragraph ( \.{\\indent}, \.{\\noindent} )}
@d ital_corr=45 {italic correction ( \.{\\/} )}
@d accent=46 {attach accent in text ( \.{\\accent} )}
@d math_accent=47 {attach accent in math ( \.{\\mathaccent} )}
@d discretionary=48 {discretionary texts ( \.{\\-}, \.{\\discretionary} )}
@d eq_no=49 {equation number ( \.{\\eqno}, \.{\\leqno} )}
@d left_right=50 {variable delimiter ( \.{\\left}, \.{\\right} )}
@d math_comp=51 {component of formula ( \.{\\mathbin}, etc.~)}
@d limit_switch=52 {diddle limit conventions ( \.{\\displaylimits}, etc.~)}
@d above=53 {generalized fraction ( \.{\\above}, \.{\\atop}, etc.~)}
@d math_style=54 {style specification ( \.{\\displaystyle}, etc.~)}
@d math_choice=55 {choice specification ( \.{\\mathchoice} )}
@d non_script=56 {conditional math glue ( \.{\\nonscript} )}
@d vcenter=57 {vertically center a vbox ( \.{\\vcenter} )}
@d case_shift=58 {force specific case ( \.{\\lowercase}, \.{\\uppercase}~)}
@d message=59 {send to user ( \.{\\message}, \.{\\errmessage} )}
@d extension=60 {extensions to \TeX\ ( \.{\\write}, \.{\\special}, etc.~)}
@d in_stream=61 {files for reading ( \.{\\openin}, \.{\\closein} )}
@d begin_group=62 {begin local grouping ( \.{\\begingroup} )}
@d end_group=63 {end local grouping ( \.{\\endgroup} )}
@d omit=64 {omit alignment template ( \.{\\omit} )}
@d ex_space=65 {explicit space ( \.{\\\ } )}
@d no_boundary=66 {suppress boundary ligatures ( \.{\\noboundary} )}
@d radical=67 {square root and similar signs ( \.{\\radical} )}
@d end_cs_name=68 {end control sequence ( \.{\\endcsname} )}
@d min_internal=68 {the smallest code that can follow \.{\\the}}
@d char_given=69 {character code defined by \.{\\chardef}}
@d math_given=70 {math code defined by \.{\\mathchardef}}
@d last_item=71 {most recent item ( \.{\\lastpenalty},
  \.{\\lastkern}, \.{\\lastskip} )}
@d max_non_prefixed_command=71 {largest command code that can't be \.{\\global}}
@z

@x
@d toks_register=71 {token list register ( \.{\\toks} )}
@d assign_toks=72 {special token list ( \.{\\output}, \.{\\everypar}, etc.~)}
@d assign_int=73 {user-defined integer ( \.{\\tolerance}, \.{\\day}, etc.~)}
@d assign_dimen=74 {user-defined length ( \.{\\hsize}, etc.~)}
@d assign_glue=75 {user-defined glue ( \.{\\baselineskip}, etc.~)}
@d assign_mu_glue=76 {user-defined muglue ( \.{\\thinmuskip}, etc.~)}
@d assign_font_dimen=77 {user-defined font dimension ( \.{\\fontdimen} )}
@d assign_font_int=78 {user-defined font integer ( \.{\\hyphenchar},
  \.{\\skewchar} )}
@d set_aux=79 {specify state info ( \.{\\spacefactor}, \.{\\prevdepth} )}
@d set_prev_graf=80 {specify state info ( \.{\\prevgraf} )}
@d set_page_dimen=81 {specify state info ( \.{\\pagegoal}, etc.~)}
@d set_page_int=82 {specify state info ( \.{\\deadcycles},
  \.{\\insertpenalties} )}
@d set_box_dimen=83 {change dimension of box ( \.{\\wd}, \.{\\ht}, \.{\\dp} )}
@d set_shape=84 {specify fancy paragraph shape ( \.{\\parshape} )}
@d def_code=85 {define a character code ( \.{\\catcode}, etc.~)}
@d def_family=86 {declare math fonts ( \.{\\textfont}, etc.~)}
@d set_font=87 {set current font ( font identifiers )}
@d def_font=88 {define a font file ( \.{\\font} )}
@d register=89 {internal register ( \.{\\count}, \.{\\dimen}, etc.~)}
@d max_internal=89 {the largest code that can follow \.{\\the}}
@d advance=90 {advance a register or parameter ( \.{\\advance} )}
@d multiply=91 {multiply a register or parameter ( \.{\\multiply} )}
@d divide=92 {divide a register or parameter ( \.{\\divide} )}
@d prefix=93 {qualify a definition ( \.{\\global}, \.{\\long}, \.{\\outer} )}
@d let=94 {assign a command code ( \.{\\let}, \.{\\futurelet} )}
@d shorthand_def=95 {code definition ( \.{\\chardef}, \.{\\countdef}, etc.~)}
@d read_to_cs=96 {read into a control sequence ( \.{\\read} )}
@d def=97 {macro definition ( \.{\\def}, \.{\\gdef}, \.{\\xdef}, \.{\\edef} )}
@d set_box=98 {set a box ( \.{\\setbox} )}
@d hyph_data=99 {hyphenation data ( \.{\\hyphenation}, \.{\\patterns} )}
@d set_interaction=100 {define level of interaction ( \.{\\batchmode}, etc.~)}
@d max_command=100 {the largest command code seen at |big_switch|}
@y
@d toks_register=72 {token list register ( \.{\\toks} )}
@d assign_toks=73 {special token list ( \.{\\output}, \.{\\everypar}, etc.~)}
@d assign_int=74 {user-defined integer ( \.{\\tolerance}, \.{\\day}, etc.~)}
@d assign_dimen=75 {user-defined length ( \.{\\hsize}, etc.~)}
@d assign_glue=76 {user-defined glue ( \.{\\baselineskip}, etc.~)}
@d assign_mu_glue=77 {user-defined muglue ( \.{\\thinmuskip}, etc.~)}
@d assign_font_dimen=78 {user-defined font dimension ( \.{\\fontdimen} )}
@d assign_font_int=79 {user-defined font integer ( \.{\\hyphenchar},  \.{\\skewchar} )}
@d set_aux=80 {specify state info ( \.{\\spacefactor}, \.{\\prevdepth} )}
@d set_prev_graf=81 {specify state info ( \.{\\prevgraf} )}
@d set_page_dimen=82 {specify state info ( \.{\\pagegoal}, etc.~)}
@d set_page_int=83 {specify state info ( \.{\\deadcycles},  \.{\\insertpenalties} )}
@d set_box_dimen=84 {change dimension of box ( \.{\\wd}, \.{\\ht}, \.{\\dp} )}
@d set_shape=85 {specify fancy paragraph shape ( \.{\\parshape} )}
@d def_code=86 {define a character code ( \.{\\catcode}, etc.~)}
@d def_family=87 {declare math fonts ( \.{\\textfont}, etc.~)}
@d set_font=88 {set current font ( font identifiers )}
@d def_font=89 {define a font file ( \.{\\font} )}
@d def_dfont=90 {define a on-demmand-load font file ( \.{\\delayedfont} )}
@d def_jfont=91 {define japanese font file ( \.{\\jfont} )}
@d register=92 {internal register ( \.{\\count}, \.{\\dimen}, etc.~)}
@d min_refbox=93 {the smallest code that have the refbox type value}
@d demmand_font=93 {load demmanded font and set current font to it ( font identifiers )}
@d set_jfont=94 {set current japanese font ( font identifiers )}
@d max_internal=94 {the largest code that can follow \.{\\the}}
@d max_refbox=94 {the largest code that have the refbox type value}
@d advance=95 {advance a register or parameter ( \.{\\advance} )}
@d multiply=96 {multiply a register or parameter ( \.{\\multiply} )}
@d divide=97 {divide a register or parameter ( \.{\\divide} )}
@d prefix=98 {qualify a definition ( \.{\\global}, \.{\\long}, \.{\\outer} )}
@d let=99 {assign a command code ( \.{\\let}, \.{\\futurelet} )}
@d shorthand_def=100 {code definition ( \.{\\chardef}, \.{\\countdef}, etc.~)}
  {or \.{\\charsubdef}}
@d read_to_cs=101 {read into a control sequence ( \.{\\read} )}
@d def=102 {macro definition ( \.{\\def}, \.{\\gdef}, \.{\\xdef}, \.{\\edef} )}
@d set_box=103 {set a box ( \.{\\setbox} )}
@d hyph_data=104 {hyphenation data ( \.{\\hyphenation}, \.{\\patterns} )}
@d set_interaction=105 {define level of interaction ( \.{\\batchmode}, etc.~)}
@d set_kinsoku_code=106 {set Kinsoku table data}
@d set_burasage=107 {set burasage table data}
@d set_jkern=108 {set jkern table data}
@d set_asciipunct=109
@d faker=110
@d max_command=110 {the largest command code seen at |big_switch|}
@z

@x
@!nest:array[0..nest_size] of list_state_record;
@y
@!nest:^list_state_record;
@z

@x
prev_graf:=0; shown_mode:=0;
@<Start a new current page@>;
@y
prev_graf:=0; shown_mode:=0;
@/{The following piece of code is a copy of module 991:}
page_contents:=empty; page_tail:=page_head; {|link(page_head):=null;|}@/
last_glue:=max_halfword; last_penalty:=0; last_kern:=0;
page_depth:=0; page_max_depth:=0;
@z

@x
    print_int(nest[p].pg_field); print(" line");
    if nest[p].pg_field<>1 then print_char("s");
@y
    print_int(nest[p].pg_field);
    if nest[p].pg_field<>1 then print(" lines")
    else print(" line");
@z

@x
paragraph shape.
@y
paragraph shape.
Additionally region~4 contains the table with ML\TeX's character
substitution definitions.
@z

@x
@d frozen_null_font=frozen_control_sequence+10
@y
@d frozen_special=frozen_control_sequence+10
  {permanent `\.{\\special}'}
@d frozen_null_font=frozen_control_sequence+11
@z

@x
@d undefined_control_sequence=frozen_null_font+257 {dummy location}
@y
@d undefined_control_sequence=frozen_null_font+max_font_max+1 {dummy location}
@z

@x
for k:=active_base to undefined_control_sequence-1 do
  eqtb[k]:=eqtb[undefined_control_sequence];
@y
for k:=active_base to eqtb_top do
  eqtb[k]:=eqtb[undefined_control_sequence];
@z

@x
@d glue_pars=18 {total number of glue parameters}
@y
@d j_interchar_skip_code=18 {glue between japanese characters}
@d j_ascii_kanji_skip_code=19 {glue between ascii string and kanji string}
@d j_math_kanji_skip_code=20 {glue between ascii string and kanji string}
@d j_space_skip_code=21 {glue corresponding to JIS space(!!)}
@d def_j_interchar_skip_code=22 {will disappear in the future version}
@d def_j_ascii_kanji_skip_code=23 {will disappear in the future version}
@d def_j_math_kanji_skip_code=24 {will disappear in the future version}
@d def_j_space_skip_code=25 {will disappear in the future version?}
@d glue_pars=26 {total number of glue parameters}
@z

@x
@d thick_mu_skip==glue_par(thick_mu_skip_code)
@y
@d thick_mu_skip==glue_par(thick_mu_skip_code)
@d j_interchar_skip==glue_par(j_interchar_skip_code)
@d j_ascii_kanji_skip==glue_par(j_ascii_kanji_skip_code)
@d j_math_kanji_skip==glue_par(j_math_kanji_skip_code)
@d j_space_skip==glue_par(j_space_skip_code)
@z

@x
thick_mu_skip_code: print_esc("thickmuskip");
@y
thick_mu_skip_code: print_esc("thickmuskip");
j_interchar_skip_code: print_esc("jintercharskip");
j_ascii_kanji_skip_code: print_esc("jasciikanjiskip");
j_math_kanji_skip_code: print_esc("jmathkanjiskip");
j_space_skip_code: print_esc("jisspaceskip");
def_j_interchar_skip_code: print_esc("@@@@jintercharskip");
def_j_ascii_kanji_skip_code: print_esc("@@@@jasciikanjiskip");
def_j_math_kanji_skip_code: print_esc("@@@@jmathkanjiskip");
def_j_space_skip_code: print_esc("@@@@jisspaceskip");
@z

@x
primitive("thickmuskip",assign_mu_glue,glue_base+thick_mu_skip_code);@/
@!@:thick_mu_skip_}{\.{\\thickmuskip} primitive@>
@y
primitive("thickmuskip",assign_mu_glue,glue_base+thick_mu_skip_code);@/
@!@:thick_mu_skip_}{\.{\\thickmuskip} primitive@>
primitive("jintercharskip",assign_glue,glue_base+j_interchar_skip_code);@/
@!@:j_interchar_skip_}{\.{\\jintercharskip} primitive@>
primitive("jasciikanjiskip",assign_glue,glue_base+j_ascii_kanji_skip_code);@/
@!@:j_ascii_kanji_skip_}{\.{\\jasciikanjiskip} primitive@>
primitive("jmathkanjiskip",assign_glue,glue_base+j_math_kanji_skip_code);@/
@!@:j_math_kanji_skip_}{\.{\\jmathkanjiskip} primitive@>
primitive("jisspaceskip",assign_glue,glue_base+j_space_skip_code);@/
@!@:j_space_skip_}{\.{\\jisspaceskip} primitive@>
primitive("@@@@jintercharskip",assign_glue,glue_base+def_j_interchar_skip_code);@/
@!@:def_j_interchar_skip_}{\.{\\@@@@jintercharskip} primitive@>
primitive("@@@@jasciikanjiskip",assign_glue,glue_base+def_j_ascii_kanji_skip_code);@/
@!@:def_j_ascii_kanji_skip_}{\.{\\@@@@jasciikanjiskip} primitive@>
primitive("@@@@jmathkanjiskip",assign_glue,glue_base+def_j_math_kanji_skip_code);@/
@!@:def_j_math_kanji_skip_}{\.{\\@@@@jmathkanjiskip} primitive@>
primitive("@@@@jisspaceskip",assign_glue,glue_base+def_j_space_skip_code);@/
@!@:def_j_space_skip_}{\.{\\@@@@jisspaceskip} primitive@>
@z

@x
@d int_base=math_code_base+256 {beginning of region 5}
@y
@d char_sub_code_base=math_code_base+256 {table of character substitutions}
@d int_base=char_sub_code_base+256 {beginning of region 5}
@z

@x
  {Note: |math_code(c)| is the true math code plus |min_halfword|}
@y
  {Note: |math_code(c)| is the true math code plus |min_halfword|}
@d char_sub_code(#)==equiv(char_sub_code_base+#)
  {Note: |char_sub_code(c)| is the true substitution info plus |min_halfword|}
@z

@x
@d int_pars=55 {total number of integer parameters}
@y
@d char_sub_def_min_code=55 {smallest value in the charsubdef list}
@d char_sub_def_max_code=56 {largest value in the charsubdef list}
@d tracing_char_sub_def_code=57 {traces changes to a charsubdef def}
@d kanji_terminal_type_code=58 {type code for kanji terminal}
@d kanji_file_type_code=59 {type code for kanji file}
@d jendline_type_code=60
@d int_pars=61 {total number of integer parameters}
@z

@x
@d error_context_lines==int_par(error_context_lines_code)
@y
@d error_context_lines==int_par(error_context_lines_code)
@d char_sub_def_min==int_par(char_sub_def_min_code)
@d char_sub_def_max==int_par(char_sub_def_max_code)
@d tracing_char_sub_def==int_par(tracing_char_sub_def_code)
@d kanji_terminal_type==int_par(kanji_terminal_type_code)
@d kanji_file_type==int_par(kanji_file_type_code)
@d jendline_type==int_par(jendline_type_code)
@z

@x
error_context_lines_code:print_esc("errorcontextlines");
@y
error_context_lines_code:print_esc("errorcontextlines");
char_sub_def_min_code:print_esc("charsubdefmin");
char_sub_def_max_code:print_esc("charsubdefmax");
tracing_char_sub_def_code:print_esc("tracingcharsubdef");
kanji_terminal_type_code:print_esc("kanjiterminaltype");
kanji_file_type_code:print_esc("kanjifiletype");
jendline_type_code:print_esc("jendlinetype");
@z

@x
@!@:error_context_lines_}{\.{\\errorcontextlines} primitive@>
@y
@!@:error_context_lines_}{\.{\\errorcontextlines} primitive@>
if mltex_p then
  begin mltex_enabled_p:=true;  {enable character substitution}
  if false then {remove the if-clause to enable \.{\\charsubdefmin}}
  primitive("charsubdefmin",assign_int,int_base+char_sub_def_min_code);@/
@!@:char_sub_def_min_}{\.{\\charsubdefmin} primitive@>
  primitive("charsubdefmax",assign_int,int_base+char_sub_def_max_code);@/
@!@:char_sub_def_max_}{\.{\\charsubdefmax} primitive@>
  primitive("tracingcharsubdef",assign_int,int_base+tracing_char_sub_def_code);@/
@!@:tracing_char_sub_def_}{\.{\\tracingcharsubdef} primitive@>
  end;
primitive("kanjiterminaltype",assign_int,int_base+kanji_terminal_type_code);@/
@!@:kanji_terminal_type_}{\.{\\kanjiterminaltype} primitive@>
primitive("kanjifiletype",assign_int,int_base+kanji_file_type_code);@/
@!@:kanji_file_type_}{\.{\\kanjifiletype} primitive@>
primitive("jendlinetype",assign_int,int_base+jendline_type_code);@/
@!@:jendline_type_}{\.{\\jendlinetype} primitive@>
@z

@x
for k:=int_base to del_code_base-1 do eqtb[k].int:=0;
@y
for k:=int_base to del_code_base-1 do eqtb[k].int:=0;
char_sub_def_min:=256; char_sub_def_max:=-1;
{allow \.{\\charsubdef} for char 0}@/
{|tracing_char_sub_def:=0| is already done}@/
@z

@x
@ The following procedure, which is called just before \TeX\ initializes its
input and output, establishes the initial values of the date and time.
@^system dependencies@>
Since standard \PASCAL\ cannot provide such information, something special
is needed. The program here simply specifies July 4, 1776, at noon; but
users probably want a better approximation to the truth.

@p procedure fix_date_and_time;
begin time:=12*60; {minutes since midnight}
day:=4; {fourth day of the month}
month:=7; {seventh month of the year}
year:=1776; {Anno Domini}
end;
@y
@ The following procedure, which is called just before \TeX\ initializes its
input and output, establishes the initial values of the date and time.
It calls a macro-defined |date_and_time| routine.  |date_and_time|
in turn is a C macro, which calls |get_date_and_time|, passing
it the addresses of the day, month, etc., so they can be set by the
routine.  |get_date_and_time| also sets up interrupt catching if that
is conditionally compiled in the C code.
@^system dependencies@>

@d fix_date_and_time==date_and_time(time,day,month,year)
@z

@x
else if n<glue_base then @<Show equivalent |n|, in region 1 or 2@>
@y
else if (n<glue_base) or ((n>eqtb_size)and(n<=eqtb_top)) then
  @<Show equivalent |n|, in region 1 or 2@>
@z

@x
@!eqtb:array[active_base..eqtb_size] of memory_word;
@y
@!zeqtb:^memory_word;
@z

@x
@!hash: array[hash_base..undefined_control_sequence-1] of two_halves;
  {the hash table}
@!hash_used:pointer; {allocation pointer for |hash|}
@y
@!hash: ^two_halves; {the hash table}
@!yhash: ^two_halves; {auxiliary pointer for freeing hash}
@!hash_used:pointer; {allocation pointer for |hash|}
@!hash_extra:pointer; {|hash_extra=hash| above |eqtb_size|}
@!hash_top:pointer; {maximum of the hash array}
@!eqtb_top:pointer; {maximum of the |eqtb|}
@!hash_high:pointer; {pointer to next high hash location}
@z

@x
next(hash_base):=0; text(hash_base):=0;
for k:=hash_base+1 to undefined_control_sequence-1 do hash[k]:=hash[hash_base];
@y
@z

@x
hash_used:=frozen_control_sequence; {nothing is used}
@y
hash_used:=frozen_control_sequence; {nothing is used}
hash_high:=0;
@z

@x
@ @<Insert a new control...@>=
begin if text(p)>0 then
  begin repeat if hash_is_full then overflow("hash size",hash_size);
@:TeX capacity exceeded hash size}{\quad hash size@>
  decr(hash_used);
  until text(hash_used)=0; {search for an empty location in |hash|}
  next(p):=hash_used; p:=hash_used;
  end;
@y
@ @<Insert a new control...@>=
begin if text(p)>0 then
  begin if hash_high<hash_extra then
      begin incr(hash_high);
      next(p):=hash_high+eqtb_size; p:=hash_high+eqtb_size;
      end
    else begin
      repeat if hash_is_full then overflow("hash size",hash_size+hash_extra);
@:TeX capacity exceeded hash size}{\quad hash size@>
      decr(hash_used);
      until text(hash_used)=0; {search for an empty location in |hash|}
    next(p):=hash_used; p:=hash_used;
    end;
  end;
@z

@x
else if p>=undefined_control_sequence then print_esc("IMPOSSIBLE.")
@y
else if ((p>=undefined_control_sequence)and(p<=eqtb_size))or(p>eqtb_top) then
  print_esc("IMPOSSIBLE.")
@z

@x
else if (text(p)<0)or(text(p)>=str_ptr) then print_esc("NONEXISTENT.")
@y
else if (text(p)>=str_ptr) then print_esc("NONEXISTENT.")
@z

@x
@!save_stack : array[0..save_size] of memory_word;
@y
@!save_stack : ^memory_word;
@z

@x
box_ref: flush_node_list(equiv_field(w));
othercases do_nothing
@y
box_ref: flush_node_list(equiv_field(w));
@<Cases of |eq_destroy| for additional ref-type box in |equiv_field|@>
othercases do_nothing
@z

@x
Global definitions are done in almost the same way, but there is no need
to save old values, and the new value is associated with |level_one|.
@y
Global definitions are done in almost the same way, but there is no need
to save old values, and the new value is associated with |level_one|.
We also introduce destructive definition |deq_define|.
@z

@x
procedure geq_word_define(@!p:pointer;@!w:integer); {global |eq_word_define|}
begin eqtb[p].int:=w; xeq_level[p]:=level_one;
end;
@y
procedure geq_word_define(@!p:pointer;@!w:integer); {global |eq_word_define|}
begin eqtb[p].int:=w; xeq_level[p]:=level_one;
end;
@#
procedure deq_define(@!p:pointer;@!t:quarterword;@!e:halfword);
begin eq_destroy(eqtb[p]);
eq_type(p):=t; equiv(p):=e;
end;
@z

@x
if p<int_base then
@y
if (p<int_base)or(p>eqtb_size) then
@z

@x
The following definitions take care of these token-oriented constants
and a few others.

@y
The following definitions take care of these token-oriented constants
and a few others.

To represent a japanese character in a token list new token flag is introduced.
The value of this |j_letter-token| is set to $2^{14}$ so that you can accomodate
$2^8f+c$ (where $1\le f\le 33$ and $0\le c\le 255$) into a halfword without
interferring other tokens.  Verify this by the following:
\item{} $2^8m+c$ (where $1\le m\le 14$, $0\le c\le 255$) ranges from 256 to 3839
\item{} $2^{12}+p$ (where $0\le p\le |undefined_control_sequence|$)
ranges from 4096 to $4096+258+|hash_size|+267$
\item{} $2^{14}+2^8f+c$ (where $1\le f\le 33$, $0\le c\le 255$) ranges from 16640
to 25087 (which is less than $2^{16}$)

@d j_letter_token_flag==@"8000000 {amount added to packed jletter ($2^8f+c$)}
@d jchr_cons_end(#)==(#)
@d jchr_cons(#)==(#)*256+jchr_cons_end
@d jchr_subfont(#)==((#) div 256)
@d jchr_char(#)==((#) mod 256)
@z

@x
@ @<Check the ``constant''...@>=
if cs_token_flag+undefined_control_sequence>max_halfword then bad:=21;
@y
@ @<Check the ``constant''...@>=
if cs_token_flag+undefined_control_sequence>=j_letter_token_flag then bad:=21;
if (hash_offset<0)or(hash_offset>hash_base) then bad:=42;
@z

@x
var m,@!c:integer; {pieces of a token}
@!match_chr:ASCII_code; {character used in a `|match|'}
@!n:ASCII_code; {the highest parameter number, as an ASCII digit}
@y
var m,@!c:integer; {pieces of a token}
@!match_chr:ASCII_code; {character used in a `|match|'}
@!n:ASCII_code; {the highest parameter number, as an ASCII digit}
@!ku_ten:integer; {to hold ku*256+ten}
@z

@x
begin match_chr:="#"; n:="0"; tally:=0;
while (p<>null) and (tally<l) do
  begin if p=q then @<Do magic computation@>;
@y
begin match_chr:="#"; n:="0"; tally:=0; tally_disp:=0;
while (p<>null) and (tally<l) do
  begin if p=q then @<Do magic computation@>;
@z

@x
@ @<Display token |p|...@>=
if (p<hi_mem_min) or (p>mem_end) then
  begin print_esc("CLOBBERED."); return;
@.CLOBBERED@>
  end;
if info(p)>=cs_token_flag then print_cs(info(p)-cs_token_flag)
@y
@ @<Display token |p|...@>=
if (p<hi_mem_min) or (p>mem_end) then
  begin print_esc("CLOBBERED."); return;
@.CLOBBERED@>
  end;
if info(p)>=j_letter_token_flag then
  begin m:=jchr_subfont(info(p) mod j_letter_token_flag);
        c:=jchr_char(info(p) mod j_letter_token_flag);
        @<Display japanese letter $(|m|,|c|)$@>; end
else if info(p)>=cs_token_flag then print_cs(info(p)-cs_token_flag)
@z

@x
other_char: chr_cmd("the character ");
@y
other_char: chr_cmd("the character ");
jletter: begin print("japanese letter ");
  print_j_char(jchr_subfont(chr_code mod j_letter_token_flag),
               jchr_char(chr_code mod j_letter_token_flag));
  print_char("(");
  print_esc(font_id_text(equiv(j_s_font_pointer
                                 [jchr_subfont(chr_code mod j_letter_token_flag)])));
  print_esc("char"); print_int(jchr_char(chr_code mod j_letter_token_flag));
  print_char(")"); end;
@z

@x
@!input_stack : array[0..stack_size] of in_state_record;
@y
@!input_stack : ^in_state_record;
@z

@x
@!input_file : array[1..max_in_open] of alpha_file;
@!line : integer; {current line number in the current source file}
@!line_stack : array[1..max_in_open] of integer;
@y
@!input_file : ^alpha_file;
@!line : integer; {current line number in the current source file}
@!line_stack : ^integer;
@!source_filename_stack : ^str_number;
@!full_source_filename_stack : ^str_number;
@z

@x
  begin print_nl("Runaway ");
@.Runaway...@>
  case scanner_status of
  defining: begin print("definition"); p:=def_ref;
    end;
  matching: begin print("argument"); p:=temp_head;
    end;
  aligning: begin print("preamble"); p:=hold_head;
    end;
  absorbing: begin print("text"); p:=def_ref;
    end;
  end; {there are no other cases}
@y
  begin
@.Runaway...@>
  case scanner_status of
  defining: begin print_nl("Runaway definition"); p:=def_ref;
    end;
  matching: begin print_nl("Runaway argument"); p:=temp_head;
    end;
  aligning: begin print_nl("Runaway preamble"); p:=hold_head;
    end;
  absorbing: begin print_nl("Runaway text"); p:=def_ref;
    end;
  end; {there are no other cases}
@z

@x
@!param_stack:array [0..param_size] of pointer;
  {token list pointers for parameters}
@y
@!param_stack: ^pointer;
  {token list pointers for parameters}
@z

@x
  begin tally:=0; {get ready to count characters}
  old_setting:=selector;
@y
  begin tally:=0; tally_disp:=0; {get ready to count characters}
  old_setting:=selector;
@z

@x
@!p: integer; {starting or ending place in |trick_buf|}
@!q: integer; {temporary index}
@y
@!p: integer; {starting or ending place in |trick_buf|}
@!q,r: integer; {temporary index}
@z

@x
@d set_trick_count==
  begin first_count:=tally;
  trick_count:=tally+1+error_line-half_error_line;
  if trick_count<error_line then trick_count:=error_line;
  end
@y
@d set_trick_count==
  begin first_count:=tally; first_count_disp:=tally_disp;
  trick_count:=tally_disp+1+error_line-half_error_line;
  if trick_count<error_line then trick_count:=error_line;
  end
@z

@x
if tally<trick_count then m:=tally-first_count
else m:=trick_count-first_count; {context on line 2}
if l+first_count<=half_error_line then
  begin p:=0; n:=l+first_count;
  end
else  begin print("..."); p:=l+first_count-half_error_line+3;
  n:=half_error_line;
  end;
for q:=p to first_count-1 do print_char(trick_buf[q mod error_line]);
print_ln;
for q:=1 to n do print_char(" "); {print |n| spaces to begin line~2}
if m+n<=error_line then p:=first_count+m else p:=first_count+(error_line-n-3);
for q:=first_count to p-1 do print_char(trick_buf[q mod error_line]);
if m+n>error_line then print("...")
@y
if tally_disp<trick_count then m:=tally_disp-first_count_disp
else m:=trick_count-first_count_disp; {context on line 2}
{l=displayed length of chars before first_count}
if l+first_count_disp<=half_error_line then
  begin n:=l+first_count_disp; r:=n-l;
  end
else  begin print("...");
  n:=half_error_line; r:=n-3-l;
  end;
@<Print the first line of tricky pseudoprint@>;
print_ln;
for q:=1 to r do print_char(" "); {print |n| or |n-1| spaces to begin line~2}
if m+n<=error_line then r:=m else r:=error_line-n-3;
@<Print the second line of tricky pseudoprint@>;
if m+n>error_line then print("...")
@z

@x
@<Pseudoprint the line@>=
begin_pseudoprint;
if buffer[limit]=end_line_char then j:=limit
else j:=limit+1; {determine the effective end of the line}
if j>0 then for i:=start to j-1 do
  begin if i=loc then set_trick_count;
  print(buffer[i]);
  end
@y
@<Pseudoprint the line@>=
begin_pseudoprint; @<Reset |pseudo_kanji_stat|@>;
@<Determin the effective end of the line@>;
if j>0 then @<Pseudo print chars in |buffer| in printable form@>
@z

@x
@ @<Pseudoprint the token list@>=
begin_pseudoprint;
@y
@ @<Pseudoprint the token list@>=
begin_pseudoprint; @<Reset |pseudo_kanji_stat|@>;
@z

@x
print(" while scanning ");
@y
@z

@x
defining:begin print("definition"); info(p):=right_brace_token+"}";
  end;
matching:begin print("use"); info(p):=par_token; long_state:=outer_call;
  end;
aligning:begin print("preamble"); info(p):=right_brace_token+"}"; q:=p;
  p:=get_avail; link(p):=q; info(p):=cs_token_flag+frozen_cr;
  align_state:=-1000000;
  end;
absorbing:begin print("text"); info(p):=right_brace_token+"}";
@y
defining:begin print(" while scanning definition"); info(p):=right_brace_token+"}";
  end;
matching:begin print(" while scanning use"); info(p):=par_token; long_state:=outer_call;
  end;
aligning:begin print(" while scanning preamble"); info(p):=right_brace_token+"}"; q:=p;
  p:=get_avail; link(p):=q; info(p):=cs_token_flag+frozen_cr;
  align_state:=-1000000;
  end;
absorbing:begin print(" while scanning text"); info(p):=right_brace_token+"}";
@z

@x
var k:0..buf_size; {an index into |buffer|}
@!t:halfword; {a token}
@!cat:0..max_char_code; {|cat_code(cur_chr)|, usually}
@!c,@!cc:ASCII_code; {constituents of a possible expanded code}
@!d:2..3; {number of excess characters in an expanded code}
@y
var k:0..buf_size; {an index into |buffer|}
@!t:halfword; {a token}
@!cat:escape..max_char_code; {|cat_code(cur_chr)|, usually}
@!c,@!cc:ASCII_code; {constituents of a possible expanded code}
@!d:2..3; {number of excess characters in an expanded code}
@!same_chr:boolean;
@!e:0..1; {shift for eightbit sup_mark}
@!jletter_endline:boolean; {true when a line ends with jletter}
@z

@x
begin switch: if loc<=limit then {current line not yet finished}
  begin cur_chr:=buffer[loc]; incr(loc);
  reswitch: cur_cmd:=cat_code(cur_chr);
@y
begin switch: if loc<=limit then {current line not yet finished}
  begin cur_chr:=buffer[loc]; incr(loc);
    @<Read an extended char and reset |cur_cmd| and |cur_chr| appropriately@>;
    @<Restore delayed |cat_ret| and return, if appropriate@>;
  reswitch:
@z

@x
mid_line+car_ret:@<Finish line, emit a space@>;
@y
mid_line+car_ret:@<Check if the last character of the line is japanese,
  change state, and finish line@>;
@z

@x
begin if cur_chr=buffer[loc] then if loc<limit then
  begin c:=buffer[loc+1]; @+if c<@'200 then {yes we have an expanded char}
    begin loc:=loc+2;
    if is_hex(c) then if loc<=limit then
      begin cc:=buffer[loc]; @+if is_hex(cc) then
        begin incr(loc); hex_to_cur_chr; goto reswitch;
        end;
      end;
    if c<@'100 then cur_chr:=c+@'100 @+else cur_chr:=c-@'100;
    goto reswitch;
@y
begin if (not is_ext_char(buffer[loc]) and (buffer[loc]=cur_chr)) then begin
  same_chr:=true; e:=0;
  end
else if (is_ext_eightbit(buffer[loc]) and
         (make_eightbit(buffer[loc+1])=cur_chr)) then begin
  same_chr:=true; e:=1;
  end
else same_chr:=false;
if same_chr then if loc+e<limit then
  begin c:=buffer[loc+e+1]; @+if c<@'200 then {yes we have an expanded char}
    begin loc:=loc+e+2;
    if is_hex(c) then if loc<=limit then
      begin cc:=buffer[loc]; @+if is_hex(cc) then
        begin incr(loc); hex_to_cur_chr;
          cur_cmd:=cat_code(cur_chr); goto reswitch;
        end;
      end;
    if c<@'100 then cur_chr:=c+@'100 @+else cur_chr:=c-@'100;
    cur_cmd:=cat_code(cur_chr); goto reswitch;
@z

@x
else  begin start_cs: k:=loc; cur_chr:=buffer[k]; cat:=cat_code(cur_chr);
  incr(k);
  if cat=letter then state:=skip_blanks
  else if cat=spacer then state:=skip_blanks
  else state:=mid_line;
  if (cat=letter)and(k<=limit) then
@y
else  begin start_cs: k:=loc; cur_chr:=buffer[k];
  @<Check an extended char in control sequence name@>;
  if cat=jletter then repos_char(k)
  else incr(k);
  if (cat=letter) or (cat=jletter) then state:=skip_blanks
  else if cat=spacer then state:=skip_blanks
  else state:=mid_line;
  if ((cat=letter) or (cat=jletter)) and (k<=limit) then
@z

@x
  cur_cs:=single_base+buffer[loc]; incr(loc);
@y
  if is_ext_eightbit(buffer[loc]) then begin incr(loc);
    cur_cs:=single_base+make_eightbit(buffer[loc]);
    end
  else
    cur_cs:=single_base+buffer[loc];
  incr(loc);
@z

@x
begin if buffer[k]=cur_chr then @+if cat=sup_mark then @+if k<limit then
  begin c:=buffer[k+1]; @+if c<@'200 then {yes, one is indeed present}
    begin d:=2;
    if is_hex(c) then @+if k+2<=limit then
      begin cc:=buffer[k+2]; @+if is_hex(cc) then incr(d);
      end;
    if d>2 then
      begin hex_to_cur_chr; buffer[k-1]:=cur_chr;
      end
    else if c<@'100 then buffer[k-1]:=c+@'100
    else buffer[k-1]:=c-@'100;
@y
begin if (not is_ext_char(buffer[k]) and (buffer[k]=cur_chr)) then begin
  same_chr:=true; e:=0;
  end
else if (is_ext_eightbit(buffer[k]) and
         (make_eightbit(buffer[k+1])=cur_chr)) then begin
  same_chr:=true; e:=1;
  end
else same_chr:=false;
if same_chr then @+if cat=sup_mark then @+if k+e<limit then
  begin c:=buffer[k+e+1]; @+if c<@'200 then {yes, one is indeed present}
    begin d:=2;
    if is_hex(c) then @+if k+e+2<=limit then
      begin cc:=buffer[k+e+2]; @+if is_hex(cc) then incr(d);
      end;
    if d>2 then
      begin hex_to_cur_chr; buffer[k-e-1]:=cur_chr;
      end
    else if c<@'100 then buffer[k-e-1]:=c+@'100
    else buffer[k-e-1]:=c-@'100;
    if is_eightbit(buffer[k-e-1]) then begin
      buffer[k-e]:=de_eightbit(buffer[k-e-1]);
      buffer[k-e-1]:=ext_eightbit;
      incr(k); decr(d);
      end;
    k:=k-e;
@z

@x
begin repeat cur_chr:=buffer[k]; cat:=cat_code(cur_chr); incr(k);
until (cat<>letter)or(k>limit);
@<If an expanded...@>;
if cat<>letter then decr(k);
  {now |k| points to first nonletter}
if k>loc+1 then {multiletter control sequence has been scanned}
@y
begin repeat cur_chr:=buffer[k];
 @<Check an extended char in control sequence name@>;
 incr(k);
until ((cat<>letter) and (cat<>jletter)) or (k>limit);
@<If an expanded...@>;
if (cat<>letter) and (cat<>jletter) then backward_onechar(k);
  {now |k| points to first nonletter}
if (k>loc+1) and not ((k=loc+2) and is_ext_eightbit(buffer[loc])) then
  {multiletter control sequence has been scanned}
@z

@x
  begin t:=info(loc); loc:=link(loc); {move to next}
  if t>=cs_token_flag then {a control sequence token}
@y
  begin t:=info(loc); loc:=link(loc); {move to next}
  if t>=j_letter_token_flag then begin
        cur_cmd:=jletter; cur_chr:=t mod j_letter_token_flag end
  else if t>=cs_token_flag then {a control sequence token}
@z

@x
begin cur_cs:=info(loc)-cs_token_flag; loc:=null;@/
cur_cmd:=eq_type(cur_cs); cur_chr:=equiv(cur_cs);
if cur_cmd>max_command then
  begin cur_cmd:=relax; cur_chr:=no_expand_flag;
  end;
end
@y
begin t:=info(loc); loc:=null;@/
if t>=j_letter_token_flag then begin
      cur_cmd:=jletter; cur_chr:=t mod j_letter_token_flag end
else begin cur_cs:=t-cs_token_flag;
cur_cmd:=eq_type(cur_cs); cur_chr:=equiv(cur_cs);
if cur_cmd>max_command then
  begin cur_cmd:=relax; cur_chr:=no_expand_flag;
  end;
end
end
@z

@x
else  begin if not terminal_input then {\.{\\read} line has ended}
    begin cur_cmd:=0; cur_chr:=0; return;
    end;
@y
else  begin
    if delayed_cat_ret then
      @<Emit a space, |delayed_cat_ret:=false|, and return@>;
    if not terminal_input then {\.{\\read} line has ended}
    begin cur_cmd:=0; cur_chr:=0; return;
    end;
@z

@x
    if end_line_char_inactive then decr(limit)
    else  buffer[limit]:=end_line_char;
@y
    @<Put the end-of-line-char if it is active@>;
@z

@x
if not force_eof then
  begin if input_ln(cur_file,true) then {not end of file}
    firm_up_the_line {this sets |limit|}
  else force_eof:=true;
  end;
@y
if not force_eof then
  begin if input_ln(cur_file,true) then {not end of file}
    firm_up_the_line {this sets |limit|}
  else if delayed_cat_ret {and (scanner_status=matching)} then begin
    decr(line); loc:=limit+1;
    @<Emit a space, |delayed_cat_ret:=false|, and return@>;
    end
  else force_eof:=true;
  end;
@z

@x
if end_line_char_inactive then decr(limit)
else  buffer[limit]:=end_line_char;
@y
@<Put the end-of-line-char if it is active@>;
@z

@x
begin no_new_control_sequence:=false; get_next; no_new_control_sequence:=true;
@^inner loop@>
if cur_cs=0 then cur_tok:=(cur_cmd*@'400)+cur_chr
else cur_tok:=cs_token_flag+cur_cs;
@y
begin no_new_control_sequence:=false; get_next; no_new_control_sequence:=true;
@^inner loop@>
if cur_cs=0 then begin
  if (cur_cmd=jletter)
    then cur_tok:=j_letter_token_flag+cur_chr
  else cur_tok:=(cur_cmd*@'400)+cur_chr end
else cur_tok:=cs_token_flag+cur_cs;
@z

@x
The |expand| subroutine is used when |cur_cmd>max_command|. It removes a
@y
@ Sometimes, recursive calls to the following |expand| routine may
cause exhaustion of the run-time calling stack, resulting in
forced execution stops by the operating system. To diminish the chance
of this happening, a counter is used to keep track of the recursion
depth, in conjunction with a constant called |expand_depth|.

This does not catch all possible infinite recursion loops, just the ones
that exhaust the application calling stack. The actual maximum value of
|expand_depth| is outside of our control, but the initial setting of
|10000| should be enough to prevent problems.
@^system dependencies@>

@<Global...@>=
expand_depth_count:integer;

@ @<Set init...@>=
expand_depth_count:=0;

@ The |expand| subroutine is used when |cur_cmd>max_command|. It removes a
@z

@x
var t:halfword; {token that is being ``expanded after''}
@!p,@!q,@!r:pointer; {for list manipulation}
@!j:0..buf_size; {index into |buffer|}
@y
var t:halfword; {token that is being ``expanded after''}
@!p,@!q,@!r:pointer; {for list manipulation}
@!j:0..buf_size; {index into |buffer|}
@!fc:halfword;
@!ku_ten:halfword;
@z

@x
begin cv_backup:=cur_val; cvl_backup:=cur_val_level; radix_backup:=radix;
@y
begin
incr(expand_depth_count);
if expand_depth_count>=expand_depth then overflow("expansion depth",expand_depth);
cv_backup:=cur_val; cvl_backup:=cur_val_level; radix_backup:=radix;
@z

@x
cur_order:=co_backup; link(backup_head):=backup_backup;
@y
cur_order:=co_backup; link(backup_head):=backup_backup;
decr(expand_depth_count);
@z

@x
while p<>null do
  begin if j>=max_buf_stack then
    begin max_buf_stack:=j+1;
    if max_buf_stack=buf_size then
      overflow("buffer size",buf_size);
@:TeX capacity exceeded buffer size}{\quad buffer size@>
    end;
  buffer[j]:=info(p) mod @'400; incr(j); p:=link(p);
  end;
@y
while p<>null do
  begin if j+1>=max_buf_stack then
    begin max_buf_stack:=j+2;
    if max_buf_stack=buf_size then
      overflow("buffer size",buf_size);
@:TeX capacity exceeded buffer size}{\quad buffer size@>
    end;
  if info(p)>=j_letter_token_flag then begin
    fc:=info(p) mod j_letter_token_flag;
    @<Put the internal representation of |fc| in |buffer|@>;
    end
  else begin
    buffer[j]:=info(p) mod @'400;
    @<Put the internal representation of char in |buffer|@>;
    end;
  incr(j); p:=link(p);
  end;
@z

@x
done: if cur_cs=0 then cur_tok:=(cur_cmd*@'400)+cur_chr
else cur_tok:=cs_token_flag+cur_cs;
@y
done: if cur_cs=0 then begin
  if (cur_cmd=jletter)
    then cur_tok:=j_letter_token_flag+cur_chr
  else cur_tok:=(cur_cmd*@'400)+cur_chr end
else cur_tok:=cs_token_flag+cur_cs;
@z

@x
  begin expand;
  get_next;
  end;
if cur_cs=0 then cur_tok:=(cur_cmd*@'400)+cur_chr
else cur_tok:=cs_token_flag+cur_cs;
@y
  begin expand;
  get_next;
  end;
if cur_cs=0 then begin
  if (cur_cmd=jletter)
    then cur_tok:=j_letter_token_flag+cur_chr
  else cur_tok:=(cur_cmd*@'400)+cur_chr end
else cur_tok:=cs_token_flag+cur_cs;
@z

@x
toks_register,assign_toks,def_family,set_font,def_font: @<Fetch a token list or
  font identifier, provided that |level=tok_val|@>;
@y
toks_register,assign_toks,def_family,set_font,def_font,def_dfont:
  @<Fetch a token list or font identifier, provided that |level=tok_val|@>;
demmand_font: scanned_result(cur_cs)(ident_val);
@z

@x
@!OK_so_far:boolean; {has an error message been issued?}
@y
@!OK_so_far:boolean; {has an error message been issued?}
@!jletter_const:boolean;
@z

@x
begin get_token; {suppress macro expansion}
if cur_tok<cs_token_flag then
  begin cur_val:=cur_chr;
  if cur_cmd<=right_brace then
    if cur_cmd=right_brace then incr(align_state)
    else decr(align_state);
  end
else if cur_tok<cs_token_flag+single_base then
  cur_val:=cur_tok-cs_token_flag-active_base
else cur_val:=cur_tok-cs_token_flag-single_base;
if cur_val>255 then
  begin print_err("Improper alphabetic constant");
@.Improper alphabetic constant@>
  help2("A one-character control sequence belongs after a ` mark.")@/
    ("So I'm essentially inserting \0 here.");
  cur_val:="0"; back_error;
  end
else @<Scan an optional space@>;
end
@y
begin get_token; {suppress macro expansion}
jletter_const:=false;
if cur_tok>=j_letter_token_flag then begin
  cur_val:= cur_chr;
  jletter_const:=true
  end
else if cur_tok<cs_token_flag then
  begin cur_val:=cur_chr;
  if cur_cmd<=right_brace then
    if cur_cmd=right_brace then incr(align_state)
    else decr(align_state);
  end
else if cur_tok<cs_token_flag+single_base then
  cur_val:=cur_tok-cs_token_flag-active_base
else cur_val:=cur_tok-cs_token_flag-single_base;
if (not jletter_const) and (cur_val>255) then
  begin print_err("Improper alphabetic or japanese constant");
print_int(cur_val);
@.Improper alphabetic or japanese constant@>
  help2("A one-character control sequence belongs after a ` mark.")@/
    ("So I'm essentially inserting \0 here.");
  cur_val:="0"; back_error;
  end
else @<Scan an optional space@>;
end
@z

@x
if scan_keyword("em") then v:=(@<The em width for |cur_font|@>)
@.em@>
else if scan_keyword("ex") then v:=(@<The x-height for |cur_font|@>)
@.ex@>
@y
if scan_keyword("em") then v:=(@<The em width for |cur_font|@>)
@.em@>
else if scan_keyword("ex") then v:=(@<The x-height for |cur_font|@>)
@.ex@>
else if scan_keyword("zw") then v:=(@<The zw width for current jfont@>)
@.zw@>
else if scan_keyword("zh") then v:=(@<The zh height for current jfont@>)
@.zh@>
@z

@x
  if t=" " then t:=space_token
  else t:=other_token+t;
@y
  @<get token of a char from |str_pool|@>;
@z

@x
@d job_name_code=5 {command code for \.{\\jobname}}

@<Put each...@>=
primitive("number",convert,number_code);@/
@!@:number_}{\.{\\number} primitive@>
primitive("romannumeral",convert,roman_numeral_code);@/
@!@:roman_numeral_}{\.{\\romannumeral} primitive@>
primitive("string",convert,string_code);@/
@!@:string_}{\.{\\string} primitive@>
primitive("meaning",convert,meaning_code);@/
@!@:meaning_}{\.{\\meaning} primitive@>
primitive("fontname",convert,font_name_code);@/
@!@:font_name_}{\.{\\fontname} primitive@>
primitive("jobname",convert,job_name_code);@/
@!@:job_name_}{\.{\\jobname} primitive@>
@y
@d job_name_code=5 {command code for \.{\\jobname}}
@d j_internal_code_code=6 {command code for \.{\\jinternalcode}}
@d j_subfont_num_code=7 {command code for \.{\\jsubfontnum}}
@d j_char_num_code=8 {command code for \.{\\jcharnum}}
@d jis_code_code=9 {command code for \.{\\jiscode}}
@d jis_ku_code=10 {command code for \.{\\jisku}}
@d jis_ten_code=11 {command code for \.{\\jisten}}

@<Put each...@>=
primitive("number",convert,number_code);@/
@!@:number_}{\.{\\number} primitive@>
primitive("romannumeral",convert,roman_numeral_code);@/
@!@:roman_numeral_}{\.{\\romannumeral} primitive@>
primitive("string",convert,string_code);@/
@!@:string_}{\.{\\string} primitive@>
primitive("meaning",convert,meaning_code);@/
@!@:meaning_}{\.{\\meaning} primitive@>
primitive("fontname",convert,font_name_code);@/
@!@:font_name_}{\.{\\fontname} primitive@>
primitive("jobname",convert,job_name_code);@/
@!@:job_name_}{\.{\\jobname} primitive@>
primitive("jinternalcode",convert,j_internal_code_code);@/
@!@:j_internal_code_}{\.{\\jinternalcode} primitive@>
primitive("jsubfontnum",convert,j_subfont_num_code);@/
@!@:j_subfont_num_}{\.{\\jsubfontnum} primitive@>
primitive("jcharnum",convert,j_char_num_code);@/
@!@:j_char_num_}{\.{\\jcharnum} primitive@>
primitive("jiscode",convert,jis_code_code);@/
@!@:jis_code_}{\.{\\jiscode} primitive@>
primitive("jisku",convert,jis_ku_code);@/
@!@:jis_ku_}{\.{\\jisku} primitive@>
primitive("jisten",convert,jis_ten_code);@/
@!@:jis_ten_}{\.{\\jisten} primitive@>
@z

@x
  othercases print_esc("jobname")
@y
  job_name_code: print_esc("jobname");
  j_internal_code_code: print_esc("jinternalcode");
  j_subfont_num_code: print_esc("jsubfontnum");
  j_char_num_code: print_esc("jcharnum");
  jis_code_code: print_esc("jiscode");
  jis_ku_code: print_esc("jisku");
  jis_ten_code: print_esc("jisten");
  othercases print_esc("unknown")
@z

@x
@!c:number_code..job_name_code; {desired type of conversion}
@y
@!c:number_code..jis_ten_code; {desired type of conversion}
@z

@x
number_code,roman_numeral_code: scan_int;
@y
number_code,roman_numeral_code,j_internal_code_code,
j_subfont_num_code,j_char_num_code,
jis_code_code,jis_ku_code,jis_ten_code: scan_int;
@z

@x
string_code:if cur_cs<>0 then sprint_cs(cur_cs)
  else print_char(cur_chr);
@y
string_code:if cur_cs<>0 then sprint_cs(cur_cs)
  else if cur_cmd=jletter then
    print_j_char(jchr_subfont(cur_chr mod j_letter_token_flag),
                 jchr_char(cur_chr mod j_letter_token_flag))
  else print_char(cur_chr);
@z

@x
job_name_code: print(job_name);
@y
job_name_code: print(job_name);
j_internal_code_code: print_int(cur_val);
j_subfont_num_code: print_int(jchr_subfont(cur_val));
j_char_num_code: print_int(jchr_char(cur_val));
jis_code_code:
  print_int(ku_ten_compute(jchr_subfont(cur_val),jchr_char(cur_val)));
jis_ku_code:
  print_int(ku_ten_compute(jchr_subfont(cur_val),jchr_char(cur_val)) div 256);
jis_ten_code:
  print_int(ku_ten_compute(jchr_subfont(cur_val),jchr_char(cur_val)) mod 256);
@z

@x
if end_line_char_inactive then decr(limit)
else  buffer[limit]:=end_line_char;
@y
@<Put the end-of-line-char if it is active@>;
@z

@x
if_eof_code: begin scan_four_bit_int; b:=(read_open[cur_val]=closed);
  end;
@y
if_eof_code: begin scan_four_bit_int_or_18;
  if cur_val=18 then b:=not shellenabledp
  else b:=(read_open[cur_val]=closed);
  end;
@z

@x
if (cur_cmd>active_char)or(cur_chr>255) then {not a character}
  begin m:=relax; n:=256;
  end
else  begin m:=cur_cmd; n:=cur_chr;
  end;
get_x_token_or_active_char;
if (cur_cmd>active_char)or(cur_chr>255) then
  begin cur_cmd:=relax; cur_chr:=256;
  end;
@y
if (cur_cmd<>jletter)and((cur_cmd>active_char)or(cur_chr>255)) then
  begin m:=relax; n:=256;
  end
else  begin m:=cur_cmd; n:=cur_chr;
  end;
get_x_token_or_active_char;
if (cur_cmd<>jletter)and((cur_cmd>active_char)or(cur_chr>255)) then
  begin cur_cmd:=relax; cur_chr:=256;
  end;
@z

@x
@ The file names we shall deal with for illustrative purposes have the
following structure:  If the name contains `\.>' or `\.:', the file area
consists of all characters up to and including the final such character;
otherwise the file area is null.  If the remaining file name contains
`\..', the file extension consists of all such characters from the first
remaining `\..' to the end, otherwise the file extension is null.
@y
@ The file names we shall deal with have the
following structure:  If the name contains `\./' or `\.:'
(for Amiga only), the file area
consists of all characters up to and including the final such character;
otherwise the file area is null.  If the remaining file name contains
`\..', the file extension consists of all such characters from the last
`\..' to the end, otherwise the file extension is null.
@z

@x
@!area_delimiter:pool_pointer; {the most recent `\.>' or `\.:', if any}
@!ext_delimiter:pool_pointer; {the relevant `\..', if any}
@y
@!area_delimiter:pool_pointer; {the most recent `\./', if any}
@!ext_delimiter:pool_pointer; {the most recent `\..', if any}
@z

@x
@d TEX_area=="TeXinputs:"
@.TeXinputs@>
@d TEX_font_area=="TeXfonts:"
@.TeXfonts@>
@y
In C, the default paths are specified separately.
@z

@x
begin area_delimiter:=0; ext_delimiter:=0;
@y
begin area_delimiter:=0; ext_delimiter:=0; quoted_filename:=false;
@z

@x
begin if c=" " then more_name:=false
@y
begin if (c=" ") and stop_at_space and (not quoted_filename) then
  more_name:=false
else  if c="""" then begin
  quoted_filename:=not quoted_filename;
  more_name:=true;
  end
@z

@x
  if (c=">")or(c=":") then
@y
  if IS_DIR_SEP(c) then
@z

@x
  else if (c=".")and(ext_delimiter=0) then ext_delimiter:=cur_length;
@y
  else if c="." then ext_delimiter:=cur_length;
@z

@x
@ The third.
@^system dependencies@>

@p procedure end_name;
@y
@ The third.
@^system dependencies@>
If a string is already in the string pool, the function
|slow_make_string| does not create a new string but returns this string
number, thus saving string space.  Because of this new property of the
returned string number it is not possible to apply |flush_string| to
these strings.

@p procedure end_name;
var temp_str: str_number; {result of file name cache lookups}
@!j,@!s,@!t: pool_pointer; {running indices}
@!must_quote:boolean; {whether we need to quote a string}
@z

@x
@:TeX capacity exceeded number of strings}{\quad number of strings@>
@y
@:TeX capacity exceeded number of strings}{\quad number of strings@>
str_room(6); {Room for quotes, if needed.}
{add quotes if needed}
if area_delimiter<>0 then begin
  {maybe quote |cur_area|}
  must_quote:=false;
  s:=str_start[str_ptr];
  t:=str_start[str_ptr]+area_delimiter;
  j:=s;
  while (not must_quote) and (j<t) do begin
    must_quote:=str_pool[j]=" "; incr(j);
    end;
  if must_quote then begin
    for j:=pool_ptr-1 downto t do str_pool[j+2]:=str_pool[j];
    str_pool[t+1]:="""";
    for j:=t-1 downto s do str_pool[j+1]:=str_pool[j];
    str_pool[s]:="""";
    if ext_delimiter<>0 then ext_delimiter:=ext_delimiter+2;
    area_delimiter:=area_delimiter+2;
    pool_ptr:=pool_ptr+2;
    end;
  end;
{maybe quote |cur_name|}
s:=str_start[str_ptr]+area_delimiter;
if ext_delimiter=0 then t:=pool_ptr else t:=str_start[str_ptr]+ext_delimiter-1;
must_quote:=false;
j:=s;
while (not must_quote) and (j<t) do begin
  must_quote:=str_pool[j]=" "; incr(j);
  end;
if must_quote then begin
  for j:=pool_ptr-1 downto t do str_pool[j+2]:=str_pool[j];
  str_pool[t+1]:="""";
  for j:=t-1 downto s do str_pool[j+1]:=str_pool[j];
  str_pool[s]:="""";
  if ext_delimiter<>0 then ext_delimiter:=ext_delimiter+2;
  pool_ptr:=pool_ptr+2;
  end;
if ext_delimiter<>0 then begin
  {maybe quote |cur_ext|}
  s:=str_start[str_ptr]+ext_delimiter-1;
  t:=pool_ptr;
  must_quote:=false;
  j:=s;
  while (not must_quote) and (j<t) do begin
    must_quote:=str_pool[j]=" "; incr(j);
    end;
  if must_quote then begin
    str_pool[t+1]:="""";
    for j:=t-1 downto s do str_pool[j+1]:=str_pool[j];
    str_pool[s]:="""";
    pool_ptr:=pool_ptr+2;
    end;
  end;
@z

@x
  end;
if ext_delimiter=0 then
  begin cur_ext:=""; cur_name:=make_string;
@y
  temp_str:=search_string(cur_area);
  if temp_str>0 then
    begin cur_area:=temp_str;
    decr(str_ptr);  {no |flush_string|, |pool_ptr| will be wrong!}
    for j:=str_start[str_ptr+1] to pool_ptr-1 do
      begin str_pool[j-area_delimiter]:=str_pool[j];
      end;
    pool_ptr:=pool_ptr-area_delimiter; {update |pool_ptr|}
    end;
  end;
if ext_delimiter=0 then
  begin cur_ext:=""; cur_name:=slow_make_string;
@z

@x
  incr(str_ptr); cur_ext:=make_string;
@y
  incr(str_ptr); cur_ext:=make_string;
  decr(str_ptr); {undo extension string to look at name part}
  temp_str:=search_string(cur_name);
  if temp_str>0 then
    begin cur_name:=temp_str;
    decr(str_ptr);  {no |flush_string|, |pool_ptr| will be wrong!}
    for j:=str_start[str_ptr+1] to pool_ptr-1 do
      begin str_pool[j-ext_delimiter+area_delimiter+1]:=str_pool[j];
      end;
    pool_ptr:=pool_ptr-ext_delimiter+area_delimiter+1;  {update |pool_ptr|}
    end;
  cur_ext:=slow_make_string;  {remake extension string}
@z

@x
some operating systems put the file area last instead of first.)
@^system dependencies@>
@y
some operating systems put the file area last instead of first.)
@^system dependencies@>

@d check_quoted(#) == {check if string |#| needs quoting}
if #<>0 then begin
  j:=str_start[#];
  while (not must_quote) and (j<str_start[#+1]) do begin
    must_quote:=str_pool[j]=" "; incr(j);
  end;
end
@#
@d print_quoted(#) == {print string |#|, omitting quotes}
if #<>0 then
  for j:=str_start[#] to str_start[#+1]-1 do
    if so(str_pool[j])<>"""" then
      print(so(str_pool[j]))
@z

@x
begin slow_print(a); slow_print(n); slow_print(e);
@y
var must_quote: boolean; {whether to quote the filename}
@!j:pool_pointer; {index into |str_pool|}
begin
must_quote:=false;
check_quoted(a); check_quoted(n); check_quoted(e);
{FIXME: Alternative is to assume that any filename that has to be quoted has
 at least one quoted component...if we pick this, a number of insertions
 of |print_file_name| should go away.
|must_quote|:=((|a|<>0)and(|str_pool|[|str_start|[|a|]]=""""))or
              ((|n|<>0)and(|str_pool|[|str_start|[|n|]]=""""))or
              ((|e|<>0)and(|str_pool|[|str_start|[|e|]]=""""));}
if must_quote then print_char("""");
print_quoted(a); print_quoted(n); print_quoted(e);
if must_quote then print_char("""");
@z

@x
@d append_to_name(#)==begin c:=#; incr(k);
  if k<=file_name_size then name_of_file[k]:=xchr[c];
  end
@y
@d append_to_name(#)==begin c:=#; if not (c="""") then begin incr(k);
  if k<=file_name_size then name_of_file[k]:=xchr[c];
  end end
@z

@x
begin k:=0;
@y
begin k:=0;
if name_of_file then libc_free (name_of_file);
name_of_file:= xmalloc_array (ASCII_code, length(a)+length(n)+length(e)+1);
@z

@x
for k:=name_length+1 to file_name_size do name_of_file[k]:=' ';
@y
name_of_file[name_length+1]:=0;
@z

@x
@d format_default_length=20 {length of the |TEX_format_default| string}
@d format_area_length=11 {length of its area part}
@d format_ext_length=4 {length of its `\.{.fmt}' part}
@y
Under {\mc UNIX} we don't give the area part, instead depending
on the path searching that will happen during file opening.  Also, the
length will be set in the main program.

@d format_area_length=0 {length of its area part}
@d format_ext_length=4 {length of its `\.{.fmt}' part}
@z

@x
@!TEX_format_default:packed array[1..format_default_length] of char;

@ @<Set init...@>=
TEX_format_default:='TeXformats:plain.fmt';
@y
@!format_default_length: integer;
@!TEX_format_default: w2c_u_string;

@ We set the name of the default format file and the length of that name
in C, instead of Pascal, since we want them to depend on the name of the
program.
@z

@x
for j:=1 to n do append_to_name(xord[TEX_format_default[j]]);
@y
if name_of_file then libc_free (name_of_file);
name_of_file := xmalloc_array (ASCII_code, n+(b-a+1)+format_ext_length+1);
for j:=1 to n do append_to_name(xord[TEX_format_default[j]]);
@z

@x
for k:=name_length+1 to file_name_size do name_of_file[k]:=' ';
@y
name_of_file[name_length+1]:=0;
@z

@x
  pack_buffered_name(0,loc,j-1); {try first without the system file area}
  if w_open_in(fmt_file) then goto found;
  pack_buffered_name(format_area_length,loc,j-1);
    {now try the system format file area}
  if w_open_in(fmt_file) then goto found;
@y
  pack_buffered_name(0,loc,j-1); {Kpathsea does everything}
  if w_open_in(fmt_file) then goto found;
@z

@x
  wterm_ln('Sorry, I can''t find that format;',' will try PLAIN.');
@y
  wterm ('Sorry, I can''t find the format `');
  fputs (stringcast(name_of_file + 1), stdout);
  wterm ('''; will try `');
  fputs (TEX_format_default + 1, stdout);
  wterm_ln ('''.');
@z

@x
  wterm_ln('I can''t find the PLAIN format file!');
@.I can't find PLAIN...@>
@y
  wterm ('I can''t find the format file `');
  fputs (TEX_format_default + 1, stdout);
  wterm_ln ('''!');
@.I can't find the format...@>
@z

@x
begin if (pool_ptr+name_length>pool_size)or(str_ptr=max_strings)or
@y
save_area_delimiter, save_ext_delimiter: pool_pointer;
save_name_in_progress, save_stop_at_space: boolean;
begin if (pool_ptr+name_length>pool_size)or(str_ptr=max_strings)or
@z

@x
  make_name_string:=make_string;
@y
  make_name_string:=make_string;
  {At this point we also set |cur_name|, |cur_ext|, and |cur_area| to
   match the contents of |name_of_file|.}
  save_area_delimiter:=area_delimiter; save_ext_delimiter:=ext_delimiter;
  save_name_in_progress:=name_in_progress; save_stop_at_space:=stop_at_space;
  name_in_progress:=true;
  begin_name;
  stop_at_space:=false;
  k:=1;
  while (k<=name_length)and(more_name(name_of_file[k])) do
    incr(k);
  stop_at_space:=save_stop_at_space;
  end_name;
  name_in_progress:=save_name_in_progress;
  area_delimiter:=save_area_delimiter; ext_delimiter:=save_ext_delimiter;
@z

@x
@p procedure scan_file_name;
label done;
begin name_in_progress:=true; begin_name;
@y
@p procedure scan_file_name;
label done;
var save_jendline_type:integer;
begin name_in_progress:=true;
save_jendline_type:=jendline_type; jendline_type:=jend_ascii;
begin_name;
@z

@x
  if not more_name(cur_chr) then goto done;
@y
  {If |cur_chr| is a space and we're not scanning a token list, check
   whether we're at the end of the buffer. Otherwise we end up adding
   spurious spaces to file names in some cases.}
  if (cur_chr=" ") and (state<>token_list) and (loc>limit) then goto done;
  if not more_name(cur_chr) then goto done;
@z

@x
done: end_name; name_in_progress:=false;
@y
done: end_name; name_in_progress:=false; jendline_type:=save_jendline_type;
@z

@x
var k:0..buf_size; {index into |buffer|}
@y
var k:0..buf_size; {index into |buffer|}
@!saved_cur_name:str_number; {to catch empty terminal input}
@!saved_cur_ext:str_number; {to catch empty terminal input}
@!saved_cur_area:str_number; {to catch empty terminal input}
@z

@x
if e=".tex" then show_context;
@y
if (e=".tex") or (e="") then show_context;
print_ln; print_c_string(prompt_file_name_help_msg);
if (e<>"") then
  begin
    print("; default file extension is `"); print(e); print("'");
  end;
print(")"); print_ln;
@z

@x
clear_terminal; prompt_input(": "); @<Scan file name in the buffer@>;
if cur_ext="" then cur_ext:=e;
@y
saved_cur_name:=cur_name;
saved_cur_ext:=cur_ext;
saved_cur_area:=cur_area;
clear_terminal; prompt_input(": "); @<Scan file name in the buffer@>;
if (length(cur_name)=0) and (cur_ext="") and (cur_area="") then
  begin
    cur_name:=saved_cur_name;
    cur_ext:=saved_cur_ext;
    cur_area:=saved_cur_area;
  end
else
  if cur_ext="" then cur_ext:=e;
@z

@x
@d ensure_dvi_open==if output_file_name=0 then
@y
@d log_name == texmf_log_name
@d ensure_dvi_open==if output_file_name=0 then
@z

@x
@!months:packed array [1..36] of char; {abbreviations of month names}
@y
@!months:const_cstring;
@z

@x
if job_name=0 then job_name:="texput";
@.texput@>
@y
if job_name=0 then job_name:=get_job_name("texput");
@.texput@>
pack_job_name(".fls");
recorder_change_filename(stringcast(name_of_file+1));
@z

@x
while not a_open_out(log_file) do @<Try to get a different log file name@>;
log_name:=a_make_name_string(log_file);
@y
while not a_open_out(log_file) do @<Try to get a different log file name@>;
log_name:=a_make_name_string(log_file);
@<Set kanji log type@>;
@z

@x
@<Print the banner line, including the date and time@>;
@y
@<Print the banner line, including the date and time@>;
if mltex_enabled_p then
  begin wlog_cr; wlog('MLTeX v2.2 enabled');
  end;
@z

@x
if buffer[l]=end_line_char then decr(l);
@y
@<Remove the end-of-line-char@>;
@z

@x
begin wlog(banner);
@y
begin
if src_specials_p or file_line_error_style_p or parse_first_line_p
then
  wlog(banner_k)
else
  wlog(banner);
@z

@x
slow_print(format_ident); print("  ");
@y
wlog(version_string);
slow_print(format_ident); print("  ");
@z

@x
months:='JANFEBMARAPRMAYJUNJULAUGSEPOCTNOVDEC';
@y
months := ' JANFEBMARAPRMAYJUNJULAUGSEPOCTNOVDEC';
@z

@x
end
@y
if shellenabledp then begin
  wlog_cr;
  wlog(' ');
  if restrictedshell then begin
    wlog('restricted ');
  end;
  wlog(' \write18 enabled.')
end;
if src_specials_p then begin
  wlog_cr;
  wlog(' Source specials enabled.')
end;
if file_line_error_style_p then begin
  wlog_cr;
  wlog(' file:line:error style messages enabled.')
end;
if parse_first_line_p then begin
  wlog_cr;
  wlog(' %&-line parsing enabled.');
end;
if translate_filename then begin
  wlog_cr;
  wlog(' (');
  fputs(translate_filename, log_file);
  wlog(')');
end;
end
@z

@x
begin scan_file_name; {set |cur_name| to desired file name}
if cur_ext="" then cur_ext:=".tex";
pack_cur_name;
loop@+  begin begin_file_reading; {set up |cur_file| and new level of input}
  if a_open_in(cur_file) then goto done;
  if cur_area="" then
    begin pack_file_name(cur_name,TEX_area,cur_ext);
    if a_open_in(cur_file) then goto done;
    end;
@y
var temp_str: str_number;
begin scan_file_name; {set |cur_name| to desired file name}
pack_cur_name;
loop@+begin
  begin_file_reading; {set up |cur_file| and new level of input}
  tex_input_type := 1; {Tell |open_input| we are \.{\\input}.}
  {Kpathsea tries all the various ways to get the file.}
  if kpse_in_name_ok(stringcast(name_of_file+1))
     and a_open_in(cur_file, kpse_tex_format) then
    goto done;
@z

@x
  prompt_file_name("input file name",".tex");
@y
  prompt_file_name("input file name","");
@z

@x
done: name:=a_make_name_string(cur_file);
@y
done: name:=a_make_name_string(cur_file);
source_filename_stack[in_open]:=name;
full_source_filename_stack[in_open]:=make_full_name_string;
@<Set kanji |cur_file| type@>;
if name=str_ptr-1 then {we can try to conserve string pool space now}
  begin temp_str:=search_string(name);
  if temp_str>0 then
    begin name:=temp_str; flush_string;
    end;
  end;
@z

@x
  begin job_name:=cur_name; open_log_file;
@y
  begin job_name:=get_job_name(cur_name);
    Init
      if dump_option then begin
        str_room(format_default_length);
        for k:=1 to format_default_length - format_ext_length do
          append_char(xord[TEX_format_default[k]]);
        job_name:=make_string;
      end;
    Tini
    open_log_file;
@z

@x
if term_offset+length(name)>max_print_line-2 then print_ln
else if (term_offset>0)or(file_offset>0) then print_char(" ");
print_char("("); incr(open_parens); slow_print(name); update_terminal;
@y
if term_offset+length(full_source_filename_stack[in_open])>max_print_line-2
then print_ln
else if (term_offset>0)or(file_offset>0) then print_char(" ");
print_char("("); incr(open_parens);
slow_print(full_source_filename_stack[in_open]); update_terminal;
@z

@x
if name=str_ptr-1 then {we can conserve string pool space now}
  begin flush_string; name:=cur_name;
  end;
@y
@z

@x
if end_line_char_inactive then decr(limit)
else  buffer[limit]:=end_line_char;
@y
@<Put the end-of-line-char if it is active@>;
@z

@x
@!internal_font_number=font_base..font_max; {|font| in a |char_node|}
@!font_index=0..font_mem_size; {index into |font_info|}
@y
@!internal_font_number=integer; {|font| in a |char_node|}
@!font_index=integer; {index into |font_info|}
@!nine_bits=min_quarterword..non_char;
@z

@x
@!font_info:array[font_index] of memory_word;
  {the big collection of font data}
@!fmem_ptr:font_index; {first unused word of |font_info|}
@!font_ptr:internal_font_number; {largest internal font number in use}
@!font_check:array[internal_font_number] of four_quarters; {check sum}
@!font_size:array[internal_font_number] of scaled; {``at'' size}
@!font_dsize:array[internal_font_number] of scaled; {``design'' size}
@!font_params:array[internal_font_number] of font_index; {how many font
  parameters are present}
@!font_name:array[internal_font_number] of str_number; {name of the font}
@!font_area:array[internal_font_number] of str_number; {area of the font}
@!font_bc:array[internal_font_number] of eight_bits;
  {beginning (smallest) character code}
@!font_ec:array[internal_font_number] of eight_bits;
  {ending (largest) character code}
@!font_glue:array[internal_font_number] of pointer;
  {glue specification for interword space, |null| if not allocated}
@!font_used:array[internal_font_number] of boolean;
  {has a character from this font actually appeared in the output?}
@!hyphen_char:array[internal_font_number] of integer;
  {current \.{\\hyphenchar} values}
@!skew_char:array[internal_font_number] of integer;
  {current \.{\\skewchar} values}
@!bchar_label:array[internal_font_number] of font_index;
  {start of |lig_kern| program for left boundary character,
  |non_address| if there is none}
@!font_bchar:array[internal_font_number] of min_quarterword..non_char;
  {right boundary character, |non_char| if there is none}
@!font_false_bchar:array[internal_font_number] of min_quarterword..non_char;
  {|font_bchar| if it doesn't exist in the font, otherwise |non_char|}
@y
@!font_info: ^fmemory_word;
  {the big collection of font data}
@!fmem_ptr:font_index; {first unused word of |font_info|}
@!font_ptr:internal_font_number; {largest internal font number in use}
@!font_check: ^four_quarters; {check sum}
@!font_size: ^scaled; {``at'' size}
@!font_dsize: ^scaled; {``design'' size}
@!font_params: ^font_index; {how many font
  parameters are present}
@!font_name: ^str_number; {name of the font}
@!font_area: ^str_number; {area of the font}
@!font_bc: ^eight_bits;
  {beginning (smallest) character code}
@!font_ec: ^eight_bits;
  {ending (largest) character code}
@!font_glue: ^pointer;
  {glue specification for interword space, |null| if not allocated}
@!font_used: ^boolean;
  {has a character from this font actually appeared in the output?}
@!hyphen_char: ^integer;
  {current \.{\\hyphenchar} values}
@!skew_char: ^integer;
  {current \.{\\skewchar} values}
@!bchar_label: ^font_index;
  {start of |lig_kern| program for left boundary character,
  |non_address| if there is none}
@!font_bchar: ^nine_bits;
  {right boundary character, |non_char| if there is none}
@!font_false_bchar: ^nine_bits;
  {|font_bchar| if it doesn't exist in the font, otherwise |non_char|}
@z

@x
@!char_base:array[internal_font_number] of integer;
  {base addresses for |char_info|}
@!width_base:array[internal_font_number] of integer;
  {base addresses for widths}
@!height_base:array[internal_font_number] of integer;
  {base addresses for heights}
@!depth_base:array[internal_font_number] of integer;
  {base addresses for depths}
@!italic_base:array[internal_font_number] of integer;
  {base addresses for italic corrections}
@!lig_kern_base:array[internal_font_number] of integer;
  {base addresses for ligature/kerning programs}
@!kern_base:array[internal_font_number] of integer;
  {base addresses for kerns}
@!exten_base:array[internal_font_number] of integer;
  {base addresses for extensible recipes}
@!param_base:array[internal_font_number] of integer;
  {base addresses for font parameters}
@y
@!char_base: ^integer;
  {base addresses for |char_info|}
@!width_base: ^integer;
  {base addresses for widths}
@!height_base: ^integer;
  {base addresses for heights}
@!depth_base: ^integer;
  {base addresses for depths}
@!italic_base: ^integer;
  {base addresses for italic corrections}
@!lig_kern_base: ^integer;
  {base addresses for ligature/kerning programs}
@!kern_base: ^integer;
  {base addresses for kerns}
@!exten_base: ^integer;
  {base addresses for extensible recipes}
@!param_base: ^integer;
  {base addresses for font parameters}
@z

@x
for k:=font_base to font_max do font_used[k]:=false;
@y
@z

@x
font_ptr:=null_font; fmem_ptr:=7;
font_name[null_font]:="nullfont"; font_area[null_font]:="";
hyphen_char[null_font]:="-"; skew_char[null_font]:=-1;
bchar_label[null_font]:=non_address;
font_bchar[null_font]:=non_char; font_false_bchar[null_font]:=non_char;
font_bc[null_font]:=1; font_ec[null_font]:=0;
font_size[null_font]:=0; font_dsize[null_font]:=0;
char_base[null_font]:=0; width_base[null_font]:=0;
height_base[null_font]:=0; depth_base[null_font]:=0;
italic_base[null_font]:=0; lig_kern_base[null_font]:=0;
kern_base[null_font]:=0; exten_base[null_font]:=0;
font_glue[null_font]:=null; font_params[null_font]:=7;
param_base[null_font]:=-1;
for k:=0 to 6 do font_info[k].sc:=0;
@y
@z

@x
as fast as possible under the circumstances.
@^inner loop@>

@d char_info_end(#)==#].qqqq
@d char_info(#)==font_info[char_base[#]+char_info_end
@y
as fast as possible under the circumstances.
@^inner loop@>

ML\TeX{} will assume that a character |c| exists iff either exists in
the current font or a character substitution definition for this
character was defined using \.{\\charsubdef}.  To avoid the
distinction between these two cases, ML\TeX{} introduces the notion
``effective character'' of an input character |c|.  If |c| exists in
the current font, the effective character of |c| is the character |c|
itself.  If it doesn't exist but a character substitution is defined,
the effective character of |c| is the base character defined in the
character substitution.  If there is an effective character for a
non-existing character |c|, the ``virtual character'' |c| will get
appended to the horizontal lists.

The effective character is used within |char_info| to access
appropriate character descriptions in the font.  For example, when
calculating the width of a box, ML\TeX{} will use the metrics of the
effective characters.  For the case of a substitution, ML\TeX{} uses
the metrics of the base character, ignoring the metrics of the accent
character.

If character substitutions are changed, it will be possible that a
character |c| neither exists in a font nor there is a valid character
substitution for |c|.  To handle these cases |effective_char| should
be called with its first argument set to |true| to ensure that it
will still return an existing character in the font.  If neither |c|
nor the substituted base character in the current character
substitution exists, |effective_char| will output a warning and
return the character |font_bc[f]| (which is incorrect, but can not be
changed within the current framework).

Sometimes character substitutions are unwanted, therefore the
original definition of |char_info| can be used using the macro
|orig_char_info|.  Operations in which character substitutions should
be avoided are, for example, loading a new font and checking the font
metric information in this font, and character accesses in math mode.

@d char_list_exists(#)==(char_sub_code(#)>hi(0))
@d char_list_accent(#)==(ho(char_sub_code(#)) div 256)
@d char_list_char(#)==(ho(char_sub_code(#)) mod 256)
@#
@d char_info_end(#)== #@=)@>].qqqq
@d char_info(#)==
  font_info[char_base[#]+effective_char@=(@>true,#,char_info_end
@#
@d orig_char_info_end(#)==#].qqqq
@d orig_char_info(#)==font_info[char_base[#]+orig_char_info_end
@#
@z

@x
@p function read_font_info(@!u:pointer;@!nom,@!aire:str_number;
@y
@p @t\4@>@<Declare additional functions for ML\TeX@>@/

function read_font_info(@!u:pointer;@!nom,@!aire:str_number;
@z

@x
@!file_opened:boolean; {was |tfm_file| successfully opened?}
@y
@!name_too_long:boolean; {|nom| or |aire| exceeds 255 bytes?}
@!file_opened:boolean; {was |tfm_file| successfully opened?}
@z

@x
@!z:scaled; {the design size or the ``at'' size}
@!alpha:integer;@!beta:1..16;
  {auxiliary quantities used in fixed-point multiplication}
@y
@!z:scaled; {the design size or the ``at'' size}
@!alpha:integer;@!beta:1..16;
  {auxiliary quantities used in fixed-point multiplication}
@!temp:integer; {store possible japanese font identifying number}
@z

@x
else print(" not loadable: Metric (TFM) file not found");
@y
else if name_too_long then print(" not loadable: Metric (TFM) file name too long")
else print(" not loadable: Metric (TFM) file not found");
@z

@x
if aire="" then pack_file_name(nom,TEX_font_area,".tfm")
else pack_file_name(nom,aire,".tfm");
@y
name_too_long:=(length(nom)>255)or(length(aire)>255);
if name_too_long then abort;
{|kpse_find_file| will append the |".tfm"|, and avoid searching the disk
 before the font alias files as well.}
pack_file_name(nom,aire,"");
@z

@x
@d fget==get(tfm_file)
@d fbyte==tfm_file^
@y
@d fget==tfm_temp:=getc(tfm_file)
@d fbyte==tfm_temp
@z

@x
while lh>2 do
  begin fget;fget;fget;fget;decr(lh); {ignore the rest of the header}
  end;
@y
if lh>2 then begin fget; temp:=fbyte; fget; temp:=temp*@'400+fbyte;
fget; temp:=temp*@'400+fbyte; fget; temp:=temp*@'400+fbyte; decr(lh); end;
if temp=142857 then {this is a japanese sub fonts!}
 begin fget; fget; fget; fget; j_font_table[f]:=fbyte; decr(lh); end
	{sub font number in |j_font_table| if this is a japanese sub font}
else j_font_table[f]:=0;
while lh>2 do
  begin fget;fget;fget;fget;decr(lh); {ignore the rest of the header}
  end;
@z

@x
  begin qw:=char_info(f)(d);
@y
  begin qw:=orig_char_info(f)(d);
@z

@x
  qw:=char_info(f)(#); {N.B.: not |qi(#)|}
@y
  qw:=orig_char_info(f)(#); {N.B.: not |qi(#)|}
@z

@x
if eof(tfm_file) then abort;
@y
if feof(tfm_file) then abort;
@z

@x
  begin qw:=char_info(f)(bchar); {N.B.: not |qi(bchar)|}
@y
  begin qw:=orig_char_info(f)(bchar); {N.B.: not |qi(bchar)|}
@z

@x
@<Declare procedures that scan font-related stuff@>=
procedure scan_font_ident;
@y
@<Declare procedures that scan font-related stuff@>=
procedure load_dfont_proc; forward;
procedure scan_font_ident;
@z

@x
else if cur_cmd=def_family then
  begin m:=cur_chr; scan_four_bit_int; f:=equiv(m+cur_val);
  end
@y
else if cur_cmd=def_family then
  begin m:=cur_chr; scan_four_bit_int; f:=equiv(m+cur_val);
  end
else if cur_cmd=def_dfont then f:=cur_font
else if cur_cmd=demmand_font then
  begin load_dfont_proc; f:=cur_chr;
  end
@z

@x
@p function new_character(@!f:internal_font_number;@!c:eight_bits):pointer;
label exit;
var p:pointer; {newly allocated node}
begin if font_bc[f]<=c then if font_ec[f]>=c then
  if char_exists(char_info(f)(qi(c))) then
@y

This allows a character node to be used if there is an equivalent
in the |char_sub_code| list.

@p function new_character(@!f:internal_font_number;@!c:eight_bits):pointer;
label exit;
var p:pointer; {newly allocated node}
@!ec:quarterword;  {effective character of |c|}
begin ec:=effective_char(false,f,qi(c));
if font_bc[f]<=qo(ec) then if font_ec[f]>=qo(ec) then
  if char_exists(orig_char_info(f)(ec)) then  {N.B.: not |char_info|}
@z

@x
@!c,@!f:quarterword; {character and font in current |char_node|}
@y
 {character and font in current |char_node|}
@!c:quarterword;
@!f:internal_font_number;
@z

@x
@!dvi_buf:array[dvi_index] of eight_bits; {buffer for \.{DVI} output}
@!half_buf:dvi_index; {half of |dvi_buf_size|}
@!dvi_limit:dvi_index; {end of the current half buffer}
@!dvi_ptr:dvi_index; {the next available buffer address}
@y
@!dvi_buf:^eight_bits; {buffer for \.{DVI} output}
@!half_buf:integer; {half of |dvi_buf_size|}
@!dvi_limit:integer; {end of the current half buffer}
@!dvi_ptr:integer; {the next available buffer address}
@z

@x
@p procedure write_dvi(@!a,@!b:dvi_index);
var k:dvi_index;
begin for k:=a to b do write(dvi_file,dvi_buf[k]);
end;
@y
In C, we use a macro to call |fwrite| or |write| directly, writing all
the bytes in one shot.  Much better even than writing four
bytes at a time.
@z

@x
each time, we use the macro |dvi_out|.
@y
each time, we use the macro |dvi_out|.

The length of |dvi_file| should not exceed |@"7FFFFFFF|; we set |cur_s:=-2|
to prevent further \.{DVI} output causing infinite recursion.
@z

@x
begin if dvi_limit=dvi_buf_size then
@y
begin if dvi_ptr>(@"7FFFFFFF-dvi_offset) then
  begin cur_s:=-2;
  fatal_error("dvi length exceeds ""7FFFFFFF");
@.dvi length exceeds...@>
  end;
if dvi_limit=dvi_buf_size then
@z

@x
if dvi_ptr>0 then write_dvi(0,dvi_ptr-1)
@y
if dvi_ptr>(@"7FFFFFFF-dvi_offset) then
  begin cur_s:=-2;
  fatal_error("dvi length exceeds ""7FFFFFFF");
@.dvi length exceeds...@>
  end;
if dvi_ptr>0 then write_dvi(0,dvi_ptr-1)
@z

@x
begin dvi_out(fnt_def1);
dvi_out(f-font_base-1);@/
@y
begin if f<=256+font_base then
  begin dvi_out(fnt_def1);
  dvi_out(f-font_base-1);
  end
else begin dvi_out(fnt_def1+1);
  dvi_out((f-font_base-1) div @'400);
  dvi_out((f-font_base-1) mod @'400);
  end;
@z

@x
  old_setting:=selector; selector:=new_string;
@y
if output_comment then
  begin l:=strlen(output_comment); dvi_out(l);
  for s:=0 to l-1 do dvi_out(output_comment[s]);
  end
else begin {the default code is unchanged}
  old_setting:=selector; selector:=new_string;
@z

@x
  end
@y
end;
  end
@z

@x
procedure hlist_out; {output an |hlist_node| box}
label reswitch, move_past, fin_rule, next_p;
@y
procedure hlist_out; {output an |hlist_node| box}
label reswitch, move_past, fin_rule, next_p, continue, found;
@z

@x
reaching a non-|char_node|. The program uses the fact that |set_char_0=0|.
@^inner loop@>
@y
reaching a non-|char_node|. The program uses the fact that |set_char_0=0|.

In ML\TeX{} this part looks for the existence of a substitution
definition for a character |c|, if |c| does not exist in the font,
and create appropriate \.{DVI} commands.  Former versions of ML\TeX{}
have spliced appropriate character, kern, and box nodes into the
horizontal list.
%
% 91/05/08 \charsubdefmax bug detected by Bernd Raichle
Because the user can change character substitions or
\.{\\charsubdefmax} on the fly, we have to test a again
for valid substitutions.
%
% 93/10/29 \leaders bug detected by Eberhard Mattes
(Additional it is necessary to be careful---if leaders are used
the current hlist is normally traversed more than once!)
@^inner loop@>
@z

@x
  if c>=qi(128) then dvi_out(set1);
  dvi_out(qo(c));@/
  cur_h:=cur_h+char_width(f)(char_info(f)(c));
@y
  if font_ec[f]>=qo(c) then if font_bc[f]<=qo(c) then
    if char_exists(orig_char_info(f)(c)) then  {N.B.: not |char_info|}
      begin if c>=qi(128) then dvi_out(set1);
      dvi_out(qo(c));@/
      cur_h:=cur_h+char_width(f)(orig_char_info(f)(c));
      goto continue;
      end;
  if mltex_enabled_p then
    @<Output a substitution, |goto continue| if not possible@>;
continue:
@z

@x
else  begin dvi_out(fnt1); dvi_out(f-font_base-1);
  end;
@y
else if f<=256+font_base then
  begin dvi_out(fnt1); dvi_out(f-font_base-1);
  end
else begin dvi_out(fnt1+1);
  dvi_out((f-font_base-1) div @'400);
  dvi_out((f-font_base-1) mod @'400);
  end;
@z

@x
done:
@y
ifdef ('IPC')
if ipc_on>0 then
  begin if dvi_limit=half_buf then
    begin write_dvi(half_buf, dvi_buf_size-1);
    flush_dvi;
    dvi_gone:=dvi_gone+half_buf;
    end;
  if dvi_ptr>(@"7FFFFFFF-dvi_offset) then
    begin cur_s:=-2;
    fatal_error("dvi length exceeds ""7FFFFFFF");
@.dvi length exceeds...@>
    end;
  if dvi_ptr>0 then
    begin write_dvi(0, dvi_ptr-1);
    flush_dvi;
    dvi_offset:=dvi_offset+dvi_ptr; dvi_gone:=dvi_gone+dvi_ptr;
    end;
  dvi_ptr:=0; dvi_limit:=dvi_buf_size;
  ipc_page(dvi_gone);
  end;
endif ('IPC');
done:
@z

@x
else  begin dvi_out(post); {beginning of the postamble}
@y
else if cur_s<>-2 then
  begin dvi_out(post); {beginning of the postamble}
@z

@x
  k:=4+((dvi_buf_size-dvi_ptr) mod 4); {the number of 223's}
@y
ifdef ('IPC')
  k:=7-((3+dvi_offset+dvi_ptr) mod 4); {the number of 223's}
endif ('IPC')
ifndef ('IPC')
  k:=4+((dvi_buf_size-dvi_ptr) mod 4); {the number of 223's}
endifn ('IPC')
@z

@x
  print_nl("Output written on "); slow_print(output_file_name);
@y
  print_nl("Output written on "); print_file_name(0, output_file_name, 0);
@z

@x
  print(" ("); print_int(total_pages); print(" page");
  if total_pages<>1 then print_char("s");
@y
  print(" ("); print_int(total_pages);
  if total_pages<>1 then print(" pages")
  else print(" page");
@z

@x
@* \[33] Packaging.
@y

@ This function used to be in pdftex, but is useful in tex too.

@p function get_nullstr: str_number;
begin
    get_nullstr := "";
end;

@* \[33] Packaging.

@z

@x
if (qo(y)>=font_bc[g])and(qo(y)<=font_ec[g]) then
  begin continue: q:=char_info(g)(y);
@y
if (qo(y)>=font_bc[g])and(qo(y)<=font_ec[g]) then
  begin continue: q:=orig_char_info(g)(y);
@z

@x
    cur_i:=char_info(cur_f)(cur_c)
@y
    cur_i:=orig_char_info(cur_f)(cur_c)
@z

@x
  i:=char_info(f)(y);
@y
  i:=orig_char_info(f)(y);
@z

@x
    begin c:=rem_byte(cur_i); i:=char_info(cur_f)(c);
@y
    begin c:=rem_byte(cur_i); i:=orig_char_info(cur_f)(c);
@z

@x
if abs(fit_class-fitness(r))>1 then d:=d+adj_demerits;
@y
if abs(intcast(fit_class)-intcast(fitness(r)))>1 then d:=d+adj_demerits;
@z

@x
  begin line_diff:=line_number(r)-best_line;
@y
  begin line_diff:=intcast(line_number(r))-intcast(best_line);
@z

@x
Comparatively few different number sequences $n_0\ldots n_k$ actually occur,
since most of the |n|'s are generally zero. Therefore the number sequences
are encoded in such a way that |trie_op|$(z_k)$ is only one byte long.
If |trie_op(@t$z_k$@>)<>min_quarterword|, when $p_1\ldots p_k$ has matched
the letters in |hc[(l-k+1)..l@,]| of language |t|,
we perform all of the required operations
for this pattern by carrying out the following little program: Set
|v:=trie_op(@t$z_k$@>)|. Then set |v:=v+op_start[t]|,
|hyf[l-hyf_distance[v]]:=@tmax@>(hyf[l-hyf_distance[v]], hyf_num[v])|,
and |v:=hyf_next[v]|; repeat, if necessary, until |v=min_quarterword|.
@y
The theory that comparatively few different number sequences $n_0\ldots n_k$
actually occur, since most of the |n|'s are generally zero, seems to fail
at least for the large German hyphenation patterns.
Therefore the number sequences cannot any longer be encoded in such a way
that |trie_op|$(z_k)$ is only one byte long.
We have introduced a new constant |max_trie_op| for the maximum allowable
hyphenation operation code value; |max_trie_op| might be different for
\TeX\ and \.{INITEX} and must not exceed |max_halfword|.
An opcode will occupy a halfword if |max_trie_op| exceeds |max_quarterword|
or a quarterword otherwise.
@^system dependencies@>
If |trie_op(@t$z_k$@>)<>min_trie_op|, when $p_1\ldots p_k$ has matched
the letters in |hc[(l-k+1)..l@,]| of language |t|,
we perform all of the required operations
for this pattern by carrying out the following little program: Set
|v:=trie_op(@t$z_k$@>)|. Then set |v:=v+op_start[t]|,
|hyf[l-hyf_distance[v]]:=@tmax@>(hyf[l-hyf_distance[v]], hyf_num[v])|,
and |v:=hyf_next[v]|; repeat, if necessary, until |v=min_trie_op|.
@z

@x
@!trie_pointer=0..trie_size; {an index into |trie|}
@y
@!trie_pointer=0..ssup_trie_size; {an index into |trie|}
@!trie_opcode=0..ssup_trie_opcode;  {a trie opcode}
@z

@x
@ @d trie_link(#)==trie[#].rh {``downward'' link in a trie}
@d trie_char(#)==trie[#].b1 {character matched at this trie location}
@d trie_op(#)==trie[#].b0 {program for hyphenation at this trie location}
@y
@ For more than 255 trie op codes, the three fields |trie_link|, |trie_char|,
and |trie_op| will no longer fit into one memory word; thus using web2c
we define |trie| as three array instead of an array of records.
The variant will be implented by reusing the opcode field later on with
another macro.

@d trie_link(#)==trie_trl[#] {``downward'' link in a trie}
@d trie_char(#)==trie_trc[#] {character matched at this trie location}
@d trie_op(#)==trie_tro[#] {program for hyphenation at this trie location}
@z

@x
@!trie:array[trie_pointer] of two_halves; {|trie_link|, |trie_char|, |trie_op|}
@y
{We will dynamically allocate these arrays.}
@!trie_trl:^trie_pointer; {|trie_link|}
@!trie_tro:^trie_pointer; {|trie_op|}
@!trie_trc:^quarterword; {|trie_char|}
@z

@x
@!hyf_next:array[1..trie_op_size] of quarterword; {continuation code}
@y
@!hyf_next:array[1..trie_op_size] of trie_opcode; {continuation code}
@z

@x
    begin if trie_op(z)<>min_quarterword then
@y
    begin if trie_op(z)<>min_trie_op then
@z

@x
until v=min_quarterword;
@y
until v=min_trie_op;
@z

@x
different from $\alpha$, we can conclude that $\alpha$ is not in the table.
@y
different from $\alpha$, we can conclude that $\alpha$ is not in the table.
This is a clever scheme which saves the need for a hash link array.
However, it is difficult to increase the size of the hyphen exception
arrays. To make this easier, the ordered hash has been replaced by
a simple hash, using an additional array |hyph_link|. The value
|0| in |hyph_link[k]| means that there are no more entries corresponding
to the specific hash chain. When |hyph_link[k]>0|, the next entry in
the hash chain is |hyph_link[k]-1|. This value is used because the
arrays start at |0|.
@z

@x
@!hyph_pointer=0..hyph_size; {an index into the ordered hash table}
@y
@!hyph_pointer=0..ssup_hyph_size; {index into hyphen exceptions hash table;
                     enlarging this requires changing (un)dump code}
@z

@x
@!hyph_word:array[hyph_pointer] of str_number; {exception words}
@!hyph_list:array[hyph_pointer] of pointer; {lists of hyphen positions}
@!hyph_count:hyph_pointer; {the number of words in the exception dictionary}
@y
@!hyph_word: ^str_number; {exception words}
@!hyph_list: ^pointer; {lists of hyphen positions}
@!hyph_link: ^hyph_pointer; {link array for hyphen exceptions hash table}
@!hyph_count:integer; {the number of words in the exception dictionary}
@!hyph_next:integer; {next free slot in hyphen exceptions hash table}
@z

@x
for z:=0 to hyph_size do
  begin hyph_word[z]:=0; hyph_list[z]:=null;
  end;
hyph_count:=0;
@y
for z:=0 to hyph_size do
  begin hyph_word[z]:=0; hyph_list[z]:=null; hyph_link[z]:=0;
  end;
hyph_count:=0;
hyph_next:=hyph_prime+1; if hyph_next>hyph_size then hyph_next:=hyph_prime;
@z

@x
h:=hc[1]; incr(hn); hc[hn]:=cur_lang;
for j:=2 to hn do h:=(h+h+hc[j]) mod hyph_size;
loop@+  begin @<If the string |hyph_word[h]| is less than \(hc)|hc[1..hn]|,
    |goto not_found|; but if the two strings are equal,
    set |hyf| to the hyphen positions and |goto found|@>;
  if h>0 then decr(h)@+else h:=hyph_size;
  end;
not_found: decr(hn)
@y
h:=hc[1]; incr(hn); hc[hn]:=cur_lang;
for j:=2 to hn do h:=(h+h+hc[j]) mod hyph_prime;
loop@+  begin @<If the string |hyph_word[h]| is less than \(hc)|hc[1..hn]|,
    |goto not_found|; but if the two strings are equal,
    set |hyf| to the hyphen positions and |goto found|@>;
  h:=hyph_link[h]; if h=0 then goto not_found;
  decr(h);
  end;
not_found: decr(hn)
@z

@x
@ @<If the string |hyph_word[h]| is less than \(hc)...@>=
k:=hyph_word[h]; if k=0 then goto not_found;
if length(k)<hn then goto not_found;
@y
@ @<If the string |hyph_word[h]| is less than \(hc)...@>=
{This is now a simple hash list, not an ordered one, so
the module title is no longer descriptive.}
k:=hyph_word[h]; if k=0 then goto not_found;
@z

@x
  repeat if so(str_pool[u])<hc[j] then goto not_found;
  if so(str_pool[u])>hc[j] then goto done;
@y
  repeat
  if so(str_pool[u])<>hc[j] then goto done;
@z

@x
@!s,@!t:str_number; {strings being compared or stored}
@y
@!s:str_number; {strings being compared or stored}
@z

@x
  begin h:=(h+h+hc[j]) mod hyph_size;
@y
  begin h:=(h+h+hc[j]) mod hyph_prime;
@z

@x
@ @<Insert the \(p)pair |(s,p)|...@>=
if hyph_count=hyph_size then overflow("exception dictionary",hyph_size);
@:TeX capacity exceeded exception dictionary}{\quad exception dictionary@>
incr(hyph_count);
while hyph_word[h]<>0 do
  begin @<If the string |hyph_word[h]| is less than \(or)or equal to
  |s|, interchange |(hyph_word[h],hyph_list[h])| with |(s,p)|@>;
  if h>0 then decr(h)@+else h:=hyph_size;
  end;
hyph_word[h]:=s; hyph_list[h]:=p
@y
@ @<Insert the \(p)pair |(s,p)|...@>=
  if hyph_next <= hyph_prime then
     while (hyph_next>0) and (hyph_word[hyph_next-1]>0) do decr(hyph_next);
if (hyph_count=hyph_size)or(hyph_next=0) then
   overflow("exception dictionary",hyph_size);
@:TeX capacity exceeded exception dictionary}{\quad exception dictionary@>
incr(hyph_count);
while hyph_word[h]<>0 do
  begin @<If the string |hyph_word[h]| is less than \(or)or equal to
  |s|, interchange |(hyph_word[h],hyph_list[h])| with |(s,p)|@>;
  if hyph_link[h]=0 then
  begin
    hyph_link[h]:=hyph_next;
    if hyph_next >= hyph_size then hyph_next:=hyph_prime;
    if hyph_next > hyph_prime then incr(hyph_next);
  end;
  h:=hyph_link[h]-1;
  end;

found: hyph_word[h]:=s; hyph_list[h]:=p
@z

@x
@ @<If the string |hyph_word[h]| is less than \(or)...@>=
k:=hyph_word[h];
if length(k)<length(s) then goto found;
if length(k)>length(s) then goto not_found;
@y
@ @<If the string |hyph_word[h]| is less than \(or)...@>=
{This is now a simple hash list, not an ordered one, so
the module title is no longer descriptive.}
k:=hyph_word[h];
if length(k)<>length(s) then goto not_found;
@z

@x
repeat if str_pool[u]<str_pool[v] then goto found;
if str_pool[u]>str_pool[v] then goto not_found;
@y
repeat if str_pool[u]<>str_pool[v] then goto not_found;
@z

@x
found:q:=hyph_list[h]; hyph_list[h]:=p; p:=q;@/
t:=hyph_word[h]; hyph_word[h]:=s; s:=t;
not_found:
@y
{repeat hyphenation exception; flushing old data}
flush_string; s:=hyph_word[h]; {avoid |slow_make_string|!}
decr(hyph_count);
{ We could also |flush_list(hyph_list[h]);|, but it interferes
  with \.{trip.log}. }
goto found;
not_found:
@z

@x
|hyf_next[@t$v^\prime$@>]=min_quarterword|.
@y
|hyf_next[@t$v^\prime$@>]=min_trie_op|.
@z

@x
$$\hbox{|@t$v^\prime$@>:=new_trie_op(0,1,min_quarterword)|,\qquad
@y
$$\hbox{|@t$v^\prime$@>:=new_trie_op(0,1,min_trie_op)|,\qquad
@z

@x
@!init@! trie_op_hash:array[-trie_op_size..trie_op_size] of 0..trie_op_size;
@y
@!init@! trie_op_hash:array[neg_trie_op_size..trie_op_size] of 0..trie_op_size;
@z

@x
@!trie_used:array[ASCII_code] of quarterword;
@y
@!trie_used:array[ASCII_code] of trie_opcode;
@z

@x
@!trie_op_val:array[1..trie_op_size] of quarterword;
@y
@!trie_op_val:array[1..trie_op_size] of trie_opcode;
@z

@x
tini
@y
tini@;
@!max_op_used:trie_opcode; {largest opcode used for any language}
@!small_op:boolean; {flag used while dumping or undumping}
@z

@x
|new_trie_op| could return |min_quarterword| (thereby simply ignoring
@y
|new_trie_op| could return |min_trie_op| (thereby simply ignoring
@z

@x
function new_trie_op(@!d,@!n:small_number;@!v:quarterword):quarterword;
label exit;
var h:-trie_op_size..trie_op_size; {trial hash location}
@!u:quarterword; {trial op code}
@y
function new_trie_op(@!d,@!n:small_number;@!v:trie_opcode):trie_opcode;
label exit;
var h:neg_trie_op_size..trie_op_size; {trial hash location}
@!u:trie_opcode; {trial op code}
@z

@x
begin h:=abs(n+313*d+361*v+1009*cur_lang) mod (trie_op_size+trie_op_size)
  - trie_op_size;
@y
begin h:=abs(intcast(n)+313*intcast(d)+361*intcast(v)+1009*intcast(cur_lang))
  mod (trie_op_size - neg_trie_op_size)
  + neg_trie_op_size;
@z

@x
    if u=max_quarterword then
      overflow("pattern memory ops per language",
        max_quarterword-min_quarterword);
    incr(trie_op_ptr); incr(u); trie_used[cur_lang]:=u;
@y
    if u=max_trie_op then
      overflow("pattern memory ops per language",
      max_trie_op-min_trie_op);
    incr(trie_op_ptr); incr(u); trie_used[cur_lang]:=u;
    if u>max_op_used then max_op_used:=u;
@z

@x
op_start[0]:=-min_quarterword;
@y
op_start[0]:=-min_trie_op;
@z

@x
for k:=0 to 255 do trie_used[k]:=min_quarterword;
@y
for k:=0 to 255 do trie_used[k]:=min_trie_op;
@z

@x
trie_op_ptr:=0;
@y
max_op_used:=min_trie_op;
trie_op_ptr:=0;
@z

@x
@!init @!trie_c:packed array[trie_pointer] of packed_ASCII_code;
  {characters to match}
@t\hskip10pt@>@!trie_o:packed array[trie_pointer] of quarterword;
  {operations to perform}
@t\hskip10pt@>@!trie_l:packed array[trie_pointer] of trie_pointer;
  {left subtrie links}
@t\hskip10pt@>@!trie_r:packed array[trie_pointer] of trie_pointer;
  {right subtrie links}
@t\hskip10pt@>@!trie_ptr:trie_pointer; {the number of nodes in the trie}
@t\hskip10pt@>@!trie_hash:packed array[trie_pointer] of trie_pointer;
  {used to identify equivalent subtries}
tini
@y
@!init @!trie_c:^packed_ASCII_code;
  {characters to match}
@t\hskip10pt@>@!trie_o:^trie_opcode;
  {operations to perform}
@t\hskip10pt@>@!trie_l:^trie_pointer;
  {left subtrie links}
@t\hskip10pt@>@!trie_r:^trie_pointer;
  {right subtrie links}
@t\hskip10pt@>@!trie_ptr:trie_pointer; {the number of nodes in the trie}
@t\hskip10pt@>@!trie_hash:^trie_pointer;
  {used to identify equivalent subtries}
tini
@z

@x
begin h:=abs(trie_c[p]+1009*trie_o[p]+@|
    2718*trie_l[p]+3142*trie_r[p]) mod trie_size;
@y
begin h:=abs(intcast(trie_c[p])+1009*intcast(trie_o[p])+@|
    2718*intcast(trie_l[p])+3142*intcast(trie_r[p])) mod trie_size;
@z

@x
@d trie_back(#)==trie[#].lh {backward links in |trie| holes}
@y
@d trie_back(#)==trie_tro[#] {use the opcode field now for backward links}
@z

@x
@!init@!trie_taken:packed array[1..trie_size] of boolean;
  {does a family start here?}
@t\hskip10pt@>@!trie_min:array[ASCII_code] of trie_pointer;
  {the first possible slot for each character}
@t\hskip10pt@>@!trie_max:trie_pointer; {largest location used in |trie|}
@t\hskip10pt@>@!trie_not_ready:boolean; {is the trie still in linked form?}
tini
@y
@!init@!trie_taken: ^boolean;
  {does a family start here?}
@t\hskip10pt@>@!trie_min:array[ASCII_code] of trie_pointer;
  {the first possible slot for each character}
@t\hskip10pt@>@!trie_max:trie_pointer; {largest location used in |trie|}
@t\hskip10pt@>@!trie_not_ready:boolean; {is the trie still in linked form?}
tini
@z

@x
trie_not_ready:=true; trie_root:=0; trie_c[0]:=si(0); trie_ptr:=0;
@y
trie_not_ready:=true;
@z

@x
@<Move the data into |trie|@>=
h.rh:=0; h.b0:=min_quarterword; h.b1:=min_quarterword; {|trie_link:=0|,
  |trie_op:=min_quarterword|, |trie_char:=qi(0)|}
@y
@d clear_trie == {clear |trie[r]|}
  begin trie_link(r):=0;
  trie_op(r):=min_trie_op;
  trie_char(r):=min_quarterword; {|trie_char:=qi(0)|}
  end

@<Move the data into |trie|@>=
@z

@x
  begin for r:=0 to 256 do trie[r]:=h;
@y
  begin for r:=0 to 256 do clear_trie;
@z

@x
  repeat s:=trie_link(r); trie[r]:=h; r:=s;
@y
  repeat s:=trie_link(r); clear_trie; r:=s;
@z

@x
@!v:quarterword; {trie op code}
@y
@!v:trie_opcode; {trie op code}
@z

@x
if trie_o[q]<>min_quarterword then
@y
if trie_o[q]<>min_trie_op then
@z

@x
trie_c[p]:=si(c); trie_o[p]:=min_quarterword;
@y
trie_c[p]:=si(c); trie_o[p]:=min_trie_op;
@z

@x
l:=k; v:=min_quarterword;
@y
l:=k; v:=min_trie_op;
@z

@x
@!h:two_halves; {template used to zero out |trie|'s holes}
@y
@z

@x
@p @t\4@>@<Declare action procedures for use by |main_control|@>@;
@y
@p @t\4@>@<Declare subprocedures needed for delayed font@>@;@/
@t\4@>@<Declare action procedures for use by |main_control|@>@;
@z

@x
var@!t:integer; {general-purpose temporary variable}
begin if every_job<>null then begin_token_list(every_job,every_job_text);
big_switch: get_x_token;@/
reswitch: @<Give diagnostic information, if requested@>;
case abs(mode)+cur_cmd of
hmode+letter,hmode+other_char,hmode+char_given: goto main_loop;
hmode+char_num: begin scan_char_num; cur_chr:=cur_val; goto main_loop;@+end;
@y
var@!t:integer; {general-purpose temporary variable}
@!p:pointer; {general-purpose temporary variable}
@!prev_cmd:eight_bits; {the previous command}
@!temp_cmd:eight_bits; {to restore right |cur_cmd| after |scan_char_num|}
begin if every_job<>null then begin_token_list(every_job,every_job_text);
big_switch: get_x_token;@/
reswitch: @<Give diagnostic information, if requested@>;
case abs(mode)+cur_cmd of
hmode+letter,hmode+jletter,hmode+other_char,hmode+char_given: goto main_loop;
hmode+char_num: begin temp_cmd:=cur_cmd;
 scan_j_char_num; if cur_val>=256 then cur_cmd:=jletter else
 cur_cmd:=temp_cmd; cur_chr:=cur_val; goto main_loop;@+end;
hmode+faker: goto main_loop_lookahead;
vmode+faker,mmode+faker: do_nothing;
@z

@x
  main_s:=sf_code(cur_chr);
  if main_s=1000 then space_factor:=1000
  else if main_s<1000 then
    begin if main_s>0 then space_factor:=main_s;
    end
  else if space_factor<1000 then space_factor:=1000
  else space_factor:=main_s
@y
  if cur_cmd=jletter then space_factor:=1000
  else begin
  main_s:=sf_code(cur_chr);
  if main_s=1000 then space_factor:=1000
  else if main_s<1000 then
    begin if main_s>0 then space_factor:=main_s;
    end
  else if space_factor<1000 then space_factor:=1000
  else space_factor:=main_s
  end
@z

@x
@<Append character |cur_chr|...@>=
@y
@<Append character |cur_chr|...@>=
if ((head=tail) and (mode>0)) then begin
  if (insert_src_special_auto) then append_src_special;
end;
@z

@x
main_f:=cur_font;
bchar:=font_bchar[main_f]; false_bchar:=font_false_bchar[main_f];
if mode>0 then if language<>clang then fix_language;
fast_get_avail(lig_stack); font(lig_stack):=main_f; cur_l:=qi(cur_chr);
character(lig_stack):=cur_l;@/
@y
if cur_cmd=jletter then begin
  main_f:=font_jsubf(jchr_subfont(cur_chr));
  cur_l:=jchr_char(cur_chr); main_c:=qo(cur_l);
  @<Kinsoku shori; insert or omit glue before jletter@>;
  end
else begin
  main_f:=cur_font; cur_l:=qi(cur_chr); main_c:=cur_chr;
  @<Kinsoku shori; insert or omit glue after jletter@>;
  end;
bchar:=font_bchar[main_f]; false_bchar:=font_false_bchar[main_f];
if mode>0 then if language<>clang then fix_language;
fast_get_avail(lig_stack); font(lig_stack):=main_f;
character(lig_stack):=cur_l;@/
@z

@x
@d pack_lig(#)== {the parameter is either |rt_hit| or |false|}
  begin main_p:=new_ligature(main_f,cur_l,link(cur_q));
@y
@d pack_lig(#)== {the parameter is either |rt_hit| or |false|}
  begin main_p:=new_ligature(cur_font,cur_l,link(cur_q));
@z

@x
main_loop_move+1:if not is_char_node(lig_stack) then goto main_loop_move_lig;
main_loop_move+2:if(cur_chr<font_bc[main_f])or(cur_chr>font_ec[main_f]) then
  begin char_warning(main_f,cur_chr); free_avail(lig_stack); goto big_switch;
  end;
main_i:=char_info(main_f)(cur_l);
if not char_exists(main_i) then
  begin char_warning(main_f,cur_chr); free_avail(lig_stack); goto big_switch;
  end;
@y
main_loop_move+1:if not is_char_node(lig_stack) then goto main_loop_move_lig;
main_loop_move+2:if(main_c<font_bc[main_f])or(main_c>font_ec[main_f]) then
  if @<|cur_chr| is jis space@> then begin {treat JIS space (!!) specially}
    @<Insert |jspaceskip|@>;
    @<set |main_i| for JIS space@>;
    free_avail(lig_stack);
    goto main_loop_lookahead;
    end
  else begin char_warning(main_f,main_c); free_avail(lig_stack);
    goto big_switch;
    end;
main_i:=char_info(main_f)(cur_l);
if not char_exists(main_i) then
  begin char_warning(main_f,main_c); free_avail(lig_stack); goto big_switch;
  end;
@z

@x
get_next; {set only |cur_cmd| and |cur_chr|, for speed}
if cur_cmd=letter then goto main_loop_lookahead+1;
if cur_cmd=other_char then goto main_loop_lookahead+1;
if cur_cmd=char_given then goto main_loop_lookahead+1;
x_token; {now expand and set |cur_cmd|, |cur_chr|, |cur_tok|}
if cur_cmd=letter then goto main_loop_lookahead+1;
if cur_cmd=other_char then goto main_loop_lookahead+1;
if cur_cmd=char_given then goto main_loop_lookahead+1;
if cur_cmd=char_num then
  begin scan_char_num; cur_chr:=cur_val; goto main_loop_lookahead+1;
  end;
if cur_cmd=no_boundary then bchar:=non_char;
cur_r:=bchar; lig_stack:=null; goto main_lig_loop;
main_loop_lookahead+1: adjust_space_factor;
fast_get_avail(lig_stack); font(lig_stack):=main_f;
cur_r:=qi(cur_chr); character(lig_stack):=cur_r;
if cur_r=false_bchar then cur_r:=non_char {this prevents spurious ligatures}
@y
prev_cmd:=cur_cmd; prev_c:=cur_chr;
get_next; {set only |cur_cmd| and |cur_chr|, for speed}
if cur_cmd=letter then goto main_loop_lookahead+1;
if cur_cmd=jletter then goto main_loop_lookahead+1;
if cur_cmd=other_char then goto main_loop_lookahead+1;
if cur_cmd=char_given then goto main_loop_lookahead+1;
x_token; {now expand and set |cur_cmd|, |cur_chr|, |cur_tok|}
if cur_cmd=letter then goto main_loop_lookahead+1;
if cur_cmd=jletter then goto main_loop_lookahead+1;
if cur_cmd=other_char then goto main_loop_lookahead+1;
if cur_cmd=char_given then goto main_loop_lookahead+1;
if cur_cmd=char_num then
  begin scan_j_char_num;
    if cur_val>=256 then {japanese character specified by |char_num|}
      begin cur_cmd:=jletter; cur_chr:=cur_val;
      end
    else begin cur_cmd:=letter; {any cmd but jletter is ok}
       cur_chr:=cur_val;
      end;
    goto main_loop_lookahead+1;
  end;
if cur_cmd=no_boundary then bchar:=non_char;
if prev_cmd=jletter then @<Right boundary of japanese char@>
else if prev_cmd=faker then goto reswitch;
cur_r:=bchar; lig_stack:=null; goto main_lig_loop;
main_loop_lookahead+1: adjust_space_factor;
fast_get_avail(lig_stack);
if cur_cmd=jletter then begin
    main_f:=font_jsubf(jchr_subfont(cur_chr));
    cur_r:=jchr_char(cur_chr); main_c:=qo(cur_r);
  end
else begin
    if (prev_cmd=jletter) or (prev_cmd=faker) then main_f:=cur_font;
    cur_r:=qi(cur_chr); main_c:=cur_chr;
  end;
font(lig_stack):=main_f;
character(lig_stack):=cur_r;
if cur_r=false_bchar then cur_r:=non_char; {this prevents spurious ligatures}
@<Kinsoku shori; insert or omit glue and |goto main_loop_move|,
  if |prev_cmd=jletter| or |cur_cmd=jletter|@>
@z

@x
vmode+letter,vmode+other_char,vmode+char_num,vmode+char_given,
@y
vmode+letter,vmode+jletter,vmode+other_char,vmode+char_num,vmode+char_given,
@z

@x
if indented then
  begin tail:=new_null_box; link(head):=tail; width(tail):=par_indent;@+
  end;
@y
if indented then
  begin tail:=new_null_box; link(head):=tail; width(tail):=par_indent;
  if (insert_src_special_every_par) then insert_src_special;@+
  end;
@z

@x
begin scan_char_num; f:=cur_font; p:=new_character(f,cur_val);
@y
begin scan_j_char_num; if cur_val>=256 then begin
f:=font_jsubf(jchr_subfont(cur_val));
p:=new_character(f,jchr_char(cur_val)); end else begin
f:=cur_font; p:=new_character(f,cur_val); end;
@z

@x
if (cur_cmd=letter)or(cur_cmd=other_char)or(cur_cmd=char_given) then
  q:=new_character(f,cur_chr)
else if cur_cmd=char_num then
  begin scan_char_num; q:=new_character(f,cur_val);
  end
else back_input
@y
if (cur_cmd=letter)or(cur_cmd=other_char)or(cur_cmd=char_given) then
  q:=new_character(f,cur_chr)
else if cur_cmd=jletter then begin
    f:=font_jsubf(jchr_subfont(cur_chr));
    q:=new_character(f,jchr_char(cur_chr)); end
  else if cur_cmd=char_num then
      begin scan_j_char_num;
        if cur_val>=256 then begin
          f:=font_jsubf(jchr_subfont(cur_val));
	  q:=new_character(f,jchr_char(cur_val)); end
        else q:=new_character(f,cur_val); end
  else back_input
@z

@x
if every_math<>null then begin_token_list(every_math,every_math_text);
@y
if (insert_src_special_every_math) then insert_src_special;
if every_math<>null then begin_token_list(every_math,every_math_text);
@z

@x
mmode+letter,mmode+other_char,mmode+char_given:
  set_math_char(ho(math_code(cur_chr)));
@y
mmode+letter,mmode+other_char,mmode+char_given:
  set_math_char(ho(math_code(cur_chr)));
mmode+jletter:
  if @<|cur_chr| is jis space@> then {treat JIS space (!!) specially}
    @<Insert |jspaceskip|@>
  else begin p:=new_noad;
    math_type(nucleus(p)):=sub_box;
    info(nucleus(p)):=
      char_box(font_jsubf(jchr_subfont(cur_chr)),jchr_char(cur_chr));
    tail_append(p);
  end;
@z

@x
  if every_vbox<>null then begin_token_list(every_vbox,every_vbox_text);
@y
  if (insert_src_special_every_vbox) then insert_src_special;
  if every_vbox<>null then begin_token_list(every_vbox,every_vbox_text);
@z

@x
@<Finish math in text@>=
begin tail_append(new_math(math_surround,before));
@y
@<Finish math in text@>=
begin
@<Kinsoku shori; insert or omit glue between jletter and math@>;
tail_append(new_math(math_surround,before));
@z

@x
any_mode(def_font),
@y
any_mode(def_font),
@<New prefixed commands@>
@z

@x
if (cur_cs=0)or(cur_cs>frozen_control_sequence) then
@y
if (cur_cs=0)or(cur_cs>eqtb_top)or
  ((cur_cs>frozen_control_sequence)and(cur_cs<=eqtb_size)) then
@z

@x
  if cur_cmd>=call then add_token_ref(cur_chr);
  define(p,cur_cmd,cur_chr);
@y
  if cur_cmd>=call then add_token_ref(cur_chr)
  else if cur_cmd=demmand_font then add_df_ref(cur_chr);
  define(p,cur_cmd,cur_chr);
@z

@x
@d toks_def_code=6 {|shorthand_def| for \.{\\toksdef}}
@y
@d toks_def_code=6 {|shorthand_def| for \.{\\toksdef}}
@d char_sub_def_code=7 {|shorthand_def| for \.{\\charsubdef}}
@z

@x
@!@:toks_def_}{\.{\\toksdef} primitive@>
@y
@!@:toks_def_}{\.{\\toksdef} primitive@>
if mltex_p then
  begin
  primitive("charsubdef",shorthand_def,char_sub_def_code);@/
@!@:char_sub_def_}{\.{\\charsubdef} primitive@>
  end;
@z

@x
  othercases print_esc("toksdef")
@y
  char_sub_def_code: print_esc("charsubdef");
  othercases print_esc("toksdef")
@z

@x
shorthand_def: begin n:=cur_chr; get_r_token; p:=cur_cs; define(p,relax,256);
@y
shorthand_def: if cur_chr=char_sub_def_code then
 begin scan_char_num; p:=char_sub_code_base+cur_val; scan_optional_equals;
  scan_char_num; n:=cur_val; {accent character in substitution}
  scan_char_num;
  if (tracing_char_sub_def>0) then
    begin begin_diagnostic; print_nl("New character substitution: ");
    print_ASCII(p-char_sub_code_base); print(" = ");
    print_ASCII(n); print_char(" ");
    print_ASCII(cur_val); end_diagnostic(false);
    end;
  n:=n*256+cur_val;
  define(p,data,hi(n));
  if (p-char_sub_code_base)<char_sub_def_min then
    word_define(int_base+char_sub_def_min_code,p-char_sub_code_base);
  if (p-char_sub_code_base)>char_sub_def_max then
    word_define(int_base+char_sub_def_max_code,p-char_sub_code_base);
 end
else begin n:=cur_chr; get_r_token; p:=cur_cs; define(p,relax,256);
@z

@x
    begin @!init new_patterns; goto done;@;@+tini@/
@y
    begin @!Init new_patterns; goto done;@;@+Tini@/
@z

@x
procedure new_font(@!a:small_number);
label common_ending;
var u:pointer; {user's font identifier}
@y
procedure new_font(@!a:small_number);
label common_ending;
var u:pointer; {user's font identifier}
@!save_jendline_type:integer;
@z

@x
@!flushable_string:str_number; {string not yet referenced}
@y
@z

@x
@ @<Scan the font size specification@>=
name_in_progress:=true; {this keeps |cur_name| from being changed}
@y
@ @<Scan the font size specification@>=
name_in_progress:=true; {this keeps |cur_name| from being changed}
save_jendline_type:=jendline_type; jendline_type:=jend_ascii;
@z

@x
else s:=-1000;
name_in_progress:=false
@y
else s:=-1000;
name_in_progress:=false; jendline_type:=save_jendline_type
@z

@x
flushable_string:=str_ptr-1;
@y
@z

@x
    begin if cur_name=flushable_string then
      begin flush_string; cur_name:=font_name[f];
      end;
    if s>0 then
@y
    begin if s>0 then
@z

@x
interaction:=cur_chr;
@y
interaction:=cur_chr;
if interaction = batch_mode
then kpse_make_tex_discard_errors := 1
else kpse_make_tex_discard_errors := 0;
@z

@x
  if cur_ext="" then cur_ext:=".tex";
  pack_cur_name;
  if a_open_in(read_file[n]) then read_open[n]:=just_open;
@y
  pack_cur_name;
  tex_input_type:=0; {Tell |open_input| we are \.{\\openin}.}
  if kpse_in_name_ok(stringcast(name_of_file+1))
     and a_open_in(read_file[n], kpse_tex_format) then
    begin k:=1;
    name_in_progress:=true;
    begin_name;
    stop_at_space:=false;
    while (k<=name_length)and(more_name(name_of_file[k])) do
      incr(k);
    stop_at_space:=true;
    end_name;
    name_in_progress:=false;
    read_open[n]:=just_open;
    @<Set kanji |read_file| type@>;
    end;
@z

@x
format_ident:=" (INITEX)";
@y
if ini_version then format_ident:=" (INITEX)";
@z

@x
@!w: four_quarters; {four ASCII codes}
@y
@!format_engine: ^text_char;
@z

@x
@<Dump constants for consistency check@>;
@y
@<Dump constants for consistency check@>;
dump_int(@"4D4C5458);  {ML\TeX's magic constant: "MLTX"}
if mltex_p then dump_int(1)
else dump_int(0);
@z

@x
@<Dump the hyphenation tables@>;
@y
@<Dump the hyphenation tables@>;
@<Dump the japanese sub font pointer@>;
@<Dump the Kinsoku tables@>;
@<Dump the |j_font_table|@>;
@z

@x
@!w: four_quarters; {four ASCII codes}
@y
@!format_engine: ^text_char;
@!dummy_xord: ASCII_code;
@!dummy_xchr: text_char;
@!dummy_xprn: ASCII_code;
@z

@x
begin @<Undump constants for consistency check@>;
@y
begin @<Undump constants for consistency check@>;
undump_int(x);   {check magic constant of ML\TeX}
if x<>@"4D4C5458 then goto bad_fmt;
undump_int(x);   {undump |mltex_p| flag into |mltex_enabled_p|}
if x=1 then mltex_enabled_p:=true
else if x<>0 then goto bad_fmt;
@z

@x
@<Undump the hyphenation tables@>;
@y
@<Undump the hyphenation tables@>;
@<Undump the japanese sub font pointer@>;
@<Undump the Kinsoku tables@>;
@<Undump the |j_font_table|@>;
@z

@x
@d dump_wd(#)==begin fmt_file^:=#; put(fmt_file);@+end
@d dump_int(#)==begin fmt_file^.int:=#; put(fmt_file);@+end
@d dump_hh(#)==begin fmt_file^.hh:=#; put(fmt_file);@+end
@d dump_qqqq(#)==begin fmt_file^.qqqq:=#; put(fmt_file);@+end
@y
@z

@x
@d undump_wd(#)==begin get(fmt_file); #:=fmt_file^;@+end
@d undump_int(#)==begin get(fmt_file); #:=fmt_file^.int;@+end
@d undump_hh(#)==begin get(fmt_file); #:=fmt_file^.hh;@+end
@d undump_qqqq(#)==begin get(fmt_file); #:=fmt_file^.qqqq;@+end
@y
@z

@x
@d undump_size_end_end(#)==too_small(#)@+else undump_end_end
@y
@d format_debug_end(#)==
    write_ln (stderr, ' = ', #);
  end;
@d format_debug(#)==
  if debug_format_file then begin
    write (stderr, 'fmtdebug:', #);
    format_debug_end
@d undump_size_end_end(#)==
  too_small(#)@+else format_debug (#)(x); undump_end_end
@z

@x
dump_int(@$);@/
@y
dump_int(@"57325458);  {Web2C \TeX's magic constant: "W2TX"}
{Align engine to 4 bytes with one or more trailing NUL}
x:=strlen(engine_name);
format_engine:=xmalloc_array(text_char,x+4);
strcpy(format_engine, engine_name);
for k:=x to x+3 do format_engine[k]:=0;
x:=x+4-(x mod 4);
dump_int(x);dump_things(format_engine[0], x);
libc_free(format_engine);@/
dump_int(@$);@/
@<Dump |xord|, |xchr|, and |xprn|@>;
dump_int(max_halfword);@/
dump_int(hash_high);
@z

@x
dump_int(hyph_size)
@y
dump_int(hyph_prime)
@z

@x
x:=fmt_file^.int;
if x<>@$ then goto bad_fmt; {check that strings are the same}
@y
@+Init
libc_free(j_font_table); {JTeX}
libc_free(font_info); libc_free(str_pool); libc_free(str_start);
libc_free(yhash); libc_free(zeqtb); libc_free(yzmem);
@+Tini
undump_int(x);
format_debug('format magic number')(x);
if x<>@"57325458 then goto bad_fmt; {not a format file}
undump_int(x);
format_debug('engine name size')(x);
if (x<0) or (x>256) then goto bad_fmt; {corrupted format file}
format_engine:=xmalloc_array(text_char, x);
undump_things(format_engine[0], x);
format_engine[x-1]:=0; {force string termination, just in case}
if strcmp(engine_name, format_engine) then
  begin wake_up_terminal;
  wterm_ln('---! ', stringcast(name_of_file+1), ' was written by ', format_engine);
  libc_free(format_engine);
  goto bad_fmt;
end;
libc_free(format_engine);
undump_int(x);
format_debug('string pool checksum')(x);
if x<>@$ then begin {check that strings are the same}
  wake_up_terminal;
  wterm_ln('---! ', stringcast(name_of_file+1), ' doesn''t match ', pool_name);
  goto bad_fmt;
end;
@<Undump |xord|, |xchr|, and |xprn|@>;
undump_int(x);
if x<>max_halfword then goto bad_fmt; {check |max_halfword|}
undump_int(hash_high);
  if (hash_high<0)or(hash_high>sup_hash_extra) then goto bad_fmt;
  if hash_extra<hash_high then hash_extra:=hash_high;
  eqtb_top:=eqtb_size+hash_extra;
  if hash_extra=0 then hash_top:=undefined_control_sequence else
        hash_top:=eqtb_top;
  yhash:=xmalloc_array(two_halves,1+hash_top-hash_offset);
  hash:=yhash - hash_offset;
  next(hash_base):=0; text(hash_base):=0;
  for x:=hash_base+1 to hash_top do hash[x]:=hash[hash_base];
  zeqtb:=xmalloc_array (memory_word,eqtb_top+1);
  eqtb:=zeqtb;

  eq_type(undefined_control_sequence):=undefined_cs;
  equiv(undefined_control_sequence):=null;
  eq_level(undefined_control_sequence):=level_zero;
  for x:=eqtb_size+1 to eqtb_top do
    eqtb[x]:=eqtb[undefined_control_sequence];
@z

@x
undump_int(x);
if x<>mem_bot then goto bad_fmt;
undump_int(x);
if x<>mem_top then goto bad_fmt;
@y
undump_int(x); format_debug ('mem_bot')(x);
if x<>mem_bot then goto bad_fmt;
undump_int(mem_top); format_debug ('mem_top')(mem_top);
if mem_bot+1100>mem_top then goto bad_fmt;


head:=contrib_head; tail:=contrib_head;
     page_tail:=page_head;  {page initialization}

mem_min := mem_bot - extra_mem_bot;
mem_max := mem_top + extra_mem_top;

yzmem:=xmalloc_array (memory_word, mem_max - mem_min + 1);
zmem := yzmem - mem_min;   {this pointer arithmetic fails with some compilers}
mem := zmem;
@z

@x
if x<>hyph_size then goto bad_fmt
@y
if x<>hyph_prime then goto bad_fmt
@z

@x
for k:=0 to str_ptr do dump_int(str_start[k]);
k:=0;
while k+4<pool_ptr do
  begin dump_four_ASCII; k:=k+4;
  end;
k:=pool_ptr-4; dump_four_ASCII;
@y
dump_things(str_start[0], str_ptr+1);
dump_things(str_pool[0], pool_ptr);
@z

@x
undump_size(0)(pool_size)('string pool size')(pool_ptr);
undump_size(0)(max_strings)('max strings')(str_ptr);
for k:=0 to str_ptr do undump(0)(pool_ptr)(str_start[k]);
k:=0;
while k+4<pool_ptr do
  begin undump_four_ASCII; k:=k+4;
  end;
k:=pool_ptr-4; undump_four_ASCII;
@y
undump_size(0)(sup_pool_size-pool_free)('string pool size')(pool_ptr);
if pool_size<pool_ptr+pool_free then
  pool_size:=pool_ptr+pool_free;
undump_size(0)(sup_max_strings-strings_free)('sup strings')(str_ptr);@/
if max_strings<str_ptr+strings_free then
  max_strings:=str_ptr+strings_free;
str_start:=xmalloc_array(pool_pointer, max_strings);
undump_checked_things(0, pool_ptr, str_start[0], str_ptr+1);@/
str_pool:=xmalloc_array(packed_ASCII_code, pool_size);
undump_things(str_pool[0], pool_ptr);
@z

@x
repeat for k:=p to q+1 do dump_wd(mem[k]);
@y
repeat dump_things(mem[p], q+2-p);
@z

@x
for k:=p to lo_mem_max do dump_wd(mem[k]);
@y
dump_things(mem[p], lo_mem_max+1-p);
@z

@x
for k:=hi_mem_min to mem_end do dump_wd(mem[k]);
@y
dump_things(mem[hi_mem_min], mem_end+1-hi_mem_min);
@z

@x
repeat for k:=p to q+1 do undump_wd(mem[k]);
@y
repeat undump_things(mem[p], q+2-p);
@z

@x
for k:=p to lo_mem_max do undump_wd(mem[k]);
@y
undump_things(mem[p], lo_mem_max+1-p);
@z

@x
for k:=hi_mem_min to mem_end do undump_wd(mem[k]);
@y
undump_things (mem[hi_mem_min], mem_end+1-hi_mem_min);
@z

@x
undump(hash_base)(frozen_control_sequence)(par_loc);
par_token:=cs_token_flag+par_loc;@/
undump(hash_base)(frozen_control_sequence)(write_loc);@/
@y
undump(hash_base)(hash_top)(par_loc);
par_token:=cs_token_flag+par_loc;@/
undump(hash_base)(hash_top)(write_loc);@/
@z

@x
while k<l do
  begin dump_wd(eqtb[k]); incr(k);
  end;
@y
dump_things(eqtb[k], l-k);
@z

@x
while k<l do
  begin dump_wd(eqtb[k]); incr(k);
  end;
@y
dump_things(eqtb[k], l-k);
@z

@x
k:=j+1; dump_int(k-l);
until k>eqtb_size
@y
k:=j+1; dump_int(k-l);
until k>eqtb_size;
if hash_high>0 then dump_things(eqtb[eqtb_size+1],hash_high);
  {dump |hash_extra| part}
@z

@x
for j:=k to k+x-1 do undump_wd(eqtb[j]);
@y
undump_things(eqtb[k], x);
@z

@x
until k>eqtb_size
@y
until k>eqtb_size;
if hash_high>0 then undump_things(eqtb[eqtb_size+1],hash_high);
  {undump |hash_extra| part}
@z

@x
dump_int(hash_used); cs_count:=frozen_control_sequence-1-hash_used;
@y
dump_int(hash_used); cs_count:=frozen_control_sequence-1-hash_used+hash_high;
@z

@x
for p:=hash_used+1 to undefined_control_sequence-1 do dump_hh(hash[p]);
@y
dump_things(hash[hash_used+1], undefined_control_sequence-1-hash_used);
if hash_high>0 then dump_things(hash[eqtb_size+1], hash_high);
@z

@x
for p:=hash_used+1 to undefined_control_sequence-1 do undump_hh(hash[p]);
@y
undump_things (hash[hash_used+1], undefined_control_sequence-1-hash_used);
if debug_format_file then begin
  print_csnames (hash_base, undefined_control_sequence - 1);
end;
if hash_high > 0 then begin
  undump_things (hash[eqtb_size+1], hash_high);
  if debug_format_file then begin
    print_csnames (eqtb_size + 1, hash_high - (eqtb_size + 1));
  end;
end;
@z

@x
for k:=0 to fmem_ptr-1 do dump_wd(font_info[k]);
dump_int(font_ptr);
for k:=null_font to font_ptr do
  @<Dump the array info for internal font number |k|@>;
@y
dump_things(font_info[0], fmem_ptr);
dump_int(font_ptr);
@<Dump the array info for internal font number |k|@>;
@z

@x
print_int(font_ptr-font_base); print(" preloaded font");
if font_ptr<>font_base+1 then print_char("s")
@y
print_int(font_ptr-font_base);
if font_ptr<>font_base+1 then print(" preloaded fonts")
else print(" preloaded font")
@z

@x
undump_size(7)(font_mem_size)('font mem size')(fmem_ptr);
for k:=0 to fmem_ptr-1 do undump_wd(font_info[k]);
undump_size(font_base)(font_max)('font max')(font_ptr);
for k:=null_font to font_ptr do
  @<Undump the array info for internal font number |k|@>
@y
undump_size(7)(sup_font_mem_size)('font mem size')(fmem_ptr);
if fmem_ptr>font_mem_size then font_mem_size:=fmem_ptr;
font_info:=xmalloc_array(fmemory_word, font_mem_size);
undump_things(font_info[0], fmem_ptr);@/
undump_size(font_base)(font_base+max_font_max)('font max')(font_ptr);
{This undumps all of the font info, despite the name.}
@<Undump the array info for internal font number |k|@>;
@z

@x
@ @<Dump the array info for internal font number |k|@>=
begin dump_qqqq(font_check[k]);
dump_int(font_size[k]);
dump_int(font_dsize[k]);
dump_int(font_params[k]);@/
dump_int(hyphen_char[k]);
dump_int(skew_char[k]);@/
dump_int(font_name[k]);
dump_int(font_area[k]);@/
dump_int(font_bc[k]);
dump_int(font_ec[k]);@/
dump_int(char_base[k]);
dump_int(width_base[k]);
dump_int(height_base[k]);@/
dump_int(depth_base[k]);
dump_int(italic_base[k]);
dump_int(lig_kern_base[k]);@/
dump_int(kern_base[k]);
dump_int(exten_base[k]);
dump_int(param_base[k]);@/
dump_int(font_glue[k]);@/
dump_int(bchar_label[k]);
dump_int(font_bchar[k]);
dump_int(font_false_bchar[k]);@/
print_nl("\font"); print_esc(font_id_text(k)); print_char("=");
print_file_name(font_name[k],font_area[k],"");
if font_size[k]<>font_dsize[k] then
  begin print(" at "); print_scaled(font_size[k]); print("pt");
  end;
end
@y
@ @<Dump the array info for internal font number |k|@>=
begin
dump_things(font_check[null_font], font_ptr+1-null_font);
dump_things(font_size[null_font], font_ptr+1-null_font);
dump_things(font_dsize[null_font], font_ptr+1-null_font);
dump_things(font_params[null_font], font_ptr+1-null_font);
dump_things(hyphen_char[null_font], font_ptr+1-null_font);
dump_things(skew_char[null_font], font_ptr+1-null_font);
dump_things(font_name[null_font], font_ptr+1-null_font);
dump_things(font_area[null_font], font_ptr+1-null_font);
dump_things(font_bc[null_font], font_ptr+1-null_font);
dump_things(font_ec[null_font], font_ptr+1-null_font);
dump_things(char_base[null_font], font_ptr+1-null_font);
dump_things(width_base[null_font], font_ptr+1-null_font);
dump_things(height_base[null_font], font_ptr+1-null_font);
dump_things(depth_base[null_font], font_ptr+1-null_font);
dump_things(italic_base[null_font], font_ptr+1-null_font);
dump_things(lig_kern_base[null_font], font_ptr+1-null_font);
dump_things(kern_base[null_font], font_ptr+1-null_font);
dump_things(exten_base[null_font], font_ptr+1-null_font);
dump_things(param_base[null_font], font_ptr+1-null_font);
dump_things(font_glue[null_font], font_ptr+1-null_font);
dump_things(bchar_label[null_font], font_ptr+1-null_font);
dump_things(font_bchar[null_font], font_ptr+1-null_font);
dump_things(font_false_bchar[null_font], font_ptr+1-null_font);
for k:=null_font to font_ptr do
  begin print_nl("\font"); print_esc(font_id_text(k)); print_char("=");
  print_file_name(font_name[k],font_area[k],"");
  if font_size[k]<>font_dsize[k] then
    begin print(" at "); print_scaled(font_size[k]); print("pt");
    end;
  end;
end
@z

@x
@ @<Undump the array info for internal font number |k|@>=
begin undump_qqqq(font_check[k]);@/
undump_int(font_size[k]);
undump_int(font_dsize[k]);
undump(min_halfword)(max_halfword)(font_params[k]);@/
undump_int(hyphen_char[k]);
undump_int(skew_char[k]);@/
undump(0)(str_ptr)(font_name[k]);
undump(0)(str_ptr)(font_area[k]);@/
undump(0)(255)(font_bc[k]);
undump(0)(255)(font_ec[k]);@/
undump_int(char_base[k]);
undump_int(width_base[k]);
undump_int(height_base[k]);@/
undump_int(depth_base[k]);
undump_int(italic_base[k]);
undump_int(lig_kern_base[k]);@/
undump_int(kern_base[k]);
undump_int(exten_base[k]);
undump_int(param_base[k]);@/
undump(min_halfword)(lo_mem_max)(font_glue[k]);@/
undump(0)(fmem_ptr-1)(bchar_label[k]);
undump(min_quarterword)(non_char)(font_bchar[k]);
undump(min_quarterword)(non_char)(font_false_bchar[k]);
end
@y
@ This module should now be named `Undump all the font arrays'.

@<Undump the array info for internal font number |k|@>=
begin {Allocate the font arrays}
font_check:=xmalloc_array(four_quarters, font_max);
font_size:=xmalloc_array(scaled, font_max);
font_dsize:=xmalloc_array(scaled, font_max);
font_params:=xmalloc_array(font_index, font_max);
font_name:=xmalloc_array(str_number, font_max);
font_area:=xmalloc_array(str_number, font_max);
font_bc:=xmalloc_array(eight_bits, font_max);
font_ec:=xmalloc_array(eight_bits, font_max);
font_glue:=xmalloc_array(halfword, font_max);
hyphen_char:=xmalloc_array(integer, font_max);
skew_char:=xmalloc_array(integer, font_max);
bchar_label:=xmalloc_array(font_index, font_max);
font_bchar:=xmalloc_array(nine_bits, font_max);
font_false_bchar:=xmalloc_array(nine_bits, font_max);
char_base:=xmalloc_array(integer, font_max);
width_base:=xmalloc_array(integer, font_max);
height_base:=xmalloc_array(integer, font_max);
depth_base:=xmalloc_array(integer, font_max);
italic_base:=xmalloc_array(integer, font_max);
lig_kern_base:=xmalloc_array(integer, font_max);
kern_base:=xmalloc_array(integer, font_max);
exten_base:=xmalloc_array(integer, font_max);
param_base:=xmalloc_array(integer, font_max);

undump_things(font_check[null_font], font_ptr+1-null_font);
undump_things(font_size[null_font], font_ptr+1-null_font);
undump_things(font_dsize[null_font], font_ptr+1-null_font);
undump_checked_things(min_halfword, max_halfword,
                      font_params[null_font], font_ptr+1-null_font);
undump_things(hyphen_char[null_font], font_ptr+1-null_font);
undump_things(skew_char[null_font], font_ptr+1-null_font);
undump_upper_check_things(str_ptr, font_name[null_font], font_ptr+1-null_font);
undump_upper_check_things(str_ptr, font_area[null_font], font_ptr+1-null_font);
{There's no point in checking these values against the range $[0,255]$,
 since the data type is |unsigned char|, and all values of that type are
 in that range by definition.}
undump_things(font_bc[null_font], font_ptr+1-null_font);
undump_things(font_ec[null_font], font_ptr+1-null_font);
undump_things(char_base[null_font], font_ptr+1-null_font);
undump_things(width_base[null_font], font_ptr+1-null_font);
undump_things(height_base[null_font], font_ptr+1-null_font);
undump_things(depth_base[null_font], font_ptr+1-null_font);
undump_things(italic_base[null_font], font_ptr+1-null_font);
undump_things(lig_kern_base[null_font], font_ptr+1-null_font);
undump_things(kern_base[null_font], font_ptr+1-null_font);
undump_things(exten_base[null_font], font_ptr+1-null_font);
undump_things(param_base[null_font], font_ptr+1-null_font);
undump_checked_things(min_halfword, lo_mem_max,
                     font_glue[null_font], font_ptr+1-null_font);
undump_checked_things(0, fmem_ptr-1,
                     bchar_label[null_font], font_ptr+1-null_font);
undump_checked_things(min_quarterword, non_char,
                     font_bchar[null_font], font_ptr+1-null_font);
undump_checked_things(min_quarterword, non_char,
                     font_false_bchar[null_font], font_ptr+1-null_font);
end
@z

@x
dump_int(hyph_count);
for k:=0 to hyph_size do if hyph_word[k]<>0 then
  begin dump_int(k); dump_int(hyph_word[k]); dump_int(hyph_list[k]);
  end;
@y
dump_int(hyph_count);
if hyph_next <= hyph_prime then hyph_next:=hyph_size;
dump_int(hyph_next);{minumum value of |hyphen_size| needed}
for k:=0 to hyph_size do if hyph_word[k]<>0 then
  begin dump_int(k+65536*hyph_link[k]);
        {assumes number of hyphen exceptions does not exceed 65535}
   dump_int(hyph_word[k]); dump_int(hyph_list[k]);
  end;
@z

@x
print_ln; print_int(hyph_count); print(" hyphenation exception");
if hyph_count<>1 then print_char("s");
@y
print_ln; print_int(hyph_count);
if hyph_count<>1 then print(" hyphenation exceptions")
else print(" hyphenation exception");
@z

@x
for k:=0 to trie_max do dump_hh(trie[k]);
@y
dump_things(trie_trl[0], trie_max+1);
dump_things(trie_tro[0], trie_max+1);
dump_things(trie_trc[0], trie_max+1);
@z

@x
for k:=1 to trie_op_ptr do
  begin dump_int(hyf_distance[k]);
  dump_int(hyf_num[k]);
  dump_int(hyf_next[k]);
  end;
@y
dump_things(hyf_distance[1], trie_op_ptr);
dump_things(hyf_num[1], trie_op_ptr);
dump_things(hyf_next[1], trie_op_ptr);
@z

@x
print(" has "); print_int(trie_op_ptr); print(" op");
if trie_op_ptr<>1 then print_char("s");
@y
print(" has "); print_int(trie_op_ptr);
if trie_op_ptr<>1 then print(" ops")
else print(" op");
@z

@x
undump(0)(hyph_size)(hyph_count);
for k:=1 to hyph_count do
  begin undump(0)(hyph_size)(j);
  undump(0)(str_ptr)(hyph_word[j]);
  undump(min_halfword)(max_halfword)(hyph_list[j]);
  end;
@y
undump_size(0)(hyph_size)('hyph_size')(hyph_count);
undump_size(hyph_prime)(hyph_size)('hyph_size')(hyph_next);
j:=0;
for k:=1 to hyph_count do
  begin undump_int(j); if j<0 then goto bad_fmt;
   if j>65535 then
   begin hyph_next:= j div 65536; j:=j - hyph_next * 65536; end
       else hyph_next:=0;
   if (j>=hyph_size)or(hyph_next>hyph_size) then goto bad_fmt;
   hyph_link[j]:=hyph_next;
  undump(0)(str_ptr)(hyph_word[j]);
  undump(min_halfword)(max_halfword)(hyph_list[j]);
  end;
  {|j| is now the largest occupied location in |hyph_word|}
  incr(j);
  if j<hyph_prime then j:=hyph_prime;
  hyph_next:=j;
  if hyph_next >= hyph_size then hyph_next:=hyph_prime else
  if hyph_next >= hyph_prime then incr(hyph_next);
@z

@x
for k:=0 to j do undump_hh(trie[k]);
@y
{These first three haven't been allocated yet unless we're \.{INITEX};
 we do that precisely so we don't allocate more space than necessary.}
if not trie_trl then trie_trl:=xmalloc_array(trie_pointer,j+1);
undump_things(trie_trl[0], j+1);
if not trie_tro then trie_tro:=xmalloc_array(trie_pointer,j+1);
undump_things(trie_tro[0], j+1);
if not trie_trc then trie_trc:=xmalloc_array(quarterword, j+1);
undump_things(trie_trc[0], j+1);
@z

@x
for k:=1 to j do
  begin undump(0)(63)(hyf_distance[k]); {a |small_number|}
  undump(0)(63)(hyf_num[k]);
  undump(min_quarterword)(max_quarterword)(hyf_next[k]);
  end;
@y
{I'm not sure we have such a strict limitation (64) on these values, so
 let's leave them unchecked.}
undump_things(hyf_distance[1], j);
undump_things(hyf_num[1], j);
undump_upper_check_things(max_trie_op, hyf_next[1], j);
@z

@x
undump(batch_mode)(error_stop_mode)(interaction);
@y
undump(batch_mode)(error_stop_mode)(interaction);
if interaction_option<>unspecified_mode then interaction:=interaction_option;
@z

@x
if (x<>69069)or eof(fmt_file) then goto bad_fmt
@y
if x<>69069 then goto bad_fmt
@z

@x
@p begin @!{|start_here|}
@y
@d const_chk(#)==begin if # < inf@&# then # := inf@&# else
                         if # > sup@&# then # := sup@&# end

{|setup_bound_var| stuff duplicated in \.{mf.ch}.}
@d setup_bound_var(#)==bound_default:=#; setup_bound_var_end
@d setup_bound_var_end(#)==bound_name:=#; setup_bound_var_end_end
@d setup_bound_var_end_end(#)==
  setup_bound_variable(addressof(#), bound_name, bound_default);

@p procedure main_body;
begin @!{|start_here|}

{Bounds that may be set from the configuration file. We want the user to
 be able to specify the names with underscores, but \.{TANGLE} removes
 underscores, so we're stuck giving the names twice, once as a string,
 once as the identifier. How ugly.}
  setup_bound_var (0)('mem_bot')(mem_bot);
  setup_bound_var (250000)('main_memory')(main_memory);
    {|memory_word|s for |mem| in \.{INITEX}}
  setup_bound_var (0)('extra_mem_top')(extra_mem_top);
    {increase high mem in \.{VIRTEX}}
  setup_bound_var (0)('extra_mem_bot')(extra_mem_bot);
    {increase low mem in \.{VIRTEX}}
  setup_bound_var (200000)('pool_size')(pool_size);
  setup_bound_var (75000)('string_vacancies')(string_vacancies);
  setup_bound_var (5000)('pool_free')(pool_free); {min pool avail after fmt}
  setup_bound_var (15000)('max_strings')(max_strings);
  setup_bound_var (100)('strings_free')(strings_free);
  setup_bound_var (100000)('font_mem_size')(font_mem_size);
  setup_bound_var (500)('font_max')(font_max);
  setup_bound_var (20000)('trie_size')(trie_size);
    {if |ssup_trie_size| increases, recompile}
  setup_bound_var (659)('hyph_size')(hyph_size);
  setup_bound_var (3000)('buf_size')(buf_size);
  setup_bound_var (50)('nest_size')(nest_size);
  setup_bound_var (15)('max_in_open')(max_in_open);
  setup_bound_var (60)('param_size')(param_size);
  setup_bound_var (4000)('save_size')(save_size);
  setup_bound_var (300)('stack_size')(stack_size);
  setup_bound_var (16384)('dvi_buf_size')(dvi_buf_size);
  setup_bound_var (79)('error_line')(error_line);
  setup_bound_var (50)('half_error_line')(half_error_line);
  setup_bound_var (79)('max_print_line')(max_print_line);
  setup_bound_var (0)('hash_extra')(hash_extra);
  setup_bound_var (10000)('expand_depth')(expand_depth);

  const_chk (mem_bot);
  const_chk (main_memory);
@+Init
  extra_mem_top := 0;
  extra_mem_bot := 0;
@+Tini
  if extra_mem_bot>sup_main_memory then extra_mem_bot:=sup_main_memory;
  if extra_mem_top>sup_main_memory then extra_mem_top:=sup_main_memory;
  {|mem_top| is an index, |main_memory| a size}
  mem_top := mem_bot + main_memory -1;
  mem_min := mem_bot;
  mem_max := mem_top;

  {Check other constants against their sup and inf.}
  const_chk (trie_size);
  const_chk (hyph_size);
  const_chk (buf_size);
  const_chk (nest_size);
  const_chk (max_in_open);
  const_chk (param_size);
  const_chk (save_size);
  const_chk (stack_size);
  const_chk (dvi_buf_size);
  const_chk (pool_size);
  const_chk (string_vacancies);
  const_chk (pool_free);
  const_chk (max_strings);
  const_chk (strings_free);
  const_chk (font_mem_size);
  const_chk (font_max);
  const_chk (hash_extra);
  if error_line > ssup_error_line then error_line := ssup_error_line;
  trick_line := 2*error_line-1; {JTeX}

  {array memory allocation}
  buffer:=xmalloc_array (ASCII_code, buf_size);
  nest:=xmalloc_array (list_state_record, nest_size);
  save_stack:=xmalloc_array (memory_word, save_size);
  input_stack:=xmalloc_array (in_state_record, stack_size);
  input_file:=xmalloc_array (alpha_file, max_in_open);
  line_stack:=xmalloc_array (integer, max_in_open);
  source_filename_stack:=xmalloc_array (str_number, max_in_open);
  full_source_filename_stack:=xmalloc_array (str_number, max_in_open);
  param_stack:=xmalloc_array (halfword, param_size);
  dvi_buf:=xmalloc_array (eight_bits, dvi_buf_size);
  hyph_word :=xmalloc_array (str_number, hyph_size);
  hyph_list :=xmalloc_array (halfword, hyph_size);
  hyph_link :=xmalloc_array (hyph_pointer, hyph_size);
@+Init
  yzmem:=xmalloc_array (memory_word, mem_top - mem_bot + 1);
  zmem := yzmem - mem_bot;   {Some compilers require |mem_bot=0|}
  eqtb_top := eqtb_size+hash_extra;
  if hash_extra=0 then hash_top:=undefined_control_sequence else
        hash_top:=eqtb_top;
  yhash:=xmalloc_array (two_halves,1+hash_top-hash_offset);
  hash:=yhash - hash_offset;   {Some compilers require |hash_offset=0|}
  next(hash_base):=0; text(hash_base):=0;
  for hash_used:=hash_base+1 to hash_top do hash[hash_used]:=hash[hash_base];
  zeqtb:=xmalloc_array (memory_word, eqtb_top);
  eqtb:=zeqtb;

  str_start:=xmalloc_array (pool_pointer, max_strings);
  str_pool:=xmalloc_array (packed_ASCII_code, pool_size);
  font_info:=xmalloc_array (fmemory_word, font_mem_size);
  j_font_table:=xmalloc_array (s_f_range0, font_max); {JTeX}
@+Tini
@z

@x
@!init if not get_strings_started then goto final_end;
init_prim; {call |primitive| for each primitive}
init_str_ptr:=str_ptr; init_pool_ptr:=pool_ptr; fix_date_and_time;
tini@/
@y
@!Init if not get_strings_started then goto final_end;
init_prim; {call |primitive| for each primitive}
init_str_ptr:=str_ptr; init_pool_ptr:=pool_ptr; fix_date_and_time;
Tini@/
@z

@x
start_of_TEX: @<Initialize the output routines@>;
@<Get the first line of input and prepare to start@>;
@y
{terminal kanji stat should be initialized before first output to terminal}
start_of_TEX: @<Initialize default kanji stat@>;
@<Initialize the output routines@>;
@<Get the first line of input and prepare to start@>;
{terminal kanji type may be changed by format file}
@<Initialize kanji stat@>;
@z

@x
end_of_TEX: close_files_and_terminate;
final_end: ready_already:=0;
end.
@y
close_files_and_terminate;
final_end: do_final_end;
end {|main_body|};
@z

@x
    slow_print(log_name); print_char(".");
    end;
  end;
@y
    print_file_name(0, log_name, 0); print_char(".");
    end;
  end;
print_ln;
if (edit_name_start<>0) and (interaction>batch_mode) then
  call_edit(str_pool,edit_name_start,edit_name_length,edit_line);
@z

@x
  wlog_ln(' ',cs_count:1,' multiletter control sequences out of ',
    hash_size:1);@/
@y
  wlog_ln(' ',cs_count:1,' multiletter control sequences out of ',
    hash_size:1, '+', hash_extra:1);@/
@z

@x
  begin @!init for c:=top_mark_code to split_bot_mark_code do
@y
  begin @!Init for c:=top_mark_code to split_bot_mark_code do
@z

@x
  store_fmt_file; return;@+tini@/
@y
  store_fmt_file; return;@+Tini@/
@z

@x
if (format_ident=0)or(buffer[loc]="&") then
@y
if (format_ident=0)or(buffer[loc]="&")or dump_line then
@z

@x
  w_close(fmt_file);
@y
  w_close(fmt_file);
  eqtb:=zeqtb;
@z

@x
if end_line_char_inactive then decr(limit)
else  buffer[limit]:=end_line_char;
@y
@<Put the end-of-line-char if it is active@>;
@z

@x
fix_date_and_time;@/
@y
if mltex_enabled_p then
  begin wterm_ln('MLTeX v2.2 enabled');
  end;
fix_date_and_time;@/

@!init
if trie_not_ready then begin {initex without format loaded}
  trie_trl:=xmalloc_array (trie_pointer, trie_size);
  trie_tro:=xmalloc_array (trie_pointer, trie_size);
  trie_trc:=xmalloc_array (quarterword, trie_size);

  trie_c:=xmalloc_array (packed_ASCII_code, trie_size);
  trie_o:=xmalloc_array (trie_opcode, trie_size);
  trie_l:=xmalloc_array (trie_pointer, trie_size);
  trie_r:=xmalloc_array (trie_pointer, trie_size);
  trie_hash:=xmalloc_array (trie_pointer, trie_size);
  trie_taken:=xmalloc_array (boolean, trie_size);

  trie_root:=0; trie_c[0]:=si(0); trie_ptr:=0;

  {Allocate and initialize font arrays}
  font_check:=xmalloc_array(four_quarters, font_max);
  font_size:=xmalloc_array(scaled, font_max);
  font_dsize:=xmalloc_array(scaled, font_max);
  font_params:=xmalloc_array(font_index, font_max);
  font_name:=xmalloc_array(str_number, font_max);
  font_area:=xmalloc_array(str_number, font_max);
  font_bc:=xmalloc_array(eight_bits, font_max);
  font_ec:=xmalloc_array(eight_bits, font_max);
  font_glue:=xmalloc_array(halfword, font_max);
  hyphen_char:=xmalloc_array(integer, font_max);
  skew_char:=xmalloc_array(integer, font_max);
  bchar_label:=xmalloc_array(font_index, font_max);
  font_bchar:=xmalloc_array(nine_bits, font_max);
  font_false_bchar:=xmalloc_array(nine_bits, font_max);
  char_base:=xmalloc_array(integer, font_max);
  width_base:=xmalloc_array(integer, font_max);
  height_base:=xmalloc_array(integer, font_max);
  depth_base:=xmalloc_array(integer, font_max);
  italic_base:=xmalloc_array(integer, font_max);
  lig_kern_base:=xmalloc_array(integer, font_max);
  kern_base:=xmalloc_array(integer, font_max);
  exten_base:=xmalloc_array(integer, font_max);
  param_base:=xmalloc_array(integer, font_max);

  font_ptr:=null_font; fmem_ptr:=7;
  font_name[null_font]:="nullfont"; font_area[null_font]:="";
  hyphen_char[null_font]:="-"; skew_char[null_font]:=-1;
  bchar_label[null_font]:=non_address;
  font_bchar[null_font]:=non_char; font_false_bchar[null_font]:=non_char;
  font_bc[null_font]:=1; font_ec[null_font]:=0;
  font_size[null_font]:=0; font_dsize[null_font]:=0;
  char_base[null_font]:=0; width_base[null_font]:=0;
  height_base[null_font]:=0; depth_base[null_font]:=0;
  italic_base[null_font]:=0; lig_kern_base[null_font]:=0;
  kern_base[null_font]:=0; exten_base[null_font]:=0;
  font_glue[null_font]:=null; font_params[null_font]:=7;
  param_base[null_font]:=-1;
  for font_k:=0 to 6 do font_info[font_k].sc:=0;
  end;
  tini@/

  font_used:=xmalloc_array (boolean, font_max);
  for font_k:=font_base to font_max do font_used[font_k]:=false;
@z

@x
if (loc<limit)and(cat_code(buffer[loc])<>escape) then start_input;
@y
{kanjifiletype may be overriden from argument}
@<Reset |kanjifiletype| from argument@>;
if (loc<limit)and(cat_code(buffer[loc])<>escape) then start_input;
@z

@x
    begin goto breakpoint;@\ {go to every label at least once}
    breakpoint: m:=0; @{'BREAKPOINT'@}@\
    end
@y
    dump_core {do something to cause a core dump}
@z

@x
5: print_word(font_info[n]);
@y
5: begin print_scaled(font_info[n].sc); print_char(" ");@/
  print_int(font_info[n].qqqq.b0); print_char(":");@/
  print_int(font_info[n].qqqq.b1); print_char(":");@/
  print_int(font_info[n].qqqq.b2); print_char(":");@/
  print_int(font_info[n].qqqq.b3);
  end;
@z

@x
primitive("special",extension,special_node);@/
@y
primitive("special",extension,special_node);@/
text(frozen_special):="special"; eqtb[frozen_special]:=eqtb[cur_val];@/
@z

@x
var i,@!j,@!k:integer; {all-purpose integers}
@!p,@!q,@!r:pointer; {all-purpose pointers}
@y
var k:integer; {all-purpose integers}
@!p:pointer; {all-purpose pointers}
@z

@x
  else if cur_val>15 then cur_val:=16;
@y
  else if (cur_val>15) and (cur_val <> 18) then cur_val:=16;
@z

@x
@!k:pool_pointer; {index into |str_pool|}
@y
@!k:pool_pointer; {index into |str_pool|}
@!ecount:integer;
@z

@x
if cur_length<256 then
  begin dvi_out(xxx1); dvi_out(cur_length);
  end
else  begin dvi_out(xxx4); dvi_four(cur_length);
  end;
for k:=str_start[str_ptr] to pool_ptr-1 do dvi_out(so(str_pool[k]));
@y
@<Output chars in |str_pool| into dvi@>;
@z

@x
begin @<Expand macros in the token list
@y
@!d:integer; {number of characters in incomplete current string}
@!clobbered:boolean; {system string is ok?}
@!runsystem_ret:integer; {return value from |runsystem|}
begin @<Expand macros in the token list
@z

@x
if write_open[j] then selector:=j
@y
if j=18 then selector := new_string
else if write_open[j] then selector:=j
@z

@x
flush_list(def_ref); selector:=old_setting;
@y
flush_list(def_ref);
if j=18 then
  begin if (tracing_online<=0) then
    selector:=log_only  {Show what we're doing in the log file.}
  else selector:=term_and_log;  {Show what we're doing.}
  {If the log file isn't open yet, we can only send output to the terminal.
   Calling |open_log_file| from here seems to result in bad data in the log.}
  if not log_opened then selector:=term_only;
  print_nl("runsystem(");
  for d:=0 to cur_length-1 do
    begin {|print| gives up if passed |str_ptr|, so do it by hand.}
    print(so(str_pool[str_start[str_ptr]+d])); {N.B.: not |print_char|}
    end;
  print(")...");
  if shellenabledp then begin
    str_room(1); append_char(0); {Append a null byte to the expansion.}
    clobbered:=false;
    for d:=0 to cur_length-1 do {Convert to external character set.}
      begin
        str_pool[str_start[str_ptr]+d]:=xchr[str_pool[str_start[str_ptr]+d]];
        if (str_pool[str_start[str_ptr]+d]=null_code)
           and (d<cur_length-1) then clobbered:=true;
        {minimal checking: NUL not allowed in argument string of |system|()}
      end;
    if clobbered then print("clobbered")
    else begin {We have the command.  See if we're allowed to execute it,
         and report in the log.  We don't check the actual exit status of
         the command, or do anything with the output.}
      runsystem_ret := runsystem(conststringcast(addressof(
                                              str_pool[str_start[str_ptr]])));
      if runsystem_ret = -1 then print("quotation error in system command")
      else if runsystem_ret = 0 then print("disabled (restricted)")
      else if runsystem_ret = 1 then print("executed")
      else if runsystem_ret = 2 then print("executed safely (allowed)")
    end;
  end else begin
    print("disabled"); {|shellenabledp| false}
  end;
  print_char("."); print_nl(""); print_ln;
  pool_ptr:=str_start[str_ptr];  {erase the string}
end;
selector:=old_setting;
@z

@x
procedure out_what(@!p:pointer);
var j:small_number; {write stream number}
@y
procedure out_what(@!p:pointer);
var j:small_number; {write stream number}
    @!old_setting:0..max_selector;
@z

@x
      while not a_open_out(write_file[j]) do
        prompt_file_name("output file name",".tex");
      write_open[j]:=true;
@y
      while not kpse_out_name_ok(stringcast(name_of_file+1))
            or not a_open_out(write_file[j]) do
        prompt_file_name("output file name",".tex");
      write_open[j]:=true;
      @<Set kanji |write_file| type@>;
      {If on first line of input, log file is not ready yet, so don't log.}
      if log_opened then begin
        old_setting:=selector;
        if (tracing_online<=0) then
          selector:=log_only  {Show what we're doing in the log file.}
        else selector:=term_and_log;  {Show what we're doing.}
        print_nl("\openout");
        print_int(j);
        print(" = `");
        print_file_name(cur_name,cur_area,cur_ext);
        print("'."); print_nl(""); print_ln;
        selector:=old_setting;
      end;
@z

@x
@* \[54] System-dependent changes.
@y
@* \[54/web2c] System-dependent changes for Web2c.
Here are extra variables for Web2c.  (This numbering of the
system-dependent section allows easy integration of Web2c and e-\TeX, etc.)
@^<system dependencies@>

@<Glob...@>=
@!edit_name_start: pool_pointer; {where the filename to switch to starts}
@!edit_name_length,@!edit_line: integer; {what line to start editing at}
@!ipc_on: cinttype; {level of IPC action, 0 for none [default]}
@!xprn: array[ASCII_code] of boolean; {use \.{\^\^} notation?}
@!is_printable: array[ASCII_code] of boolean; {use \.{\^\^} notation?}
@!stop_at_space: boolean; {whether |more_name| returns false for space}

@ The |edit_name_start| will be set to point into |str_pool| somewhere after
its beginning if \TeX\ is supposed to switch to an editor on exit.

@<Set init...@>=
edit_name_start:=0;
stop_at_space:=true;

@ These are used when we regenerate the representation of the first 256
strings.

@<Global...@> =
@!save_str_ptr: str_number;
@!save_pool_ptr: pool_pointer;
@!shellenabledp: cinttype;
@!restrictedshell: cinttype;
@!output_comment: ^char;
@!k,l: 0..255; {used by `Make the first 256 strings', etc.}

@ When debugging a macro package, it can be useful to see the exact
control sequence names in the format file.  For example, if ten new
csnames appear, it's nice to know what they are, to help pinpoint where
they came from.  (This isn't a truly ``basic'' printing procedure, but
that's a convenient module in which to put it.)

@<Basic printing procedures@> =
procedure print_csnames (hstart:integer; hfinish:integer);
var c,h:integer;
begin
  write_ln(stderr, 'fmtdebug:csnames from ', hstart, ' to ', hfinish, ':');
  for h := hstart to hfinish do begin
    if text(h) > 0 then begin {if have anything at this position}
      for c := str_start[text(h)] to str_start[text(h) + 1] - 1
      do begin
        put_byte(str_pool[c], stderr); {print the characters}
      end;
      write_ln(stderr, '|');
    end;
  end;
end;

@ Are we printing extra info as we read the format file?

@<Glob...@> =
@!debug_format_file: boolean;


@ A helper for printing file:line:error style messages.  Look for a
filename in |full_source_filename_stack|, and if we fail to find
one fall back on the non-file:line:error style.

@<Basic print...@>=
procedure print_file_line;
var level: 0..max_in_open;
begin
  level:=in_open;
  while (level>0) and (full_source_filename_stack[level]=0) do
    decr(level);
  if level=0 then
    print_nl("! ")
  else begin
    print_nl (""); print (full_source_filename_stack[level]); print (":");
    if level=in_open then print_int (line)
    else print_int (line_stack[level+1]);
    print (": ");
  end;
end;

@ To be able to determine whether \.{\\write18} is enabled from within
\TeX\ we also implement \.{\\eof18}.  We sort of cheat by having an
additional route |scan_four_bit_int_or_18| which is the same as
|scan_four_bit_int| except it also accepts the value 18.

@<Declare procedures that scan restricted classes of integers@>=
procedure scan_four_bit_int_or_18;
begin scan_int;
if (cur_val<0)or((cur_val>15)and(cur_val<>18)) then
  begin print_err("Bad number");
@.Bad number@>
  help2("Since I expected to read a number between 0 and 15,")@/
    ("I changed this one to zero."); int_error(cur_val); cur_val:=0;
  end;
end;

@ Dumping the |xord|, |xchr|, and |xprn| arrays.  We dump these always
in the format, so a TCX file loaded during format creation can set a
default for users of the format.

@<Dump |xord|, |xchr|, and |xprn|@>=
dump_things(xord[0], 256);
dump_things(xchr[0], 256);
dump_things(xprn[0], 256);

@ Undumping the |xord|, |xchr|, and |xprn| arrays.  This code is more
complicated, because we want to ensure that a TCX file specified on
the command line will override whatever is in the format.  Since the
tcx file has already been loaded, that implies throwing away the data
in the format.  Also, if no |translate_filename| is given, but
|eight_bit_p| is set we have to make all characters printable.

@<Undump |xord|, |xchr|, and |xprn|@>=
if translate_filename then begin
  for k:=0 to 255 do undump_things(dummy_xord, 1);
  for k:=0 to 255 do undump_things(dummy_xchr, 1);
  for k:=0 to 255 do undump_things(dummy_xprn, 1);
  end
else begin
  undump_things(xord[0], 256);
  undump_things(xchr[0], 256);
  undump_things(xprn[0], 256);
  if eight_bit_p then
    for k:=0 to 255 do
      xprn[k]:=1;
end;


@* \[54/web2c-string] The string recycling routines.  \TeX{} uses 2
upto 4 {\it new\/} strings when scanning a filename in an \.{\\input},
\.{\\openin}, or \.{\\openout} operation.  These strings are normally
lost because the reference to them are not saved after finishing the
operation.  |search_string| searches through the string pool for the
given string and returns either 0 or the found string number.

@<Declare additional routines for string recycling@>=
function search_string(@!search:str_number):str_number;
label found;
var result: str_number;
@!s: str_number; {running index}
@!len: integer; {length of searched string}
begin result:=0; len:=length(search);
if len=0 then  {trivial case}
  begin result:=""; goto found;
  end
else  begin s:=search-1;  {start search with newest string below |s|; |search>1|!}
  while s>255 do  {first 256 strings depend on implementation!!}
    begin if length(s)=len then
      if str_eq_str(s,search) then
        begin result:=s; goto found;
        end;
    decr(s);
    end;
  end;
found:search_string:=result;
end;

@ The following routine is a variant of |make_string|.  It searches
the whole string pool for a string equal to the string currently built
and returns a found string.  Otherwise a new string is created and
returned.  Be cautious, you can not apply |flush_string| to a replaced
string!

@<Declare additional routines for string recycling@>=
function slow_make_string : str_number;
label exit;
var s: str_number; {result of |search_string|}
@!t: str_number; {new string}
begin t:=make_string; s:=search_string(t);
if s>0 then
  begin flush_string; slow_make_string:=s; return;
  end;
slow_make_string:=t;
exit:end;

@* \[54/ML\TeX] System-dependent changes for ML\TeX.

The boolean variable |mltex_p| is set by web2c according to the given
command line option (or an entry in the configuration file) before any
\TeX{} function is called.

@<Global...@> =
@!mltex_p: boolean;

@ The boolean variable |mltex_enabled_p| is used to enable ML\TeX's
character substitution.  It is initialised to |false|.  When loading
a \.{FMT} it is set to the value of the boolean |mltex_p| saved in
the \.{FMT} file.  Additionally it is set to the value of |mltex_p|
in Ini\TeX.

@<Glob...@>=
@!mltex_enabled_p:boolean;  {enable character substitution}


@ @<Set init...@>=
mltex_enabled_p:=false;

@ The function |effective_char| computes the effective character with
respect to font information.  The effective character is either the
base character part of a character substitution definition, if the
character does not exist in the font or the character itself.

Inside |effective_char| we can not use |char_info| because the macro
|char_info| uses |effective_char| calling this function a second time
with the same arguments.

If neither the character |c| exists in font |f| nor a character
substitution for |c| was defined, you can not use the function value
as a character offset in |char_info| because it will access an
undefined or invalid |font_info| entry!  Therefore inside |char_info|
and in other places, |effective_char|'s boolean parameter |err_p| is
set to |true| to issue a warning and return the incorrect
replacement, but always existing character |font_bc[f]|.
@^inner loop@>

@<Declare additional functions for ML\TeX@>=
function effective_char(@!err_p:boolean;
                        @!f:internal_font_number;@!c:quarterword):integer;
label found;
var base_c: integer; {or |eightbits|: replacement base character}
@!result: integer; {or |quarterword|}
begin result:=c;  {return |c| unless it does not exist in the font}
if not mltex_enabled_p then goto found;
if font_ec[f]>=qo(c) then if font_bc[f]<=qo(c) then
  if char_exists(orig_char_info(f)(c)) then  {N.B.: not |char_info|(f)(c)}
    goto found;
if qo(c)>=char_sub_def_min then if qo(c)<=char_sub_def_max then
  if char_list_exists(qo(c)) then
    begin base_c:=char_list_char(qo(c));
    result:=qi(base_c);  {return |base_c|}
    if not err_p then goto found;
    if font_ec[f]>=base_c then if font_bc[f]<=base_c then
      if char_exists(orig_char_info(f)(qi(base_c))) then goto found;
    end;
if err_p then  {print error and return existing character?}
  begin begin_diagnostic;
  print_nl("Missing character: There is no "); print("substitution for ");
@.Missing character@>
  print_ASCII(qo(c)); print(" in font ");
  slow_print(font_name[f]); print_char("!"); end_diagnostic(false);
  result:=qi(font_bc[f]); {N.B.: not non-existing character |c|!}
  end;
found: effective_char:=result;
end;


@ The function |effective_char_info| is equivalent to |char_info|,
except it will return |null_character| if neither the character |c|
exists in font |f| nor is there a substitution definition for |c|.
(For these cases |char_info| using |effective_char| will access an
undefined or invalid |font_info| entry.  See the documentation of
|effective_char| for more information.)
@^inner loop@>

@<Declare additional functions for ML\TeX@>=
function effective_char_info(@!f:internal_font_number;
                             @!c:quarterword):four_quarters;
label exit;
var ci:four_quarters; {character information bytes for |c|}
@!base_c:integer; {or |eightbits|: replacement base character}
begin if not mltex_enabled_p then
  begin effective_char_info:=orig_char_info(f)(c); return;
  end;
if font_ec[f]>=qo(c) then if font_bc[f]<=qo(c) then
  begin ci:=orig_char_info(f)(c);  {N.B.: not |char_info|(f)(c)}
  if char_exists(ci) then
    begin effective_char_info:=ci; return;
    end;
  end;
if qo(c)>=char_sub_def_min then if qo(c)<=char_sub_def_max then
  if char_list_exists(qo(c)) then
    begin {|effective_char_info:=char_info(f)(qi(char_list_char(qo(c))));|}
    base_c:=char_list_char(qo(c));
    if font_ec[f]>=base_c then if font_bc[f]<=base_c then
      begin ci:=orig_char_info(f)(qi(base_c));  {N.B.: not |char_info|(f)(c)}
      if char_exists(ci) then
        begin effective_char_info:=ci; return;
        end;
      end;
    end;
effective_char_info:=null_character;
exit:end;


@ This code is called for a virtual character |c| in |hlist_out|
during |ship_out|.  It tries to built a character substitution
construct for |c| generating appropriate \.{DVI} code using the
character substitution definition for this character.  If a valid
character substitution exists \.{DVI} code is created as if
|make_accent| was used.  In all other cases the status of the
substituion for this character has been changed between the creation
of the character node in the hlist and the output of the page---the
created \.{DVI} code will be correct but the visual result will be
undefined.

Former ML\TeX\ versions have replaced the character node by a
sequence of character, box, and accent kern nodes splicing them into
the original horizontal list.  This version does not do this to avoid
a)~a memory overflow at this processing stage, b)~additional code to
add a pointer to the previous node needed for the replacement, and
c)~to avoid wrong code resulting in anomalies because of the use
within a \.{\\leaders} box.

@<Output a substitution, |goto continue| if not possible@>=
  begin
  @<Get substitution information, check it, goto |found|
  if all is ok, otherwise goto |continue|@>;
found: @<Print character substition tracing log@>;
  @<Rebuild character using substitution information@>;
  end


@ The global variables for the code to substitute a virtual character
can be declared as local.  Nonetheless we declare them as global to
avoid stack overflows because |hlist_out| can be called recursivly.

@<Glob...@>=
@!accent_c,@!base_c,@!replace_c:integer;
@!ia_c,@!ib_c:four_quarters; {accent and base character information}
@!base_slant,@!accent_slant:real; {amount of slant}
@!base_x_height:scaled; {accent is designed for characters of this height}
@!base_width,@!base_height:scaled; {height and width for base character}
@!accent_width,@!accent_height:scaled; {height and width for accent}
@!delta:scaled; {amount of right shift}


@ Get the character substitution information in |char_sub_code| for
the character |c|.  The current code checks that the substition
exists and is valid and all substitution characters exist in the
font, so we can {\it not\/} substitute a character used in a
substitution.  This simplifies the code because we have not to check
for cycles in all character substitution definitions.

@<Get substitution information, check it...@>=
  if qo(c)>=char_sub_def_min then if qo(c)<=char_sub_def_max then
    if char_list_exists(qo(c)) then
      begin  base_c:=char_list_char(qo(c));
      accent_c:=char_list_accent(qo(c));
      if (font_ec[f]>=base_c) then if (font_bc[f]<=base_c) then
        if (font_ec[f]>=accent_c) then if (font_bc[f]<=accent_c) then
          begin ia_c:=char_info(f)(qi(accent_c));
          ib_c:=char_info(f)(qi(base_c));
          if char_exists(ib_c) then
            if char_exists(ia_c) then goto found;
          end;
      begin_diagnostic;
      print_nl("Missing character: Incomplete substitution ");
@.Missing character@>
      print_ASCII(qo(c)); print(" = "); print_ASCII(accent_c);
      print(" "); print_ASCII(base_c); print(" in font ");
      slow_print(font_name[f]); print_char("!"); end_diagnostic(false);
      goto continue;
      end;
  begin_diagnostic;
  print_nl("Missing character: There is no "); print("substitution for ");
@.Missing character@>
  print_ASCII(qo(c)); print(" in font ");
  slow_print(font_name[f]); print_char("!"); end_diagnostic(false);
  goto continue


@ For |tracinglostchars>99| the substitution is shown in the log file.

@<Print character substition tracing log@>=
 if tracing_lost_chars>99 then
   begin begin_diagnostic;
   print_nl("Using character substitution: ");
   print_ASCII(qo(c)); print(" = ");
   print_ASCII(accent_c); print(" "); print_ASCII(base_c);
   print(" in font "); slow_print(font_name[f]); print_char(".");
   end_diagnostic(false);
   end


@ This outputs the accent and the base character given in the
substitution.  It uses code virtually identical to the |make_accent|
procedure, but without the node creation steps.

Additionally if the accent character has to be shifted vertically it
does {\it not\/} create the same code.  The original routine in
|make_accent| and former versions of ML\TeX{} creates a box node
resulting in |push| and |pop| operations, whereas this code simply
produces vertical positioning operations.  This can influence the
pixel rounding algorithm in some \.{DVI} drivers---and therefore will
probably be changed in one of the next ML\TeX{} versions.

@<Rebuild character using substitution information@>=
  base_x_height:=x_height(f);
  base_slant:=slant(f)/float_constant(65536);
@^real division@>
  accent_slant:=base_slant; {slant of accent character font}
  base_width:=char_width(f)(ib_c);
  base_height:=char_height(f)(height_depth(ib_c));
  accent_width:=char_width(f)(ia_c);
  accent_height:=char_height(f)(height_depth(ia_c));
  @/{compute necessary horizontal shift (don't forget slant)}@/
  delta:=round((base_width-accent_width)/float_constant(2)+
            base_height*base_slant-base_x_height*accent_slant);
@^real multiplication@>
@^real addition@>
  dvi_h:=cur_h;  {update |dvi_h|, similar to the last statement in module 620}
  @/{1. For centering/horizontal shifting insert a kern node.}@/
  cur_h:=cur_h+delta; synch_h;
  @/{2. Then insert the accent character possibly shifted up or down.}@/
  if ((base_height<>base_x_height) and (accent_height>0)) then
    begin {the accent must be shifted up or down}
    cur_v:=base_line+(base_x_height-base_height); synch_v;
    if accent_c>=128 then dvi_out(set1);
    dvi_out(accent_c);@/
    cur_v:=base_line;
    end
  else begin synch_v;
    if accent_c>=128 then dvi_out(set1);
    dvi_out(accent_c);@/
    end;
  cur_h:=cur_h+accent_width; dvi_h:=cur_h;
  @/{3. For centering/horizontal shifting insert another kern node.}@/
  cur_h:=cur_h+(-accent_width-delta);
  @/{4. Output the base character.}@/
  synch_h; synch_v;
  if base_c>=128 then dvi_out(set1);
  dvi_out(base_c);@/
  cur_h:=cur_h+base_width;
  dvi_h:=cur_h {update of |dvi_h| is unnecessary, will be set in module 620}


@* \[54/delayed] System-dependent changes for delayed font.

Various modules necessary for `delayed font'. The font defined as a delayed
font is not loaded when defined, but it is loaded when the font is first used.
In other words, it is an on-demmand-loaded font.

We define a new box to express the status of the delayed font. We call such
a box a df-box. It is similar to |glue_spec| but it can be an |equiv| value
of the command.
@d df_spec_size=4
@d df_ref_count(#) == link(#)
@d df_null=0
@d df_font=1
@d df_loaded=2
@d df_share=3
@d df_sharedelayed=4
@d df_fname(#) == mem[#+1].hh.rh
@d df_farea(#) == mem[#+1].hh.lh
@d df_fidtext(#) == mem[#+2].hh.rh
@d df_scaled(#) == mem[#+3].sc
@d df_fnum(#) == mem[#+3].int
@d df_dfref(#) == link(#+3)

@ @<Define additional ref-type box@>=
function new_df_spec(@!dt:small_number;@!fn,@!fa,@!t:str_number):pointer;
var q:pointer; {the new spec}
begin q:=get_node(df_spec_size);@/
type(q):=dt; df_ref_count(q):=null;
df_fname(q):=fn; df_farea(q):=fa; df_fidtext(q):=t;
new_df_spec:=q;
end;

@ @<Destroy additional ref-type box@>=
procedure delete_df_ref(@!p:pointer); {|p| points to a dfont specification}
begin if df_ref_count(p)=null then begin
  if type(p)=df_sharedelayed then delete_df_ref(df_dfref(p));
  free_node(p,df_spec_size);
  end
else decr(df_ref_count(p));
end;

@ @<Cases of |eq_destroy| for additional ref-type box in |equiv_field|@>=
demmand_font: delete_df_ref(equiv_field(w));

@ @<Put each...@>=
primitive("delayedfont",def_dfont,0);@/
@!@:delayedfont_}{\.{\\delayedfont} primitive@>

@ @<Cases of |print_cmd_chr|...@>=
def_dfont: print_esc("delayedfont");

@ @<New prefixed commands@>=
any_mode(def_dfont),

@ The df-box is generated here. It contains the information for loading
the font when it is used.

@<Assignments@>=
def_dfont: new_dfont(a);

@ @<Declare subprocedures needed for delayed font@>=
procedure new_dfont(@!a:small_number);
label done,common_ending;
var u:pointer; {user's font identifier}
@!s:scaled; {stated ``at'' size, or negative of scaled magnification}
@!f:internal_font_number; {runs through existing fonts}
@!t:str_number; {name for the frozen font identifier}
@!old_setting:0..max_selector; {holds |selector| setting}
@!flushable_string:str_number; {string not yet referenced}
@!dftype:small_number;
@!p,@!q:pointer;
@!save_jendline_type:integer;
begin if job_name=0 then open_log_file;
  {avoid confusing \.{texput} with the font name}
@.texput@>
get_r_token; u:=cur_cs;
if u>=hash_base then t:=text(u)
else if u>=single_base then
  if u=null_cs then t:="FONT"@+else t:=u-single_base
else  begin old_setting:=selector; selector:=new_string;
  print("FONT"); print(u-active_base); selector:=old_setting;
@.FONTx@>
  str_room(1); t:=make_string;
  end;
scan_optional_equals; scan_file_name;
dftype:=df_font;
@<Scan the font size spec or the font to share and set |dftype|@>;
if dftype=df_font then begin
  @<If this font has already been loaded, set |f| to the internal
    font number and |goto common_ending|@>;
  p:=new_df_spec(df_font,cur_name,cur_area,t); df_scaled(p):=s;
  define(u,demmand_font,p);
  goto done;
 common_ending: define(u,set_font,f);
  eqtb[font_id_base+f]:=eqtb[u]; font_id_text(f):=t;
 done:
  end
else if dftype=df_share then begin
  p:=new_df_spec(df_share,cur_name,cur_area,t); df_fnum(p):=cur_chr;
  define(u,demmand_font,p);
  end
else if dftype=df_sharedelayed then begin
  p:=new_df_spec(df_sharedelayed,cur_name,cur_area,t);
  if type(cur_chr)=df_sharedelayed then q:=df_dfref(cur_chr)
  else q:=cur_chr;
  add_df_ref(q); df_dfref(p):=q;
  define(u,demmand_font,p);
  end
else
  define(u,set_font,null_font);
end;

@ @<Scan the font size spec or the font to share and set |dftype|@>=
name_in_progress:=true; {this keeps |cur_name| from being changed}
save_jendline_type:=jendline_type; jendline_type:=jend_ascii;
if scan_keyword("at") then @<Put the \(p)(positive) `at' size into |s|@>
@.at@>
else if scan_keyword("scaled") then
@.scaled@>
  begin scan_int; s:=-cur_val;
  if (cur_val<=0)or(cur_val>32768) then
    begin print_err("Illegal magnification has been changed to 1000");@/
@.Illegal magnification...@>
    help1("The magnification ratio must be between 1 and 32768.");
    int_error(cur_val); s:=-1000;
    end;
  end
else if scan_keyword("share") then @<Get the font to share@>
@.share@>
else s:=-1000;
name_in_progress:=false; jendline_type:=save_jendline_type

@ @<Get the font to share@>=
begin @<Get the next non-blank non-call token@>;
if cur_cmd=set_font then dftype:=df_share
else if cur_cmd=demmand_font then dftype:=df_sharedelayed
else begin print_err("Improper `share' font");@/
  help1("Delayed font can share tfm with font or delayed font");
  error; dftype:=df_null;
  end
end

@ @<Cases of |print_cmd_chr|...@>=
demmand_font: begin print("delayed font ");
  case type(chr_code) of
  df_font: print("not loaded");
  df_loaded: print("loaded");
  df_share: print("share");
  df_sharedelayed: print("sharedelayed");
  othercases print("ERROR");
  endcases;
  end;

@ @<New prefixed commands@>=
any_mode(demmand_font),

@ Execution of the df-box (|cur_chr|) changes the state of the box and
yields the font number. It is assigned to |cur_cs|.

@<Assignments@>=
demmand_font: load_set_dfont(a,cur_cs,cur_chr);

@ @<Declare subprocedures needed for delayed font@>=
function load_dfont(@!u,@!p:pointer):internal_font_number;
{|u| is used just to get command name in error reporting.}
label done,done1,common_ending;
var s:scaled;
@!tfm_f,@!f:internal_font_number;
@!nom,@!aire:str_number;
@!flushable_string:str_number; {string not yet referenced}
@!q:pointer;
begin
case type(p) of
df_font: begin cur_name:=df_fname(p); cur_area:=df_farea(p); s:=df_scaled(p);
  @<If this font has already been loaded, set |f| to the internal
    font number and |goto common_ending|@>;
  f:=read_font_info(u,cur_name,cur_area,s);
  end;
df_loaded: begin f:=df_fnum(p); goto done1; end;
df_share: begin tfm_f:=df_fnum(p);
  cur_name:=df_fname(p); cur_area:=df_farea(p); s:=font_size[tfm_f];
  @<If this font has already been loaded, set |f| to the internal
    font number and |goto common_ending|@>;
  nom:=cur_name; aire:=cur_area;
  @<Copy TFM infomation from |tfm_f| to new font |f|@>;
  end;
df_sharedelayed: begin q:=df_dfref(p);
  if type(q)=df_font then begin type(p):=df_font;
    nom:=df_fname(p); aire:=df_farea(p);
    df_fname(p):=df_fname(q); df_farea(p):=df_farea(q);
    df_scaled(p):=df_scaled(q);
    f:=load_dfont(u,p);
    df_fname(p):=nom; df_farea(p):=aire;
    font_name[f]:=nom; font_area[f]:=aire;
    type(q):=df_share; df_fnum(q):=f;
    end
  else begin type(p):=df_share; df_fnum(p):=df_fnum(q);
    f:=load_dfont(u,p);
    end;
  delete_df_ref(q); goto done;
  end;
endcases;
common_ending: type(p):=df_loaded; df_fnum(p):=f;
done1: eq_type(font_id_base+f):=set_font; equiv(font_id_base+f):=f;
font_id_text(f):=df_fidtext(p);
done: load_dfont:=f;
end;

@ @<Copy TFM infomation from |tfm_f| to new font |f|@>=
if (font_ptr=font_max) then begin f:=null_font;
  @<Apologize for not loading the font, |goto done|@>;
  end;
font_ptr:=font_ptr+1; f:=font_ptr; {new font pointer}
char_base[f]:=char_base[tfm_f];
width_base[f]:=width_base[tfm_f];
height_base[f]:=height_base[tfm_f];
depth_base[f]:=depth_base[tfm_f];
italic_base[f]:=italic_base[tfm_f];
lig_kern_base[f]:=lig_kern_base[tfm_f];
kern_base[f]:=kern_base[tfm_f];
exten_base[f]:=exten_base[tfm_f];
param_base[f]:=param_base[tfm_f];
font_check[f]:=font_check[tfm_f];
font_size[f]:=font_size[tfm_f];
font_dsize[f]:=font_dsize[tfm_f];
font_params[f]:=font_params[tfm_f];
font_name[f]:=nom; {This and area should be distinct from TFM file}
font_area[f]:=aire;
font_bc[f]:=font_bc[tfm_f];
font_ec[f]:=font_ec[tfm_f];
font_glue[f]:=font_glue[tfm_f];
bchar_label[f]:=bchar_label[tfm_f];
font_bchar[f]:=font_bchar[tfm_f];
font_false_bchar[f]:=font_false_bchar[tfm_f];
hyphen_char[f]:=hyphen_char[tfm_f];
skew_char[f]:=skew_char[tfm_f];
j_font_table[f]:=j_font_table[tfm_f];

@ @<Declare subprocedures needed for delayed font@>=
procedure load_set_dfont(@!a,@!u,@!p:pointer);
var f:internal_font_number;
begin
  f:=load_dfont(u,p);
  deq_define(u,set_font,f);
  define(cur_font_loc,data,f);
end;

@ @<Declare subprocedures needed for delayed font@>=
procedure load_dfont_proc;
begin
  cur_chr:=load_dfont(cur_cs,cur_chr);
end;


@* \[54/\JTeX] System-dependent changes for \JTeX.

Various modules necessary for JTeX.
From here to the end of the file, JTeX related modules are gathered.

First of all we need an array which holds a correspondence between generic
sub font identifier such as "jsy", "jhira", "ja" and the pointer to
|eqtb| entry which contains the current corresponding font number.

@d max_j_sub_font=33

@<Types ...@>=
s_f_range=1..max_j_sub_font;
s_f_range0=0..max_j_sub_font;

@ @<Glob...@>=
@!j_s_font_pointer: array [s_f_range] of halfword;

@ You need to initialize this array together with entering sub font identifier
into \TeX's hash table.

@d init_end(#) == j_s_font_pointer[#]:=cur_val
@d enter_and_init(#) == primitive(#,set_font,null_font); init_end
@d jsubfp_a = 8

@<Put each...@>=
enter_and_init("jsy")(1);@/
enter_and_init("jroma")(2);@/
enter_and_init("jhira")(3);@/
enter_and_init("jkata")(4);@/
enter_and_init("jgreek")(5);@/
enter_and_init("jrussian")(6);@/
enter_and_init("jkeisen")(7);@/
enter_and_init("ja")(8);@/
enter_and_init("jb")(9);@/
enter_and_init("jc")(10);@/
enter_and_init("jd")(11);@/
enter_and_init("je")(12);@/
enter_and_init("jf")(13);@/
enter_and_init("jg")(14);@/
enter_and_init("jh")(15);@/
enter_and_init("ji")(16);@/
enter_and_init("jj")(17);@/
enter_and_init("jk")(18);@/
enter_and_init("jl")(19);@/
enter_and_init("jm")(20);@/
enter_and_init("jn")(21);@/
enter_and_init("jo")(22);@/
enter_and_init("jp")(23);@/
enter_and_init("jq")(24);@/
enter_and_init("jr")(25);@/
enter_and_init("js")(26);@/
enter_and_init("jt")(27);@/
enter_and_init("ju")(28);@/
enter_and_init("jv")(29);@/
enter_and_init("jw")(30);@/
enter_and_init("jx")(31);@/
enter_and_init("jy")(32);@/
enter_and_init("jz")(33);@/

@ To compute sub font number |f| and character number |c| from JIS code
(ku and ten), we use the following function |compute_f_c|.  The result is
packed into a halfword so that it can be stored as |cur_chr| and can be
used in token list.

@<Utility functions and procedures for Japanese@>=
function compute_f_c(ku,ten:integer):halfword;
label exit;
var f:s_f_range;
    c:eight_bits;
    n:integer;
begin ku:=ku-32; ten:=ten-32;
 compute_f_c:=256+1; {treat invalid char as JIS space (1ku 1ten)}
 if (ku<=0)or((ku>=9)and(ku<=15))or(ku>84) then
   @<Report invalid ku in JIS code and |goto exit|@>;
 if (ten<1)or(ten>94) then @<Report invalid ten in JIS code and |goto exit|@>;
 if ku<=8 then begin case ku of
                     1: begin f:=1; c:=ten end;
                     2: begin f:=1; c:=ten+100 end;
                     3: begin f:=2; c:=ten+32 end;
                     othercases begin f:=ku-1; c:=ten end
                     endcases end
 else if ku<=47 then {Daiichi Suijun}
  begin n:=(ku-16)*94+ten-1; f:=(n div 256)+8; c:=n-(f-8)*256 end
 else {Daini Suijun}
  begin n:=(ku-48)*94+ten-1; f:=(n div 256)+20; c:=n-(f-20)*256 end;
 compute_f_c:=256*f+c;
exit: end;

@ @<Report invalid ku in JIS code and |goto exit|@>=
begin print_err("Japanese text contains an invalid character");
@.Japanese text...@>
help1("First byte of two bytes JIS code is out of proper range (1<=ku<=94)");@/
deletions_allowed:=false; error; deletions_allowed:=true;
goto exit;
end

@ @<Report invalid ten in JIS code and |goto exit|@>=
begin print_err("Japanese text contains an invalid character");
@.Japanese text...@>
help1("Second byte of two bytes JIS code is out of proper range (1<=ten<=94)");@/
deletions_allowed:=false; error; deletions_allowed:=true;
goto exit;
end

@ This is a function to compute ku and ten from internal font number and
character number.

@<Utility ...@>=
function ku_ten_compute(f,c:integer):halfword;
var ku:1..94;
    ten:1..94;
    n:integer;
begin
 if f<=7 then begin case f of
                    1: if c>=100 then begin ku:=2; ten:=c-100 end
                                 else begin ku:=1; ten:=c end;
                    2: begin ku:=3; ten:=c-32 end;
                    othercases begin ku:=f+1; ten:=c end
                    endcases end
 else if f<=19 then {Daiichi Suijun}
  begin n:=(f-8)*256+c; ku:=(n div 94)+16; ten:=(n mod 94)+1 end
 else {Daini Suijun}
  begin n:=(f-20)*256+c; ku:=(n div 94)+48; ten:=(n mod 94)+1 end;
 ku_ten_compute:=256*(ku+32)+(ten+32);
end;

@ We use the following table to get sub font number from the internal font
number.

@<Glob...@>=
@!j_font_table: ^s_f_range0;

@ @<Initialize table entries...@>=
j_font_table[null_font]:=0;

@ @<Utility ...@>=
function j_font_p(f:integer): s_f_range0;
begin
j_font_p:=j_font_table[f];
end;

@ Following code is used to specify kanji terminal type and kanji file type.
Kanji code of input and output is controlled by \.{\\kanjiterminaltype} and
\.{\\kanjifiletype}.

@d ascii_only = 0
@d jis_1 = 1 {The third byte for enter kanji is at sign and that for exit
                kanji is J}
@d jis_2 = 2 {at sign and H}
@d jis_3 = 3 {at sign and B}
@d jis_4 = 4 {B and J}
@d jis_5 = 5 {B and H}
@d jis_6 = 6 {B and B}
@d shift_jis = 10 {shift jis code}
@d jis7_1 = 11 {jis_1 with 8bit through}
@d jis7_2 = 12 {jis_2 with 8bit through}
@d jis7_3 = 13 {jis_3 with 8bit through}
@d jis7_4 = 14 {jis_4 with 8bit through}
@d jis7_5 = 15 {jis_5 with 8bit through}
@d jis7_6 = 16 {jis_6 with 8bit through}
@d EUC = 20 {Extended Unix Code, eighth bit is on for both bytes}

@d all_kanji_code == ascii_only,jis_1,jis_2,jis_3,jis_4,jis_5,jis_6,jis7_1,jis7_2,jis7_3,jis7_4,jis7_5,jis7_6,shift_jis,EUC

@ @<Glob...@>=
@!kanji_term_init : boolean;

@ Initialize kanjiterminaltype and kanjifiletype.

@<Initialize table entries...@>=
kanji_terminal_type:=0; {|ascii_only|}
kanji_file_type:=0; {|ascii_only|}

@ @<Utility ...@>=
procedure check_kanji_terminal_type;
begin
  case kanji_terminal_type of
    all_kanji_code: do_nothing;
    othercases begin
      print_err("No such terminal type ");
      print_int(kanji_terminal_type);
      print(", I will change it to 1 (jis)");
      kanji_terminal_type := jis_1;
      help4("kanji terminal type code is one of the following:") @/
           (" 0:[ascii], 1:[JIS,$$@@-$(J], 2:[JIS,$$@@-$(H], 3:[JIS,$$@@-$(B],")@/
           (" 4:[JIS,$$B-$$(J], 5:[JIS,$$B-$(H], 6:[JIS,$$B-$(B],") @/
           ("10:[shift JIS], 20:[Extended Unix Code].");@/
@.kanji terminal type code...@>
      error;
      end;
  endcases;
end;
@#
procedure check_kanji_file_type;
begin
  case kanji_file_type of
    all_kanji_code: do_nothing;
    othercases begin
      print_err("No such file type ");
      print_int(kanji_file_type);
      print(", I will change it to 1 (jis)");
      kanji_file_type := jis_1;
      help4("kanji file type code is one of the following:") @/
           (" 0:[ascii], 1:[JIS,$$@@-$(J], 2:[JIS,$$@@-$(H], 3:[JIS,$$@@-$(B],")@/
           (" 4:[JIS,$$B-$$(J], 5:[JIS,$$B-$(H], 6:[JIS,$$B-$(B],") @/
           ("10:[shift JIS], 20:[Extended Unix Code].");@/
@.kanji file type code...@>
      error;
      end;
  endcases;
end;

@ The following two functions are called from the external C functions.

@<Utility ...@>=
function get_kanji_terminal_type: integer;
begin
  if kanji_term_init then begin
    check_kanji_terminal_type;
    get_kanji_terminal_type := kanji_terminal_type;
    end
  else
    get_kanji_terminal_type := ascii_only;
end;
@#
function get_kanji_file_type: integer;
begin
  check_kanji_file_type;
  get_kanji_file_type := kanji_file_type;
end;

@ Printing Japanese.

We need to know whether we have printed the first byte of KANJI
or the second.

@d KAN_ASCII = 0
@d KAN_FIRST = 1
@d KAN_SECOND = 2
@d KAN_EIGHT1 = 3
@d KAN_EIGHT2 = 4

@<Types...@>=
@!kan_stat=KAN_ASCII..KAN_EIGHT2;

@ @<Glob...@>=
@!term_kanji_stat : kan_stat;
@!log_kanji_stat : kan_stat;
@!write_kanji_stat : array[0..15] of kan_stat;

@ @<Initialize default kanji stat@>=
kanji_term_init := false;
term_kanji_stat := KAN_ASCII; log_kanji_stat := KAN_ASCII;
setoutkanjitype(term_out, ascii_only);
setinkanjitype(term_in, ascii_only);

@ @<Initialize kanji stat@>=
kanji_term_init := true;
term_kanji_stat := KAN_ASCII; log_kanji_stat := KAN_ASCII;
@<Set kanji terminal type@>;

@ @<Set init...@>=
for k:=0 to 15 do write_kanji_stat[k] := KAN_ASCII;

@ @<Declare procedures used by |print_char|@>=
procedure check_kanji_terminal_type; forward;
@#
procedure check_kanji_file_type; forward;
@#
function print_char_term(@!s:ASCII_code):boolean;
label exit;
var is_newline:boolean;
begin
  is_newline:=false;
  @<Change term kanji state@>;
  if is_newline then begin
    wterm_cr; term_offset:=0; print_char_term:=true; return;
    end;
  print_char_term:=false;
  if (term_kanji_stat=KAN_FIRST) and
     (term_offset>=max_print_line-1) then begin
    wterm_cr; term_offset:=0;
    end
  else if term_kanji_stat=KAN_EIGHT1 then return
  else if term_kanji_stat=KAN_EIGHT2 then begin
    wterm(xchr[ext_eightbit]);
    term_kanji_stat:=KAN_ASCII;
    end;
  wterm(xchr[s]); incr(term_offset);
  if term_offset>=max_print_line then begin
    wterm_cr; term_offset:=0;
    end;
exit:end;
@#
function print_char_log(@!s:ASCII_code):boolean;
label exit;
var is_newline:boolean;
begin
  is_newline:=false;
  @<Change log kanji state@>;
  if is_newline then begin
    wlog_cr; file_offset:=0; print_char_log:=true; return;
    end;
  print_char_log:=false;
  if (log_kanji_stat=KAN_FIRST) and
     (file_offset>=max_print_line-1) then begin
    wlog_cr; file_offset:=0;
    end
  else if log_kanji_stat=KAN_EIGHT1 then return
  else if log_kanji_stat=KAN_EIGHT2 then begin
    wlog(xchr[ext_eightbit]);
    log_kanji_stat:=KAN_ASCII;
    end;
  wlog(xchr[s]); incr(file_offset);
  if file_offset>=max_print_line then begin
    wlog_cr; file_offset:=0;
    end;
exit:end;

@ @<Change term kanji state@>=
begin
if term_kanji_stat=KAN_FIRST then
  term_kanji_stat:=KAN_SECOND
else if term_kanji_stat=KAN_EIGHT1 then begin
  is_newline:= make_eightbit(s)=new_line_char;
  term_kanji_stat:=KAN_EIGHT2;
  end
else if is_ext_kanji(s) then begin
  if term_kanji_stat=KAN_ASCII then @<Set kanji terminal type@>;
  term_kanji_stat:=KAN_FIRST;
  end
else if is_ext_eightbit(s) then
  term_kanji_stat:=KAN_EIGHT1
else begin
  is_newline:=@<Character |s| is the current new-line character@>;
  term_kanji_stat:=KAN_ASCII;
  end;
end

@ @<Change log kanji state@>=
begin
if log_kanji_stat=KAN_FIRST then
  log_kanji_stat:=KAN_SECOND
else if log_kanji_stat=KAN_EIGHT1 then begin
  is_newline:= make_eightbit(s)=new_line_char;
  log_kanji_stat:=KAN_EIGHT2;
  end
else if is_ext_kanji(s) then begin
  if log_kanji_stat=KAN_ASCII then @<Set kanji log type@>;
  log_kanji_stat:=KAN_FIRST;
  end
else if is_ext_eightbit(s) then
  log_kanji_stat:=KAN_EIGHT1
else begin
  is_newline:=@<Character |s| is the current new-line character@>;
  log_kanji_stat:=KAN_ASCII;
  end;
end

@ @<Print char to |write_file|@>=
begin
is_newline:=false;
if write_kanji_stat[selector]=KAN_FIRST then
  write_kanji_stat[selector]:=KAN_SECOND
else if write_kanji_stat[selector]=KAN_EIGHT1 then begin
  is_newline:= make_eightbit(s)=new_line_char;
  write_kanji_stat[selector]:=KAN_EIGHT2;
  end
else if is_ext_kanji(s) then
  write_kanji_stat[selector]:=KAN_FIRST
else if is_ext_eightbit(s) then
  write_kanji_stat[selector]:=KAN_EIGHT1
else begin
  is_newline:=@<Character |s| is the current new-line character@>;
  write_kanji_stat[selector]:=KAN_ASCII;
  end;
if is_newline then begin
  write_ln(write_file[selector]); return;
  end
else if write_kanji_stat[selector]=KAN_EIGHT1 then
else if write_kanji_stat[selector]=KAN_EIGHT2 then begin
  write(write_file[selector],xchr[ext_eightbit]);
  write_kanji_stat[selector]:=KAN_ASCII;
  end
else
  write(write_file[selector],xchr[s])
end

@ @<Set kanji terminal type@>=
begin
check_kanji_terminal_type;
setoutkanjitype(term_out, kanji_terminal_type);
end

@ @<Reset |kanjifiletype| from argument@>=
begin
if hasargcode then kanji_file_type:=getargcode;
if hasargterm then kanji_terminal_type:=getargterm;
end

@ @<Set kanji |cur_file| type@>=
begin
check_kanji_file_type;
setinkanjitype(cur_file, kanji_file_type);
end

@ @<Set kanji |read_file| type@>=
begin
check_kanji_file_type;
setinkanjitype(read_file[n], kanji_file_type);
end

@ @<Set kanji log type@>=
begin
check_kanji_file_type;
setoutkanjitype(log_file, kanji_file_type);
end

@ @<Set kanji |write_file| type@>=
begin
check_kanji_file_type;
setoutkanjitype(write_file[j], kanji_file_type);
end

@ @<Print chars in |str_pool| in printable form@>=
while j<str_start[s+1] do begin
  if is_ext_kanji(so(str_pool[j])) then begin
    print_char(so(str_pool[j])); incr(j);
    print_char(so(str_pool[j]));
    end
  else if is_ext_eightbit(so(str_pool[j])) then begin incr(j);
    print(make_eightbit(so(str_pool[j])));
    end
  else
    print(so(str_pool[j]));
  incr(j);
  end

@ @<Utility ...@>=
procedure print_j_char(sub_font:s_f_range;char_no:eight_bits);
var ku_ten:integer; {to hold ku*256+ten in japanese output}
begin
  ku_ten:=ku_ten_compute(sub_font,char_no);
  print_char(make_ext_kanji(ku_ten div 256));
  print_char(ku_ten mod 256);
end;

@ @<Utility ...@>=
procedure display_j_char(sub_font:s_f_range;char_no:eight_bits);
begin
 if kanji_terminal_type<>0 then print_j_char(sub_font,char_no)
 else begin
  print_char("{");
  print_esc(text(j_s_font_pointer[sub_font]));
  print_esc("char");
  print_int(char_no);
  print_char("}"); end
end;

@ @<Display japanese letter $(|m|,|c|)$@>=
begin {|m| contains sub font number and |c| contains character number}
 display_j_char(m,c)
end

@ Pseudo printing.

@ @<Glob...@>=
@!pseudo_kanji_stat : kan_stat; {|KAN_ASCII..KAN_EIGHT2|}

@ @<Reset |pseudo_kanji_stat|@>=
pseudo_kanji_stat:=KAN_ASCII

@ @<Store char in |trick_buf|@>=
begin
  if pseudo_kanji_stat=KAN_FIRST then begin
    trick_buf[tally mod trick_line] := s;
    tally_disp:=tally_disp+2;
    pseudo_kanji_stat:=KAN_ASCII;
    end
  else if pseudo_kanji_stat=KAN_EIGHT1 then begin
    trick_buf[tally mod trick_line] := s;
    incr(tally_disp);
    pseudo_kanji_stat:=KAN_ASCII;
    end
  else if is_ext_kanji(s) then begin
    trick_buf[tally mod trick_line] := s;
    pseudo_kanji_stat:=KAN_FIRST;
    end
  else if is_ext_eightbit(s) then
    pseudo_kanji_stat:=KAN_EIGHT1
  else begin
    trick_buf[tally mod trick_line] := s;
    incr(tally_disp);
    end
end

@ @<Print the first line of tricky pseudoprint@>=
begin
p:=first_count;
while r>0 do begin
  decr(p);
  if is_ext_eightbit(trick_buf[(p-1) mod trick_line]) then decr(p);
  decr(r);
  end;
if is_ext_char(trick_buf[(p-1) mod trick_line]) then begin
  incr(p); r:=n-1;
  end
else r:=n;
for q:=p to first_count-1 do print_char(trick_buf[q mod trick_line]);
end

@ @<Print the second line of tricky pseudoprint@>=
begin
q:=first_count;
while r>1 do begin
  if is_ext_kanji(trick_buf[q mod trick_line]) then begin
    print_char(trick_buf[q mod trick_line]); decr(r); incr(q);
    end
  else if is_ext_eightbit(trick_buf[q mod trick_line]) then incr(q);
  print_char(trick_buf[q mod trick_line]);
  decr(r); incr(q);
  end;
if (r>0) and not is_ext_char(trick_buf[q mod trick_line]) then
  print_char(trick_buf[q mod trick_line]);
end

@ @<Pseudo print chars in |buffer| in printable form@>=
begin
i:=start;
while i<j do begin
  if i=loc then set_trick_count;
  if is_ext_kanji(buffer[i]) then begin
    print_char(buffer[i]); incr(i);
    print_char(buffer[i]);
    end
  else if is_ext_eightbit(buffer[i]) then begin incr(i);
    print(make_eightbit(buffer[i]));
    end
  else
    print(buffer[i]);
  incr(i);
  end;
end

@ The kanji code of kanji in dvi special is EUC (not custumizable for now).

@<Output chars in |str_pool| into dvi@>=
k:=str_start[str_ptr]; ecount:=0;
while k<pool_ptr do begin
  if is_ext_eightbit(so(str_pool[k])) then begin
    incr(ecount); incr(k);
    end;
  incr(k);
  end;
if cur_length-ecount<256 then
  begin dvi_out(xxx1); dvi_out(cur_length-ecount);
  end
else  begin dvi_out(xxx4); dvi_four(cur_length-ecount);
  end;
k:=str_start[str_ptr];
while k<pool_ptr do begin
  if is_ext_kanji(so(str_pool[k])) then begin
    dvi_out(so(str_pool[k])); incr(k);
    dvi_out(make_ext_kanji(so(str_pool[k])));
    end
  else if is_ext_eightbit(so(str_pool[k])) then begin incr(k);
    dvi_out(make_eightbit(so(str_pool[k])));
    end
  else
    dvi_out(so(str_pool[k]));
  incr(k);
  end

@ Reading Japanese.

Find the possibly 8bit char in current position.

@d char_in_cur_pos(#) == begin
  end

@ @<Glob...@>=
@!cur_ext_chr : ASCII_code;

@ @<Determin the effective end of the line@>=
begin
if is_ext_eightbit(buffer[limit-1]) and (limit>1) then
  if make_eightbit(buffer[limit])=end_line_char then j:=limit-1
  else j:=limit+1
else if buffer[limit]=end_line_char then j:=limit
else j:=limit+1
end

@ @<Put the end-of-line-char if it is active@>=
begin
if end_line_char_inactive then decr(limit)
else if is_eightbit(end_line_char) then begin
  buffer[limit]:=ext_eightbit; incr(limit);
  buffer[limit]:=de_eightbit(end_line_char);
  end
else
  buffer[limit]:=end_line_char
end

@ @<Remove the end-of-line-char@>=
begin
if is_ext_eightbit(buffer[l-1]) and (l>1) then begin
  if make_eightbit(buffer[l])=end_line_char then l:=l-2
  end
else if buffer[l]=end_line_char then decr(l)
end

@ Following routine reset |cur_cmd| and |cur_chr| appropriately so that
japanese letters can readily be made into a token.

@<Read an extended char and reset |cur_cmd| and |cur_chr| appropriately@>=
if is_ext_kanji(cur_chr) then begin cur_cmd := jletter;
  cur_chr:=compute_f_c(de_ext_kanji(cur_chr),buffer[loc]);
  incr(loc);
  state:=mid_line; {while you are reading japanese letter, you are in |mid_line|}
  end
else begin if is_ext_eightbit(cur_chr) then begin
    cur_chr:=make_eightbit(buffer[loc]);
    incr(loc);
    end;
  cur_cmd:=cat_code(cur_chr);
  end

@ Whether the carriage return is regarded as space or not is controlled
by \.{\\jendlinetype}.

@d jend_ascii==0
@d jend_comment_bit==1
@d jend_ignore_bit==2
@d is_jend_comment(#)==odd(#)  {dirty}
@d is_jend_ignore(#)==((#)>=jend_ignore_bit)   {dirty}

@ @<Glob...@>=
@!delayed_cat_ret:boolean; {used to ignore CR after/before jletter}

@ @<Set init...@>=
delayed_cat_ret:=false;

@ @<Check if the last character of the line is japanese,
    change state, and finish line@>=
begin
if jendline_type>jend_ascii then begin
  k:=loc; backward_onechar(k); backward_onechar(k);
  jletter_endline:=is_ext_kanji(buffer[k]);
  if is_jend_comment(jendline_type) and jletter_endline then
    @<Finish line, |goto switch|@>;
  if is_jend_ignore(jendline_type) then begin
    if @<The last character is not ascii punctuation@> then begin
      delayed_cat_ret:=true;
      @<Finish line, |goto switch|@>;
      end;
    end;
  end;
@<Finish line, emit a space@>;
end

@ @<Restore delayed |cat_ret| and return, if appropriate@>=
if delayed_cat_ret then begin {|state=new_line| now}
  delayed_cat_ret:=false;
  if ({jletter_endline and} cur_cmd=spacer) or
     ((not jletter_endline) and cur_cmd<>jletter) then begin
    cur_cmd:=spacer; cur_chr:=" ";
    backward_onechar(loc); return;
    end
  end

@ @<Emit a space, |delayed_cat_ret:=false|, and return@>=
begin cur_cmd:=spacer; cur_chr:=" "; delayed_cat_ret:=false; return;
end

@ @<Check an extended char in control sequence name@>=
if is_ext_char(cur_chr) then begin incr(k);
  if is_ext_kanji(cur_chr) then cat:=jletter
  else cat:=cat_code(make_eightbit(buffer[k]));
  end
else
  cat:=cat_code(cur_chr)

@ @<Put the internal representation of |fc| in |buffer|@>=
ku_ten:=ku_ten_compute(jchr_subfont(fc),jchr_char(fc));
buffer[j]:=make_ext_kanji(ku_ten div 256);
incr(j);
buffer[j]:=ku_ten mod 256;

@ @<Put the internal representation of char in |buffer|@>=
if is_eightbit(buffer[j]) then begin
  buffer[j+1]:=de_eightbit(buffer[j]); buffer[j]:=ext_eightbit; incr(j);
  end

@ ascii cat_ret japanese

@d ascii_norm=0
@d ascii_punct=1

@<Glob...@>=
@!ascii_punct_table: array [0..max_ascii_tab] of 0..1;

@ @<Initialize table entries...@>=
for k:=0 to max_ascii_tab do ascii_punct_table[k]:=ascii_norm;

@ New primitive \.{\\asciipunct}.

@<Put each...@>=
primitive("asciipunct",set_asciipunct,0);@/
@!@:asciipunct_}{\.{\\asciipunct} primitive@>

@ @<Cases of |print_cmd_chr|...@>=
set_asciipunct: print_esc("asciipunct");

@ @<Cases of |main_control| that don't...@>=
any_mode(set_asciipunct): set_asciipunct_table;

@ Read a japanese or ascii char and set its asciipunct code.

@<Declare act...@>=
procedure set_asciipunct_table;
var c:halfword;
begin scan_char_num; c:=cur_val; scan_int; ascii_punct_table[c]:=cur_val;
end;

@ @<The last character is not ascii punctuation@>=
  (ascii_punct_table[buffer[loc-2]]<>ascii_punct)


@ This procedure is similar to |scan_chr_num| ([435]).

@<Declare procedures that scan restricted classes of integers@>=
procedure scan_j_char_num;
begin scan_int;
  if (cur_val<0) or (cur_val>8703) then {8703="21FF, subfont 33, char 255}
  begin print_err("Bad japanese character code");
  help3("Japanese character number (including ascii character) must be")@/
("less than 8703(=21FF in hexadecimal).")@/
("I changed this on to zero."); @/
int_error(cur_val); cur_val:=0; end;
end;

@ width and height+depth of japanese zenkaku character.

@<The zw width for current jfont@>=
param(16)(equiv(j_s_font_pointer[jsubfp_a]))

@ @<The zh height for current jfont@>=
param(17)(equiv(j_s_font_pointer[jsubfp_a]))

@ \.{\\string} and a japanese char ([464]).

@<get token of a char from |str_pool|@>=
if is_ext_char(t) then begin incr(k);
  if is_ext_kanji(t) then
    t:=j_letter_token_flag+compute_f_c(de_ext_kanji(t),so(str_pool[k]))
  else
    t:=other_token+make_eightbit(so(str_pool[k]));
  end
else if t=" " then t:=space_token
else t:=other_token+t


@ Pretend to autoload japanese subfonts.

@<Declare subprocedures needed for delayed font@>=
function font_jsubf(@!sf:s_f_range):internal_font_number;
var f:internal_font_number;
@!jsubf:pointer;
begin
jsubf := j_s_font_pointer[sf];
if eq_type(jsubf) = set_font then font_jsubf := equiv(jsubf)
else if eq_type(jsubf) = demmand_font then begin
  f := load_dfont(jsubf,equiv(jsubf));
  deq_define(jsubf,set_font,f);
  j_font_table[f] := sf;
  font_jsubf := f;
  end
else begin
  print_err("Improper japanese subfont "); print_cs(jsubf);
  help2("Commands that have the same name as japanese subfont")@/
  ("should not be defined");
  error; font_jsubf := null_font;
  end
end;

@ @<|cur_chr| is jis space@>=
cur_chr=256+1

@ @<set |main_i| for JIS space@>=
main_i.b2:=no_tag


@ Kinsoku shori.

Insertion of nobreak (maximum penalty) is forced when a japanese character
cannot appear at the beginning of a line or at the end of a line. (This is
called ``Kinsoku shori'' in japanese.
|jintercharskip| is inserted when both previous character and the current
character are japanese characters.

@ Some japanese characters cannot appear at the beginning of a line
(This is called "gyoutou-kinsoku") and several other characters cannot
appear at the end of a line ("gyoumatsu-kinsoku").  Special processing
of these characters is "Kinsoku shori".
This effect is realized by omitting the insertion of |jintercharskip| or
|jasciikanjiskip| before
gyoutou-kinsoku character and after a gyoumatsu-kinsoku character.

Following constants and Kinsoku table are used in Kinsoku shori.

@d no_kinsoku==0 {You don't need to worry about Kinsoku shori}
@d pre_kinsoku==1 {This character shouldn't appear at the beginning of a line}
@d post_kinsoku==2 {This shouldn't be the last character of a line}

@d max_ascii_tab==127
@d max_jsy_tab==255
@d max_jhira_tab==95
@d max_jkata_tab==95

@<Glob...@>=
@!ascii_kinsoku_table: array [0..max_ascii_tab] of 0..2;
@!jsy_kinsoku_table: array [0..max_jsy_tab] of 0..2;
@!jhira_kinsoku_table: array [0..max_jhira_tab] of 0..2;
@!jkata_kinsoku_table: array [0..max_jkata_tab] of 0..2;

@ Initialization of Kinsoku table (temporary).  You must be able to change the
data in this table from plain file or on line using new primitive.
Also you need to dump the info when the primitive is introduced and used in
jplain.tex.

@<Initialize table entries...@>=
for k:=0 to max_ascii_tab do ascii_kinsoku_table[k]:=no_kinsoku;
for k:=0 to max_jsy_tab do jsy_kinsoku_table[k]:=no_kinsoku;
for k:=0 to max_jhira_tab do jhira_kinsoku_table[k]:=no_kinsoku;
for k:=0 to max_jkata_tab do jkata_kinsoku_table[k]:=no_kinsoku;

{These will be done in jplain.tex
|ascii_kinsoku_table[34]:=post_kinsoku|; {"}
|ascii_kinsoku_table[39]:=post_kinsoku|; {'}
|ascii_kinsoku_table[40]:=post_kinsoku|; {(}
|ascii_kinsoku_table[41]:=pre_kinsoku|; {)}
|ascii_kinsoku_table[44]:=pre_kinsoku|; {,}
|ascii_kinsoku_table[46]:=pre_kinsoku|; {.}
|ascii_kinsoku_table[58]:=pre_kinsoku|; {:}
|ascii_kinsoku_table[59]:=pre_kinsoku|; {;}
|ascii_kinsoku_table[60]:=post_kinsoku|; {<}
|ascii_kinsoku_table[62]:=pre_kinsoku|; {>}
|ascii_kinsoku_table[63]:=pre_kinsoku|; {?}
|ascii_kinsoku_table[91]:=post_kinsoku|; {[}
|ascii_kinsoku_table[93]:=pre_kinsoku|; {]}
|ascii_kinsoku_table[96]:=post_kinsoku|; {`}
|ascii_kinsoku_table[123]:=post_kinsoku|; {curly open bracket}
|ascii_kinsoku_table[125]:=pre_kinsoku|; {curly close bracket}

|jsy_kinsoku_table[38]:=post_kinsoku|;
|jsy_kinsoku_table[40]:=post_kinsoku|;
|jsy_kinsoku_table[42]:=post_kinsoku|;
|jsy_kinsoku_table[44]:=post_kinsoku|;
|jsy_kinsoku_table[46]:=post_kinsoku|;
|jsy_kinsoku_table[48]:=post_kinsoku|;
|jsy_kinsoku_table[50]:=post_kinsoku|;
|jsy_kinsoku_table[52]:=post_kinsoku|;
|jsy_kinsoku_table[54]:=post_kinsoku|;
|jsy_kinsoku_table[56]:=post_kinsoku|;
|jsy_kinsoku_table[58]:=post_kinsoku|;
|jsy_kinsoku_table[79]:=post_kinsoku|;
|jsy_kinsoku_table[80]:=post_kinsoku|;
|jsy_kinsoku_table[81]:=post_kinsoku|;
|jsy_kinsoku_table[82]:=post_kinsoku|;
|jsy_kinsoku_table[87]:=post_kinsoku|;
|jsy_kinsoku_table[88]:=post_kinsoku|;

|jsy_kinsoku_table[2]:=pre_kinsoku|;
|jsy_kinsoku_table[3]:=pre_kinsoku|;
|jsy_kinsoku_table[4]:=pre_kinsoku|;
|jsy_kinsoku_table[5]:=pre_kinsoku|;
|jsy_kinsoku_table[6]:=pre_kinsoku|;
|jsy_kinsoku_table[7]:=pre_kinsoku|;
|jsy_kinsoku_table[8]:=pre_kinsoku|;
|jsy_kinsoku_table[9]:=pre_kinsoku|;
|jsy_kinsoku_table[10]:=pre_kinsoku|;
|jsy_kinsoku_table[11]:=pre_kinsoku|;
|jsy_kinsoku_table[12]:=pre_kinsoku|;
|jsy_kinsoku_table[19]:=pre_kinsoku|;
|jsy_kinsoku_table[20]:=pre_kinsoku|;
|jsy_kinsoku_table[21]:=pre_kinsoku|;
|jsy_kinsoku_table[22]:=pre_kinsoku|;
|jsy_kinsoku_table[23]:=pre_kinsoku|;
|jsy_kinsoku_table[25]:=pre_kinsoku|;
|jsy_kinsoku_table[28]:=pre_kinsoku|;
|jsy_kinsoku_table[29]:=pre_kinsoku|;
|jsy_kinsoku_table[30]:=pre_kinsoku|;
|jsy_kinsoku_table[39]:=pre_kinsoku|;
|jsy_kinsoku_table[41]:=pre_kinsoku|;
|jsy_kinsoku_table[43]:=pre_kinsoku|;
|jsy_kinsoku_table[45]:=pre_kinsoku|;
|jsy_kinsoku_table[47]:=pre_kinsoku|;
|jsy_kinsoku_table[49]:=pre_kinsoku|;
|jsy_kinsoku_table[51]:=pre_kinsoku|;
|jsy_kinsoku_table[53]:=pre_kinsoku|;
|jsy_kinsoku_table[55]:=pre_kinsoku|;
|jsy_kinsoku_table[57]:=pre_kinsoku|;
|jsy_kinsoku_table[59]:=pre_kinsoku|;
|jsy_kinsoku_table[75]:=pre_kinsoku|;
|jsy_kinsoku_table[76]:=pre_kinsoku|;
|jsy_kinsoku_table[77]:=pre_kinsoku|;
|jsy_kinsoku_table[78]:=pre_kinsoku|;

|jhira_kinsoku_table[1]:=pre_kinsoku|;
|jhira_kinsoku_table[3]:=pre_kinsoku|;
|jhira_kinsoku_table[5]:=pre_kinsoku|;
|jhira_kinsoku_table[7]:=pre_kinsoku|;
|jhira_kinsoku_table[9]:=pre_kinsoku|;
|jhira_kinsoku_table[35]:=pre_kinsoku|;
|jhira_kinsoku_table[67]:=pre_kinsoku|;
|jhira_kinsoku_table[69]:=pre_kinsoku|;
|jhira_kinsoku_table[71]:=pre_kinsoku|;
|jhira_kinsoku_table[78]:=pre_kinsoku|;

|jkata_kinsoku_table[1]:=pre_kinsoku|;
|jkata_kinsoku_table[3]:=pre_kinsoku|;
|jkata_kinsoku_table[5]:=pre_kinsoku|;
|jkata_kinsoku_table[7]:=pre_kinsoku|;
|jkata_kinsoku_table[9]:=pre_kinsoku|;
|jkata_kinsoku_table[35]:=pre_kinsoku|;
|jkata_kinsoku_table[67]:=pre_kinsoku|;
|jkata_kinsoku_table[69]:=pre_kinsoku|;
|jkata_kinsoku_table[71]:=pre_kinsoku|;
|jkata_kinsoku_table[78]:=pre_kinsoku|;
|jkata_kinsoku_table[85]:=pre_kinsoku|;
|jkata_kinsoku_table[86]:=pre_kinsoku|;}

@ New primitive \.{\\kinsokucode}.

@<Put each...@>=
primitive("kinsokucode",set_kinsoku_code,0);@/
@!@:kinsokucode_}{\.{\\kinsokucode} primitive@>

@ @<Cases of |print_cmd_chr|...@>=
set_kinsoku_code: print_esc("kinsokucode");

@ @<Cases of |main_control| that don't...@>=
any_mode(set_kinsoku_code): set_kinsoku_table;

@ Read a japanese or ascii char and set its kinsoku code.

@<Declare act...@>=
procedure set_kinsoku_table;
var @!p,@!q:pointer; {for temporary short-term use}
@!n:integer; {ditto}
begin
scan_j_char_num; p:=cur_val; scan_optional_equals; scan_int;
if ((cur_val<0) or (cur_val>2)) then begin
 print_err("Invalid Kinsoku code ("); print_int(cur_val); print_char(")");@/
 help2("Kinsoku code must be 0(no kinsoku), 1(pre kinsoku) or 2(post kinsoku).")@/
("I'm going to use 0 instead of that illegal code value.");@/
 error; cur_val:=0; end;
if p<=max_ascii_tab then {set Kinsoku code for an ASCII character}
 ascii_kinsoku_table[p]:=cur_val
else begin
 n:=p div 256; q:=p mod 256; {subfont number in n and character number in q}
 if ((n<=0)or(n=2)or(n>4)) then begin
  print_err("You cannot set Kinsoku code for this character:");
  display_j_char(n,q);
  help2("Kinsoku code can be set only for ascii character, japanese symbols,")@/
       ("hiragana and katakana.  So I will ignore this.");@/
  error; end
 else if n=1 then jsy_kinsoku_table[q]:=cur_val
        else if n=3 then jhira_kinsoku_table[q]:=cur_val
          else if n=4 then jkata_kinsoku_table[q]:=cur_val;
 end;
end;

@ Fake chars.

@d no_fake==0
@d fake_jchar==1
@d fake_char==2
@d fake_math==3

@ New primitive \.{\\fakejchar}, \.{\\fakechar}.

@<Put each...@>=
primitive("fakejchar",faker,fake_jchar);@/
@!@:fakejchar_}{\.{\\fakejchar} primitive@>
primitive("fakechar",faker,fake_char);@/
@!@:fakechar_}{\.{\\fakechar} primitive@>
primitive("fakemath",faker,fake_math);@/
@!@:fakemath_}{\.{\\fakemath} primitive@>

@ @<Cases of |print_cmd_chr|...@>=
faker: case chr_code of
  fake_jchar: print_esc("fakejchar");
  fake_char: print_esc("fakechar");
  fake_math: print_esc("fakemath");
  endcases;

@ Kinsoku shori.

@<Glob...@>=
@!main_c:halfword;
@!prev_sf:s_f_range0; {subfont of the previous character}
@!prev_c:halfword; {the previous character}
@!kinsoku_shori:boolean; {used in Kinsoku shori routine}
@!burasage_shori:boolean; {used in Burasage shori routine}
@!prev_jkern,cur_jkern:eight_bits;
@!prev_jkern_info:integer;

@ @<Kinsoku shori; insert or omit glue before jletter@>=
begin
if tail <> head then
  if is_char_node(tail) then
    if j_font_p(font(tail)) <> 0 then begin
      prev_sf:=j_font_p(font(tail)); prev_c:=character(tail);
      @<Insert or omit |jintercharskip| using Kinsoku table@>;
      end
    else begin prev_sf:=0; prev_c:=character(tail);
      @<Insert or omit |jasciikanjiskip| before jletter using Kinsoku table@>;
      end
  else if type(tail) = math_node then
    @<Insert or omit |jmathkanjiskip| before jletter using Kinsoku table@>
else {or the case tail is space}
  @<Left boundary of japanese char@>
end

@ @<Kinsoku shori; insert or omit glue after jletter@>=
begin
if tail <> head then
  if is_char_node(tail) and j_font_p(font(tail)) <> 0 then  begin
    prev_sf:=j_font_p(font(tail)); prev_c:=character(tail);
    @<Insert or omit |jasciikanjiskip| after jletter using Kinsoku table@>;
    end
end

@ @<Kinsoku shori; insert or omit glue and |goto main_loop_move|,...@>=
if prev_cmd=faker then begin
  if prev_c=fake_jchar then begin
    if cur_cmd=jletter then begin
      kinsoku_shori:=false;
      @<Test of jletter pre-kinsoku@>;
      if not kinsoku_shori then @<Insert |jintercharskip|@>;
      end
    else begin
      kinsoku_shori:=false;
      if ascii_kinsoku_table[cur_chr]=pre_kinsoku then kinsoku_shori:=true;
      if not kinsoku_shori then @<Insert |jasciikanjiskip|@>;
      end;
    goto main_loop_move;
    end
  else if prev_c=fake_char then begin
    if cur_cmd=jletter then begin
      kinsoku_shori:=false;
      @<Test of jletter pre-kinsoku@>;
      if not kinsoku_shori then @<Insert |jasciikanjiskip|@>;
      goto main_loop_move;
      end
    end
  else if prev_c=fake_math then begin
    if cur_cmd=jletter then begin
      kinsoku_shori:=false;
      @<Test of jletter pre-kinsoku@>;
      if not kinsoku_shori then @<Insert |jmathkanjiskip|@>;
      goto main_loop_move;
      end
    end
  end
else if cur_cmd=jletter then begin
  if prev_cmd=jletter then begin
    prev_sf:=jchr_subfont(prev_c); prev_c:=jchr_char(prev_c);
    @<Insert or omit |jintercharskip| using Kinsoku table@>;
    end
  else begin wrapup(rt_hit); prev_sf:=0;
    @<Insert or omit |jasciikanjiskip| before jletter using Kinsoku table@>;
    end;
  goto main_loop_move;
  end
else if prev_cmd=jletter then begin
  prev_sf:=jchr_subfont(prev_c); prev_c:=jchr_char(prev_c);
  @<Insert or omit |jasciikanjiskip| after jletter using Kinsoku table@>;
  goto main_loop_move;
  end

@ Insertion of glue between jletter and math is done in |after_math| ([1194]).

@<Kinsoku shori; insert or omit glue between jletter and math@>=
if tail <> head then
  if is_char_node(tail) then if j_font_p(font(tail)) <> 0 then begin
    prev_sf:=j_font_p(font(tail)); prev_c:=character(tail);
    @<Insert or omit |jmathkanjiskip| after jletter using Kinsoku table@>;
    end

@ Kinsoku shori (between jletter and jletter)

@<Insert or omit |jintercharskip| using Kinsoku table@>=
begin
  kinsoku_shori:=false; burasage_shori:=false;
  prev_jkern:=no_jkern; cur_jkern:=no_jkern;
  @<Test of jletter post-kinsoku@>;
  @<Test of burasage and jkern@>;
  @<Test of jletter pre-kinsoku@>;
  if @<interchar jkern@> then @<Do interchar jkern@>
  else if burasage_shori then @<Burasage shori@>;
  if not kinsoku_shori then @<Insert |jintercharskip|@>;
end

@ Kinsoku shori (between jletter and ascii)

@<Insert or omit |jasciikanjiskip| after jletter using Kinsoku table@>=
begin
  kinsoku_shori:=false; burasage_shori:=false;
  prev_jkern:=no_jkern; cur_jkern:=no_jkern;
  @<Test of jletter post-kinsoku@>;
  @<Test of burasage and jkern@>;
  if ascii_kinsoku_table[cur_chr]=pre_kinsoku then kinsoku_shori:=true;
  if @<interchar jkern@> then @<Do interchar jkern@>
  else if burasage_shori then @<Burasage shori@>;
  if not kinsoku_shori then @<Insert |jasciikanjiskip|@>;
end

@ Kinsoku shori (between ascii and jletter)

@<Insert or omit |jasciikanjiskip| before jletter using Kinsoku table@>=
begin
  kinsoku_shori:=ascii_kinsoku_table[prev_c]=post_kinsoku;
  @<Test of jletter pre-kinsoku@>;
  if not kinsoku_shori then @<Insert |jasciikanjiskip|@>;
end

@ Kinsoku shori (between jletter and math)

@<Insert or omit |jmathkanjiskip| after jletter using Kinsoku table@>=
begin
  kinsoku_shori:=false;
  @<Test of jletter post-kinsoku@>;
  if not kinsoku_shori then @<Insert |jmathkanjiskip|@>;
end

@ Kinsoku shori (between math and jletter)

@<Insert or omit |jmathkanjiskip| before jletter using Kinsoku table@>=
begin
  kinsoku_shori:=false;
  @<Test of jletter pre-kinsoku@>;
  if not kinsoku_shori then @<Insert |jmathkanjiskip|@>;
end

@ @<Test of jletter pre-kinsoku@>=
case jchr_subfont(cur_chr) of
 1: if main_c<=255 then
      if jsy_kinsoku_table[main_c]=pre_kinsoku then kinsoku_shori:=true;
 3: if main_c<=94 then
      if jhira_kinsoku_table[main_c]=pre_kinsoku then kinsoku_shori:=true;
 4: if main_c<=94 then
      if jkata_kinsoku_table[main_c]=pre_kinsoku then kinsoku_shori:=true;
 othercases do_nothing
endcases

@ @<Test of jletter post-kinsoku@>=
case prev_sf of
 1: if prev_c<=255 then
      if jsy_kinsoku_table[prev_c]=post_kinsoku then kinsoku_shori:=true;
 3: if prev_c<=94 then
      if jhira_kinsoku_table[prev_c]=post_kinsoku then kinsoku_shori:=true;
 4: if prev_c<=94 then
      if jkata_kinsoku_table[prev_c]=post_kinsoku then kinsoku_shori:=true;
 othercases do_nothing
endcases

@ @<Insert |jintercharskip|@>=
begin
if j_interchar_skip=zero_glue then
  tail_append(new_param_glue(def_j_interchar_skip_code))
else
  tail_append(new_param_glue(j_interchar_skip_code))
end

@ @<Insert |jasciikanjiskip|@>=
begin
if j_ascii_kanji_skip=zero_glue then
  tail_append(new_param_glue(def_j_ascii_kanji_skip_code))
else
  tail_append(new_param_glue(j_ascii_kanji_skip_code))
end

@ @<Insert |jmathkanjiskip|@>=
begin
if j_math_kanji_skip=zero_glue then
  tail_append(new_param_glue(def_j_math_kanji_skip_code))
else
  tail_append(new_param_glue(j_math_kanji_skip_code))
end

@ @<Insert |jspaceskip|@>=
begin
if j_space_skip=zero_glue then
  tail_append(new_param_glue(def_j_space_skip_code))
else
  tail_append(new_param_glue(j_space_skip_code))
end


@ Burasage shori.
This is an experimental hack.

@d no_burasage==0
@d burasage==1

@<Glob...@>=
@!jsy_burasage_table: array [0..max_jsy_tab] of 0..1;

@ @<Initialize table entries...@>=
for k:=0 to max_jsy_tab do jsy_burasage_table[k]:=no_burasage;

@ New primitive \.{\\burasage}.

@<Put each...@>=
primitive("burasage",set_burasage,0);@/
@!@:burasage_}{\.{\\burasage} primitive@>

@ @<Cases of |print_cmd_chr|...@>=
set_burasage: print_esc("burasage");

@ @<Cases of |main_control| that don't...@>=
any_mode(set_burasage): set_burasage_table;

@ Read a japanese or ascii char and set its burasage code.

@<Declare act...@>=
procedure set_burasage_table;
var p:halfword;
f:s_f_range;
c:eight_bits;
begin
scan_j_char_num; p:=cur_val; scan_optional_equals; scan_int;
if ((cur_val<0) or (cur_val>1)) then begin
 print_err("Invalid Burasage code ("); print_int(cur_val); print_char(")");@/
 help2("Burasage code must be 0(no burasage) or 1(burasage).")@/
      ("I'm going to use 0 instead of that illegal code value.");@/
 error; cur_val:=0; end;
if p<=max_ascii_tab then {set Burasage code for an ASCII character}
 print_err("You cannot set Burasage code for ascii character.")
else begin
 f:=jchr_subfont(p); c:= jchr_char(p);
 if f<>1 then begin
  print_err("You cannot set Burasage code for this character:");
  display_j_char(f,c);
  help2("Burasage code can be set only for japanese symbols.")@/
       ("So I will ignore this.");@/
  error;
  end
 else jsy_burasage_table[c]:=cur_val;
 end;
end;

@ burasage flag
@d br_kin==0
@d br_norm==1
@d br_bnd==2
@<Types...@>=
@!br_stat=br_kin..br_bnd;

@ @<Declare act...@>=
procedure burasage_char(@!p:pointer;@!br:br_stat);
var q:four_quarters;
@!hd:eight_bits; {|height_depth| byte}
@!b:pointer; {the new box and its character node}
@!f:internal_font_number;
@!c:quarterword;
begin c:=character(p); f:=font(p);
q:=char_info(f)(c);
tail_append(p);
if br=br_kin then
else begin tail_append(new_kern(-char_width(f)(q)));
  tail_append(new_penalty(1));
  b:=new_spec(zero_glue);
  width(b):=char_width(f)(q);
  tail_append(new_glue(b));
  if br=br_norm then tail_append(new_penalty(0));
  end;
end;


@ Kerning for japanese char.
This is an experimental hack.

@d no_jkern==0
@d pre_jkern==1
@d post_jkern==2
@d inter_jkern==3
@d bpre_jkern==4
@d bpost_jkern==5
@d pre_jkern_bit==1
@d post_jkern_bit==2
@d inter_jkern_bit==4
@d bpre_jkern_bit==8
@d bpost_jkern_bit==16
@d is_pre_jkern(#)==odd((#) div  pre_jkern_bit)
@d is_post_jkern(#)==odd((#) div  post_jkern_bit)
@d is_inter_jkern(#)==odd((#) div  inter_jkern_bit)
@d is_bpre_jkern(#)==odd((#) div  bpre_jkern_bit)
@d is_bpost_jkern(#)==odd((#) div  bpost_jkern_bit)
@d max_jkern_info=100

@<Glob...@>=
@!jsy_jkern_table: array [0..max_jsy_tab] of eight_bits;
@!jsy_bpre_jkern: array [0..max_jsy_tab] of pointer;
@!jkern_info: array [0..max_jkern_info] of integer;
@!jkern_inter_glue1: array [0..max_jkern_info] of pointer;
@!jkern_inter_glue2: array [0..max_jkern_info] of pointer;
@!last_jkern_info: integer;

@ @<Initialize table entries...@>=
for k:=0 to max_jsy_tab do jsy_jkern_table[k]:=no_jkern;
last_jkern_info:=0;

@ New primitive \.{\\jkern}.

@<Put each...@>=
primitive("jkern",set_jkern,0);@/
@!@:jkern_}{\.{\\jkern} primitive@>

@ @<Cases of |print_cmd_chr|...@>=
set_jkern: print_esc("jkern");

@ @<Cases of |main_control| that don't...@>=
any_mode(set_jkern): set_jkern_table;

@ Read a japanese or ascii char and set its jkern code.

@<Declare act...@>=
procedure set_jkern_table;
label exit;
var c1,c2:halfword;
cc:integer;
p,q:pointer;
begin scan_int;
if (cur_val<no_jkern) or (bpost_jkern<cur_val) then begin
  print_err("Invalid jkern code ("); print_int(cur_val); print_char(")");@/
  error; help0; return;
  end;
case cur_val of
no_jkern: begin scan_j_char_num;
  if jchr_subfont(cur_val)=1 then
    jsy_jkern_table[jchr_char(cur_val)]:=no_jkern;
  end;
inter_jkern: begin scan_j_char_num; c1:=cur_val;
  scan_glue(glue_val); p:=cur_val;
  scan_j_char_num; c2:=cur_val;
  scan_glue(glue_val); q:=cur_val;
  if jchr_subfont(c1)=1 then begin cc:=(256*256)*c1+c2;
    c1:=jchr_char(c1);
    jsy_jkern_table[c1]:=inter_jkern_bit;
    jkern_info[last_jkern_info]:=cc;
    jkern_inter_glue1[last_jkern_info]:=p;
    jkern_inter_glue2[last_jkern_info]:=q;
    incr(last_jkern_info);
    end;
  end;
bpre_jkern: begin scan_glue(glue_val); p:=cur_val;
  scan_j_char_num;
  if jchr_subfont(cur_val)=1 then begin c1:=jchr_char(cur_val);
    jsy_jkern_table[c1]:=bpre_jkern_bit;
    jsy_bpre_jkern[c1]:=p;
    end;
  end;
othercases begin
  print_err("Sorry, this case of jkern not implemented");
  help0; error
  end
endcases;
exit: end;

@ @<Declare act...@>=
function get_jkern_info_index(cc:integer):integer;
label exit;
var i:integer;
begin i:=last_jkern_info-1;
  while i>=0 do begin
    if jkern_info[i]=cc then begin
      get_jkern_info_index:=i; return;
      end;
    decr(i)
  end;
  get_jkern_info_index:=-1;
exit: end;

@ @<Burasage shori@>=
begin tail:=cur_q;
  {|link(cur_q)| points prev char}
  if kinsoku_shori then burasage_char(link(cur_q),br_kin)
  else burasage_char(link(cur_q),br_norm);
  if is_bpre_jkern(cur_jkern) then begin
    tail_append(new_glue(jsy_bpre_jkern[main_c]));
    goto main_loop_move;
  end;
end

@ @<Test of burasage and jkern@>=
begin
if prev_sf=1 then
  if prev_c<=255 then begin
    if jsy_burasage_table[prev_c]=burasage then burasage_shori:=true;
    prev_jkern:=jsy_jkern_table[prev_c];
    if @<interchar jkern@> then begin
      prev_jkern_info:=
        get_jkern_info_index((prev_sf*256+prev_c)*(256*256)+cur_chr);
      if prev_jkern_info<0 then prev_jkern:=prev_jkern-inter_jkern_bit;
      end;
    end;
if jchr_subfont(cur_chr)=1 then
  if main_c<=255 then begin
    cur_jkern:=jsy_jkern_table[main_c];
    end;
end

@ @<interchar jkern@>=is_inter_jkern(prev_jkern)

@ @<Do interchar jkern@>=
begin
  tail_append(new_glue(jkern_inter_glue1[prev_jkern_info]));
  tail_append(lig_stack);
  tail_append(new_glue(jkern_inter_glue2[prev_jkern_info]));
  goto big_switch;
end

@ @<Left boundary of japanese char@>=
begin
if jchr_subfont(cur_chr)=1 then
  if is_bpre_jkern(jsy_jkern_table[jchr_char(cur_chr)]) then
    tail_append(new_glue(jsy_bpre_jkern[jchr_char(cur_chr)]))
end

@ @<Right boundary of japanese char@>=
begin
if jchr_subfont(prev_c)=1 then
if jsy_burasage_table[jchr_char(prev_c)]=burasage then begin
  tail:=cur_q;
  {|link(cur_q)| points prev char}
  if cur_cmd=par_end then burasage_char(link(cur_q),br_bnd)
  else burasage_char(link(cur_q),br_norm);
  goto reswitch;
  end
end


@ Dump.

@<Dump the japanese sub font pointer@>=
dump_things(j_s_font_pointer[1], max_j_sub_font)

@ @<Undump the japanese sub font pointer@>=
undump_things(j_s_font_pointer[1], max_j_sub_font)

@ @<Dump the Kinsoku tables@>=
dump_things(ascii_punct_table[0], max_ascii_tab+1);
dump_things(ascii_kinsoku_table[0], max_ascii_tab+1);
dump_things(jsy_kinsoku_table[0], max_jsy_tab+1);
dump_things(jhira_kinsoku_table[0], max_jhira_tab+1);
dump_things(jkata_kinsoku_table[0], max_jkata_tab+1);
dump_things(jsy_burasage_table[0], max_jsy_tab+1);
dump_things(jsy_jkern_table[0], max_jsy_tab+1);

@ @<Undump the Kinsoku tables@>=
undump_things(ascii_punct_table[0], max_ascii_tab+1);
undump_things(ascii_kinsoku_table[0], max_ascii_tab+1);
undump_things(jsy_kinsoku_table[0], max_jsy_tab+1);
undump_things(jhira_kinsoku_table[0], max_jhira_tab+1);
undump_things(jkata_kinsoku_table[0], max_jkata_tab+1);
undump_things(jsy_burasage_table[0], max_jsy_tab+1);
undump_things(jsy_jkern_table[0], max_jsy_tab+1);

@ @<Dump the |j_font_table|@>=
dump_things(j_font_table[null_font], font_ptr+1-null_font)

@ @<Undump the |j_font_table|@>=
j_font_table:=xmalloc_array(s_f_range0, font_max);
undump_things(j_font_table[null_font], font_ptr+1-null_font)


@* \[54] System-dependent changes.
@z

@x
@* \[55] Index.
@y

@ @<Declare action procedures for use by |main_control|@>=

procedure insert_src_special;
var toklist, p, q : pointer;
begin
  if (source_filename_stack[in_open] > 0 and is_new_source (source_filename_stack[in_open], line)) then begin
    toklist := get_avail;
    p := toklist;
    info(p) := cs_token_flag+frozen_special;
    link(p) := get_avail; p := link(p);
    info(p) := left_brace_token+"{";
    q := str_toks (make_src_special (source_filename_stack[in_open], line));
    link(p) := link(temp_head);
    p := q;
    link(p) := get_avail; p := link(p);
    info(p) := right_brace_token+"}";
    ins_list (toklist);
    remember_source_info (source_filename_stack[in_open], line);
  end;
end;

procedure append_src_special;
var q : pointer;
begin
  if (source_filename_stack[in_open] > 0 and is_new_source (source_filename_stack[in_open], line)) then begin
    new_whatsit (special_node, write_node_size);
    write_stream(tail) := null;
    def_ref := get_avail;
    token_ref_count(def_ref) := null;
    q := str_toks (make_src_special (source_filename_stack[in_open], line));
    link(def_ref) := link(temp_head);
    write_tokens(tail) := def_ref;
    remember_source_info (source_filename_stack[in_open], line);
  end;
end;

@* \[55] Index.
@z

