#define	LOWP	16
#define	FIXP	20
#define	LOWMASK	((1<<LOWP)-1)
#define	D	(1<<(FIXP-LOWP))
#define	H	(1<<(2*LOWP-FIXP))
#define	TPT(x, y)	((x)<<(y))	/* x * 2^y */
#define	DPT(x, y)	((x)>>(y))	/* x / 2^y */

scalesp(s, d)
int s, d;
{
    int sign;
    unsigned int s1, s0, d1, d0;

    sign = 1;
    if (s < 0) {
	sign = -1;
	s *= -1;
    }
    s0 = s & LOWMASK;
    d0 = d & LOWMASK;
    s1 = s >> LOWP;
    d1 = d >> LOWP;
    return (sign *
	    (TPT(s1*d1, 2*LOWP-FIXP) +
	     DPT(s1*d0+s0*d1 + DPT(s0*d0, LOWP), FIXP-LOWP))
	    );
}
