#define	MAXCHAR		255	/* >= 255 */
#define	NONEXISTANT	-1	/* offset for raster files not found */

struct rastchar_entry {		/* character entry */
    unsigned short width, height;/* width and height in pixels */
    short xoffset, yoffset;	/* x offset and y offset in pixels */
    unsigned short nbpl;	/* # of bytes per pixel data line */
    unsigned short bbw, bbh;	/* # of bytes per pixel data line */
    union {
	unsigned int fileoffset;
	char *pixptr;
    } where;
    int tfmw;			/* TFM width */
};

#define	bitmap	where.pixptr

struct rastfntinfo {
    int hppp, vppp;
    int nfntchars;
    struct rastchar_entry ch[MAXCHAR+1];	/* character information */
};

#define	rastfinfo(fe)	((struct rastfntinfo *)((fe)->finfo))

struct rastinitfontinfo {
    int maxc;
    BOOLEAN mark[MAXCHAR+1];
};

struct rastfntinfo *alloc_rastfinfo();
#define	rastinifinfo(fe)	((struct rastinitfontinfo *)((fe)->finfo))
