/*
 * make vf which which converts ascii font in vertical mode to rotated font
 * mkvfvj2h rotchars-spec dmjsy10 tdmjsy10 /.../djmsy10.tfm [VFDIR]
 *	dmjsy10.vf
 */
#include	<stdio.h>
#include	"defs.h"
#include	"vfcodes.h"
#include	"bifont.h"

#define	UNIT	1048576		/* 1 fixpoint real = 2^20 */
#define	VFRATIO	UNIT

/* hard coded data */
/* end of hard coded data */

#define	MAXCHAR		255	/* >= 255 */
BOOLEAN mark[MAXCHAR+1];

char *font;
char *rotfont;
int vfds;
char *vfdir;
FILE *tfm, *vf;

/* set by readtfm */
extern byte header[];
extern byte width[];
extern byte char_info[];
extern int id, nt, lh, bc, ec, nw, ds;

main(ac, av)
int ac;
char *av[];
{
    int ac0;
    char name[64];

    read_vchar(av[1]);
    ac0 = 1;
    font = av[ac0+1];
    rotfont = av[ac0+2];
    if ((tfm = fopen(av[ac0+3], "rb")) == NULL) {
	fprintf(stderr, "cannot read %s\n", av[ac0+3]);
	exit(1);
    }
    if (!readtfm(tfm)) {
	fprintf(stderr, "%s is not tfm\n", av[ac0+3]);
	exit(1);
    }
    vfds = ds;

    vfdir = (ac > ac0+4) ? av[ac0+4] : "";
    sprintf(name, "%s%s.vf", vfdir, font);
    if ((vf = fopen(name, "wb")) == NULL) {
	fprintf(stderr, "cannot write %s\n", name);
	exit(1);
    }
    vertvf();
    fclose(vf);

    exit(0);
}

#define	LEN	256

read_vchar(fn)
char *fn;
{
    FILE *cf;
    char buf[LEN], *p;
    int i;
    int f, c;

    if ((cf = fopen(fn, "rb")) == NULL) {
	fprintf(stderr, "cannot read %s\n", fn);
	exit(1);
    }
    for (i = 0; fgets(buf, LEN, cf) != NULL && i <= MAXCHAR; i++) {
	compute_fc((buf[0]&0x7f)-0x20, (buf[1]&0x7f)-0x20, &f, &c);
	if (f != 1) {
	    fprintf(stderr, "%c%c is not a symbol\n", buf[0], buf[1]);
	    continue;
	}
/*
	fprintf(stderr, "%c%c %x%x\n", buf[0], buf[1],
		(buf[0]&0x7f), (buf[1]&0x7f));
*/
	mark[c] = TRUE;
    }
}

vertvf()
{
    long len;
    int i;

    putuint(vf, VF_PRE, 1);
    putuint(vf, VF_ID, 1);
    putuint(vf, 0, 1);	/* no comment */
    putbytes(vf, header, 2*4);	/* check sum & design size */

    putuint(vf, FNT_DEF1, 1);
    putuint(vf, 1, 1);
    putuint(vf, 0, 4);
    putuint(vf, VFRATIO, 4);
    putuint(vf, vfds, 4);
    putuint(vf, 0, 1);
    putuint(vf, strlen(rotfont), 1);
    putbytes(vf, rotfont, strlen(rotfont));

    for (i = bc; i <= ec; i++)
	if (mark[i])
	    vfchar(i);

    len = ftell(vf);
    for (i = 0; i < 4 - len%4; i++)
	putuint(vf, VF_POST, 1);
}

vfchar(c)
int c;
{
    int pl;
    unsigned char *b;

    pl = 2;	/* DIR 3 */
    pl += (c <= SETC_127) ? 1 : 2;

    putuint(vf, VF_LONG_CHAR, 1);
    putuint(vf, pl, 4);
    putuint(vf, c, 4);
    putbytes(vf, width+char_info[(c-bc)*4]*4, 4);
    putuint(vf, DIR, 1);
    putuint(vf, 3, 1);
    if (c <= SETC_127)
	putuint(vf, c, 1);
    else {
	putuint(vf, SET1, 1);
	putuint(vf, c, 1);
    }
}
