/*
 * make vf which converts NTT-dvi to ASCII-dvi
 * mkvfn2a dm 10 min10 /.../min10.tfm
 *	dmXXX10.vf
 */
#include	<stdio.h>
#include	"defs.h"
#include	"vfcodes.h"
#include	"bifont.h"
#include	"jsub.h"

/* hard coded data */

int na_ratio = 997580;		/* (NTT/ASC)*2^20 */
int nttcharwid = 959887;
int vfcs[21] = {
    0,
    0,
    0,
    0,
    0,
    19,
    23,
    27,
    30,
    34,
    38,
    0,
    46,
    0,
    0,
    0,
    0,
    66,
    0,
    0,
    76,
};

struct {
    int bc, ec;
} jsdata[] = {
    {0, 0},
    {2, 194},
    {33, 122},
    {1, 83},
    {1, 86},
    {1, 56},
    {1, 81},
    {1, 32},
    {0, 255},
    {0, 255},
    {0, 255},
    {0, 255},
    {0, 255},
    {0, 255},
    {0, 255},
    {0, 255},
    {0, 255},
    {0, 255},
    {0, 255},
    {0, 148},
    {0, 255},
    {0, 255},
    {0, 255},
    {0, 255},
    {0, 255},
    {0, 255},
    {0, 255},
    {0, 255},
    {0, 255},
    {0, 255},
    {0, 255},
    {0, 255},
    {0, 255},
    {0, 59},
};

struct specchar {
    int ct, gl;
} scdata[] = {
    {3, 112608},
    {4, 319056},
    {5, 240230},
    {6, 480461},
    {0, 0},
};

/* end of hard coded data */

char *ntt1, *ntt2;
char *ascfont;
int vfds0, vfds;
char *vfdir;
FILE *jfm, *vf;

/* set by readjfm */
extern char width[];
extern int nt, lh, bc, ec, nw, ds;
extern struct jfmfntinfo *jfmfi;

main(ac, av)
int ac;
char *av[];
{
    int f;
    char name[64];

    ntt1 = av[1];
    ntt2 = av[2];
    vfds0 = atoi(ntt2);
    vfds = atoi(ntt2)<<20;
    ascfont = av[3];
    if ((jfm = fopen(av[4], "rb")) == NULL) {
	fprintf(stderr, "cannot read %s\n", av[4]);
	exit(1);
    }
    readjfm(jfm);

    vfdir = (ac > 5) ? av[5] : "";
    for (f = 1; f <= NJSUBS; f++) {
	sprintf(name, "%s%s%s%s.vf", vfdir, ntt1, jsubfontname(f), ntt2);
	if ((vf = fopen(name, "wb")) == NULL) {
	    fprintf(stderr, "cannot write %s\n", name);
	    exit(1);
	}
	nttvf(f);
	fclose(vf);
    }

    exit(0);
}

nttvf(f)
int f;
{
    int jis, cc, i, len;
    int ct, gl, n;
    struct specchar *sd;
    byte b[sizeof(int)];

    putuint(vf, VF_PRE, 1);
    putuint(vf, VF_ID, 1);
    putuint(vf, 0, 1);	/* no comment */
    putuint(vf, vfcs[vfds0], 4);
    putuint(vf, vfds, 4);

    putuint(vf, FNT_DEF1, 1);
    putuint(vf, 0, 1);
    putuint(vf, 0, 4);
    putuint(vf, na_ratio, 4);
    putuint(vf, ds, 4);
    putuint(vf, 0, 1);
    putuint(vf, strlen(ascfont), 1);
    putbytes(vf, ascfont, strlen(ascfont));

    for (cc = jsdata[f].bc; cc <= jsdata[f].ec; cc++) {
	jis = compute_jis(f,cc);
	ct = getctype(jis, jfmfi);
	gl = 0;
	for (sd = scdata; sd->ct != 0; sd++)
	    if (sd->ct == ct)
		gl = sd->gl;
	if (gl != 0) {
	    n = inttob(b, scalesp(gl, na_ratio), TRUE);
	    len = 4+n;
	} else
	    len = 3;

	putuint(vf, VF_LONG_CHAR, 1);
	putuint(vf, len, 4);
	putuint(vf, cc, 4);
	putuint(vf, nttcharwid, 4);
	if (gl != 0) {
	    putuint(vf, RIGHT1+n-1, 1);
	    putbytes(vf, b, n);
	}
	putuint(vf, SET2, 1);
	putuint(vf, jis, 2);
    }

    len = ftell(vf);
    for (i = 0; i < 4 - len%4; i++)
	putuint(vf, VF_POST, 1);
}
