/*
 * make vf which converts ASCII-dvi to NTT-dvi
 * mkvfa2n dm 10 min10 /.../min10.tfm
 *	min10.vf
 */
#include	<stdio.h>
#include	"defs.h"
#include	"vfcodes.h"
#include	"bifont.h"
#include	"jsub.h"

/* hard coded data */

int an_ratio = 1102180;		/* (ASC/NTT)*2^20 */
int asccharwid = 1008957;
/*unsigned int vfcs = 0xe99fd0f6;*/

struct specchar {
    int ct, gl;
} scdata[] = {
    {1, 504478},
    {3, 252239},
    {0, 0},
};

/* end of hard coded data */

char *ntt1, *ntt2;
char *ascfont;
int vfds;
char *vfdir;
FILE *jfm, *vf;

/* set by readjfm */
extern char header[];
extern char width[];
extern int nt, lh, bc, ec, nw, ds;
extern struct jfmfntinfo *jfmfi;

main(ac, av)
int ac;
char *av[];
{
    int f;
    char name[64];

    ntt1 = av[1];
    ntt2 = av[2];
    vfds = atoi(ntt2)<<20;
    ascfont = av[3];
    if ((jfm = fopen(av[4], "rb")) == NULL) {
	fprintf(stderr, "cannot read %s\n", av[4]);
	exit(1);
    }
    readjfm(jfm);

    vfdir = (ac > 5) ? av[5] : "";
    sprintf(name, "%s%s.vf", vfdir, ascfont);
    if ((vf = fopen(name, "wb")) == NULL) {
	fprintf(stderr, "cannot write %s\n", name);
	exit(1);
    }
    ascvf();
    fclose(vf);

    exit(0);
}

#define	makejis(k,t)	((k+0x20)*256+t+0x20)

ascvf()
{
    int f, c, ku, ten;
    char jsubname[64];
    long len;
    int i;

    putuint(vf, VF_PRE, 1);
    putuint(vf, VF_ID, 1);
    putuint(vf, 0, 1);	/* no comment */
    putbytes(vf, header, 2*4);	/* check sum & design size */

    for (f = 1; f <= NJSUBS; f++) {
	putuint(vf, FNT_DEF1, 1);
	putuint(vf, f, 1);
	putuint(vf, 0, 4);
	putuint(vf, an_ratio, 4);
	putuint(vf, vfds, 4);
	putuint(vf, 0, 1);
	sprintf(jsubname, "%s%s%s", ntt1, jsubfontname(f), ntt2);
	putuint(vf, strlen(jsubname), 1);
	putbytes(vf, jsubname, strlen(jsubname));
    }

    vfspace();
    for (ku = 1, ten = 2; ten <= 94; ten++)
	if (compute_fc(ku, ten, &f, &c))
	    vfchar(makejis(ku, ten), f, c);
    for (ku = 2; ku <= 84; ku++)
	for (ten = 1; ten <= 94; ten++)
	    if (compute_fc(ku, ten, &f, &c))
		vfchar(makejis(ku, ten), f, c);

    len = ftell(vf);
    for (i = 0; i < 4 - len%4; i++)
	putuint(vf, VF_POST, 1);
}

vfspace()
{
    putuint(vf, VF_LONG_CHAR, 1);
    putuint(vf, 0, 4);
    putuint(vf, 0x2121, 4);
    putuint(vf, jfmfi->ch[0].tfmw, 4);
}

vfchar(jis, f, c)
int jis, f, c;
{
    int pl;
    int ct, gl, n;
    struct specchar *sd;
    byte b[sizeof(int)];

    pl = (f == 1) ? 0 : 1;
    pl += (c <= SETC_127) ? 1 : 2;
    ct = getctype(jis, jfmfi);
    gl = 0;
    for (sd = scdata; sd->ct != 0; sd++)
	if (sd->ct == ct)
	    gl = sd->gl;
    if (gl != 0) {
	n = inttob(b, -gl, TRUE);
	pl += 1+n;
    }
    
    putuint(vf, VF_LONG_CHAR, 1);
    putuint(vf, pl, 4);
    putuint(vf, jis, 4);
    putuint(vf, jfmfi->ch[ct].tfmw, 4);
    if (gl != 0) {
	putuint(vf, RIGHT1+n-1, 1);
	putbytes(vf, b, n);
    }
    if (f != 1)
	putuint(vf, FONT_00+f, 1);
    if (c <= SETC_127)
	putuint(vf, c, 1);
    else {
	putuint(vf, SET1, 1);
	putuint(vf, c, 1);
    }
}
