#include	<stdio.h>
#include	"defs.h"
#include	"gffont.h"

#define	NGFCHARS	256

struct gf_char_loc {
    BOOLEAN used;
    long p;
    int dm, tfm;
} gf_char_locs[NGFCHARS];
int gf_min_m, gf_max_m, gf_min_n, gf_max_n;

gfpre(gf)
FILE *gf;
{
    struct gf_char_loc *gfl;

    putuint(gf, GF_PRE, 1);
    putuint(gf, GF_ID, 1);
    putuint(gf, 0, 1);	/* no comment */

    for (gfl = gf_char_locs; gfl < gf_char_locs+NGFCHARS; gfl++) {
	gfl->used = FALSE;
	gfl->p = -1;
    }
    gf_min_m = gf_max_m = gf_min_n = gf_max_n = 0;
}

gfpost(gf, d, c, hppp, vppp)
FILE *gf;
int d, c, hppp, vppp;	/* design size, check sum */
{
    long pos, len;
    int cc, i;
    struct gf_char_loc *gfl;

    pos = ftell(gf);
    putuint(gf, GF_POST, 1);
    putuint(gf, pos, 4);
    putuint(gf, d, 4);
    putuint(gf, c, 4);
    putuint(gf, hppp, 4);
    putuint(gf, vppp, 4);
    putuint(gf, gf_min_m, 4);
    putuint(gf, gf_max_m, 4);
    putuint(gf, gf_min_n, 4);
    putuint(gf, gf_max_n, 4);

    /* char locators */
    for (gfl = gf_char_locs, cc = 0; gfl < gf_char_locs+NGFCHARS; gfl++, cc++)
	if (gfl->used) {
	    putuint(gf, GF_CHAR_LOC0, 1);
	    putuint(gf, cc, 1);
	    putuint(gf, gfl->dm, 1);
	    putuint(gf, gfl->tfm, 4);
	    putuint(gf, gfl->p, 4);
	}

    putuint(gf, GF_POSTPOST, 1);
    putuint(gf, pos, 4);
    putuint(gf, GF_ID, 1);
    len = ftell(gf);
    for (i = 0; i < 8 - len%4; i++)
	putuint(gf, GF_FILLER, 1);
}

#define	min(x,y)	((x) <= (y) ? (x) : (y))
#define	max(x,y)	((x) >= (y) ? (x) : (y))
#define	onebyte(x)	(0 <= (x) && (x) <= 255)

#define	WHITE		0
#define	BLACK		1
#define	INVERT(x)	x = 1-x
#define	rowbit(r,i)	(((*((r)+(i)/8))>>(7-(i)%8))&1)

int paint_switch;
int d;

gfchar(gf, c, dm, tfm, bm, hoff, w, bw, voff, h)
FILE *gf;
int c, dm, tfm;
byte *bm;
int hoff, w, bw, voff, h;
{
    struct gf_char_loc *gfl;
    long prevp;
    int min_m, max_m, min_n, max_n;
    byte *row;
    int i, j, j0;
    int k;
    byte b[sizeof(int)];

    gfl = gf_char_locs+c;
    gfl->used = TRUE;
    prevp = gfl->p;
    gfl->p = ftell(gf);
    gfl->dm = dm;
    gfl->tfm = tfm;

    min_m = hoff;
    max_m = min_m+w;
    max_n = voff;
    min_n = max_n-h;
    gf_min_m = min(min_m, gf_min_m);
    gf_max_m = max(max_m, gf_max_m);
    gf_min_n = min(min_n, gf_min_n);
    gf_max_n = max(max_n, gf_max_n);
    if (onebyte(w) && onebyte(max_m) && onebyte(h) && onebyte(max_n) &&
	prevp == -1) {
	putuint(gf, GF_BOC1, 1);
	putuint(gf, c, 1);
	putuint(gf, w, 1);
	putuint(gf, max_m, 1);
	putuint(gf, h, 1);
	putuint(gf, max_n, 1);
    } else {
	putuint(gf, GF_BOC, 1);
	putuint(gf, c, 4);
	putuint(gf, prevp, 4);
	putuint(gf, min_m, 4);
	putuint(gf, max_m, 4);
	putuint(gf, min_n, 4);
	putuint(gf, max_n, 4);
    }

    paint_switch = WHITE;
    d = 0;
    onerow(gf, bm, w, 0);
    for (j = 1, row = bm+bw; j < h; j++, row += bw) {
	if (paint_switch == BLACK) {
	    paint(gf, d);
	    paint_switch = WHITE;
	}
	j0 = j;
	do {
	    for (i = 0; i < w; i++)
		if (rowbit(row,i) == BLACK)
		    break;
	    if (i == w) {
		if (++j >= h)
		    goto eoc;
		row += bw;
	    } else
		break;
	} while (TRUE);
	if (j > j0) {
	    k = inttob(b, j-j0, FALSE);
	    putuint(gf, GF_SKIP0+k, 1);
	    putbytes(gf, b, k);
	    i = 0;
	} else if (i > 164) {
	    putuint(gf, GF_SKIP0, 1);
	    i = 0;
	} else {
	    putuint(gf, GF_NEW_ROW_0+i, 1);
	    paint_switch = BLACK;
	}
	d = 0;
	onerow(gf, row, w, i);
    }

 eoc:
    putuint(gf, GF_EOC, 1);
}

onerow(gf, row, w, i)
FILE *gf;
byte *row;
int w, i;
{
    for (; i < w; i++) {
	if (rowbit(row,i) == paint_switch)
	    d++;
	else {
	    paint(gf, d);
	    INVERT(paint_switch);
	    d = 1;
	}
    }
}

paint(gf, d)
FILE *gf;
int d;
{
    int k;
    byte b[sizeof(int)];

    if (d <= 63)
	putuint(gf, GF_PAINT_0+d, 1);
    else {
	k = inttob(b, d, FALSE);
	putuint(gf, GF_PAINT1+k-1, 1);
	putbytes(gf, b, k);
    }
}
