#include <stdio.h>
#include <stdlib.h>
#include <process.h>
#include <string.h>
#include <malloc.h>
#include <kpathsea/kpathsea.h>

int is_include_space(char *s)
{
  char *p;
  p = strchr(s, ' ');
  if(p) return 1;
  p = strchr(s, '\t');
  if(p) return 1;
  return 0;
}

int main(int argc, char *argv[])
{
  char *autoloc, *p, *w32tex, *texlive;
  char *libpath;
  FILE *f;
  int ret;
  int i;

  for(i = 0; i < argc; i++) {
    if(is_include_space(argv[i])) {
      p = (char *)malloc(strlen(argv[i])+3);
#if defined _MSC_VER
#define alloca _alloca
#endif
      p = alloca(strlen(argv[i])+3);
      strcpy(p, "\"");
      strcat(p, argv[i]);
      strcat(p, "\"");
      argv[i] = p;
    }
  }
  argv[argc] = NULL;

  kpse_set_program_name(argv[0], NULL);
  autoloc = kpse_var_value("SELFAUTOLOC");
  libpath = kpse_var_value("TW_LIBPATH");
  if(autoloc == NULL) {
    fprintf(stderr, "I cannot determine SELFAUTOLOC.\n");
    return 1;
  }
  for(p = autoloc; *p; p++)
    tolower(*p);
  p = strstr(autoloc, "/bin");
  if(p == NULL) {
    fprintf(stderr, "Strange SELFAUTOLOC.\n");
    return 1;
  }
  w32tex = strstr(p, "/bin");
  if(w32tex)
    p = w32tex;
  *p = '\0';
  w32tex = concat(autoloc, "/share/texworks/texworks.exe");
  texlive = concat(autoloc, "/tlpkg/texworks/texworks.exe");
  f = fopen(w32tex, "rb");
  if(f) {
    fclose(f);
    if(libpath) {
      xputenv("TW_INIPATH", libpath);
      xputenv("TW_LIBPATH", libpath);
    }
    ret = spawnv(_P_NOWAIT, w32tex, argv);
    return ret;
  } else if((f = fopen(texlive, "rb"))) {
    fclose(f);
    ret = spawnv(_P_NOWAIT, texlive, argv);
    return ret;
  } else {
    fprintf(stderr, "TeXworks is not found.\n");
    return 2;
  }
}
