/* 
   copy scriptwrapper.exe to script.exe.
   public domain.
*/
#include <kpathsea/config.h>
#include <kpathsea/kpathsea.h>
#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <process.h>

#define SBUF   256
#define LBUF   1024
#define MAXARG 256

#define PERLEXE    "/tlpkg/tlperl/bin/perl.exe"
#define SELFPARENT "SELFAUTOPARENT"
#define GSLIBLIB   "/tlpkg/tlgs/lib;"
#define GSLIBFONTS "/tlpkg/tlgs/fonts"
#define GSDLL      "/tlpkg/tlgs/bin/gsdll32.dll"
#define GSPATH     "/tlpkg/tlgs/bin;"

static int is_texlive = 0;

static int is_include_space(char *s)
{
  char *p;
  p = strchr(s, ' ');
  if(p) return 1;
  p = strchr(s, '\t');
  if(p) return 1;
  return 0;
}

char *getlname(char *name)
{
  HANDLE hnd;
  WIN32_FIND_DATA ffd;

  char *path = NULL;
  char buff[SBUF];
  char buff2[SBUF];
  char *p, *fp;

  strcpy(buff, name);
  for(p = buff; *p; p++) {
    if(IS_KANJI(p)) {
      p++;
      continue;
    }
    if(*p == '\\') *p = '/';
  }
  fp = buff;
  if(p = strrchr(fp, '/')) {
    p++;
    fp = p;
  }
  if(p = strrchr(fp, ':')) {
    p++;
    fp = p;
  }
  if(p = strrchr(fp, '.')) *p = '\0';
  strcpy(buff2, fp);

  if(SearchPath(getenv("PATH"), buff2, ".exe", SBUF, buff, &fp)) {
    if ((hnd = FindFirstFile(buff, &ffd)) == NULL) {
      return NULL;
    }
    FindClose(hnd);

    path = (char *)xmalloc(strlen(buff) + 1);
    strcpy(path, buff);
    for(p=path; *p; p++) {
      if(IS_KANJI(p)) {
        p++;
        continue;
      }
      if(*p == '\\') *p = '/';
    }
    if(p = strrchr(path, '/')) *p = '\0';
  }
  else {
    return NULL;
  }
   return path;
}

/* search for the script in the TeX bin directory */
int searchscr1(char *path, char *name, char *ext, char *dstname,
                int *interpreter, int val)
{
  char *fname;
  int  ret = 0;
  fname = concatn(path, "/", name, ext, NULL);
  if(_access(fname, 0) == 0) {
    strcpy(dstname, fname);
    *interpreter = val;
    ret = 1;
  }
  free(fname);
  return ret;
}

/* search for the script under $TEXMF/scripts// */
int searchscr2(char *name, char *ext, char *dstname,
                int *interpreter, int val)
{
  char *fname, *fullname;
  int  ret = 0;
  fname = concat(name, ext);
  fullname = kpse_find_file(fname, kpse_texmfscripts_format, 1);
  if(fullname) {
    strcpy(dstname, fullname);
    free(fullname);
    *interpreter = val;
    ret = 1;
  }
  free(fname);
  return ret;
}

int main(int ac, char **av)
{
  int  i, ret;
  char *argv[MAXARG];
  char *p, *q;
  char *av0;
  char scrname[SBUF];
  FILE *f;
  char option[LBUF];
  int  interpreter;
  char cmdname[128];
  char cmdname2[128];
  int  use1stline = 0;

  char *fullcmdname;

  char *selfautoparent;
  char *gslib;
  char *gsdll;
  char *orgpath;
  char *newpath;

  for(i=0; i < MAXARG; i++)
    argv[i] = NULL;

  kpse_set_program_name(av[0], NULL);
  av0 = kpse_program_name;
  cmdname[0] = '\0';
  cmdname2[0] = '\0';

  if(ac>MAXARG - 5) {
    fprintf(stderr, "Too many arguments.\n");
    exit (100);
  }

/* check if TeX Live or W32TeX */
  p = kpse_var_value("jtex_filetype");
  if(p) {
    is_texlive = 0;
    free(p);
  } else {
    is_texlive = 1;
  }

  if(is_texlive) {
    selfautoparent = kpse_var_value(SELFPARENT);
    if(selfautoparent == NULL) {
      fprintf(stderr, "I cannot find SELFAUTOPARENT.\n");
      exit (100);
    }
  }

  p = getlname(av0);
  if(!p) {
    fprintf(stderr, "Failed to find script loader.\n");
    exit (100);
  }

  scrname[0] = '\0';

/* first search for script in the bin directory */
/* perl or generic (no suffix, .pl, .plx, .scr) */
  if(searchscr1(p, av0, "", scrname, &interpreter, 0))
    goto Found;
  if(searchscr1(p, av0, ".pl", scrname, &interpreter, 0))
    goto Found;
  if(searchscr1(p, av0, ".plx", scrname, &interpreter, 0))
    goto Found;
  if(searchscr1(p, av0, ".scr", scrname, &interpreter, 0))
    goto Found;

/* ruby (suffix .rb) */
  if(searchscr1(p, av0, ".rb", scrname, &interpreter, 1))
    goto Found;

/* python (suffix .py) */
  if(searchscr1(p, av0, ".py", scrname, &interpreter, 2))
    goto Found;

/* texlua (suffixes .lua, .tlu, .texlua) */
  if(searchscr1(p, av0, ".lua", scrname, &interpreter, 3))
    goto Found;
  if(searchscr1(p, av0, ".tlu", scrname, &interpreter, 3))
    goto Found;
  if(searchscr1(p, av0, ".texlua", scrname, &interpreter, 3))
    goto Found;

/* search script under $TEXMF/scripts */
/* perl */
  if(searchscr2(av0, ".pl", scrname, &interpreter, 0))
    goto Found;

/* ruby */
  if(searchscr2(av0, ".rb", scrname, &interpreter, 1))
    goto Found;

/* python */
  if(searchscr2(av0, ".py", scrname, &interpreter, 2))
    goto Found;

/* lua */
  if(searchscr2(av0, ".lua", scrname, &interpreter, 3))
    goto Found;
  if(searchscr2(av0, ".tlu", scrname, &interpreter, 3))
    goto Found;
  if(searchscr2(av0, ".texlua", scrname, &interpreter, 3))
    goto Found;

/* general suffix .scr (assume perl) */
  if(searchscr2(av0, ".scr", scrname, &interpreter, 0))
    goto Found;

/* no suffix (assume perl) */
  if(searchscr2(av0, "", scrname, &interpreter, 0))
    goto Found;

  if(!scrname[0]) {
    fprintf(stderr, "Failed to find script.\n");
    exit (100);
  }

/* read the first line of the script */
 Found:

  f = fopen(scrname, "r");
  if(!f) {
    fprintf(stderr, "No script.\n");
    exit (100);
  }

  for(i=0; i < LBUF; i++)
    option[i] = '\0';

  fgets(option, LBUF-1, f);
  fclose(f);
  i = strlen(option);
  if(option[i-1] == '\n') option[i-1] = '\0';

/* we save options for interpreter in argv[1] */

  argv[1] = NULL;
  if((strstr(option, "perl")) ||
     (strstr(option, "Perl"))) {
    use1stline = 0;
    interpreter = 0;
  } else if(*option == '#' && *(option + 1) == '!') {
    p = option + 2;
    while(*p == ' ' || *p == '\t')
      p++;
    if(*p) {
      use1stline = 1;
      q = p;
      while(*p != ' ' && *p != '\t' && *p != '\0')
        p++;
      *p = '\0';
      strcpy(cmdname2, q);
      q = strrchr(cmdname2, '/');
      if (q) q++;
      else q = cmdname2;
      strcpy(cmdname, q);
      if(stricmp(cmdname, "env") == 0) {
        p++;
        while(*p == ' ' || *p == '\t')
          p++;
        q = p;
        while(*p != ' ' && *p != '\t' && *p != '\0')
          p++;
        *p = '\0';
        if(*q == '\0')
          use1stline = 0;
        else
          strcpy(cmdname, q);
      }
      p++;
      while(*p == ' ' || *p == '\t')
        p++;
      if(*p) {
        if(is_include_space(p)) {
          argv[1] = concat3("\"", p, "\"");
        } else {
          argv[1] = xmalloc(strlen(p) + 1);
          strcpy(argv[1], p);
        }
      } else {
        argv[1] = xmalloc(2);
        strcpy(argv[1], " ");
      }
    }
  }

  if(!argv[1]) {
    argv[1] = xmalloc(2);
    strcpy(argv[1], " ");
  }

  if(use1stline) {
    if((q = strstr(cmdname, "perl")))
      interpreter = 0;
    else
      interpreter = 10000;
  }

  if(!use1stline) {
    if(interpreter == 0)
      strcpy(cmdname, "perl.exe");
    else if(interpreter == 1)
      strcpy(cmdname, "ruby.exe");
    else if(interpreter == 2)
      strcpy(cmdname, "python.exe");
    else if(interpreter == 3)
      strcpy(cmdname, "texlua.exe");
    else {
      fprintf(stderr, "Unknown interpreter.\n");
      exit(100);
    }
  }

  if(is_texlive) {
    gslib = concatn(selfautoparent, GSLIBLIB, selfautoparent, GSLIBFONTS, NULL);
    gsdll = concat(selfautoparent, GSDLL);
    orgpath = getenv("PATH");
    newpath = concat3(selfautoparent, GSPATH, orgpath);
    for(p = newpath; *p; p++) {
      if(*p == '/') *p = '\\';
    }
    xputenv("PATH", newpath);
    xputenv("GS_DLL", gsdll);
    xputenv("GS_LIB", gslib);
    free(newpath);
    free(gsdll);
    free(gslib);
  }

  if(is_texlive) {
    if(interpreter) {
      if((p = getlname(cmdname)) == NULL) {
        fprintf(stderr, "Script interpreter is not found in PATH.\n");
        exit (100);
      }
    }
  } else {
    if((p = getlname(cmdname)) == NULL) {
      fprintf(stderr, "Script interpreter is not found in PATH.\n");
      exit (100);
    }
  }

  argv[0] = xmalloc(strlen(cmdname) + 1);
  strcpy(argv[0], cmdname);
  if(is_include_space(scrname)) {
    argv[2] = concat3("\"", scrname, "\"");
  } else {
    argv[2] = xmalloc(strlen(scrname) + 1);
    strcpy(argv[2], scrname);
  }

  for(i=1; i < ac; i++) {
    if(is_include_space(av[i])) {
      argv[i+2] = concat3("\"", av[i], "\"");
    } else {
      argv[i+2] = xmalloc(strlen(av[i]) + 1);
      strcpy(argv[i+2], av[i]);
    }
  }
  argv[ac+2] = NULL;

  if(is_texlive) {
    if(interpreter == 0)
      fullcmdname = concat(selfautoparent, PERLEXE);
    else
      fullcmdname = concat3(p, "/", cmdname);
  } else {
    fullcmdname = concat3(p, "/", cmdname);
  }

/*
fprintf(stderr, "%s\n", fullcmdname); 
for(i=0; i < ac + 2; i++) {
  if(argv[i])
    fprintf(stderr, "%s\n", argv[i]);
  else
    break;
}
*/

  ret = _spawnv(_P_WAIT, fullcmdname, argv);

  free(fullcmdname);
  for(i=0; i < ac + 2; i++) {
    if(argv[i])
      free(argv[i]);
    else
      break;
  }

  return ret;
}
