/* myprogname.c: An implementation of set_program_name to be used with
   Visual Studio.

   Copyright 2014 Akira Kakuto.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public License
   along with this library; if not, see <http://www.gnu.org/licenses/>.  */

#include <malloc.h>
#include <string.h>

char *program_name = NULL;

void set_program_name(char *p)
{
  char *q;

  program_name = malloc(strlen(p) + 1);
  strcpy(program_name, p);

  q = strrchr(program_name, '\\');
  if (q)
    program_name = q + 1;
  q = strrchr(program_name, '/');
  if (q)
    program_name = q + 1;
  q = strrchr(program_name, '.');
  if (q && stricmp (q, ".exe") == 0)
    *q = '\0';
  return;
}
