#include <stdio.h>
#include <string.h>
#include <malloc.h>
#include <process.h>
#include <conio.h>
#include <kpathsea/kpathsea.h>

#define CRYPTCFG "pdfcrypt.cfg"
#define ITEXT    "iText.jar"
#define ENCRYPT  "encrypt_pdf.java"

void read_cfg(char *key, char *pflag)
{
  char *fname;
  FILE *f;
  char *b;
  char buf[512];
  char b1[128];
  char b2[128];

  *key = *pflag = '\0';
  fname = kpse_find_file(CRYPTCFG, kpse_program_text_format, 0);
  if(fname == NULL) {
    return;
  }

  f = fopen(fname, "r");
  free(fname);
  if(f == NULL) {
    return;
  }

  while((b = fgets(buf, 512, f)) != NULL) {
    if(*b == '%' || *b == '#' || *b == '\n')
      continue;
    sscanf(b, "%s %s", b1, b2);
    if(b1[0] == 'K')
      strcpy(key, b2);
    else if(b1[0] == 'P')
      strcpy(pflag, b2);
    else
      continue;
  }
  fclose(f);
}

void usage(void)
{
  fprintf(stderr,"Usage     : pdfcrypt [-K keybit] [-P permission] ");
  fprintf(stderr, "old.pdf new.pdf\n");
  fprintf(stderr,"keybit    : 40 or 128\n");
  fprintf(stderr,"permission: 8 byte string of 0 or 1.\n");
  fprintf(stderr,"            See texmf/pdfcrypt/pdfcrypt.cfg.\n");
}

char *getpass (char *prompt)
{
  static char pwd_buf[128];
  size_t i;

  fputs(prompt, stderr);
  fflush(stderr);
  for (i = 0; i < sizeof(pwd_buf)-1; i++) {
    pwd_buf[i] = getch();
    if(pwd_buf[i] != '\r') {
      fputs("*", stderr);
      fflush(stderr);
    }
    if (pwd_buf[i] == '\r')
      break;
  }
  pwd_buf[i] = '\0';
  fputs("\n", stderr);
  return pwd_buf;
}


int main(int argc, char *argv[])
{
  char key[128];
  char pflag[128];
  char source[256];
  char target[256];
  char owner[128];
  char user[128];
  char cmd[512];
  char otherdata[1024];
  char *p;
  char *itext;
  char *encrypt;

  unsigned int keybit;
  char s_key[64];
  int  i;

  if(argc < 2 || (argc > 1 && !strncmp(argv[1], "-h", 2)) ||
     (argc > 1 && !strncmp(argv[1], "--h", 3))) {
    usage();
    return 0;
  }

  kpse_set_program_name(argv[0], NULL);
  read_cfg(key, pflag);

  source[0] = target[0] = otherdata[0] = '\0';

  argc--;
  argv++;
  while(argc) {
    if(!strncmp(*argv, "-K",2)) {
      if(*(*argv + 2) != '\0')
	strcpy(key, *argv + 2);
      else {
	argc--;
	argv++;
	strcpy(key, *argv);
      }
    }
    else if(!strncmp(*argv, "-P",2)) {
      if(*(*argv + 2) != '\0')
	strcpy(pflag, *argv + 2);
      else {
	argc--;
	argv++;
	strcpy(pflag, *argv);
      }
    }
    else if(source[0] == '\0' && target[0] == '\0')
      strcpy(source, *argv);
    else if(source[0] != '\0' && target[0] == '\0')
      strcpy(target, *argv);
    else {
      strcat(otherdata, " \"");
      strcat(otherdata, *argv);
      strcat(otherdata, "\"");
    }
    argc--;
    argv++;
  }

  if(!key[0] || !pflag[0] || !source[0] || !target[0]) {
    fprintf(stderr, "Maybe arguments are incorrect.\n");
    usage();
    return 1;
  }

  if(strlen(pflag) != 8) {
    fprintf(stderr, "Permission flag should be an 8byte string.\n");
    usage();
    return 1;
  }

  for(i = 0; i < 8; i++) {
    if(pflag[i] != '0' && pflag[i] != '1') {
      fprintf(stderr, "Each digit in permission flag should be 0 or 1.\n");
      return 1;
    }
  }

  keybit = strtoul(key, &p, 0);

  if(keybit != 40 && keybit != 128) {
    fprintf(stderr, "Key bit shoud be 40 or 128.\n");
    return 1;
  }

  sprintf(s_key, "%d", keybit);

  p = getpass("Input owner password: ");
  strcpy(owner, p);
  p = getpass("Input user  password: ");
  strcpy(user, p);

  if(!owner[0]) strcpy(owner, "\"\"");
  if(!user[0]) strcpy(user, "\"\"");

  itext = kpse_find_file(ITEXT, kpse_program_binary_format, 0);
  if(itext == NULL) {
    fprintf(stderr, "I cannot find " ITEXT ".\n");
    return 1;
  }

  encrypt = kpse_find_file(ENCRYPT, kpse_program_binary_format, 0);
  if(encrypt == NULL) {
    free(itext);
    fprintf(stderr, "I cannot find " ENCRYPT ".\n");
    return 1;
  }

  p = strrchr(encrypt, '/');
  if(p) *p = '\0';

  sprintf(cmd, "-cp %s;%s encrypt_pdf %s %s %s %s %s %s", encrypt, itext,
	  source, target, user, owner, pflag, s_key);

  spawnlp(P_WAIT, "java", "java", cmd, otherdata, NULL);
  free(itext);
  free(encrypt);
  return 0;
}
