/*
 * ppower4.c
 *
 * run java -jar FoundDir/pp4p.jar input.pdf output.pdf
 * where pp4p.jar is searched for by kpse_texmfscripts_format
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <malloc.h>
#include <process.h>
#include <io.h>
#include <fcntl.h>
#include <kpathsea/kpathsea.h>

#define  PP4PJAR "pp4p.jar"

char *Av[11];

int main(int argc, char *argv[])
{
  int i, ret;
  char *p;

  kpse_set_program_name(argv[0], NULL);

  if (argc > 8) {
    fprintf (stderr, "Too many arguments.\n");
    return 100;
  }

  if (argc == 1) {
    fprintf (stderr, "This runs \"java -jar Found_Dir/pp4p.jar args\"\n");
    fprintf (stderr, "Usage: ppower4 [-v|-n|-h|-V] input.pdf output.pdf\n");
    return 0;
  }

  setmode (fileno(stdin), _O_BINARY);
  setmode (fileno(stdout), _O_BINARY);

  p = kpse_find_file(PP4PJAR, kpse_texmfscripts_format, 0);
  if (!p) {
    fprintf (stderr, "I cannot find pp4p.jar.\n");
    return 100;
  }

  for (i=0; i < argc + 2; i++) {
    Av[i] = (char *)malloc(256);
    if (!Av[i]) {
      fprintf (stderr, "I cannot allocate memory.\n");
      return 100;
    }
  }

  strcpy (Av[0], "java");
  strcpy (Av[1], "-jar");
  strcpy (Av[2], p);
  free (p);
  for (i=1; i < argc; i++)
    strcpy (Av[2+i], argv[i]);
  Av[argc+2] = NULL;

  ret = spawnvp(P_WAIT, Av[0], Av);

  for (i=0; i < argc + 2; i++)
    free (Av[i]);
  return ret;
}
