/*
nts.exe : loader of nts.rt.jar for Windows
2002/06/27 --ak
*/

#include <stdio.h>
#include <stdlib.h>
#include <fcntl.h>
#include <io.h>
#include <string.h>
#include <malloc.h>
#include <process.h>
#include <kpathsea/kpathsea.h>

#define  ARGNUM  32
#define  NTS_JAR "nts.rt.jar"
char Nts_Rt_Jar[128];

char *Help[] = {
    "Usage: nts [OPTION]... [TEXNAME[.tex]] [COMMANDS]",
    "   or: nts [OPTION]... \\FIRST-LINE",
    "   or: nts [OPTION]... &FMT ARGS",
    " ",
    "  Run NTS on TEXNAME, usually creating TEXNAME.dvi.",
    "  Any remaining COMMANDS are processed as NTS input, after TEXNAME is read.",
    "  If an existing .nfmt file is given using &FMT or the -fmt=FMT option, use it.",
    "  Else use `NAME.nfmt', where NAME is the program invocation name, most",
    "  commonly `tex'.  To be a bit smart, if the given .nfmt does not exist and",
    "  contains the string `nts', the format file search is tried with `nts'",
    "  removed or replaced by the string `tex'.",
    " ",
    "  Alternatively, if the first non-option argument begins with a backslash,",
    "  interpret all non-option arguments as a line of TeX input.",
    " ",
    "  Alternatively, if the first non-option argument begins with a &, the",
    "  next word is taken as the FMT to read, overriding all else.  Any",
    "  remaining arguments are processed as above.",
    " ",
    "  If no arguments or options are specified, prompt for input.",
    " ",
    "-fmt=FMTNAME             use FMTNAME instead of program name",
    "-ini                     be NTS' variant of initex, for dumping formats",
    "-interaction=STRING      set interaction mode (STRING=batchmode/nonstopmode/",
    "                          scrollmode/errorstopmode)",
    "-log-extension=EXT       use EXT as the file name extension of the protocol",
    "                          file (default is `log')",
    "-dvi-extension=EXT       use EXT as the file name extension of the .dvi file",
    "                          (default is `dvi')",
    "-progname=STRING         set program (and fmt) name to STRING",
    "-help                    display this help and exit",
    "-version                 output version information and exit",
    " ",
    "Email bug reports to nts@dante.de.",
    NULL
};

char *
find_nts (void)
{
    char *p;
    p = kpse_find_file (NTS_JAR, kpse_program_binary_format, true);
    return p;
}

void
print_version (void)
{
    FILE *f;
    char buf[128], cmd[128];
    char *p;
    int i;

    if (!Nts_Rt_Jar[0]) {
        p = find_nts ();
        if (!p) {
            fprintf (stderr, "I cannot find nts.rt.jar.\n");
            exit (100);
        }
        strcpy (Nts_Rt_Jar, p);
        free (p);
    }
    sprintf (cmd, "java -jar %s <nul", Nts_Rt_Jar);
    f = _popen (cmd, "r");
    if (!f) {
        fprintf (stderr, "popen error.\n");
        exit (100);
    }
    for (i = 0; i < 5; i++) {
        fgets (buf, 128, f);
        fputs (buf, stdout);
    }
    _pclose (f);
}

void
usage (void)
{
    int i = 0;
    while (Help[i]) {
        puts (Help[i]);
        i++;
    }
}

void
checkarray (int i)
{
    if (i >= ARGNUM - 1) {
        fprintf (stderr, "Too many arguments.\n");
        exit (100);
    }
}

int
main (int argc, char **argv)
{
    char *av[ARGNUM];
    int i, j;
    int non_option = 0;
    int initialize = 0;
    char *p;
    char fmt[128];
    char interaction[128];
    char log_ext[128];
    char dvi_ext[128];
    char progname[128];

    fmt[0] = interaction[0] = log_ext[0] = dvi_ext[0] = progname[0] = '\0';

    kpse_set_program_name (argv[0], "nts");

    if (argc < 2) {
        usage ();
        exit (0);
    }

    for (i = 1; i < argc; i++) {
        if (argv[i][0] != '-') {
            non_option = i;
            break;
        }
        if (!strncmp (argv[i], "-f", 2) || !strncmp (argv[i], "--f", 3)) {
            p = strchr (argv[i], '=');
            if (p) {
                p++;
                sprintf (fmt, "-Dnts.fmt=%s", p);
            }
        } else if (!strncmp (argv[i], "-ini", 4)
                   || !strncmp (argv[i], "--ini", 5))
            initialize = 1;
        else if (!strncmp (argv[i], "-int", 4)
                 || !strncmp (argv[i], "--int", 5)) {
            p = strchr (argv[i], '=');
            if (p) {
                p++;
                sprintf (interaction, "-Dnts.interaction=%s", p);
            }
        } else if (!strncmp (argv[i], "-l", 2) || !strncmp (argv[i], "--l", 3)) {
            p = strchr (argv[i], '=');
            if (p) {
                p++;
                sprintf (log_ext, "-Dnts.log.extension=%s", p);
            }
        } else if (!strncmp (argv[i], "-d", 2) || !strncmp (argv[i], "--d", 3)) {
            p = strchr (argv[i], '=');
            if (p) {
                p++;
                sprintf (dvi_ext, "-Dnts.dvi.extension=%s", p);
            }
        } else if (!strncmp (argv[i], "-p", 2) || !strncmp (argv[i], "--p", 3)) {
            p = strchr (argv[i], '=');
            if (p) {
                p++;
                sprintf (progname, "-Dnts.progname=%s", p);
            }
        } else if (!strncmp (argv[i], "-h", 2) || !strncmp (argv[i], "--h", 3)) {
            usage ();
            exit (0);
        } else if (!strncmp (argv[i], "-v", 2) || !strncmp (argv[i], "--v", 3)) {
            print_version ();
            exit (0);
        } else {
            fprintf (stderr, "Incorrect option\n");
            exit (100);
        }
    }
    Nts_Rt_Jar[0] = '\0';

    p = find_nts ();
    if (!p) {
        fprintf (stderr, "I cannot find nts.rt.jar.\n");
        exit (100);
    }

    if (non_option == 0) {
        fprintf (stderr, "Argument error.\n");
        exit (100);
    }

    strcpy (Nts_Rt_Jar, p);
    free (p);

    for (i = 0; i < ARGNUM; i++)
        av[i] = (char *) malloc (128);

    strcpy (av[0], "java");
    strcpy (av[1], "-jar");

    if (initialize) {
        i = 2;
        if (progname[0]) {
            strcpy (av[i], progname);
            i++;
        }
        strcpy (av[i], Nts_Rt_Jar);
        i++;
        for (j = non_option; j < argc; j++) {
            av[i] = argv[j];
            i++;
            checkarray (i);
        }
        av[i] = NULL;
    } else {
        i = 2;
        if (fmt[0]) {
            strcpy (av[i], fmt);
            i++;
        }
        if (progname[0]) {
            strcpy (av[i], progname);
            i++;
        }
        if (interaction[0]) {
            strcpy (av[i], interaction);
            i++;
        }
        if (log_ext[0]) {
            strcpy (av[i], log_ext);
            i++;
        }
        if (dvi_ext[0]) {
            strcpy (av[i], dvi_ext);
            i++;
        }
        strcpy (av[i], Nts_Rt_Jar);
        i++;
        for (j = non_option; j < argc; j++) {
            av[i] = argv[j];
            i++;
            checkarray (i);
        }
        av[i] = NULL;
    }

    j = spawnvp (P_WAIT, "java.exe", av);

    for (i = 0; i < ARGNUM; i++)
        free (av[i]);
    return j;
}
