/*
deltexlsr ( erase ls-R files )
Web2C 7.3.7 (2002/04/26 --ak)
!! construct (2002/10/09 --ak)
Web2C 7.3.8 (2002/10/13 --ak)
Web2C 7.3.9 (2002/10/25 --ak)
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <malloc.h>
#include <kpathsea/kpathsea.h>

#define  MAXTREE   16 /* Max number of texmf trees */
#define  TEXMFDBS  "TEXMFDBS"

int main(int ac, char **av)
{
  char *texmfdbs ;
  char ls_R_name[256];
  int len, i, numtree;
  char *progname;
  char *pathbuff[MAXTREE];
  char *p, *q, *saveptr;

  kpse_set_program_name(av[0], NULL);
  progname = kpse_program_name;

  for(i = 0; i < MAXTREE; i++) {
    pathbuff[i] = (char *)malloc(128);
    if(!pathbuff[i]) {
      fprintf(stderr, "Memory allocation error.\n");
      exit(100);
    }
  }

  if(!(p = kpse_var_value(TEXMFDBS))) {
    fprintf(stderr, "TEXMFDBS is not defined in texmf.cnf.\n");
    exit (100);
  }

  texmfdbs = saveptr = kpse_brace_expand(p);
  free(p);

  for(i=0 ; (i < MAXTREE) && *texmfdbs ; i++) {
    p = strchr(texmfdbs, ';');
    if(!p) {
      strcpy(pathbuff[i], texmfdbs);
      q = pathbuff[i];
      if(*q == '!' && *(q+1) == '!')
        q += 2;
      strcpy(pathbuff[i], q);
      i++;
      break;
    }
    *p = '\0';
    strcpy(pathbuff[i], texmfdbs);
    q = pathbuff[i];
    if(*q == '!' && *(q+1) == '!')
      q += 2;
    strcpy(pathbuff[i], q);
    p++;
    texmfdbs = p;
  }

  numtree = i;
  
  for(i = 0; i < numtree; i++) {
    strcpy(ls_R_name, pathbuff[i]);
    len = (int)strlen(ls_R_name);
    if(ls_R_name[len-1] != '/') strcat(ls_R_name, "/");
    strcat(ls_R_name, "ls-R");

    if(_access(ls_R_name, 0) == 0) {
      if(remove(ls_R_name) == 0)
        fprintf(stdout, "Deleted : %s\n", ls_R_name);
      else
        fprintf(stdout, "Failed to delete %s\n", ls_R_name);
    }
    else
      fprintf(stdout, "%s does not exist\n", ls_R_name);
  }

  fprintf(stdout, "%s: Done.\n", progname);
  
  for(i = 0; i < MAXTREE; i++) {
    free(pathbuff[i]);
  }
  free(saveptr);

  return 0;
}
