/*
 * Decompiled with CFR 0.152.
 */
package nts.tfm;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import nts.base.BoolPar;
import nts.base.IntPar;
import nts.tfm.FixWord;
import nts.tfm.IndexMultimap;
import nts.tfm.PLDumper;
import nts.tfm.TeXFmDiagnostic;
import nts.tfm.TeXFmLoader;

public class TeXFm
implements Serializable {
    public static final short NO_CHAR_CODE = -1;
    public static final int NO_INDEX = -1;
    protected static final int BOUNDARY_LABEL_CODE = -1;
    private static int init_fp = 0;
    public static final int FP_SLANT = init_fp++;
    public static final int FP_SPACE = init_fp++;
    public static final int FP_STRETCH = init_fp++;
    public static final int FP_SHRINK = init_fp++;
    public static final int FP_X_HEIGHT = init_fp++;
    public static final int FP_QUAD = init_fp++;
    public static final int FP_EXTRA_SPACE = init_fp++;
    public static final int FP_MAX = init_fp++;
    protected static final String[] paramLabel = new String[]{"SLANT", "SPACE", "STRETCH", "SHRINK", "XHEIGHT", "QUAD", "EXTRASPACE"};
    protected int checkSum;
    protected FixWord designSize;
    protected short firstCharCode;
    protected CharInfo[] charTable;
    protected short boundaryChar = (short)-1;
    protected int boundaryStart = -1;
    protected LigKern[] ligKernTable;
    protected FixWord[] paramTable;
    protected String codingScheme;
    protected String family;
    protected int face;
    protected boolean sevenBitSafe;
    protected int[] headerRest;
    protected int restIndex;

    public static TeXFm readFrom(InputStream in, TeXFmDiagnostic dg) throws IOException {
        return new TeXFmLoader(in, dg).getMetric();
    }

    public static TeXFm readFrom(InputStream in) throws IOException {
        return new TeXFmLoader(in).getMetric();
    }

    public static TeXFm readFrom(String path, TeXFmDiagnostic dg) throws IOException {
        return new TeXFmLoader(path, dg).getMetric();
    }

    public static TeXFm readFrom(String path) throws IOException {
        return new TeXFmLoader(path).getMetric();
    }

    public int getCheckSum() {
        return this.checkSum;
    }

    public FixWord getDesignSize() {
        return this.designSize;
    }

    public int paramCount() {
        return this.paramTable.length;
    }

    public FixWord getParam(int idx) {
        return this.paramTable[idx];
    }

    public CharInfo getCharInfo(short idx) {
        return (idx = (short)(idx - this.firstCharCode)) >= 0 && idx < this.charTable.length ? this.charTable[idx] : null;
    }

    public LigKern getLigKern(short left, short right) {
        int i;
        if (left == -1) {
            int n = this.boundaryStart;
        } else {
            CharInfo info = this.getCharInfo(left);
            int n = i = info != null ? info.ligKernStart() : -1;
        }
        if (right == -1) {
            right = this.boundaryChar;
        }
        if (right != -1) {
            while (i != -1) {
                LigKern lk = this.ligKernTable[i];
                if (lk.nextChar == right) {
                    return lk;
                }
                i = lk.nextIndex(i);
            }
        }
        return null;
    }

    public PLDumper dump(PLDumper dmp) {
        if (this.family != null) {
            dmp.open("FAMILY").addStr(this.family).close();
        }
        if (this.face >= 0) {
            dmp.open("FACE").addFace(this.face).close();
        }
        if (this.headerRest != null) {
            TeXFm.dumpHeaderRest(dmp, this.headerRest, this.restIndex);
        }
        if (this.codingScheme != null) {
            dmp.open("CODINGSCHEME").addStr(this.codingScheme).close();
        }
        dmp.open("DESIGNSIZE").addReal(this.designSize).close();
        this.dumpComment(dmp, "DESIGNSIZE IS IN POINTS");
        this.dumpComment(dmp, "OTHER SIZES ARE MULTIPLES OF DESIGNSIZE");
        dmp.open("CHECKSUM").addOct(this.checkSum).close();
        if (this.sevenBitSafe) {
            dmp.open("SEVENBITSAFEFLAG").addBool(this.sevenBitSafe).close();
        }
        this.dumpParams(dmp);
        this.dumpLigKernTable(dmp);
        this.dumpChars(dmp);
        return dmp;
    }

    protected PLDumper dumpParams(PLDumper dmp) {
        if (this.paramTable.length > 0) {
            dmp.open("FONTDIMEN");
            int i = 0;
            while (i < this.paramTable.length) {
                String name = this.paramName(i);
                if (name != null) {
                    dmp.open(name);
                } else {
                    dmp.open("PARAMETER").addDec(i + 1);
                }
                dmp.addReal(this.paramTable[i]).close();
                ++i;
            }
            dmp.close();
        }
        return dmp;
    }

    protected PLDumper dumpLigKernTable(PLDumper dmp) {
        if (this.boundaryChar != -1) {
            dmp.open("BOUNDARYCHAR").addChar(this.boundaryChar).close();
        }
        if (this.ligKernTable.length > 0) {
            dmp.open("LIGTABLE");
            boolean[] activity = new boolean[this.ligKernTable.length];
            IndexMultimap labels = this.buildLabels(activity);
            this.computeActivity(activity);
            boolean commenting = false;
            int i = 0;
            while (i < this.ligKernTable.length) {
                if (activity[i]) {
                    if (commenting) {
                        dmp.close();
                        commenting = false;
                    }
                    IndexMultimap.Enum lab = labels.forKey(i);
                    while (lab.hasMore()) {
                        short charCode = (short)lab.next();
                        dmp.open("LABEL");
                        if (charCode == -1) {
                            dmp.addStr("BOUNDARYCHAR");
                        } else {
                            dmp.addChar(charCode);
                        }
                        dmp.close();
                    }
                    this.ligKernTable[i].dump(dmp, activity, i);
                } else {
                    if (!commenting) {
                        dmp.open("COMMENT");
                        dmp.addStr("THIS PART OF THE PROGRAM IS NEVER USED!");
                        commenting = true;
                    }
                    this.ligKernTable[i].dump(dmp);
                }
                ++i;
            }
            if (commenting) {
                dmp.close();
            }
            dmp.close();
        }
        return dmp;
    }

    protected IndexMultimap buildLabels(boolean[] active) {
        IndexMultimap labels = new IndexMultimap();
        if (this.boundaryStart != -1) {
            labels.add(this.boundaryStart, -1);
            active[this.boundaryStart] = true;
        }
        int i = 0;
        while (i < this.charTable.length) {
            int start;
            if (this.charTable[i] != null && (start = this.charTable[i].ligKernStart()) != -1) {
                labels.add(start, i + this.firstCharCode);
                active[start] = true;
            }
            ++i;
        }
        return labels;
    }

    protected void computeActivity(boolean[] active) {
        int i = 0;
        while (i < this.ligKernTable.length) {
            int next;
            if (active[i] && (next = this.ligKernTable[i].nextIndex(i)) != -1) {
                active[next] = true;
            }
            ++i;
        }
    }

    protected PLDumper dumpChars(PLDumper dmp) {
        int i = 0;
        while (i < this.charTable.length) {
            if (this.charTable[i] != null) {
                dmp.open("CHARACTER").addChar((short)(i + this.firstCharCode));
                this.charTable[i].dump(dmp, this).close();
            }
            ++i;
        }
        return dmp;
    }

    protected static PLDumper dumpHeaderRest(PLDumper dmp, int[] rest, int num) {
        int i = 0;
        while (i < rest.length) {
            dmp.open("HEADER").addDec(i + num).addOct(rest[i]).close();
            ++i;
        }
        return dmp;
    }

    protected PLDumper dumpComment(PLDumper dmp, String s) {
        return dmp.open("COMMENT").addStr(s).close();
    }

    protected String paramName(int i) {
        return i < paramLabel.length ? paramLabel[i] : null;
    }

    protected TeXFm(int checkSum, FixWord designSize, short firstCharCode, CharInfo[] charTable, short boundaryChar, int boundaryStart, LigKern[] ligKernTable, FixWord[] paramTable, String codingScheme, String family, int face, boolean sevenBitSafe, int[] headerRest, int restIndex) {
        this.checkSum = checkSum;
        this.designSize = designSize;
        this.firstCharCode = firstCharCode;
        this.charTable = charTable;
        this.boundaryChar = boundaryChar;
        this.boundaryStart = boundaryStart;
        this.ligKernTable = ligKernTable;
        this.paramTable = paramTable;
        this.codingScheme = codingScheme;
        this.family = family;
        this.face = face;
        this.sevenBitSafe = sevenBitSafe;
        this.headerRest = headerRest;
        this.restIndex = restIndex;
    }

    public static abstract class LigKern
    implements Serializable {
        public static final LigKern NULL;
        private int skip;
        protected short nextChar;

        public short getLig(BoolPar left, BoolPar right, IntPar over) {
            return -1;
        }

        public FixWord getKern() {
            return null;
        }

        public int nextIndex(int pos) {
            return this.skip < 0 ? -1 : pos + this.skip + 1;
        }

        public abstract PLDumper dump(PLDumper var1);

        public PLDumper dump(PLDumper dmp, boolean[] active, int pos) {
            this.dump(dmp);
            if (this.skip > 0) {
                int count = 0;
                int next = pos + this.skip + 1;
                while (++pos < next) {
                    if (!active[pos]) continue;
                    ++count;
                }
                dmp.open("SKIP").addDec(count).close();
            } else if (this.skip < 0) {
                dmp.open("STOP").close();
            }
            return dmp;
        }

        public LigKern(int skip, short next) {
            this.skip = skip;
            this.nextChar = next;
        }
    }

    public static class Ligature
    extends LigKern {
        private short addingChar;
        private boolean keepLeft;
        private boolean keepRight;
        private byte stepOver;

        public short getLig(BoolPar left, BoolPar right, IntPar over) {
            left.set(this.keepLeft);
            right.set(this.keepRight);
            over.set(this.stepOver);
            return this.addingChar;
        }

        /*
         * Handled impossible loop by duplicating code
         * Enabled aggressive block sorting
         */
        public PLDumper dump(PLDumper dmp) {
            StringBuffer buf;
            block5: {
                byte by;
                byte i;
                block4: {
                    buf = new StringBuffer(7);
                    if (this.keepLeft) {
                        buf.append('/');
                    }
                    buf.append("LIG");
                    if (this.keepRight) {
                        buf.append('/');
                    }
                    i = this.stepOver;
                    if (!true) break block4;
                    by = i;
                    i = (byte)(by - 1);
                    if (by <= 0) break block5;
                }
                do {
                    buf.append('>');
                    by = i;
                    i = (byte)(by - 1);
                } while (by > 0);
            }
            dmp.open(buf.toString()).addChar(this.nextChar);
            return dmp.addChar(this.addingChar).close();
        }

        public Ligature(int skip, short next, short a, boolean l, boolean r, byte s) {
            super(skip, next);
            this.addingChar = a;
            this.keepLeft = l;
            this.keepRight = r;
            this.stepOver = s;
        }
    }

    public static class Kerning
    extends LigKern {
        private FixWord kern;

        public FixWord getKern() {
            return this.kern;
        }

        public PLDumper dump(PLDumper dmp) {
            dmp.open("KRN").addChar(this.nextChar);
            return dmp.addReal(this.kern).close();
        }

        public Kerning(int skip, short next, FixWord k) {
            super(skip, next);
            this.kern = k;
        }
    }

    public static class CharInfo
    implements Serializable {
        public static final CharInfo NULL;
        private FixWord width;
        private FixWord height;
        private FixWord depth;
        private FixWord italic;

        public final FixWord getWidth() {
            return this.width;
        }

        public final FixWord getHeight() {
            return this.height;
        }

        public final FixWord getDepth() {
            return this.depth;
        }

        public final FixWord getItalic() {
            return this.italic;
        }

        public int ligKernStart() {
            return -1;
        }

        public short nextChar() {
            return -1;
        }

        public short extTop() {
            return -1;
        }

        public short extMid() {
            return -1;
        }

        public short extBot() {
            return -1;
        }

        public short extRep() {
            return -1;
        }

        public PLDumper dump(PLDumper dmp, TeXFm tfm) {
            this.dumpDimen(dmp, this.width, "CHARWD");
            this.dumpDimen(dmp, this.height, "CHARHT");
            this.dumpDimen(dmp, this.depth, "CHARDP");
            this.dumpDimen(dmp, this.italic, "CHARIC");
            return dmp;
        }

        protected void dumpDimen(PLDumper dmp, FixWord dim, String what) {
            if (dim != FixWord.ZERO) {
                dmp.open(what).addReal(dim).close();
            }
        }

        public CharInfo(FixWord w, FixWord h, FixWord d, FixWord i) {
            this.width = w;
            this.height = h;
            this.depth = d;
            this.italic = i;
        }
    }

    public static class LigCharInfo
    extends CharInfo {
        private int start;

        public final int ligKernStart() {
            return this.start;
        }

        public PLDumper dump(PLDumper dmp, TeXFm tfm) {
            super.dump(dmp, tfm);
            dmp.open("COMMENT");
            int i = this.start;
            while (i != -1) {
                tfm.ligKernTable[i].dump(dmp);
                i = tfm.ligKernTable[i].nextIndex(i);
            }
            return dmp.close();
        }

        public LigCharInfo(FixWord w, FixWord h, FixWord d, FixWord i, int s) {
            super(w, h, d, i);
            this.start = s;
        }
    }

    public static class ListCharInfo
    extends CharInfo {
        private short next;

        public final short nextChar() {
            return this.next;
        }

        public PLDumper dump(PLDumper dmp, TeXFm tfm) {
            super.dump(dmp, tfm);
            return dmp.open("NEXTLARGER").addChar(this.next).close();
        }

        public ListCharInfo(FixWord w, FixWord h, FixWord d, FixWord i, short n) {
            super(w, h, d, i);
            this.next = n;
        }
    }

    public static class ExtCharInfo
    extends CharInfo {
        private short top;
        private short mid;
        private short bot;
        private short rep;

        public final short extTop() {
            return this.top;
        }

        public final short extMid() {
            return this.mid;
        }

        public final short extBot() {
            return this.bot;
        }

        public final short extRep() {
            return this.rep;
        }

        public PLDumper dump(PLDumper dmp, TeXFm tfm) {
            super.dump(dmp, tfm);
            dmp.open("VARCHAR");
            this.dumpPart(dmp, this.top, "TOP");
            this.dumpPart(dmp, this.mid, "MID");
            this.dumpPart(dmp, this.bot, "BOT");
            this.dumpPart(dmp, this.rep, "REP");
            return dmp.close();
        }

        protected void dumpPart(PLDumper dmp, short c, String what) {
            if (c != -1) {
                dmp.open(what).addChar(c).close();
            }
        }

        public ExtCharInfo(FixWord w, FixWord h, FixWord d, FixWord i, short t, short m, short b, short r) {
            super(w, h, d, i);
            this.top = t;
            this.mid = m;
            this.bot = b;
            this.rep = r;
        }
    }
}

