/*
 * Decompiled with CFR 0.152.
 */
package nts.command;

import nts.command.BaseToksChecker;
import nts.command.CommandBase;
import nts.command.Macro;
import nts.command.MacroBody;
import nts.command.MacroParamToken;
import nts.command.RightBraceToken;
import nts.command.Token;
import nts.command.TokenList;
import nts.io.CharCode;
import nts.io.Log;
import nts.io.MaxLoggable;

class MacroDefining
extends BaseToksChecker
implements MaxLoggable {
    public CharCode matchCode = MacroParamToken.CODE;
    public MacroBody.Buffer bodyBuf = null;
    private CharCode[] matchCodes = new CharCode[9];
    private TokenList[] paramMask = new TokenList[10];
    private TokenList.Buffer paramBuf = new TokenList.Buffer(10, 10);
    private int count = 0;

    public int paramCnt() {
        return this.count;
    }

    public void addToMask(Token tok) {
        this.paramBuf.append(tok);
    }

    public void addParam() {
        this.matchCodes[this.count] = this.matchCode;
        this.paramMask[this.count++] = this.paramBuf.toTokenList();
        this.paramBuf = new TokenList.Buffer(10, 10);
    }

    public Macro toMacro(int prefixes) {
        int i = this.count;
        if (i > 0 || this.paramBuf.length() > 0) {
            this.paramMask[i++] = this.paramBuf.toTokenList();
        }
        TokenList[] mask = new TokenList[i];
        System.arraycopy(this.paramMask, 0, mask, 0, i);
        CharCode[] codes = null;
        if (this.count > 0) {
            codes = new CharCode[this.count];
            System.arraycopy(this.matchCodes, 0, codes, 0, this.count);
        }
        TokenList body = this.bodyBuf != null ? this.bodyBuf.toTokenList() : TokenList.EMPTY;
        return new Macro(mask, codes, body, prefixes);
    }

    protected void tryToFix() {
        CommandBase.insertTokenWithoutCleaning(RightBraceToken.TOKEN);
    }

    protected void reportRunAway() {
        CommandBase.runAway("definition", this);
    }

    public void addOn(Log log, int maxCount) {
        this.toMacro(0).addMaxOn(log, maxCount);
    }

    public MacroDefining(Token source) {
        super("OuterInDef", "EOFinDef", source);
    }
}

