/*# --------------------------------------------------------------------------
###  package    = "FTETX"
###  version    = "0.04"
###  date       = "1997/08/20"
###  filename   = "./CONTRIB/FTETX004/SRC/TXLAUNCH.003/cnf.c"
###  local      = "NO"
### --------------------------------------------------------------------------
###  txlaunch-version = "0.03"
### -------------------------- Copyright (c) 1997, Oliver John von Zydowitz */

#define __CNF_C__

#include "common.h"

#include "global.h"
#include "prf.h"
#include "fn.h"
#include "cnf.h"
#include "msg.h"
#include "str.h"



/*----------------------------------------------------------------------------
  void CNF_parse_msgerr(PRF prf, PSZ szLineBuf)
  displays the line-number and the line with an error 
*/

void CNF_parse_msgerr(PRF prf, PSZ szLineBuf)
{
PCH           p1;
char          tempbuf[32];
unsigned long np;
int           r;

  MSG_msg(prf->szAbsPath);
  MSG_msg(prf->szFileName);
  MSG_msg(":");
                          /* there is not ltoa() in the libs by default */
  p1    = tempbuf + 31;          /* skip to end, we fill this backwards */
  *p1-- = 0;
  np = prf->lineno;
  while (np>0)
    {
      r = np % 10;
      *p1-- = ((char) r) + '0';
      np /= 10;
      }
  p1++;
  MSG_msg(p1);
  MSG_msg(": ");
  MSG_msg(szLineBuf);
  MSG_msg("\n");
}


/*----------------------------------------------------------------------------
  void CNF_parseline_s(int *valid, PRF prf, PSZ szLineBuf, PSZ szKey,
                         PPSZ pszStore, int qucheck)

  given: address of an valid flag, profile (for linneo)
         the keyword to look for
         address of (char *) where to store the argument of key
         quotecheck-flag

  parses a keywords line.
  First it looks at the valid flag what might be already set by a 
  previous call. Checks for the key, and for previusly set data.
  If key matches and no data for key is found before, it stores
  the quoted string found after the keyword. If no qouted string 
  is found but an single asterix (*) instead, it stores an empty
  string. (if quotecheck-flag is set to 0 quotes are not needed)

  *valid is set to 1 whenever the keyword is valid.
  
  returns: nothing (return-code goes via *valid)
*/   

void CNF_parseline_s(int *valid, PRF prf, PSZ szLineBuf, PSZ szKey,
                     PPSZ pszStore, int qucheck)
{
PCH p1;


  if (*valid) return;               /* another check has been successful */ 
  if (!(p1=STR_is_leader(szLineBuf,szKey)))
     return;                                        /* key doesn't match */
  *valid = 1;                                         /* key is matching */

  if (*pszStore)
    {
      CNF_parse_msgerr(prf, szLineBuf);
      MSG_msg_n(MSG_KEYTWICE);
      return;                       /* *store !=NULL,  found twice */   
    }

  if (*p1!='*')
    {                               /* not default entry (asterisk) */
      STR_copy_string(pszStore, p1);
      if (qucheck)
        {
          if (!STR_unquote_string(pszStore))
            {
              STR_delete_string(pszStore);
              CNF_parse_msgerr(prf, szLineBuf);
              MSG_msg_n(MSG_INVKEYARG);
            }
        }
    }
  else 
    STR_copy_string(pszStore, "");        /* is default entry */
}


/*----------------------------------------------------------------------------
  int CNF_parse_sect(PPRF pPrf)
  parse the keywords from a section and store arguments
  given: profile
  returns: 0 on (ignored) error, 1 if succesful (unless fatal err)
*/   

int CNF_parse_sect(PPRF pPrf)
{
PSZ  szLineBuf = NULL;
int  valid;
int  retcode = 1;

  for(;;)
    {
      if (!PRF_readln(pPrf, &szLineBuf, FAT_READCONF ))
        break;                                                     /* at eof */
      if (STR_is_bracked(szLineBuf))  break;              /* at next section */

      valid = 0;                                         /* process keywords */
      CNF_parseline_s(&valid, *pPrf, szLineBuf, "drive=", &szCNFdrive, 1 );
      CNF_parseline_s(&valid, *pPrf, szLineBuf, "path=",  &szCNFpath,  1 );
      CNF_parseline_s(&valid, *pPrf, szLineBuf, "name=",  &szCNFname,  1 );
      CNF_parseline_s(&valid, *pPrf, szLineBuf, "ext=",   &szCNFext,   1 );
      CNF_parseline_s(&valid, *pPrf, szLineBuf, "delim=", &szCNFdelim, 1 );
      CNF_parseline_s(&valid, *pPrf, szLineBuf, "cmd=",   &szCNFcmd,   0 );
      if (!valid)                     /* valid still ==0 ... unknown keyword */
       {   
         CNF_parse_msgerr(*pPrf, szLineBuf);
         MSG_msg_n(MSG_INVKEY);
         retcode = 0;
       }
    }

  STR_delete_string(&szLineBuf);
  return retcode;
}


/*-----------------------------------------------------------------------------
  int CNF_search_sect(PPRF pPrf, PSZ szSection, int msg_code, int fatal_code)
  searches the profile, line-by-line, until it finds the section-header 
  it searches for. The section-header is a line like "[section]" in the
  profile (w/o quotes) 
  given:   adress of profile
           string of section to search for,
           no. of msg if search fails,
           no. of fatal-msg on read-err
  returns: 1 if section found in profile, 0 otherwise
*/

int CNF_search_sect(PPRF pPrf, PSZ szSection, int msg_code, int fatal_code)
{
PSZ  szLineBuf = NULL;
PSZ  szCompBuf = NULL;
int  retcode = 0;

  STR_copy_string(&szCompBuf, "[");        /* build a buffer for compare */
  STR_concat_string(&szCompBuf, szSection);
  STR_concat_string(&szCompBuf, "]");
  for(;;)                          /* loop terminated by break */
    {
      if (!PRF_readln(pPrf, &szLineBuf, fatal_code))
        {                                     /* have read no line */
          MSG_msg_n(msg_code);                /* msg */
          MSG_msg(szSection);
          MSG_msg("\n");
          break;
        } 
      if (!strcmp(szLineBuf, szCompBuf))      /* found */
        { 
          retcode = 1;
          break;
        }
    } 
  STR_delete_string(&szLineBuf);            /* free memory */
  STR_delete_string(&szCompBuf);
  return retcode;
}


/*----------------------------------------------------------------------------
  int CNF_lookup(PSZ szCnfName, PSZ szSection)
  parses the section (if exists) and gathers data
  given:   name of configfile and section
  returns: 0 on error, 1 if succesful (unless fatal err)
*/

int CNF_lookup(PSZ szCnfName, PSZ szSection)
{
int  retcode = 1;
PRF  Profile = NULL;

    PRF_open_file(szCnfName, &Profile, FAT_OPENCONF );
    if (!CNF_search_sect(&Profile, szSection,
                         MSG_SECNOTFOUND, FAT_READCONF ))
      {
        PRF_close_allfiles(&Profile);
        return 0;
      }
    retcode = CNF_parse_sect(&Profile);
    PRF_close_allfiles(&Profile);
    /* concat with "" makes all strings valid, drive, path,... */
    /* are converted to std filename conventions (lowercase, / for DOS, OS2) */
    STR_concat_string(&szCNFdrive, ""); FN_MakeStd(szCNFdrive);
    STR_concat_string(&szCNFpath, "");  FN_MakeStd(szCNFpath);
    STR_concat_string(&szCNFname, "");  FN_MakeStd(szCNFname);
    STR_concat_string(&szCNFext, "");   FN_MakeStd(szCNFext);
    STR_concat_string(&szCNFdelim, "");
    STR_concat_string(&szCNFcmd, "");
    if (retcode==0) MSG_msg_n(MSG_CONFERR);
    return retcode;
}


/*------------------------------------------------------------------------- */
