#include <errno.h>
#include <string.h>

extern unsigned short WinExec(char *, unsigned);

#define MAX_EXEC_CHARS 120

int system(const char *buf)
{
    int ret, len;

    len = strlen(buf);

    /* only 120 chars allowed (Win 3.1) */
    if (len  >= MAX_EXEC_CHARS) {
	errno = E2BIG;
	return -1;
    }

    ret = WinExec(buf, 1);

    if (ret <= 32) {
	errno = EINVAL;
	return -1;
    }
    else
	return 0;
}
