/* ptrace.c (rsxnt) -- Copyright (c) 1996-1998 Rainer Schnitker */

#include "rsxnt.h"

/*
    This modeule is only included by the sys library.
    The dll call _rsxnt_do_ptrace().
*/

int __ptrace (int request, int pid, int addr, int data)
{
  int retv;

  int sys_errno = _rsxnt_do_ptrace(request, pid, addr, data, &retv);

  if (sys_errno < 0)
    errno = -sys_errno;
  else
    errno = 0;

  return retv;
}

/* add this function to the constructor list */
extern WAIT_DEBUG _func_rsxnt_wait_debuggee;

static void enable_wait_debug (void)
{
  _func_rsxnt_wait_debuggee = _rsxnt_wait_debuggee;
}

__asm__ ("\t.stabs \"___CTOR_LIST__\", 23, 0, 0, _enable_wait_debug");
