#include <stdio.h>
#include <stdlib.h>
#include "\rsx\source\DPMI.H"

POINTER16_16 int21rmv;	 /* dos int21h realmode handler */
TRANSLATION ts;

int emx_read_kbd(int echo, int wait, int signal)
{
    int c;

    ts.sp = 0;
    ts.ss = 0;
    ts.flags = 3202;
    ts.cs = int21rmv.sel;
    ts.ip = int21rmv.off;

    if (wait) {
	ts.eax = 0x0700;
	CallRMprocIret (0, 0, &ts);
	c = ts.eax & 0xFF;
    } else {
	ts.eax = 0x0600;
	ts.edx = 0xFF;
	CallRMprocIret (0, 0, &ts);
	c = ts.eax & 0xFF;
	if (ts.flags & 64)
	    return -1;
    }
    if (echo && c) {
	ts.eax = 0x0600;
	ts.edx = c;
	SimulateRMint(0x21, 0, 0, &ts);
    }
    return c;
}

int main( int argc, char **argv, char **env)
{
    int c, x1,x2,x3;

    GetRealModeVector(0x21, &int21rmv.sel, &int21rmv.off);
    SetRealModeVector(0x21, int21rmv.sel, int21rmv.off);

    printf("options:");
    scanf("%d %d %d", &x1, &x2, &x3);

    do {
	c = emx_read_kbd(x1,x2,x3);
	if (c == -1)
	    printf("+");
	else
	    printf("-%d-", c);
	fflush(stdout);
    } while (c != 'q');

    return 0;
}
