/* crlf converts CR/LF character pairs to LF and removes 
   the trailing Control-Z from OS/2 text files.

   Copyright (c) 1993 by Ralph Schleicher */


#include <sys/types.h>
#include <sys/stat.h>
#include <getopt.h>
#include <unistd.h>
#include <fcntl.h>
#include <stdio.h>
#include <stdlib.h>

#ifndef O_BINARY
#define O_BINARY	0
#endif

void usage(void);
char *program_name;


int main(int argc, char *argv[])
{
  char **names, *buf, *src, *dst;
  int handle, c, n;
  struct stat st;
#ifdef __EMX__
  _wildcard(&argc, &argv);
#endif
  program_name = argv[0];
  opterr = 0;   

  while ((c = getopt(argc, argv, "")) != EOF)
    switch (c)
      { 
      default:
	usage();
	exit(1);
      }
  
  for (buf = NULL, names = &argv[1]; *names; ++names)
    {
      if ((handle = open(*names, O_RDONLY | O_BINARY)) < 0)
        {
	  fprintf(stderr, "Cannot access file `%s'", *names);
	  
	  continue;
        }
      
      fstat(handle, &st);
      n = st.st_size;
      
      if (!(src = realloc(buf, n)))
        {
	  fprintf(stderr, "Out of Memory!");
        }
      else
        {
	  buf = dst = src;
	  n = read(handle, buf, n);
	  close(handle);
	  
	  for (; n > 0; --n)
            {
	      switch (*src)
                {
                case '\x1a': /* stop with first CTRL-Z */
		  n = 1;
		  break;
                case '\r':
		  if (src[1] == '\n')
		    {
		      ++src;
		      --n;
		    }  
                default:
		  *dst++ = *src++;
                }
            }
	  
	  handle = open(*names, O_WRONLY | O_TRUNC | O_CREAT | O_BINARY);
	  n = write(handle, buf, dst - buf);
	  
	  printf("%d bytes written to file `%s'.\n", n, *names);
        }
      
      close(handle);
    }
  
  free(buf);
  
  return 0;
}

void usage(void)
{ 
  fprintf(stderr, "Usage:  %s <file-names>\n"
    "%s converts CR/LF character pairs to LF and removes\n"
    "the trailing Control-Z from text files (OS/2, DOS).\n",
    program_name, program_name);
}
	
