# (auto-install)
alpha::mode Pasc 1.0.2 dummyPascal {*.p} {thinkRefMenu toolboxRefMenu electricSemicolon electricTab electricReturn} {
	set unixMode(pascal) {Pasc}
}


newPref v leftFillColumn {3} Pasc
newPref v wordBreak {\w+} Pasc
newPref f wordWrap {0} Pasc
# newPref v funcExpr {^[^ \t\(#\r/@].*\(.*\)$} Pasc
# newPref v parseExpr {^[^ \t\(#\r/@].*\((.*)\)$} Pasc
newPref v funcExpr {^procedure.*\(} Pasc
newPref v parseExpr {^procedure[ \t]*(.*)[ \t]*\(} Pasc
newPref v wordBreakPreface {\W} Pasc
newPref f autoMark	0 Pasc

set pascCommentRegexp	{/\*(([^*]/)|[^*]|\r)*\*/}
set pascPreRegexp		{^\#[\t ]*[a-z]*}
set pascKeyWords		{
	procedure function integer while with return var const unit type interface
	packed record begin end boolean if else repeat for downto case to of mod 
	goto file do then program or label div until set not in forward and
	implementation unit
}
regModeKeywords -b \{ \} -c red -k blue Pasc $pascKeyWords
unset pascKeyWords

hook::register saveHook modified "Pasc"

#================================================================================

proc dummyPascal {} {}

set commentCharacters(Pasc:Paragraph) [list "(*" "*)" " * "]


proc Pasc::MarkFile {} {
	message "Not yet (someone write me)"
}

proc Pasc::indentLine {} {
    # get details of current line
    set beg [lineStart [getPos]]
    set text [getText $beg [nextLineStart $beg]]
    regexp "^\[ \t\]*" $text white
    set len [string length $white]
    set epos [pos::math $beg + $len]
    
    # Find last previous non-comment line and get its leading whitespace
    set pos $beg
    while 1 {
	if {[catch {search -s -f 0 -r 1 -i 0 -m 0 "^\[ \t\]*\[^ \t\r\n\]" [pos::math $pos - 1]} lst]} {
	    # search failed at top of file
	    set line "#"
	    set lwhite 0
	    break
	}
	if {![catch {text::inCommentBlock [lindex $lst 0]} res]} {
	    set pos [lindex $res 0]
	} else {
	    set line [getText [lindex $lst 0] [pos::math [nextLineStart [lindex $lst 0]] - 1]]
	    set lwhite [posX [pos::math [lindex $lst 1] - 1]]	
	    break
	}
    }
    
    global indentationAmount electricColon
    if {[regexp "begin\[ \t\]*$" $line]} {
	incr lwhite $indentationAmount
    }
    if {[regexp "end;?\[ \t\r\n\]*$" [getText $epos [nextLineStart $epos]]]} {
	incr lwhite [expr -$indentationAmount]
    }
    set lwhite [text::indentOf $lwhite]
    if {$white != $lwhite} {
	replaceText $beg $epos $lwhite
    }
    goto [pos::math $beg + [string length $lwhite]]
}
