/******************************************************************************
 * program:     wp2latex                                                      *
 * function:    module with XML support functions for HTML, AbiWord ans Accent*
 * modul:       pass1xml.cc                                                   *
 * description: 							      *
 * licency:     GPL		                                              *
 ******************************************************************************/
#include<stdio.h>
#include<string.h>
#include<stdlib.h>

#include<strings.h>
#include<lists.h>
#include<dbllist.h>

#include"wp2latex.h"
#include"pass1xml.h"
#include "cp_lib/cptran.h"
//#include "cp_lib/html.trn"


void TconvertedPass1_XML::SelectTranslator(const char *CharSet)
{
string translator;
  while(*CharSet==' ') CharSet++;

  if(!strcmp(CharSet,"utf8") || !strcmp(CharSet,"utf-8") || 
     !strcmp(CharSet,"UTF8") || !strcmp(CharSet,"UTF-8"))
    {
    ConvertCpg = GetTranslator("unicodeTOinternal");
    CharReader = &utf8_fgetc;
    return;
    }

  if(!strcmp(CharSet,"iso-8859-1")) translator="iso_8859_1";
  else if(!stricmp(CharSet,"iso-8859-2")) translator="iso_8859_2";
  else if(!stricmp(CharSet,"windows-1250")) translator="cp1250";
  else if(!stricmp(CharSet,"windows-1251")) translator="cp1251";
  else if(!stricmp(CharSet,"windows-1252")) translator="cp1252";
  else translator=CharSet;

  translator+="TOinternal";
  ConvertCpg = GetTranslator(translator);
  CharReader = &ch_fgetc;

  if(ConvertCpg==NULL || ConvertCpg->number()==0)
    if(err != NULL)
      {
      perc.Hide();
      fprintf(err,_("\nError: Cannot initialize charset convertor %s!"),translator());
      }
}


//cq->by = 0 (normal char), 1 (extended char &xxx;), 2 (tag <>), 3 (end tag </>), 4 comment, 5 unfinished &xxx, 6 expanded unicode, 127 fail
void TconvertedPass1_XML::ReadXMLTag(boolean MakeUpper)
{
#ifdef DEBUG
  fprintf(log,"\n#ReadXMLTag() ");fflush(log);
#endif
int c;
string Attribute,Value;

erase(TAG_Args);
c=CharReader(wpd);
if((unsigned)c==0xFFFF)
  {by=127;erase(TAG);return;}

if(c>=0x100)	//Handle unicode character
	{
	TAG=Ext_chr_str(c,this,ConvertCpg);
	by=6;
	return;
	}

if(c=='<')	//Handle HTML tag
   {
   by=2;
   TAG='<';
   c=fgetc(wpd);
   if(c=='/') by=3;

   while(!feof(wpd))
	{
	if(c=='>') {TAG += MakeUpper?toupper(c):c; return;}
	if(isspace(c))
	    {
	    if(TAG[1]=='!')
		{
		Attribute="!";Value="";
		do {
		   if( (c=fgetc(wpd)) == EOF) return;
                   if(c==0) return;			 //illegal 0 char
		   TAG+=c;		//read all comment
		   } while (c!='>');
		by=4;
		return;
		}
	    TAG+='>';
	    while(!feof(wpd))	// read arg list
		{
		Attribute=Value="";
		do {
		   c=fgetc(wpd);
		   } while (c==' ' || c=='\r' || c=='\n');
		if(c=='>') break;
		while(c!='=' && c!='>')
		   {
		   Attribute+=c;
		   if( (c=fgetc(wpd)) == EOF) return;
		   if(c==0) return;			 //illegal 0 char
		   }
		if(c!='>')		//Attribute without value <x aaa>
		   {
		   do {
		      c=fgetc(wpd);
		      } while (isspace(c));
		   if(c=='"')		//read "value" in double quotation mark
		     {
		     c=fgetc(wpd);
		     while(c!='\"')
		       {
		       Value+=c;
		       if( (c=fgetc(wpd)) == EOF) break;
		       if(c==0) {c='>';break;}			//illegal 0 char
		       }
		     }
		  else			//read "value" without double quotation mark
		     {
		     while(c!='>' && !isspace(c))
			{
			Value+=c;
			if( (c=fgetc(wpd)) == EOF) break;
			if(c==0) {c='>';break;}			//illegal 0 char
			}
		     }
		  }
		TAG_Args.Add(Attribute(),Value());
		if(c=='>') break;
		}
	    return;
	    }

	TAG += MakeUpper?toupper(c):c;
	c=fgetc(wpd);
	}

   TAG+='>';			//EOF reached
   return;
   }

if(c=='&')
   {
   by=1;

   TAG=c;
   while(!feof(wpd))
       {
       c=fgetc(wpd);
       if(c==';') break;
       if(isspace(c) || c==0)	//unterminated & sequence
	   {			//space also terminates &xx; section (CR, LF, TAB and ' ')
	   by=5;
	   break;
	   }

       TAG+=c;
       }
   TAG+=';';
   return;
   }

by=0;
subby=c;
TAG=c;
}


/*This function converts comment inside HTML*/
void TconvertedPass1_XML::CommentXML(void)
{
#ifdef DEBUG
  fprintf(log,"\n#CommentXML() ");fflush(log);
#endif
  signed char Old_char_on_line;
  unsigned char OldFlag;
  attribute OldAttr;
  int i,maxi,commentchars;


  OldFlag = flag;
  OldAttr = attr;
  Old_char_on_line = char_on_line;
  flag = CharsOnly;
  recursion++;
  InitAttr(attr);		//Turn all attributes in the comment off

  fputc('%',strip);

  maxi=length(TAG);
  i=0;
  commentchars=0;
  if(TAG[i]=='<' && TAG[i+1]=='!' && TAG[maxi-1]=='>') {i+=2;maxi--;}
  if(TAG[i]=='-' && TAG[maxi-1]=='-' && i<maxi) {i++;maxi--;}
  if(TAG[i]=='-' && TAG[maxi-1]=='-' && i<maxi) {i++;maxi--;}
  while(TAG[i]==' ' && TAG[maxi-1]==' ' && i<maxi) {i++;maxi--;}

  while (i<maxi)
       {
       by=TAG[i++];
       if(by==0) break;

       if(by==0xA || by==0xD)	//New comment line
		{
		if(commentchars)
		  {
		  line_term = 's';    	//Soft return
		  Make_tableentry_envir_extra_end(this);
		  fprintf(strip, "\n");
		  rownum++;
		  Make_tableentry_attr(this);

		  fputc('%',strip);
		  commentchars=0;
		  }
		continue;
		}

       fputc(by,strip);
       commentchars++;
       continue;
       }

  line_term = 's';    	//Soft return
  Make_tableentry_envir_extra_end(this);
  fprintf(strip, "\n");
  rownum++;
  Make_tableentry_attr(this);


  recursion--;
  strcpy(ObjType, "Comment");
  attr = OldAttr;
  flag = OldFlag;
  if(Old_char_on_line==true || Old_char_on_line==-1) char_on_line = -1;
	else char_on_line = false;
}
