/******************************************************************************
 * program:     cp-lib							      *
 * function:    support file for codepage based character conversion          *
 * modul:       cptran.cc 						      *
 * description: This file should be linked with final code together with trn  *
 *              output files from cpbldr code.				      *
 ******************************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
//#include <mem.h>


#include <strings.h>

#if __BORLANDC__  //&& ! __WIN32__
 #include "cp_lib/cptran.h"
#else
 #include "cptran.h"
#endif


CpTranslator *CpTranslator::First=NULL;
CpTranslator Dummy("dummy");

CpTranslator::CpTranslator(char *name)
{
 Name=name;

 Next=First;
 Previous=NULL;
 First=this;
 if(Next!=NULL) Next->Previous=this;
}


CpTranslator::~CpTranslator(void)
{
 if(First==this)
	{
	First=Next;
	if(Next!=NULL) Next->Previous=NULL;
	return;
	}
 if(Next!=NULL) Next->Previous=Previous;
 if(Previous==NULL) return; //Error
 Previous->Next=Next;
}

//---------------

WCpTranslator::WCpTranslator(char *name, WORD number, const WORD *trn): CpTranslator(name)
{
 Number=number;
 Trn=trn;
}


BCpTranslator::BCpTranslator(char *name, WORD number, const BYTE *trn): CpTranslator(name)
{
 Number=number;
 Trn=trn;
}


SparseCpTranslator::SparseCpTranslator(char *name, BYTE banks, WORD **trn_bank): CpTranslator(name)
{
 Banks=banks;
 Trn_bank=trn_bank;
}


WORD SparseCpTranslator::operator[](const WORD n) const
{
BYTE b=n>>8;
 if(b>=Banks) return(0);
 if(Trn_bank[b]==NULL) return(0);
 return(Trn_bank[b][n & 0xFF]);
}


//---------------

CpTranslator *GetTranslator(const char *Name)
{
CpTranslator *Ptrn;

Ptrn=CpTranslator::First;
if(Name!=NULL)
  while(Ptrn!=NULL)
	{
	if(!StrCmp(Name,Ptrn->Name)) return(Ptrn);
	Ptrn=Ptrn->Next;
	}
return(&Dummy);
}


#if __BORLANDC__ //&& !__WIN32__
  #include "cp_lib/trn.trn"
#else
  #include "trn.trn"
#endif




//The main function for testing purpose only.
#if 0
void main(void)
{
CpTranslator *x;

x=GetTranslator("Dummy");
x=GetTranslator("wp6TOwp5");

}
#endif

